/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.master.material.MaterialGroupFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.mm.planning.app.AbstractMMSOPRptFacadeControllerBean;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class MMSOPRptFacadeControllerBean
extends AbstractMMSOPRptFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.planning.app.MMSOPRptFacadeControllerBean");

    @Override
    protected Map _getSOPParamByNumber(Context ctx, Map paramNumber) throws BOSException {
        if (null == paramNumber) {
            return null;
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        String storageOrgNumber = "";
        String companyNumber = "";
        String materialGroupNumber = "";
        if (paramNumber.containsKey("STORAGR_NUMBERS")) {
            storageOrgNumber = this.replaceBlank((String)paramNumber.get("STORAGR_NUMBERS"));
        }
        if (paramNumber.containsKey("COMPANY_NUMBERS")) {
            companyNumber = this.replaceBlank((String)paramNumber.get("COMPANY_NUMBERS"));
        }
        if (paramNumber.containsKey("MATERIAL_GROUP_NUMBERS")) {
            materialGroupNumber = this.replaceBlank((String)paramNumber.get("MATERIAL_GROUP_NUMBERS"));
        }
        List selectedCompany = this.getCompanyByNumber(ctx, companyNumber);
        resultMap.put("USER_PERMISSION_COMPANY", this.getUserPermissionOrgs(ctx));
        resultMap.put("SELECTED_COMPANY", selectedCompany);
        resultMap.put("STORAGE_RANGE", this.getStorageByCompany(ctx, selectedCompany));
        resultMap.put("SELECTED_STORAGE", this.getStorageByNumber(ctx, storageOrgNumber));
        resultMap.put("MATERIAL_GROUP", this.getMaterialGroupByNumber(ctx, materialGroupNumber));
        Date date = new Date();
        resultMap.put("SERVER_TIME", date);
        return resultMap;
    }

    private List getCompanyByNumber(Context ctx, String numbers) throws BOSException {
        ArrayList<CompanyOrgUnitInfo> companys = new ArrayList<CompanyOrgUnitInfo>();
        if (StringUtils.isEmpty((String)numbers)) {
            return companys;
        }
        ICompanyOrgUnit companyFactor = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        EntityViewInfo companyViewInfo = new EntityViewInfo();
        FilterInfo companyFilterInfo = new FilterInfo();
        companyFilterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)this.replaceBlank(numbers), CompareType.INCLUDE));
        companyViewInfo.setFilter(companyFilterInfo);
        CoreBaseCollection companyCollection = companyFactor.getCollection(companyViewInfo);
        int n = companyCollection.size();
        for (int i = 0; i < n; ++i) {
            companys.add((CompanyOrgUnitInfo)companyCollection.get(i));
        }
        return companys;
    }

    private List getStorageByCompany(Context ctx, List companys) throws BOSException {
        ArrayList<StorageOrgUnitInfo> storageOrgs = new ArrayList<StorageOrgUnitInfo>();
        if (null == companys || companys.size() < 1) {
            return storageOrgs;
        }
        OrgUnitCollection collection = null;
        IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo companyInfo = null;
        StorageOrgUnitInfo storageInfo = null;
        for (int i = 0; i < companys.size(); ++i) {
            companyInfo = (CompanyOrgUnitInfo)companys.get(i);
            try {
                collection = iUnitRel.getFromUnit(companyInfo.getId().toString(), 1, 4);
            }
            catch (EASBizException e) {
                throw new BOSException((Throwable)e);
            }
            if (null == collection || collection.size() <= 0) continue;
            for (int j = 0; j < collection.size(); ++j) {
                storageInfo = (StorageOrgUnitInfo)collection.get(j);
                if (!storageInfo.isIsBizUnit()) continue;
                storageOrgs.add(storageInfo);
            }
        }
        return storageOrgs;
    }

    private List getStorageByNumber(Context ctx, String numbers) throws BOSException {
        ArrayList<CoreBaseInfo> storageList = new ArrayList<CoreBaseInfo>();
        if (StringUtils.isEmpty((String)numbers)) {
            return storageList;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)this.replaceBlank(numbers), CompareType.INCLUDE));
        viewInfo.setFilter(filterInfo);
        StorageOrgUnitInfo storageInfo = null;
        CoreBaseCollection storageCollection = StorageOrgUnitFactory.getLocalInstance((Context)ctx).getCollection(viewInfo);
        for (int i = 0; i < storageCollection.size(); ++i) {
            storageInfo = (StorageOrgUnitInfo)storageCollection.get(i);
            if (!storageInfo.isIsBizUnit()) continue;
            storageList.add(storageCollection.get(i));
        }
        return storageList;
    }

    private List getMaterialGroupByNumber(Context ctx, String numbers) throws BOSException {
        ArrayList<CoreBaseInfo> materialGroupList = new ArrayList<CoreBaseInfo>();
        if (StringUtils.isEmpty((String)numbers)) {
            return materialGroupList;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)this.replaceBlank(numbers), CompareType.INCLUDE));
        viewInfo.setFilter(filterInfo);
        CoreBaseCollection typeCollection = MaterialGroupFactory.getLocalInstance((Context)ctx).getCollection(viewInfo);
        for (int i = 0; i < typeCollection.size(); ++i) {
            materialGroupList.add(typeCollection.get(i));
        }
        return materialGroupList;
    }

    private List getUserPermissionOrgs(Context ctx) throws BOSException {
        ArrayList<CompanyOrgUnitInfo> permissionFullOrgs = new ArrayList<CompanyOrgUnitInfo>();
        Map hasPermissionOrgs = this.getRptAuthorizedCompany(ctx);
        EntityViewInfo ev = new EntityViewInfo();
        ev.setFilter(new FilterInfo());
        ev.getSelector().add(new SelectorItemInfo("id"));
        ev.getSelector().add(new SelectorItemInfo("name"));
        ev.getSelector().add(new SelectorItemInfo("number"));
        ev.getSelector().add(new SelectorItemInfo("longNumber"));
        ev.getSelector().add(new SelectorItemInfo("isBizUnit"));
        ev.getSelector().add(new SelectorItemInfo("baseCurrency.id"));
        Iterator it = hasPermissionOrgs.keySet().iterator();
        String fieldValue = "";
        int index = 0;
        StringBuffer maskString = new StringBuffer();
        boolean hasValidFieldValue = false;
        while (it.hasNext()) {
            fieldValue = it.next().toString().trim();
            if (StringUtils.isEmpty((String)fieldValue)) continue;
            ev.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)fieldValue, CompareType.EQUALS));
            if (!hasValidFieldValue) {
                maskString.append("#" + index++);
            } else {
                maskString.append(" or #" + index++);
            }
            hasValidFieldValue = true;
        }
        if (hasValidFieldValue) {
            ev.getFilter().setMaskString(maskString.toString());
        }
        CompanyOrgUnitCollection ouc = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(ev);
        int n = ouc.size();
        for (int i = 0; i < n; ++i) {
            CompanyOrgUnitInfo info = ouc.get(i);
            permissionFullOrgs.add(info);
        }
        return permissionFullOrgs;
    }

    private Map getRptAuthorizedCompany(Context ctx) throws BOSException {
        IPermission permission = null;
        IObjectPK userPK = null;
        permission = PermissionFactory.getLocalInstance((Context)ctx);
        userPK = ctx.getCaller();
        Map authorizedCompany = new HashMap();
        try {
            authorizedCompany = permission.getAuthorizedOrgs(userPK, OrgType.Company, null, (IMetaDataPK)MetaDataPK.create((String)"com.kingdee.eas.fi.rpt.client", (String)"RptReportProcessUI"), (IMetaDataPK)MetaDataPK.create((String)"rpt_report_calculate"));
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
        return authorizedCompany;
    }

    private String replaceBlank(String resource) {
        if (null != resource) {
            resource = resource.replace(';', ',');
            resource = resource.replaceAll("\\s", "");
        }
        return resource;
    }
}

