/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.DataLimitExceedException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.JDBCExceptionHandler;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.mm.basedata.BomException;
import com.kingdee.eas.mm.basedata.PlanVersionSetInfo;
import com.kingdee.eas.mm.common.MMCommonException;
import com.kingdee.eas.mm.planning.IMRPCalcFacade;
import com.kingdee.eas.mm.planning.IMultiOrgPlanRunLog;
import com.kingdee.eas.mm.planning.MRPCalcFacadeFactory;
import com.kingdee.eas.mm.planning.MRPException;
import com.kingdee.eas.mm.planning.MRPRunLogFactory;
import com.kingdee.eas.mm.planning.MRPRunLogInfo;
import com.kingdee.eas.mm.planning.MrpRunEnum;
import com.kingdee.eas.mm.planning.MultiOrgPlanCalcStatusEnum;
import com.kingdee.eas.mm.planning.MultiOrgPlanEntryCollection;
import com.kingdee.eas.mm.planning.MultiOrgPlanEntryInfo;
import com.kingdee.eas.mm.planning.MultiOrgPlanInfo;
import com.kingdee.eas.mm.planning.MultiOrgPlanRunLogFactory;
import com.kingdee.eas.mm.planning.MultiOrgPlanRunLogInfo;
import com.kingdee.eas.mm.planning.PlannedOrderFacadeFactory;
import com.kingdee.eas.mm.planning.PlanningCalcTypeEnum;
import com.kingdee.eas.mm.planning.app.AbstractMultiOrgPlanFacadeControllerBean;
import com.kingdee.eas.mm.planning.app.MultiOrgPlanRunParam;
import com.kingdee.eas.mm.planning.app.mrp.MRPResource;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.log4j.Logger;

public class MultiOrgPlanFacadeControllerBean
extends AbstractMultiOrgPlanFacadeControllerBean {
    private static final long serialVersionUID = -2568124387728348601L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.planning.app.multiplan.MultiOrgPlanFacadeControllerBean");
    private static final String RESOURCE = "com.kingdee.eas.mm.planning.MultiOrgPlanResource";
    public static final String MRP_RESOURCE = "com.kingdee.eas.mm.planning.client.PlanningResource";
    private static final String REGEX_L = "\\{";
    private static final String REGEX_R = "\\}";
    private static final int TIME_DELAY = 5000;
    private static final int RESERVE_PROC_PERCENT = 10;

    private String getResource(Context ctx, String key) {
        Locale locale = ctx.getLocale();
        return ResourceBase.getString((String)RESOURCE, (String)key, (Locale)locale);
    }

    private String getResource(Context ctx, String resource, String key) {
        Locale locale = ctx.getLocale();
        return ResourceBase.getString((String)resource, (String)key, (Locale)locale);
    }

    private String getMessage(Context ctx, String key, String[] parameters) {
        String message = this.getResource(ctx, key);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < parameters.length; ++i) {
            sb.setLength(0);
            message = message.replaceAll(sb.append(REGEX_L).append(i).append(REGEX_R).toString(), parameters[i]);
        }
        return message;
    }

    private void oneStorageOrgUnitRun(Context ctx, StorageOrgUnitInfo execOrgInfo, PlanVersionSetInfo planVersion, MultiOrgPlanRunParam param) throws BOSException, EASBizException {
        String msg = null;
        PlanningCalcTypeEnum calcType = param.getCalcType();
        boolean isIsProcessMRP = param.isIsProcessMRP();
        boolean isIsAllowPlanPast = param.isIsAllowPlanPast();
        boolean isIsBomCheck = param.isIsBomCheck();
        boolean isIsCalcLvlCode = param.isIsCalcLvlCode();
        boolean isIsMaterialReplace = param.isIsMaterialReplace();
        MRPRunLogInfo objRunLog = new MRPRunLogInfo();
        objRunLog.setStorageOrgUnit(execOrgInfo);
        objRunLog.setIsContainsMRPMaterial(isIsProcessMRP);
        objRunLog.setIsDelayOrder(isIsAllowPlanPast);
        objRunLog.setIsCheckBOM(isIsBomCheck);
        objRunLog.setIsManageLLC(isIsCalcLvlCode);
        objRunLog.setPlanVersion(planVersion);
        objRunLog.setIsMaterialReplace(isIsMaterialReplace);
        objRunLog.setRunName(MrpRunEnum.MPS_GLOBAL);
        objRunLog.setPlanDate(new Date());
        IMRPCalcFacade calcFacade = MRPCalcFacadeFactory.getLocalInstance(ctx);
        String permItem = null;
        permItem = calcType.equals((Object)PlanningCalcTypeEnum.MPS_GLOBAL) ? "mm_mps_planGlobal_execution" : "mm_mrp_planGlobal_execution";
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
        IPermission iPermission = PermissionFactory.getLocalInstance((Context)ctx);
        iPermission.checkFunctionPermission((IObjectPK)new ObjectUuidPK(user.getId().toString()), (IObjectPK)new ObjectUuidPK(execOrgInfo.getId().toString()), permItem);
        Map rsMap = calcFacade.checkData(execOrgInfo.getId().toString(), objRunLog);
        Integer nVal = new Integer(-1);
        StringBuffer sbPrompt = new StringBuffer();
        Object obj = rsMap.get("ValidateBOM");
        if (obj != null) {
            nVal = (Integer)obj;
        }
        if (nVal.equals(new Integer(10))) {
            objRunLog.setBomNestingCheck(true);
            sbPrompt.append(this.getResource(ctx, "MPS_MRP_RUN_BOM_NESTED")).append("; ");
        } else {
            objRunLog.setBomNestingCheck(false);
        }
        obj = rsMap.get("ReCalcLLC");
        if (obj != null) {
            nVal = (Integer)obj;
        }
        if (nVal.equals(new Integer(1))) {
            objRunLog.setIsCalculateLLC(false);
            sbPrompt.append(this.getResource(ctx, "MPS_MRP_RUN_RECALC_LLC_FAIL"));
        } else {
            objRunLog.setIsCalculateLLC(true);
        }
        if (sbPrompt.length() > 0) {
            msg = sbPrompt.toString();
            throw new MMCommonException(MMCommonException.BLANK, (Object[])new String[]{msg});
        }
        String op = null;
        op = calcType.equals((Object)PlanningCalcTypeEnum.MPS_GLOBAL) ? "MPS" : "MRP";
        IObjectPK pk = LogUtil.beginLog((Context)param.getCtx(), (String)op, (BOSObjectType)new BOSObjectType("F94043EF"), null, (String)op);
        LogUtil.afterLog((Context)param.getCtx(), (IObjectPK)pk);
        BOSUuid logId = BOSUuid.create((BOSObjectType)objRunLog.getBOSType());
        objRunLog.setId(logId);
        param.setCurrMRPRunLogId(logId.toString());
        calcFacade.backRun(objRunLog, false);
    }

    private void refreshRunProgressForMRPRunning(MultiOrgPlanRunParam param) throws BOSException, EASBizException {
        try {
            Locale locale = param.getCtx().getLocale();
            int percent = 0;
            int status = 0;
            String desc = null;
            StringBuffer sql = new StringBuffer();
            sql.append("select distinct t.FNumber FNumber,t.FPercent FPercent,t.FStatus FStatus,t1.FException FException").append(" from T_MM_MRPRunlog t ").append("left join T_MM_MRPRunsteplog t1 on t.FID=t1.FParentId and t1.FStatus=").append(30).append(" where t.fid='").append(param.getCurrMRPRunLogId()).append("'");
            IRowSet rs = DbUtil.executeQuery((Context)param.getCtx(), (String)sql.toString());
            if (rs.next()) {
                percent = rs.getInt("FPercent");
                status = rs.getInt("FStatus");
                desc = rs.getString("FException");
            }
            if (status == 20 || status == 30) {
                if (status == 30) {
                    throw new MRPException(MRPException.STOP_MRP);
                }
                throw new MMCommonException(MMCommonException.BLANK, (Object[])new String[]{desc});
            }
            double execPercent = 0.0;
            if (status == 10) {
                execPercent = 90.0;
                param.setCurrMRPRunEnd(true);
            } else {
                execPercent = percent < 10 ? 0.0 : (double)(percent - 10);
            }
            sql = new StringBuffer();
            sql.append(" update T_MM_MultiOrgPlanRunLogDetail ").append(" set FPercent=?,FStatus=?,FMrpRunLogID=? ").append(" where FMultiOrgRunLogID=? and FStorageOrgUnitID=?");
            DbUtil.execute((Context)param.getCtx(), (String)sql.toString(), (Object[])new Object[]{new Integer((int)execPercent), new Integer(20), param.getCurrMRPRunLogId(), param.getMultiOrgRunLog().getId().toString(), param.getCurrStorageOrgUnit().getId().toString()});
            double remaining = param.getExecStorageSize() - param.getRunOrgList().size();
            double totalSize = Double.parseDouble(param.getExecStorageSize().toString());
            double totalPercent = remaining / totalSize * 100.0 + execPercent * (1.0 / totalSize);
            sql = new StringBuffer();
            sql.append("update T_MM_MultiOrgPlanRunLog ").append("set FPercent=? where FID=?");
            DbUtil.execute((Context)param.getCtx(), (String)sql.toString(), (Object[])new Object[]{new Integer((int)totalPercent), param.getMultiOrgRunLog().getId().toString()});
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void refreshRunProgressForMRPRunEnd(MultiOrgPlanRunParam param) throws BOSException {
        double execPercent = 0.0;
        Integer status = null;
        if (!param.isCurrTransferReqEnd()) {
            execPercent = 90.0;
            status = new Integer(20);
        } else {
            execPercent = 100.0;
            status = new Integer(40);
        }
        double totalPercent = 0.0;
        if (param.getRunOrgList() == null || param.getRunOrgList().size() <= 0) {
            totalPercent = 100.0;
        } else {
            double remaining = param.getExecStorageSize() - param.getRunOrgList().size();
            double totalSize = Double.parseDouble(param.getExecStorageSize().toString());
            totalPercent = (remaining * 100.0 + execPercent) / totalSize;
        }
        Timestamp endDate = new Timestamp(Calendar.getInstance().getTimeInMillis());
        StringBuffer sql = new StringBuffer();
        sql.append(" update T_MM_MultiOrgPlanRunLogDetail ").append(" set FPercent=?,FStatus=?,FEndTime=?").append(" where FMultiOrgRunLogID=? and FStorageOrgUnitID=?");
        DbUtil.execute((Context)param.getCtx(), (String)sql.toString(), (Object[])new Object[]{new Integer((int)execPercent), status, endDate, param.getMultiOrgRunLog().getId().toString(), param.getCurrStorageOrgUnit().getId().toString()});
        MultiOrgPlanCalcStatusEnum headStatus = MultiOrgPlanCalcStatusEnum.RUNNING;
        if ((int)totalPercent == 100) {
            headStatus = MultiOrgPlanCalcStatusEnum.COMPLETE;
        }
        sql = new StringBuffer();
        sql.append("update T_MM_MultiOrgPlanRunLog ").append("set FPercent=?, FStatus=? where FID=?");
        DbUtil.execute((Context)param.getCtx(), (String)sql.toString(), (Object[])new Object[]{new Integer((int)totalPercent), new Integer(headStatus.getValue()), param.getMultiOrgRunLog().getId().toString()});
    }

    private void refreshRunProcess(MultiOrgPlanRunParam param) throws BOSException, EASBizException {
        if (param.isCurrMRPRunEnd()) {
            this.refreshRunProgressForMRPRunEnd(param);
        } else {
            this.refreshRunProgressForMRPRunning(param);
        }
    }

    private void transferReq(MultiOrgPlanRunParam param) throws BOSException, EASBizException {
        PlannedOrderFacadeFactory.getLocalInstance(param.getCtx()).releaseStockTransfer(param.getCurrMRPRunLogId());
        param.setCurrTransferReqEnd(true);
    }

    private void procesMultiOrgPlanRunException(Exception e, MultiOrgPlanRunParam param, Timer timer) {
        Locale locale = param.getCtx().getLocale();
        String msg = null;
        int status = 30;
        msg = this.getExceptionMsg(param.getCtx(), e);
        this.logTrace(e);
        if (e instanceof MRPException && MRPException.STOP_MRP.getCode().equals(((MRPException)((Object)e)).getSubCode())) {
            status = 50;
        }
        try {
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
            Timestamp endDate = new Timestamp(Calendar.getInstance().getTimeInMillis());
            StringBuffer sql = new StringBuffer();
            sql.append(" update T_MM_MultiOrgPlanRunLogDetail ").append(" set FPercent=?,FStatus=?,FMrpRunLogID=?,FRemark_" + locale + "=?,").append(" FEndTime=?").append(" where FMultiOrgRunLogID=? and FStorageOrgUnitID=?");
            Object[] objArray = new Object[]{new Integer(100), new Integer(status), param.getCurrMRPRunLogId(), msg, endDate, param.getMultiOrgRunLog().getId().toString(), param.getCurrStorageOrgUnit().getId().toString()};
            paramsList.add(objArray);
            msg = this.getMessage(param.getCtx(), "MULTIPLAN_EXCEPTION_PRE", new String[]{param.getCurrStorageOrgUnit().getNumber()}) + msg;
            MultiOrgPlanEntryInfo info = null;
            for (int i = 1; i < param.getRunOrgList().size(); ++i) {
                info = (MultiOrgPlanEntryInfo)param.getRunOrgList().get(i);
                objArray = new Object[]{new Integer(100), new Integer(status), null, msg, endDate, param.getMultiOrgRunLog().getId().toString(), info.getStorageOrgUnit().getId().toString()};
                paramsList.add(objArray);
            }
            DbUtil.executeBatch((Context)param.getCtx(), (String)sql.toString(), paramsList);
            sql = new StringBuffer();
            sql.append("update T_MM_MultiOrgPlanRunLog ").append("set FPercent=?,FRemark_" + locale + "=?, FStatus=? where FID=?");
            DbUtil.execute((Context)param.getCtx(), (String)sql.toString(), (Object[])new Object[]{new Integer(100), msg, new Integer(status), param.getMultiOrgRunLog().getId().toString()});
        }
        catch (BOSException e1) {
            logger.error((Object)"MULTI_PLAN: Exception", (Throwable)e1);
        }
        param.setCurrMRPRunEnd(true);
        param.getRunOrgList().clear();
        if (timer != null) {
            timer.cancel();
        }
    }

    private Timer runTimerSchedule(final MultiOrgPlanRunParam param) {
        final Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                try {
                    MultiOrgPlanFacadeControllerBean.this.processMultiOrgPlan(param);
                }
                catch (BOSException e) {
                    MultiOrgPlanFacadeControllerBean.this.procesMultiOrgPlanRunException((Exception)((Object)e), param, timer);
                }
            }
        }, 5000L);
        return timer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processMultiOrgPlan(MultiOrgPlanRunParam param) throws BOSException {
        Timer timer = null;
        try {
            if (param.getRunOrgList() != null && param.getRunOrgList().size() > 0) {
                if (param.isCurrMRPRunEnd()) {
                    MultiOrgPlanEntryInfo entry = (MultiOrgPlanEntryInfo)param.getRunOrgList().get(0);
                    param.setCurrStorageOrgUnit(entry.getStorageOrgUnit());
                    param.setCurrPlanVersion(entry.getPlanVersionSet());
                    param.setCurrMRPRunEnd(false);
                    param.setCurrMRPRunLogId(null);
                    param.setCurrTransferReqEnd(false);
                    this.oneStorageOrgUnitRun(param.getCtx(), entry.getStorageOrgUnit(), entry.getPlanVersionSet(), param);
                    logger.info((Object)("MULTI_PLAN: Start StorageOrgUnit:" + entry.getStorageOrgUnit().getNumber() + " MRP calculator."));
                }
                this.refreshRunProcess(param);
                if (!param.isCurrMRPRunEnd()) {
                    timer = this.runTimerSchedule(param);
                } else {
                    this.transferReq(param);
                    this.refreshRunProcess(param);
                    param.getRunOrgList().remove(0);
                }
                if (param.isCurrMRPRunEnd() && param.isCurrTransferReqEnd()) {
                    this.processMultiOrgPlan(param);
                }
            } else {
                if (timer != null) {
                    timer.cancel();
                }
                this.refreshRunProcess(param);
            }
        }
        catch (Exception e) {
            this.procesMultiOrgPlanRunException(e, param, timer);
        }
        finally {
            String mutexId = "MULTIPLAN" + param.getPlanStorageOrgUnit().getId().toString();
            IMutexServiceControl mutex = MutexServiceControlFactory.getLocalInstance((Context)param.getCtx());
            mutex.releaseObjIDForUpdate(mutexId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _runMultiOrgPlan(Context ctx, IObjectValue runLog) throws BOSException, EASBizException {
        MultiOrgPlanRunLogInfo multiOrgRunLog = (MultiOrgPlanRunLogInfo)runLog;
        MultiOrgPlanInfo multiOrgPlan = multiOrgRunLog.getMultiOrgPlan();
        Timer timer = null;
        MultiOrgPlanRunParam param = new MultiOrgPlanRunParam();
        try {
            logger.info((Object)"MULTI_PLAN: Generate MultiOrgPlan run log.");
            IMultiOrgPlanRunLog iMultiOrgPlanRunLog = MultiOrgPlanRunLogFactory.getLocalInstance(ctx);
            iMultiOrgPlanRunLog.save((CoreBaseInfo)multiOrgRunLog);
            logger.info((Object)"MULTI_PLAN: Construct MultiOrgPlan run parameters.");
            param.setPlanStorageOrgUnit(multiOrgPlan.getStorageOrgUnit());
            param.setCalcType(multiOrgPlan.getPlanCalcType());
            param.setIsProcessMRP(multiOrgPlan.isIsProcessMRP());
            param.setIsBomCheck(multiOrgPlan.isIsBomCheck());
            param.setIsCalcLvlCode(multiOrgPlan.isIsCalcLvlCode());
            param.setIsAllowPlanPast(multiOrgPlan.isIsAllowPlanPast());
            param.setIsMaterialReplace(multiOrgPlan.isIsMaterialReplace());
            param.setMultiOrgRunLog(multiOrgRunLog);
            MultiOrgPlanEntryCollection multiOrgPlanEntryCollection = multiOrgPlan.getEntry();
            param.setRunOrgList(new ArrayList());
            for (int i = 0; i < multiOrgPlanEntryCollection.size(); ++i) {
                param.getRunOrgList().add(multiOrgPlanEntryCollection.get(i));
            }
            param.setExecStorageSize(new Integer(multiOrgPlanEntryCollection.size()));
            param.setCtx(ctx);
            logger.info((Object)"MULTI_PLAN: Start MultiOrgPlan run.");
            this.processMultiOrgPlan(param);
        }
        catch (Exception e) {
            this.procesMultiOrgPlanRunException(e, param, timer);
        }
        finally {
            if (param.getRunOrgList().size() <= 0) {
                logger.info((Object)"MULTI_PLAN: Releas MultiOrgPlan mutex.");
                String mutexId = "MULTIPLAN" + multiOrgPlan.getStorageOrgUnit().getId().toString();
                IMutexServiceControl mutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
                mutex.releaseObjIDForUpdate(mutexId);
            }
        }
    }

    @Override
    protected MRPRunLogInfo _getMRPRunlogInfo(Context ctx, String logDetailId) throws BOSException, EASBizException {
        Locale locale = ctx.getLocale();
        MRPRunLogInfo runLogInfo = new MRPRunLogInfo();
        runLogInfo.setTotalMaterals(new BigDecimal("0.0"));
        runLogInfo.setNumOfexceptionMaterials(new BigDecimal("0.0"));
        runLogInfo.setNumOflowerSafeStockMtl(new BigDecimal("0.0"));
        runLogInfo.setTotalPlanOrders(new BigDecimal("0.0"));
        if (logDetailId == null) {
            return runLogInfo;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT ").append("MULTIORGPLANRUNLOGDETAIL.FRemark_" + locale + " AS REMARK,  ").append("MULTIORGPLANRUNLOGDETAIL.FStartTime AS STARTTIME,  ").append("MULTIORGPLANRUNLOGDETAIL.FEndTime AS ENDTIME,  ").append("MULTIORGPLANRUNLOGDETAIL.FStatus AS STATUS,  ").append("PLANVERSION.FNUMBER AS planNumFrom,  ").append("CREATOR.FNumber AS CREATORNUMBER,  ").append("CREATOR.FName_" + locale + " AS CREATORNAME,  ").append("MULTIORGPLANRUNLOGDETAIL.FCreatorID AS CREATORID,  ").append("STORAGEORGUNIT.FName_" + locale + " AS STORAGEORGUNITNAME,  ").append("STORAGEORGUNIT.FNumber AS STORAGEORGUNITNUMBER,  ").append("MULTIORGPLANRUNLOGDETAIL.FStorageOrgUnitID AS STORAGEORGUNITID,  ").append("MRPRUNLOG.FID AS MRPRUNLOGID,  ").append("MULTIORGPLAN.FPlanCalcType AS MULTIORGPLANPLANCALCTYPE,  ").append("MULTIORGPLAN.FIsProcessMRP AS MULTIORGPLANISPROCESSMRP,  ").append("MULTIORGPLAN.FIsCalcLvlCode AS MULTIORGPLANISCALCLVLCODE,  ").append("MULTIORGPLAN.FIsBomCheck AS MULTIORGPLANISBOMCHECK,  ").append("MULTIORGPLAN.FIsAllowPlanPast AS MULTIORGPLANISALLOWPLANPAST ").append("FROM ").append("T_MM_MultiOrgPlanRunLogDetail AS MULTIORGPLANRUNLOGDETAIL ").append("LEFT OUTER JOIN T_PM_User AS CREATOR ").append("ON MULTIORGPLANRUNLOGDETAIL.FCreatorID = CREATOR.FID ").append("LEFT OUTER JOIN T_ORG_Storage AS STORAGEORGUNIT ").append("ON MULTIORGPLANRUNLOGDETAIL.FStorageOrgUnitID = STORAGEORGUNIT.FID ").append("LEFT OUTER JOIN T_MM_MRPRunLog AS MRPRUNLOG ").append("ON MULTIORGPLANRUNLOGDETAIL.FMrpRunLogID = MRPRUNLOG.FID ").append("LEFT OUTER JOIN T_MM_MultiOrgPlanRunLog AS MULTIORGRUNLOG ").append("ON MULTIORGPLANRUNLOGDETAIL.FMultiOrgRunLogID = MULTIORGRUNLOG.FID ").append("LEFT OUTER JOIN T_MM_PlanVersionSet AS PLANVERSION ").append("ON MRPRUNLOG.FPlanVersionID = PLANVERSION.FID ").append("LEFT OUTER JOIN T_MM_MultiOrgPlan AS MULTIORGPLAN ").append("ON MULTIORGRUNLOG.FMultiOrgPlanID = MULTIORGPLAN.FID ").append(" WHERE ").append(" MULTIORGPLANRUNLOGDETAIL.FID ='").append(logDetailId).append("' ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (rs.size() <= 0) {
            return runLogInfo;
        }
        try {
            if (rs.next()) {
                if (rs.getString("MRPRUNLOGID") == null) {
                    String planVerNumber = rs.getString("planNumFrom");
                    throw new MRPException(MRPException.NO_MRP_RUNLOG);
                }
                ObjectStringPK mrpRunLogPK = new ObjectStringPK(rs.getString("MRPRUNLOGID"));
                runLogInfo = (MRPRunLogInfo)MRPRunLogFactory.getLocalInstance(ctx).getValue((IObjectPK)mrpRunLogPK);
                if (rs.getString("REMARK") != null) {
                    runLogInfo.setDesc(rs.getString("REMARK"));
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return runLogInfo;
    }

    @Override
    protected RptParams _getPlannerWorkPlatformFilter(Context ctx, String logDetailId) throws BOSException, EASBizException {
        RptParams filter = new RptParams();
        filter.setString("materialAtr_1", "true");
        filter.setString("materialAtr_2", "true");
        filter.setString("materialAtr_3", "true");
        filter.setString("kdMaterialAtr_other", "true");
        filter.setString("planModeall", "true");
        filter.setString("exception_1", "true");
        filter.setString("exception_2", "true");
        filter.setString("exception_3", "true");
        filter.setString("exception_4", "true");
        filter.setString("exception_5", "true");
        filter.setString("exception_6", "true");
        filter.setString("exception_7", "true");
        filter.setString("exception_8", "true");
        filter.setString("exception_none", "true");
        filter.setString("allProcess", "false");
        filter.setString("uProcess", "true");
        filter.setString("Process", "false");
        filter.setString("advance", "true");
        filter.setString("delay", "true");
        filter.setString("cancel", "true");
        filter.setString("byScheduling", "true");
        filter.setString("supplyAdvance", "true");
        filter.setString("supplyCurrentPeriod", "true");
        filter.setString("supplyDelay", "true");
        filter.setString("isSimulantResult", "false");
        filter.setString("showCollect", "true");
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT  ").append("STORAGEORGUNIT.FNumber AS STORAGEORGUNITNUMBER,  ").append("MULTIORGPLANRUNLOGDETAIL.FStorageOrgUnitID AS STORAGEORGUNITID,  ").append("MRPRUNLOG.FID AS MRPRUNLOGID,  ").append("planverset.fnumber AS planNumFrom,  ").append("MRPRUNLOG.FPlanDate AS MRPRUNLOGPLANDATE,  ").append("MULTIORGPLAN.FIsProcessMRP AS MULTIORGPLANISPROCESSMRP,  ").append("MULTIORGPLAN.FPlanCalcType AS MULTIORGPLANPLANCALCTYPE  ").append("FROM ").append("T_MM_MultiOrgPlanRunLogDetail AS MULTIORGPLANRUNLOGDETAIL ").append("LEFT OUTER JOIN T_ORG_Storage AS STORAGEORGUNIT ").append("ON MULTIORGPLANRUNLOGDETAIL.FStorageOrgUnitID = STORAGEORGUNIT.FID ").append("LEFT OUTER JOIN T_MM_MRPRunLog AS MRPRUNLOG ").append("ON MULTIORGPLANRUNLOGDETAIL.FMrpRunLogID = MRPRUNLOG.FID ").append("LEFT OUTER JOIN t_mm_planversionset AS planverset ").append("ON MRPRUNLOG.fplanversionid = planverset.FID ").append("RIGHT OUTER JOIN T_MM_MultiOrgPlanRunLog AS MULTIORGRUNLOG ").append("ON MULTIORGPLANRUNLOGDETAIL.FMultiOrgRunLogID = MULTIORGRUNLOG.FID ").append("LEFT OUTER JOIN T_MM_MultiOrgPlan AS MULTIORGPLAN ").append("ON MULTIORGRUNLOG.FMultiOrgPlanID = MULTIORGPLAN.FID ").append(" WHERE ").append(" MULTIORGPLANRUNLOGDETAIL.FID ='").append(logDetailId).append("' ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (rs.size() <= 0) {
            return filter;
        }
        try {
            if (rs.next()) {
                String planVerNumber = rs.getString("planNumFrom");
                filter.setString("storageOrgUnit", rs.getString("STORAGEORGUNITNUMBER"));
                filter.setString("storageOrgID", rs.getString("STORAGEORGUNITID"));
                filter.setString("planNumFrom", planVerNumber);
                filter.setString("planNum", planVerNumber);
                filter.setString("mrpRunLogId", rs.getString("MRPRUNLOGID"));
                String strDate = null;
                Date endDate = new Date();
                Calendar startDate = Calendar.getInstance();
                strDate = new SimpleDateFormat("yyyy-MM-dd ").format(endDate);
                startDate.setTime(endDate);
                startDate.set(11, 0);
                startDate.set(12, 0);
                startDate.set(13, 0);
                startDate.set(14, 0);
                startDate.set(3, startDate.get(3) - 1);
                String strStartDate = new SimpleDateFormat("yyyy-MM-dd ").format(startDate.getTime());
                filter.setString("planDateFrom", strStartDate);
                filter.setString("planDateTo", strDate);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return filter;
    }

    private String getExceptionMsg(Context ctx, Throwable t) {
        if (t != null) {
            if (t instanceof MRPException || t instanceof BomException || t instanceof CodingRuleException || t instanceof EASBizException) {
                return t.getMessage();
            }
            if (t instanceof SQLException) {
                SQLException sqlExp = (SQLException)t;
                Exception exp = JDBCExceptionHandler.convertException((SQLException)sqlExp);
                if (exp instanceof DataLimitExceedException) {
                    return MRPResource.getString(ctx, "RUNDATA_OUTOFRANG");
                }
                String errMsg = sqlExp.getMessage();
                int index = errMsg.indexOf("source sql is :");
                if (index > 0) {
                    errMsg = errMsg.substring(index + 15);
                }
                return "SQL Error:" + errMsg;
            }
            if (t.getCause() != null) {
                return this.getExceptionMsg(ctx, t.getCause());
            }
        }
        return this.getResource(ctx, "SYSTEM_EXCEPTION");
    }

    private void logTrace(Throwable t) {
        if (t != null && t.getStackTrace() != null) {
            StringBuffer msg = new StringBuffer();
            msg.append(t.getClass().toString() + " : " + t.getMessage()).append("\r\n");
            StackTraceElement[] elements = t.getStackTrace();
            for (int i = 0; i < elements.length; ++i) {
                msg.append(elements[i].toString()).append("\r\n");
            }
            logger.info((Object)msg.toString());
            this.logTrace(t.getCause());
        }
    }
}

