/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.basedata.AllotRuleEnum;
import com.kingdee.eas.mm.basedata.BDStatusEnum;
import com.kingdee.eas.mm.basedata.PLSModelInfo;
import com.kingdee.eas.mm.basedata.ProductLineInfo;
import com.kingdee.eas.mm.basedata.ProductLinePAllotDefEntryCollection;
import com.kingdee.eas.mm.basedata.ProductLinePAllotDefEntryInfo;
import com.kingdee.eas.mm.basedata.ProductLinePAllotDefEntryRuleEntryCollection;
import com.kingdee.eas.mm.basedata.ProductLinePAllotDefEntryRuleEntryInfo;
import com.kingdee.eas.mm.common.util.ResourceUtils;
import com.kingdee.eas.mm.planning.PLChooseEntryInfo;
import com.kingdee.eas.mm.planning.PLSConstant;
import com.kingdee.eas.mm.planning.PLSExectionMSGInfo;
import com.kingdee.eas.mm.planning.PlanOrderEntryInfo;
import com.kingdee.eas.mm.planning.app.CalcPLSPriorityRunner;
import com.kingdee.eas.mm.planning.app.PLSRunner;
import com.kingdee.eas.mm.planning.util.PLSUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PLChooseRunner
extends PLSRunner {
    protected List srcList;
    protected Map pOEntryMap;
    private ProductLinePAllotDefEntryCollection productLinePAllotDefEntryCollection;
    private static final int PRIORITY = 1;
    private static final int QUOTA = 2;

    public PLChooseRunner(Context context, StorageOrgUnitInfo storageOrgUnit, List pOEntryList, String currVoucherID, PLSModelInfo pLSModelInfo) {
        this.ctx = context;
        this.storageOrgUnitInfo = storageOrgUnit;
        this.srcList = pOEntryList;
        this.voucherID = currVoucherID;
        this.lineSchedulingModelInfo = pLSModelInfo;
    }

    @Override
    public void prepareData() throws BOSException, EASBizException {
        super.prepareData();
        this.productLinePAllotDefEntryCollection = PLSUtil.getProductLinePAllotDefForServer(this.ctx, this.lineSchedulingModelInfo.getProductLineAllocate().getId().toString());
        this.pOEntryMap = new HashMap();
        int n = this.srcList.size();
        for (int i = 0; i < n; ++i) {
            List<PlanOrderEntryInfo> list;
            PlanOrderEntryInfo pOEntryInfo = (PlanOrderEntryInfo)this.srcList.get(i);
            if (this.pOEntryMap.containsKey(pOEntryInfo.getMaterial())) {
                list = (List)this.pOEntryMap.get(pOEntryInfo.getMaterial());
                list.add(pOEntryInfo);
                continue;
            }
            list = new ArrayList<PlanOrderEntryInfo>();
            list.add(pOEntryInfo);
            this.pOEntryMap.put(pOEntryInfo.getMaterial(), list);
        }
    }

    @Override
    public void running() throws BOSException, EASBizException {
        this.prepareData();
        this.returnList = new ArrayList();
        Set keySet = this.pOEntryMap.keySet();
        block5: for (MaterialInfo material : keySet) {
            boolean isInDef = false;
            List list = (List)this.pOEntryMap.get(material);
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                PlanOrderEntryInfo pOEntryInfo = (PlanOrderEntryInfo)list.get(i);
                block7: for (int j = 0; j < this.productLinePAllotDefEntryCollection.size(); ++j) {
                    ProductLinePAllotDefEntryInfo productLinePAllotDefEntryInfo = this.productLinePAllotDefEntryCollection.get(j);
                    int distribStrategy = productLinePAllotDefEntryInfo.getDistribStrategy().getValue();
                    if (!pOEntryInfo.getMaterial().getId().equals((Object)productLinePAllotDefEntryInfo.getMaterial().getId())) continue;
                    isInDef = true;
                    ArrayList<ProductLinePAllotDefEntryRuleEntryInfo> ruleEntryList = new ArrayList<ProductLinePAllotDefEntryRuleEntryInfo>();
                    ProductLinePAllotDefEntryRuleEntryCollection ruleEntryCollection = productLinePAllotDefEntryInfo.getRuleEntrys();
                    for (ProductLinePAllotDefEntryRuleEntryInfo ruleEntryInfo : ruleEntryCollection) {
                        if (!ruleEntryInfo.getProductLine().getStatus().equals((Object)BDStatusEnum.APPROVE)) {
                            String exceDesc = ResourceUtils.getMessageForServer((String)"com.kingdee.eas.mm.planning.SchedulingExceptionResource", (String)"LINDINALLOTDEFNOAUDIT_DESC");
                            int exceNum = 202;
                            ProductLineInfo productLine = ruleEntryInfo.getProductLine();
                            String exceDetail = ResourceUtils.getMessageForServer((String)"com.kingdee.eas.mm.planning.SchedulingExceptionResource", (String)"LINDINALLOTDEFNOAUDIT_DETAIL", (String[])new String[]{material.getNumber(), material.getName(), productLine.getNumber(), productLine.getName()});
                            PLSExectionMSGInfo exceInfo = new PLSExectionMSGInfo(exceNum, exceDesc, exceDetail, this.voucherID);
                            this.exceptions.add(exceInfo);
                        }
                        ruleEntryList.add(ruleEntryInfo);
                    }
                    switch (distribStrategy) {
                        case 10: {
                            PLChooseEntryInfo pLCEntry;
                            Comparator comparator = PLChooseRunner.getPriorityComparator(1);
                            if (comparator != null) {
                                Collections.sort(ruleEntryList, comparator);
                            }
                            if (pOEntryInfo.getNoSchedulingQty().compareTo(productLinePAllotDefEntryInfo.getSplitLeastNum()) <= 0) {
                                ProductLinePAllotDefEntryRuleEntryInfo ruleEntry;
                                pLCEntry = this.getPLChooseEntryFromPlanOrderEntry(pOEntryInfo);
                                if (productLinePAllotDefEntryInfo.getAllotRule().equals((Object)AllotRuleEnum.PRIHIGHT)) {
                                    ruleEntry = (ProductLinePAllotDefEntryRuleEntryInfo)ruleEntryList.get(0);
                                    pLCEntry.setProductLine(ruleEntry.getProductLine());
                                    pLCEntry.setWorkShop(pLCEntry.getProductLine().getWorkshop());
                                } else {
                                    ruleEntry = (ProductLinePAllotDefEntryRuleEntryInfo)ruleEntryList.get(ruleEntryList.size() - 1);
                                    pLCEntry.setProductLine(ruleEntry.getProductLine());
                                    pLCEntry.setWorkShop(pLCEntry.getProductLine().getWorkshop());
                                }
                                this.returnList.add(pLCEntry);
                                continue block7;
                            }
                            for (int k = 0; k < ruleEntryList.size(); ++k) {
                                ProductLinePAllotDefEntryRuleEntryInfo ruleEntry = (ProductLinePAllotDefEntryRuleEntryInfo)ruleEntryList.get(k);
                                PLChooseEntryInfo pLCEntry2 = this.getPLChooseEntryFromPlanOrderEntry(pOEntryInfo);
                                pLCEntry2.setProductLine(ruleEntry.getProductLine());
                                pLCEntry2.setWorkShop(pLCEntry2.getProductLine().getWorkshop());
                                if (pOEntryInfo.getNoSchedulingQty().compareTo(ruleEntry.getMaxLotNum()) <= 0) {
                                    pLCEntry2.setQty(pOEntryInfo.getNoSchedulingQty());
                                    this.returnList.add(pLCEntry2);
                                    continue block7;
                                }
                                if (k == ruleEntryList.size() - 1) {
                                    pLCEntry2.setQty(pOEntryInfo.getNoSchedulingQty());
                                } else {
                                    pLCEntry2.setQty(ruleEntry.getMaxLotNum());
                                    pOEntryInfo.setNoSchedulingQty(pOEntryInfo.getNoSchedulingQty().subtract(ruleEntry.getMaxLotNum()));
                                }
                                this.returnList.add(pLCEntry2);
                            }
                            continue block7;
                        }
                        case 20: {
                            ProductLinePAllotDefEntryRuleEntryInfo ruleEntry;
                            int k;
                            PLChooseEntryInfo pLCEntry;
                            Comparator comparator = PLChooseRunner.getPriorityComparator(2);
                            if (comparator != null) {
                                Collections.sort(ruleEntryList, comparator);
                            }
                            if (pOEntryInfo.getNoSchedulingQty().compareTo(productLinePAllotDefEntryInfo.getSplitLeastNum()) <= 0) {
                                ProductLinePAllotDefEntryRuleEntryInfo ruleEntry2;
                                pLCEntry = this.getPLChooseEntryFromPlanOrderEntry(pOEntryInfo);
                                if (productLinePAllotDefEntryInfo.getAllotRule().equals((Object)AllotRuleEnum.QUOTALOW)) {
                                    ruleEntry2 = (ProductLinePAllotDefEntryRuleEntryInfo)ruleEntryList.get(0);
                                    pLCEntry.setProductLine(ruleEntry2.getProductLine());
                                    pLCEntry.setWorkShop(pLCEntry.getProductLine().getWorkshop());
                                } else {
                                    ruleEntry2 = (ProductLinePAllotDefEntryRuleEntryInfo)ruleEntryList.get(ruleEntryList.size() - 1);
                                    pLCEntry.setProductLine(ruleEntry2.getProductLine());
                                    pLCEntry.setWorkShop(pLCEntry.getProductLine().getWorkshop());
                                }
                                this.returnList.add(pLCEntry);
                                continue block7;
                            }
                            BigDecimal sumQty = pOEntryInfo.getNoSchedulingQty();
                            int m = ruleEntryList.size();
                            for (k = 0; k < m; ++k) {
                                ruleEntry = (ProductLinePAllotDefEntryRuleEntryInfo)ruleEntryList.get(k);
                                PLChooseEntryInfo pLCEntry3 = this.getPLChooseEntryFromPlanOrderEntry(pOEntryInfo);
                                pLCEntry3.setProductLine(ruleEntry.getProductLine());
                                pLCEntry3.setWorkShop(pLCEntry3.getProductLine().getWorkshop());
                                if (k == m - 1) {
                                    pLCEntry3.setQty(sumQty);
                                    this.returnList.add(pLCEntry3);
                                    continue block7;
                                }
                                pLCEntry3.setQty(pLCEntry3.getQty().multiply(ruleEntry.getQuota().divide(PLSConstant.HUNDRED, 8, 4)));
                                sumQty = sumQty.subtract(pLCEntry3.getQty());
                                this.returnList.add(pLCEntry3);
                            }
                            continue block7;
                        }
                        case 30: {
                            ProductLinePAllotDefEntryRuleEntryInfo ruleEntry;
                            int k;
                            ArrayList<ProductLinePAllotDefEntryRuleEntryInfo> priList = new ArrayList<ProductLinePAllotDefEntryRuleEntryInfo>();
                            ArrayList<ProductLinePAllotDefEntryRuleEntryInfo> aqtList = new ArrayList<ProductLinePAllotDefEntryRuleEntryInfo>();
                            int m = ruleEntryList.size();
                            for (k = 0; k < m; ++k) {
                                ruleEntry = (ProductLinePAllotDefEntryRuleEntryInfo)ruleEntryList.get(k);
                                if (ruleEntry.getPriority() >= 0) {
                                    priList.add(ruleEntry);
                                    continue;
                                }
                                aqtList.add(ruleEntry);
                            }
                            Comparator comparator_Priority = PLChooseRunner.getPriorityComparator(1);
                            Comparator comparator_Quota = PLChooseRunner.getPriorityComparator(2);
                            if (comparator_Priority != null) {
                                Collections.sort(ruleEntryList, comparator_Priority);
                            }
                            if (comparator_Quota != null) {
                                Collections.sort(ruleEntryList, comparator_Quota);
                            }
                            if (pOEntryInfo.getNoSchedulingQty().compareTo(productLinePAllotDefEntryInfo.getSplitLeastNum()) <= 0) {
                                ProductLinePAllotDefEntryRuleEntryInfo ruleEntry3;
                                PLChooseEntryInfo pLCEntry = this.getPLChooseEntryFromPlanOrderEntry(pOEntryInfo);
                                if (productLinePAllotDefEntryInfo.getAllotRule().equals((Object)AllotRuleEnum.PRIHIGHT)) {
                                    ruleEntry3 = (ProductLinePAllotDefEntryRuleEntryInfo)priList.get(0);
                                    pLCEntry.setProductLine(ruleEntry3.getProductLine());
                                    pLCEntry.setWorkShop(pLCEntry.getProductLine().getWorkshop());
                                } else if (productLinePAllotDefEntryInfo.getAllotRule().equals((Object)AllotRuleEnum.PRILOW)) {
                                    ruleEntry3 = (ProductLinePAllotDefEntryRuleEntryInfo)priList.get(priList.size() - 1);
                                    pLCEntry.setProductLine(ruleEntry3.getProductLine());
                                    pLCEntry.setWorkShop(pLCEntry.getProductLine().getWorkshop());
                                } else if (productLinePAllotDefEntryInfo.getAllotRule().equals((Object)AllotRuleEnum.QUOTALOW)) {
                                    ruleEntry3 = (ProductLinePAllotDefEntryRuleEntryInfo)aqtList.get(0);
                                    pLCEntry.setProductLine(ruleEntry3.getProductLine());
                                    pLCEntry.setWorkShop(pLCEntry.getProductLine().getWorkshop());
                                } else {
                                    ruleEntry3 = (ProductLinePAllotDefEntryRuleEntryInfo)aqtList.get(aqtList.size() - 1);
                                    pLCEntry.setProductLine(ruleEntry3.getProductLine());
                                    pLCEntry.setWorkShop(pLCEntry.getProductLine().getWorkshop());
                                }
                                this.returnList.add(pLCEntry);
                                continue block7;
                            }
                            int m2 = priList.size();
                            for (int k2 = 0; k2 < m2; ++k2) {
                                ProductLinePAllotDefEntryRuleEntryInfo ruleEntry4 = (ProductLinePAllotDefEntryRuleEntryInfo)priList.get(k2);
                                PLChooseEntryInfo pLCEntry = this.getPLChooseEntryFromPlanOrderEntry(pOEntryInfo);
                                pLCEntry.setProductLine(ruleEntry4.getProductLine());
                                pLCEntry.setWorkShop(pLCEntry.getProductLine().getWorkshop());
                                if (pOEntryInfo.getNoSchedulingQty().compareTo(ruleEntry4.getMaxLotNum()) <= 0) {
                                    pLCEntry.setQty(pOEntryInfo.getNoSchedulingQty());
                                    pOEntryInfo.setNoSchedulingQty(PLSConstant.ZERO);
                                    this.returnList.add(pLCEntry);
                                    break;
                                }
                                pLCEntry.setQty(ruleEntry4.getMaxLotNum());
                                pOEntryInfo.setNoSchedulingQty(pOEntryInfo.getNoSchedulingQty().subtract(ruleEntry4.getMaxLotNum()));
                                this.returnList.add(pLCEntry);
                            }
                            if (pOEntryInfo.getNoSchedulingQty().compareTo(PLSConstant.ZERO) <= 0) continue block7;
                            BigDecimal sumQty = pOEntryInfo.getNoSchedulingQty();
                            int m3 = aqtList.size();
                            for (int k3 = 0; k3 < m3; ++k3) {
                                ProductLinePAllotDefEntryRuleEntryInfo ruleEntry5 = (ProductLinePAllotDefEntryRuleEntryInfo)aqtList.get(k3);
                                PLChooseEntryInfo pLCEntry = this.getPLChooseEntryFromPlanOrderEntry(pOEntryInfo);
                                pLCEntry.setProductLine(ruleEntry5.getProductLine());
                                pLCEntry.setWorkShop(pLCEntry.getProductLine().getWorkshop());
                                if (k3 == m3 - 1) {
                                    pLCEntry.setQty(sumQty);
                                    this.returnList.add(pLCEntry);
                                    continue block7;
                                }
                                pLCEntry.setQty(pLCEntry.getQty().multiply(ruleEntry5.getQuota().divide(PLSConstant.HUNDRED, 8, 4)));
                                sumQty = sumQty.subtract(pLCEntry.getQty());
                                this.returnList.add(pLCEntry);
                            }
                            continue block7;
                        }
                    }
                }
                if (isInDef) continue;
                String exceDesc = ResourceUtils.getMessageForServer((String)"com.kingdee.eas.mm.planning.SchedulingExceptionResource", (String)"NOINALLOTDEF_DESC");
                int exceNum = 201;
                String exceDetail = ResourceUtils.getMessageForServer((String)"com.kingdee.eas.mm.planning.SchedulingExceptionResource", (String)"NOINALLOTDEF_DETAIL", (String[])new String[]{material.getNumber(), material.getName()});
                PLSExectionMSGInfo exceInfo = new PLSExectionMSGInfo(exceNum, exceDesc, exceDetail, this.voucherID);
                this.exceptions.add(exceInfo);
                continue block5;
            }
        }
        CalcPLSPriorityRunner calcPLSPriorityRunner = new CalcPLSPriorityRunner(this.ctx, this.storageOrgUnitInfo, this.returnList, this.voucherID, this.lineSchedulingModelInfo);
        calcPLSPriorityRunner.running();
        this.returnList = calcPLSPriorityRunner.getReturnList();
        List cpExceptions = calcPLSPriorityRunner.getExceptions();
        if (cpExceptions != null && cpExceptions.size() > 0) {
            int n = cpExceptions.size();
            for (int i = 0; i < n; ++i) {
                PLSExectionMSGInfo exceInfo = (PLSExectionMSGInfo)cpExceptions.get(i);
                this.exceptions.add(exceInfo);
            }
        }
    }

    protected static Comparator getPriorityComparator(int sortStrategy) throws BOSException, EASBizException {
        switch (sortStrategy) {
            case 1: {
                return new Comparator(){

                    public int compare(Object o1, Object o2) {
                        ProductLinePAllotDefEntryRuleEntryInfo ruleEntry1 = (ProductLinePAllotDefEntryRuleEntryInfo)o1;
                        ProductLinePAllotDefEntryRuleEntryInfo ruleEntry2 = (ProductLinePAllotDefEntryRuleEntryInfo)o2;
                        return ruleEntry1.getPriority() - ruleEntry2.getPriority();
                    }
                };
            }
            case 2: {
                return new Comparator(){

                    public int compare(Object o1, Object o2) {
                        ProductLinePAllotDefEntryRuleEntryInfo ruleEntry1 = (ProductLinePAllotDefEntryRuleEntryInfo)o1;
                        ProductLinePAllotDefEntryRuleEntryInfo ruleEntry2 = (ProductLinePAllotDefEntryRuleEntryInfo)o2;
                        return ruleEntry1.getQuota().compareTo(ruleEntry2.getQuota());
                    }
                };
            }
        }
        return null;
    }

    protected PLChooseEntryInfo getPLChooseEntryFromPlanOrderEntry(PlanOrderEntryInfo pOEntryInfo) throws BOSException, EASBizException {
        PLChooseEntryInfo pLCEntry = new PLChooseEntryInfo();
        pLCEntry.setId(BOSUuid.create((String)"0D3E538A"));
        pLCEntry.setBeginDate(pOEntryInfo.getBeginDate());
        pLCEntry.setEndDate(pOEntryInfo.getEndDate());
        pLCEntry.setMaterial(pOEntryInfo.getMaterial());
        pLCEntry.setUnit(pOEntryInfo.getUnit());
        pLCEntry.setBaseUnit(pOEntryInfo.getMaterial().getBaseUnit());
        pLCEntry.setQty(pOEntryInfo.getNoSchedulingQty());
        pLCEntry.setSchedulingQty(PLSConstant.ZERO);
        pLCEntry.setNoSchedulingQty(PLSConstant.ZERO);
        pLCEntry.setSourceBillNumber(pOEntryInfo.getSourceBillNumber());
        pLCEntry.setSourceBillId(pOEntryInfo.getSourceBillId());
        pLCEntry.setSourceBillEntryId(pOEntryInfo.getId().toString());
        pLCEntry.setSrcType(pOEntryInfo.getSrcType());
        pLCEntry.setTraceNo(pOEntryInfo.getTraceNo());
        pLCEntry.setTrackNumber(pOEntryInfo.getTrackNumber());
        pLCEntry.setSaleOrder(pOEntryInfo.getSaleOrder());
        return pLCEntry;
    }
}

