/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.IMaterialPlan;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.master.material.MaterialIssueModeEnum;
import com.kingdee.eas.basedata.master.material.MaterialPlanFactory;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.master.material.MaterialProductEnum;
import com.kingdee.eas.basedata.master.material.MaterialScrapRateExpressionEnum;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeFactory;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.batchaction.ActionCommonException;
import com.kingdee.eas.mm.basedata.BomInfo;
import com.kingdee.eas.mm.basedata.ConsumeTypeEnum;
import com.kingdee.eas.mm.basedata.ExpandStrategyEnum;
import com.kingdee.eas.mm.basedata.PLSModelInfo;
import com.kingdee.eas.mm.basedata.ProductLineInfo;
import com.kingdee.eas.mm.basedata.ProductLineWPCollection;
import com.kingdee.eas.mm.basedata.ProductLineWPEntryCollection;
import com.kingdee.eas.mm.basedata.ProductLineWPEntryInfo;
import com.kingdee.eas.mm.basedata.ProductLineWPFactory;
import com.kingdee.eas.mm.basedata.ProductLineWPInfo;
import com.kingdee.eas.mm.basedata.ProductionFormulaEntryCollection;
import com.kingdee.eas.mm.basedata.ProductionFormulaEntryInfo;
import com.kingdee.eas.mm.basedata.ProductionFormulaInfo;
import com.kingdee.eas.mm.basedata.SubstituteModeEnum;
import com.kingdee.eas.mm.common.MMBaseException;
import com.kingdee.eas.mm.common.util.ProductionFormulaHelper;
import com.kingdee.eas.mm.common.util.ResourceUtils;
import com.kingdee.eas.mm.control.BizTypeEnum;
import com.kingdee.eas.mm.control.ProductionOrderEntryInfo;
import com.kingdee.eas.mm.control.ProductionOrderFactory;
import com.kingdee.eas.mm.control.ProductionOrderInfo;
import com.kingdee.eas.mm.control.ProductionOrderOutputEntryInfo;
import com.kingdee.eas.mm.control.ProductionOrderStockEntryCollection;
import com.kingdee.eas.mm.control.ProductionOrderStockEntryInfo;
import com.kingdee.eas.mm.control.TransactionTypeEnum;
import com.kingdee.eas.mm.control.app.PrdLotServerUtils;
import com.kingdee.eas.mm.planning.IPlannedOrder;
import com.kingdee.eas.mm.planning.PLSConstant;
import com.kingdee.eas.mm.planning.PLSEntryInfo;
import com.kingdee.eas.mm.planning.PLSExectionMSGInfo;
import com.kingdee.eas.mm.planning.PlannedOrderEntryCollection;
import com.kingdee.eas.mm.planning.PlannedOrderEntryInfo;
import com.kingdee.eas.mm.planning.PlannedOrderFactory;
import com.kingdee.eas.mm.planning.PlannedOrderInfo;
import com.kingdee.eas.mm.planning.SchedulingException;
import com.kingdee.eas.mm.planning.SrcTypeEnum;
import com.kingdee.eas.mm.planning.app.PLSRunner;
import com.kingdee.eas.mm.planning.util.PLSUtil;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.loadmass.SCMEntryDataVO;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PLSReleaseRunner
extends PLSRunner {
    protected List srcList;
    protected Map srcMap;
    protected Map lineWPMap;
    protected Map mmuPrecisions;
    protected Map mmuConvsRate;
    protected Map materialPlanInfos;
    protected Map materialInvInfos;
    protected UserInfo currUser;
    protected BillTypeInfo billType;
    protected BillTypeInfo sourceBillType;
    protected Map<String, BomInfo> bomCatch;
    protected String lotNoGen;

    public PLSReleaseRunner(Context ctx, StorageOrgUnitInfo storageOrgUnitInfo, List list, String currVoucherID, PLSModelInfo pLSModelInfo) {
        this.ctx = ctx;
        this.srcList = list;
        this.storageOrgUnitInfo = storageOrgUnitInfo;
        this.voucherID = currVoucherID;
        this.lineSchedulingModelInfo = pLSModelInfo;
    }

    @Override
    protected void prepareData() throws BOSException, EASBizException {
        super.prepareData();
        if (this.srcList != null && this.srcList.size() > 0) {
            this.srcMap = new HashMap();
            HashSet<String> keySet = new HashSet<String>();
            HashSet<String> lineSet = new HashSet<String>();
            int n = this.srcList.size();
            MaterialInfo[] materialInfos = new MaterialInfo[n];
            MeasureUnitInfo[] unitInfos = new MeasureUnitInfo[n];
            MeasureUnitInfo[] baseUnitInfos = new MeasureUnitInfo[n];
            for (int i = 0; i < n; ++i) {
                List<PLSEntryInfo> list;
                PLSEntryInfo plsEntryInfo = (PLSEntryInfo)this.srcList.get(i);
                String materialID = plsEntryInfo.getMaterial().getId().toString();
                String productLineID = plsEntryInfo.getProductLine().getId().toString();
                keySet.add(materialID + "@" + productLineID);
                lineSet.add(productLineID);
                materialInfos[i] = plsEntryInfo.getMaterial();
                unitInfos[i] = plsEntryInfo.getUnit();
                baseUnitInfos[i] = plsEntryInfo.getBaseUnit();
                String lineNum = plsEntryInfo.getLineNum();
                if (plsEntryInfo.isIsSubPlan()) {
                    lineNum = plsEntryInfo.getLineNum().substring(0, 3);
                }
                if (this.srcMap.containsKey(lineNum)) {
                    list = (List)this.srcMap.get(lineNum);
                    list.add(plsEntryInfo);
                    continue;
                }
                list = new ArrayList<PLSEntryInfo>();
                list.add(plsEntryInfo);
                this.srcMap.put(lineNum, list);
            }
            SCMEntryDataVO voResult = PLSUtil.loadComplexDataForServer(this.ctx, this.storageOrgUnitInfo, materialInfos);
            if (voResult != null) {
                this.materialPlanInfos = voResult.getMaterialPlanInfos();
                this.materialInvInfos = voResult.getMaterialInventoryInfos();
                voResult = PLSUtil.getMmuPrecisionForServer(this.ctx, this.storageOrgUnitInfo, materialInfos, unitInfos, baseUnitInfos);
                if (voResult != null) {
                    this.mmuConvsRate = voResult.getMmuConvsRate();
                    this.mmuPrecisions = voResult.getMmuPrecisions();
                }
            }
            this.getLineWPMap(lineSet);
            this.currUser = UserFactory.getLocalInstance((Context)this.ctx).getUserInfo(this.ctx.getCaller());
            this.billType = BillTypeFactory.getLocalInstance((Context)this.ctx).getBillTypeInfo((IObjectPK)new ObjectUuidPK("ejIZHXXTQliYCQJg9t4Re0Y+1VI="));
            this.sourceBillType = BillTypeFactory.getLocalInstance((Context)this.ctx).getBillTypeInfo((IObjectPK)new ObjectUuidPK("OC9YcwEhEADgAAApfwAAAUY+1VI="));
            this.lotNoGen = ParamManager.getParamValue((Context)this.ctx, (IObjectPK)new ObjectUuidPK(this.storageOrgUnitInfo.getId().toString()), (String)"LotCodeGen");
        }
    }

    @Override
    protected void running() throws BOSException, EASBizException {
        this.prepareData();
        if (this.srcMap != null && this.srcMap.size() > 0) {
            PreparedStatement saveBotpPrpStmt;
            Connection conn;
            block32: {
                String saveBotpSql = "insert into t_bot_relation (FID,FSRCENTITYID,FDESTENTITYID,FSRCOBJECTID,FDESTOBJECTID,FDATE,FOPERATORID,FISEFFECTED,FBOTMAPPINGID,FTYPE) values (?,'6B821276','1F66774E',?,?,now(),?,1,null,0)";
                conn = null;
                saveBotpPrpStmt = null;
                try {
                    conn = EJBFactory.getConnection((Context)this.ctx);
                    saveBotpPrpStmt = conn.prepareStatement(saveBotpSql);
                    HashMap<String, BigDecimal> writeBackMap = new HashMap<String, BigDecimal>();
                    CoreBaseCollection productionOrderCollection = new CoreBaseCollection();
                    Set keySet = this.srcMap.keySet();
                    this.returnList = new ArrayList();
                    IParamControl ipc = ParamControlFactory.getLocalInstance((Context)this.ctx);
                    String strValue = ipc.getParamValue((IObjectPK)new ObjectStringPK(this.storageOrgUnitInfo.getId().toString()), "DailyCapacityPlansTITCAM");
                    boolean isReplace = false;
                    HashMap<String, String> errorMap = new HashMap<String, String>();
                    if (strValue != null && strValue.trim().toLowerCase().equals("true")) {
                        isReplace = true;
                    }
                    for (String key : keySet) {
                        List list = (List)this.srcMap.get(key);
                        Collections.sort(list, new Comparator(){

                            public int compare(Object o1, Object o2) {
                                PLSEntryInfo info1 = (PLSEntryInfo)o1;
                                PLSEntryInfo info2 = (PLSEntryInfo)o2;
                                return info1.getLineNum().compareTo(info2.getLineNum());
                            }
                        });
                        ArrayList<ProductionOrderInfo> genOrderList = new ArrayList<ProductionOrderInfo>();
                        boolean isFail = false;
                        String plannedOrderId = null;
                        BigDecimal releasedQty = PLSConstant.ZERO;
                        int n = list.size();
                        for (int i = 0; i < n; ++i) {
                            PLSEntryInfo plsEntryInfo = (PLSEntryInfo)list.get(i);
                            String msKey = plsEntryInfo.getMaterial().getId().toString() + this.storageOrgUnitInfo.getId().toString();
                            MaterialInventoryInfo miInfo = (MaterialInventoryInfo)this.materialInvInfos.get(msKey);
                            MaterialPlanInfo mpInfo = (MaterialPlanInfo)this.materialPlanInfos.get(msKey);
                            StringBuffer errBuff = new StringBuffer();
                            MaterialInfo material = plsEntryInfo.getMaterial();
                            ProductLineInfo productLine = plsEntryInfo.getProductLine();
                            ProductionOrderInfo productionOrderInfo = new ProductionOrderInfo();
                            BigDecimal yield = null;
                            if (plsEntryInfo.getParent().getPLSModel().getExpandStrategy().equals((Object)ExpandStrategyEnum.ByBOMExpand)) {
                                BomInfo bomInfo = null;
                                if (this.bomCatch == null) {
                                    this.bomCatch = new HashMap<String, BomInfo>();
                                }
                                if (this.bomCatch.containsKey(material.getId().toString())) {
                                    bomInfo = this.bomCatch.get(material.getId().toString());
                                } else {
                                    bomInfo = ProductionFormulaHelper.getDefaultBOM((Context)this.ctx, (Object)material, (Object)this.storageOrgUnitInfo, null);
                                    this.bomCatch.put(material.getId().toString(), bomInfo);
                                }
                                productionOrderInfo.setBom(bomInfo);
                                yield = bomInfo != null ? bomInfo.getYield() : mpInfo.getYield();
                            } else if (plsEntryInfo.getParent().getPLSModel().getExpandStrategy().equals((Object)ExpandStrategyEnum.ByProductionFormulaExpand)) {
                                ProductionFormulaInfo productionFormula = plsEntryInfo.getFormula();
                                if (productionFormula == null) {
                                    productionFormula = ProductionFormulaHelper.getDefaultFormula((Context)this.ctx, null, (Object)material, (Object)productLine, (Object)plsEntryInfo.getTrackNumber(), (Object)this.storageOrgUnitInfo, (Object)productionFormula);
                                }
                                productionOrderInfo.setFormula(productionFormula);
                                yield = productionFormula != null ? productionFormula.getYield() : mpInfo.getYield();
                            }
                            Timestamp curDate = new Timestamp(new Date().getTime());
                            productionOrderInfo.setId(BOSUuid.create((String)"1F66774E"));
                            productionOrderInfo = this.genBillHead(this.ctx, productionOrderInfo, plsEntryInfo);
                            productionOrderInfo.setBillType(this.billType);
                            productionOrderInfo.setSourceBillType(this.sourceBillType);
                            productionOrderInfo.setMmBizType(BizTypeEnum.common);
                            productionOrderInfo.setWarehouse(miInfo.getDefaultWarehouse());
                            PrdLotServerUtils.dealLotNo((Context)this.ctx, (ProductionOrderInfo)productionOrderInfo);
                            productionOrderInfo = ProductionOrderFactory.getLocalInstance((Context)this.ctx).buildEntrys(productionOrderInfo);
                            productionOrderInfo.setBizDate((Date)curDate);
                            productionOrderInfo.setHandler(this.currUser);
                            productionOrderInfo.setCreator(this.currUser);
                            productionOrderInfo.setCreateTime(curDate);
                            productionOrderInfo.setModifier(this.currUser);
                            productionOrderInfo.setModificationTime(curDate);
                            productionOrderInfo.setMaterialPlan(mpInfo);
                            productionOrderInfo.setYield(yield);
                            yield = yield != null ? yield.divide(PLSConstant.HUNDRED, 8, 4) : PLSConstant.ONE;
                            productionOrderInfo.setExpectOutputQty(plsEntryInfo.getQty().multiply(yield));
                            productionOrderInfo.setBaseExpectOutputQty(plsEntryInfo.getBaseQty().multiply(yield));
                            String err = "";
                            try {
                                err = ProductionOrderFactory.getLocalInstance((Context)this.ctx).plsCheckForPrdEntry(productionOrderInfo);
                                if (isReplace) {
                                    this.dealWithReplaceMat(plsEntryInfo, productionOrderInfo);
                                }
                            }
                            catch (ActionCommonException e) {
                                errBuff.append(e.getMessage());
                            }
                            if (err.length() > 0) {
                                errBuff.append(err);
                            }
                            if (errBuff.length() > 0) {
                                if (errorMap.containsKey(plsEntryInfo.getParent().getId().toString()) && errorMap.get(plsEntryInfo.getParent().getId().toString()).toString().equals(plsEntryInfo.getMaterial().getId().toString() + "@" + plsEntryInfo.getProductLine().getId().toString())) continue;
                                String exceDesc = ResourceUtils.getMessageForServer((String)"com.kingdee.eas.mm.planning.SchedulingExceptionResource", (String)"RELEASEFAIL_DESC");
                                int exceNum = 301;
                                String exceDetail = errBuff.toString();
                                PLSExectionMSGInfo exceInfo = new PLSExectionMSGInfo(exceNum, exceDesc, exceDetail, plsEntryInfo.getParent().getId().toString());
                                this.exceptions.add(exceInfo);
                                errorMap.put(plsEntryInfo.getParent().getId().toString(), plsEntryInfo.getMaterial().getId().toString() + "@" + plsEntryInfo.getProductLine().getId().toString());
                                isFail = true;
                                continue;
                            }
                            genOrderList.add(productionOrderInfo);
                            if (plsEntryInfo.isIsSubPlan()) continue;
                            SrcTypeEnum srcType = plsEntryInfo.getSrcType();
                            if (srcType != null && srcType == SrcTypeEnum.PLANORDER) {
                                plannedOrderId = plsEntryInfo.getSourceBillId();
                                releasedQty = plsEntryInfo.getQty();
                            }
                            if (plannedOrderId == null) continue;
                            if (writeBackMap.get(plannedOrderId) != null) {
                                BigDecimal current = (BigDecimal)writeBackMap.get(plannedOrderId);
                                writeBackMap.put(plannedOrderId, current.add(releasedQty));
                                continue;
                            }
                            writeBackMap.put(plannedOrderId, releasedQty);
                        }
                        if (genOrderList.size() <= 0) continue;
                        int m = genOrderList.size();
                        for (int j = 0; j < m; ++j) {
                            ProductionOrderInfo productionOrderInfo_success = (ProductionOrderInfo)genOrderList.get(j);
                            try {
                                saveBotpPrpStmt.setString(1, BOSUuid.create((String)"59302EC6").toString());
                                saveBotpPrpStmt.setString(2, productionOrderInfo_success.getSourceBillId());
                                saveBotpPrpStmt.setString(3, productionOrderInfo_success.getId().toString());
                                saveBotpPrpStmt.setString(4, productionOrderInfo_success.getCreator().getId().toString());
                                saveBotpPrpStmt.addBatch();
                            }
                            catch (SQLException e) {
                                throw new BOSException((Throwable)e);
                            }
                            productionOrderCollection.add((CoreBaseInfo)productionOrderInfo_success);
                            this.returnList.add(productionOrderInfo_success.getSourceBillEntry());
                        }
                    }
                    ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)this.ctx);
                    ProductionOrderInfo prOrderInfo = new ProductionOrderInfo();
                    prOrderInfo.setBizDate(new Date());
                    prOrderInfo.setCU(this.storageOrgUnitInfo.getCU());
                    int n = productionOrderCollection.size();
                    if (n <= 0) break block32;
                    if (codingRuleManager.isExist((IObjectValue)prOrderInfo, this.storageOrgUnitInfo.getId().toString())) {
                        String[] numbers = codingRuleManager.getBatchNumber((IObjectValue)prOrderInfo, this.storageOrgUnitInfo.getId().toString(), n);
                        for (int i = 0; i < n; ++i) {
                            ProductionOrderInfo productionOrderInfo = (ProductionOrderInfo)productionOrderCollection.get(i);
                            productionOrderInfo.setNumber(numbers[i]);
                        }
                    } else {
                        throw new SchedulingException(SchedulingException.NOCODERULE);
                    }
                    try {
                        if (writeBackMap != null && writeBackMap.size() > 0) {
                            PlannedOrderFactory.getLocalInstance(this.ctx).batchWriteBackByRelease(writeBackMap);
                        }
                        if (this.returnList != null && this.returnList.size() > 0) {
                            String idStr = this.parseToStringForInclude(this.returnList);
                            StringBuffer releaseSql = new StringBuffer();
                            releaseSql.append(" update T_MM_PLSEntry set FBaseStatus = 5");
                            releaseSql.append(" ,FReleaseUserID = '" + this.ctx.getCaller().toString() + "'");
                            releaseSql.append(" ,FReleaseTime = now()");
                            releaseSql.append(" where FID in (" + idStr + ")");
                            DbUtil.execute((Context)this.ctx, (String)releaseSql.toString());
                        }
                        ProductionOrderFactory.getLocalInstance((Context)this.ctx).addNewByBatch(productionOrderCollection);
                        saveBotpPrpStmt.executeBatch();
                    }
                    catch (SQLException e) {
                        throw new BOSException((Throwable)e);
                    }
                }
                catch (SQLException e) {
                    try {
                        throw new BOSException((Throwable)e);
                    }
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(saveBotpPrpStmt, (Connection)conn);
                        throw throwable;
                    }
                }
            }
            SQLUtils.cleanup((Statement)saveBotpPrpStmt, (Connection)conn);
        }
    }

    private String parseToStringForInclude(List list) {
        StringBuffer ret = new StringBuffer();
        Iterator it = list.iterator();
        int index = 0;
        while (it.hasNext()) {
            if (index > 0) {
                ret.append(",");
            }
            ret.append("'");
            ret.append(it.next().toString());
            ret.append("'");
            ++index;
        }
        return ret.toString();
    }

    protected ProductionOrderInfo genBillHead(Context ctx, ProductionOrderInfo productionOrderInfo, PLSEntryInfo plsEntryInfo) throws BOSException, EASBizException {
        productionOrderInfo.setCU(plsEntryInfo.getParent().getCU());
        productionOrderInfo.setSourceBillId(plsEntryInfo.getParent().getId().toString());
        productionOrderInfo.setSourceBillNumber(plsEntryInfo.getParent().getNumber());
        productionOrderInfo.setSourceBillEntry(plsEntryInfo.getId().toString());
        productionOrderInfo.setMpsPlanOrdID(plsEntryInfo.getSourceBillId());
        productionOrderInfo.setQty(plsEntryInfo.getQty());
        productionOrderInfo.setBaseQty(plsEntryInfo.getBaseQty());
        productionOrderInfo.setTraceNo(plsEntryInfo.getTraceNo());
        productionOrderInfo.setTrackNumber(plsEntryInfo.getTrackNumber());
        productionOrderInfo.setStorageOrgUnit(plsEntryInfo.getParent().getStorageOrgUnit());
        productionOrderInfo.setMaterial(plsEntryInfo.getMaterial());
        productionOrderInfo.setModel(plsEntryInfo.getMaterial().getModel());
        productionOrderInfo.setProductLine(plsEntryInfo.getProductLine());
        productionOrderInfo.setUnit(plsEntryInfo.getUnit());
        productionOrderInfo.setBaseUnit(plsEntryInfo.getBaseUnit());
        productionOrderInfo.setWorkShop(plsEntryInfo.getProductLine().getWorkshop());
        productionOrderInfo.setStartDate((Date)plsEntryInfo.getBeginDate());
        productionOrderInfo.setEndDate((Date)plsEntryInfo.getEndDate());
        productionOrderInfo.setClassTeam(plsEntryInfo.getClassTeam());
        productionOrderInfo.setPriority(plsEntryInfo.getProOrder());
        productionOrderInfo.setIsPickSlip(false);
        productionOrderInfo.setSaleOrder(plsEntryInfo.getSaleOrder());
        productionOrderInfo.setBaseStatus(BillBaseStatusEnum.SUBMITED);
        productionOrderInfo.setMotherBillId(plsEntryInfo.getMainPlanID());
        productionOrderInfo.setExpectEndDate((Date)plsEntryInfo.getOutputDate());
        return productionOrderInfo;
    }

    protected ProductionOrderInfo genWPEntrys(Context ctx, ProductionOrderInfo productionOrderInfo) throws BOSException, EASBizException {
        String productLineID = productionOrderInfo.getProductLine().getId().toString();
        ProductLineWPEntryCollection wpCol = (ProductLineWPEntryCollection)this.lineWPMap.get(productLineID);
        if (wpCol != null && wpCol.size() > 0) {
            for (int j = 0; j < wpCol.size(); ++j) {
                ProductLineWPEntryInfo prdLineWPEntryInfo = wpCol.get(j);
                ProductionOrderEntryInfo entryInfo = new ProductionOrderEntryInfo();
                entryInfo.setProductLineWP(prdLineWPEntryInfo);
                entryInfo.setPrdLineWPNumber(prdLineWPEntryInfo.getNumber());
                entryInfo.setIsWP(prdLineWPEntryInfo.isIsWP());
                entryInfo.setIsQCPoint(prdLineWPEntryInfo.isIsQCPoint());
                entryInfo.setIsReportPoint(prdLineWPEntryInfo.isIsReportPoint());
                entryInfo.setIsStockPoint(prdLineWPEntryInfo.isIsStockPoint());
                entryInfo.setPrepareTime(prdLineWPEntryInfo.getPrepareTime());
                entryInfo.setWorkTime(prdLineWPEntryInfo.getWorkTime());
                entryInfo.setResource(prdLineWPEntryInfo.getResource());
                entryInfo.setPrepTimeUnit(prdLineWPEntryInfo.getPrepTimeUnit());
                entryInfo.setWorkTimeUnit(prdLineWPEntryInfo.getWorkTimeUnit());
                entryInfo.setRemark(prdLineWPEntryInfo.getWPDescription());
                productionOrderInfo.getWpEntry().add(entryInfo);
            }
        }
        return productionOrderInfo;
    }

    protected ProductionOrderInfo genOtherEntrys(Context ctx, ProductionOrderInfo productionOrderInfo, ProductionFormulaInfo productionFormula) throws BOSException, EASBizException {
        ProductionFormulaEntryCollection col = productionFormula.getEntrys();
        int lineSeq = 1;
        if (col != null && col.size() > 0) {
            int n = col.size();
            for (int i = 0; i < n; ++i) {
                ProductionOrderOutputEntryInfo entryInfo;
                ProductionFormulaEntryInfo formulaEntryInfo = col.get(i);
                if (productionOrderInfo.getStartDate().after(formulaEntryInfo.getDisableDate()) || productionOrderInfo.getEndDate().before(formulaEntryInfo.getEffectiveDate())) continue;
                double one = PLSConstant.ONE.doubleValue();
                double zero = PLSConstant.ZERO.doubleValue();
                double hundred = PLSConstant.HUNDRED.doubleValue();
                double baseQty = productionOrderInfo.getBaseQty().doubleValue();
                double parentBaseQty = productionFormula.getProductBaseQty().doubleValue();
                ConsumeTypeEnum consumeType = formulaEntryInfo.getConsumeType();
                double consumeFixBaseQty = formulaEntryInfo.getConsumeFixBaseQty().doubleValue();
                double proportion = formulaEntryInfo.getProportion().doubleValue() / hundred;
                double productRate = formulaEntryInfo.getBaseProductRate().doubleValue();
                double scrapRate = zero;
                if (formulaEntryInfo.getMaterialInventory() != null && formulaEntryInfo.getMaterialInventory().getScrapRate() != null) {
                    scrapRate = formulaEntryInfo.getMaterialInventory().getScrapRate().doubleValue() / hundred;
                }
                MaterialScrapRateExpressionEnum scrapRateExpression = null;
                if (formulaEntryInfo.getMaterialInventory() != null && formulaEntryInfo.getMaterialInventory().getScrapRateExpression() != null) {
                    scrapRateExpression = formulaEntryInfo.getMaterialInventory().getScrapRateExpression();
                }
                if (!MaterialProductEnum.RELATEDPRODUCT.equals((Object)formulaEntryInfo.getProductType()) && !MaterialProductEnum.BYPRODUCT.equals((Object)formulaEntryInfo.getProductType()) && (MaterialIssueModeEnum.PRODUCEISSMODE.equals((Object)formulaEntryInfo.getPickingMode()) || MaterialIssueModeEnum.STRAIGHT.equals((Object)formulaEntryInfo.getPickingMode()))) {
                    entryInfo = new ProductionOrderStockEntryInfo();
                    entryInfo.setProductLineWP(formulaEntryInfo.getProductLineWP());
                    MaterialInfo material = formulaEntryInfo.getMaterial();
                    entryInfo.setMaterial(material);
                    entryInfo.setUnit(formulaEntryInfo.getUnit());
                    entryInfo.setMaterialInventory(formulaEntryInfo.getMaterialInventory());
                    entryInfo.setBaseUnit(formulaEntryInfo.getBaseUnit());
                    entryInfo.setPickingLeadTime(formulaEntryInfo.getPickingLeadTime());
                    entryInfo.setIssMode(formulaEntryInfo.getPickingMode());
                    entryInfo.setIsBackFlush(formulaEntryInfo.isIsBackFlush());
                    WarehouseInfo warehouse = formulaEntryInfo.getWarehouse();
                    entryInfo.setDefaultWarehouse(warehouse);
                    entryInfo.setBaseSendOutTotalQty(PLSConstant.ZERO);
                    entryInfo.setSendOutTotalQty(PLSConstant.ZERO);
                    entryInfo.setUntreadTotalQty(PLSConstant.ZERO);
                    entryInfo.setBaseUntreadTotalQty(PLSConstant.ZERO);
                    entryInfo.setMaterialChar(formulaEntryInfo.getMaterialAttr());
                    entryInfo.setModel(formulaEntryInfo.getMaterial().getModel());
                    entryInfo.setStartDate(productionOrderInfo.getStartDate());
                    entryInfo.setEndDate(productionOrderInfo.getEndDate());
                    entryInfo.setConsumeType(consumeType);
                    entryInfo.setLineSeq(lineSeq + "0");
                    ++lineSeq;
                    entryInfo.setIsStock(formulaEntryInfo.isIsStock());
                    entryInfo.setMoveOutWarehouse(formulaEntryInfo.getMoveOutWareHouse());
                    entryInfo.setMoveOutStorageOrgUnit(formulaEntryInfo.getSourceStorageOrgUnit());
                    if (ConsumeTypeEnum.VariableAmount.equals((Object)consumeType)) {
                        entryInfo.setConsumeFixQty(formulaEntryInfo.getConsumeFixQty());
                        entryInfo.setBaseConsumeFixQty(formulaEntryInfo.getConsumeFixBaseQty());
                        entryInfo.setProportion(PLSConstant.ZERO);
                    } else if (ConsumeTypeEnum.Proportion.equals((Object)consumeType)) {
                        entryInfo.setConsumeFixQty(PLSConstant.ZERO);
                        entryInfo.setBaseConsumeFixQty(PLSConstant.ZERO);
                        entryInfo.setProportion(formulaEntryInfo.getProportion());
                    }
                    entryInfo.setRemark(formulaEntryInfo.getRemark());
                    String materialId = entryInfo.getMaterial().getId().toString();
                    if (ConsumeTypeEnum.VariableAmount.equals((Object)consumeType)) {
                        double tempQty = baseQty / parentBaseQty * consumeFixBaseQty;
                        if (scrapRateExpression != null && scrapRateExpression.equals((Object)MaterialScrapRateExpressionEnum.BYDIVIDE)) {
                            tempQty /= one - scrapRate;
                        } else if (scrapRateExpression != null && scrapRateExpression.equals((Object)MaterialScrapRateExpressionEnum.MUTIPLE)) {
                            tempQty *= one + scrapRate;
                        }
                        entryInfo.setBaseQty(PLSUtil.getConstraintQty(new BigDecimal(tempQty).setScale(8, 4)));
                    } else if (ConsumeTypeEnum.Proportion.equals((Object)consumeType)) {
                        double tempQty = baseQty * proportion / productRate;
                        if (scrapRateExpression != null && scrapRateExpression.equals((Object)MaterialScrapRateExpressionEnum.BYDIVIDE)) {
                            tempQty /= one - scrapRate;
                        } else if (scrapRateExpression != null && scrapRateExpression.equals((Object)MaterialScrapRateExpressionEnum.MUTIPLE)) {
                            tempQty *= one + scrapRate;
                        }
                        entryInfo.setBaseQty(PLSUtil.getConstraintQty(new BigDecimal(tempQty)));
                    }
                    String unitId = entryInfo.getUnit().getId().toString();
                    String baseUnitId = entryInfo.getBaseUnit().getId().toString();
                    if (entryInfo.getBaseQty() != null) {
                        entryInfo.setQty(PLSUtil.getConstraintQty(this.getExchangePrecisionQty(materialId, baseUnitId, unitId, entryInfo.getBaseQty())));
                    }
                    productionOrderInfo.getStockEntry().add((ProductionOrderStockEntryInfo)entryInfo);
                    continue;
                }
                if (!MaterialProductEnum.RELATEDPRODUCT.equals((Object)formulaEntryInfo.getProductType()) && !MaterialProductEnum.BYPRODUCT.equals((Object)formulaEntryInfo.getProductType())) continue;
                entryInfo = new ProductionOrderOutputEntryInfo();
                entryInfo.setMaterial(formulaEntryInfo.getMaterial());
                entryInfo.setModel(formulaEntryInfo.getMaterial().getModel());
                entryInfo.setUnit(formulaEntryInfo.getUnit());
                entryInfo.setBaseUnit(formulaEntryInfo.getBaseUnit());
                entryInfo.setOutputType(formulaEntryInfo.getProductType());
                entryInfo.setProductLineWP(formulaEntryInfo.getProductLineWP());
                entryInfo.setMaterialPlan(formulaEntryInfo.getMaterialInventory());
                entryInfo.setConsumeType(consumeType);
                if (ConsumeTypeEnum.VariableAmount.equals((Object)consumeType)) {
                    entryInfo.setConsumeFixQty(formulaEntryInfo.getConsumeFixQty());
                    entryInfo.setBaseConsumeFixQty(formulaEntryInfo.getConsumeFixBaseQty());
                    entryInfo.setProportion(PLSConstant.ZERO);
                } else if (ConsumeTypeEnum.Proportion.equals((Object)consumeType)) {
                    entryInfo.setConsumeFixQty(PLSConstant.ZERO);
                    entryInfo.setBaseConsumeFixQty(PLSConstant.ZERO);
                    entryInfo.setProportion(formulaEntryInfo.getProportion());
                }
                entryInfo.setRemark(formulaEntryInfo.getRemark());
                String materialId = entryInfo.getMaterial().getId().toString();
                if (ConsumeTypeEnum.VariableAmount.equals((Object)consumeType)) {
                    double tempQty = baseQty / parentBaseQty * consumeFixBaseQty;
                    if (scrapRateExpression != null && scrapRateExpression.equals((Object)MaterialScrapRateExpressionEnum.BYDIVIDE)) {
                        tempQty /= one - scrapRate;
                    } else if (scrapRateExpression != null && scrapRateExpression.equals((Object)MaterialScrapRateExpressionEnum.MUTIPLE)) {
                        tempQty *= one + scrapRate;
                    }
                    entryInfo.setBaseQty(PLSUtil.getConstraintQty(new BigDecimal(tempQty).setScale(8, 4)));
                } else if (ConsumeTypeEnum.Proportion.equals((Object)consumeType)) {
                    double tempQty = baseQty * proportion / productRate;
                    if (scrapRateExpression != null && scrapRateExpression.equals((Object)MaterialScrapRateExpressionEnum.BYDIVIDE)) {
                        tempQty /= one - scrapRate;
                    } else if (scrapRateExpression != null && scrapRateExpression.equals((Object)MaterialScrapRateExpressionEnum.MUTIPLE)) {
                        tempQty *= one + scrapRate;
                    }
                    entryInfo.setBaseQty(PLSUtil.getConstraintQty(new BigDecimal(tempQty)));
                }
                String unitId = entryInfo.getUnit().getId().toString();
                String baseUnitId = entryInfo.getBaseUnit().getId().toString();
                if (entryInfo.getBaseQty() != null) {
                    entryInfo.setQty(PLSUtil.getConstraintQty(this.getExchangePrecisionQty(materialId, baseUnitId, unitId, entryInfo.getBaseQty())));
                }
                productionOrderInfo.getOutputEntry().add(entryInfo);
            }
        }
        return productionOrderInfo;
    }

    protected void getLineWPMap(Set lineSet) throws BOSException, EASBizException {
        this.lineWPMap = new HashMap();
        EntityViewInfo wpViewInfo = new EntityViewInfo();
        FilterInfo wpFilterInfo = new FilterInfo();
        wpFilterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(20), CompareType.EQUALS));
        wpFilterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)this.storageOrgUnitInfo.getId().toString(), CompareType.EQUALS));
        wpFilterInfo.getFilterItems().add(new FilterItemInfo("productline.id", (Object)lineSet, CompareType.INCLUDE));
        wpViewInfo.getSelector().add(new SelectorItemInfo("*"));
        wpViewInfo.getSelector().add(new SelectorItemInfo("entry.*"));
        wpViewInfo.getSelector().add(new SelectorItemInfo("entry.resource.*"));
        wpViewInfo.setFilter(wpFilterInfo);
        ProductLineWPCollection wpCol = ProductLineWPFactory.getLocalInstance((Context)this.ctx).getProductLineWPCollection(wpViewInfo);
        if (wpCol != null && wpCol.size() > 0) {
            int n = wpCol.size();
            for (int i = 0; i < n; ++i) {
                ProductLineWPInfo lineWPInfo = wpCol.get(i);
                String productLine = lineWPInfo.getProductLine().getId().toString();
                this.lineWPMap.put(productLine, lineWPInfo.getEntry());
            }
        }
    }

    protected BigDecimal getExchangePrecisionQty(String materialId, String beforeUnitId, String afterUnitId, BigDecimal qty) throws BOSException, EASBizException {
        BigDecimal targetQty = null;
        if (beforeUnitId.equals(afterUnitId)) {
            targetQty = qty;
        } else {
            MultiMeasureUnitInfo multiUnifInfo;
            BigDecimal afterBaseRate;
            MultiMeasureUnitInfo multiUnifInfo2;
            BigDecimal beforeBaseRate = (BigDecimal)this.mmuConvsRate.get(materialId + beforeUnitId);
            if (beforeBaseRate == null && (multiUnifInfo2 = MultiMeasureUnitFactory.getLocalInstance((Context)this.ctx).getMultiUnit(materialId, beforeUnitId)) != null) {
                beforeBaseRate = multiUnifInfo2.getBaseConvsRate();
            }
            if ((afterBaseRate = (BigDecimal)this.mmuConvsRate.get(materialId + afterUnitId)) == null && (multiUnifInfo = MultiMeasureUnitFactory.getLocalInstance((Context)this.ctx).getMultiUnit(materialId, afterUnitId)) != null) {
                afterBaseRate = multiUnifInfo.getBaseConvsRate();
            }
            if (beforeBaseRate == null) {
                beforeBaseRate = PLSConstant.ONE;
            }
            if (afterBaseRate == null) {
                afterBaseRate = PLSConstant.ONE;
            }
            BigDecimal baseQty = qty.multiply(beforeBaseRate);
            targetQty = baseQty.divide(afterBaseRate, 8, 4);
        }
        return targetQty;
    }

    private void dealWithReplaceMat(PLSEntryInfo plsEntryInfo, ProductionOrderInfo productionOrderInfo) throws BOSException, EASBizException {
        if (plsEntryInfo == null || productionOrderInfo == null) {
            return;
        }
        String strSourceId = plsEntryInfo.getSourceBillId();
        IPlannedOrder iplan = PlannedOrderFactory.getLocalInstance(this.ctx);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("entries.*"));
        sic.add(new SelectorItemInfo("entries.material.id"));
        sic.add(new SelectorItemInfo("entries.material.name"));
        sic.add(new SelectorItemInfo("entries.material.number"));
        sic.add(new SelectorItemInfo("entries.unit.id"));
        sic.add(new SelectorItemInfo("entries.unit.name"));
        sic.add(new SelectorItemInfo("entries.unit.number"));
        sic.add(new SelectorItemInfo("entries.unit.qtyPrecision"));
        PlannedOrderInfo plannedInfo = iplan.getPlannedOrderInfo((IObjectPK)new ObjectUuidPK(strSourceId), sic);
        PlannedOrderEntryCollection poec = plannedInfo.getEntries();
        ProductionOrderStockEntryCollection prosColl = productionOrderInfo.getStockEntry();
        ProductionOrderStockEntryCollection prosCollreplace = new ProductionOrderStockEntryCollection();
        HashMap<String, ProductionOrderStockEntryCollection> hsRepMap = new HashMap<String, ProductionOrderStockEntryCollection>();
        HashMap<String, ProductLineWPEntryInfo> wpHashMap = new HashMap<String, ProductLineWPEntryInfo>();
        for (int i = prosColl.size() - 1; i >= 0; --i) {
            ProductionOrderStockEntryInfo prodsEInfo = prosColl.get(i);
            String strMatId = prodsEInfo.getMaterial().getId().toString();
            if (hsRepMap.containsKey(strMatId)) {
                ProductLineWPEntryInfo proLineWPInfo = prodsEInfo.getProductLineWP();
                ProductLineWPEntryInfo productLineWPInfo = (ProductLineWPEntryInfo)wpHashMap.get(strMatId);
                if (proLineWPInfo.getNumber().compareTo(productLineWPInfo.getNumber()) < 0) {
                    ProductionOrderStockEntryCollection prosCollreplaceTemp = (ProductionOrderStockEntryCollection)hsRepMap.get(strMatId);
                    wpHashMap.put(strMatId, proLineWPInfo);
                    this.setwpLine(prosCollreplaceTemp, proLineWPInfo);
                }
                prosColl.remove(prodsEInfo);
                continue;
            }
            HashMap hashMapRepPOE = this.getPlannedOEntryColl(strMatId, poec);
            if (hashMapRepPOE.size() <= 0) continue;
            Iterator itKey = hashMapRepPOE.keySet().iterator();
            int index = 0;
            int[] keys = new int[hashMapRepPOE.size()];
            while (itKey.hasNext()) {
                keys[index++] = (Integer)itKey.next();
            }
            Arrays.sort(keys);
            ProductionOrderStockEntryCollection prosCollreplaceTemp = this.genReplaceProOrdEntry(prodsEInfo, keys, hashMapRepPOE, plannedInfo, productionOrderInfo);
            hsRepMap.put(strMatId, prosCollreplaceTemp);
            wpHashMap.put(strMatId, prodsEInfo.getProductLineWP());
            this.setwpLine(prosCollreplaceTemp, prodsEInfo.getProductLineWP());
            prosCollreplace.addCollection(prosCollreplaceTemp);
            prosColl.remove(prodsEInfo);
        }
        prosColl.addCollection(prosCollreplace);
    }

    private HashMap getPlannedOEntryColl(String strMaterialId, PlannedOrderEntryCollection poec) {
        HashMap<Integer, PlannedOrderEntryInfo> hashMap = new HashMap<Integer, PlannedOrderEntryInfo>();
        if (strMaterialId == null || poec == null) {
            return null;
        }
        for (int i = 0; i < poec.size(); ++i) {
            PlannedOrderEntryInfo planOrdEInfo = poec.get(i);
            if (planOrdEInfo.getMaterialSubs() != null && planOrdEInfo.isIsReplaced()) {
                if (!strMaterialId.equals(planOrdEInfo.getMaterialSubs().getId().toString())) continue;
                int replacePriority = planOrdEInfo.getReplacePriority();
                Integer key = new Integer(replacePriority);
                if (hashMap.containsKey(key)) {
                    hashMap.clear();
                    return hashMap;
                }
                hashMap.put(new Integer(replacePriority), planOrdEInfo);
                continue;
            }
            if (!strMaterialId.equals(planOrdEInfo.getMaterial().getId().toString()) || !planOrdEInfo.isIsReplaced()) continue;
            int original = -1;
            hashMap.put(new Integer(original), planOrdEInfo);
        }
        return hashMap;
    }

    private ProductionOrderStockEntryCollection genReplaceProOrdEntry(ProductionOrderStockEntryInfo prodsEInfo, int[] keys, HashMap hashMapRepPOE, PlannedOrderInfo plannedOrderInfo, ProductionOrderInfo productionOrderInfo) throws EASBizException, BOSException {
        ProductionOrderStockEntryCollection prosCollreplace = new ProductionOrderStockEntryCollection();
        BigDecimal bigQty = productionOrderInfo.getQty();
        int original = keys[0];
        PlannedOrderEntryInfo originalInfo = (PlannedOrderEntryInfo)hashMapRepPOE.get(new Integer(original));
        BigDecimal bigReleaseQty = plannedOrderInfo.getTotalReleaseQty();
        BigDecimal bigUnitQty = originalInfo.getUnitQty();
        BigDecimal bigT = bigReleaseQty.multiply(bigUnitQty);
        BigDecimal issueQty = bigQty.multiply(bigUnitQty);
        BigDecimal bigZero = new BigDecimal("0.00");
        StorageOrgUnitInfo headOrgInfo = productionOrderInfo.getStorageOrgUnit();
        for (int i = 0; i < keys.length; ++i) {
            int key = keys[i];
            PlannedOrderEntryInfo plannedOrderEntryInfo = (PlannedOrderEntryInfo)hashMapRepPOE.get(new Integer(key));
            BigDecimal bigX = plannedOrderEntryInfo.getOriginalPlanQty();
            ProductionOrderStockEntryInfo proOrderStockEntryInfo = new ProductionOrderStockEntryInfo();
            proOrderStockEntryInfo.setId(BOSUuid.create((BOSObjectType)proOrderStockEntryInfo.getBOSType()));
            proOrderStockEntryInfo.setParent(prodsEInfo.getParent());
            proOrderStockEntryInfo.setLineSeq(plannedOrderEntryInfo.getLineSeq());
            MaterialInfo material = plannedOrderEntryInfo.getMaterial();
            proOrderStockEntryInfo.setMaterial(material);
            MeasureUnitInfo unitInfo = plannedOrderEntryInfo.getUnit();
            proOrderStockEntryInfo.setUnit(unitInfo);
            MeasureUnitInfo baseUnitInfo = plannedOrderEntryInfo.getBaseUnit();
            proOrderStockEntryInfo.setBaseUnit(baseUnitInfo);
            proOrderStockEntryInfo.setConsumeFixQty(plannedOrderEntryInfo.getUnitQty());
            proOrderStockEntryInfo.setBaseConsumeFixQty(plannedOrderEntryInfo.getUnitQty());
            proOrderStockEntryInfo.setConsumeType(prodsEInfo.getConsumeType());
            proOrderStockEntryInfo.setStartDate(prodsEInfo.getStartDate());
            proOrderStockEntryInfo.setEndDate(prodsEInfo.getEndDate());
            proOrderStockEntryInfo.setIsBackFlush(plannedOrderEntryInfo.isBackFlush());
            proOrderStockEntryInfo.setProvideType(plannedOrderEntryInfo.getProvideType());
            proOrderStockEntryInfo.setSupplyOrgUnit(plannedOrderEntryInfo.getStorageOrgUnit());
            proOrderStockEntryInfo.setProportion(bigZero);
            proOrderStockEntryInfo.setIssMode(prodsEInfo.getIssMode());
            proOrderStockEntryInfo.setDefaultWarehouse(plannedOrderEntryInfo.getDefaultWarehouse());
            proOrderStockEntryInfo.setLocation(plannedOrderEntryInfo.getLocation());
            proOrderStockEntryInfo.setIsStock(plannedOrderEntryInfo.isIsStockTransfer());
            proOrderStockEntryInfo.setSendOutTotalQty(bigZero);
            proOrderStockEntryInfo.setBaseSendOutTotalQty(bigZero);
            proOrderStockEntryInfo.setUntreadTotalQty(bigZero);
            proOrderStockEntryInfo.setBaseUntreadTotalQty(bigZero);
            proOrderStockEntryInfo.setTotleReceiveQty(bigZero);
            proOrderStockEntryInfo.setBaseTotleReceiveQty(bigZero);
            proOrderStockEntryInfo.setTotalTransferInQty(bigZero);
            proOrderStockEntryInfo.setTotalTransferInBaseQty(bigZero);
            proOrderStockEntryInfo.setMoveOutStorageOrgUnit(plannedOrderEntryInfo.getTransferOrgUnit());
            proOrderStockEntryInfo.setMoveOutWarehouse(plannedOrderEntryInfo.getTransferWarehouse());
            int persision = plannedOrderEntryInfo.getUnit().getQtyPrecision();
            if (i != 0) {
                proOrderStockEntryInfo.setReplaceFlag(plannedOrderEntryInfo.isIsReplaced());
                proOrderStockEntryInfo.setSubstituteSeq(key);
                int type = plannedOrderEntryInfo.getMatReplaceType().getValue();
                proOrderStockEntryInfo.setSubstituteMode(SubstituteModeEnum.getEnum((int)type));
                IMaterialPlan imatPlan = MaterialPlanFactory.getLocalInstance((Context)this.ctx);
                String orgId = proOrderStockEntryInfo.getSupplyOrgUnit().getId().toString();
                MaterialPlanInfo matPlanInfo = imatPlan.getPlanInfo(material.getId().toString(), orgId);
                proOrderStockEntryInfo.setMaterialInventory(matPlanInfo);
                BigDecimal bigRepUnitQty = plannedOrderEntryInfo.getUnitQty();
                if (bigUnitQty.compareTo(bigZero) > 0) {
                    bigRepUnitQty = bigRepUnitQty.divide(bigUnitQty).setScale(4, 4);
                    proOrderStockEntryInfo.setSubstituteQty(bigRepUnitQty);
                }
            } else {
                proOrderStockEntryInfo.setSubstituteQty(bigZero);
                proOrderStockEntryInfo.setMaterialInventory(prodsEInfo.getMaterialInventory());
            }
            CompanyOrgUnitInfo orgInfo_financial = this.getCompanyOrgByStorageOrg(headOrgInfo.getId().toString());
            StorageOrgUnitInfo moveStorageOrgUnit = proOrderStockEntryInfo.getMoveOutStorageOrgUnit();
            if (orgInfo_financial != null && moveStorageOrgUnit != null) {
                CompanyOrgUnitInfo moveStorageOrgUnit_financial = this.getCompanyOrgByStorageOrg(moveStorageOrgUnit.getId().toString());
                if (moveStorageOrgUnit_financial.equals((Object)orgInfo_financial) && !moveStorageOrgUnit.getId().equals((Object)headOrgInfo.getId())) {
                    proOrderStockEntryInfo.setTransactionType(TransactionTypeEnum.CROSSSTORAGETRANSFER);
                } else if (!moveStorageOrgUnit_financial.equals((Object)orgInfo_financial)) {
                    proOrderStockEntryInfo.setTransactionType(TransactionTypeEnum.CROSSFUNDTRANSFER);
                } else if (moveStorageOrgUnit.getId().equals((Object)headOrgInfo.getId())) {
                    proOrderStockEntryInfo.setTransactionType(TransactionTypeEnum.CROSSWAREHOUSETRANSFER);
                }
            }
            if (bigT.compareTo(bigX) < 0) {
                BigDecimal bigBaseReqQty;
                BigDecimal bigReqQty;
                BigDecimal bigRepelaceOri;
                BigDecimal bigStardQty;
                BigDecimal bigConsumeFixQty = proOrderStockEntryInfo.getConsumeFixQty();
                BigDecimal scrapRate = plannedOrderEntryInfo.getScrapRate();
                if (scrapRate.compareTo(bigZero) != 0) {
                    scrapRate = scrapRate.divide(new BigDecimal(100)).setScale(2, 4);
                }
                if (bigT.add(issueQty).compareTo(bigX) <= 0) {
                    bigStardQty = issueQty;
                    bigRepelaceOri = bigStardQty.add(bigStardQty.multiply(scrapRate)).setScale(persision, 0);
                    proOrderStockEntryInfo.setOrigialQty(bigRepelaceOri);
                    if (i != 0) {
                        bigStardQty = bigStardQty.multiply(proOrderStockEntryInfo.getSubstituteQty()).setScale(persision, 0);
                    }
                    proOrderStockEntryInfo.setStandardQty(bigStardQty);
                    bigReqQty = bigStardQty.add(bigStardQty.multiply(scrapRate)).setScale(persision, 0);
                    proOrderStockEntryInfo.setQty(bigReqQty);
                    bigBaseReqQty = SCMUtils.getExchangePrecisionQtyForServer((Context)this.ctx, (String)material.getId().toString(), (MeasureUnitInfo)unitInfo, (MeasureUnitInfo)baseUnitInfo, (BigDecimal)bigReqQty);
                    proOrderStockEntryInfo.setBaseQty(bigBaseReqQty);
                    prosCollreplace.add(proOrderStockEntryInfo);
                    break;
                }
                bigStardQty = bigX.subtract(bigT);
                bigRepelaceOri = bigStardQty.add(bigStardQty.multiply(scrapRate)).setScale(persision, 0);
                proOrderStockEntryInfo.setOrigialQty(bigRepelaceOri);
                issueQty = issueQty.subtract(bigStardQty);
                if (i != 0) {
                    bigStardQty = bigStardQty.multiply(proOrderStockEntryInfo.getSubstituteQty()).setScale(persision, 0);
                }
                proOrderStockEntryInfo.setStandardQty(bigStardQty);
                bigReqQty = bigStardQty.add(bigStardQty.multiply(scrapRate)).setScale(persision, 0);
                proOrderStockEntryInfo.setQty(bigReqQty);
                bigBaseReqQty = SCMUtils.getExchangePrecisionQtyForServer((Context)this.ctx, (String)material.getId().toString(), (MeasureUnitInfo)unitInfo, (MeasureUnitInfo)baseUnitInfo, (BigDecimal)bigReqQty);
                proOrderStockEntryInfo.setBaseQty(bigBaseReqQty);
                bigT = bigZero;
                proOrderStockEntryInfo.setReplaceFlag(plannedOrderEntryInfo.isIsReplaced());
                prosCollreplace.add(proOrderStockEntryInfo);
                continue;
            }
            proOrderStockEntryInfo.setQty(bigZero);
            proOrderStockEntryInfo.setBaseQty(bigZero);
            proOrderStockEntryInfo.setStandardQty(bigZero);
            proOrderStockEntryInfo.setOrigialQty(bigZero);
            proOrderStockEntryInfo.setProportion(bigZero);
            bigT = bigT.subtract(bigX);
            if (i != 0) continue;
            proOrderStockEntryInfo.setReplaceFlag(plannedOrderEntryInfo.isIsReplaced());
            prosCollreplace.add(proOrderStockEntryInfo);
        }
        return prosCollreplace;
    }

    private CompanyOrgUnitInfo getCompanyOrgByStorageOrg(String storageOrgId) throws BOSException, EASBizException {
        if (storageOrgId == null) {
            return null;
        }
        CompanyOrgUnitInfo ret = null;
        IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getLocalInstance((Context)this.ctx);
        OrgUnitCollection orgCol = iUnitRel.getToUnit(storageOrgId, 4, 1);
        if (orgCol != null && orgCol.size() > 0) {
            ret = (CompanyOrgUnitInfo)orgCol.get(0);
        }
        if (ret == null) {
            String msg = EASResource.getString((String)"com.kingdee.eas.mm.common.MMResource", (String)"CompanyOrtUnit_Is_Null");
            MMBaseException baseException = new MMBaseException(MMBaseException.NULL, new Object[]{msg});
            ExceptionHandler.handle((Throwable)baseException);
        }
        return ret;
    }

    private void setwpLine(ProductionOrderStockEntryCollection prosCollreplace, ProductLineWPEntryInfo productLineWPInfo) {
        if (prosCollreplace == null) {
            return;
        }
        for (int j = 0; j < prosCollreplace.size(); ++j) {
            ProductionOrderStockEntryInfo stockEntryInfo = prosCollreplace.get(j);
            stockEntryInfo.setProductLineWP(productLineWPInfo);
        }
    }
}

