/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.basedata.PLSModelInfo;
import com.kingdee.eas.mm.planning.PLSConstant;
import com.kingdee.eas.mm.planning.PLSEntryCollection;
import com.kingdee.eas.mm.planning.PLSEntryFactory;
import com.kingdee.eas.mm.planning.PLSEntryInfo;
import com.kingdee.eas.mm.planning.RunResult;
import com.kingdee.eas.mm.planning.app.AbstractPLSRunFacadeControllerBean;
import com.kingdee.eas.mm.planning.app.CalcPLSPriorityRunner;
import com.kingdee.eas.mm.planning.app.CapAnalyzeRunner;
import com.kingdee.eas.mm.planning.app.GenPlanTasksRunner;
import com.kingdee.eas.mm.planning.app.PLChooseRunner;
import com.kingdee.eas.mm.planning.app.PLSExpandRunner;
import com.kingdee.eas.mm.planning.app.PLSReleaseRunner;
import com.kingdee.eas.mm.planning.app.PLSUnReleaseRunner;
import com.kingdee.eas.mm.planning.app.SchedulingRunner;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class PLSRunFacadeControllerBean
extends AbstractPLSRunFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.planning.app.PLSRunFacadeControllerBean");

    @Override
    protected RunResult _calcPriority(Context ctx, IObjectValue orgUnitInfo, List list, String voucherId, PLSModelInfo pLSModelInfo) throws BOSException, EASBizException {
        StorageOrgUnitInfo storageOrgUnitInfo = (StorageOrgUnitInfo)orgUnitInfo;
        CalcPLSPriorityRunner pLSRunner = new CalcPLSPriorityRunner(ctx, storageOrgUnitInfo, list, voucherId, pLSModelInfo);
        return pLSRunner.doRunning();
    }

    @Override
    protected RunResult _genProductionOrder(Context ctx, IObjectValue orgUnitInfo, List list, String voucherId, PLSModelInfo pLSModelInfo) throws BOSException, EASBizException {
        StorageOrgUnitInfo storageOrgUnitInfo = (StorageOrgUnitInfo)orgUnitInfo;
        PLSReleaseRunner pLSRunner = new PLSReleaseRunner(ctx, storageOrgUnitInfo, list, voucherId, pLSModelInfo);
        return pLSRunner.doRunning();
    }

    @Override
    protected RunResult _getPlanOrderEntrys(Context ctx, IObjectValue orgUnitInfo, Map map, String voucherId, PLSModelInfo pLSModelInfo) throws BOSException, EASBizException {
        StorageOrgUnitInfo storageOrgUnitInfo = (StorageOrgUnitInfo)orgUnitInfo;
        GenPlanTasksRunner pLSRunner = new GenPlanTasksRunner(ctx, storageOrgUnitInfo, map, voucherId, pLSModelInfo);
        return pLSRunner.doRunning();
    }

    @Override
    protected RunResult _pLChoose(Context ctx, IObjectValue orgUnitInfo, List poList, String voucherId, PLSModelInfo pLSModelInfo) throws BOSException, EASBizException {
        StorageOrgUnitInfo storageOrgUnitInfo = (StorageOrgUnitInfo)orgUnitInfo;
        PLChooseRunner pLSRunner = new PLChooseRunner(ctx, storageOrgUnitInfo, poList, voucherId, pLSModelInfo);
        return pLSRunner.doRunning();
    }

    @Override
    protected RunResult _scheduling(Context ctx, IObjectValue orgUnitInfo, List pLCList, String voucherId, Map proOrderMap, Timestamp beginDate, Timestamp endDate, List pLSList, PLSModelInfo pLSModelInfo) throws BOSException, EASBizException {
        StorageOrgUnitInfo storageOrgUnitInfo = (StorageOrgUnitInfo)orgUnitInfo;
        SchedulingRunner pLSRunner = new SchedulingRunner(ctx, storageOrgUnitInfo, pLCList, voucherId, proOrderMap, beginDate, endDate, pLSList, pLSModelInfo);
        return pLSRunner.doRunning();
    }

    @Override
    protected RunResult _subPlanExpand(Context ctx, IObjectValue orgUnitInfo, List list, String voucherId, Map proOrderMap, Timestamp beginDate, Timestamp endDate, PLSModelInfo pLSModelInfo) throws BOSException, EASBizException {
        StorageOrgUnitInfo storageOrgUnitInfo = (StorageOrgUnitInfo)orgUnitInfo;
        PLSExpandRunner pLSRunner = new PLSExpandRunner(ctx, storageOrgUnitInfo, list, voucherId, proOrderMap, beginDate, endDate, pLSModelInfo);
        return pLSRunner.doRunning();
    }

    @Override
    protected void _auditPLS(Context ctx, Set pks) throws BOSException, EASBizException {
        String logInfo = this.getLogInfo(ctx, pks);
        IObjectPK logPk = LogUtil.beginLog((Context)ctx, (String)"Audit", (BOSObjectType)this.getBOSType(), null, (String)logInfo, (String)"mm_ProductionLineScheduling_auditRow");
        String strIDs = StringUtils.arrayToString((Object[])pks.toArray(), (String)"','");
        StringBuffer auditSql = new StringBuffer();
        auditSql.append("update T_MM_PLSEntry set FBaseStatus = 4, ");
        auditSql.append("FAuditorID = '" + ctx.getCaller().toString() + "', ");
        auditSql.append("FAuditTime = now() ");
        auditSql.append("where FID in ('" + strIDs + "') and FBaseStatus = " + 2);
        DbUtil.execute((Context)ctx, (String)auditSql.toString());
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPk);
    }

    @Override
    protected void _unauditPLS(Context ctx, Set pks) throws BOSException, EASBizException {
        String logInfo = this.getLogInfo(ctx, pks);
        IObjectPK logPk = LogUtil.beginLog((Context)ctx, (String)"Unaudit", (BOSObjectType)this.getBOSType(), null, (String)logInfo, (String)"mm_ProductionLineScheduling_unauditRow");
        String strIDs = StringUtils.arrayToString((Object[])pks.toArray(), (String)"','");
        StringBuffer auditSql = new StringBuffer();
        auditSql.append("update T_MM_PLSEntry set FBaseStatus = 2");
        auditSql.append(", FAuditorID = null, ");
        auditSql.append("FAuditTime = null ");
        auditSql.append(" where FID in ('" + strIDs + "') and FBaseStatus = " + 4);
        DbUtil.execute((Context)ctx, (String)auditSql.toString());
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPk);
    }

    @Override
    protected RunResult _releasePLS(Context ctx, Set pks) throws BOSException, EASBizException {
        StorageOrgUnitInfo storageOrgUnitInfo = null;
        PLSModelInfo plsModelInfo = null;
        String voucherId = null;
        List pLSList = this.getPLSEntrysByIds(ctx, pks);
        String number = null;
        ArrayList<String> lineNums = new ArrayList<String>();
        if (pLSList != null && pLSList.size() > 0) {
            int n = pLSList.size();
            for (int i = 0; i < n; ++i) {
                PLSEntryInfo plsEntryInfo = (PLSEntryInfo)pLSList.get(i);
                if (number == null) {
                    number = plsEntryInfo.getParent().getNumber();
                }
                if (voucherId == null) {
                    voucherId = plsEntryInfo.getParent().getId().toString();
                }
                if (storageOrgUnitInfo == null) {
                    storageOrgUnitInfo = plsEntryInfo.getParent().getStorageOrgUnit();
                }
                if (plsModelInfo == null) {
                    plsModelInfo = plsEntryInfo.getParent().getPLSModel();
                }
                lineNums.add(plsEntryInfo.getLineNum());
            }
        }
        Collections.sort(lineNums, new Comparator(){

            public int compare(Object o1, Object o2) {
                String info1 = (String)o1;
                String info2 = (String)o2;
                return info1.compareTo(info2);
            }
        });
        String logInfo = number + "(" + StringUtils.arrayToString((Object[])lineNums.toArray(), (String)",") + ")";
        IObjectPK logPk = LogUtil.beginLog((Context)ctx, (String)"Release", (BOSObjectType)this.getBOSType(), null, (String)logInfo, (String)"mm_ProductionLineScheduling_releasedRow");
        RunResult runResult = this._genProductionOrder(ctx, (IObjectValue)storageOrgUnitInfo, pLSList, voucherId, plsModelInfo);
        List idList = runResult.getReturnList();
        if (idList != null && idList.size() > 0) {
            String strIDs = StringUtils.arrayToString((Object[])idList.toArray(), (String)"','");
            StringBuffer auditSql = new StringBuffer();
            auditSql.append("update T_MM_PLSEntry set FBaseStatus = 5, ");
            auditSql.append("FReleaseUserID = '" + ctx.getCaller().toString() + "', ");
            auditSql.append("FReleaseTime = now() ");
            auditSql.append("where FID in ('" + strIDs + "')");
            DbUtil.execute((Context)ctx, (String)auditSql.toString());
            LogUtil.afterLog((Context)ctx, (IObjectPK)logPk);
        }
        return runResult;
    }

    protected List getPLSEntrysByIds(Context ctx, Set pks) throws BOSException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)pks, CompareType.INCLUDE));
        entityViewInfo.setFilter(filterInfo);
        entityViewInfo.getSelector().add(new SelectorItemInfo("*"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("parent.*"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("parent.storageOrgUnit.*"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("material.*"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("unit.*"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("baseUnit.*"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("productLine.*"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("parent.pLSModel.*"));
        PLSEntryCollection col = PLSEntryFactory.getLocalInstance(ctx).getPLSEntryCollection(entityViewInfo);
        if (col != null && col.size() > 0) {
            ArrayList<PLSEntryInfo> pLSEntryList = new ArrayList<PLSEntryInfo>();
            int n = col.size();
            for (int i = 0; i < n; ++i) {
                PLSEntryInfo plsEntryInfo = col.get(i);
                pLSEntryList.add(plsEntryInfo);
            }
            return pLSEntryList;
        }
        return null;
    }

    protected String getLogInfo(Context ctx, Set pks) throws BOSException, EASBizException {
        List pLSList = this.getPLSEntrysByIds(ctx, pks);
        String number = null;
        ArrayList<String> lineNums = new ArrayList<String>();
        if (pLSList != null && pLSList.size() > 0) {
            int n = pLSList.size();
            for (int i = 0; i < n; ++i) {
                PLSEntryInfo plsEntryInfo = (PLSEntryInfo)pLSList.get(i);
                if (number == null) {
                    number = plsEntryInfo.getParent().getNumber();
                }
                lineNums.add(plsEntryInfo.getLineNum());
            }
        }
        Collections.sort(lineNums, new Comparator(){

            public int compare(Object o1, Object o2) {
                String info1 = (String)o1;
                String info2 = (String)o2;
                return info1.compareTo(info2);
            }
        });
        return number + "(" + StringUtils.arrayToString((Object[])lineNums.toArray(), (String)",") + ")";
    }

    @Override
    protected List _scheDiffAnalyse(Context ctx, Set idList, String voucherId) throws BOSException {
        ArrayList list = new ArrayList();
        Map pLCData = this.getPLCData(ctx, idList, voucherId);
        if (pLCData != null && pLCData.size() > 0) {
            String strIDs = StringUtils.arrayToString((Object[])idList.toArray(), (String)"','");
            StringBuffer sb = new StringBuffer();
            sb.append("select pls.fmaterialid,sum(pls.fqty) sumQty, sum(porder.fcommittotalqty) as endQty ");
            sb.append("from t_mm_plsentry pls left join t_mm_productionorder porder on pls.fid = porder.fsourcebillentryid ");
            sb.append("where pls.fsourcebillid in ('" + strIDs + "') and pls.fparent <> ?  and pls.fissubplan = 0 ");
            sb.append("group by pls.fmaterialid");
            IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{voucherId});
            try {
                while (rows.next()) {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    String materialId = rows.getString("fmaterialid");
                    BigDecimal sumQty = rows.getBigDecimal("sumQty");
                    BigDecimal endQty = rows.getBigDecimal("endQty");
                    if (endQty == null) {
                        endQty = PLSConstant.ZERO;
                    }
                    map.put("materialId", materialId);
                    map.put("plcQty", pLCData.get(materialId));
                    map.put("plsQty", sumQty);
                    map.put("endQty", endQty);
                    list.add(map);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return list;
    }

    protected Map getPLCData(Context ctx, Set idList, String voucherId) throws BOSException {
        String strIDs = StringUtils.arrayToString((Object[])idList.toArray(), (String)"','");
        StringBuffer sb = new StringBuffer();
        sb.append("select fmaterialid,sum(fqty) as sumQty from t_mm_plchooseentry where fsourcebillid in ('" + strIDs + "') and fparent <> ?  group by fmaterialid");
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{voucherId});
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        try {
            while (rows.next()) {
                String materialId = rows.getString("fmaterialid");
                BigDecimal sumQty = rows.getBigDecimal("sumQty");
                map.put(materialId, sumQty);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return map;
    }

    @Override
    protected RunResult _capAnalyze(Context ctx, IObjectValue orgUnitInfo, Map paraMap, String voucherId, PLSModelInfo pLSModelInfo) throws BOSException, EASBizException {
        StorageOrgUnitInfo storageOrgUnitInfo = (StorageOrgUnitInfo)orgUnitInfo;
        CapAnalyzeRunner pLSRunner = new CapAnalyzeRunner(ctx, storageOrgUnitInfo, paraMap, voucherId, pLSModelInfo);
        return pLSRunner.doRunning();
    }

    @Override
    protected RunResult _unReleasePLS(Context ctx, Set pks, String voucherId) throws BOSException, EASBizException {
        String logInfo = this.getLogInfo(ctx, pks);
        IObjectPK logPk = LogUtil.beginLog((Context)ctx, (String)"UnRelease", (BOSObjectType)this.getBOSType(), null, (String)logInfo, (String)"mm_ProductionLineScheduling_unReleasedRow");
        PLSUnReleaseRunner pLSRunner = new PLSUnReleaseRunner(ctx, pks, voucherId);
        RunResult runResult = pLSRunner.doRunning();
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPk);
        return runResult;
    }
}

