/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.IORMappingDAO;
import com.kingdee.bos.dao.ormapping.ORMappingDAO;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.basedata.PLSModelInfo;
import com.kingdee.eas.mm.planning.PLSExectionMSGInfo;
import com.kingdee.eas.mm.planning.RunResult;
import com.kingdee.eas.mm.planning.app.IPLSRunner;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;

public abstract class PLSRunner
implements IPLSRunner {
    protected Context ctx;
    protected StorageOrgUnitInfo storageOrgUnitInfo;
    protected String voucherID;
    protected String featureNum;
    protected PLSModelInfo lineSchedulingModelInfo;
    protected List exceptions;
    protected List returnList;

    protected void prepareData() throws BOSException, EASBizException {
        this.featureNum = String.valueOf(new Date().getTime()) + "@" + this.ctx.getClientHostIP();
        this.exceptions = new ArrayList();
    }

    @Override
    public RunResult doRunning() throws BOSException, EASBizException {
        this.running();
        this.saveExceptions();
        RunResult runResult = new RunResult();
        runResult.setContext(this.ctx);
        runResult.setReturnList(this.returnList);
        runResult.setExceptions(this.exceptions);
        if (this.exceptions != null && this.exceptions.size() > 0) {
            runResult.setHasException(true);
        } else {
            runResult.setHasException(false);
        }
        return runResult;
    }

    protected abstract void running() throws BOSException, EASBizException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveExceptions() throws EASBizException, BOSException {
        Connection cn = null;
        IORMappingDAO idao = null;
        try {
            cn = EJBFactory.getConnection((Context)this.ctx);
            idao = ORMappingDAO.getInstance((BOSObjectType)BOSObjectType.create((String)"5F2E969A"), (Context)this.ctx, (Connection)cn);
            HashSet<String> set = new HashSet<String>();
            if (this.exceptions != null && this.exceptions.size() > 0) {
                Timestamp date = new Timestamp(new Date().getTime());
                UserInfo userInfo = new UserInfo();
                userInfo.setId(BOSUuid.read((String)this.ctx.getCaller().toString()));
                int n = this.exceptions.size();
                for (int i = 0; i < n; ++i) {
                    PLSExectionMSGInfo exceInfo = (PLSExectionMSGInfo)this.exceptions.get(i);
                    exceInfo.setCreator(userInfo);
                    exceInfo.setCreateTime(date);
                    exceInfo.setLastUpdateUser(userInfo);
                    exceInfo.setLastUpdateTime(date);
                    idao.addNewBatch((IObjectValue)exceInfo);
                    set.add(exceInfo.getDetailInfo());
                }
                idao.executeBatch();
            }
        }
        catch (SQLException sQLException) {
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
    }
}

