/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.common.util.ResourceUtils;
import com.kingdee.eas.mm.common.util.SQLUtil;
import com.kingdee.eas.mm.planning.PLSConstant;
import com.kingdee.eas.mm.planning.PLSExectionMSGInfo;
import com.kingdee.eas.mm.planning.PlannedOrderFactory;
import com.kingdee.eas.mm.planning.app.PLSRunner;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Set;

public class PLSUnReleaseRunner
extends PLSRunner {
    protected Set idList;
    private String[] batchSql;

    public PLSUnReleaseRunner(Context ctx, Set list, String currVoucherID) {
        this.ctx = ctx;
        this.idList = list;
        this.voucherID = currVoucherID;
    }

    @Override
    protected void prepareData() throws BOSException, EASBizException {
        super.prepareData();
        this.deleteNotReleasedIds();
        this.batchSql = new String[6];
    }

    @Override
    protected void running() throws BOSException, EASBizException {
        this.prepareData();
        this.deleteBOTPRelation();
        this.deleteProductionOrder();
        this.updatePLSStatus();
        SQLUtil.batchExecuteSql((Context)this.ctx, (String[])this.batchSql);
        this.writeBackPlannedOrder();
    }

    private void deleteBOTPRelation() throws BOSException, EASBizException {
        StringBuffer tempSql = new StringBuffer();
        tempSql.setLength(0);
        tempSql.append("delete from T_BOT_Relation where FSRCOBJECTID = '").append(this.voucherID).append("' and FDESTOBJECTID in (select FId from T_MM_ProductionOrder where FSourceBillId = '").append(this.voucherID).append("' and FSourceBillEntryId in (").append(SQLUtil.arrayToString((Object[])this.idList.toArray())).append("))");
        this.batchSql[0] = tempSql.toString();
    }

    private void deleteProductionOrder() throws BOSException, EASBizException {
        StringBuffer tempSql = new StringBuffer();
        tempSql.setLength(0);
        tempSql.append("delete from T_MM_ProductionOrderEntry where FParentId in (select FId from T_MM_ProductionOrder where FSourceBillId = '").append(this.voucherID).append("' and FSourceBillEntryId in (").append(SQLUtil.arrayToString((Object[])this.idList.toArray())).append("))");
        this.batchSql[1] = tempSql.toString();
        tempSql.setLength(0);
        tempSql.append("delete from T_MM_ProductionOrderSEntry where FParentId in (select FId from T_MM_ProductionOrder where FSourceBillId = '").append(this.voucherID).append("' and FSourceBillEntryId in (").append(SQLUtil.arrayToString((Object[])this.idList.toArray())).append("))");
        this.batchSql[2] = tempSql.toString();
        tempSql.setLength(0);
        tempSql.append("delete from T_MM_ProductionOrderOEntry where FParentId in (select FId from T_MM_ProductionOrder where FSourceBillId = '").append(this.voucherID).append("' and FSourceBillEntryId in (").append(SQLUtil.arrayToString((Object[])this.idList.toArray())).append("))");
        this.batchSql[3] = tempSql.toString();
        tempSql.setLength(0);
        tempSql.append("delete from T_MM_ProductionOrder where FSourceBillId = '").append(this.voucherID).append("' and FSourceBillEntryId in (").append(SQLUtil.arrayToString((Object[])this.idList.toArray())).append(")");
        this.batchSql[4] = tempSql.toString();
    }

    private void updatePLSStatus() throws BOSException, EASBizException {
        StringBuffer tempSql = new StringBuffer();
        tempSql.setLength(0);
        tempSql.append("update T_MM_PLSEntry set FBaseStatus = 4, ").append("FReleaseUserID = null,FReleaseTime = null").append(" where FID in (").append(SQLUtil.arrayToString((Object[])this.idList.toArray())).append(")");
        this.batchSql[5] = tempSql.toString();
    }

    private void writeBackPlannedOrder() throws BOSException, EASBizException {
        StringBuffer tempSql = new StringBuffer();
        tempSql.setLength(0);
        tempSql.append("select FSourceBillId, FSrcType, FQty from T_MM_PLSEntry where FID in (").append(SQLUtil.arrayToString((Object[])this.idList.toArray())).append(") and FIsSubPlan = 0");
        IRowSet rows = DbUtil.executeQuery((Context)this.ctx, (String)tempSql.toString());
        try {
            HashMap<String, BigDecimal> writeBackMap = new HashMap<String, BigDecimal>();
            while (rows.next()) {
                String sourceBillId = rows.getString("FSourceBillId");
                int sourceType = rows.getInt("FSrcType");
                BigDecimal qty = rows.getBigDecimal("FQty");
                if (sourceBillId == null || qty == null || sourceType != 20) continue;
                if (writeBackMap.containsKey(sourceBillId)) {
                    writeBackMap.put(sourceBillId, ((BigDecimal)writeBackMap.get(sourceBillId)).subtract(qty));
                    continue;
                }
                writeBackMap.put(sourceBillId, qty.multiply(PLSConstant.MINUSONE));
            }
            if (writeBackMap != null && writeBackMap.size() > 0) {
                PlannedOrderFactory.getLocalInstance(this.ctx).batchWriteBackByRelease(writeBackMap);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void deleteNotReleasedIds() throws BOSException {
        StringBuffer tempSql = new StringBuffer();
        tempSql.setLength(0);
        tempSql.append("select FId,FLineNum from T_MM_PLSEntry where FID in (").append(SQLUtil.arrayToString((Object[])this.idList.toArray())).append(") and FBaseStatus <> 5");
        IRowSet rows = DbUtil.executeQuery((Context)this.ctx, (String)tempSql.toString());
        try {
            String lineNum = null;
            String id = null;
            String str_lineNum = null;
            while (rows.next()) {
                lineNum = rows.getString("FLineNum");
                id = rows.getString("FId");
                this.idList.remove(id);
                if (str_lineNum == null) {
                    str_lineNum = lineNum;
                    continue;
                }
                str_lineNum = str_lineNum + "\uff0c" + lineNum;
            }
            if (str_lineNum != null) {
                String exceDesc = ResourceUtils.getMessageForServer((String)"com.kingdee.eas.mm.planning.SchedulingExceptionResource", (String)"OTHEREXCEPTION_DESC");
                int exceNum = 199;
                String exceDetail = ResourceUtils.getMessageForServer((String)"com.kingdee.eas.mm.planning.SchedulingExceptionResource", (String)"NOTRELEASEDSTATUS_DEDAIL", (String[])new String[]{str_lineNum});
                PLSExectionMSGInfo exceInfo = new PLSExectionMSGInfo(exceNum, exceDesc, exceDetail, this.voucherID);
                this.exceptions.add(exceInfo);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }
}

