/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.cssp.app.DataImportUtils;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialAttributeEnum;
import com.kingdee.eas.basedata.master.material.MaterialBaseException;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitCollection;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.PerminsionUtil;
import com.kingdee.eas.basedata.master.material.app.DataImportTools;
import com.kingdee.eas.basedata.org.StorageOrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mm.basedata.BomCollection;
import com.kingdee.eas.mm.basedata.BomFactory;
import com.kingdee.eas.mm.basedata.BomInfo;
import com.kingdee.eas.mm.basedata.PlanVersionSetCollection;
import com.kingdee.eas.mm.basedata.PlanVersionSetFactory;
import com.kingdee.eas.mm.basedata.PlanVersionSetInfo;
import com.kingdee.eas.mm.planning.PlannedOrderFactory;
import com.kingdee.eas.mm.planning.PlannedOrderInfo;
import com.kingdee.eas.mm.planning.PlannedOrderTypeEnum;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.enums.Enum;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;

public class PlanOrderImpExp
extends AbstractDataTransmission {
    Map scheme = new HashMap();
    Map material = new HashMap();
    Map cachePerson = new HashMap();

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return PlannedOrderFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        try {
            return this.innerTransmit(hsData, ctx);
        }
        catch (TaskExternalException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    private CoreBaseInfo innerTransmit(Hashtable hsData, Context ctx) throws TaskExternalException, Exception {
        Object data = ((DataToken)hsData.get((Object)"FStorageOrgUnitID")).data;
        if (data == null) {
            throw new TaskExternalException(DataImportUtils.getResource((String)"com.kingdee.eas.basedata.master.material.MaterialAddResource", (String)"GetInventoryOrgUnitFailed", (Context)ctx));
        }
        StorageOrgUnitInfo storageOrgUnit = this.getOrgByNumber(ctx, data.toString());
        if (storageOrgUnit == null) {
            storageOrgUnit = ContextUtil.getCurrentStorageUnit((Context)ctx);
        }
        if (storageOrgUnit == null) {
            throw new TaskExternalException(DataImportUtils.getResource((String)"com.kingdee.eas.basedata.master.material.MaterialAddResource", (String)"GetInventoryOrgUnitFailed", (Context)ctx));
        }
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        if (!PerminsionUtil.isUserBizOrgRange((Context)ctx, (String)userId, (String)storageOrgUnit.getId().toString())) {
            throw new TaskExternalException(new MaterialBaseException(MaterialBaseException.OUT_BIZ_ORG, new Object[]{storageOrgUnit.getName()}).getMessage());
        }
        PlannedOrderInfo info = new PlannedOrderInfo();
        this.handleInfo(hsData, ctx, info);
        return info;
    }

    private void handleInfo(Hashtable hsData, Context ctx, PlannedOrderInfo info) throws TaskExternalException {
        MaterialInfo matInfo = null;
        BigDecimal bigRate = new BigDecimal("0.00");
        try {
            info.setNumber(DataImportTools.getDataString((Hashtable)hsData, (String)"FNumber"));
            info.setStorageOrgUnit(this.getOrgByNumber(ctx, DataImportTools.getDataString((Hashtable)hsData, (String)"FStorageOrgUnitID")));
            matInfo = this.getMaterialByNumber(ctx, DataImportTools.getDataString((Hashtable)hsData, (String)"FMaterial_Number"));
            info.setMaterial(matInfo);
            info.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
            info.setOrderType(this.getOrderTypeEnum(ctx, this.getDataString(hsData, "FOrderType")));
            info.setOrderMatLock(DataImportTools.getDataboolean((Hashtable)hsData, (String)"FOrdMatLock"));
            MultiMeasureUnitInfo multiUnitInfo = this.getMultiMeasureUnitInfo(ctx, DataImportTools.getDataString((Hashtable)hsData, (String)"FUnit_Number"), matInfo.getId().toString());
            MeasureUnitInfo measureUnitInfo = DataImportTools.getMultiMeasureUnitInfo((Context)ctx, (String)DataImportTools.getDataString((Hashtable)hsData, (String)"FUnit_Number"), (String)matInfo.getId().toString());
            info.setUnit(matInfo.getBaseUnit());
            info.setProductUnit(multiUnitInfo.getMeasureUnit());
            bigRate = multiUnitInfo.isIsBasicUnit() ? new BigDecimal("1.00") : multiUnitInfo.getBaseConvsRate();
            info.setQty(DataImportTools.getDataBigDecimal((Hashtable)hsData, (String)"FQty"));
            info.setScheduleQty(new BigDecimal("0.00"));
            info.setTotalReleaseQty(new BigDecimal("0.00"));
            info.setBaseQty(info.getQty().multiply(bigRate));
            info.setBaseScheduleQty(new BigDecimal("0.00"));
            info.setBaseTotalReleaseQty(new BigDecimal("0.00"));
            info.setProductionOrgUnit(this.getOrgByNumber(ctx, DataImportTools.getDataString((Hashtable)hsData, (String)"FSupplyStorageOrg_Number")));
            info.setPlanner(this.getPersonByNumber(ctx, DataImportTools.getDataString((Hashtable)hsData, (String)"FPlanner_Number")));
            info.setStartDate(DataImportTools.getDataDate((Hashtable)hsData, (String)"FStartDate"));
            info.setEndDate(DataImportTools.getDataDate((Hashtable)hsData, (String)"FEndDate"));
            info.setBom(this.getBomInfo(ctx, DataImportTools.getDataString((Hashtable)hsData, (String)"FBomNumber")));
            info.setNumber(this.getNewNumber(ctx, info.getStorageOrgUnit().getId().toString(), info));
            String number = DataImportTools.getDataString((Hashtable)hsData, (String)"FSchemeID");
            info.setScheme(this.getSchemeByNumber(ctx, number));
            info.setAvilableDate(DataImportTools.getDataDate((Hashtable)hsData, (String)"FAvilableDate"));
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    public String getNewNumber(Context ctx, String bizOrgUnitID, PlannedOrderInfo info) throws CodingRuleException, EASBizException, BOSException {
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        return iCodingRuleManager.getNumber((IObjectValue)info, bizOrgUnitID);
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable result = new Hashtable();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            String sDate = null;
            String eDate = null;
            String aDate = null;
            sDate = rs.getDate("startDate") == null ? "" : sdf.format(rs.getDate("startDate"));
            eDate = rs.getDate("endDate") == null ? "" : sdf.format(rs.getDate("endDate"));
            aDate = rs.getDate("avilableDate") == null ? "" : sdf.format(rs.getDate("avilableDate"));
            this.putTable(result, "FNumber", rs.getString("number"));
            this.putTable(result, "FStorageOrgUnitID", rs.getString("storageOrgUnit.number"));
            this.putTable(result, "FMaterial_Number", rs.getString("material.number"));
            this.putTable(result, "FMaterial_Name", rs.getString("material.name"));
            this.putTable(result, "FMaterial_Model", rs.getString("material.model"));
            this.putTable(result, "FOrderType", PlannedOrderTypeEnum.getEnum(rs.getInt("orderType")).getAlias());
            this.putTable(result, "FBaseStatus", BillBaseStatusEnum.getEnum((int)rs.getInt("baseStatus")));
            this.putTable(result, "FOrdMatLock", rs.getBoolean("orderMatLock"));
            this.putTable(result, "FQty", rs.getBigDecimal("qty"));
            this.putTable(result, "FScheduleQty", rs.getBigDecimal("scheduleQty"));
            this.putTable(result, "FTotalReleaseQty", rs.getBigDecimal("totalReleaseQty"));
            this.putTable(result, "FUnit_Number", rs.getString("productUnit.number"));
            this.putTable(result, "FUnit_Name", rs.getString("productUnit.name"));
            this.putTable(result, "FSupplyStorageOrg_Number", rs.getString("productionOrgUnit.number"));
            this.putTable(result, "FSupplyStorageOrg_Name", rs.getString("productionOrgUnit.name"));
            this.putTable(result, "FPlanner_Number", rs.getString("planner.number"));
            this.putTable(result, "FPlanner_Name", rs.getString("planner.name"));
            this.putTable(result, "FStartDate", sDate);
            this.putTable(result, "FEndDate", eDate);
            this.putTable(result, "FBomNumber", rs.getString("bomNumber"));
            this.putTable(result, "FCalcID", rs.getString("calcID.number"));
            this.putTable(result, "FAvilableDate", aDate);
            this.putTable(result, "FCreator", rs.getString("creator.name"));
            this.putTable(result, "FCreateTime", rs.getString("createTime"));
            this.putTable(result, "FSchemeID", rs.getString("scheme.number"));
            this.putTable(result, "FMaterialAttribute", MaterialAttributeEnum.getEnum((int)rs.getInt("materialPlan.materialAttr")).getAlias());
            this.putTable(result, "FLastUpdateTime", rs.getString("lastUpdateTime"));
            this.putTable(result, "FLastUpdateUser", rs.getString("lastUpdateUser.name"));
            this.putTable(result, "FAuditTime", rs.getString("auditTime"));
            this.putTable(result, "FAuditor", rs.getString("auditor.name"));
        }
        catch (Exception e) {
            throw new TaskExternalException("", (Throwable)e);
        }
        return result;
    }

    private void putTable(Hashtable htable, Object key, Object value) {
        DataImportTools.putToHashtable((Hashtable)htable, (Object)key, (Object)value);
    }

    private String getDataString(Hashtable hsData, String fieldName) {
        return DataImportTools.getDataString((Hashtable)hsData, (String)fieldName);
    }

    private BigDecimal getDataBigDecimal(Hashtable hsData, String fieldName) {
        return DataImportTools.getDataBigDecimal((Hashtable)hsData, (String)fieldName);
    }

    private PlanVersionSetInfo getSchemeByNumber(Context ctx, String number) throws TaskExternalException, BOSException {
        if (number == null || "".equals(number)) {
            return null;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("Number", (Object)number, CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        PlanVersionSetCollection coll = PlanVersionSetFactory.getLocalInstance((Context)ctx).getPlanVersionSetCollection(viewInfo);
        PlanVersionSetInfo info = coll.get(0);
        return info;
    }

    private StorageOrgUnitInfo getOrgByNumber(Context ctx, String number) throws TaskExternalException, BOSException {
        if (number == null || "".equals(number)) {
            return null;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("Number", (Object)number, CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        StorageOrgUnitCollection coll = StorageOrgUnitFactory.getLocalInstance((Context)ctx).getStorageOrgUnitCollection(viewInfo);
        StorageOrgUnitInfo info = coll.get(0);
        return info;
    }

    private MaterialInfo getMaterialByNumber(Context ctx, String number) throws TaskExternalException {
        if (number == null || "".equals(number)) {
            return null;
        }
        Object result = this.material.get(number);
        if (result == null) {
            result = DataImportTools.getMaterialInfo((Context)ctx, (String)number);
            this.material.put(number, result);
        }
        return (MaterialInfo)result;
    }

    private BomInfo getBomInfo(Context ctx, String value) throws BOSException {
        if (value.equals("")) {
            return null;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("Number", (Object)value, CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        BomCollection bomColl = BomFactory.getLocalInstance((Context)ctx).getBomCollection(viewInfo);
        BomInfo bomInfo = bomColl.get(0);
        return bomInfo;
    }

    private PlannedOrderTypeEnum getOrderTypeEnum(Context ctx, String value) {
        if (value == null || "".equals(value)) {
            return null;
        }
        if (PlanOrderImpExp.EnumEqualByAlias(value, (Enum)PlannedOrderTypeEnum.FABRICATED)) {
            return PlannedOrderTypeEnum.FABRICATED;
        }
        if (PlanOrderImpExp.EnumEqualByAlias(value, (Enum)PlannedOrderTypeEnum.PURCHASE)) {
            return PlannedOrderTypeEnum.PURCHASE;
        }
        if (PlanOrderImpExp.EnumEqualByAlias(value, (Enum)PlannedOrderTypeEnum.STOCKTRANSFER)) {
            return PlannedOrderTypeEnum.STOCKTRANSFER;
        }
        return null;
    }

    private PersonInfo getPersonByNumber(Context ctx, String number) throws TaskExternalException {
        if (number == null || "".equals(number)) {
            return null;
        }
        Object result = this.cachePerson.get(number);
        if (result == null) {
            result = DataImportTools.getPersonInfo((Context)ctx, (String)number);
            this.cachePerson.put(number, result);
        }
        return (PersonInfo)result;
    }

    private MultiMeasureUnitInfo getMultiMeasureUnitInfo(Context ctx, String number, String materialId) throws TaskExternalException {
        MultiMeasureUnitCollection unitCollection;
        if (number == null || "".equals(number)) {
            return null;
        }
        FilterInfo filter = new FilterInfo();
        DataImportTools.AddFilterItemInfo((FilterInfo)filter, (String)"convsUnit.number", (Object)number);
        DataImportTools.AddFilterItemInfo((FilterInfo)filter, (String)"material.id", (Object)materialId);
        filter.setMaskString("#0 and #1");
        try {
            IMultiMeasureUnit iUnit = MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
            EntityViewInfo ev = DataImportTools.getViewInfo((FilterInfo)filter);
            ev.getSelector().add(new SelectorItemInfo("baseConvsRate"));
            unitCollection = iUnit.getMultiMeasureUnitCollection(ev);
            if (unitCollection == null || unitCollection.size() <= 0) {
                filter.getFilterItems().clear();
                DataImportTools.AddFilterItemInfo((FilterInfo)filter, (String)"measureUnit.number", (Object)number);
                DataImportTools.AddFilterItemInfo((FilterInfo)filter, (String)"material.id", (Object)materialId);
                filter.setMaskString("#0 and #1");
                iUnit = MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
                ev = DataImportTools.getViewInfo((FilterInfo)filter);
                ev.getSelector().add(new SelectorItemInfo("baseConvsRate"));
                unitCollection = iUnit.getMultiMeasureUnitCollection(ev);
                if (unitCollection == null || unitCollection.size() <= 0) {
                    throw new TaskExternalException(DataImportTools.getResString((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"DataImport_MeasureUnit_Error", (Locale)ctx.getLocale()));
                }
            }
        }
        catch (BOSException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
        return unitCollection.get(0);
    }

    public static boolean EnumEqualByAlias(String value, Enum enumValue) {
        return value.equals(enumValue.getAlias());
    }
}

