/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.batchaction.ActionResult;
import com.kingdee.eas.framework.batchaction.ActionResultEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.mm.common.MMCommonException;
import com.kingdee.eas.mm.planning.PlannedOrderCollection;
import com.kingdee.eas.mm.planning.PlannedOrderFactory;
import com.kingdee.eas.mm.planning.PlannedOrderInfo;
import com.kingdee.eas.mm.planning.PlannedOrderNewMappingFacadeFactory;
import com.kingdee.eas.mm.planning.app.AbstractPlannedOrderFacadeControllerBean;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class PlannedOrderFacadeControllerBean
extends AbstractPlannedOrderFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.planning.app.PlannedOrderFacadeControllerBean");

    private PlannedOrderCollection getTransferPlannedOrder(Context ctx, String mrpRunLogId) throws EASBizException, BOSException {
        StringBuffer oql = new StringBuffer();
        oql.append("SELECT ").append("id, ").append("startDate, ").append("endDate, ").append("number, ").append("qty, ").append("baseQty, ").append("totalReleaseQty, ").append("baseTotalReleaseQty, ").append("baseStatus, ").append("sourceType, ").append("storageOrgUnit.id, ").append("productionOrgUnit.id, ").append("material.id, ").append("material.name, ").append("material.number, ").append("material.materialGroup.id, ").append("material.materialGroup.name, ").append("material.assistUnit.id, ").append("material.baseUnit.id, ").append("productUnit.id, ").append("unit.id, ").append("bizType.id, ").append("scheme.id, ").append("scheme.number, ").append("planner.id ").append(" where ").append(" calcID='").append(mrpRunLogId).append("' and ").append(" orderType=").append(30).append(" and isCanNotRelease = 0");
        PlannedOrderCollection collection = PlannedOrderFactory.getLocalInstance(ctx).getPlannedOrderCollection(oql.toString());
        PlannedOrderCollection result = new PlannedOrderCollection();
        for (int i = 0; i < collection.size(); ++i) {
            PlannedOrderInfo info = collection.get(i);
            if (info.getStorageOrgUnit() == null || info.getProductionOrgUnit() == null || info.getStorageOrgUnit().getId().toString().equals(info.getProductionOrgUnit().getId().toString())) continue;
            result.add(info);
        }
        return result;
    }

    @Override
    protected void _releaseStockTransfer(Context ctx, String mrpRunLogId) throws BOSException, EASBizException {
        PlannedOrderCollection collection = this.getTransferPlannedOrder(ctx, mrpRunLogId);
        if (collection.size() <= 0) {
            return;
        }
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[collection.size()];
        BatchExecuteParamsEntry entry = null;
        PlannedOrderInfo info = null;
        for (int i = 0; i < collection.size(); ++i) {
            info = collection.get(i);
            entry = new BatchExecuteParamsEntry(new Class[]{IObjectPK.class});
            entry.add((Object)new ObjectUuidPK(info.getId()));
            entries[i] = entry;
        }
        BatchActionResults results = PlannedOrderFactory.getLocalInstance(ctx).batchAudit(entries);
        List idList = results.getToDoIdsList();
        if (idList == null || idList.size() <= 0) {
            String errorMsg = this.getBatchResult(collection, results);
            throw new MMCommonException(MMCommonException.BLANK, (Object[])new String[]{errorMsg});
        }
        ArrayList<String> ids = null;
        for (int i = 0; i < idList.size(); ++i) {
            if (ids == null) {
                ids = new ArrayList<String>();
            }
            ids.add(idList.get(i).toString());
        }
        Map map = PlannedOrderNewMappingFacadeFactory.getLocalInstance(ctx).mapping(ids);
        if (map != null && !map.isEmpty()) {
            Iterator it = map.keySet().iterator();
            String poNumber = null;
            String cause = null;
            StringBuffer value = new StringBuffer();
            while (it.hasNext()) {
                poNumber = (String)it.next();
                cause = poNumber + map.get(poNumber).toString();
                if (value.length() + cause.length() >= 765) continue;
                value.append(cause).append("\r\n");
            }
            throw new MMCommonException(MMCommonException.BLANK, (Object[])new String[]{value.toString()});
        }
    }

    private String getBatchResult(PlannedOrderCollection col, BatchActionResults results) {
        StringBuffer msg = new StringBuffer();
        PlannedOrderInfo poInfo = null;
        ActionResult result = null;
        for (int i = 0; i < col.size(); ++i) {
            poInfo = col.get(i);
            result = results.getActionResult((Object)poInfo.getId().toString());
            if (result.getMessage() == null || result.getResult().equals((Object)ActionResultEnum.SUCCESS) || msg.length() + result.getMessage().length() >= 765) continue;
            msg.append(poInfo.getNumber()).append(" ").append(result.getMessage()).append("\n");
        }
        return msg.toString();
    }
}

