/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.util.DBUtil;
import com.kingdee.eas.mm.common.app.MMLogger;
import com.kingdee.eas.mm.common.app.SQLUtils;
import com.kingdee.eas.mm.common.util.SQLUtil;
import com.kingdee.eas.mm.planning.IPlannedOrder;
import com.kingdee.eas.mm.planning.PlannedOrderCollection;
import com.kingdee.eas.mm.planning.PlannedOrderEntryCollection;
import com.kingdee.eas.mm.planning.PlannedOrderEntryInfo;
import com.kingdee.eas.mm.planning.PlannedOrderFactory;
import com.kingdee.eas.mm.planning.PlannedOrderInfo;
import com.kingdee.eas.mm.planning.app.AbstractPlannedOrderNewMappingFacadeControllerBean;
import com.kingdee.eas.mm.planning.app.mrp.MRPCalendarFactory;
import com.kingdee.eas.mm.planning.app.release.PlanOrderRelease;
import com.kingdee.eas.scm.util.app.db.KsqlUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class PlannedOrderNewMappingFacadeControllerBean
extends AbstractPlannedOrderNewMappingFacadeControllerBean {
    private static final long serialVersionUID = -7987130903843223084L;
    protected static final Logger logger = MMLogger.getLogger();

    private ArrayList getbillIdlist(Map[] models) {
        ArrayList list = new ArrayList();
        for (int i = 0; i < models.length; ++i) {
            Map tempMap = models[i];
            list.add(tempMap.get("id"));
        }
        return list;
    }

    @Override
    protected Map _mapping(Context ctx, Map[] map) throws BOSException, EASBizException {
        HashMap maperror = new HashMap();
        ArrayList ids = this.getbillIdlist(map);
        IPlannedOrder iplannedorder = PlannedOrderFactory.getLocalInstance(ctx);
        HashSet idset = new HashSet();
        for (int i = 0; i < ids.size(); ++i) {
            idset.add(ids.get(i));
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idset, CompareType.INCLUDE));
        viewInfo.setSelector(this.getPlanOderSelectorForRelease());
        viewInfo.setFilter(filter);
        PlannedOrderCollection plannedorders = iplannedorder.getPlannedOrderCollection(viewInfo);
        PlannedOrderCollection planOrderWithSequence = new PlannedOrderCollection();
        PlannedOrderInfo plan = null;
        String planid = null;
        String key = null;
        Map temp = null;
        for (int j = 0; j < map.length; ++j) {
            temp = map[j];
            for (int k = 0; k < plannedorders.size(); ++k) {
                plan = plannedorders.get(k);
                planid = plan.getId().toString();
                key = (String)temp.get("id");
                if (key.equals(planid)) break;
            }
            if (temp == null) continue;
            this.setPlanOrderBeforeRelease(ctx, plan, temp);
            temp = null;
            planOrderWithSequence.add(plan);
        }
        return this.commMaping(ctx, maperror, ids, planOrderWithSequence);
    }

    private void setPlanOrderBeforeRelease(Context ctx, PlannedOrderInfo poInfo, Map releaseInfo) throws BOSException {
        Calendar startDate = this.getCalendar(poInfo.getStartDate());
        Calendar newStartDate = this.getCalendar((Date)releaseInfo.get("startDate"));
        if (newStartDate.compareTo(startDate) != 0) {
            MRPCalendarFactory calendarFactory = new MRPCalendarFactory(ctx, poInfo.getStorageOrgUnit().getId().toString());
            long timeInterval = newStartDate.getTimeInMillis() - startDate.getTimeInMillis();
            int dayInterval = (int)timeInterval / 86400000;
            PlannedOrderEntryCollection poEntries = poInfo.getEntries();
            PlannedOrderEntryInfo entry = null;
            Calendar reqDate = null;
            Calendar reqWorkDate = null;
            for (int i = 0; i < poEntries.size(); ++i) {
                entry = poEntries.get(i);
                reqDate = this.getCalendar(entry.getReqDate());
                reqDate.add(6, dayInterval);
                reqWorkDate = calendarFactory.getDate(reqDate.getTime(), false).getDate();
                entry.setReqDate(reqWorkDate.getTime());
            }
        }
        poInfo.put("thisTotalReleaseQty", releaseInfo.get("releaseQty"));
        poInfo.put("thisTotalReleaseBaseQty", releaseInfo.get("baseReleaseQty"));
        poInfo.put("thisisClose", releaseInfo.get("isClose"));
        poInfo.setStartDate((Date)releaseInfo.get("startDate"));
        poInfo.setEndDate((Date)releaseInfo.get("endDate"));
        poInfo.put("productLine", releaseInfo.get("productLine"));
    }

    private Calendar getCalendar(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar;
    }

    @Override
    protected Map _mapping(Context ctx, List ids) throws BOSException, EASBizException {
        long time0 = System.currentTimeMillis();
        HashMap map = new HashMap();
        IPlannedOrder iplannedorder = PlannedOrderFactory.getLocalInstance(ctx);
        HashSet idset = new HashSet();
        for (int i = 0; i < ids.size(); ++i) {
            idset.add(ids.get(i));
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idset, CompareType.INCLUDE));
        viewInfo.setSelector(this.getPlanOderSelectorForRelease());
        viewInfo.setFilter(filter);
        PlannedOrderCollection plannedorders = iplannedorder.getPlannedOrderCollection(viewInfo);
        long time1 = System.currentTimeMillis();
        logger.error((Object)("#############\u83b7\u53d6\u8ba1\u5212\u8ba2\u5355\u96c6\u5408\uff1a" + (time1 - time0)));
        HashMap<String, PlannedOrderInfo> planMap = new HashMap<String, PlannedOrderInfo>();
        PlannedOrderInfo planOrderInfo = null;
        int size = plannedorders.size();
        for (int k = 0; k < size; ++k) {
            planOrderInfo = plannedorders.get(k);
            planMap.put(planOrderInfo.getId().toString(), planOrderInfo);
        }
        PlannedOrderCollection planOrderWithSequence = new PlannedOrderCollection();
        for (int j = 0; j < ids.size(); ++j) {
            planOrderInfo = (PlannedOrderInfo)planMap.get(ids.get(j).toString());
            if (planOrderInfo == null) continue;
            planOrderWithSequence.add(planOrderInfo);
        }
        long time2 = System.currentTimeMillis();
        logger.error((Object)("#############\u8ba1\u5212\u8ba2\u5355\u6392\u5e8f\uff1a" + (time2 - time1)));
        return this.commMaping(ctx, map, ids, planOrderWithSequence);
    }

    private Map commMaping(Context ctx, Map map, List ids, PlannedOrderCollection plannedorders) throws BOSException, EASBizException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("poCollection", (Object)plannedorders);
        paramMap.put("errorMap", map);
        paramMap.put("plannedOrderIdList", ids);
        String idSql = this.batchExecuteSql(ctx, ids.toArray(new String[ids.size()]));
        String temp = null;
        String Sql = null;
        if (idSql.contains("null")) {
            Sql = idSql;
        } else {
            Sql = "select FBillID from " + idSql;
            temp = idSql;
        }
        paramMap.put("temp_id", Sql);
        paramMap.put("temp", temp);
        PlanOrderRelease release = new PlanOrderRelease(ctx);
        Map rst = null;
        try {
            rst = (Map)release.doing(paramMap);
        }
        catch (Exception e) {
            throw new BOSException("sql Execute Error :", (Throwable)e);
        }
        finally {
            if (null != paramMap.get("temp")) {
                KsqlUtil.releaseTempTable((Context)ctx, (String)((String)paramMap.get("temp")));
            }
        }
        return rst;
    }

    private String batchExecuteSql(Context ctx, String[] ids) throws BOSException {
        if (ids.length <= 20) {
            return SQLUtil.arrayToString((Object[])ids);
        }
        StringBuffer createSql = new StringBuffer();
        String tempTableName = null;
        createSql.append("create table temptable ( FBillID varchar(44) ); ");
        tempTableName = KsqlUtil.createTempTableWithNewTx((Context)ctx, (String)createSql.toString());
        String[] insertSqls = new String[ids.length];
        StringBuffer insertSql = new StringBuffer();
        for (String BillId : ids) {
            insertSql.append(" insert into ").append(tempTableName).append("(FBillID) values ('").append(BillId).append("');");
            insertSqls[i] = insertSql.toString();
            insertSql.setLength(0);
        }
        DBUtil.executeBatch((Context)ctx, (String[])insertSqls);
        return tempTableName;
    }

    protected Map _getCouOrgUnit(Context ctx, String[] orgUnitID) throws BOSException, EASBizException {
        IRowSet rs = null;
        StringBuffer sql = new StringBuffer();
        HashMap<String, String> map = new HashMap<String, String>();
        if (orgUnitID == null || orgUnitID.length == 0) {
            return map;
        }
        sql.append("select orgRe.FFromUnitID ,orgRe.FTOUnitID from T_ORG_UnitRelation orgRe where orgRe.FFromUnitID in (");
        for (int i = 0; i < orgUnitID.length; ++i) {
            sql.append("'");
            sql.append(orgUnitID[i]);
            if (i != orgUnitID.length - 1) {
                sql.append("' , ");
                continue;
            }
            sql.append("' )");
        }
        sql.append("  and orgRe.ftyperelationid='");
        sql.append("00000000-0000-0000-0000-0000000000070FE9F8B5");
        sql.append("'  ");
        try {
            rs = SQLUtils.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                map.put(rs.getString(1), rs.getString(2));
            }
        }
        catch (SQLException e) {
            throw new BOSException();
        }
        return map;
    }

    protected SelectorItemCollection getPlanOderSelectorForRelease() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("scheme.*"));
        sic.add(new SelectorItemInfo("material.Number"));
        sic.add(new SelectorItemInfo("material.Name"));
        sic.add(new SelectorItemInfo("material.id"));
        sic.add(new SelectorItemInfo("unit.id"));
        sic.add(new SelectorItemInfo("unit.Number"));
        sic.add(new SelectorItemInfo("unit.Name"));
        sic.add(new SelectorItemInfo("productUnit.id"));
        sic.add(new SelectorItemInfo("productUnit.Number"));
        sic.add(new SelectorItemInfo("productUnit.Name"));
        sic.add(new SelectorItemInfo("storageOrgUnit.Number"));
        sic.add(new SelectorItemInfo("storageOrgUnit.Name"));
        sic.add(new SelectorItemInfo("storageOrgUnit.id"));
        sic.add(new SelectorItemInfo("productionOrgUnit.Number"));
        sic.add(new SelectorItemInfo("productionOrgUnit.Name"));
        sic.add(new SelectorItemInfo("productionOrgUnit.id"));
        sic.add(new SelectorItemInfo("entries.*"));
        return sic;
    }
}

