/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.EASClientException;
import com.kingdee.eas.mm.planning.IPlanningParam;
import com.kingdee.eas.mm.planning.IPlanningParamValue;
import com.kingdee.eas.mm.planning.PlanOrderException;
import com.kingdee.eas.mm.planning.PlannedOrderReleaseEnum;
import com.kingdee.eas.mm.planning.PlannedOrderTypeEnum;
import com.kingdee.eas.mm.planning.PlanningParamCollection;
import com.kingdee.eas.mm.planning.PlanningParamFactory;
import com.kingdee.eas.mm.planning.PlanningParamInfo;
import com.kingdee.eas.mm.planning.PlanningParamValueCollection;
import com.kingdee.eas.mm.planning.PlanningParamValueFactory;
import com.kingdee.eas.mm.planning.PlanningParamValueInfo;
import com.kingdee.eas.mm.planning.app.AbstractPlanningParamControllerBean;
import com.kingdee.eas.scm.cal.util.DBUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class PlanningParamControllerBean
extends AbstractPlanningParamControllerBean {
    Locale locale1 = LocaleUtils.getLocale((String)"l1");
    Locale locale2 = LocaleUtils.getLocale((String)"l2");
    Locale locale3 = LocaleUtils.getLocale((String)"l3");
    private static final long serialVersionUID = -8280159506040772246L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.planning.app.PlanningParamControllerBean");
    private static String sParent = null;
    private static int iGetParamTimes = 0;

    @Override
    protected IObjectCollection _getParameters(Context ctx, String ParamName, IObjectPK StorageOrgUnit) throws BOSException, EASBizException {
        IPlanningParamValue iParamValue = PlanningParamValueFactory.getLocalInstance(ctx);
        PlanningParamValueCollection collParamValue = null;
        Object paramValueInfo = null;
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("parent.number", (Object)ParamName, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)StorageOrgUnit.toString(), CompareType.EQUALS));
        EntityViewInfo viewParam = new EntityViewInfo();
        viewParam.setFilter(filterInfo);
        collParamValue = iParamValue.getPlanningParamValueCollection(viewParam);
        if (collParamValue == null || collParamValue.size() < 1) {
            this.initParameters(ctx, ParamName, StorageOrgUnit);
            collParamValue = iParamValue.getPlanningParamValueCollection(viewParam);
        }
        return collParamValue;
    }

    private void initParameters(Context ctx, String ParamName, IObjectPK StorageOrgUnit) throws BOSException {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("Number", ParamName);
        paramMap.put("OrgUnit", StorageOrgUnit.toString());
        try {
            this.initPlanningParameters(ctx, paramMap);
            this.initParameterValue(ctx, sParent, StorageOrgUnit.toString());
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initParameterValue(Context ctx, String parentid, String storageorgUnitPK) throws EASClientException, BOSException {
        String sql = null;
        IPlanningParamValue iPlanningPV = PlanningParamValueFactory.getLocalInstance(ctx);
        PlanningParamValueCollection collPV = null;
        PlanningParamValueInfo pvInfo = null;
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("parent.id", (Object)parentid, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)storageorgUnitPK, CompareType.EQUALS));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filterInfo);
        collPV = iPlanningPV.getPlanningParamValueCollection(view);
        if (collPV != null && collPV.size() >= 1) {
            pvInfo = collPV.get(0);
            return;
        }
        sql = "insert into T_MM_PlanningParamValue(FID,FParentID,FOrgType,FOrgUnitID,FNumber,FDescription_l1,FDescription_l2,FDescription_l3,FParamValue)values(?,?,?,?,?,?,?,?,?);";
        Connection conn = null;
        PreparedStatement stmt = null;
        String bosType = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            stmt = conn.prepareStatement(sql);
            for (int i = 0; i < 3; ++i) {
                bosType = new PlanningParamValueInfo().getBOSType().toString();
                stmt.setString(1, BOSUuid.create((String)bosType).toString());
                stmt.setString(2, sParent);
                stmt.setInt(3, 4);
                stmt.setString(4, storageorgUnitPK);
                switch (i) {
                    case 0: {
                        stmt.setString(5, PlannedOrderReleaseEnum.PLANNEDORDER_RELEASE_FABRICATEDPART.getValue());
                        stmt.setString(6, PlannedOrderReleaseEnum.PLANNEDORDER_RELEASE_FABRICATEDPART.getAlias(this.locale1));
                        stmt.setString(7, PlannedOrderReleaseEnum.PLANNEDORDER_RELEASE_FABRICATEDPART.getAlias(this.locale2));
                        stmt.setString(8, PlannedOrderReleaseEnum.PLANNEDORDER_RELEASE_FABRICATEDPART.getAlias(this.locale3));
                        stmt.setString(9, "4");
                        break;
                    }
                    case 1: {
                        stmt.setString(5, PlannedOrderReleaseEnum.PLANNEDORDER_RELEASE_PURCHASEDPART.getValue());
                        stmt.setString(6, PlannedOrderReleaseEnum.PLANNEDORDER_RELEASE_PURCHASEDPART.getAlias(this.locale1));
                        stmt.setString(7, PlannedOrderReleaseEnum.PLANNEDORDER_RELEASE_PURCHASEDPART.getAlias(this.locale2));
                        stmt.setString(8, PlannedOrderReleaseEnum.PLANNEDORDER_RELEASE_PURCHASEDPART.getAlias(this.locale3));
                        stmt.setString(9, "2");
                        break;
                    }
                    case 2: {
                        stmt.setString(5, PlannedOrderReleaseEnum.PLANNEDORDER_RELEASE_EXTERNALPROCESSINPART.getValue());
                        stmt.setString(6, PlannedOrderReleaseEnum.PLANNEDORDER_RELEASE_EXTERNALPROCESSINPART.getAlias(this.locale1));
                        stmt.setString(7, PlannedOrderReleaseEnum.PLANNEDORDER_RELEASE_EXTERNALPROCESSINPART.getAlias(this.locale2));
                        stmt.setString(8, PlannedOrderReleaseEnum.PLANNEDORDER_RELEASE_EXTERNALPROCESSINPART.getAlias(this.locale3));
                        stmt.setString(9, "1");
                        break;
                    }
                }
                stmt.addBatch();
            }
            stmt.executeBatch();
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
    }

    protected void initPlanningParameters(Context ctx, Map paramMap) throws BOSException, EASBizException {
        String number = (String)paramMap.get("Number");
        boolean isExist = false;
        IPlanningParam isp = PlanningParamFactory.getLocalInstance(ctx);
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(fi);
        PlanningParamCollection paramColl = isp.getPlanningParamCollection(view);
        isExist = isp.exists(fi);
        String sql = null;
        sql = isExist ? "Update T_MM_PlanningParam set FLastUpdateTime=?,FLastUpdateUserID=? where FNumber=?" : "insert into T_MM_PlanningParam (FID,FControlUnitID,FLastUpdateTime,FLastUpdateUserID,FCreateTime,FCreatorID,FsimpleName,FDescription_l1,FDescription_l2,FDescription_l3,FNumber,FName)values(?,?,CONVERT(DATETIME,null),?,?,?,?,?,?,?,?,?);";
        UserInfo user = (UserInfo)ctx.get((Object)"UserInfo");
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            stmt = conn.prepareStatement(sql);
            String bosType = new PlanningParamInfo().getBOSType().toString();
            String CU = "11111111-1111-1111-1111-111111111111CCE7AED4";
            if (isExist) {
                sParent = paramColl.get(0).getId().toString();
                stmt.setTimestamp(1, new Timestamp(new Date().getTime()));
                stmt.setString(2, user.getId().toString());
                stmt.setString(3, number);
            } else {
                sParent = BOSUuid.create((String)bosType).toString();
                stmt.setString(1, sParent);
                stmt.setString(2, CU);
                stmt.setString(3, null);
                stmt.setTimestamp(4, new Timestamp(new Date().getTime()));
                stmt.setString(5, user.getId().toString());
                stmt.setString(6, "");
                stmt.setString(7, "");
                stmt.setString(8, "");
                stmt.setString(9, "");
                stmt.setString(10, number);
                stmt.setString(11, "");
            }
            stmt.addBatch();
            stmt.executeBatch();
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
    }

    @Override
    protected void _saveParameters(Context ctx, IObjectCollection model) throws BOSException, EASBizException {
        PlanningParamValueCollection pvColl = (PlanningParamValueCollection)model;
        String sql = null;
        String sqlvalue = null;
        sql = "Update T_MM_PlanningParam set FLastUpdateTime=?,FLastUpdateUserID=? where FID=?;";
        sqlvalue = "Update T_MM_PlanningParamValue set FParamValue=? where FID=? and FNumber=?;";
        UserInfo user = (UserInfo)ctx.get((Object)"UserInfo");
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            stmt = conn.prepareStatement(sql);
            stmt.setTimestamp(1, new Timestamp(new Date().getTime()));
            stmt.setString(2, user.getId().toString());
            stmt.setString(3, pvColl.get(0).getParent().getId().toString());
            stmt.addBatch();
            stmt.executeBatch();
            stmt = conn.prepareStatement(sqlvalue);
            for (int i = 0; i < pvColl.size(); ++i) {
                stmt.setString(1, pvColl.get(i).getParamValue());
                stmt.setString(2, pvColl.get(i).getId().toString());
                stmt.setString(3, pvColl.get(i).getNumber());
                stmt.addBatch();
            }
            stmt.executeBatch();
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
    }

    @Override
    protected boolean _checkReleaseParam(Context ctx, String storageOrgUnitID, int materialAttr, int targetOrderType) throws BOSException, PlanOrderException {
        int iParamValue = 0;
        String sBinParamValue = "";
        boolean bResult = false;
        String sMaterialAttr = "";
        switch (materialAttr) {
            case 10030: {
                sMaterialAttr = "PLANNEDORDER_RELEASE_FABRICATEDPART";
                break;
            }
            case 10040: {
                sMaterialAttr = "PLANNEDORDER_RELEASE_PURCHASEDPART";
                break;
            }
            case 10050: {
                sMaterialAttr = "PLANNEDORDER_RELEASE_EXTERNALPROCESSINPART";
            }
        }
        String sql = "select t1.FParamValue from T_MM_PlanningParamValue t1 Inner join T_MM_PlanningParam t2 on t1.FParentID=t2.FID where t1.FOrgUnitID='" + storageOrgUnitID + "' and t1.FNumber='" + sMaterialAttr + "' and t2.FNumber='PLANNEDORDER_RELEASE_SETS'";
        try {
            IRowSet rowSet = DBUtil.executeQuery((Context)ctx, (String)sql);
            rowSet.next();
            iParamValue = Integer.parseInt(rowSet.getString("FParamValue"));
        }
        catch (Exception ex) {
            throw new PlanOrderException(PlanOrderException.PARAMCHECKINIT_EXCEPTION);
        }
        sBinParamValue = Integer.toBinaryString(iParamValue);
        while (sBinParamValue.length() < 3) {
            sBinParamValue = "0" + sBinParamValue;
        }
        if (PlannedOrderTypeEnum.getEnum(targetOrderType) == PlannedOrderTypeEnum.FABRICATED) {
            iParamValue = sBinParamValue.charAt(0);
            if ((char)iParamValue == '1') {
                bResult = true;
            }
        } else if (PlannedOrderTypeEnum.getEnum(targetOrderType) == PlannedOrderTypeEnum.PURCHASE) {
            iParamValue = sBinParamValue.charAt(1);
            if ((char)iParamValue == '1') {
                bResult = true;
            }
        } else if (PlannedOrderTypeEnum.getEnum(targetOrderType) == PlannedOrderTypeEnum.STOCKTRANSFER) {
            iParamValue = sBinParamValue.charAt(2);
            if ((char)iParamValue == '1') {
                bResult = true;
            }
        } else {
            bResult = false;
        }
        return bResult;
    }
}

