/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.DataLimitExceedException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.JDBCExceptionHandler;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.bp.BPOption;
import com.kingdee.bos.framework.bp.DynamicBackground;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexLockType;
import com.kingdee.eas.base.netctrl.MutexParameter;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.mm.basedata.ITrackNumber;
import com.kingdee.eas.mm.basedata.TrackNumberCollection;
import com.kingdee.eas.mm.basedata.TrackNumberFactory;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.common.app.SQLUtils;
import com.kingdee.eas.mm.common.util.MMUtils;
import com.kingdee.eas.mm.common.util.ResourceManage;
import com.kingdee.eas.mm.common.util.SQLUtil;
import com.kingdee.eas.mm.planning.IReqPlanExceptionRecord;
import com.kingdee.eas.mm.planning.ReqCntactException;
import com.kingdee.eas.mm.planning.ReqPlanException;
import com.kingdee.eas.mm.planning.ReqPlanExceptionRecordFactory;
import com.kingdee.eas.mm.planning.ReqPlanExceptionRecordInfo;
import com.kingdee.eas.mm.planning.ReqPlanExceptionTypeEnum;
import com.kingdee.eas.mm.planning.ReqPlanInsertExtendFacadeFactory;
import com.kingdee.eas.mm.planning.ReqPlanManulWriteOffDataVO;
import com.kingdee.eas.mm.planning.ReqPlanWriteOffFacadeFactory;
import com.kingdee.eas.mm.planning.RequirementPlanInfo;
import com.kingdee.eas.mm.planning.app.AbstractReqPlanWriteOffFacadeControllerBean;
import com.kingdee.eas.mm.planning.app.ReqPlanUpdateDataVO;
import com.kingdee.eas.mm.planning.app.reqplan.ReqPlanAllRunner;
import com.kingdee.eas.mm.planning.app.reqplan.ReqPlanForSubmitRunner;
import com.kingdee.eas.mm.planning.app.reqplan.ReqplanUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class ReqPlanWriteOffFacadeControllerBean
extends AbstractReqPlanWriteOffFacadeControllerBean {
    private static final long serialVersionUID = -8089383003428909650L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.planning.app.ReqPlanWriteOffFacadeControllerBean");
    private static final Format dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private static final Format dateFormat2 = new SimpleDateFormat("yyyy-MM-dd HH:MM:SSSS");
    private static final String REQPLAN_RESOURCE_PATH = "com.kingdee.eas.mm.planning.ReqPlanResource";
    private static final int CON_WRITEOFFPID = 1;
    private static final int CON_WRITEOFFPIO = 3;
    private static String MM_REQPLAN_CNT_MUTEXLOCK = "MM_ReqPlan_Cnt_MutexLock";

    @Override
    protected void _immdiateCounteract(Context ctx, List orgIDList) throws BOSException, EASBizException {
        BPOption bpOption = new BPOption();
        bpOption.setImmediately(true);
        DynamicBackground bd = new DynamicBackground(ctx);
        bd.invokeBackound(this.getBOSType(), "counteract", new Class[]{List.class}, new Object[]{orgIDList}, bpOption);
    }

    @Override
    protected void _counteract(Context ctx, List orgIDList) throws BOSException, EASBizException {
        StringBuffer str = new StringBuffer();
        str.append(" select  fStorageOrgUnitID  from T_MM_ReqPlanData ");
        if (orgIDList != null && orgIDList.size() > 0) {
            str.append(" where fStorageOrgUnitID in (").append(MMUtils.listToString((List)orgIDList)).append(")");
        } else {
            str.append(" where fStorageOrgUnitID is not null ");
        }
        str.append(" group by fStorageOrgUnitID having count(*) >500");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)str.toString());
        BPOption bpOption = new BPOption();
        bpOption.setImmediately(true);
        DynamicBackground bd = new DynamicBackground(ctx);
        try {
            while (rs.next()) {
                String orgId = rs.getString("fStorageOrgUnitID");
                IMutexServiceControl mutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
                boolean isSucceed = false;
                boolean isSucceedMRP = mutex.requestObjIDForUpdate(orgId + "reqPlanForMRP", ctx.getCaller().toString(), Uuid.create());
                if (isSucceedMRP) {
                    isSucceed = ReqplanUtils.checkMutex(ctx, orgId);
                }
                if (isSucceed) {
                    logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"78_ReqPlanWriteOffFacadeControllerBean", (Locale)ctx.getLocale()));
                    bd.invokeBackound(this.getBOSType(), "cntactAndCollect", new Class[]{String.class, Boolean.TYPE}, new Object[]{orgId, Boolean.TRUE}, bpOption);
                    continue;
                }
                logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"79_ReqPlanWriteOffFacadeControllerBean", (Locale)ctx.getLocale()));
                this.writeExceptionLocal(ctx, orgId, ReqPlanExceptionTypeEnum.ALARM, "", ResourceManage.getResource((String)REQPLAN_RESOURCE_PATH, (String)"EXCEPTION_MUTEX", (Locale)ctx.getLocale()), "");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private boolean checkHasData(Context ctx, String storageId) throws BOSException, EASBizException {
        boolean hasReqPlanData = false;
        String sql = "select top 1 fid from T_MM_ReqPlanData where fStorageOrgUnitID = ?";
        IRowSet rs = SQLUtils.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{storageId});
        if (rs != null && rs.size() > 0) {
            hasReqPlanData = true;
        }
        return hasReqPlanData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _cntactAndCollect(Context ctx, String storageOrgUnitID, boolean isAsynchronous) throws BOSException, EASBizException {
        boolean isSucceedMRP = false;
        boolean isSucceed = false;
        if (!isAsynchronous) {
            boolean hasReqPlanData = this.checkHasData(ctx, storageOrgUnitID);
            if (!hasReqPlanData) {
                return;
            }
            IMutexServiceControl mutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
            isSucceedMRP = mutex.requestObjIDForUpdate(storageOrgUnitID + "reqPlanForMRP", ctx.getCaller().toString(), Uuid.create());
            if (isSucceedMRP) {
                logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"80_ReqPlanWriteOffFacadeControllerBean", (Locale)ctx.getLocale()));
                isSucceed = ReqplanUtils.checkMutex(ctx, storageOrgUnitID);
            }
            if (!isSucceed) {
                logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"81_ReqPlanWriteOffFacadeControllerBean", (Locale)ctx.getLocale()));
                this.writeExceptionLocal(ctx, storageOrgUnitID, ReqPlanExceptionTypeEnum.ALARM, "", ResourceManage.getResource((String)REQPLAN_RESOURCE_PATH, (String)"EXCEPTION_MUTEX", (Locale)ctx.getLocale()), "");
                return;
            }
        }
        try {
            this.cntactAndCollect(ctx, storageOrgUnitID);
        }
        finally {
            IMutexServiceControl mutex2 = MutexServiceControlFactory.getLocalInstance((Context)ctx);
            mutex2.releaseObjIDForUpdate(storageOrgUnitID + "reqPlan");
        }
    }

    protected void cntactAndCollect(Context ctx, String storageOrgUnitID) throws BOSException, EASBizException {
        ReqPlanAllRunner runner = new ReqPlanAllRunner(ctx);
        runner.run(ctx, storageOrgUnitID);
    }

    private void rubricWriteOffReq(Context ctx, ReqPlanUpdateDataVO dataVO) throws BOSException, EASBizException {
        Connection conn = null;
        Statement batchStatement = null;
        String billTypeID = dataVO.getBillTypeID();
        String billID = dataVO.getBillID();
        String billNum = dataVO.getBillNumber();
        String billEntryID = dataVO.getBillEntryID();
        String unitID = dataVO.getUnitID();
        String baseUnitID = dataVO.getBaseUnitID();
        BigDecimal qty = dataVO.getQty();
        BigDecimal baseQty = dataVO.getBaseQty();
        String materialId = dataVO.getMaterialID();
        String srcOfSourceBillID = dataVO.getSrcBillID();
        String srcOfSourceEntryID = dataVO.getSrcBillEntryID();
        qty = qty.abs();
        baseQty = baseQty.abs();
        String sql_getCntRelation = "SELECT FID,FDestID,(FQty-fRubricQty) as fQty,(FBaseQty-fRubricBaseQty) as FBaseQty,FSeq  FROM  T_MM_ReqCounteractRelation  WHERE FSourceID = ? and FSourceEntryID = ?  and (FQty-fRubricQty)>0  ORDER BY FSeq DESC";
        IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sql_getCntRelation, (Object[])new Object[]{srcOfSourceBillID, srcOfSourceEntryID});
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            batchStatement = conn.createStatement();
            StringBuffer sql_uptReqplan = new StringBuffer();
            int seq = 1;
            while (row.next()) {
                Object[] params;
                StringBuffer updateSql;
                String destID = row.getString("FDestID");
                BigDecimal cntactQty = row.getBigDecimal("FQty");
                BigDecimal cntactBaseQty = row.getBigDecimal("FBaseQty");
                String id = row.getString("fID");
                StringBuffer sql_recordWriteOffRelation = new StringBuffer();
                sql_recordWriteOffRelation.append("insert into T_MM_ReqCounteractRelation");
                sql_recordWriteOffRelation.append("(FID,FSourceID,FSourceEntryID,FDestID,FBillTypeID,FQty,FBaseQty,FUnitID,FBaseUnitID,FSeq,FSourceNumber,FmaterialId)");
                sql_recordWriteOffRelation.append(" values(?,?,?,?,?,?,?,?,?,?,?,?)");
                if (qty.compareTo(cntactQty) >= 0) {
                    sql_uptReqplan.setLength(0);
                    sql_uptReqplan.append("update T_MM_Requirementplan set fCntactTotalQty = fCntactTotalQty - ");
                    sql_uptReqplan.append(cntactQty);
                    sql_uptReqplan.append(",fBaseCntactTotalQty = fBaseCntactTotalQty - ");
                    sql_uptReqplan.append(cntactBaseQty);
                    sql_uptReqplan.append(",fStatus = case when(fQty - fCntactTotalQty + ");
                    sql_uptReqplan.append(cntactQty);
                    sql_uptReqplan.append(")>0 then ");
                    sql_uptReqplan.append(10);
                    sql_uptReqplan.append(" else ");
                    sql_uptReqplan.append(20);
                    sql_uptReqplan.append(" end");
                    sql_uptReqplan.append(" where fID = '" + destID + "'");
                    batchStatement.addBatch(sql_uptReqplan.toString());
                    updateSql = new StringBuffer();
                    updateSql.append("update T_MM_ReqCounteractRelation set fRubricQty = fqty,fRubricBaseQty = fbaseqty ");
                    updateSql.append(" where fid = '").append(id).append("'");
                    DbUtil.execute((Context)ctx, (String)updateSql.toString());
                    params = new Object[]{BOSUuid.create((String)"D02F7535").toString(), billID, billEntryID, row.getString("FDestID"), billTypeID, cntactQty.negate(), cntactBaseQty.negate(), unitID, baseUnitID, new Integer(seq++), billNum, materialId};
                    DbUtil.execute((Context)ctx, (String)sql_recordWriteOffRelation.toString(), (Object[])params);
                    qty = qty.subtract(cntactQty);
                    baseQty = baseQty.subtract(cntactBaseQty);
                    continue;
                }
                sql_uptReqplan.setLength(0);
                sql_uptReqplan.append("update T_MM_RequirementPlan set fCntactTotalQty = fCntactTotalQty - ");
                sql_uptReqplan.append(qty);
                sql_uptReqplan.append(",fBaseCntactTotalQty = fBaseCntactTotalQty - ");
                sql_uptReqplan.append(baseQty);
                sql_uptReqplan.append(",fStatus = case when(fQty - fCntactTotalQty + ");
                sql_uptReqplan.append(qty);
                sql_uptReqplan.append(")>0 then ");
                sql_uptReqplan.append(10);
                sql_uptReqplan.append(" else ");
                sql_uptReqplan.append(20);
                sql_uptReqplan.append(" end");
                sql_uptReqplan.append(" where fID = '" + destID + "'");
                batchStatement.addBatch(sql_uptReqplan.toString());
                updateSql = new StringBuffer();
                updateSql.append("update T_MM_ReqCounteractRelation set fRubricQty = fRubricQty+?,fRubricBaseQty = fRubricBaseQty+? ");
                updateSql.append(" where fid = '").append(id).append("'");
                DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{qty, baseQty});
                params = new Object[]{BOSUuid.create((String)"D02F7535").toString(), billID, billEntryID, row.getString("FDestID"), billTypeID, qty.negate(), baseQty.negate(), unitID, baseUnitID, new Integer(seq++), billNum, materialId};
                DbUtil.execute((Context)ctx, (String)sql_recordWriteOffRelation.toString(), (Object[])params);
                break;
            }
            batchStatement.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                com.kingdee.util.db.SQLUtils.cleanup(batchStatement, (Connection)conn);
                throw throwable;
            }
        }
        com.kingdee.util.db.SQLUtils.cleanup((Statement)batchStatement, (Connection)conn);
    }

    @Override
    protected void _collectReq(Context ctx, String[] storageOrgUnitIDs) throws BOSException, EASBizException {
        Connection conn = null;
        Statement batchStatement = null;
        String suFilter = "";
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            batchStatement = conn.createStatement();
            StringBuffer sql_delReqCollect = new StringBuffer();
            sql_delReqCollect.append("delete from T_MM_RequirementCollect ");
            if (storageOrgUnitIDs.length > 0) {
                String suIDs = StringUtils.arrayToString((Object[])storageOrgUnitIDs, (String)"','");
                suIDs = "'" + suIDs + "'";
                suFilter = " and fStorageOrgUnitID in(" + suIDs + ")";
                sql_delReqCollect.append(" where 1 = 1 ").append(suFilter);
            }
            batchStatement.addBatch(sql_delReqCollect.toString());
            String sql_insert = "insert into T_MM_RequirementCollect(fID,fStorageOrgUnitID,fMaterialID,FMANUSTRATEGYID,fUnitID,fBaseUnitID,fQty,fBaseQty,fReqDate,fprojectid,ftracknumberid,fPlanResource)";
            String sql_select = " select newbosid('1D1143DC'),fStorageOrgUnitID,fMaterialID,FMANUSTRATEGYID,fUnitID,fBaseUnitID";
            String sql_from = "select fStorageOrgUnitID,fMaterialID,FMANUSTRATEGYID,fUnitID,fBaseUnitID,fQty,fBaseQty,fCntactTotalQty,fBaseCntactTotalQty,TO_DATE(SUBSTRING(TO_CHAR(fRequireDate, 'YYYY-MM-DD'),1,10) || ' 00:00:00') as fRequireDate, fprojectid, ftracknumberid from t_mm_requirementplan";
            String sql_selectPre = sql_select + ",sum(fQty),sum(fBaseQty),fRequireDate,fprojectid,ftracknumberid";
            String sql_selectAft = sql_select + ",sum(case when fQty < fCntactTotalQty then 0 else (fQty-fCntactTotalQty) end ),sum(case when fBaseQty < fBaseCntactTotalQty then 0 else (fBaseQty-fBaseCntactTotalQty) end ),fRequireDate,fprojectid,ftracknumberid";
            String sql_where = " where fStatus =  10" + suFilter;
            String sql_groupby = " group by fStorageOrgUnitID,fMaterialID,FMANUSTRATEGYID,fUnitID,fBaseUnitID,fRequireDate,fprojectid,ftracknumberid";
            StringBuffer sql_insertReq = new StringBuffer();
            sql_insertReq.append(sql_insert).append(sql_selectPre).append(",");
            sql_insertReq.append(30).append(" from (").append(sql_from);
            sql_insertReq.append(sql_where).append(" and fReqTypeID = '");
            sql_insertReq.append("NcvxPgEcEADgAAiqwKgL09hs+cg=') as a").append(sql_groupby);
            batchStatement.addBatch(sql_insertReq.toString());
            sql_insertReq.setLength(0);
            sql_insertReq.append(sql_insert).append(sql_selectAft).append(",");
            sql_insertReq.append(40).append(" from (").append(sql_from);
            sql_insertReq.append(sql_where).append(" and fReqTypeID = '");
            sql_insertReq.append("NcvxPgEcEADgAAiqwKgL09hs+cg=') as a").append(sql_groupby);
            batchStatement.addBatch(sql_insertReq.toString());
            sql_insertReq.setLength(0);
            sql_insertReq.append(sql_insert).append(sql_selectPre).append(",");
            sql_insertReq.append(50).append(" from (").append(sql_from);
            sql_insertReq.append(sql_where).append(" and fReqTypeID = '");
            sql_insertReq.append("NcvxPgEcEADgAAiowKgL09hs+cg=') as a").append(sql_groupby);
            batchStatement.addBatch(sql_insertReq.toString());
            sql_insertReq.setLength(0);
            sql_insertReq.append(sql_insert).append(sql_selectAft).append(",");
            sql_insertReq.append(60).append(" from (").append(sql_from);
            sql_insertReq.append(sql_where).append(" and fReqTypeID = '");
            sql_insertReq.append("NcvxPgEcEADgAAiowKgL09hs+cg=') as a").append(sql_groupby);
            batchStatement.addBatch(sql_insertReq.toString());
            sql_insertReq.setLength(0);
            sql_insertReq.append(sql_insert).append(sql_selectPre).append(",");
            sql_insertReq.append(62).append(" from (").append(sql_from);
            sql_insertReq.append(sql_where).append(" and fReqTypeID = '");
            sql_insertReq.append("s0fDJAEoEADgAABCfwAAAdhs+cg=') as a").append(sql_groupby);
            batchStatement.addBatch(sql_insertReq.toString());
            sql_insertReq.setLength(0);
            sql_insertReq.append(sql_insert).append(sql_selectAft).append(",");
            sql_insertReq.append(64).append(" from (").append(sql_from);
            sql_insertReq.append(sql_where).append(" and fReqTypeID = '");
            sql_insertReq.append("s0fDJAEoEADgAABCfwAAAdhs+cg=') as a").append(sql_groupby);
            batchStatement.addBatch(sql_insertReq.toString());
            sql_insertReq.setLength(0);
            sql_insertReq.append(sql_insert).append(sql_selectPre).append(",");
            sql_insertReq.append(10).append(" from (").append(sql_from);
            sql_insertReq.append(sql_where).append(" and fReqTypeID = '");
            sql_insertReq.append("NcvxPgEcEADgAAiswKgL09hs+cg=') as a").append(sql_groupby);
            batchStatement.addBatch(sql_insertReq.toString());
            sql_insertReq.setLength(0);
            sql_insertReq.append(sql_insert).append(sql_selectAft).append(",");
            sql_insertReq.append(20).append(" from (").append(sql_from);
            sql_insertReq.append(sql_where).append(" and fReqTypeID = '");
            sql_insertReq.append("NcvxPgEcEADgAAiswKgL09hs+cg=') as a").append(sql_groupby);
            batchStatement.addBatch(sql_insertReq.toString());
            sql_insertReq.setLength(0);
            sql_insertReq.append(sql_insert).append(sql_selectPre).append(",");
            sql_insertReq.append(90).append(" from (").append(sql_from);
            sql_insertReq.append(sql_where).append(" and fReqTypeID = '");
            sql_insertReq.append("NcvxPgEcEADgAAiwwKgL09hs+cg=') as a").append(sql_groupby);
            batchStatement.addBatch(sql_insertReq.toString());
            sql_insertReq.setLength(0);
            sql_insertReq.append(sql_insert).append(sql_selectAft).append(",");
            sql_insertReq.append(100).append(" from (").append(sql_from);
            sql_insertReq.append(sql_where).append(" and fReqTypeID = '");
            sql_insertReq.append("NcvxPgEcEADgAAiwwKgL09hs+cg=') as a").append(sql_groupby);
            batchStatement.addBatch(sql_insertReq.toString());
            sql_insertReq.setLength(0);
            sql_insertReq.append(sql_insert).append(sql_selectPre).append(",");
            sql_insertReq.append(101).append(" from (").append(sql_from);
            sql_insertReq.append(sql_where).append(" and fReqTypeID = '");
            sql_insertReq.append("NcvxPgEcEADgAAiuwKgL09hs+cg=') as a").append(sql_groupby);
            batchStatement.addBatch(sql_insertReq.toString());
            sql_insertReq.setLength(0);
            sql_insertReq.append(sql_insert).append(sql_selectAft).append(",");
            sql_insertReq.append(102).append(" from (").append(sql_from);
            sql_insertReq.append(sql_where).append(" and fReqTypeID = '");
            sql_insertReq.append("NcvxPgEcEADgAAiuwKgL09hs+cg=') as a").append(sql_groupby);
            batchStatement.addBatch(sql_insertReq.toString());
            sql_insertReq.setLength(0);
            sql_insertReq.append(sql_insert).append(sql_selectPre).append(",");
            sql_insertReq.append(103).append(" from (").append(sql_from);
            sql_insertReq.append(sql_where).append(" and fReqTypeID = '");
            sql_insertReq.append("sdRQaQEoEADgAAvafwAAAdhs+cg=') as a").append(sql_groupby);
            batchStatement.addBatch(sql_insertReq.toString());
            sql_insertReq.setLength(0);
            sql_insertReq.append(sql_insert).append(sql_selectAft).append(",");
            sql_insertReq.append(104).append(" from (").append(sql_from);
            sql_insertReq.append(sql_where).append(" and fReqTypeID = '");
            sql_insertReq.append("sdRQaQEoEADgAAvafwAAAdhs+cg=') as a").append(sql_groupby);
            batchStatement.addBatch(sql_insertReq.toString());
            sql_insertReq.setLength(0);
            sql_insertReq.append(sql_insert).append(sql_selectPre).append(",");
            sql_insertReq.append(105).append(" from (").append(sql_from);
            sql_insertReq.append(sql_where).append(" and fReqTypeID = '");
            sql_insertReq.append("LIggukxnQ0eNvHc34XGmuNhs+cg=') as a").append(sql_groupby);
            batchStatement.addBatch(sql_insertReq.toString());
            sql_insertReq.setLength(0);
            sql_insertReq.append(sql_insert).append(sql_selectAft).append(",");
            sql_insertReq.append(106).append(" from (").append(sql_from);
            sql_insertReq.append(sql_where).append(" and fReqTypeID = '");
            sql_insertReq.append("LIggukxnQ0eNvHc34XGmuNhs+cg=') as a").append(sql_groupby);
            batchStatement.addBatch(sql_insertReq.toString());
            StringBuffer sql_inserttotal = new StringBuffer();
            sql_inserttotal.append("insert into T_MM_RequirementCollect");
            sql_inserttotal.append("(fID,fStorageOrgUnitID,fMaterialID,FMANUSTRATEGYID,fUnitID,fBaseUnitID,");
            sql_inserttotal.append("fQty,fBaseQty,fReqDate,fprojectid,ftracknumberid,fPlanResource)");
            sql_inserttotal.append(" select newbosid('1D1143DC'),fStorageOrgUnitID,fMaterialID,FMANUSTRATEGYID,fUnitID,fBaseUnitID,");
            sql_inserttotal.append("sum(fQty),sum(fBaseQty),");
            sql_inserttotal.append("fReqDate,fprojectid,ftracknumberid,");
            sql_inserttotal.append(110);
            sql_inserttotal.append(" from T_MM_RequirementCollect where 1 = 1 ");
            sql_inserttotal.append(suFilter);
            sql_inserttotal.append(" and fPlanResource in( ");
            sql_inserttotal.append(40).append(",");
            sql_inserttotal.append(60).append(",");
            sql_inserttotal.append(20).append(",");
            sql_inserttotal.append(100).append(",");
            sql_inserttotal.append(102).append(",");
            sql_inserttotal.append(104).append(",");
            sql_inserttotal.append(64).append(",");
            sql_inserttotal.append(106).append("");
            sql_inserttotal.append(" )");
            sql_inserttotal.append(" group by fStorageOrgUnitID,fMaterialID,FMANUSTRATEGYID,fUnitID,fBaseUnitID,fReqDate,fprojectid,ftracknumberid");
            batchStatement.addBatch(sql_inserttotal.toString());
            logger.info((Object)("#############before" + System.currentTimeMillis()));
            batchStatement.executeBatch();
            logger.info((Object)("#############after" + System.currentTimeMillis()));
        }
        catch (SQLException e) {
            try {
                Exception e1 = JDBCExceptionHandler.convertException((SQLException)e);
                if (e1 instanceof DataLimitExceedException) {
                    throw new DataLimitExceedException((Throwable)e1);
                }
                throw new BOSException((Throwable)e1);
            }
            catch (Throwable throwable) {
                com.kingdee.util.db.SQLUtils.cleanup(batchStatement, (Connection)conn);
                throw throwable;
            }
        }
        com.kingdee.util.db.SQLUtils.cleanup((Statement)batchStatement, (Connection)conn);
    }

    @Override
    protected void _cntactAndCollectAll(Context ctx, boolean ignoreFailedMutex) throws BOSException, EASBizException {
        ReqPlanWriteOffFacadeFactory.getLocalInstance(ctx).cntactAndCollect(null, ignoreFailedMutex);
    }

    private List getStorageOrgUnitsFromReqPlanTmp(Context ctx) throws BOSException {
        String sql = "SELECT DISTINCT fStorageOrgUnitID from T_MM_ReqPlanData";
        IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sql);
        ArrayList<String> storageOrgUnits = new ArrayList<String>();
        try {
            while (null != row && row.next()) {
                storageOrgUnits.add(row.getString("fStorageOrgUnitID"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            com.kingdee.util.db.SQLUtils.cleanup((ResultSet)row);
        }
        return storageOrgUnits;
    }

    private void dealBoforre(Context ctx, String storageOrgUnitID) throws BOSException, EASBizException {
        String[] sqls = new String[6];
        StringBuffer str = new StringBuffer();
        str.setLength(0);
        str.append(" delete from T_MM_ReqPlanData where fid in (select fid  from T_MM_ReqPlanData as t1 ");
        str.append(" inner join (select fSourceEntryID,FcreateTime from T_MM_ReqPlanData where FOPERATIONTYPE in( ").append(109);
        str.append(" ,").append(801);
        str.append(" ) and fstorageOrgUnitID = '").append(storageOrgUnitID).append("'");
        str.append(")");
        str.append(" as t2 on t1.fSourceEntryID = t2.fSourceEntryID");
        str.append("  where  t1.FcreateTime <t2.FcreateTime and t1.FOPERATIONTYPE in (").append(103);
        str.append(" ,").append(701).append(",").append(99042);
        str.append(" )) and fstorageOrgUnitID = '").append(storageOrgUnitID).append("'");
        sqls[0] = str.toString();
        str.setLength(0);
        str.append("  delete from T_MM_ReqPlanData  where fid in  ");
        str.append(" (select t1.Fid from T_MM_ReqPlanData as t1 inner join  ");
        str.append(" (select t2.fid, t2.fSourceEntryID,t2.FcreateTime from T_MM_ReqPlanData  as t2 ");
        str.append(" where t2.FOPERATIONTYPE in ( ").append(104);
        str.append(" ,").append(108);
        str.append(" ,").append(701);
        str.append(") and fstorageOrgUnitID = '").append(storageOrgUnitID).append("'");
        str.append("  ) as t3 on ");
        str.append("  t1.fSourceEntryID = t3.fSourceEntryID and  t1.FcreateTime <t3.FcreateTime  and t1.FOPERATIONTYPE <> ").append(104);
        str.append(" ) and fstorageOrgUnitID = '").append(storageOrgUnitID).append("'");
        sqls[1] = str.toString();
        str.setLength(0);
        str.append(" delete from T_MM_ReqPlanData where fid in (select t1.fid  from T_MM_ReqPlanData as t1 ");
        str.append(" inner join (select fSourceEntryID,FcreateTime from T_MM_ReqPlanData where FOPERATIONTYPE = ").append(303);
        str.append(" and fstorageOrgUnitID = '").append(storageOrgUnitID).append("')");
        str.append(" as t2 on t1.fSourceEntryID = t2.fSourceEntryID");
        str.append("  where  t1.FcreateTime <t2.FcreateTime and  t1.FOPERATIONTYPE = ").append(201);
        str.append(" ) and fstorageOrgUnitID = '").append(storageOrgUnitID).append("'");
        sqls[2] = str.toString();
        str.setLength(0);
        str.append(" delete from T_MM_ReqPlanData where fid in (select fid  from T_MM_ReqPlanData as t1 ");
        str.append(" inner join (select fSourceEntryID,FcreateTime from T_MM_ReqPlanData where FOPERATIONTYPE = ").append(9902);
        str.append(")");
        str.append(" as t2 on t1.fSourceEntryID = t2.fSourceEntryID");
        str.append("  where  t1.FcreateTime <t2.FcreateTime and  t1.FOPERATIONTYPE = ").append(9901);
        str.append(" ) and fstorageOrgUnitID = '").append(storageOrgUnitID).append("'");
        sqls[3] = str.toString();
        str.setLength(0);
        str.append("  delete from T_MM_ReqPlanData where fid  in ");
        str.append("(select t.fid  from T_MM_reqplandata as t inner join ");
        str.append("  (select max(fcreateTime) as fcreateTime ,fmaterialid,fSourceEntryID,FOPERATIONTYPE,fSourcebillID,FRequireDate ");
        str.append("  from T_MM_reqplandata ");
        str.append(" where fstorageOrgUnitID = '").append(storageOrgUnitID).append("'");
        str.append(" group by fmaterialid,fSourceEntryID,fSourcebillID,FOPERATIONTYPE,FRequireDate  ) as t1 ");
        str.append(" on t.fmaterialid = t1.fmaterialid ");
        str.append(" where t.fSourcebillID = t1.fSourcebillID  ");
        str.append(" and t.fSourceEntryID = t1.fSourceEntryID and t.fcreateTime<t1.fcreateTime ");
        str.append(" and t1.FOPERATIONTYPE in (99032,99031,99042,99041)) and fstorageOrgUnitID = '").append(storageOrgUnitID).append("'");
        sqls[4] = str.toString();
        str.setLength(0);
        str.append("  delete from T_MM_ReqPlanData where fid  in ");
        str.append("(select t.fid  from T_MM_reqplandata as t left outer join ");
        str.append("  (select max(fcreateTime) as fcreateTimeMax ,fSourceEntryID,FOPERATIONTYPE ");
        str.append("  from T_MM_reqplandata group by fSourceEntryID,FOPERATIONTYPE  ) as t1 ");
        str.append(" on  t.fSourceEntryID = t1.fSourceEntryID and t.FOPERATIONTYPE = t1.FOPERATIONTYPE and t.fcreateTime = t1.fcreateTimeMax ");
        str.append(" where t1.fSourceEntryID is null  ");
        str.append(" ) ");
        sqls[5] = str.toString();
        SQLUtil.batchExecuteSql((Context)ctx, (String[])sqls);
        str.setLength(0);
        str.append(" update T_MM_ReqPlanData as t2 set (fOffsetMode,FIsolatedRule,fqty,funitID,fManufactureStrategyID ,");
        str.append(" FPlanMode,fForwardDaysOffset,fBackwardDaysOffset,FPlanner,FDutyDepartment,FControlUnitID) = ");
        str.append(" ( select t1.fOffsetMode,t1.FIsolatedRule,t1.fqty,t1.funitID,t1.fManufactureStrategyID ,");
        str.append(" t1.FPlanMode,t1.fForwardDaysOffset,t1.fBackwardDaysOffset,");
        str.append(" t1.FPlanner,t1.FDutyDepartment,t1.FControlUnitID from ");
        str.append(" ( select t.fid, mp.fOffsetMode,mp.FIsolatedRule,round(t.FBaseQty/isnull(mu.fBaseConvsRate,1),isnull(mu.FQtyPrecision,4)) as FQty,");
        str.append(" mp.FPlanningMode as FPlanMode,mp.FProductUnitID as FUnitID,mp.fManufactureStrategyID,");
        str.append(" mp.fForwardDaysOffset,mp.fBackwardDaysOffset,mp.FPlanner,mp.FDutyDepartment,org.FControlUnitID");
        str.append("  from t_org_storage as org   ");
        str.append("  inner join  T_MM_ReqPlanData as t  on   t.FStorageOrgUnitID = org.FID ");
        str.append(" inner join  t_bd_materialplan  mp    on  mp.FOrgUnit  =org.fid and t.FMaterialID = mp.fMaterialID");
        str.append(" inner join t_bd_multiMeasureUnit mu \ton mp.FMaterialID = mu.FMaterialID and mp.FProductUnitID = mu.FMeasureUnitID ");
        str.append(" where t.fStorageOrgUnitID ='").append(storageOrgUnitID).append("') as t1 ");
        str.append(" where t2.fid = t1.fid)");
        str.append(" where t2.fStorageOrgUnitID ='").append(storageOrgUnitID).append("'");
        DbUtil.execute((Context)ctx, (String)str.toString());
    }

    private void deletePlan(Context ctx, String storageOrgUnitID, boolean hasCodingRuler) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append(" delete T_MM_ReqPlanData where fStorageOrgUnitID = '").append(storageOrgUnitID).append("'");
        if (!hasCodingRuler) {
            sql.append(" and fisaddnew = 0  ");
        }
        sql.append("and  fisNowWriteOff  = 1");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private void writeOffReqPlan(Context ctx, String storageOrgUnitID, String cuID, boolean hasCodingRuler) throws EASBizException, BOSException {
        Date date = new Date();
        logger.info((Object)(" writeOffReqPlanBegin:" + dateFormat2.format(date)));
        this.beforewriteOff(ctx, storageOrgUnitID);
        this.passiveWriteOffPICReq(ctx, storageOrgUnitID, cuID);
        this.writeOffReqTransBySrcBill(ctx, storageOrgUnitID, cuID);
        this.passiveWriteOffPIDReq(ctx, storageOrgUnitID, cuID);
        this.passiveWriteOffPIOReq(ctx, storageOrgUnitID, cuID, hasCodingRuler);
        this.passiveRubricWriteOffReq(ctx, storageOrgUnitID);
        Date date2 = new Date();
        logger.info((Object)(" ##writeOffReqPlanEnd:##" + dateFormat2.format(date2)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _batchDealCounteract(Context ctx, String storageOrgUnitID) throws BOSException, EASBizException {
        try {
            boolean isSucceed = ReqplanUtils.checkMutex(ctx, storageOrgUnitID);
            if (!isSucceed) {
                throw new ReqCntactException(ReqCntactException.REQUESTMUTEXFAIL);
            }
            ReqPlanForSubmitRunner runner = new ReqPlanForSubmitRunner(ctx);
            runner.run(ctx, storageOrgUnitID);
        }
        finally {
            IMutexServiceControl mutex2 = MutexServiceControlFactory.getLocalInstance((Context)ctx);
            mutex2.releaseObjIDForUpdate(storageOrgUnitID + "reqPlan");
        }
    }

    public MutexParameter setMutexParameter(Uuid mutexUuid, String orgUnitID) {
        MutexParameter mutexParam = new MutexParameter();
        mutexParam.setRequestId(mutexUuid);
        mutexParam.setOrgUnitID(BOSUuid.read((String)orgUnitID));
        mutexParam.setMutexLockType(MutexLockType.EXCLUSIVE_LOCK);
        mutexParam.setMutexName(MM_REQPLAN_CNT_MUTEXLOCK);
        return mutexParam;
    }

    private void writeExceptionLocal(Context ctx, String storageOrgUnitID, ReqPlanExceptionTypeEnum errType, String description, String exceptionDesr, String detailInfo) throws BOSException, EASBizException {
        ReqPlanExceptionRecordInfo rqExcpInfo = new ReqPlanExceptionRecordInfo();
        StorageOrgUnitInfo soInfo = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("id"));
        selectors.add(new SelectorItemInfo("name"));
        selectors.add(new SelectorItemInfo("number"));
        selectors.add(new SelectorItemInfo("cu.id"));
        selectors.add(new SelectorItemInfo("cu.number"));
        selectors.add(new SelectorItemInfo("cu.name"));
        viewInfo.setSelector(selectors);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)storageOrgUnitID, CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        StorageOrgUnitCollection orgCol = StorageOrgUnitFactory.getLocalInstance((Context)ctx).getStorageOrgUnitCollection(viewInfo);
        if (orgCol.size() > 0) {
            soInfo = orgCol.get(0);
            rqExcpInfo.setStorageOrgUnit(soInfo);
            rqExcpInfo.setCU(soInfo.getCU());
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(System.currentTimeMillis());
            rqExcpInfo.setErrorDate(new Timestamp(calendar.getTimeInMillis()));
            rqExcpInfo.setExceptionType(errType);
            rqExcpInfo.setDescription(description);
            rqExcpInfo.setExceptionDescription(exceptionDesr);
            rqExcpInfo.setDetailInfo(detailInfo);
            IReqPlanExceptionRecord iReqPlanEr = ReqPlanExceptionRecordFactory.getLocalInstance(ctx);
            iReqPlanEr.submit((CoreBaseInfo)rqExcpInfo);
        }
    }

    private String[] getNumbers(Context ctx, String storageOrgUnitID, int count) throws BOSException, EASBizException {
        ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        RequirementPlanInfo reqInfo = new RequirementPlanInfo();
        Calendar cal = Calendar.getInstance();
        reqInfo.setCreateTime(new Timestamp(cal.getTimeInMillis()));
        String[] nums = null;
        if (codingRuleManager.getCodingRule((IObjectValue)reqInfo, storageOrgUnitID) == null) {
            throw new ReqPlanException(ReqPlanException.NOCODINGRULE);
        }
        nums = codingRuleManager.getBatchNumber((IObjectValue)reqInfo, storageOrgUnitID, count);
        return nums;
    }

    protected void reverseWriteOffReq(Context ctx, String storageOrgUnitID, boolean hasCodingRuler) throws BOSException, EASBizException {
        this.execProjectTask(ctx, storageOrgUnitID);
        try {
            StringBuffer sql_updateCntactQty = new StringBuffer();
            sql_updateCntactQty.append(" UPDATE T_MM_RequirementPlan as p SET (FCntactTotalQty,FBaseCntactTotalQty,FStatus) = ");
            sql_updateCntactQty.append("(SELECT case when p.FCntactTotalQty -t1.fqty < 0 then 0 else p.FCntactTotalQty -t1.fqty end, ");
            sql_updateCntactQty.append(" case when p.FBaseCntactTotalQty - t1.fbaseqty < 0 then 0 else p.FBaseCntactTotalQty -t1.fbaseqty end, ");
            sql_updateCntactQty.append(" case when p.fQty - (p.FCntactTotalQty -t1.fqty)>0 and fclosetype <> 20 then 10 else 20 end ");
            sql_updateCntactQty.append(" FROM");
            sql_updateCntactQty.append("    ( select  r.fmaterialid,r.FDestID, sum(r.fBaseQty) as fbaseqty , sum(r.fQty) as fqty ");
            sql_updateCntactQty.append("  from T_MM_ReqCounteractRelation as r ");
            sql_updateCntactQty.append("  where r.fSourceID in (");
            sql_updateCntactQty.append("     select FSOURCebillID from T_MM_ReqPlanData as t ");
            sql_updateCntactQty.append("  where  t.FSTORAGEORGUNITID = ?  and t.fisRubricWriteOff = 1 and  t.fisNowWriteOff  = 1");
            if (!hasCodingRuler) {
                sql_updateCntactQty.append(" and t.fisaddnew = 0 ");
            }
            sql_updateCntactQty.append(")");
            sql_updateCntactQty.append("    group by  r.FDestID,r.fmaterialid ) as t1 ");
            sql_updateCntactQty.append("  WHERE t1.FDestID = p.fid and p.fmaterialid = t1.fmaterialid )   where p.FSTORAGEORGUNITID = ?");
            DbUtil.execute((Context)ctx, (String)sql_updateCntactQty.toString(), (Object[])new Object[]{storageOrgUnitID, storageOrgUnitID});
            sql_updateCntactQty.setLength(0);
            sql_updateCntactQty.append(" UPDATE T_MM_ReqCounteractRelation as p SET (fRubricQty,fRubricBaseQty) = ");
            sql_updateCntactQty.append("(SELECT (p.fRubricQty+t1.fqty) as fRubricQty , (p.fRubricBaseQty+t1.fbaseqty) as fRubricBaseQty ");
            sql_updateCntactQty.append(" FROM");
            sql_updateCntactQty.append("   (select t.FSrcOfSourceEntryID, r.FDestID,sum(r.fBaseQty) as fbaseqty , sum(r.fQty) as fqty ");
            sql_updateCntactQty.append("    from T_MM_ReqCounteractRelation as r inner join T_MM_ReqPlanData as t on ");
            sql_updateCntactQty.append("    r.fSourceEntryID = t.FSOURCEENTRYID ");
            sql_updateCntactQty.append("    WHERE  t.FSTORAGEORGUNITID = ? and t.fisRubricWriteOff = 1  and t.fqty<0 and  t.fisNowWriteOff  = 1");
            if (!hasCodingRuler) {
                sql_updateCntactQty.append(" and t.fisaddnew = 0 ");
            }
            sql_updateCntactQty.append("    group by  r.FDestID,t.FSrcOfSourceEntryID) as t1 ");
            sql_updateCntactQty.append("  WHERE t1.FSrcOfSourceEntryID = p.fSourceEntryID and t1.FDestID = p.FDestID )");
            DbUtil.execute((Context)ctx, (String)sql_updateCntactQty.toString(), (Object[])new Object[]{storageOrgUnitID});
            sql_updateCntactQty.setLength(0);
            sql_updateCntactQty.append("delete from T_MM_ReqCounteractRelation where  FSourceID in  ");
            sql_updateCntactQty.append(" (select FSOURCEbillID from T_MM_ReqPlanData as t where t.FSTORAGEORGUNITID = ? and t.fisRubricWriteOff = 1 and  t.fisNowWriteOff  = 1");
            if (!hasCodingRuler) {
                sql_updateCntactQty.append(" and t.fisaddnew = 0 ");
            }
            sql_updateCntactQty.append(")");
            DbUtil.execute((Context)ctx, (String)sql_updateCntactQty.toString(), (Object[])new Object[]{storageOrgUnitID});
            sql_updateCntactQty.setLength(0);
            sql_updateCntactQty.append(" UPDATE T_MM_RequirementPlan as p SET (FCntactTotalQty,FBaseCntactTotalQty,FStatus) = ");
            sql_updateCntactQty.append("(SELECT case when t1.fqty > 0 then t1.fqty  else 0 end, ");
            sql_updateCntactQty.append(" case when t1.fbaseqty > 0 then t1.fbaseqty else 0 end, ");
            sql_updateCntactQty.append(" case when (p.fQty - t1.fqty)>0 and fclosetype <> 20   then 10 else 20 end ");
            sql_updateCntactQty.append(" FROM");
            sql_updateCntactQty.append("   (select  p1.fid, (case when sum(r.fBaseQty) is null then 0 else sum(r.fBaseQty) end )as fbaseqty, ");
            sql_updateCntactQty.append(" (case when sum(r.fQty) is null then 0 else sum(r.fQty) end )as fqty ");
            sql_updateCntactQty.append("    from T_MM_RequirementPlan as p1 ");
            sql_updateCntactQty.append("   inner join T_MM_ReqCounteractRelation as r on r.FDestID = p1.fid ");
            sql_updateCntactQty.append(" where p1.FSourceentryID in (select FSrcOfSourceEntryID from T_MM_ReqPlanData  as t ");
            sql_updateCntactQty.append("    WHERE  t.FSTORAGEORGUNITID = ? and t.fisRubricWriteOff = 1 and  t.fisNowWriteOff  = 1 and t.fisOrderToOrder = 1 )");
            if (!hasCodingRuler) {
                sql_updateCntactQty.append(" and t.fisaddnew = 0 ");
            }
            sql_updateCntactQty.append("    group by  p1.FSourceentryID,p1.fid) as t1 ");
            sql_updateCntactQty.append("  WHERE t1.fid = p.fid  )");
            DbUtil.execute((Context)ctx, (String)sql_updateCntactQty.toString(), (Object[])new Object[]{storageOrgUnitID});
            StringBuffer condition = new StringBuffer();
            condition.append("  fSourceEntryID in  ");
            condition.append(" (select fSourceEntryID from T_MM_ReqPlanData as t where ");
            condition.append("  t.fisRubricWriteOff = 1 and  t.fisNowWriteOff  = 1");
            if (!hasCodingRuler) {
                condition.append(" and t.fisaddnew = 0 ");
            }
            condition.append(" ) and FCntactTotalQty<=0 ");
            Integer closeType = new Integer("20");
            condition.append(" and FCloseType <> ").append(closeType);
            StringBuffer condition2 = new StringBuffer();
            condition2.append("  fSourcebillID in  ");
            condition2.append(" (select fSourcebillID from T_MM_ReqPlanData as t where ");
            condition2.append("  t.fisRubricWriteOff = 1 and  t.fisNowWriteOff  = 1");
            if (!hasCodingRuler) {
                condition2.append(" and t.fisaddnew = 0 ");
            }
            condition2.append(" ) and FCntactTotalQty<=0 ");
            condition2.append(" and FSTORAGEORGUNITID = '").append(storageOrgUnitID).append("'");
            condition2.append(" and FCloseType <> ").append(closeType);
            List billNumberLst = this.getReqPlanNumbers(ctx, condition.toString());
            String sql_delReq = "delete from t_mm_RequirementPlan where " + condition;
            DbUtil.execute((Context)ctx, (String)sql_delReq);
            this.recycleNumber(ctx, storageOrgUnitID, billNumberLst);
            List billNumberLst2 = this.getReqPlanNumbers(ctx, condition2.toString());
            String sql_delReq2 = "delete from t_mm_RequirementPlan where " + condition2;
            DbUtil.execute((Context)ctx, (String)sql_delReq2);
            this.recycleNumber(ctx, storageOrgUnitID, billNumberLst2);
            Date date = new Date();
            logger.info((Object)(" ##reverseWriteOffReqEnd:##" + dateFormat2.format(date)));
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void recycleNumber(Context ctx, String storageOrgUnitID, List recNumbers) throws BOSException, EASBizException {
        RequirementPlanInfo reqInfo;
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        CodingRuleInfo crInfo = iCodingRuleManager.getCodingRule((IObjectValue)(reqInfo = new RequirementPlanInfo()), storageOrgUnitID);
        if (crInfo == null) {
            return;
        }
        if (iCodingRuleManager.isExist((IObjectValue)reqInfo, storageOrgUnitID) && iCodingRuleManager.isUseIntermitNumber((IObjectValue)reqInfo, storageOrgUnitID)) {
            iCodingRuleManager.recycleBatchNumber((IObjectValue)reqInfo, storageOrgUnitID, recNumbers.toArray(new String[recNumbers.size()]));
        }
    }

    private List getReqPlanNumbers(Context ctx, String whereCondition) throws BOSException, EASBizException {
        ArrayList<String> result = new ArrayList<String>();
        String sql = "select fNumber from t_mm_requirementplan where " + whereCondition;
        IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (row.next()) {
                result.add(row.getString("fNumber"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    protected void execProjectTask(Context ctx, String storageOrgUnitID) throws BOSException, EASBizException {
        StringBuffer sql_activeSub = new StringBuffer();
        sql_activeSub.append(" update T_MM_RequirementPlan set FStatus = 10,FCloseType = 0");
        sql_activeSub.append(" where FID in(");
        sql_activeSub.append(" select rp.FID from T_MM_RequirementPlan as rp");
        sql_activeSub.append(" inner join T_MM_ReqPlanTmpParam as rpp on  rp.FSourceBillID = rpp.fParamValue ");
        sql_activeSub.append(" inner join T_MM_ReqPlanData as t on  t.FSourceBillID = rpp.FParent ");
        sql_activeSub.append(" where t.fisRubricWriteOff = 0 and t.fBillTypeID = 'cV8Sqe5UQ3eI+vH675lGxUY+1VI='");
        sql_activeSub.append(" and t.fStorageOrgUnitID = ? and  t.fisNowWriteOff  = 1");
        sql_activeSub.append(" and rp.FStatus = 20");
        sql_activeSub.append(" and rp.FCloseType = 30)");
        DbUtil.execute((Context)ctx, (String)sql_activeSub.toString(), (Object[])new Object[]{storageOrgUnitID});
        sql_activeSub.setLength(0);
        sql_activeSub.append(" delete from T_MM_ReqPlanTmpParam where FParent in");
        sql_activeSub.append(" (select FSourceBillID from  T_MM_ReqPlanData ");
        sql_activeSub.append(" where fisRubricWriteOff = 1 and fBillTypeID = 'cV8Sqe5UQ3eI+vH675lGxUY+1VI='");
        sql_activeSub.append(" and fStorageOrgUnitID = ? and  fisNowWriteOff  = 1)");
        DbUtil.execute((Context)ctx, (String)sql_activeSub.toString(), (Object[])new Object[]{storageOrgUnitID});
    }

    protected void insertPlan(Context ctx, String storageOrgUnitID, boolean hasCodingRuler, String cuID) throws BOSException, EASBizException {
        int i;
        StringBuffer sql = new StringBuffer();
        if (!hasCodingRuler) {
            String str = ResourceManage.getResource((String)REQPLAN_RESOURCE_PATH, (String)"ACTION_GETNUMBERS", (Locale)ctx.getLocale());
            String exception = ResourceManage.getResource((String)REQPLAN_RESOURCE_PATH, (String)"EXCEPTION_NOCODEINGRULE", (Locale)ctx.getLocale());
            this.writeExceptionLocal(ctx, storageOrgUnitID, ReqPlanExceptionTypeEnum.ALARM, str, exception, "");
            return;
        }
        String paramValue = ParamManager.getParamValue((Context)ctx, (IObjectPK)new ObjectUuidPK(storageOrgUnitID), (String)"TRACKNUMBER_GENERATEMODE");
        boolean isaddTtrackNumber = false;
        TrackNumberCollection trackNumberCol = null;
        String trackNumber = null;
        if (paramValue != null && paramValue.equals("1")) {
            sql.setLength(0);
            sql.append("select t.FSOURCEENTRYID from  T_MM_ReqPlanData as t ");
            sql.append(" left join T_MM_RequirementPlan as r on r.fSourceEntryID = t.FSOURCEENTRYID ");
            sql.append(" where  t.FSTORAGEORGUNITID = ? and t.fisaddnew = 1 and  t.fisNowWriteOff  = 1 ");
            sql.append(" and r.fSourceEntryID is null and t.FTrackNumberID is null and t.FProjectID is null ");
            sql.append(" and t.FaddPlanType = '").append("NcvxPgEcEADgAAiswKgL09hs+cg=").append("'");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{storageOrgUnitID});
            ITrackNumber itrackNumber = TrackNumberFactory.getLocalInstance((Context)ctx);
            CtrlUnitInfo cu = new CtrlUnitInfo();
            cu.setId(BOSUuid.read((String)cuID));
            boolean hasCodingRule = itrackNumber.hasCodingRuler(cu);
            if (hasCodingRule && rs.size() > 0 && (trackNumberCol = itrackNumber.autoGenerateNum(null, rs.size(), cu)).size() > 0) {
                isaddTtrackNumber = true;
            }
        }
        this.execInsertProjectTask(ctx, storageOrgUnitID);
        sql.setLength(0);
        sql.append(" UPDATE T_MM_RequirementPlan as r");
        sql.append(" SET (FQty, FBaseQty,FNotCntactQty ,FBaseNotCntactQty,FRequireDate ,FStatus) = ");
        sql.append(" (select t.fqty as FQty,t.fbaseQty as FBaseQty,t.fqty as FNotCntactQty,t.fbaseQty as FBaseNotCntactQty,");
        Integer closeType = new Integer("20");
        sql.append(" t.FRequireDate as  FRequireDate, (case when r.FBaseCntactTotalQty < t.fbaseqty and r.FCloseType <> ").append(closeType);
        sql.append(" then 10");
        sql.append(" else 20 end) as FStatus  ");
        sql.append(" from T_MM_ReqPlanData as t where t.fisaddnew = 1 and r.fSourceEntryID = t.FSOURCEENTRYID   ");
        sql.append(" and r.fmaterialID = t.fmaterialID ");
        sql.append(" and  t.fisNowWriteOff  = 1 and t.FSTORAGEORGUNITID = ? )");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{storageOrgUnitID});
        HashMap map = ReqPlanInsertExtendFacadeFactory.getLocalInstance(ctx).getAllCols();
        ArrayList tmpList = null;
        ArrayList reqplanList = null;
        if (map != null) {
            tmpList = (ArrayList)map.get("tmpList");
            reqplanList = (ArrayList)map.get("reqplanList");
        }
        sql.setLength(0);
        sql.append("insert into T_MM_RequirementPlan ");
        sql.append("(FID,FNumber,FcustomerID,fStorageOrgUnitID,fSourceSUID,fMaterialID,fUnitID,fBaseUnitID,");
        sql.append("fReqSource,fReqTypeID,fManuStrategyID,fRequireDate,");
        sql.append("fQty,fBaseQty,fNotCntactQty,fBaseNotCntactQty,fSourceBillID,fSourceBillNum,fBillTypeID,");
        sql.append("fSourceEntryID,fSourceEntrySeq,fStatus,fPlanMode,fCreatorID,FCreateTime,");
        sql.append("fControlUnitID,FTrackNumberID,FProjectID, FIsTrackNumFromSrc");
        sql.append(",FPlannerID,FProductionDeptID,FIsDirectTransport ");
        if (reqplanList != null) {
            for (i = 0; i < reqplanList.size(); ++i) {
                sql.append(",").append(reqplanList.toArray()[i]);
            }
        }
        sql.append(") \n");
        sql.append(" (select  newbosid('D86AF5B7') as fid ,null as fnumber,t.FcustomerID,t.fStorageOrgUnitID,t.fSourceSUID,t.fMaterialID,t.fUnitID,t.fBaseUnitID, ");
        sql.append(" t.fReqSource,t.FaddPlanType as fReqTypeID,t.fManufactureStrategyID as fManuStrategyID,t.fRequireDate,");
        sql.append(" t.fQty,t.fBaseQty,t.fQty  as fNotCntactQty ,t.fBaseQty as fBaseNotCntactQty,t.fSourceBillID,t.FSrcNumber as fSourceBillNum,t.fBillTypeID,");
        sql.append(" t.fSourceEntryID,t.FSrcSeq as fSourceEntrySeq ,? as fStatus,t.FPlanMode as fPlanMode,t.fCreatorID,t.FCreateTime,");
        sql.append(" t.FControlUnitID,t.FTrackNumberID,t.FProjectID,(case when t.FTrackNumberID is null then 0 else 1 end) as FIsTrackNumFromSrc,");
        sql.append(" t.FPlanner,t.FDutyDepartment as FProductionDeptID ,t.FIsDirectTransport as FIsDirectTransport ");
        if (tmpList != null) {
            for (i = 0; i < tmpList.size(); ++i) {
                sql.append(",t.").append(tmpList.toArray()[i]);
            }
        }
        sql.append(" from T_MM_ReqPlanData as t ");
        sql.append(" left join T_MM_RequirementPlan as r on r.fSourceEntryID = t.FSOURCEENTRYID ");
        sql.append(" where  t.FSTORAGEORGUNITID = ? and t.fisaddnew = 1  and  t.fisNowWriteOff  = 1");
        sql.append(" and r.fSourceEntryID is null and t.FaddPlanType is not null )");
        int number = SQLUtils.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{new Integer(10), storageOrgUnitID});
        if (number <= 0) {
            sql.setLength(0);
            sql.append("delete from T_MM_RequirementPlan where fBaseQty<=0 and  FSTORAGEORGUNITID = '").append(storageOrgUnitID).append("'");
            SQLUtils.execute((Context)ctx, (String)sql.toString());
            return;
        }
        String[] billNumber = this.getNumbers(ctx, storageOrgUnitID, number);
        sql.setLength(0);
        sql.append(" select fid,fReqTypeID, FTrackNumberID,FProjectID from  T_MM_RequirementPlan  where fnumber is null and FSTORAGEORGUNITID = '").append(storageOrgUnitID).append("'");
        IRowSet rs1 = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append(" update T_MM_RequirementPlan set fnumber  = ?,FTrackNumberID= ? where fnumber is null and FSTORAGEORGUNITID = ? and fid = ?");
        Connection conn = null;
        PreparedStatement stmt = null;
        int j = 0;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            String sql_t = sql.toString();
            stmt = conn.prepareStatement(sql_t);
            for (int i2 = 0; i2 < billNumber.length; ++i2) {
                rs1.next();
                stmt.setString(1, billNumber[i2]);
                if (isaddTtrackNumber && rs1.getString("fReqTypeID").equals("NcvxPgEcEADgAAiswKgL09hs+cg=") && rs1.getObject("FTrackNumberID") == null && rs1.getObject("FProjectID") == null) {
                    trackNumber = trackNumberCol.get(j).getId().toString();
                    stmt.setString(2, trackNumber);
                    ++j;
                } else {
                    stmt.setString(2, rs1.getString("FTrackNumberID"));
                }
                stmt.setString(3, storageOrgUnitID);
                stmt.setString(4, rs1.getString("fid"));
                stmt.addBatch();
            }
            stmt.executeBatch();
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                com.kingdee.util.db.SQLUtils.cleanup(stmt, (Connection)conn);
                throw throwable;
            }
        }
        com.kingdee.util.db.SQLUtils.cleanup((Statement)stmt, (Connection)conn);
        sql.setLength(0);
        sql.append("delete from T_MM_RequirementPlan where fBaseQty<=0 and  FSTORAGEORGUNITID = '").append(storageOrgUnitID).append("'");
        SQLUtils.execute((Context)ctx, (String)sql.toString());
        Date date = new Date();
        logger.info((Object)(" ##insertPlanEnd:##" + dateFormat2.format(date)));
    }

    private void setclose(Context ctx, String storageOrgUnitID) throws BOSException, EASBizException {
        StringBuffer str = new StringBuffer();
        str.append("update T_MM_RequirementPlan set FStatus = 20 where fBaseQty<=fBaseCntactTotalQty ");
        str.append(" and fstorageorgunitid = '").append(storageOrgUnitID).append("'");
        SQLUtils.execute((Context)ctx, (String)str.toString());
    }

    private void execInsertProjectTask(Context ctx, String storageOrgUnitID) throws BOSException, EASBizException {
        StringBuffer sql_closeSub = new StringBuffer();
        sql_closeSub.append(" update T_MM_RequirementPlan set FStatus = 20,FCloseType = 30");
        sql_closeSub.append(" where FID in(");
        sql_closeSub.append(" select rp.FID from T_MM_RequirementPlan as rp ");
        sql_closeSub.append(" inner join T_MM_ReqPlanTmpParam as rpp on  rp.FSourceBillID = rpp.fParamValue ");
        sql_closeSub.append(" inner join T_MM_ReqPlanData as t on  t.FSourceBillID = rpp.FParent ");
        sql_closeSub.append(" where t.fisaddnew = 1 and  t.fisNowWriteOff  = 1 and t.fBillTypeID = 'cV8Sqe5UQ3eI+vH675lGxUY+1VI='");
        sql_closeSub.append(" and t.fStorageOrgUnitID = ? ");
        sql_closeSub.append(" and rp.FStatus = 10) ");
        DbUtil.execute((Context)ctx, (String)sql_closeSub.toString(), (Object[])new Object[]{storageOrgUnitID});
        sql_closeSub.setLength(0);
        sql_closeSub.append(" delete from T_MM_ReqPlanTmpParam where FParent in");
        sql_closeSub.append(" (select FSourceBillID from  T_MM_ReqPlanData ");
        sql_closeSub.append(" where fisaddnew = 1 and  fisNowWriteOff  = 1 and fBillTypeID = 'cV8Sqe5UQ3eI+vH675lGxUY+1VI='");
        sql_closeSub.append(" and fStorageOrgUnitID = ? )");
        DbUtil.execute((Context)ctx, (String)sql_closeSub.toString(), (Object[])new Object[]{storageOrgUnitID});
    }

    protected void writeOffReqTransBySrcBill(Context ctx, String storageOrgUnitID, String cuID) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append(" insert into T_MM_ReqCounteractRelation ");
        sql.append(" (fID,fmaterialId,fSourceID,fSourceEntryID,fDestID,fBillTypeID,fQty,fBaseQty,fUnitID,fBaseUnitID,fSeq,FSourceNumber)");
        sql.append(" (select newbosid('D02F7535') as fid,t.fmaterialId, t.fSourceBillID as fSourceID ,t.fSourceEntryID as fSourceEntryID,");
        sql.append(" r.fid as fDestID,t.fBillTypeID as fBillTypeID,t.fqty as  fQty,t.fbaseqty as fBaseQty,");
        sql.append(" t.fUnitID as fUnitID,t.fBaseUnitID as fBaseUnitID, ? as fSeq ,t.fsrcNumber as FSourceNumber ");
        sql.append(" from t_mm_RequirementPlan as r inner join T_MM_ReqPlanData as t on r.fSourceEntryID = t.FSrcOfSourceEntryID");
        sql.append(" where  t.FSTORAGEORGUNITID = ? and t.fisWriteOff = 1 and t.fisOrderToOrder = 1 ");
        sql.append("  and  t.fisNowWriteOff  = 1 and t.FBillTypeID<>isnull(t.FSOURCEBILLTYPEID,' '))");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{new Integer(1), storageOrgUnitID});
        StringBuffer sql_updateCntactQty = new StringBuffer();
        sql_updateCntactQty.setLength(0);
        sql_updateCntactQty.append(" UPDATE T_MM_RequirementPlan as p SET (FCntactTotalQty,FBaseCntactTotalQty,FStatus) = ");
        sql_updateCntactQty.append("(SELECT case when t1.fqty > 0 then t1.fqty  else 0 end, ");
        sql_updateCntactQty.append(" case when t1.fbaseqty > 0 then t1.fbaseqty else 0 end, ");
        sql_updateCntactQty.append(" case when (p.fQty - t1.fqty)>0 and fclosetype <> 20   then 10 else 20 end ");
        sql_updateCntactQty.append(" FROM");
        sql_updateCntactQty.append("   (select  p1.fid, sum(r.fBaseQty) as fbaseqty , sum(r.fQty) as fqty ");
        sql_updateCntactQty.append("    from T_MM_RequirementPlan as p1 ");
        sql_updateCntactQty.append("   inner join T_MM_ReqCounteractRelation as r on r.FDestID = p1.fid ");
        sql_updateCntactQty.append(" where p1.FSourceentryID in (select FSrcOfSourceEntryID from T_MM_ReqPlanData  as t ");
        sql_updateCntactQty.append("    WHERE  t.FSTORAGEORGUNITID = ? and t.fisWriteOff = 1  and t.fisOrderToOrder = 1  and  t.fisNowWriteOff  = 1 ) ");
        sql_updateCntactQty.append("    group by  p1.FSourceentryID,p1.fid) as t1 ");
        sql_updateCntactQty.append("  WHERE t1.fid = p.fid  )");
        DbUtil.execute((Context)ctx, (String)sql_updateCntactQty.toString(), (Object[])new Object[]{storageOrgUnitID});
    }

    protected void passiveWriteOffPICReq(Context ctx, String storageOrgUnitID, String cuID) throws BOSException, EASBizException {
        String defaultTrackNumber = this.getDefaultTrackNumber(ctx, cuID);
        logger.info((Object)" ReqPlan##PIC##Start");
        String paramValueManul = ParamManager.getParamValue((Context)ctx, (IObjectPK)new ObjectUuidPK(storageOrgUnitID), (String)"ReqPlan_ManualWriteOff");
        boolean ismanul = Boolean.valueOf(paramValueManul);
        if (ismanul) {
            this.WriteOffPICReq(ctx, storageOrgUnitID);
            return;
        }
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet reqRow = null;
        StringBuffer sql_querySIDReq = new StringBuffer();
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            String paramValueMTD = ParamManager.getParamValue((Context)ctx, (IObjectPK)new ObjectUuidPK(storageOrgUnitID), (String)"MTDREQ_CONSUMEPICREQ");
            String paramValueMID = ParamManager.getParamValue((Context)ctx, (IObjectPK)new ObjectUuidPK(storageOrgUnitID), (String)"MIDREQ_CONSUMEPICREQ");
            boolean iswriteOffDefaultTrackNumber = Boolean.valueOf(ParamManager.getParamValue((Context)ctx, (IObjectPK)new ObjectUuidPK(storageOrgUnitID), (String)"Req_Writeoff_Control"));
            boolean isMtdConsumePic = false;
            isMtdConsumePic = Boolean.valueOf(paramValueMTD);
            boolean isMidConsumePic = false;
            isMidConsumePic = Boolean.valueOf(paramValueMID);
            sql_querySIDReq.append("select p.FTrackNumberID,p.fID,p.fSourceBillID,p.fsourceBillNum,p.fSourceEntryID,p.fBillTypeID,p.fStorageOrgUnitID,p.fMaterialID,p.fUnitID,p.fBaseUnitID");
            sql_querySIDReq.append(",m.fManufactureStrategyID,m.fOffSetMode,m.fForwardDaysOffset,m.fBackwardDaysOffset,p.fNotCntactQty,p.fBaseNotCntactQty,p.fRequireDate ");
            sql_querySIDReq.append(" from t_mm_RequirementPlan p,t_bd_materialplan m ");
            sql_querySIDReq.append(" where p.fMaterialID = m.fMaterialID ");
            sql_querySIDReq.append(" and p.fStorageOrgUnitID = m.FOrgUnit");
            sql_querySIDReq.append(" and p.fStorageOrgUnitID = ?");
            sql_querySIDReq.append(" and p.fStatus = ?");
            sql_querySIDReq.append(" and p.fNotCntactQty >0");
            sql_querySIDReq.append(" and (p.fReqSource= ?");
            sql_querySIDReq.append(" and p.FReqTypeID = ?");
            if (isMtdConsumePic) {
                sql_querySIDReq.append(" or ( p.fReqSource = ?");
                sql_querySIDReq.append(" and p.FReqTypeID = ?)");
            }
            if (isMidConsumePic) {
                sql_querySIDReq.append(" or( p.fReqSource= ?");
                sql_querySIDReq.append(" and p.FReqTypeID = ?)");
            }
            sql_querySIDReq.append(" )");
            sql_querySIDReq.append(" and exists (select 1 from t_mm_RequirementPlan as picR ");
            sql_querySIDReq.append("\twhere p.FStorageOrgUnitID = picR.FStorageOrgUnitID");
            sql_querySIDReq.append("\tand p.FMaterialID = picR.FMaterialID ");
            sql_querySIDReq.append("\tand picR.fReqTypeID = 'NcvxPgEcEADgAAiqwKgL09hs+cg='");
            sql_querySIDReq.append("\tand picR.fStatus =  10");
            sql_querySIDReq.append("\tand fQty > fCntactTotalQty)");
            sql_querySIDReq.append(" order by p.fMaterialID,p.fRequireDate ,p.FReqTypeID,p.fcreateTime  ");
            statement = conn.prepareStatement(sql_querySIDReq.toString());
            int rowIndex = 1;
            statement.setString(rowIndex++, storageOrgUnitID);
            statement.setInt(rowIndex++, 10);
            statement.setInt(rowIndex++, 20);
            statement.setString(rowIndex++, "NcvxPgEcEADgAAiswKgL09hs+cg=");
            if (isMtdConsumePic) {
                statement.setInt(rowIndex++, 40);
                statement.setString(rowIndex++, "NcvxPgEcEADgAAiwwKgL09hs+cg=");
            }
            if (isMidConsumePic) {
                statement.setInt(rowIndex++, 50);
                statement.setString(rowIndex++, "NcvxPgEcEADgAAiuwKgL09hs+cg=");
            }
            reqRow = statement.executeQuery();
            int i = 0;
            while (reqRow.next()) {
                if (reqRow.getString("fManufactureStrategyID") == null || reqRow.getString("fManufactureStrategyID").trim().length() <= 0 || reqRow.getInt("fOffsetMode") <= 0) continue;
                ReqPlanUpdateDataVO newDataVO = new ReqPlanUpdateDataVO();
                newDataVO.setId(reqRow.getString("fID"));
                newDataVO.setBillID(reqRow.getString("fSourceBillID"));
                newDataVO.setBillNumber(reqRow.getString("fsourceBillNum"));
                newDataVO.setBillEntryID(reqRow.getString("fSourceEntryID"));
                newDataVO.setBillTypeID(reqRow.getString("fBillTypeID"));
                newDataVO.setStorageOrgUnitID(reqRow.getString("fStorageOrgUnitID"));
                newDataVO.setMaterialID(reqRow.getString("fMaterialID"));
                newDataVO.setUnitID(reqRow.getString("fUnitID"));
                newDataVO.setBaseUnitID(reqRow.getString("fBaseUnitID"));
                newDataVO.setQty(reqRow.getBigDecimal("fNotCntactQty"));
                newDataVO.setBaseQty(reqRow.getBigDecimal("fBaseNotCntactQty"));
                newDataVO.setRequireDate(reqRow.getDate("fRequireDate"));
                newDataVO.setOffsetMode(reqRow.getInt("fOffsetMode"));
                newDataVO.setForwardDaysOffset(reqRow.getInt("fForwardDaysOffset"));
                newDataVO.setBackwardDaysOffset(reqRow.getInt("fBackwardDaysOffset"));
                newDataVO.setRequirementTypeInfo("NcvxPgEcEADgAAiqwKgL09hs+cg=");
                newDataVO.setManuStrategyID(reqRow.getString("fManufactureStrategyID"));
                newDataVO.setIswriteOffDefaultTrackNumber(iswriteOffDefaultTrackNumber);
                newDataVO.setDefaultTrackNumber(defaultTrackNumber);
                newDataVO.setTrackNumberID(reqRow.getString("FTrackNumberID"));
                ++i;
                this.writeOffReq(ctx, newDataVO);
            }
            logger.info((Object)("passiveWriteOffPICReqEnd\uff1apassiveWriteOffPICReq ==== i = " + i));
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                com.kingdee.util.db.SQLUtils.cleanup(reqRow, statement, (Connection)conn);
                throw throwable;
            }
        }
        com.kingdee.util.db.SQLUtils.cleanup((ResultSet)reqRow, (Statement)statement, (Connection)conn);
    }

    protected void passiveWriteOffPIOReq(Context ctx, String storageOrgUnitID, String cuID, boolean hasCodingRuler) throws BOSException, EASBizException {
        String consPioParamValue = ParamManager.getParamValue((Context)ctx, (IObjectPK)new ObjectUuidPK(storageOrgUnitID), (String)"MTDREQ_CONSUMEPIOREQ");
        boolean isMTDConsumePio = Boolean.valueOf(consPioParamValue);
        boolean iswriteOffDefaultTrackNumber = Boolean.valueOf(ParamManager.getParamValue((Context)ctx, (IObjectPK)new ObjectUuidPK(storageOrgUnitID), (String)"Req_Writeoff_Control"));
        String reductionMode = ParamManager.getParamValue((Context)ctx, (IObjectPK)new ObjectUuidPK(storageOrgUnitID), (String)"ReductionMode");
        String defaultTrackNumber = this.getDefaultTrackNumber(ctx, cuID);
        StringBuffer sql = new StringBuffer();
        sql.append(" select fForwardDaysOffset ,fBackwardDaysOffset,faddPlanType as FSourceReqType,fRequireDate, fCreateTime, '' as fid,fqty,fbaseqty,FStorageOrgUnitID,FSourceBillID,FSrcNumber,FSourceEntryID,");
        sql.append("FBillTypeID,FMaterialID,FUnitID,FBaseUnitID,fOffsetMode,fManufactureStrategyID,");
        sql.append(" FProjectID,FTrackNumberID,FIsolatedRule ");
        sql.append(" from T_MM_ReqPlanData where FSTORAGEORGUNITID = '").append(storageOrgUnitID).append("'");
        sql.append(" and fisWriteOff = 1  and fWriteOffPlanType = ? and FBillTypeID<>isnull(FSOURCEBILLTYPEID,' ') and  fisNowWriteOff  = 1");
        sql.append(" and (faddPlanType is null or isnull(faddPlanType,' ') <>  '").append("NcvxPgEcEADgAAiwwKgL09hs+cg=").append("')");
        if (isMTDConsumePio) {
            sql.append(" union ");
            sql.append(" select m.fForwardDaysOffset,m.fBackwardDaysOffset,p.FReqTypeID as FSourceReqType,p.fRequireDate, p.fCreateTime,p.fid, p.fNotCntactQty as fQty,p.FBaseNotCntactQty as fbaseQty, p.FStorageOrgUnitID,");
            sql.append(" to_char(p.FSourceBillID),p.FSourceBillNum as FSrcNumber ,to_char(p.FSourceEntryID),");
            sql.append(" p.FBillTypeID,p.FMaterialID,p.FUnitID,p.FBaseUnitID,m.fOffsetMode,p.FManuStrategyID as fManufactureStrategyID,");
            sql.append(" FProjectID,FTrackNumberID,m.FIsolatedRule ");
            sql.append(" from t_mm_RequirementPlan p,t_bd_materialplan m ");
            sql.append(" where p.fMaterialID = m.fMaterialID ");
            sql.append(" and p.fStorageOrgUnitID = m.FOrgUnit");
            sql.append(" and p.fStorageOrgUnitID = '").append(storageOrgUnitID);
            sql.append("' and p.fStatus = ").append(10);
            sql.append(" and p.fNotCntactQty >0");
            sql.append(" and p.FReqTypeID = '").append("NcvxPgEcEADgAAiwwKgL09hs+cg=").append("'");
        }
        sql.append(" order by fRequireDate,fCreateTime ASC ");
        IRowSet reqRow = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{new Integer(3)});
        int i = 0;
        try {
            while (reqRow.next()) {
                if (reqRow.getString("fManufactureStrategyID") != null && reqRow.getString("fManufactureStrategyID").trim().length() > 0 && reqRow.getInt("fOffsetMode") > 0) {
                    ReqPlanUpdateDataVO newDataVO = new ReqPlanUpdateDataVO();
                    newDataVO.setId(reqRow.getString("fID"));
                    newDataVO.setBillID(reqRow.getString("fSourceBillID"));
                    newDataVO.setBillNumber(reqRow.getString("FSrcNumber"));
                    newDataVO.setBillEntryID(reqRow.getString("fSourceEntryID"));
                    newDataVO.setBillTypeID(reqRow.getString("fBillTypeID"));
                    newDataVO.setStorageOrgUnitID(reqRow.getString("fStorageOrgUnitID"));
                    newDataVO.setMaterialID(reqRow.getString("fMaterialID"));
                    newDataVO.setUnitID(reqRow.getString("fUnitID"));
                    newDataVO.setBaseUnitID(reqRow.getString("fBaseUnitID"));
                    newDataVO.setManuStrategyID(reqRow.getString("fManufactureStrategyID"));
                    newDataVO.setProjectID(reqRow.getString("FProjectID"));
                    newDataVO.setTrackNumberID(reqRow.getString("FTrackNumberID"));
                    newDataVO.setEtoConsumeRuleValue(reqRow.getString("FIsolatedRule"));
                    newDataVO.setQty(reqRow.getBigDecimal("fqty"));
                    newDataVO.setBaseQty(reqRow.getBigDecimal("fbaseqty"));
                    newDataVO.setRequirementTypeInfo("s0fDJAEoEADgAABCfwAAAdhs+cg=");
                    newDataVO.setIswriteOffDefaultTrackNumber(iswriteOffDefaultTrackNumber);
                    newDataVO.setDefaultTrackNumber(defaultTrackNumber);
                    newDataVO.setOffsetMode(reqRow.getInt("fOffsetMode"));
                    newDataVO.setReductionMode(reductionMode);
                    newDataVO.setSourceReqTypeInfo(reqRow.getString("FSourceReqType"));
                    newDataVO.setRequireDate(reqRow.getDate("fRequireDate"));
                    newDataVO.setForwardDaysOffset(reqRow.getInt("fForwardDaysOffset"));
                    newDataVO.setBackwardDaysOffset(reqRow.getInt("fBackwardDaysOffset"));
                    this.writeOffReq(ctx, newDataVO);
                }
                ++i;
            }
            logger.info((Object)("passiveWriteOffPIOReqEnd\uff1apassiveWriteOffPIOReq ==== i = " + i));
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected void passiveRubricWriteOffReq(Context ctx, String storageOrgUnitID) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select FSourceBillTypeID,fOffsetMode,FsrcOfSourceBillID,FsrcOfSourceEntryID,fqty,fbaseqty,FStorageOrgUnitID,FSourceBillID,FSrcNumber,FSourceEntryID,");
        sql.append("FBillTypeID,FMaterialID,FUnitID,FBaseUnitID, fQty,FBaseQty,fManufactureStrategyID,");
        sql.append(" FProjectID,FTrackNumberID,FIsolatedRule ,faddPlanType");
        sql.append(" from T_MM_ReqPlanData where FSTORAGEORGUNITID = ?  and  fisWriteOff = 1 and  fisNowWriteOff  = 1");
        sql.append("  and fbaseqty<0 ");
        sql.append(" order by fCreateTime ASC ");
        IRowSet reqRow = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{storageOrgUnitID});
        try {
            while (reqRow.next()) {
                if (reqRow.getString("fManufactureStrategyID") == null || reqRow.getString("fManufactureStrategyID").trim().length() <= 0 || reqRow.getInt("fOffsetMode") <= 0) continue;
                ReqPlanUpdateDataVO newDataVO = new ReqPlanUpdateDataVO();
                newDataVO.setBillID(reqRow.getString("fSourceBillID"));
                newDataVO.setBillNumber(reqRow.getString("FSrcNumber"));
                newDataVO.setBillEntryID(reqRow.getString("fSourceEntryID"));
                newDataVO.setBillTypeID(reqRow.getString("fBillTypeID"));
                newDataVO.setStorageOrgUnitID(reqRow.getString("fStorageOrgUnitID"));
                newDataVO.setMaterialID(reqRow.getString("fMaterialID"));
                newDataVO.setUnitID(reqRow.getString("fUnitID"));
                newDataVO.setBaseUnitID(reqRow.getString("fBaseUnitID"));
                newDataVO.setManuStrategyID(reqRow.getString("fManufactureStrategyID"));
                newDataVO.setProjectID(reqRow.getString("FProjectID"));
                newDataVO.setTrackNumberID(reqRow.getString("FTrackNumberID"));
                newDataVO.setEtoConsumeRuleValue(reqRow.getString("FIsolatedRule"));
                newDataVO.setQty(reqRow.getBigDecimal("fqty"));
                newDataVO.setBaseQty(reqRow.getBigDecimal("fbaseqty"));
                newDataVO.setSrcBillID(reqRow.getString("FsrcOfSourceBillID"));
                newDataVO.setSrcBillEntryID(reqRow.getString("FsrcOfSourceEntryID"));
                if ("50957179-0105-1000-e008-8152c0a812fd463ED552".equals(reqRow.getString("FSourceBillTypeID")) || "B2aZSVXaSx6qxdfekgCmrEY+1VI=".equals(reqRow.getString("FSourceBillTypeID"))) continue;
                this.rubricWriteOffReq(ctx, newDataVO);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected void passiveWriteOffPIDReq(Context ctx, String storageOrgUnitID, String cuID) throws BOSException, EASBizException {
        String defaultTrackNumber = this.getDefaultTrackNumber(ctx, cuID);
        StringBuffer sql = new StringBuffer();
        sql.append(" select fForwardDaysOffset ,fBackwardDaysOffset,faddPlanType as FSourceReqType,");
        sql.append(" fRequireDate, fCreateTime, '' as fid,fqty,fbaseqty,FStorageOrgUnitID,FSourceBillID,FSrcNumber,FSourceEntryID,");
        sql.append("FBillTypeID,FMaterialID,FUnitID,FBaseUnitID,fOffsetMode,fManufactureStrategyID,");
        sql.append(" FProjectID,FTrackNumberID,FIsolatedRule ");
        sql.append(" from T_MM_ReqPlanData where FSTORAGEORGUNITID = ? and fisWriteOff = 1  ");
        sql.append("  and fWriteOffPlanType = ? and FBillTypeID<>isnull(FSOURCEBILLTYPEID,' ') and  fisNowWriteOff  = 1");
        sql.append(" and (faddPlanType is null or isnull(faddPlanType,' ') <>  '").append("LIggukxnQ0eNvHc34XGmuNhs+cg=").append("')");
        sql.append(" union ");
        sql.append(" select m.fForwardDaysOffset,m.fBackwardDaysOffset,p.FReqTypeID as FSourceReqType,");
        sql.append(" p.fRequireDate, p.fCreateTime,p.fid, p.fNotCntactQty as fQty,p.FBaseNotCntactQty as fbaseQty, p.FStorageOrgUnitID,");
        sql.append(" to_char(p.FSourceBillID),p.FSourceBillNum as FSrcNumber ,to_char(p.FSourceEntryID),");
        sql.append(" p.FBillTypeID,p.FMaterialID,p.FUnitID,p.FBaseUnitID,m.fOffsetMode,p.FManuStrategyID as fManufactureStrategyID,");
        sql.append(" FProjectID,FTrackNumberID,m.FIsolatedRule ");
        sql.append(" from t_mm_RequirementPlan p,t_bd_materialplan m ");
        sql.append(" where p.fMaterialID = m.fMaterialID ");
        sql.append(" and p.fStorageOrgUnitID = m.FOrgUnit");
        sql.append(" and p.fStorageOrgUnitID = '").append(storageOrgUnitID);
        sql.append("' and p.fStatus = ").append(10);
        sql.append(" and p.fNotCntactQty >0");
        sql.append(" and p.FReqTypeID = '").append("LIggukxnQ0eNvHc34XGmuNhs+cg=").append("'");
        sql.append(" order by fRequireDate,fCreateTime ASC ");
        IRowSet reqRow = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{storageOrgUnitID, new Integer(1)});
        String reductionMode = ParamManager.getParamValue((Context)ctx, (IObjectPK)new ObjectUuidPK(storageOrgUnitID), (String)"ReductionMode");
        boolean iswriteOffDefaultTrackNumber = Boolean.valueOf(ParamManager.getParamValue((Context)ctx, (IObjectPK)new ObjectUuidPK(storageOrgUnitID), (String)"Req_Writeoff_Control"));
        int i = 0;
        try {
            while (reqRow.next()) {
                if (reqRow.getString("fManufactureStrategyID") == null || reqRow.getString("fManufactureStrategyID").trim().length() <= 0 || reqRow.getInt("fOffsetMode") <= 0) continue;
                ReqPlanUpdateDataVO newDataVO = new ReqPlanUpdateDataVO();
                newDataVO.setId(reqRow.getString("fID"));
                newDataVO.setBillID(reqRow.getString("fSourceBillID"));
                newDataVO.setBillNumber(reqRow.getString("FSrcNumber"));
                newDataVO.setBillEntryID(reqRow.getString("fSourceEntryID"));
                newDataVO.setBillTypeID(reqRow.getString("fBillTypeID"));
                newDataVO.setStorageOrgUnitID(reqRow.getString("fStorageOrgUnitID"));
                newDataVO.setMaterialID(reqRow.getString("fMaterialID"));
                newDataVO.setUnitID(reqRow.getString("fUnitID"));
                newDataVO.setBaseUnitID(reqRow.getString("fBaseUnitID"));
                newDataVO.setManuStrategyID(reqRow.getString("fManufactureStrategyID"));
                newDataVO.setRequireDate(reqRow.getDate("fRequireDate"));
                newDataVO.setOffsetMode(reqRow.getInt("fOffsetMode"));
                newDataVO.setForwardDaysOffset(reqRow.getInt("fForwardDaysOffset"));
                newDataVO.setBackwardDaysOffset(reqRow.getInt("fBackwardDaysOffset"));
                newDataVO.setQty(reqRow.getBigDecimal("fqty"));
                newDataVO.setBaseQty(reqRow.getBigDecimal("fbaseqty"));
                newDataVO.setReductionMode(reductionMode);
                newDataVO.setRequirementTypeInfo("NcvxPgEcEADgAAiowKgL09hs+cg=");
                newDataVO.setIswriteOffDefaultTrackNumber(iswriteOffDefaultTrackNumber);
                newDataVO.setDefaultTrackNumber(defaultTrackNumber);
                newDataVO.setSourceReqTypeInfo(reqRow.getString("FSourceReqType"));
                newDataVO.setOffsetMode(reqRow.getInt("fOffsetMode"));
                newDataVO.setForwardDaysOffset(reqRow.getInt("fForwardDaysOffset"));
                newDataVO.setBackwardDaysOffset(reqRow.getInt("fBackwardDaysOffset"));
                newDataVO.setProjectID(reqRow.getString("FProjectID"));
                newDataVO.setTrackNumberID(reqRow.getString("FTrackNumberID"));
                this.writeOffReq(ctx, newDataVO);
                ++i;
            }
            logger.info((Object)("passiveWriteOffPIDReqEnd\uff1apassiveWriteOffPIDReq ==== i = " + i));
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private Date getDate(Date reqDate, int days, boolean isforward) {
        Calendar theDate = Calendar.getInstance();
        theDate.setTime(reqDate);
        if (isforward) {
            theDate.add(6, days);
        } else {
            theDate.add(6, -days);
        }
        return theDate.getTime();
    }

    private String getCntFilter(Context ctx, String storageOrgUnitID, Date reqDate, int offset, int forwardDaysOffset, int backwardDaysOffset, String strSelect, String strFrom, String strWhere, boolean iswriteOffDefaultTrackNumber) throws BOSException, EASBizException {
        StringBuffer sql_queryReq = new StringBuffer();
        String startDate = "";
        String endDate = "";
        switch (offset) {
            case 10320: {
                startDate = dateFormat.format(this.getDate(reqDate, forwardDaysOffset, false));
                sql_queryReq.append("select * from (");
                sql_queryReq.append(strSelect).append("\n  ");
                sql_queryReq.append(strFrom).append(strWhere);
                sql_queryReq.append(" \n and to_char(fRequireDate,'yyyy-mm-dd') >='").append(startDate);
                sql_queryReq.append("' \n and to_char(fRequireDate,'yyyy-mm-dd') <='").append(dateFormat.format(reqDate) + "') as A ");
                if (iswriteOffDefaultTrackNumber) {
                    sql_queryReq.append(" \n ORDER BY fOrder2 ASC,fRequireDate DESC, fcreateTime ASC  ");
                    break;
                }
                sql_queryReq.append(" \n ORDER BY fRequireDate DESC, fcreateTime ASC ");
                break;
            }
            case 10330: {
                endDate = dateFormat.format(this.getDate(reqDate, backwardDaysOffset, true));
                sql_queryReq.append("select * from (");
                sql_queryReq.append(strSelect).append("\n ");
                sql_queryReq.append(strFrom).append(strWhere);
                sql_queryReq.append(" \n and to_char(fRequireDate,'yyyy-mm-dd') >='").append(dateFormat.format(reqDate));
                sql_queryReq.append("' \n and to_char(fRequireDate,'yyyy-mm-dd') <='").append(endDate).append("') as A ");
                if (iswriteOffDefaultTrackNumber) {
                    sql_queryReq.append(" \n ORDER BY fOrder2 ASC,fRequireDate ASC, fcreateTime ASC ");
                    break;
                }
                sql_queryReq.append(" \n ORDER BY fRequireDate ASC, fcreateTime ASC ");
                break;
            }
            case 10340: {
                startDate = dateFormat.format(this.getDate(reqDate, forwardDaysOffset, false));
                endDate = dateFormat.format(this.getDate(reqDate, backwardDaysOffset, true));
                sql_queryReq.append("select * from (");
                sql_queryReq.append(strSelect).append("\n,fRequireDate - to_date('").append(startDate).append("') as fOrder3 ");
                sql_queryReq.append(strFrom).append(strWhere);
                sql_queryReq.append(" \n and to_char(fRequireDate,'yyyy-mm-dd') >='").append(startDate);
                sql_queryReq.append("' \n and to_char(fRequireDate,'yyyy-mm-dd') <='").append(dateFormat.format(reqDate)).append("' ");
                sql_queryReq.append(" \n union all ");
                sql_queryReq.append(strSelect).append("\n ,to_date('").append(dateFormat.format(reqDate)).append("')-fRequireDate  as fOrder3 ");
                sql_queryReq.append(strFrom).append(strWhere);
                sql_queryReq.append(" \n and to_char(fRequireDate,'yyyy-mm-dd') >'").append(dateFormat.format(reqDate));
                sql_queryReq.append("' \n and to_char(fRequireDate,'yyyy-mm-dd') <='").append(endDate + "') as A ");
                if (iswriteOffDefaultTrackNumber) {
                    sql_queryReq.append(" \n ORDER BY fOrder2 ASC,fOrder3 DESC, fcreateTime ASC");
                    break;
                }
                sql_queryReq.append(" \n ORDER BY fOrder3 DESC, fcreateTime ASC");
                break;
            }
            case 10350: {
                startDate = dateFormat.format(this.getDate(reqDate, forwardDaysOffset, false));
                endDate = dateFormat.format(this.getDate(reqDate, backwardDaysOffset, true));
                sql_queryReq.append("select * from (");
                sql_queryReq.append(strSelect).append("\n ,fRequireDate - to_date('").append(endDate).append("') as fOrder3 ");
                sql_queryReq.append(strFrom).append(strWhere);
                sql_queryReq.append(" \n and to_char(fRequireDate,'yyyy-mm-dd') >='").append(dateFormat.format(reqDate));
                sql_queryReq.append("' \n and to_char(fRequireDate,'yyyy-mm-dd') <= '").append(endDate + "' ");
                sql_queryReq.append(" \n union all ");
                sql_queryReq.append(strSelect).append("\n  ,to_date('").append(dateFormat.format(reqDate)).append("')-fRequireDate as fOrder3 ");
                sql_queryReq.append(strFrom).append(strWhere);
                sql_queryReq.append(" \n and to_char(fRequireDate,'yyyy-mm-dd') >= '").append(startDate);
                sql_queryReq.append("' \n and to_char(fRequireDate,'yyyy-mm-dd') < '").append(dateFormat.format(reqDate) + "') as A ");
                if (iswriteOffDefaultTrackNumber) {
                    sql_queryReq.append(" \n ORDER BY fOrder2 ASC,fOrder3 ASC,fcreateTime ASC ");
                    break;
                }
                sql_queryReq.append(" \n ORDER BY fOrder3 ASC, fcreateTime ASC");
                break;
            }
        }
        return sql_queryReq.toString();
    }

    private String getCntFilter(Context ctx, ReqPlanUpdateDataVO dataVO) throws BOSException, EASBizException {
        StringBuffer strSelect = new StringBuffer();
        StringBuffer strWhere = new StringBuffer();
        String sql_queryReq = null;
        String orgUnitID = dataVO.getStorageOrgUnitID();
        String materialID = dataVO.getMaterialID();
        int offsetMode = dataVO.getOffsetMode();
        int forwardDaysOffset = dataVO.getForwardDaysOffset();
        int backwardDaysOffset = dataVO.getBackwardDaysOffset();
        Date reqDate = dataVO.getRequireDate();
        String requirementTypeInfo = dataVO.getRequirementTypeInfo();
        String reductionMode = dataVO.getReductionMode();
        String projectID = dataVO.getProjectID();
        String trackNumberID = dataVO.getTrackNumberID();
        String manufactureStrategy = dataVO.getManuStrategyID();
        String etoConsumePioValue = dataVO.getEtoConsumeRuleValue();
        String defaultTrackNumber = dataVO.getDefaultTrackNumber();
        BigDecimal qty = dataVO.getQty();
        boolean iswriteOffDefaultTrackNumber = dataVO.getIswriteOffDefaultTrackNumber();
        boolean isATOwriteOffDefaultTrackNumber = dataVO.getIswriteOffDefaultTrackNumber();
        String reductionModeByTime = "0";
        String reductionModeByMaterail = "1";
        String reductionModeByMonth = "2";
        isATOwriteOffDefaultTrackNumber = (manufactureStrategy.equals("qAYfaBzTrmLgQKjAYj0f3dg0uEU=") || manufactureStrategy.equals("qAYbemEdG9ngQKjAYj0V1dg0uEU=")) && iswriteOffDefaultTrackNumber;
        String sourceReqType = dataVO.getSourceReqTypeInfo();
        strSelect.append("select fID,fQty,fBaseQty,fCntactTotalQty,fBaseCntactTotalQty,fRequireDate,fMaterialID,fcreateTime ");
        String strFrom = " from t_mm_RequirementPlan ";
        strWhere.append(" where fStorageOrgUnitID = '").append(orgUnitID);
        strWhere.append("' and fMaterialID = '").append(materialID).append("'");
        if (qty.compareTo(new BigDecimal("0.0")) > 0) {
            strWhere.append(" and fStatus =  ").append(10);
            strWhere.append(" and fQty>fCntactTotalQty ");
        }
        if (requirementTypeInfo.equals("NcvxPgEcEADgAAiqwKgL09hs+cg=")) {
            if (isATOwriteOffDefaultTrackNumber) {
                strSelect.append(", (case when FTrackNumberID = '").append(trackNumberID).append("' then 1 else 2 end ) as Forder2 ");
            }
            strWhere.append(" and fReqTypeID = '").append("NcvxPgEcEADgAAiqwKgL09hs+cg=").append("'");
            if (isATOwriteOffDefaultTrackNumber) {
                strWhere.append(" and (FTrackNumberID = '").append(trackNumberID).append("' or FTrackNumberID is null or FTrackNumberID = '").append(defaultTrackNumber).append("')");
            } else if (manufactureStrategy.equals("qAYfaBzTrmLgQKjAYj0f3dg0uEU=") || manufactureStrategy.equals("qAYbemEdG9ngQKjAYj0V1dg0uEU=")) {
                if (trackNumberID != null && trackNumberID.trim().length() > 0 && !trackNumberID.equals(defaultTrackNumber)) {
                    strWhere.append(" and FTrackNumberID = '").append(trackNumberID).append("' ");
                } else {
                    strWhere.append(" and ( FTrackNumberID is null or FTrackNumberID = '").append(defaultTrackNumber).append("')");
                }
            }
            sql_queryReq = this.getCntFilter(ctx, orgUnitID, reqDate, offsetMode, forwardDaysOffset, backwardDaysOffset, strSelect.toString(), strFrom, strWhere.toString(), isATOwriteOffDefaultTrackNumber);
        } else if (requirementTypeInfo.equals("NcvxPgEcEADgAAiowKgL09hs+cg=")) {
            StringBuffer trackNumberSb = new StringBuffer();
            if (isATOwriteOffDefaultTrackNumber) {
                strSelect.append(", (case when FTrackNumberID = '").append(trackNumberID).append("' then 1 else 2 end ) as Forder2 ");
            }
            trackNumberSb.append(" and fReqTypeID = '").append("NcvxPgEcEADgAAiowKgL09hs+cg=").append("'");
            if (isATOwriteOffDefaultTrackNumber) {
                trackNumberSb.append(" and (FTrackNumberID = '").append(trackNumberID).append("' or FTrackNumberID is null or FTrackNumberID = '").append(defaultTrackNumber).append("')");
            } else if (manufactureStrategy.equals("qAYfaBzTrmLgQKjAYj0f3dg0uEU=") || manufactureStrategy.equals("qAYbemEdG9ngQKjAYj0V1dg0uEU=")) {
                if (trackNumberID != null && trackNumberID.trim().length() > 0 && !trackNumberID.equals(defaultTrackNumber)) {
                    trackNumberSb.append(" and FTrackNumberID = '").append(trackNumberID).append("' ");
                } else {
                    trackNumberSb.append(" and ( FTrackNumberID is null or FTrackNumberID = '").append(defaultTrackNumber).append("')");
                }
            }
            if ("LIggukxnQ0eNvHc34XGmuNhs+cg=".equals(sourceReqType)) {
                strWhere.append(trackNumberSb.toString());
                sql_queryReq = this.getCntFilter(ctx, orgUnitID, reqDate, offsetMode, forwardDaysOffset, backwardDaysOffset, strSelect.toString(), strFrom, strWhere.toString(), isATOwriteOffDefaultTrackNumber);
            }
            strWhere.append(" and fReqTypeID = '").append("NcvxPgEcEADgAAiowKgL09hs+cg=").append("'");
            String strOrderBy = null;
            strOrderBy = isATOwriteOffDefaultTrackNumber ? " order by Forder2,fRequireDate,fcreateTime " : " order by fRequireDate,fcreateTime ";
            if (reductionModeByTime.equals(reductionMode) && !"LIggukxnQ0eNvHc34XGmuNhs+cg=".equals(sourceReqType)) {
                strWhere.append(trackNumberSb.toString());
                sql_queryReq = strSelect.toString() + strFrom.toString() + strWhere.toString() + strOrderBy + " ASC ";
            } else if (reductionModeByMaterail.equals(reductionMode) && !"LIggukxnQ0eNvHc34XGmuNhs+cg=".equals(sourceReqType)) {
                strWhere.append(trackNumberSb.toString());
                sql_queryReq = this.getCntFilter(ctx, orgUnitID, reqDate, offsetMode, forwardDaysOffset, backwardDaysOffset, strSelect.toString(), strFrom.toString(), strWhere.toString(), isATOwriteOffDefaultTrackNumber);
            } else if (reductionModeByMonth.equals(reductionMode) && !"LIggukxnQ0eNvHc34XGmuNhs+cg=".equals(sourceReqType)) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(reqDate);
                strWhere.append(" and year(fRequireDate) = ").append(calendar.get(1)).append("  and month(fRequireDate) = ").append(calendar.get(2) + 1);
                strWhere.append(trackNumberSb.toString());
                sql_queryReq = strSelect.toString() + strFrom.toString() + strWhere.toString() + strOrderBy;
            }
        } else if (requirementTypeInfo.equals("s0fDJAEoEADgAABCfwAAAdhs+cg=")) {
            StringBuffer sql_orderby = new StringBuffer();
            if (iswriteOffDefaultTrackNumber && "NcvxPgEcEADgAAiwwKgL09hs+cg=".equals(sourceReqType)) {
                strSelect.append(", (case when FTrackNumberID = '").append(trackNumberID).append("' then 1 else 2 end ) as Forder2 ");
            }
            strWhere.append(" and fReqTypeID = '").append("s0fDJAEoEADgAABCfwAAAdhs+cg=").append("'");
            if ("ITEM_TRACKNO".equalsIgnoreCase(etoConsumePioValue) || "NONE".equalsIgnoreCase(etoConsumePioValue)) {
                if (trackNumberID != null && trackNumberID.trim().length() > 0) {
                    if (iswriteOffDefaultTrackNumber && "NcvxPgEcEADgAAiwwKgL09hs+cg=".equals(sourceReqType)) {
                        strWhere.append(" and (FTrackNumberID = '").append(trackNumberID).append("' or FTrackNumberID is null or FTrackNumberID = '").append(defaultTrackNumber).append("')");
                    } else {
                        strWhere.append(" and FTrackNumberID = '").append(trackNumberID).append("' ");
                    }
                } else {
                    strWhere.append(" and ( FTrackNumberID is null or FTrackNumberID = '").append(defaultTrackNumber).append("')");
                }
                if (manufactureStrategy.equals("qAXoUB/uBg/gQKjAYj0WQ9g0uEU=") || manufactureStrategy.equals("GE2FIa4GQ6uhdx0RDGuibtg0uEU=")) {
                    if (projectID != null && projectID.trim().length() > 0) {
                        strWhere.append(" and FProjectID = '").append(projectID).append("'");
                    } else {
                        strWhere.append(" and FProjectID is null ");
                    }
                }
            } else if ("ITEM".equalsIgnoreCase(etoConsumePioValue)) {
                if (projectID != null && projectID.trim().length() > 0) {
                    strWhere.append(" and FProjectID = '").append(projectID).append("'");
                } else {
                    strWhere.append(" and FProjectID is null ");
                }
                iswriteOffDefaultTrackNumber = false;
            }
            if (iswriteOffDefaultTrackNumber && "NcvxPgEcEADgAAiwwKgL09hs+cg=".equals(sourceReqType)) {
                sql_orderby.append(" order by Forder2 ASC ,fRequireDate ASC ,fcreateTime ASC");
            } else {
                sql_orderby.append(" order by fRequireDate ASC ,fcreateTime ASC");
            }
            if (reductionModeByTime.equals(reductionMode) && !"NcvxPgEcEADgAAiwwKgL09hs+cg=".equals(sourceReqType)) {
                sql_queryReq = strSelect.toString() + strFrom + strWhere.toString() + sql_orderby.toString();
            } else if (reductionModeByMaterail.equals(reductionMode) || "NcvxPgEcEADgAAiwwKgL09hs+cg=".equals(sourceReqType)) {
                if (!"NcvxPgEcEADgAAiwwKgL09hs+cg=".equals(sourceReqType)) {
                    iswriteOffDefaultTrackNumber = false;
                }
                sql_queryReq = this.getCntFilter(ctx, orgUnitID, reqDate, offsetMode, forwardDaysOffset, backwardDaysOffset, strSelect.toString(), strFrom.toString(), strWhere.toString(), iswriteOffDefaultTrackNumber);
            } else if (reductionModeByMonth.equals(reductionMode) && !"NcvxPgEcEADgAAiwwKgL09hs+cg=".equals(sourceReqType)) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(reqDate);
                strWhere.append(" and year(fRequireDate) = ").append(calendar.get(1)).append("  and month(fRequireDate) = ").append(calendar.get(2) + 1);
                sql_queryReq = strSelect.toString() + strFrom.toString() + strWhere.toString() + sql_orderby.toString();
            }
        }
        return sql_queryReq;
    }

    protected void writeOffReq(Context ctx, ReqPlanUpdateDataVO dataVO) throws BOSException, EASBizException {
        String reqID = dataVO.getId();
        String billID = dataVO.getBillID();
        String billNum = dataVO.getBillNumber();
        String billEntryID = dataVO.getBillEntryID();
        String billTypeID = dataVO.getBillTypeID();
        String unitID = dataVO.getUnitID();
        String baseUnitID = dataVO.getBaseUnitID();
        BigDecimal notCntQty = dataVO.getQty();
        BigDecimal baseNotCntQty = dataVO.getBaseQty();
        String materialId = dataVO.getMaterialID();
        String sql_queryReq = this.getCntFilter(ctx, dataVO);
        IRowSet reqRow = DbUtil.executeQuery((Context)ctx, (String)sql_queryReq);
        boolean isRubric = false;
        if (notCntQty.compareTo(new BigDecimal("0.0")) < 0) {
            isRubric = true;
        }
        Connection conn = null;
        PreparedStatement stmtUpdate = null;
        PreparedStatement stmtInsert = null;
        String sql_updatePIC = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            StringBuffer sql_writeOffRelation = new StringBuffer();
            sql_writeOffRelation.append("insert into T_MM_ReqCounteractRelation ");
            sql_writeOffRelation.append("(FID,FSourceID,FSourceEntryID,FDestID,FBillTypeID,FQty,FBaseQty,FUnitID,FBaseUnitID,FSeq,FSourceNumber,fmaterialId)");
            sql_writeOffRelation.append(" values(?,?,?,?,?,?,?,?,?,?,?,?)");
            sql_updatePIC = !isRubric ? "update T_MM_RequirementPlan set fCntactTotalQty= fQty,fBaseCntactTotalQty= fBaseQty,fStatus = 20 where fID = ?" : "update T_MM_RequirementPlan set fCntactTotalQty= 0,fBaseCntactTotalQty= 0,fStatus = 10 where fID = ?";
            stmtUpdate = conn.prepareStatement(sql_updatePIC.toString());
            stmtInsert = conn.prepareStatement(sql_writeOffRelation.toString());
            int seq = 1;
            while (reqRow.next()) {
                String pidReqID = reqRow.getString("fID");
                BigDecimal picQty = reqRow.getBigDecimal("fQty");
                BigDecimal basePicQty = reqRow.getBigDecimal("fBaseQty");
                BigDecimal picCntactQty = reqRow.getBigDecimal("fCntactTotalQty");
                BigDecimal basePicCntactQty = reqRow.getBigDecimal("fBaseCntactTotalQty");
                if (!isRubric && notCntQty.compareTo(picQty.subtract(picCntactQty)) >= 0 || isRubric && notCntQty.add(picCntactQty).compareTo(new BigDecimal("0.0")) < 0) {
                    stmtUpdate.setString(1, pidReqID);
                    stmtUpdate.addBatch();
                    stmtInsert.setString(1, BOSUuid.create((String)"D02F7535").toString());
                    stmtInsert.setString(2, billID);
                    stmtInsert.setString(3, billEntryID);
                    stmtInsert.setString(4, pidReqID);
                    stmtInsert.setString(5, billTypeID);
                    stmtInsert.setString(8, unitID);
                    stmtInsert.setString(9, baseUnitID);
                    stmtInsert.setInt(10, seq++);
                    stmtInsert.setString(11, billNum);
                    stmtInsert.setString(12, materialId);
                    if (!isRubric) {
                        notCntQty = notCntQty.subtract(picQty.subtract(picCntactQty));
                        baseNotCntQty = baseNotCntQty.subtract(basePicQty.subtract(basePicCntactQty));
                        stmtInsert.setBigDecimal(6, picQty.subtract(picCntactQty));
                        stmtInsert.setBigDecimal(7, basePicQty.subtract(basePicCntactQty));
                        stmtInsert.addBatch();
                        if (notCntQty.compareTo(new BigDecimal("0.00")) <= 0) {
                            break;
                        }
                    } else {
                        stmtInsert.setBigDecimal(6, picCntactQty.negate());
                        stmtInsert.setBigDecimal(7, basePicQty.negate());
                        notCntQty = notCntQty.add(picCntactQty);
                        baseNotCntQty = baseNotCntQty.add(basePicCntactQty);
                        stmtInsert.addBatch();
                        if (notCntQty.compareTo(new BigDecimal("0.00")) >= 0) break;
                    }
                    ++seq;
                    continue;
                }
                sql_updatePIC = "update T_MM_RequirementPlan set fCntactTotalQty= fCntactTotalQty+" + notCntQty + ",fBaseCntactTotalQty= fBaseCntactTotalQty+" + baseNotCntQty + " where fID = '" + pidReqID + "'";
                DbUtil.execute((Context)ctx, (String)sql_updatePIC);
                Object[] params = new Object[]{BOSUuid.create((String)"D02F7535").toString(), billID, billEntryID, pidReqID, billTypeID, notCntQty, baseNotCntQty, unitID, baseUnitID, new Integer(seq++), billNum, materialId};
                DbUtil.execute((Context)ctx, (String)sql_writeOffRelation.toString(), (Object[])params);
                notCntQty = new BigDecimal(0.0);
                baseNotCntQty = new BigDecimal(0.0);
                break;
            }
            if (seq > 1) {
                stmtUpdate.executeBatch();
                stmtInsert.executeBatch();
            }
            if ("NcvxPgEcEADgAAiqwKgL09hs+cg=".equals(dataVO.getRequirementTypeInfo()) || "s0fDJAEoEADgAABCfwAAAdhs+cg=".equals(dataVO.getRequirementTypeInfo()) || "NcvxPgEcEADgAAiowKgL09hs+cg=".equals(dataVO.getRequirementTypeInfo())) {
                String sql_updateSID = "update T_MM_RequirementPlan set fNotCntactQty = ?,fBaseNotCntactQty = ? where fID = ?";
                DbUtil.execute((Context)ctx, (String)sql_updateSID, (Object[])new Object[]{notCntQty, baseNotCntQty, reqID});
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                com.kingdee.util.db.SQLUtils.cleanup(stmtUpdate, (Connection)conn);
                com.kingdee.util.db.SQLUtils.cleanup(stmtInsert);
                throw throwable;
            }
        }
        com.kingdee.util.db.SQLUtils.cleanup((Statement)stmtUpdate, (Connection)conn);
        com.kingdee.util.db.SQLUtils.cleanup((Statement)stmtInsert);
    }

    private void beforewriteOff(Context ctx, String storageOrgUnitID) throws BOSException {
        StringBuffer str = new StringBuffer();
        str.append(" update T_MM_ReqPlanData  as r1 set (FisOrderToOrder , FWriteOffPlanType ) = ");
        str.append(" ( select 0 as FisOrderToOrder,  t1.FWriteOffPlanType from ");
        str.append(" (select t.fid, (case when t.fManufactureStrategyID in( '").append("NUnM+gEcEADgAA3gwKgL09g0uEU=").append("','");
        str.append("qAYbemEdG9ngQKjAYj0V1dg0uEU=").append("','");
        str.append("qAYfaBzTrmLgQKjAYj0f3dg0uEU=").append("','");
        str.append("qAYfaBzUrmLgQKjAYj0f3dg0uEU=");
        str.append("') then ").append(1).append(" when t.fManufactureStrategyID in ('");
        str.append("qAXoUB/tBg/gQKjAYj0WQ9g0uEU=").append("','");
        str.append("fpPxtypCS/ihJ30GjB/UJtg0uEU=").append("','");
        str.append("qAXoUB/uBg/gQKjAYj0WQ9g0uEU=").append("','");
        str.append("GE2FIa4GQ6uhdx0RDGuibtg0uEU=");
        str.append("') then  ").append(3).append(" else t.FWriteOffPlanType  end ) as FWriteOffPlanType ");
        str.append(" from T_MM_ReqPlanData as t left join T_MM_RequirementPlan as r on ");
        str.append(" r.fSourceEntryID = t.FSrcOfSourceEntryID ");
        str.append(" where r.fSourceEntryID is null and t.FWriteOffPlanType in(").append(2);
        str.append(",").append(5);
        str.append(") and t.fstorageorgunitid = '").append(storageOrgUnitID);
        str.append("'  and  t.fisNowWriteOff  = 1 ) as t1 ");
        str.append(" where t1.fid = r1.fid )");
        DbUtil.execute((Context)ctx, (String)str.toString());
        str.setLength(0);
        str.append(" delete from T_MM_ReqPlanData where fid in (select t.fid  from T_MM_ReqPlanData as t ");
        str.append(" inner join T_MM_CounteractSet as c on c.fStorageOrgUnitID = t.fstorageorgunitid ");
        str.append(" where   t.FBillTypeID=c.FBillTypeID and t.fManufactureStrategyID = c.fManuStrategyID  ");
        str.append(" and t.fstorageOrgUnitID = '").append(storageOrgUnitID).append("'");
        str.append(" and c.FIsCounteractPID = 0 and t.FisOrderToOrder = 0 )");
        DbUtil.execute((Context)ctx, (String)str.toString());
    }

    private String getDefaultTrackNumber(Context ctx, String cuID) throws BOSException {
        String defaultTrackNumber = null;
        TrackNumberInfo trackNumberInfo = new TrackNumberInfo();
        StringBuffer checkSql = new StringBuffer("");
        checkSql.append("select fid from T_MM_TrackNumber\n").append(" where FDefaultTraceNumberFlag = 1\n").append(" and (FADMINCUID = '").append(cuID).append("' or FID in( select FDataBaseDID FROM T_BD_DataBaseDAssign WHERE FBOSObjectType = '").append(trackNumberInfo.getBOSType()).append("' AND FAssignCUID='").append(cuID).append("'))");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)checkSql.toString());
        try {
            if (rs.next()) {
                defaultTrackNumber = rs.getString("fid");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return defaultTrackNumber;
    }

    private void manulwriteOffPICReq(Context ctx, HashMap map) throws BOSException, EASBizException {
        String picPlanID = (String)map.get("picPlanID");
        BigDecimal totalQty = (BigDecimal)map.get("totalQty");
        BigDecimal totalBaseQty = (BigDecimal)map.get("totalBaseQty");
        ArrayList dataList = (ArrayList)map.get("dataList");
        ArrayList idList = (ArrayList)map.get("idList");
        String ids = MMUtils.listToString((List)idList);
        StringBuffer updateSID = new StringBuffer();
        StringBuffer updateDetail = new StringBuffer();
        StringBuffer insertDetail = new StringBuffer();
        StringBuffer updatePIC = new StringBuffer();
        updatePIC.append(" update T_MM_RequirementPlan set ");
        updatePIC.append(" FCntactTotalQty = ( FCntactTotalQty + ? ),");
        updatePIC.append(" FBaseCntactTotalQty = (FBaseCntactTotalQty + ? ),");
        updatePIC.append(" FStatus =  case when fQty > (FCntactTotalQty + ?  ) and fclosetype <> 20 then 10 else 20 end ");
        updatePIC.append("where fid = ?");
        DbUtil.execute((Context)ctx, (String)updatePIC.toString(), (Object[])new Object[]{totalQty, totalBaseQty, totalQty, picPlanID});
        insertDetail.append("insert into T_MM_ReqCounteractRelation ");
        insertDetail.append("(FID,FSourceID,FSourceEntryID,FDestID,FBillTypeID,FQty,");
        insertDetail.append("FBaseQty,FUnitID,FBaseUnitID,FSeq,FSourceNumber,fmaterialId)");
        insertDetail.append(" ( select newbosid('D02F7535'),r.FSourceBillID,r.FSourceEntryID,'");
        insertDetail.append(picPlanID).append("',r.FBillTypeID,");
        insertDetail.append(" 0,0,r.FUnitID,r.FBaseUnitID,0,r.FSourceBillNum,r.FMaterialID ");
        insertDetail.append(" from T_MM_RequirementPlan as r ");
        insertDetail.append(" where r.fid in(").append(ids);
        insertDetail.append(")  and r.FSourceEntryID not in  ( select r1.FSourceEntryID");
        insertDetail.append(" from T_MM_RequirementPlan as r1 inner join T_MM_ReqCounteractRelation as rc ");
        insertDetail.append(" on r1.FSourceEntryID = rc.FSourceEntryID ");
        insertDetail.append(" where rc.FDestID = '").append(picPlanID);
        insertDetail.append("'))");
        DbUtil.execute((Context)ctx, (String)insertDetail.toString());
        Connection conn = null;
        PreparedStatement stmtUpdateSid = null;
        PreparedStatement stmtUpdate = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            updateSID.append(" update T_MM_RequirementPlan set FNotCntactQty = FNotCntactQty - ?, ");
            updateSID.append(" FBaseNotCntactQty = FBaseNotCntactQty - ? ");
            updateSID.append(" where fid = ? ");
            updateDetail.append(" update T_MM_ReqCounteractRelation set FQty =FQty+?, FBaseQty = FBaseQty+?");
            updateDetail.append(" where FDestID = ? and FSourceEntryID  = ? ");
            String sql_t = updateSID.toString();
            String sql_t2 = updateDetail.toString();
            stmtUpdateSid = conn.prepareStatement(sql_t);
            stmtUpdate = conn.prepareStatement(sql_t2);
            for (int i = 0; i < dataList.size(); ++i) {
                ReqPlanManulWriteOffDataVO data = (ReqPlanManulWriteOffDataVO)dataList.toArray()[i];
                stmtUpdateSid.setBigDecimal(1, data.getQty());
                stmtUpdateSid.setBigDecimal(2, data.getBaseQty());
                stmtUpdateSid.setString(3, data.getId());
                stmtUpdate.setBigDecimal(1, data.getQty());
                stmtUpdate.setBigDecimal(2, data.getBaseQty());
                stmtUpdate.setString(3, picPlanID);
                stmtUpdate.setString(4, data.getBillEntryID());
                stmtUpdateSid.addBatch();
                stmtUpdate.addBatch();
            }
            stmtUpdateSid.executeBatch();
            stmtUpdate.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                com.kingdee.util.db.SQLUtils.cleanup(stmtUpdateSid, (Connection)conn);
                com.kingdee.util.db.SQLUtils.cleanup(stmtUpdate, (Connection)conn);
                throw throwable;
            }
        }
        com.kingdee.util.db.SQLUtils.cleanup((Statement)stmtUpdateSid, (Connection)conn);
        com.kingdee.util.db.SQLUtils.cleanup((Statement)stmtUpdate, (Connection)conn);
    }

    private void manulreversewriteOffPICReq(Context ctx, HashMap map) throws BOSException, EASBizException {
        String picPlanID = (String)map.get("picPlanID");
        BigDecimal totalQty = (BigDecimal)map.get("totalQty");
        BigDecimal totalBaseQty = (BigDecimal)map.get("totalBaseQty");
        ArrayList dataList = (ArrayList)map.get("dataList");
        StringBuffer updateSID = new StringBuffer();
        StringBuffer updateDetail = new StringBuffer();
        StringBuffer deleteDetail = new StringBuffer();
        StringBuffer updatePIC = new StringBuffer();
        updatePIC.append("update T_MM_RequirementPlan set ( FCntactTotalQty,FBaseCntactTotalQty,FStatus) = ");
        updatePIC.append("(SELECT case when FCntactTotalQty < ").append(totalQty.toPlainString());
        updatePIC.append("  then 0 else FCntactTotalQty - ").append(totalQty.toPlainString()).append(" end, ");
        updatePIC.append(" case when FBaseCntactTotalQty < ").append(totalBaseQty.toPlainString());
        updatePIC.append(" then 0 else FBaseCntactTotalQty - ").append(totalBaseQty.toPlainString()).append(" end, ");
        updatePIC.append(" case when fQty > (FCntactTotalQty - ").append(totalQty.toPlainString());
        updatePIC.append("                   ) and fclosetype <> 20 then 10 else 20 end ");
        updatePIC.append(" from T_MM_RequirementPlan where fid = ? ) where fid = ? ");
        SQLUtils.execute((Context)ctx, (String)updatePIC.toString(), (Object[])new Object[]{picPlanID, picPlanID});
        Connection conn = null;
        PreparedStatement stmtUpdateSid = null;
        PreparedStatement stmtUpdate = null;
        PreparedStatement stmtdelete = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            updateSID.append(" update T_MM_RequirementPlan set FNotCntactQty =FNotCntactQty + ?,FBaseNotCntactQty = ");
            updateSID.append("FBaseNotCntactQty + ? ");
            updateSID.append(" where FSourceEntryID = ? ");
            updateDetail.append(" update T_MM_ReqCounteractRelation set FQty = FQty-?, FBaseQty = ");
            updateDetail.append("FBaseQty-? ");
            updateDetail.append(" where FDestID = ? and FSourceEntryID  = ? and  FQty>?");
            deleteDetail.append(" delete from  T_MM_ReqCounteractRelation  ");
            deleteDetail.append(" where FDestID = ? and FSourceEntryID  = ? and  FQty<=?");
            stmtUpdateSid = conn.prepareStatement(updateSID.toString());
            stmtUpdate = conn.prepareStatement(updateDetail.toString());
            stmtdelete = conn.prepareStatement(deleteDetail.toString());
            for (int i = 0; i < dataList.size(); ++i) {
                ReqPlanManulWriteOffDataVO data = (ReqPlanManulWriteOffDataVO)dataList.toArray()[i];
                stmtUpdateSid.setBigDecimal(1, data.getQty());
                stmtUpdateSid.setBigDecimal(2, data.getBaseQty());
                stmtUpdateSid.setString(3, data.getBillEntryID());
                stmtUpdate.setBigDecimal(1, data.getQty());
                stmtUpdate.setBigDecimal(2, data.getBaseQty());
                stmtUpdate.setString(3, picPlanID);
                stmtUpdate.setString(4, data.getBillEntryID());
                stmtUpdate.setBigDecimal(5, data.getQty());
                stmtdelete.setString(1, picPlanID);
                stmtdelete.setString(2, data.getBillEntryID());
                stmtdelete.setBigDecimal(3, data.getQty());
                stmtUpdate.addBatch();
                stmtdelete.addBatch();
                stmtUpdateSid.addBatch();
            }
            stmtUpdateSid.executeBatch();
            stmtdelete.executeBatch();
            stmtUpdate.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                com.kingdee.util.db.SQLUtils.cleanup(stmtUpdateSid, (Connection)conn);
                com.kingdee.util.db.SQLUtils.cleanup(stmtUpdate);
                com.kingdee.util.db.SQLUtils.cleanup(stmtdelete);
                throw throwable;
            }
        }
        com.kingdee.util.db.SQLUtils.cleanup((Statement)stmtUpdateSid, (Connection)conn);
        com.kingdee.util.db.SQLUtils.cleanup((Statement)stmtUpdate);
        com.kingdee.util.db.SQLUtils.cleanup((Statement)stmtdelete);
    }

    @Override
    protected void _manulwriteOffPICReq(Context ctx, boolean isWriteOff, HashMap map) throws BOSException, EASBizException {
        if (isWriteOff) {
            this.manulwriteOffPICReq(ctx, map);
        } else {
            this.manulreversewriteOffPICReq(ctx, map);
        }
    }

    private void WriteOffPICReq(Context ctx, String storageOrgUnitID) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append(" insert into T_MM_ReqCounteractRelation ");
        sql.append(" (fID,fmaterialId,fSourceID,fSourceEntryID,fDestID,fBillTypeID,fQty,fBaseQty,fUnitID,fBaseUnitID,fSeq,FSourceNumber)");
        sql.append(" (select newbosid('D02F7535') as fid,t.fmaterialId, t.fSourceBillID as fSourceID ,t.fSourceEntryID as fSourceEntryID,");
        sql.append(" r.fid as fDestID,t.fBillTypeID as fBillTypeID,");
        sql.append(" (case when (r.fQTy-r.fCntactTotalQty) >t.fqty then t.fqty else  (r.fQTy-r.fCntactTotalQty) end ) as fqty,");
        sql.append(" (case when (r.fBaseQty-r.fBaseCntactTotalQty) >t.fqty then t.fBaseQty else  (r.fBaseQty-r.fBaseCntactTotalQty) end ) as fBaseQty,");
        sql.append(" t.fUnitID as fUnitID,t.fBaseUnitID as fBaseUnitID, ? as fSeq ,t.fsrcNumber as FSourceNumber ");
        sql.append(" from t_mm_RequirementPlan as r inner join T_MM_ReqPlanData as t on r.fid = t.FSrcOfSourceEntryID ");
        sql.append(" and r.fmaterialId = t.fmaterialId  ");
        sql.append(" where  t.FSTORAGEORGUNITID = ? and  isnull(r.FTrackNumberID,' ') = isnull(t.FTrackNumberID,' ') and t.fisWriteOff = 1  and t.FaddPlanType = '").append("NcvxPgEcEADgAAiswKgL09hs+cg=");
        sql.append("' and r.FReqTypeID = '").append("NcvxPgEcEADgAAiqwKgL09hs+cg=").append("'");
        sql.append(" and  t.fisNowWriteOff  = 1 )");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{new Integer(1), storageOrgUnitID});
        sql.setLength(0);
        sql.append(" update t_mm_RequirementPlan as r1 set (fCntactTotalQty,fBaseCntactTotalQty,FStatus) = ");
        sql.append(" (select (r1.fCntactTotalQty + t1.fqty ) as fCntactTotalQty,(t1.fbaseqty+r1.fBaseCntactTotalQty) as  fBaseCntactTotalQty,");
        sql.append(" (case when r1.fQty - (r1.fCntactTotalQty + t1.fqty)>0 and r1.fclosetype <> 20 then 10 else 20 end) as status ");
        sql.append(" from ");
        sql.append(" ( select t.FSrcOfSourceEntryID , r.fmaterialId,r.FTrackNumberID,");
        sql.append(" (case when (r.fQTy-r.fCntactTotalQty) >t.fqty then t.fqty else  (r.fQTy-r.fCntactTotalQty) end ) as fqty,");
        sql.append(" (case when (r.fBaseQty-r.fBaseCntactTotalQty) >t.fqty then t.fBaseQty else  (r.fBaseQty-r.fBaseCntactTotalQty) end ) as fBaseQty ");
        sql.append(" from T_MM_ReqPlanData as t  inner join  t_mm_RequirementPlan as r ");
        sql.append(" on   r.fid = t.FSrcOfSourceEntryID ");
        sql.append(" and r.fmaterialId = t.fmaterialId  ");
        sql.append(" where t.fisWriteOff = 1   ");
        sql.append(" and t.FaddPlanType = '").append("NcvxPgEcEADgAAiswKgL09hs+cg=");
        sql.append("' and isnull(r.FTrackNumberID,' ') = isnull(t.FTrackNumberID,' ') and  t.fisNowWriteOff  = 1 ");
        sql.append(" and r.FReqTypeID = '").append("NcvxPgEcEADgAAiqwKgL09hs+cg=").append("'");
        sql.append(" and t.FSTORAGEORGUNITID = ? ) as t1 ");
        sql.append(" where t1.FSrcOfSourceEntryID = r1.fid ");
        sql.append(" and r1.FReqTypeID = '").append("NcvxPgEcEADgAAiqwKgL09hs+cg=").append("'");
        sql.append("and t1.fmaterialId = r1.fmaterialId and  isnull(r1.FTrackNumberID,' ') = isnull(t1.FTrackNumberID,' ')) ");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{storageOrgUnitID});
        sql.setLength(0);
        sql.append("update T_MM_RequirementPlan  as r set (fNotCntactQty ,fBaseNotCntactQty) = ");
        sql.append(" (select (r.fqty-t1.fqty)  as fqty , (r.fbaseqty -t1.fbaseqty) as fbaseqty ");
        sql.append(" from (select sum(t.fqty) as fqty ,sum(t.fbaseqty) as fbaseqty, t.fSourceID,t.fSourceEntryID");
        sql.append("      from T_MM_ReqCounteractRelation as t inner join T_MM_ReqPlanData as rp on t.fSourceEntryID = rp.fSourceEntryID ");
        sql.append("      where rp.FaddPlanType = '").append("NcvxPgEcEADgAAiswKgL09hs+cg=").append("'");
        sql.append("      and rp.FSrcOfSourceEntryID is not null and rp.fisWriteOff = 1  and rp.FSTORAGEORGUNITID= ?");
        sql.append("      group by t.fSourceID, t.fSourceEntryID ) ");
        sql.append(" as t1 ");
        sql.append(" where t1.fSourceEntryID = r.fSourceEntryID )");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{storageOrgUnitID});
    }
}

