/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.JDBCExceptionHandler;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.ormapping.SQLAccessException;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.mm.basedata.BOMExtendFacadeFactory;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.basedata.app.BomMatch;
import com.kingdee.eas.mm.common.app.SQLUtils;
import com.kingdee.eas.mm.common.util.MMUtils;
import com.kingdee.eas.mm.planning.IReqSubConsumeRecordDEntry;
import com.kingdee.eas.mm.planning.IReqSubConsumeRecordEntry;
import com.kingdee.eas.mm.planning.IRequirementPlan;
import com.kingdee.eas.mm.planning.ReqPlanCloseTypeEnum;
import com.kingdee.eas.mm.planning.ReqPlanManulWriteOffDataVO;
import com.kingdee.eas.mm.planning.ReqPlanStatusEnum;
import com.kingdee.eas.mm.planning.ReqSubConsumeRecordCollection;
import com.kingdee.eas.mm.planning.ReqSubConsumeRecordDEntryCollection;
import com.kingdee.eas.mm.planning.ReqSubConsumeRecordDEntryFactory;
import com.kingdee.eas.mm.planning.ReqSubConsumeRecordDEntryInfo;
import com.kingdee.eas.mm.planning.ReqSubConsumeRecordEntryCollection;
import com.kingdee.eas.mm.planning.ReqSubConsumeRecordEntryFactory;
import com.kingdee.eas.mm.planning.ReqSubConsumeRecordEntryInfo;
import com.kingdee.eas.mm.planning.ReqSubConsumeRecordInfo;
import com.kingdee.eas.mm.planning.RequirementPlanCntDtlVo;
import com.kingdee.eas.mm.planning.RequirementPlanFactory;
import com.kingdee.eas.mm.planning.RequirementPlanInfo;
import com.kingdee.eas.mm.planning.SubConsumeEnum;
import com.kingdee.eas.mm.planning.app.AbstractReqSubConsumeRecordControllerBean;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ReqSubConsumeRecordControllerBean
extends AbstractReqSubConsumeRecordControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.planning.app.ReqSubConsumeRecordControllerBean");

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ReqSubConsumeRecordInfo curInfo = (ReqSubConsumeRecordInfo)model;
        this.initDefaultUnit4DEntry(curInfo);
        this._antiConsume(ctx, curInfo.getId().toString());
        this.syncHeadConsumedQty(ctx, curInfo);
        this.syncSIDReqPlan(ctx, curInfo);
        this.syncPIDReqPlan(ctx, curInfo, false);
        ObjectUuidPK pk = new ObjectUuidPK(curInfo.getId());
        super._save(ctx, (IObjectPK)pk, (IObjectValue)curInfo);
        return pk;
    }

    private void syncSIDReqPlan(Context ctx, ReqSubConsumeRecordInfo curInfo) throws BOSException, EASBizException {
        if (curInfo == null || curInfo.getEntrys() == null) {
            return;
        }
        SubConsumeEnum consumeEnum = SubConsumeEnum.NONE;
        boolean allequal = true;
        Iterator entryIter = curInfo.getEntrys().iterator();
        while (entryIter.hasNext()) {
            ReqSubConsumeRecordEntryInfo curEntryInfo = (ReqSubConsumeRecordEntryInfo)entryIter.next();
            if (curEntryInfo.getConsumedQty().compareTo(curEntryInfo.getReqQty()) == 0) continue;
            allequal = false;
            break;
        }
        if (allequal) {
            consumeEnum = SubConsumeEnum.OVER;
        } else {
            boolean hasworn = false;
            boolean allovered = true;
            entryIter = curInfo.getEntrys().iterator();
            while (entryIter.hasNext()) {
                ReqSubConsumeRecordEntryInfo curEntryInfo = (ReqSubConsumeRecordEntryInfo)entryIter.next();
                if (curEntryInfo.getConsumedQty().compareTo(curEntryInfo.getReqQty()) < 0) {
                    allovered = false;
                    break;
                }
                if (curEntryInfo.getConsumedQty().compareTo(curEntryInfo.getReqQty()) <= 0) continue;
                hasworn = true;
            }
            if (hasworn && allovered) {
                consumeEnum = SubConsumeEnum.WARNING;
            } else {
                boolean isconsumed = false;
                entryIter = curInfo.getEntrys().iterator();
                while (entryIter.hasNext()) {
                    ReqSubConsumeRecordEntryInfo curEntryInfo = (ReqSubConsumeRecordEntryInfo)entryIter.next();
                    if (curEntryInfo.getConsumedQty().compareTo(BigDecimal.ZERO) <= 0) continue;
                    isconsumed = true;
                    break;
                }
                if (isconsumed) {
                    consumeEnum = SubConsumeEnum.PART;
                }
            }
        }
        IRequirementPlan reqPlanBiz = RequirementPlanFactory.getLocalInstance(ctx);
        curInfo.getReqPlan().setSubConsumeStatus(consumeEnum);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("subConsumeStatus"));
        reqPlanBiz.updatePartial((CoreBaseInfo)curInfo.getReqPlan(), sic);
    }

    private void syncPIDReqPlan(Context ctx, ReqSubConsumeRecordInfo curInfo, boolean isNegative) throws EASBizException, BOSException {
        if (curInfo == null || curInfo.getEntrys() == null) {
            return;
        }
        ReqSubConsumeRecordDEntryCollection targetReqPlans = new ReqSubConsumeRecordDEntryCollection();
        Iterator entryIter = curInfo.getEntrys().iterator();
        while (entryIter.hasNext()) {
            ReqSubConsumeRecordEntryInfo curEntryInfo = (ReqSubConsumeRecordEntryInfo)entryIter.next();
            if (curEntryInfo.getDentrys() == null || curEntryInfo.getDentrys().size() <= 0) continue;
            Iterator dentryIter = curEntryInfo.getDentrys().iterator();
            while (dentryIter.hasNext()) {
                ReqSubConsumeRecordDEntryInfo curDentryInfo = (ReqSubConsumeRecordDEntryInfo)dentryIter.next();
                if (curDentryInfo.getConsumedQty() == null || curDentryInfo.getConsumedQty().compareTo(BigDecimal.ZERO) == 0) continue;
                if (isNegative) {
                    curDentryInfo.setPIDConsumeQty(curDentryInfo.getConsumedQty().negate());
                    curDentryInfo.setPIDBaseConsumeQty(curDentryInfo.getBaseConsumedQty().negate());
                } else {
                    curDentryInfo.setPIDConsumeQty(curDentryInfo.getConsumedQty());
                    curDentryInfo.setPIDBaseConsumeQty(curDentryInfo.getBaseConsumedQty());
                }
                targetReqPlans.add(curDentryInfo);
            }
        }
        if (targetReqPlans == null || targetReqPlans.size() <= 0) {
            return;
        }
        Connection conn = null;
        PreparedStatement preparedStmt = null;
        try {
            int paramIdx;
            ReqSubConsumeRecordDEntryInfo curDEntryInfo;
            conn = EJBFactory.getConnection((Context)ctx);
            preparedStmt = conn.prepareStatement("update T_MM_RequirementPlan set   FCntactTotalQty=FCntactTotalQty+?,   FBaseCntactTotalQty=FBaseCntactTotalQty+? where FID=?");
            Iterator iter = targetReqPlans.iterator();
            while (iter.hasNext()) {
                curDEntryInfo = (ReqSubConsumeRecordDEntryInfo)iter.next();
                paramIdx = 1;
                preparedStmt.setBigDecimal(paramIdx++, curDEntryInfo.getPIDConsumeQty());
                preparedStmt.setBigDecimal(paramIdx++, curDEntryInfo.getPIDBaseConsumeQty());
                preparedStmt.setString(paramIdx++, curDEntryInfo.getReqPlan().getId().toString());
                preparedStmt.addBatch();
            }
            preparedStmt.executeBatch();
            preparedStmt.clearBatch();
            preparedStmt = conn.prepareStatement("update T_MM_RequirementPlan set   FStatus = case when FCntactTotalQty>=FQty then 20 else 10 end where FID=?");
            iter = targetReqPlans.iterator();
            while (iter.hasNext()) {
                curDEntryInfo = (ReqSubConsumeRecordDEntryInfo)iter.next();
                paramIdx = 1;
                preparedStmt.setString(paramIdx++, curDEntryInfo.getReqPlan().getId().toString());
                preparedStmt.addBatch();
            }
            preparedStmt.executeBatch();
            preparedStmt.clearBatch();
        }
        catch (SQLException sqlExp) {
            try {
                throw new SQLAccessException(sqlExp.getMessage(), JDBCExceptionHandler.convertException((SQLException)sqlExp));
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(preparedStmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)preparedStmt, (Connection)conn);
    }

    private void syncHeadConsumedQty(Context ctx, ReqSubConsumeRecordInfo curInfo) throws EASBizException, BOSException {
        if (curInfo == null || curInfo.getEntrys() == null) {
            return;
        }
        Iterator entryIter = curInfo.getEntrys().iterator();
        while (entryIter.hasNext()) {
            ReqSubConsumeRecordEntryInfo curEntryInfo = (ReqSubConsumeRecordEntryInfo)entryIter.next();
            if (curEntryInfo.getDentrys() == null || curEntryInfo.getDentrys().size() <= 0) {
                curEntryInfo.setConsumedQty(BigDecimal.ZERO);
                curEntryInfo.setBaseConsumedQty(BigDecimal.ZERO);
                continue;
            }
            BigDecimal sumConsumeQty = BigDecimal.ZERO;
            BigDecimal sumBaseConsumeQty = BigDecimal.ZERO;
            Iterator dentryIter = curEntryInfo.getDentrys().iterator();
            while (dentryIter.hasNext()) {
                ReqSubConsumeRecordDEntryInfo curDentryInfo = (ReqSubConsumeRecordDEntryInfo)dentryIter.next();
                if (curDentryInfo.getConsumedQty() == null) {
                    curDentryInfo.setConsumedQty(BigDecimal.ZERO);
                }
                if (curDentryInfo.getCurConsumeQty() != null && curDentryInfo.getCurConsumeQty().compareTo(BigDecimal.ZERO) > 0) {
                    curDentryInfo.setConsumedQty(curDentryInfo.getConsumedQty().add(curDentryInfo.getCurConsumeQty()));
                    BigDecimal baseConsumedQty = SCMUtils.getExchangeQtyForServer((Context)ctx, (String)curEntryInfo.getMaterial().getId().toString(), (String)curDentryInfo.getUnit().getId().toString(), (BigDecimal)curDentryInfo.getConsumedQty(), (String)curDentryInfo.getBaseUnit().getId().toString());
                    curDentryInfo.setBaseConsumedQty(baseConsumedQty);
                    curDentryInfo.setCurConsumeQty(BigDecimal.ZERO);
                }
                sumConsumeQty = sumConsumeQty.add(curDentryInfo.getConsumedQty());
                sumBaseConsumeQty = sumBaseConsumeQty.add(curDentryInfo.getBaseConsumedQty());
            }
            curEntryInfo.setConsumedQty(sumConsumeQty);
            curEntryInfo.setBaseConsumedQty(sumBaseConsumeQty);
        }
    }

    private void initDefaultUnit4DEntry(ReqSubConsumeRecordInfo curInfo) {
        if (curInfo == null || curInfo.getEntrys() == null) {
            return;
        }
        Iterator entryIter = curInfo.getEntrys().iterator();
        while (entryIter.hasNext()) {
            ReqSubConsumeRecordEntryInfo curEntryInfo = (ReqSubConsumeRecordEntryInfo)entryIter.next();
            if (curEntryInfo.getDentrys() == null || curEntryInfo.getDentrys().size() <= 0) continue;
            Iterator dentryIter = curEntryInfo.getDentrys().iterator();
            while (dentryIter.hasNext()) {
                ReqSubConsumeRecordDEntryInfo curDentryInfo = (ReqSubConsumeRecordDEntryInfo)dentryIter.next();
                if (curDentryInfo.getReqPlan() == null) {
                    dentryIter.remove();
                    continue;
                }
                curDentryInfo.setUnit(curDentryInfo.getReqPlan().getUnit());
                curDentryInfo.setBaseUnit(curDentryInfo.getReqPlan().getBaseUnit());
            }
        }
    }

    @Override
    protected IObjectPK _refreshByReqPlanId(Context ctx, String reqPlanId) throws BOSException, EASBizException {
        ReqSubConsumeRecordInfo targetInfo = this.findByReqPlanId(ctx, reqPlanId);
        ObjectUuidPK rtnKey = null;
        if (targetInfo == null || !this.hasConsumedInfo(targetInfo)) {
            if (targetInfo != null) {
                super._delete(ctx, (IObjectPK)new ObjectUuidPK(targetInfo.getId()));
            }
            targetInfo = new ReqSubConsumeRecordInfo();
            RequirementPlanInfo reqPlan = new RequirementPlanInfo();
            reqPlan.setId(BOSUuid.read((String)reqPlanId));
            targetInfo.setReqPlan(reqPlan);
            ReqSubConsumeRecordEntryCollection entries = this.bomExtend(ctx, reqPlanId);
            entries = this.groupRecordEntryCollection(this.removeNotComReqConsumeEntries(entries));
            targetInfo.getEntrys().addCollection(entries);
            rtnKey = super._save(ctx, (IObjectValue)targetInfo);
            this.syncSIDReqPlan(ctx, targetInfo);
        } else {
            rtnKey = new ObjectUuidPK(targetInfo.getId());
        }
        return rtnKey;
    }

    private ReqSubConsumeRecordInfo findByReqPlanId(Context ctx, String reqPlanId) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("reqPlan", (Object)reqPlanId, CompareType.EQUALS));
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("reqPlan");
        selector.add("entrys.id");
        selector.add("entrys.consumedQty");
        view.setSelector(selector);
        ReqSubConsumeRecordCollection savedList = this.getReqSubConsumeRecordCollection(ctx, view);
        ReqSubConsumeRecordInfo rtnInfo = null;
        if (savedList != null && savedList.size() > 0) {
            rtnInfo = savedList.get(0);
        }
        return rtnInfo;
    }

    private boolean hasConsumedInfo(ReqSubConsumeRecordInfo rcdInfo) {
        boolean rtnValue = false;
        if (rcdInfo == null || rcdInfo.getEntrys() == null || rcdInfo.getEntrys().size() <= 0) {
            return rtnValue;
        }
        Iterator iter = rcdInfo.getEntrys().iterator();
        while (iter.hasNext()) {
            ReqSubConsumeRecordEntryInfo curEntryInfo = (ReqSubConsumeRecordEntryInfo)iter.next();
            if (curEntryInfo.getConsumedQty() == null || curEntryInfo.getConsumedQty().compareTo(BigDecimal.ZERO) <= 0) continue;
            rtnValue = true;
        }
        return rtnValue;
    }

    private ReqSubConsumeRecordEntryCollection removeNotComReqConsumeEntries(ReqSubConsumeRecordEntryCollection tarEntries) {
        if (tarEntries == null || tarEntries.size() <= 0) {
            return null;
        }
        Iterator iter = tarEntries.iterator();
        while (iter.hasNext()) {
            ReqSubConsumeRecordEntryInfo deInfo = (ReqSubConsumeRecordEntryInfo)iter.next();
            if (deInfo.isComReqConsume()) continue;
            iter.remove();
        }
        return tarEntries;
    }

    private ReqSubConsumeRecordEntryCollection groupRecordEntryCollection(ReqSubConsumeRecordEntryCollection tarEntries) {
        if (tarEntries == null || tarEntries.size() <= 0) {
            return null;
        }
        ReqSubConsumeRecordEntryCollection rtnList = new ReqSubConsumeRecordEntryCollection();
        HashMap<String, ReqSubConsumeRecordEntryInfo> map = new HashMap<String, ReqSubConsumeRecordEntryInfo>();
        Iterator iter = tarEntries.iterator();
        while (iter.hasNext()) {
            ReqSubConsumeRecordEntryInfo deInfo = (ReqSubConsumeRecordEntryInfo)iter.next();
            String key = deInfo.getMaterial().getId().toString();
            if (deInfo.getTraceNum() != null && deInfo.getTraceNum().getId() != null) {
                key = key + deInfo.getTraceNum().getId().toString();
            }
            if (map.containsKey(key)) {
                ReqSubConsumeRecordEntryInfo savedInfo = (ReqSubConsumeRecordEntryInfo)map.get(key);
                savedInfo.setReqQty(savedInfo.getReqQty().add(deInfo.getReqQty()));
                savedInfo.setBaseReqQty(savedInfo.getBaseReqQty().add(deInfo.getBaseReqQty()));
                savedInfo.setPerQty(savedInfo.getPerQty().add(deInfo.getPerQty()));
                continue;
            }
            map.put(key, deInfo);
            rtnList.add(deInfo);
        }
        return rtnList;
    }

    private ReqSubConsumeRecordEntryCollection getEntryCollection(Context ctx, String resultTblName, BOSUuid traceId) throws BOSException {
        if (resultTblName == null || resultTblName.length() <= 0) {
            return null;
        }
        ReqSubConsumeRecordEntryCollection rtnList = new ReqSubConsumeRecordEntryCollection();
        try {
            StringBuffer resultSql = new StringBuffer(256);
            resultSql.append(" select tr.FChildMaterialID as FMaterialID, ").append("   tr.FTraceID as FTraceID, ").append("   tr.fBaseUnitId as FBUnitID, ").append("   tr.FBaseQty as FBReqQty, ").append("   tr.FProductUnitId as FPUnitID, ").append("   tr.FProductQty as FPReqQty, ").append("   tr.FUnitQty as FPerQty, ").append("   tr.FPlannedOrderEntryID as FVirtualEntryID, ").append("   tp.FIsComReqConsume as FIsComReqConsume, ").append("   tp.FManufactureStrategyID as FMfgStrategyID, ").append("   tu.FQtyPrecision as FQtyPrecision ").append(" from ").append(resultTblName).append(" tr").append("   inner join T_BD_MaterialPlan tp on tr.FChildMaterialID=tp.FMaterialID and tr.FStorageOrgUnitId=tp.FOrgUnit ").append("   inner join T_BD_MeasureUnit tu on tu.FID=tr.FProductUnitId ").append(" where tr.fstorageOrgUnitId=tr.FSupplyStorageOrgUnitID ");
            IRowSet rs = SQLUtils.executeQuery((Context)ctx, (String)resultSql.toString());
            if (rs == null || rs.size() == 0) {
                return rtnList;
            }
            while (rs.next()) {
                BOSUuid materialId = BOSUuid.read((String)rs.getString("FMaterialID"));
                ReqSubConsumeRecordEntryInfo curEntryInfo = new ReqSubConsumeRecordEntryInfo();
                rtnList.add(curEntryInfo);
                curEntryInfo.setId(BOSUuid.create((BOSObjectType)this.getBOSType()));
                curEntryInfo.setParentVirtualEntryId(rs.getString("FTraceID"));
                curEntryInfo.setVirtualEntryId(rs.getString("FVirtualEntryID"));
                curEntryInfo.setComReqConsume(rs.getBoolean("FIsComReqConsume"));
                MaterialInfo materialInfo = new MaterialInfo();
                curEntryInfo.setMaterial(materialInfo);
                materialInfo.setId(materialId);
                MeasureUnitInfo productUnit = new MeasureUnitInfo();
                String fpUnitId = rs.getString("FPUnitID");
                productUnit.setId(BOSUuid.read((String)fpUnitId));
                productUnit.setQtyPrecision(rs.getInt("FQtyPrecision"));
                curEntryInfo.setUnit(productUnit);
                MeasureUnitInfo baseUnit = new MeasureUnitInfo();
                String fbUnitId = rs.getString("FBUnitID");
                baseUnit.setId(BOSUuid.read((String)fbUnitId));
                curEntryInfo.setBaseUnit(baseUnit);
                String mfgStrategyId = rs.getString("FMfgStrategyID");
                if (("qAYbemEdG9ngQKjAYj0V1dg0uEU=".equals(mfgStrategyId) || "qAYfaBzTrmLgQKjAYj0f3dg0uEU=".equals(mfgStrategyId) || "fpPxtypCS/ihJ30GjB/UJtg0uEU=".equals(mfgStrategyId) || "qAXoUB/tBg/gQKjAYj0WQ9g0uEU=".equals(mfgStrategyId)) && traceId != null) {
                    TrackNumberInfo trackInfo = new TrackNumberInfo();
                    trackInfo.setId(traceId);
                    curEntryInfo.setTraceNum(trackInfo);
                }
                curEntryInfo.setReqQty(rs.getBigDecimal("FPReqQty"));
                curEntryInfo.setBaseReqQty(rs.getBigDecimal("FBReqQty"));
                curEntryInfo.setConsumedQty(BigDecimal.ZERO);
                curEntryInfo.setBaseConsumedQty(BigDecimal.ZERO);
                curEntryInfo.setPerQty(rs.getBigDecimal("FPerQty"));
            }
        }
        catch (SQLException sqlExp) {
            throw new SQLAccessException(sqlExp.getMessage(), JDBCExceptionHandler.convertException((SQLException)sqlExp));
        }
        return rtnList;
    }

    private ReqSubConsumeRecordEntryCollection bomExtend(Context ctx, String reqPlanId) throws EASBizException, BOSException {
        String matchTblName;
        String resultTblName;
        TempTablePool pool;
        ReqSubConsumeRecordEntryCollection rtnList;
        block18: {
            String expandTblName;
            TrackNumBOM bomInfo;
            block16: {
                ReqSubConsumeRecordEntryCollection reqSubConsumeRecordEntryCollection;
                block17: {
                    rtnList = new ReqSubConsumeRecordEntryCollection();
                    bomInfo = this.getBomIdFromReqPlan(ctx, reqPlanId);
                    if (bomInfo == null || bomInfo.bomId == null || bomInfo.bomId.length() <= 0) {
                        return rtnList;
                    }
                    pool = TempTablePool.getInstance((Context)ctx);
                    StringBuffer sqlBuf = new StringBuffer(256);
                    sqlBuf.append("create table TempBomExpand (").append("FStorageorgUnitID varchar(44) not null,").append("FMaterialID varchar(44) null,").append("FBomID varchar(44),").append("FDate datetime null,").append("FDaySeq integer not null default 0,").append("FBaseQty numeric(21,8) not null default 0,").append("FTraceID varchar(44) null, ").append("FProjectID varchar(44) null, ").append("FTrackNumberID varchar(44) null  ").append(")");
                    expandTblName = MMUtils.createTmpTable((Context)ctx, (String)sqlBuf.toString());
                    StringBuffer insertSql = new StringBuffer(256);
                    insertSql.append(" Insert Into ").append(expandTblName).append("       (FStorageorgUnitID,FMaterialID,FDate,       FBaseQty,         FTrackNumberID,FProjectID,FTraceID,FBomID)").append(" select FStorageOrgUnitID,FMaterialID,to_date(to_char(FRequireDate, 'yyyy-MM-dd') || ' 00:00:00'),FBaseQty,FTrackNumberID,FProjectID,FID,'").append(bomInfo.bomId).append("'").append(" from T_MM_RequirementPlan").append(" where FID='").append(reqPlanId).append("'");
                    resultTblName = null;
                    matchTblName = null;
                    SQLUtils.execute((Context)ctx, (String)insertSql.toString());
                    resultTblName = BOMExtendFacadeFactory.getLocalInstance((Context)ctx).getBOMExpandResult(expandTblName, true);
                    if (resultTblName != null) break block16;
                    reqSubConsumeRecordEntryCollection = rtnList;
                    if (expandTblName == null) break block17;
                    pool.releaseTable(expandTblName);
                }
                if (resultTblName != null) {
                    pool.releaseTable(resultTblName);
                }
                if (matchTblName != null) {
                    pool.releaseTable(matchTblName);
                }
                return reqSubConsumeRecordEntryCollection;
            }
            try {
                BomMatch bomMatch;
                ReqSubConsumeRecordEntryCollection subEntries;
                ReqSubConsumeRecordEntryCollection entries = this.getEntryCollection(ctx, resultTblName, bomInfo.trackNumId);
                if (entries != null && entries.size() > 0) {
                    rtnList.addCollection(entries);
                }
                if ((subEntries = this.cycleExpandBOM(ctx, bomInfo, bomMatch = new BomMatch(), matchTblName = MMUtils.createTmpTable((Context)ctx, (String)bomMatch.getExpandTmpTableSQL()), expandTblName, resultTblName, rtnList, 1)) != null && subEntries.size() > 0) {
                    rtnList.addCollection(subEntries);
                }
                if (expandTblName == null) break block18;
            }
            catch (BOSException bosExp) {
                try {
                    if (bosExp.getCause() != null && bosExp.getCause() instanceof SQLException) {
                        SQLException sqle = (SQLException)bosExp.getCause();
                        throw new SQLAccessException(sqle.getMessage(), JDBCExceptionHandler.convertException((SQLException)sqle));
                    }
                    throw bosExp;
                }
                catch (Throwable throwable) {
                    if (expandTblName != null) {
                        pool.releaseTable(expandTblName);
                    }
                    if (resultTblName != null) {
                        pool.releaseTable(resultTblName);
                    }
                    if (matchTblName != null) {
                        pool.releaseTable(matchTblName);
                    }
                    throw throwable;
                }
            }
            pool.releaseTable(expandTblName);
        }
        if (resultTblName != null) {
            pool.releaseTable(resultTblName);
        }
        if (matchTblName != null) {
            pool.releaseTable(matchTblName);
        }
        return rtnList;
    }

    private ReqSubConsumeRecordEntryInfo findInListBy(ReqSubConsumeRecordEntryCollection tarList, String virtualEntryId) {
        if (tarList == null || tarList.size() <= 0) {
            return null;
        }
        ReqSubConsumeRecordEntryInfo targetInfo = null;
        Iterator iter = tarList.iterator();
        while (iter.hasNext()) {
            ReqSubConsumeRecordEntryInfo deInfo = (ReqSubConsumeRecordEntryInfo)iter.next();
            if (!virtualEntryId.equals(deInfo.getVirtualEntryId())) continue;
            targetInfo = deInfo;
            break;
        }
        return targetInfo;
    }

    private ReqSubConsumeRecordEntryInfo findInListBy(ReqSubConsumeRecordEntryCollection tarList, BOSUuid materialId, BOSUuid trackId) {
        if (tarList == null || tarList.size() <= 0) {
            return null;
        }
        ReqSubConsumeRecordEntryInfo targetInfo = null;
        Iterator iter = tarList.iterator();
        while (iter.hasNext()) {
            ReqSubConsumeRecordEntryInfo deInfo = (ReqSubConsumeRecordEntryInfo)iter.next();
            if (!deInfo.getMaterial().getId().equals((Object)materialId) || deInfo.getTraceNum() == null && trackId != null || deInfo.getTraceNum() != null && !deInfo.getTraceNum().getId().equals((Object)trackId)) continue;
            targetInfo = deInfo;
            break;
        }
        return targetInfo;
    }

    private ReqSubConsumeRecordEntryCollection cycleExpandBOM(Context ctx, TrackNumBOM trackNumId, BomMatch bomMatch, String matchTblName, String expandTblName, String resultTblName, ReqSubConsumeRecordEntryCollection topLevelEntries, int level) throws EASBizException, BOSException {
        StringBuffer deleteSql = new StringBuffer(256);
        deleteSql.append(" delete from ").append(matchTblName);
        StringBuffer sqlBuf = new StringBuffer();
        sqlBuf.append(" insert into ").append(matchTblName).append("   (FID,FMaterialID,fTrackId,FProjectID,").append("   FStorageOrgUnitID,fManufactureStrategyId,fLevel,fMaterialAttr,fIsolatedRule,FExpandTraceId)").append(" select t1.fBomEntryId, t1.FChildMaterialID,").append("   ('").append(trackNumId.trackNum).append("') fTrackId,").append("   ('").append("999999999").append("') FProjectID,").append("   t1.FStorageorgUnitID,t2.FManufactureStrategyID,0,t2.FMaterialAttr,t2.FIsolatedRule,t1.FPlannedOrderEntryID").append(" from ").append(resultTblName).append(" t1 ").append("   inner join T_BD_MaterialPlan t2 on t1.FChildMaterialID=t2.FMaterialID and t1.fstorageOrgUnitId=t2.FOrgUnit").append(" where t1.FSupplyStorageOrgUnitID=fstorageOrgUnitId ");
        SQLUtils.execute((Context)ctx, (String)deleteSql.toString());
        SQLUtils.execute((Context)ctx, (String)sqlBuf.toString());
        int bomCount = bomMatch.matchOrderBom(ctx, matchTblName, 0);
        if (bomCount <= 0) {
            bomCount = bomMatch.matchMfgBom(ctx, matchTblName, 0);
        }
        if (bomCount <= 0) {
            return null;
        }
        ReqSubConsumeRecordEntryCollection rtnList = new ReqSubConsumeRecordEntryCollection();
        deleteSql.setLength(0);
        deleteSql.append(" delete from ").append(expandTblName);
        StringBuffer insertSql = new StringBuffer(256);
        insertSql.append(" Insert Into ").append(expandTblName).append("       (FStorageorgUnitID, FMaterialID, FBomID, FTraceID)").append(" select FStorageOrgUnitID, FMaterialID, FBomID, FExpandTraceId ").append(" from ").append(matchTblName).append(" where FBomID is not null ");
        StringBuffer updateSql = new StringBuffer(256);
        updateSql.append(" update ").append(expandTblName).append(" as t1").append("   set(   FDate, FBaseQty, FTrackNumberID)=").append("  (select t2.FDate, t2.FBaseQty, t2.FTraceID ").append("     from ").append(resultTblName).append(" as t2").append("     where t1.FTraceID=t2.FPlannedOrderEntryID)");
        String tableResult = null;
        SQLUtils.execute((Context)ctx, (String)deleteSql.toString());
        SQLUtils.execute((Context)ctx, (String)insertSql.toString());
        SQLUtils.execute((Context)ctx, (String)updateSql.toString());
        tableResult = BOMExtendFacadeFactory.getLocalInstance((Context)ctx).getBOMExpandResult(expandTblName, true);
        if (tableResult == null) {
            return null;
        }
        ReqSubConsumeRecordEntryCollection entries = this.getEntryCollection(ctx, tableResult, trackNumId.trackNumId);
        if (entries != null && entries.size() > 0) {
            this.calcPerQty(entries, topLevelEntries);
            rtnList.addCollection(entries);
            ReqSubConsumeRecordEntryCollection subentries = this.cycleExpandBOM(ctx, trackNumId, bomMatch, matchTblName, expandTblName, tableResult, entries, level++);
            if (subentries != null && subentries.size() > 0) {
                rtnList.addCollection(subentries);
            }
        }
        return rtnList;
    }

    private void calcPerQty(ReqSubConsumeRecordEntryCollection entries, ReqSubConsumeRecordEntryCollection topLevelEntries) {
        if (topLevelEntries == null || topLevelEntries.size() <= 0) {
            return;
        }
        if (entries == null || entries.size() <= 0) {
            return;
        }
        Iterator iter = entries.iterator();
        while (iter.hasNext()) {
            ReqSubConsumeRecordEntryInfo curEntry = (ReqSubConsumeRecordEntryInfo)iter.next();
            ReqSubConsumeRecordEntryInfo srcEntry = this.findInListBy(topLevelEntries, curEntry.getParentVirtualEntryId());
            if (srcEntry != null) {
                BigDecimal perQty = curEntry.getPerQty().multiply(srcEntry.getPerQty());
                perQty = perQty.setScale(srcEntry.getUnit().getQtyPrecision(), 0);
                curEntry.setPerQty(perQty);
                continue;
            }
            curEntry.setPerQty(BigDecimal.ZERO);
        }
    }

    private TrackNumBOM getBomIdFromReqPlan(Context ctx, String reqPlanId) throws EASBizException, BOSException {
        BomMatch bomMatch = new BomMatch();
        String matchTblName = MMUtils.createTmpTable((Context)ctx, (String)bomMatch.getExpandTmpTableSQL());
        StringBuffer sqlBuf = new StringBuffer();
        sqlBuf.append(" insert into ").append(matchTblName).append("   (FID,FMaterialID,fTrackId,FProjectID,").append("   FStorageOrgUnitID,fManufactureStrategyId,fLevel,fMaterialAttr,fIsolatedRule,fbomType)").append(" select t1.FID, t1.FMaterialID,").append("   isnull(t1.FTrackNumberID, '").append("999999999").append("') fTrackId,").append("   isnull(t1.FProjectID, '").append("999999999").append("') FProjectID,").append("   t1.FStorageorgUnitID,t2.FManufactureStrategyID,0,t2.FMaterialAttr,t2.FIsolatedRule,").append(45).append(" from T_MM_RequirementPlan t1 ").append("   inner join T_BD_MaterialPlan t2 on t1.FMaterialID=t2.FMaterialID and t1.FStorageOrgUnitID=t2.FOrgUnit").append(" where t1.FID='").append(reqPlanId).append("'");
        SQLUtils.execute((Context)ctx, (String)sqlBuf.toString());
        int bomCount = bomMatch.matchOrderBom(ctx, matchTblName, 0);
        if (bomCount <= 0) {
            bomCount = bomMatch.matchMfgBom(ctx, matchTblName, 0);
        }
        if (bomCount <= 0) {
            return null;
        }
        String bomIdSQL = "select fBomId,fTrackId from " + matchTblName + " where FID='" + reqPlanId + "'";
        IRowSet rs = SQLUtils.executeQuery((Context)ctx, (String)bomIdSQL);
        if (rs == null || rs.size() <= 0) {
            return null;
        }
        TrackNumBOM rtnInfo = new TrackNumBOM();
        try {
            rs.next();
            rtnInfo.bomId = rs.getString("fBomId");
            rtnInfo.trackNum = rs.getString("fTrackId");
            if (rtnInfo.trackNum != null && !rtnInfo.trackNum.equals("999999999")) {
                rtnInfo.trackNumId = BOSUuid.read((String)rtnInfo.trackNum);
            }
        }
        catch (SQLException sqlExp) {
            throw new SQLAccessException(sqlExp.getMessage(), JDBCExceptionHandler.convertException((SQLException)sqlExp));
        }
        return rtnInfo;
    }

    private void revertSIDReqPlan(Context ctx, ReqSubConsumeRecordInfo curInfo) throws EASBizException, BOSException {
        if (curInfo == null || curInfo.getEntrys() == null) {
            return;
        }
        IRequirementPlan reqPlanBiz = RequirementPlanFactory.getLocalInstance(ctx);
        curInfo.getReqPlan().setSubConsumeStatus(SubConsumeEnum.NULL);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("subConsumeStatus"));
        reqPlanBiz.updatePartial((CoreBaseInfo)curInfo.getReqPlan(), sic);
    }

    private void revertConsume(Context ctx, String subConsumeId) throws BOSException, EASBizException {
        if (subConsumeId == null || subConsumeId.length() <= 0) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)subConsumeId, CompareType.EQUALS));
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("reqPlan.id");
        selector.add("reqPlan.subConsumeStatus");
        selector.add("entrys.id");
        selector.add("entrys.material");
        selector.add("entrys.consumedQty");
        selector.add("entrys.baseConsumedQty");
        selector.add("entrys.dentrys.id");
        selector.add("entrys.dentrys.unit");
        selector.add("entrys.dentrys.baseUnit");
        selector.add("entrys.dentrys.consumedQty");
        selector.add("entrys.dentrys.baseConsumedQty");
        selector.add("entrys.dentrys.reqPlan.id");
        selector.add("entrys.dentrys.reqPlan.unit");
        selector.add("entrys.dentrys.reqPlan.baseUnit");
        selector.add("entrys.dentrys.reqPlan.qty");
        selector.add("entrys.dentrys.reqPlan.baseQty");
        selector.add("entrys.dentrys.reqPlan.cntactTotalQty");
        selector.add("entrys.dentrys.reqPlan.baseCntactTotalQty");
        view.setSelector(selector);
        ReqSubConsumeRecordCollection savedList = this.getReqSubConsumeRecordCollection(ctx, view);
        if (savedList == null || savedList.size() <= 0) {
            return;
        }
        ReqSubConsumeRecordInfo curInfo = savedList.get(0);
        if (curInfo == null || curInfo.getEntrys() == null) {
            return;
        }
        this.syncPIDReqPlan(ctx, curInfo, true);
        this.revertSIDReqPlan(ctx, curInfo);
    }

    @Override
    protected void _antiConsume(Context ctx, String subConsumeId) throws BOSException, EASBizException {
        this.revertConsume(ctx, subConsumeId);
        BOSUuid id = BOSUuid.read((String)subConsumeId);
        this._delete(ctx, (IObjectPK)new ObjectUuidPK(id));
    }

    @Override
    protected Map _getManulWriteOffData(Context ctx, String reqPlanId, boolean isManulWriteOff) throws BOSException, EASBizException {
        HashMap map = new HashMap();
        ArrayList<ReqPlanManulWriteOffDataVO> list = new ArrayList<ReqPlanManulWriteOffDataVO>();
        map.put("list", list);
        map = this.getPrecision(ctx, reqPlanId, map);
        if (isManulWriteOff) {
            return map;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("reqPlan", (Object)reqPlanId, CompareType.EQUALS));
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        view.setSelector(selector);
        selector.add("id");
        selector.add("reqPlan.material.id");
        selector.add("unit.id");
        selector.add("baseUnit.id");
        selector.add("parentEntry.reqQty");
        selector.add("parentEntry.baseReqQty");
        selector.add("reqPlan.storageOrgUnit");
        selector.add("parentEntry.parent.reqPlan.sourceBillID");
        selector.add("parentEntry.parent.reqPlan.sourceBillNum");
        selector.add("parentEntry.parent.reqPlan.sourceEntryID");
        selector.add("parentEntry.parent.reqPlan.sourceEntrySeq");
        selector.add("parentEntry.parent.reqPlan.billType.id");
        selector.add("parentEntry.parent.reqPlan.billType.name");
        selector.add("parentEntry.parent.trackNumber.id");
        selector.add("parentEntry.parent.trackNumber.number");
        selector.add("consumedQty");
        selector.add("baseConsumedQty");
        selector.add("parentEntry.parent.reqPlan.reqType.id");
        selector.add("parentEntry.parent.reqPlan.customer.name");
        IReqSubConsumeRecordDEntry dentryBiz = ReqSubConsumeRecordDEntryFactory.getLocalInstance(ctx);
        ReqSubConsumeRecordDEntryCollection dentries = dentryBiz.getReqSubConsumeRecordDEntryCollection(view);
        if (dentries == null || dentries.size() <= 0) {
            return map;
        }
        Iterator iter = dentries.iterator();
        while (iter.hasNext()) {
            ReqSubConsumeRecordDEntryInfo deInfo = (ReqSubConsumeRecordDEntryInfo)iter.next();
            RequirementPlanInfo reqPlan = deInfo.getParentEntry().getParent().getReqPlan();
            ReqPlanManulWriteOffDataVO billVO = new ReqPlanManulWriteOffDataVO();
            list.add(billVO);
            billVO.setBillID(reqPlan.getSourceBillID());
            billVO.setNumber(reqPlan.getSourceBillNum());
            billVO.setBillEntryID(reqPlan.getSourceEntryID());
            billVO.setBillEntrySeq(reqPlan.getSourceEntrySeq());
            if (reqPlan.getBillType() != null) {
                billVO.setBillTypeID(reqPlan.getBillType().getId().toString());
                billVO.setBillTypeName(reqPlan.getBillType().getName());
            }
            billVO.setQty(deInfo.getParentEntry().getReqQty());
            billVO.setContactQty(deInfo.getConsumedQty());
            billVO.setContactBaseQty(deInfo.getBaseConsumedQty());
            String reqType = "MID";
            if (reqPlan.getBillType() != null) {
                if (reqPlan.getBillType().getId().toString().equals("510b6503-0105-1000-e000-0113c0a812fd463ED552")) {
                    reqType = "SID";
                } else if (reqPlan.getReqType().getId().toString().equals("50957179-0105-1000-e003-3152c0a812fd463ED552") || reqPlan.getReqType().getId().toString().equals("Eg5BUQEVEADgAAABwKgOEEY+1VI=")) {
                    reqType = "MTD";
                }
            } else if (reqPlan.getReqType().getId().toString().equals("NcvxPgEcEADgAAiowKgL09hs+cg=")) {
                reqType = "PRD";
            }
            billVO.setReqType(reqType);
            if (reqPlan.getCustomer() != null) {
                billVO.setCustomer(reqPlan.getCustomer().getName());
            }
            billVO.setProject(null);
            if (deInfo.getParentEntry().getTraceNum() != null) {
                billVO.setTrackNumber(deInfo.getParentEntry().getTraceNum().getNumber());
            }
            billVO.setId(deInfo.getParentEntry().getId().toString());
        }
        return map;
    }

    private HashMap getPrecision(Context ctx, String requirementPlanId, HashMap map) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer();
        BigDecimal baseConvsRate = new BigDecimal("0.0");
        int baseQtyPrecision = 2;
        int qtyPrecision = 2;
        sb.append(" select mulUnit.FQtyPrecision as FQtyPrecision,  ");
        sb.append(" mulUnit2.FQtyPrecision as FbaseQtyPrecision ,mulUnit2.FBaseConvsRate ");
        sb.append(" from t_mm_requirementplan rp ");
        sb.append(" inner join t_bd_multimeasureunit mulUnit on mulUnit.FMaterialID = rp.FMaterialID and rp.FUnitID = mulUnit.FMeasureUnitID");
        sb.append(" inner join t_bd_multimeasureunit mulUnit2 on mulUnit2.FMaterialID = rp.FMaterialID ");
        sb.append(" and rp.FbaseUnitID = mulUnit2.FMeasureUnitID");
        sb.append(" where rp.Fid = '").append(requirementPlanId).append("'");
        IRowSet reqRow = SQLUtils.executeQuery((Context)ctx, (String)sb.toString());
        try {
            while (reqRow.next()) {
                baseConvsRate = reqRow.getBigDecimal("FBaseConvsRate");
                baseQtyPrecision = reqRow.getInt("FbaseQtyPrecision");
                qtyPrecision = reqRow.getInt("FQtyPrecision");
                map.put("baseConvsRate", baseConvsRate);
                map.put("baseQtyPrecision", new Integer(baseQtyPrecision));
                map.put("qtyPrecision", new Integer(qtyPrecision));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return map;
    }

    @Override
    protected void _syncSubConsumeRecord(Context ctx, boolean isWriteOff, HashMap map) throws BOSException, EASBizException {
        String reqPlanId = (String)map.get("picPlanID");
        BigDecimal totalQty = (BigDecimal)map.get("totalQty");
        BigDecimal totalBaseQty = (BigDecimal)map.get("totalBaseQty");
        if (!isWriteOff) {
            totalQty = totalQty.negate();
            totalBaseQty = totalBaseQty.negate();
        }
        List dataList = (List)map.get("dataList");
        List idList = (List)map.get("idList");
        IRequirementPlan reqPlanBiz = RequirementPlanFactory.getLocalInstance(ctx);
        RequirementPlanInfo reqPlanInfo = reqPlanBiz.getRequirementPlanInfo((IObjectPK)new ObjectUuidPK(reqPlanId));
        reqPlanInfo.setCntactTotalQty(reqPlanInfo.getCntactTotalQty().add(totalQty));
        reqPlanInfo.setBaseCntactTotalQty(reqPlanInfo.getBaseCntactTotalQty().add(totalBaseQty));
        ReqPlanStatusEnum reqPlanStatus = ReqPlanStatusEnum.CLOSED;
        if (reqPlanInfo.getQty().compareTo(reqPlanInfo.getCntactTotalQty()) > 0 && reqPlanInfo.getCloseType().compareTo((Object)ReqPlanCloseTypeEnum.MANUAL) != 0) {
            reqPlanStatus = ReqPlanStatusEnum.ACTIVE;
        }
        reqPlanInfo.setStatus(reqPlanStatus);
        reqPlanBiz.update((IObjectPK)new ObjectUuidPK(reqPlanId), (CoreBaseInfo)reqPlanInfo);
        IReqSubConsumeRecordEntry consumeRcdEntryBiz = ReqSubConsumeRecordEntryFactory.getLocalInstance(ctx);
        for (int curIdx = 0; curIdx < dataList.size(); ++curIdx) {
            ReqSubConsumeRecordEntryInfo consumeEntryInfo;
            ReqPlanManulWriteOffDataVO vo = (ReqPlanManulWriteOffDataVO)dataList.get(curIdx);
            if (vo.getQty().compareTo(BigDecimal.ZERO) <= 0) continue;
            if (!isWriteOff) {
                vo.setQty(vo.getQty().negate());
                vo.setBaseQty(vo.getBaseQty().negate());
            }
            BigDecimal consumedQty = (consumeEntryInfo = consumeRcdEntryBiz.getReqSubConsumeRecordEntryInfo((IObjectPK)new ObjectUuidPK(vo.getId()))).getConsumedQty() == null ? BigDecimal.ZERO : consumeEntryInfo.getConsumedQty();
            BigDecimal baseConsumedQty = consumeEntryInfo.getBaseConsumedQty() == null ? BigDecimal.ZERO : consumeEntryInfo.getBaseConsumedQty();
            consumeEntryInfo.setConsumedQty(consumedQty.add(vo.getQty()));
            consumeEntryInfo.setBaseConsumedQty(baseConsumedQty.add(vo.getBaseQty()));
            ReqSubConsumeRecordDEntryCollection dentries = consumeEntryInfo.getDentrys();
            if (dentries.size() <= 0) {
                ReqSubConsumeRecordDEntryInfo dentryInfo = new ReqSubConsumeRecordDEntryInfo();
                dentries.add(dentryInfo);
                dentryInfo.setUnit(reqPlanInfo.getUnit());
                dentryInfo.setBaseUnit(reqPlanInfo.getBaseUnit());
                dentryInfo.setParentEntry(consumeEntryInfo);
                dentryInfo.setId(BOSUuid.create((BOSObjectType)dentryInfo.getBOSType()));
                dentryInfo.setReqPlan(reqPlanInfo);
                dentryInfo.setConsumedQty(vo.getQty());
                dentryInfo.setBaseConsumedQty(vo.getBaseQty());
            } else {
                ReqSubConsumeRecordDEntryInfo dentryInfo;
                boolean isAddnew = true;
                Iterator iter = dentries.iterator();
                while (iter.hasNext()) {
                    dentryInfo = (ReqSubConsumeRecordDEntryInfo)iter.next();
                    if (!dentryInfo.getReqPlan().getId().equals((Object)reqPlanInfo.getId())) continue;
                    isAddnew = false;
                    dentryInfo.setConsumedQty(dentryInfo.getConsumedQty().add(vo.getQty()));
                    dentryInfo.setBaseConsumedQty(dentryInfo.getBaseConsumedQty().add(vo.getBaseQty()));
                    if (dentryInfo.getConsumedQty().compareTo(BigDecimal.ZERO) != 0) break;
                    dentries.remove(dentryInfo);
                    break;
                }
                if (isAddnew) {
                    dentryInfo = new ReqSubConsumeRecordDEntryInfo();
                    dentries.add(dentryInfo);
                    dentryInfo.setUnit(reqPlanInfo.getUnit());
                    dentryInfo.setBaseUnit(reqPlanInfo.getBaseUnit());
                    dentryInfo.setParentEntry(consumeEntryInfo);
                    dentryInfo.setId(BOSUuid.create((BOSObjectType)dentryInfo.getBOSType()));
                    dentryInfo.setReqPlan(reqPlanInfo);
                    dentryInfo.setConsumedQty(vo.getQty());
                    dentryInfo.setBaseConsumedQty(vo.getBaseQty());
                }
            }
            consumeRcdEntryBiz.update((IObjectPK)new ObjectUuidPK(vo.getId()), (CoreBaseInfo)consumeEntryInfo);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("id");
            selector.add("reqPlan");
            selector.add("entrys.id");
            selector.add("entrys.consumedQty");
            selector.add("entrys.reqQty");
            ReqSubConsumeRecordInfo curRcd = this.getReqSubConsumeRecordInfo(ctx, (IObjectPK)new ObjectUuidPK(consumeEntryInfo.getParent().getId()), selector);
            this.syncSIDReqPlan(ctx, curRcd);
        }
    }

    @Override
    protected List _getCntDtlData(Context ctx, String destID) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("reqPlan", (Object)destID, CompareType.EQUALS));
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        view.setSelector(selector);
        selector.add("id");
        selector.add("parentEntry.parent.reqPlan.sourceBillID");
        selector.add("parentEntry.parent.reqPlan.sourceBillNum");
        selector.add("parentEntry.parent.reqPlan.sourceEntryID");
        selector.add("parentEntry.parent.reqPlan.sourceEntrySeq");
        selector.add("parentEntry.parent.reqPlan.billType.id");
        selector.add("parentEntry.parent.reqPlan.billType.name");
        selector.add("unit.qtyPrecision");
        selector.add("consumedQty");
        IReqSubConsumeRecordDEntry dentryBiz = ReqSubConsumeRecordDEntryFactory.getLocalInstance(ctx);
        ReqSubConsumeRecordDEntryCollection dentries = dentryBiz.getReqSubConsumeRecordDEntryCollection(view);
        if (dentries == null || dentries.size() <= 0) {
            return null;
        }
        ArrayList<RequirementPlanCntDtlVo> list = new ArrayList<RequirementPlanCntDtlVo>();
        Iterator iter = dentries.iterator();
        while (iter.hasNext()) {
            ReqSubConsumeRecordDEntryInfo deInfo = (ReqSubConsumeRecordDEntryInfo)iter.next();
            RequirementPlanInfo reqPlan = deInfo.getParentEntry().getParent().getReqPlan();
            RequirementPlanCntDtlVo billVO = new RequirementPlanCntDtlVo();
            list.add(billVO);
            billVO.setBillID(reqPlan.getSourceBillID());
            billVO.setEntryID(reqPlan.getSourceEntryID());
            if (reqPlan.getBillType() != null && reqPlan.getBillType().getId() != null) {
                billVO.setBillTypeID(reqPlan.getBillType().getId().toString());
                billVO.setBillTypeName(reqPlan.getBillType().getName());
            }
            billVO.setContactQty(deInfo.getConsumedQty());
            billVO.setNumber(reqPlan.getSourceBillNum());
            billVO.setQtyPrecision(deInfo.getUnit().getQtyPrecision());
        }
        return list;
    }

    @Override
    protected void _syncReqPlanReqQty(Context ctx, String subConsumeId, BigDecimal reqQty) throws BOSException, EASBizException {
        if (subConsumeId == null || subConsumeId.length() <= 0) {
            return;
        }
        if (reqQty == null || reqQty.compareTo(BigDecimal.ZERO) <= 0) {
            this._antiConsume(ctx, subConsumeId);
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)subConsumeId, CompareType.EQUALS));
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("reqPlan.id");
        selector.add("reqPlan.qty");
        selector.add("reqPlan.subConsumeStatus");
        selector.add("entrys.*");
        selector.add("entrys.unit.qtyPrecision");
        selector.add("entrys.dentrys.*");
        view.setSelector(selector);
        ReqSubConsumeRecordCollection savedList = this.getReqSubConsumeRecordCollection(ctx, view);
        if (savedList == null || savedList.size() <= 0) {
            return;
        }
        ReqSubConsumeRecordInfo curInfo = savedList.get(0);
        if (curInfo == null || curInfo.getEntrys() == null) {
            return;
        }
        this.syncEntryReqQty(curInfo, reqQty);
        this.syncSIDReqPlan(ctx, curInfo);
        ObjectUuidPK pk = new ObjectUuidPK(curInfo.getId());
        super._update(ctx, (IObjectPK)pk, (IObjectValue)curInfo);
    }

    private void syncEntryReqQty(ReqSubConsumeRecordInfo curInfo, BigDecimal reqQty) {
        if (curInfo == null || curInfo.getEntrys() == null) {
            return;
        }
        BigDecimal ratio = reqQty.divide(curInfo.getReqPlan().getQty(), 12, 5);
        Iterator iter = curInfo.getEntrys().iterator();
        while (iter.hasNext()) {
            ReqSubConsumeRecordEntryInfo entryInfo = (ReqSubConsumeRecordEntryInfo)iter.next();
            BigDecimal curReqQty = entryInfo.getReqQty().multiply(ratio);
            curReqQty = curReqQty.setScale(entryInfo.getUnit().getQtyPrecision(), 5);
            entryInfo.setReqQty(curReqQty);
        }
    }

    class TrackNumBOM {
        String bomId;
        String trackNum;
        BOSUuid trackNumId;

        TrackNumBOM() {
        }
    }
}

