/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ExchangeTableInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfoInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.ICustomer;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.common.DeliveryTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.TableManagerFacadeFactory;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.mm.common.app.SQLUtils;
import com.kingdee.eas.mm.common.util.MMUtils;
import com.kingdee.eas.mm.common.util.ResourceManage;
import com.kingdee.eas.mm.common.util.ResourceUtils;
import com.kingdee.eas.mm.common.util.SQLUtil;
import com.kingdee.eas.mm.control.ProductionOrderFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderFactory;
import com.kingdee.eas.mm.mo.ScrapOrderFactory;
import com.kingdee.eas.mm.planning.CooperatePlanOrderFactory;
import com.kingdee.eas.mm.planning.IRequirementPlan;
import com.kingdee.eas.mm.planning.MMBatchResult;
import com.kingdee.eas.mm.planning.PlannedOrderFactory;
import com.kingdee.eas.mm.planning.ReqPlanException;
import com.kingdee.eas.mm.planning.ReqPlanManulWriteOffDataVO;
import com.kingdee.eas.mm.planning.ReqPlanStatusEnum;
import com.kingdee.eas.mm.planning.ReqPlanWriteOffFacadeFactory;
import com.kingdee.eas.mm.planning.RequireSourceEnum;
import com.kingdee.eas.mm.planning.RequirementPlanCollection;
import com.kingdee.eas.mm.planning.RequirementPlanFactory;
import com.kingdee.eas.mm.planning.RequirementPlanInfo;
import com.kingdee.eas.mm.planning.app.AbstractRequirementPlanControllerBean;
import com.kingdee.eas.mm.project.ProjectTaskFactory;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillCommonFacadeFactory;
import com.kingdee.eas.scm.common.app.SCMGroupServerUtils;
import com.kingdee.eas.scm.common.util.KsqlUtil;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.im.inv.StockTransferBillFactory;
import com.kingdee.eas.scm.im.inv.TransferOrderBillFactory;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryCollection;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryInfo;
import com.kingdee.eas.scm.sd.sale.SaleOrderFactory;
import com.kingdee.eas.scm.sd.sale.SaleOrderInfo;
import com.kingdee.eas.scm.sm.pur.PurRequestFactory;
import com.kingdee.eas.scm.sm.sc.SubContractOrderFactory;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.IntEnum;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class RequirementPlanControllerBean
extends AbstractRequirementPlanControllerBean {
    private static final long serialVersionUID = 2145426516227304455L;
    private static Logger logger = Logger.getLogger((String)RequirementPlanControllerBean.class.getName());
    private static final String REQPLAN_RESOURCE_PATH = "com.kingdee.eas.mm.planning.ReqPlanResource";
    private static final String TABLENAME = "T_MM_RequirementPlan";
    private static final BigDecimal ZERO = new BigDecimal(0);
    private static final String SO_SEND_MODE = "51eb893e-0105-1000-e000-0c00c0a8123362E9EE3F";

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        RequirementPlanInfo info = (RequirementPlanInfo)model;
        IObjectPK pk = super._submit(ctx, (IObjectValue)info);
        if (info != null && info.getStorageOrgUnit() != null) {
            ReqPlanWriteOffFacadeFactory.getLocalInstance(ctx).batchDealCounteract(info.getStorageOrgUnit().getId().toString());
        }
        return pk;
    }

    @Override
    protected List _batchSubmitData(Context ctx, List editCollection) throws BOSException, EASBizException {
        String paramValue;
        if (editCollection == null || editCollection.size() <= 0) {
            return null;
        }
        MMBatchResult result = new MMBatchResult();
        String storageOrgUnitid = null;
        ArrayList removeList = new ArrayList();
        ArrayList<RequirementPlanInfo> insertList = new ArrayList<RequirementPlanInfo>();
        ArrayList<RequirementPlanInfo> updateList = new ArrayList<RequirementPlanInfo>();
        for (Object info : editCollection) {
            if (info instanceof String) {
                removeList.add(info);
                if (storageOrgUnitid != null) continue;
                RequirementPlanInfo tmp = this.getRequirementPlanInfo(ctx, (IObjectPK)new ObjectUuidPK((String)info));
                storageOrgUnitid = tmp.getStorageOrgUnit().getId().toString();
                continue;
            }
            RequirementPlanInfo planInfo = (RequirementPlanInfo)info;
            if (storageOrgUnitid == null) {
                storageOrgUnitid = planInfo.getStorageOrgUnit().getId().toString();
            }
            if (planInfo.getOprStatus() == 1) {
                insertList.add(planInfo);
                continue;
            }
            if (planInfo.getOprStatus() != 2) continue;
            updateList.add(planInfo);
        }
        if ((insertList.size() > 0 || updateList.size() > 0) && Boolean.valueOf(paramValue = ParamManager.getParamValue((Context)ctx, (IObjectPK)new ObjectUuidPK(storageOrgUnitid), (String)"TRACKNUMBER_EXCLUSIVE")).booleanValue()) {
            this.checkTrackNumberDup(ctx, storageOrgUnitid, insertList, updateList, removeList);
        }
        this.removePlan(ctx, removeList, result);
        this.insertPlan(ctx, insertList, result);
        this.updatePlan(ctx, updateList, result);
        if (storageOrgUnitid.trim().length() > 0) {
            ReqPlanWriteOffFacadeFactory.getLocalInstance(ctx).batchDealCounteract(storageOrgUnitid);
        }
        int successRecNum = result.getInsertedObject().size() + result.getDeletedPK().size() + result.getUpdatedObject().size();
        result.getHeadMsg().append(this.getReqResource(ctx, "SUBMIT_SUCCESSFUL", new String[]{String.valueOf(successRecNum)}) + "\n");
        if (result.getErrNum() > 0) {
            result.getHeadMsg().append(this.getReqResource(ctx, "SUBMIT_ERROR", new String[]{String.valueOf(result.getErrNum())}) + "\n");
        }
        ArrayList<MMBatchResult> l = new ArrayList<MMBatchResult>();
        l.add(result);
        return l;
    }

    @Override
    protected Map _batchDeleteData(Context ctx, Set idSet) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection selectorColl = new SelectorItemCollection();
        selectorColl.add("id");
        selectorColl.add("number");
        selectorColl.add("reqSource");
        selectorColl.add("cntactTotalQty");
        selectorColl.add("scheduledQty");
        selectorColl.add("storageOrgUnit.id");
        view.setSelector(selectorColl);
        IRequirementPlan irp = RequirementPlanFactory.getLocalInstance(ctx);
        RequirementPlanCollection coll = irp.getRequirementPlanCollection(view);
        if (coll == null || coll.size() == 0) {
            return null;
        }
        RequirementPlanInfo info = null;
        RequireSourceEnum reqSource = null;
        HashSet<String> deleteIdSet = new HashSet<String>();
        HashSet<String> deleteNumberSet = new HashSet<String>();
        StringBuffer sb = new StringBuffer();
        String[] params = null;
        String orgUnitid = null;
        for (int i = 0; i < coll.size(); ++i) {
            info = coll.get(i);
            if (info.getCntactTotalQty().compareTo(ZERO) > 0) {
                sb.append(this.getReqResource(ctx, "HASCOUNTERACTED_UNABLEDELETE", new String[]{info.getNumber()})).append("\n");
                continue;
            }
            if (info.getScheduledQty().compareTo(ZERO) > 0) {
                sb.append(this.getReqResource(ctx, "HASSCHEDULED_UNABLEDELETE", new String[]{info.getNumber()})).append("\n");
                continue;
            }
            reqSource = info.getReqSource();
            if (RequireSourceEnum.MANUAL.equals((Object)reqSource) || RequireSourceEnum.SOP.equals((Object)reqSource) || RequireSourceEnum.CENTRALPURREQ.equals((Object)reqSource)) {
                deleteIdSet.add(info.getId().toString());
                orgUnitid = info.getStorageOrgUnit().getId().toString();
                deleteNumberSet.add(info.getNumber());
                continue;
            }
            params = new String[]{info.getNumber(), reqSource.getAlias()};
            sb.append(this.getReqResource(ctx, "reqPlan_cannot_delete", params)).append("\n");
        }
        if (deleteIdSet.size() > 0) {
            StringBuffer sql = new StringBuffer();
            sql.append(" delete from T_MM_RequirementPlan where fid in (");
            sql.append(SQLUtil.setToString(deleteIdSet)).append(")");
            int executeNum = SQLUtils.execute((Context)ctx, (String)sql.toString());
            logger.info((Object)(" delete RequirementPlan total :" + executeNum));
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            RequirementPlanInfo caller = new RequirementPlanInfo();
            if (iCodingRuleManager.isExist((IObjectValue)caller, orgUnitid) && iCodingRuleManager.isUseIntermitNumber((IObjectValue)caller, orgUnitid)) {
                Object[] numberObjs = deleteNumberSet.toArray();
                for (int i = 0; i < numberObjs.length; ++i) {
                    iCodingRuleManager.recycleNumber((IObjectValue)caller, orgUnitid, numberObjs[i].toString());
                }
            }
        }
        HashMap<String, String> rstMap = null;
        if (sb.length() > 0) {
            rstMap = new HashMap<String, String>();
            int totalNum = coll.size();
            int errorNum = totalNum - deleteIdSet.size();
            params = new String[]{String.valueOf(totalNum), String.valueOf(errorNum)};
            rstMap.put("HEAD_ERROR", this.getReqResource(ctx, "reqPlan_delete_headError", params));
            rstMap.put("DETAIL_ERROR", sb.toString());
        }
        return rstMap;
    }

    private void checkTrackNumberDup(Context ctx, String storageOrgUnitId, List newAddCollection, List modifiedCollection, List deleteList) throws BOSException, EASBizException {
        HashMap<String, String> trackNumberMap = new HashMap<String, String>();
        RequirementPlanInfo info2 = null;
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        ArrayList<String> excludeList = new ArrayList<String>();
        excludeList.addAll(deleteList);
        Iterator it = null;
        for (RequirementPlanInfo info2 : newAddCollection) {
            if (info2.getTrackNumber() == null) continue;
            if (!trackNumberMap.containsKey(info2.getTrackNumber().getId().toString())) {
                trackNumberMap.put(info2.getTrackNumber().getId().toString(), info2.getTrackNumber().getNumber());
                paramList.add(new Object[]{"null", info2.getTrackNumber().getId().toString()});
                continue;
            }
            throw new ReqPlanException(ReqPlanException.TRACKNUMBER_DUPREF, new String[]{info2.getTrackNumber().getNumber()});
        }
        for (RequirementPlanInfo info2 : modifiedCollection) {
            excludeList.add(info2.getId().toString());
            if (info2.getTrackNumber() == null) continue;
            if (!trackNumberMap.containsKey(info2.getTrackNumber().getId().toString())) {
                trackNumberMap.put(info2.getTrackNumber().getId().toString(), info2.getTrackNumber().getNumber());
                paramList.add(new Object[]{info2.getId().toString(), info2.getTrackNumber().getId().toString()});
                continue;
            }
            throw new ReqPlanException(ReqPlanException.TRACKNUMBER_DUPREF, new String[]{info2.getTrackNumber().getNumber()});
        }
        String tmpTable = "";
        tmpTable = KsqlUtil.createTempTable((Context)ctx, (String)"Create Table ReqPlanTmpTableForCheck(FID Varchar(44),FTrackNumberID Varchar(44))");
        String insertSql = "insert into " + tmpTable + "(FID,FTrackNumberID) values(?,?)";
        SQLUtils.executeBatch((Context)ctx, (String)insertSql, paramList);
        StringBuffer checkSql = new StringBuffer();
        checkSql.append("select distinct tmp.FTrackNumberID from " + tmpTable);
        checkSql.append(" as tmp,T_MM_RequirementPlan as rp ");
        checkSql.append("where rp.FStorageOrgUnitID = '" + storageOrgUnitId + "'");
        if (excludeList != null && excludeList.size() > 0) {
            checkSql.append(" and rp.FID not in ('" + StringUtils.arrayToString((Object[])excludeList.toArray(), (String)"','") + "') ");
        }
        checkSql.append(" and tmp.FTrackNumberID = rp.FTrackNumberID ");
        checkSql.append(" and tmp.FID != rp.FID ");
        IRowSet rs = SQLUtils.executeQuery((Context)ctx, (String)checkSql.toString());
        KsqlUtil.releaseTempTable((Context)ctx, (String)tmpTable);
        try {
            ArrayList<String> dupTrackNumber = new ArrayList<String>();
            while (rs.next()) {
                dupTrackNumber.add((String)trackNumberMap.get(rs.getString("FTrackNumberID")));
            }
            if (dupTrackNumber.size() > 0) {
                throw new ReqPlanException(ReqPlanException.TRACKNUMBER_DUPREF, new String[]{StringUtils.arrayToString((Object[])dupTrackNumber.toArray(), (String)";")});
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    private void removePlan(Context ctx, List removeList, MMBatchResult result) throws BOSException, EASBizException {
        if (this.isEmpty(removeList)) {
            return;
        }
        String tmpTblName = null;
        try {
            StringBuffer errMsg = new StringBuffer();
            removeList = this.verifyBeforeRemove(ctx, removeList, errMsg, result);
            if (!this.isEmpty(removeList)) {
                this.doBeforeDeletePlan(ctx, removeList);
                RequirementPlanInfo info = this.getRequirementPlanInfo(ctx, (IObjectPK)new ObjectUuidPK((String)removeList.get(0)));
                String sql = "DELETE FROM T_MM_REQUIREMENTPLAN WHERE FID in ('" + this.listToStr(removeList, false) + "')";
                this.executeBatchSQL(ctx, sql, null);
                ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
                if (info.getStorageOrgUnit() != null && info.getNumber() != null) {
                    String storageOrgID = info.getStorageOrgUnit().getId().toString();
                    String number = info.getNumber();
                    if (codingRuleManager.isExist((IObjectValue)info, storageOrgID) && codingRuleManager.isUseIntermitNumber((IObjectValue)info, storageOrgID)) {
                        codingRuleManager.recycleNumber((IObjectValue)info, storageOrgID, number);
                    }
                }
            }
            if (errMsg.toString().length() > 0) {
                result.getDetailMsg().append(errMsg.toString());
            }
            if (removeList.size() > 0) {
                Iterator it = removeList.iterator();
                while (it.hasNext()) {
                    result.getDeletedPK().add((String)it.next());
                }
            }
        }
        catch (BOSException e) {
            throw e;
        }
        catch (EASBizException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            this.releaseTempTable(ctx, tmpTblName);
        }
    }

    private void updatePlan(Context ctx, List updateList, MMBatchResult result) throws EASBizException, BOSException {
        String tmpTblName = null;
        try {
            if (this.isEmpty(updateList)) {
                return;
            }
            StringBuffer errMsg = new StringBuffer();
            updateList = this.verityEmpty(ctx, updateList, errMsg, result);
            updateList = this.verityQty(ctx, updateList, errMsg, result);
            this.setRequireDate(updateList);
            tmpTblName = this.createTempTable(ctx);
            this.insertDataToTmpTable(ctx, updateList, tmpTblName);
            updateList = this.verifyExist(ctx, updateList, errMsg, result);
            updateList = this.verifyLastUptTime(ctx, updateList, errMsg, tmpTblName, result);
            updateList = this.verifyNumberModify(ctx, updateList, errMsg, tmpTblName, result);
            this.lockData(ctx, updateList);
            String storageOrgUnitid = null;
            if (!this.isEmpty(updateList)) {
                this.saveValues(ctx, updateList);
                storageOrgUnitid = ((RequirementPlanInfo)updateList.get(0)).getStorageOrgUnit().getId().toString();
            }
            if (errMsg.toString().length() > 0) {
                result.getDetailMsg().append(errMsg.toString());
            }
            if (updateList.size() > 0 && storageOrgUnitid != null) {
                List l = this.findNewInsertObject(ctx, storageOrgUnitid, updateList);
                result.setUpdatedObject(l);
            }
            this.releaseTempTable(ctx, tmpTblName);
        }
        catch (BOSException e) {
            throw e;
        }
        catch (EASBizException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            this.releaseTempTable(ctx, tmpTblName);
        }
    }

    private void saveValues(Context ctx, List insertList) throws EASBizException, BOSException {
        for (RequirementPlanInfo info : insertList) {
            this.save(ctx, (CoreBaseInfo)info);
        }
    }

    private void insertPlan(Context ctx, List insertList, MMBatchResult result) throws BOSException, EASBizException {
        String tmpTblName = null;
        try {
            if (this.isEmpty(insertList)) {
                return;
            }
            StringBuffer errMsg = new StringBuffer();
            insertList = this.verityEmpty(ctx, insertList, errMsg, result);
            this.setRequireDate(insertList);
            insertList = this.verityQty(ctx, insertList, errMsg, result);
            tmpTblName = this.createTempTable(ctx);
            this.insertDataToTmpTable(ctx, insertList, tmpTblName);
            insertList = this.verifyNumberAdd(ctx, insertList, errMsg, tmpTblName, result);
            String storageOrgUnitid = null;
            if (!this.isEmpty(insertList)) {
                this.saveValues(ctx, insertList);
                storageOrgUnitid = ((RequirementPlanInfo)insertList.get(0)).getStorageOrgUnit().getId().toString();
            }
            if (errMsg.toString().length() > 0) {
                result.getDetailMsg().append(errMsg.toString());
            }
            if (insertList.size() > 0 && storageOrgUnitid != null) {
                List l = this.findNewInsertObject(ctx, storageOrgUnitid, insertList);
                result.setInsertedObject(l);
            }
            this.releaseTempTable(ctx, tmpTblName);
        }
        catch (BOSException e) {
            throw e;
        }
        catch (EASBizException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            this.releaseTempTable(ctx, tmpTblName);
        }
    }

    private void doBeforeDeletePlan(Context ctx, List removeList) throws BOSException {
        String deleteIDs = "'" + this.listToStr(removeList, false) + "'";
        Connection conn = null;
        Statement batchStatement = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            batchStatement = conn.createStatement();
            StringBuffer sql_uptCntactReq = new StringBuffer();
            sql_uptCntactReq.append(" update T_MM_RequirementPlan as p \n");
            sql_uptCntactReq.append(" set (FCntactTotalQty,FBaseCntactTotalQty,FStatus) = \n");
            sql_uptCntactReq.append("(select case when (p.FCntactTotalQty - q.fQty) < 0 then 0 else (p.FCntactTotalQty - q.fQty) end \n");
            sql_uptCntactReq.append(",case when (p.FBaseCntactTotalQty - q.fBaseQty) < 0 then 0 else (p.FBaseCntactTotalQty - q.fBaseQty) end \n");
            sql_uptCntactReq.append(",case when (p.fQty - (p.FCntactTotalQty - q.fQty))>0 then ").append(10).append(" else ").append(20).append(" end \n");
            sql_uptCntactReq.append(" from ");
            sql_uptCntactReq.append(" ( select r.FDESTID as FDESTID, sum(r.FQTY) as FQTY, sum(r.FBASEQTY) as FBASEQTY ");
            sql_uptCntactReq.append("   from T_MM_ReqCounteractRelation as r, T_MM_RequirementPlan as d ");
            sql_uptCntactReq.append("   where d.FID in (" + deleteIDs + ") ");
            sql_uptCntactReq.append("   and d.FSourceEntryID is not null ");
            sql_uptCntactReq.append("   and d.FSourceBillID = r.FSourceID ");
            sql_uptCntactReq.append("   and d.FSourceEntryID = r.FSourceEntryID ");
            sql_uptCntactReq.append("   group by r.FDESTID ");
            sql_uptCntactReq.append(" ) AS q ");
            sql_uptCntactReq.append(" where q.FDestID = p.FID)");
            batchStatement.addBatch(sql_uptCntactReq.toString());
            String sql_delCntRela = "delete from T_MM_ReqCounteractRelation where fid in  (select r.fid from T_MM_ReqCounteractRelation as r inner join T_MM_RequirementPlan as p on  p.FID in (" + deleteIDs + ") and p.FSourceBillID = r.FSourceID and p.FSourceEntryID = r.FSourceEntryID)";
            batchStatement.addBatch(sql_delCntRela);
            batchStatement.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(batchStatement, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)batchStatement, (Connection)conn);
    }

    private List verityEmpty(Context ctx, List insertList, StringBuffer headBuffer, MMBatchResult result) {
        if (this.isEmpty(insertList)) {
            return insertList;
        }
        Iterator it = insertList.iterator();
        while (it.hasNext()) {
            RequirementPlanInfo info = (RequirementPlanInfo)it.next();
            StringBuffer sb = new StringBuffer();
            if (info.getNumber() == null) {
                sb.append(ResourceManage.getResource((String)REQPLAN_RESOURCE_PATH, (String)"billNumber", (Locale)ctx.getLocale()));
            }
            if (info.getMaterial() == null) {
                sb.append(ResourceManage.getResource((String)REQPLAN_RESOURCE_PATH, (String)"materialIsNull", (Locale)ctx.getLocale()));
            }
            if (info.getQty() == null || info.getQty().compareTo(new BigDecimal(0.0)) == 0) {
                sb.append(ResourceManage.getResource((String)REQPLAN_RESOURCE_PATH, (String)"reqQtyIsNull", (Locale)ctx.getLocale()));
            }
            if (info.getRequireDate() == null) {
                sb.append(ResourceManage.getResource((String)REQPLAN_RESOURCE_PATH, (String)"RequireDate", (Locale)ctx.getLocale()));
            }
            if (info.getReqType() == null) {
                sb.append(ResourceManage.getResource((String)REQPLAN_RESOURCE_PATH, (String)"reqTypeIsNull", (Locale)ctx.getLocale()));
            }
            if (sb.length() <= 0) continue;
            it.remove();
            result.setErrNum(result.getErrNum() + 1);
            String billNumber = info.getNumber();
            headBuffer.append(this.getReqResource(ctx, "SUBMIT_NULLFAIL", new String[]{billNumber == null ? "#Undefined#" : billNumber, sb.toString()}) + "\n");
        }
        return insertList;
    }

    private List verityQty(Context ctx, List insertList, StringBuffer errMsg, MMBatchResult result) {
        if (this.isEmpty(insertList)) {
            return insertList;
        }
        Iterator it = insertList.iterator();
        StringBuffer headBuffer = new StringBuffer();
        while (it.hasNext()) {
            RequirementPlanInfo info = (RequirementPlanInfo)it.next();
            if (!info.getReqType().getNumber().equalsIgnoreCase("PIC") && !info.getReqType().getNumber().equalsIgnoreCase("PID") || info.getCntactTotalQty() == null || info.getCntactTotalQty().compareTo(info.getQty()) <= 0) continue;
            StringBuffer sb = new StringBuffer();
            sb.append(ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"4_RequirementPlanControllerBean", (Locale)ctx.getLocale()));
            sb.append(info.getMaterial().getNumber());
            sb.append(",");
            sb.append(ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"5_RequirementPlanControllerBean", (Locale)ctx.getLocale()));
            sb.append(info.getRequireDate());
            sb.append(",");
            sb.append(ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"6_RequirementPlanControllerBean", (Locale)ctx.getLocale()));
            sb.append(info.getReqType().getName());
            sb.append(",");
            sb.append(ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"7_RequirementPlanControllerBean", (Locale)ctx.getLocale()));
            sb.append(info.getReqSource().getAlias());
            headBuffer.append(sb.toString() + ResourceManage.getResource((String)REQPLAN_RESOURCE_PATH, (String)"qtyGECntactTotalQty", (Locale)ctx.getLocale()) + "\n");
            it.remove();
            result.setErrNum(result.getErrNum() + 1);
        }
        if (headBuffer.length() > 0) {
            errMsg.append(headBuffer.toString() + "\n");
        }
        return insertList;
    }

    protected List verifyNumberAdd(Context ctx, List insertList, StringBuffer errMsg, String tmpTblName, MMBatchResult result) throws EASBizException, BOSException {
        if (this.isEmpty(tmpTblName) || this.isEmpty(insertList)) {
            return insertList;
        }
        Object[] params = new Object[insertList.size()];
        StringBuffer inSql = new StringBuffer();
        int count = insertList.size();
        for (int i = 0; i < count; ++i) {
            params[i] = ((RequirementPlanInfo)insertList.get(i)).getNumber();
            if (i != 0) {
                inSql.append(',');
            }
            inSql.append('?');
        }
        String sql = "Select a.fnumber \nfrom " + tmpTblName + " a,t_mm_requirementplan b \n where a.fnumber in (" + inSql + ") and \n       a.FSTORAGEORGUNITID = b.FSTORAGEORGUNITID and \n       a.fnumber = b.fnumber \n";
        try {
            IRowSet rs = SQLUtils.executeQuery((Context)ctx, (String)sql, (Object[])params);
            while (rs != null && rs.next()) {
                String id = rs.getString("fnumber");
                Iterator it = insertList.iterator();
                while (it.hasNext()) {
                    RequirementPlanInfo info = (RequirementPlanInfo)it.next();
                    if (!info.getNumber().toString().equals(id)) continue;
                    errMsg.append(this.getReqResource(ctx, "NUMBER_EXIST", new String[]{info.getNumber()}));
                    it.remove();
                    result.setErrNum(result.getErrNum() + 1);
                }
            }
            return insertList;
        }
        catch (SQLException e1) {
            throw new BOSException((Throwable)e1);
        }
    }

    protected List verifyBeforeRemove(Context ctx, List removeList, StringBuffer errMsg, MMBatchResult result) throws BOSException {
        if (this.isEmpty(removeList)) {
            return removeList;
        }
        String sql = "select FID,FNumber,FCntactTotalQty,FScheduledQty,FReqSource,FReqTypeID  from t_mm_requirementplan where \n     fid in ('" + this.listToStr(removeList, false) + "')\n ";
        try {
            IRowSet rs = SQLUtils.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                String number = rs.getString("FNumber");
                String id = rs.getString("FID");
                if (rs.getBigDecimal("FCntactTotalQty").compareTo(ZERO) > 0) {
                    errMsg.append(this.getReqResource(ctx, "HASCOUNTERACTED_UNABLEDELETE", new String[]{number}) + "\n");
                    removeList.remove(id);
                    result.setErrNum(result.getErrNum() + 1);
                    result.getErrDeletePK().add(id);
                    continue;
                }
                if (rs.getBigDecimal("FScheduledQty").compareTo(ZERO) <= 0) continue;
                errMsg.append(this.getReqResource(ctx, "HASSCHEDULED_UNABLEDELETE", new String[]{number}) + "\n");
                removeList.remove(id);
                result.setErrNum(result.getErrNum() + 1);
                result.getErrDeletePK().add(id);
            }
            return removeList;
        }
        catch (SQLException e1) {
            throw new BOSException((Throwable)e1);
        }
    }

    protected List verifyNumberModify(Context ctx, List insertList, StringBuffer errMsg, String tmpTblName, MMBatchResult result) throws EASBizException, BOSException {
        if (this.isEmpty(tmpTblName) || this.isEmpty(insertList)) {
            return insertList;
        }
        RequirementPlanInfo reqPlanInfo = null;
        HashSet<String> numberSet = new HashSet<String>();
        for (int i = 0; i < insertList.size(); ++i) {
            reqPlanInfo = (RequirementPlanInfo)insertList.get(i);
            if (!ReqPlanStatusEnum.ACTIVE.equals((Object)reqPlanInfo.getStatus())) continue;
            numberSet.add(reqPlanInfo.getNumber());
        }
        if (numberSet.size() == 0) {
            return insertList;
        }
        String sql = "Select a.fnumber from " + tmpTblName + " a,t_mm_requirementplan b  where a.fnumber in " + MMUtils.setToString(numberSet) + " and        a.FSTORAGEORGUNITID = b.FSTORAGEORGUNITID and        a.fnumber = b.fnumber and a.fid <> b.fid ";
        try {
            IRowSet rs = SQLUtils.executeQuery((Context)ctx, (String)sql);
            while (rs != null && rs.next()) {
                String id = rs.getString("fnumber");
                Iterator it = insertList.iterator();
                while (it.hasNext()) {
                    RequirementPlanInfo info = (RequirementPlanInfo)it.next();
                    if (!info.getNumber().toString().equals(id)) continue;
                    errMsg.append(this.getReqResource(ctx, "NUMBER_EXIST", new String[]{info.getNumber()}));
                    it.remove();
                    result.setErrNum(result.getErrNum() + 1);
                }
            }
            return insertList;
        }
        catch (SQLException e1) {
            throw new BOSException((Throwable)e1);
        }
    }

    protected void lockData(Context ctx, List updateList) throws BOSException {
        String sql = "update T_MM_RequirementPlan set FLastUpdateTime= now() where fid in ('" + this.listToStr(updateList, false) + "')";
        SQLUtils.execute((Context)ctx, (String)sql);
    }

    private List verifyExist(Context ctx, List updateList, StringBuffer errMsg, MMBatchResult result2) throws BOSException {
        if (this.isEmpty(updateList)) {
            return updateList;
        }
        String sql = "select fid from t_mm_requirementplan where fid in ('" + this.listToStr(updateList, false) + "') ";
        ArrayList<String> result = new ArrayList<String>();
        try {
            IRowSet rs = SQLUtils.executeQuery((Context)ctx, (String)sql);
            StringBuffer sb = new StringBuffer();
            while (rs.next()) {
                String id = rs.getString("fid");
                result.add(id);
            }
            Iterator it = updateList.iterator();
            while (it.hasNext()) {
                RequirementPlanInfo info = (RequirementPlanInfo)it.next();
                Iterator iter = result.iterator();
                boolean find = false;
                while (iter.hasNext()) {
                    String id = (String)iter.next();
                    if (!info.getId().toString().equals(id)) continue;
                    find = true;
                    break;
                }
                if (find) continue;
                sb.append(this.getReqResource(ctx, "RECORD_NOTEXIST", new String[]{info.getNumber()}));
                it.remove();
                result2.setErrNum(result2.getErrNum() + 1);
            }
            if (sb.length() > 0) {
                errMsg.append(sb.toString() + "\n");
            }
            return updateList;
        }
        catch (SQLException e1) {
            throw new BOSException((Throwable)e1);
        }
    }

    public List verifyLastUptTime(Context ctx, List updateList, StringBuffer errMsg, String tmpTblName, MMBatchResult result) throws BOSException {
        if (this.isEmpty(tmpTblName) || this.isEmpty(updateList)) {
            return updateList;
        }
        String sql = "Select a.fid \nfrom " + tmpTblName + " a inner join t_mm_requirementplan b on a.fid = b.fid \nwhere a.fid in ('" + this.listToStr(updateList, false) + "') and \n      a.flastupdatetime < b.flastupdatetime \n";
        try {
            IRowSet rs = SQLUtils.executeQuery((Context)ctx, (String)sql);
            StringBuffer sb = new StringBuffer();
            while (rs.next()) {
                String id = rs.getString("fid");
                Iterator it = updateList.iterator();
                while (it.hasNext()) {
                    RequirementPlanInfo info = (RequirementPlanInfo)it.next();
                    if (info.getLastUpdateTime() == null || !info.getId().toString().equals(id)) continue;
                    sb.append(this.getReqResource(ctx, "ALREADYMODIFIED_BYOTHERS", new String[]{info.getNumber()}));
                    it.remove();
                    result.setErrNum(result.getErrNum() + 1);
                }
            }
            if (sb.length() > 0) {
                errMsg.append(sb.toString() + "\n");
            }
            return updateList;
        }
        catch (SQLException e1) {
            throw new BOSException((Throwable)e1);
        }
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("storageOrgUnit.name"));
        sic.add(new SelectorItemInfo("material.id"));
        sic.add(new SelectorItemInfo("material.name"));
        sic.add(new SelectorItemInfo("material.number"));
        sic.add(new SelectorItemInfo("material.model"));
        sic.add(new SelectorItemInfo("unit.name"));
        sic.add(new SelectorItemInfo("baseUnit.name"));
        sic.add(new SelectorItemInfo("sourceSU.name"));
        sic.add(new SelectorItemInfo("billType.name"));
        sic.add(new SelectorItemInfo("manuStrategy.number"));
        sic.add(new SelectorItemInfo("manuStrategy.name"));
        sic.add(new SelectorItemInfo("reqType.id"));
        sic.add(new SelectorItemInfo("reqType.number"));
        sic.add(new SelectorItemInfo("reqType.name"));
        sic.add(new SelectorItemInfo("CU.id"));
        sic.add(new SelectorItemInfo("CU.name"));
        sic.add(new SelectorItemInfo("creator.id"));
        sic.add(new SelectorItemInfo("creator.number"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("trackNumber.id"));
        sic.add(new SelectorItemInfo("trackNumber.number"));
        sic.add(new SelectorItemInfo("trackNumber.name"));
        sic.add(new SelectorItemInfo("project.id"));
        sic.add(new SelectorItemInfo("project.number"));
        sic.add(new SelectorItemInfo("project.name"));
        sic.add(new SelectorItemInfo("planner.id"));
        sic.add(new SelectorItemInfo("planner.name"));
        sic.add(new SelectorItemInfo("productionDept.id"));
        sic.add(new SelectorItemInfo("productionDept.name"));
        sic.add(new SelectorItemInfo("customer.name"));
        sic.add(new SelectorItemInfo("customer.id"));
        sic.add(new SelectorItemInfo("customer.number"));
        return sic;
    }

    private String listToStr(List list, boolean isNumber) {
        Object[] numbers = new String[list.size()];
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Object obj = list.get(i);
            if (obj instanceof RequirementPlanInfo) {
                RequirementPlanInfo info = (RequirementPlanInfo)obj;
                if (isNumber) {
                    numbers[i] = info.getNumber();
                    continue;
                }
                numbers[i] = info.getId().toString();
                continue;
            }
            if (!(obj instanceof String)) continue;
            numbers[i] = (String)obj;
        }
        return StringUtils.arrayToString((Object[])numbers, (String)"','");
    }

    private void setRequireDate(List insertList) {
        Iterator it = insertList.iterator();
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
        while (it.hasNext()) {
            RequirementPlanInfo info = (RequirementPlanInfo)it.next();
            info.setRequireDate(Timestamp.valueOf(sf.format(info.getRequireDate()) + " 00:00:00"));
        }
    }

    private Object fitValue(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof String || obj instanceof BigDecimal || obj instanceof Short) {
            return obj;
        }
        if (obj instanceof CoreBaseInfo) {
            return ((CoreBaseInfo)obj).getId() == null ? null : ((CoreBaseInfo)obj).getId().toString();
        }
        if (obj instanceof Date) {
            return new Timestamp(((Date)obj).getTime());
        }
        if (obj instanceof IntEnum) {
            return new Integer(((IntEnum)obj).getValue());
        }
        return obj;
    }

    private void executeBatchSQL(Context ctx, String sql, List insertList) throws BOSException {
        PreparedStatement ptmt;
        Connection conn;
        block8: {
            conn = null;
            ptmt = null;
            try {
                conn = EJBFactory.getConnection((Context)ctx);
                ptmt = conn.prepareStatement(sql);
                if (!this.isEmpty(insertList)) {
                    for (Object[] values : insertList) {
                        int n = values.length;
                        for (int i = 0; i < n; ++i) {
                            if (values[i] == null) {
                                ptmt.setNull(i + 1, 0);
                                continue;
                            }
                            ptmt.setObject(i + 1, values[i]);
                        }
                        ptmt.addBatch();
                    }
                    ptmt.executeBatch();
                    break block8;
                }
                ptmt.execute();
            }
            catch (SQLException e) {
                try {
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(ptmt, (Connection)conn);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((Statement)ptmt, (Connection)conn);
    }

    public String createTempTable(Context ctx) throws BOSException, EASBizException {
        String tableName = TableManagerFacadeFactory.getLocalInstance((Context)ctx).getTableName("RequirmentPlanTmpTable");
        String createSql = "Create table " + tableName + " (  \nFID VARCHAR(44),  \nFNUMBER VARCHAR(80),  \nFREQUIREDATE DATETIME,  \nFQTY NUMERIC(28,10),  \nFMATERIALID varchar(44),  \nFcustomerID varchar(44),  \nFSTORAGEORGUNITID varchar(44),  \nFIsDirectTransport int,  \nFREQTYPEID varchar(44),  \nFREQSOURCE int, \nFLASTUPDATETIME DATETIME ,FPROJECTID varchar(44),FTRACKNUMBERID varchar(44)\n)";
        SQLUtils.execute((Context)ctx, (String)createSql);
        return tableName;
    }

    public void insertDataToTmpTable(Context ctx, List data, String tmpTblName) throws BOSException, EASBizException {
        if (this.isEmpty(tmpTblName) || this.isEmpty(data)) {
            return;
        }
        ArrayList<Object[]> values = new ArrayList<Object[]>();
        for (RequirementPlanInfo info : data) {
            Object[] value = new Object[]{info.getId() == null ? "" : info.getId().toString(), info.getNumber(), this.fitValue(info.getRequireDate()), info.getQty(), this.fitValue(info.getCustomer()), this.fitValue(info.getMaterial()), this.fitValue(info.getStorageOrgUnit()), new Integer(info.isIsDirectTransport() ? 1 : 0), this.fitValue(info.getReqType()), this.fitValue((Object)info.getReqSource()), info.getLastUpdateTime(), info.getProject() == null ? null : info.getProject().getId().toString(), info.getTrackNumber() == null ? null : info.getTrackNumber().getId().toString()};
            values.add(value);
        }
        String sql = "Insert into " + tmpTblName + " values(?,?,?,?,?,?,?,?,?,?,?,?,?)";
        this.executeBatchSQL(ctx, sql, values);
    }

    public void releaseTempTable(Context ctx, String tableName) throws BOSException, EASBizException {
        if (!StringUtil.isEmptyString((String)tableName)) {
            TableManagerFacadeFactory.getLocalInstance((Context)ctx).releaseTableName(tableName);
        }
    }

    public boolean isEmpty(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof String) {
            return (String)obj == null || ((String)obj).length() <= 0;
        }
        if (obj instanceof List) {
            return (List)obj == null || ((List)obj).size() <= 0;
        }
        return false;
    }

    private List findNewInsertObject(Context ctx, String storageOrgUnitid, List insertList) throws BOSException, EASBizException {
        HashSet<String> numbers = new HashSet<String>();
        for (RequirementPlanInfo info : insertList) {
            numbers.add(info.getNumber());
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setSelector(this.getSelectors());
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgUnitid, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("number", numbers, CompareType.INCLUDE));
        viewInfo.setFilter(filter);
        ArrayList result = new ArrayList();
        RequirementPlanCollection col = this.getRequirementPlanCollection(ctx, viewInfo);
        Iterator it = col.iterator();
        while (it.hasNext()) {
            result.add(it.next());
        }
        return result;
    }

    private String getReqResource(Context ctx, String key, String[] params) {
        return ResourceUtils.getMessageByLocale((String)REQPLAN_RESOURCE_PATH, (String)key, (String[])params, (Locale)ctx.getLocale());
    }

    @Override
    protected Map _getSourceBillUIInfo(Context ctx, String requirementPlanId) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        HashMap<String, String> uiInfoMap = new HashMap<String, String>();
        sql.append(" select ui.FSourceEditUIPath as uiPath, reqPlan.FSourceSUID as sourceSU, reqPlan.FBillTypeID,");
        sql.append(" reqPlan.fsourceBillID as billId from ");
        sql.append(" T_MM_RequirementPlanSourceUI as ui ");
        sql.append(" inner join T_MM_RequirementPlan as reqPlan ");
        sql.append(" on ui.FSourceBillTypeId = reqPlan.FBillTypeID ");
        sql.append(" and reqPlan.fid = '").append(requirementPlanId).append("'");
        IRowSet rs = SQLUtils.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rs.next()) {
                String billTypeID = rs.getString("FBillTypeID");
                uiInfoMap.put("uiPath", rs.getString("uiPath"));
                uiInfoMap.put("sourceStorageUnit", rs.getString("sourceSU"));
                uiInfoMap.put("billId", rs.getString("billId"));
                this.checkexist(ctx, billTypeID, rs.getString("billId"));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return uiInfoMap;
    }

    private void checkexist(Context ctx, String billtypeId, String billid) throws BOSException, EASBizException {
        Object bizInterface = null;
        if ("50957179-0105-1000-e003-3152c0a812fd463ED552".equalsIgnoreCase(billtypeId)) {
            bizInterface = StockTransferBillFactory.getLocalInstance((Context)ctx);
        }
        if ("Eg5BUQEVEADgAAABwKgOEEY+1VI=".equalsIgnoreCase(billtypeId)) {
            bizInterface = TransferOrderBillFactory.getLocalInstance((Context)ctx);
        }
        if ("kvQieV/4TJ+1ipJVFBlPx0Y+1VI=".equals(billtypeId)) {
            bizInterface = SubContractOrderFactory.getLocalInstance((Context)ctx);
        }
        if ("510b6503-0105-1000-e000-0107c0a812fd463ED552".equals(billtypeId)) {
            bizInterface = PurRequestFactory.getLocalInstance((Context)ctx);
        }
        if ("510b6503-0105-1000-e000-0113c0a812fd463ED552".equalsIgnoreCase(billtypeId)) {
            bizInterface = SaleOrderFactory.getLocalInstance((Context)ctx);
        }
        if ("B2aZSVXaSx6qxdfekgCmrEY+1VI=".equalsIgnoreCase(billtypeId)) {
            bizInterface = ManufactureOrderFactory.getLocalInstance((Context)ctx);
        }
        if ("ejIZHXXTQliYCQJg9t4Re0Y+1VI=".equalsIgnoreCase(billtypeId)) {
            bizInterface = ProductionOrderFactory.getLocalInstance((Context)ctx);
        }
        if ("9XXvbVGlRtym/0qtqeIXXrhE1B8=".equalsIgnoreCase(billtypeId)) {
            bizInterface = PlannedOrderFactory.getLocalInstance(ctx);
        }
        if ("YnsvoPSeRzCK0b/jEufQpkY+1VI=".equals(billtypeId)) {
            bizInterface = ScrapOrderFactory.getLocalInstance((Context)ctx);
        }
        if ("tMCsjuu0TMO+jMoUTkrsSkY+1VI=".equals(billtypeId)) {
            bizInterface = CooperatePlanOrderFactory.getLocalInstance(ctx);
        }
        if ("cV8Sqe5UQ3eI+vH675lGxUY+1VI=".equals(billtypeId)) {
            bizInterface = ProjectTaskFactory.getLocalInstance((Context)ctx);
        }
        if (!bizInterface.exists((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)billid)))) {
            throw new EASBizException(EASBizException.CHECKEXIST);
        }
    }

    @Override
    protected void _updateCalculateTime(Context ctx, List reqPlanIdList, Date calculateTime) throws BOSException, EASBizException {
        if (calculateTime == null || reqPlanIdList == null || reqPlanIdList.size() == 0) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String calculateTimeStr = df.format(calculateTime);
        df.format(calculateTime);
        String ids = SQLUtil.arrayToString((Object[])reqPlanIdList.toArray());
        sql.append(" update t_mm_requirementPlan set fcalculateTime = {ts'").append(calculateTimeStr).append("'}");
        sql.append(" , fselectedStatus = ").append(1);
        sql.append(" where fid in (").append(ids).append(")");
        SQLUtils.execute((Context)ctx, (String)sql.toString());
    }

    @Override
    protected SaleOrderInfo _generateSaleOrder(Context ctx, RequirementPlanCollection requirementPlanList, List saleOrderQtyList) throws BOSException, EASBizException {
        StorageOrgUnitInfo storageOrg = null;
        if (requirementPlanList.size() > 0) {
            storageOrg = requirementPlanList.get(0).getStorageOrgUnit();
        }
        SaleOrderInfo saleOrderInfo = new SaleOrderInfo();
        SaleOrgUnitInfo saleOrg = null;
        OrgUnitInfo org = SCMGroupServerUtils.getDefaultOrgsByRelation((Context)ctx, (OrgType)OrgType.Storage, (OrgType)OrgType.Sale, (String)storageOrg.getId().toString());
        if (org == null) {
            OrgUnitCollection saleOrgCollection = SCMGroupServerUtils.getOrgsByRelation((Context)ctx, (OrgType)OrgType.Storage, (OrgType)OrgType.Sale, (String)storageOrg.getId().toString());
            if (saleOrgCollection != null && saleOrgCollection.size() > 0) {
                Object[] objs = saleOrgCollection.toArray();
                OrgUnitInfo[] orgs = new OrgUnitInfo[objs.length];
                System.arraycopy(objs, 0, orgs, 0, objs.length);
                saleOrg = (SaleOrgUnitInfo)orgs[0];
            }
        } else {
            saleOrg = (SaleOrgUnitInfo)org;
        }
        if (saleOrg == null) {
            storageOrg = StorageOrgUnitFactory.getLocalInstance((Context)ctx).getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(storageOrg.getId().toString()));
            throw new ReqPlanException(ReqPlanException.NOSALEORDER, new String[]{storageOrg.getName()});
        }
        IPermission permission = PermissionFactory.getLocalInstance((Context)ctx);
        permission.checkFunctionPermission((IObjectPK)new ObjectUuidPK(ctx.getCaller().toString()), (IObjectPK)new ObjectUuidPK(saleOrg.getId().toString()), "saleorder_addnew");
        ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        if (!codingRuleManager.isExist((IObjectValue)saleOrderInfo, saleOrg.getId().toString())) {
            throw new ReqPlanException(ReqPlanException.SALEORDERBOTPNOTOPEN);
        }
        String saleOrderNumber = codingRuleManager.getNumber((IObjectValue)saleOrderInfo, saleOrg.getId().toString());
        saleOrderInfo.setSaleOrgUnit(saleOrg);
        saleOrderInfo.setNumber(saleOrderNumber);
        BizTypeInfo bizType = new BizTypeInfo();
        bizType.setId(BOSUuid.read((String)"d8e80652-010e-1000-e000-04c5c0a812202407435C"));
        saleOrderInfo.setBizType(bizType);
        saleOrderInfo.setBizDate(new Date());
        CurrencyInfo baseCurrInfo = null;
        CompanyOrgUnitInfo company = null;
        OrgUnitCollection collection = SCMGroupServerUtils.getOrgsByRelation((Context)ctx, (OrgType)OrgType.Storage, (OrgType)OrgType.Company, (String)storageOrg.getId().toString());
        if (collection != null && collection.size() > 0) {
            Object[] objs = collection.toArray();
            OrgUnitInfo[] orgs = new OrgUnitInfo[objs.length];
            System.arraycopy(objs, 0, orgs, 0, objs.length);
            company = (CompanyOrgUnitInfo)orgs[0];
            baseCurrInfo = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(company.getBaseCurrency().getId().toString()));
        }
        CurrencyInfo baseCurrInfo2 = null;
        CompanyOrgUnitInfo company2 = null;
        OrgUnitCollection collection2 = SCMGroupServerUtils.getOrgsByRelation((Context)ctx, (OrgType)OrgType.Sale, (OrgType)OrgType.Company, (String)storageOrg.getId().toString());
        if (collection2 != null && collection2.size() > 0) {
            Object[] objs = collection2.toArray();
            OrgUnitInfo[] orgs = new OrgUnitInfo[objs.length];
            System.arraycopy(objs, 0, orgs, 0, objs.length);
            company2 = (CompanyOrgUnitInfo)orgs[0];
            baseCurrInfo2 = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(company.getBaseCurrency().getId().toString()));
        }
        saleOrderInfo.setCompanyOrgUnit(company2);
        saleOrderInfo.setCurrency(baseCurrInfo2);
        saleOrderInfo.setExchangeRate(new BigDecimal("1"));
        DeliveryTypeInfo deliveryType = new DeliveryTypeInfo();
        deliveryType.setId(BOSUuid.read((String)SO_SEND_MODE));
        saleOrderInfo.setDeliveryType(deliveryType);
        saleOrderInfo.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        BillTypeInfo billType = new BillTypeInfo();
        billType.setId(BOSUuid.read((String)"510b6503-0105-1000-e000-0113c0a812fd463ED552"));
        saleOrderInfo.setBillType(billType);
        SaleOrderEntryCollection entries = new SaleOrderEntryCollection();
        CustomerInfo customerInfo = null;
        int size = requirementPlanList.size();
        for (int i = 0; i < size; ++i) {
            RequirementPlanInfo reqPlan = requirementPlanList.get(i);
            SaleOrderEntryInfo saleOrderEntry = new SaleOrderEntryInfo();
            saleOrderEntry.setSeq(i);
            saleOrderEntry.setParent(saleOrderInfo);
            saleOrderEntry.setStorageOrgUnit(storageOrg);
            MaterialInfo material = reqPlan.getMaterial();
            saleOrderEntry.setMaterial(material);
            BigDecimal saleOrderQty = (BigDecimal)saleOrderQtyList.get(i);
            BigDecimal baseSaleOrderQty = SCMUtils.getExchangeQtyForServer((Context)ctx, (String)material.getId().toString(), (String)reqPlan.getUnit().getId().toString(), (BigDecimal)saleOrderQty, (String)reqPlan.getBaseUnit().getId().toString());
            saleOrderEntry.setUnit(reqPlan.getUnit());
            saleOrderEntry.setBaseUnit(reqPlan.getBaseUnit());
            saleOrderEntry.setQty(saleOrderQty);
            saleOrderEntry.setBaseQty(baseSaleOrderQty);
            saleOrderEntry.setProject(reqPlan.getProject());
            saleOrderEntry.setTrackNumber(reqPlan.getTrackNumber());
            saleOrderEntry.setSendDate(reqPlan.getRequireDate());
            saleOrderEntry.setUnOrderedQty(saleOrderQty);
            saleOrderEntry.setDeliveryCustomer(reqPlan.getCustomer());
            saleOrderEntry.setPaymentCustomer(reqPlan.getCustomer());
            saleOrderEntry.setReceiveCustomer(reqPlan.getCustomer());
            saleOrderEntry.setSourceBillEntryId(reqPlan.getId().toString());
            saleOrderEntry.setSourceBillId(reqPlan.getId().toString());
            saleOrderEntry.setIsMrpCal(true);
            saleOrderEntry.setBaseStatus(EntryBaseStatusEnum.TEMPORARILYSAVED);
            saleOrderEntry.setCompanyOrgUnit(company);
            if (company != null && company2 != null && company.getId().toString().equals(company2.getId().toString())) {
                saleOrderEntry.setIsBetweenCompanySend(false);
            } else {
                saleOrderEntry.setIsBetweenCompanySend(true);
            }
            entries.add(saleOrderEntry);
            if (customerInfo != null) continue;
            customerInfo = reqPlan.getCustomer();
        }
        saleOrderInfo.setOrderCustomer(customerInfo);
        if (customerInfo != null && company != null && baseCurrInfo != null) {
            ICustomer iCustomer = CustomerFactory.getLocalInstance((Context)ctx);
            ObjectUuidPK customerPK = new ObjectUuidPK(customerInfo.getId().toString());
            ObjectUuidPK companyOrgUnitPK = new ObjectUuidPK(company.getId());
            ObjectUuidPK destCurrPK = new ObjectUuidPK(baseCurrInfo.getId());
            CustomerCompanyInfoInfo customerCompanyInfoInfo = iCustomer.getCustomerCompanyInfo((IObjectPK)customerPK, (IObjectPK)companyOrgUnitPK, this.getCustomerCompanyInfoSelector());
            if (customerCompanyInfoInfo != null) {
                CurrencyInfo customerCurrencyInfo = customerCompanyInfoInfo.getSettlementCurrency();
                ObjectUuidPK sourceCurrPK = new ObjectUuidPK(customerCurrencyInfo.getId());
                ExchangeRateInfo tempexrateinfo = RequirementPlanControllerBean.getExchangeRate(ctx, company, (IObjectPK)sourceCurrPK, (IObjectPK)destCurrPK);
                saleOrderInfo.setCurrency(customerCurrencyInfo);
                if (tempexrateinfo != null) {
                    saleOrderInfo.setExchangeRate(tempexrateinfo.getConvertRate());
                }
            }
        }
        saleOrderInfo.put("entries", (Object)entries);
        IObjectPK id = SaleOrderFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)saleOrderInfo);
        if (id != null) {
            this.setReqPlanSaleOrderRelation(ctx, requirementPlanList, saleOrderInfo, entries);
        }
        return saleOrderInfo;
    }

    public static ExchangeRateInfo getExchangeRate(Context ctx, CompanyOrgUnitInfo companyOrgUnitInfo, IObjectPK sourceCurrPK, IObjectPK destCurrPK) throws EASBizException, BOSException {
        if (destCurrPK == null) {
            destCurrPK = sourceCurrPK;
        }
        ExchangeTableInfo exchangeTableInfo = companyOrgUnitInfo.getBaseExchangeTable();
        ObjectUuidPK excTablepk = null;
        if (exchangeTableInfo == null) {
            return null;
        }
        excTablepk = new ObjectUuidPK(exchangeTableInfo.getId());
        ExchangeRateInfo exchangeRateInfo = null;
        exchangeRateInfo = SCMBillCommonFacadeFactory.getLocalInstance((Context)ctx).getCurrentExchangeRate((IObjectPK)excTablepk, sourceCurrPK, destCurrPK);
        return exchangeRateInfo;
    }

    protected SelectorItemCollection getCustomerCompanyInfoSelector() {
        SelectorItemCollection selectorItems = new SelectorItemCollection();
        selectorItems.add(new SelectorItemInfo("id"));
        selectorItems.add(new SelectorItemInfo("settlementCurrency"));
        selectorItems.add(new SelectorItemInfo("settlementCurrency.name"));
        return selectorItems;
    }

    private void setReqPlanSaleOrderRelation(Context ctx, RequirementPlanCollection requirementPlanList, SaleOrderInfo saleOrderInfo, SaleOrderEntryCollection entries) throws BOSException {
        StringBuffer saveRelationSql = new StringBuffer();
        saveRelationSql.append(" insert into T_MM_ReqSaleOrderRelation(");
        saveRelationSql.append(" FRequirementPlanId,FSaleOrderId,FSaleOrderNumber,FQty,FBaseQty,fSaleEntryID,fsaleEntrySeq)");
        saveRelationSql.append(" values(?,?,?,?,?,?,?)");
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        int size = requirementPlanList.size();
        for (int i = 0; i < size; ++i) {
            paramsList.add(new Object[]{requirementPlanList.get(i).getId().toString(), saleOrderInfo.getId().toString(), saleOrderInfo.getNumber(), entries.get(i).getQty(), entries.get(i).getBaseQty(), entries.get(i).getId().toString(), new Integer(entries.get(i).getSeq())});
        }
        SQLUtils.executeBatch((Context)ctx, (String)saveRelationSql.toString(), paramsList);
    }

    @Override
    protected Map _getSaleOrderRelation(Context ctx, String requirementPlanId) throws BOSException, EASBizException {
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        StringBuffer sql = new StringBuffer();
        sql.append(" select r.FSaleOrderId,r.FSaleOrderNumber,r.FQty,r.FBaseQty,s.FSaleOrgUnitID, ");
        sql.append(" se.FBaseStatus,se.fparentid ,r.fSaleEntryID,r.fsaleEntrySeq from T_MM_ReqSaleOrderRelation r  ");
        sql.append(" left join  t_sd_saleorder as s on r.FSaleOrderId = s.fid ");
        sql.append(" left join t_sd_saleorderentry as se on r.fSaleEntryID = se.fid ");
        sql.append("  where FRequirementPlanId = '").append(requirementPlanId).append("'");
        IRowSet rs = SQLUtils.executeQuery((Context)ctx, (String)sql.toString());
        ArrayList saleOrderInfoList = new ArrayList();
        EntryBaseStatusEnum statusEnum = null;
        try {
            while (rs.next()) {
                HashMap<String, Object> saleOrderInfoMap = new HashMap<String, Object>();
                saleOrderInfoMap.put("FSaleOrderId", rs.getString("FSaleOrderId"));
                saleOrderInfoMap.put("FSaleOrderNumber", rs.getString("FSaleOrderNumber"));
                saleOrderInfoMap.put("FQty", rs.getBigDecimal("FQty"));
                saleOrderInfoMap.put("FBaseQty", rs.getBigDecimal("FBaseQty"));
                saleOrderInfoMap.put("saleEntryID", rs.getString("fSaleEntryID"));
                saleOrderInfoMap.put("saleEntrySeq", new Integer(rs.getInt("fsaleEntrySeq")));
                saleOrderInfoMap.put("saleOrgUnitID", rs.getString("FSaleOrgUnitID"));
                int statusInt = rs.getInt("FBaseStatus");
                if (rs.getString("fparentid") != null) {
                    statusEnum = EntryBaseStatusEnum.getEnum((int)statusInt);
                    saleOrderInfoMap.put("FBaseStatus", statusEnum.getAlias());
                } else {
                    saleOrderInfoMap.put("FBaseStatus", ResourceBase.getString((String)"com.kingdee.eas.mm.planning.ReqPlanResource.hasDeleted", (Locale)ctx.getLocale()));
                }
                saleOrderInfoList.add(saleOrderInfoMap);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        RequirementPlanInfo requirementPlan = RequirementPlanFactory.getLocalInstance(ctx).getRequirementPlanInfo("select *, material.*,unit.name where id = '" + requirementPlanId + "'");
        map.put("requirementPlan", requirementPlan);
        map.put("saleOrder", saleOrderInfoList);
        return map;
    }

    private HashMap getPrecision(Context ctx, String requirementPlanId, HashMap map) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer();
        BigDecimal baseConvsRate = new BigDecimal("0.0");
        int baseQtyPrecision = 2;
        int qtyPrecision = 2;
        sb.append(" select mulUnit.FQtyPrecision as FQtyPrecision,  ");
        sb.append(" mulUnit2.FQtyPrecision as FbaseQtyPrecision ,mulUnit2.FBaseConvsRate ");
        sb.append(" from t_mm_requirementplan rp ");
        sb.append(" inner join t_bd_multimeasureunit mulUnit on mulUnit.FMaterialID = rp.FMaterialID and rp.FUnitID = mulUnit.FMeasureUnitID");
        sb.append(" inner join t_bd_multimeasureunit mulUnit2 on mulUnit2.FMaterialID = rp.FMaterialID ");
        sb.append(" and rp.FbaseUnitID = mulUnit2.FMeasureUnitID");
        sb.append(" where rp.Fid = '").append(requirementPlanId).append("'");
        IRowSet reqRow = SQLUtils.executeQuery((Context)ctx, (String)sb.toString());
        try {
            while (reqRow.next()) {
                baseConvsRate = reqRow.getBigDecimal("FBaseConvsRate");
                baseQtyPrecision = reqRow.getInt("FbaseQtyPrecision");
                qtyPrecision = reqRow.getInt("FQtyPrecision");
                map.put("baseConvsRate", baseConvsRate);
                map.put("baseQtyPrecision", new Integer(baseQtyPrecision));
                map.put("qtyPrecision", new Integer(qtyPrecision));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return map;
    }

    @Override
    protected Map _getManulWriteOffData(Context ctx, String requirementPlanId, boolean isManulWriteOff) throws BOSException, EASBizException {
        HashMap map = new HashMap();
        ArrayList<ReqPlanManulWriteOffDataVO> list = new ArrayList<ReqPlanManulWriteOffDataVO>();
        map = this.getPrecision(ctx, requirementPlanId, map);
        if (!isManulWriteOff) {
            Connection conn = null;
            PreparedStatement batchStatement = null;
            ResultSet reqRow = null;
            StringBuffer sb = new StringBuffer();
            sb.append(" select rp.fid, rp2.FSourceEntrySeq,p.fnumber as fproject ,  t.fnumber as ftracknumber,");
            sb.append(" c.fname_").append(ctx.getLocale()).append(" as FCustomer,");
            sb.append(" (case when rc.FBillTypeID = '").append("510b6503-0105-1000-e000-0113c0a812fd463ED552");
            sb.append("' then 'SID' when rc.FBillTypeID in ('").append("50957179-0105-1000-e003-3152c0a812fd463ED552");
            sb.append("','").append("Eg5BUQEVEADgAAABwKgOEEY+1VI=").append("') then 'MTD'");
            sb.append(" when rp.FReqTypeID = '").append("NcvxPgEcEADgAAiowKgL09hs+cg=").append("' then 'PRD' ");
            sb.append(" else 'MID' end ) as FReqType,");
            sb.append(" rc.FBillTypeID,bt.FName_");
            sb.append(ctx.getLocale());
            sb.append(" as FBillTypeName,rc.FSourceNumber,rc.FSourceID");
            sb.append(" ,rc.FSourceEntryID,rc.FQty as FContactQty,rc.FbaseQty as FContactBaseQty,rp2.FQty as FQty,mulUnit.FQtyPrecision as FQtyPrecision,  ");
            sb.append(" mulUnit2.FQtyPrecision as FbaseQtyPrecision ,mulUnit2.FBaseConvsRate ");
            sb.append(" from T_MM_ReqCounteractRelation as rc inner join t_scm_billtype bt on rc.FBillTypeID = bt.fID ");
            sb.append(" inner join t_mm_requirementplan as rp on rc.FDestID = rp.fID ");
            sb.append(" inner join t_mm_requirementplan as rp2 on rc.FSourceEntryID = rp2.FSourceEntryID ");
            sb.append(" left join t_mm_project as p on rp2.FProjectID = p.fID ");
            sb.append(" left join t_mm_tracknumber as t on rp2.FTrackNumberID = t.fID ");
            sb.append(" left join T_BD_Customer as c on rp2.FCustomerID = c.fID ");
            sb.append(" inner join t_bd_multimeasureunit mulUnit on mulUnit.FMaterialID = rp2.FMaterialID and rc.FUnitID = mulUnit.FMeasureUnitID");
            sb.append(" inner join t_bd_multimeasureunit mulUnit2 on mulUnit2.FMaterialID = rp2.FMaterialID ");
            sb.append(" and rc.FbaseUnitID = mulUnit2.FMeasureUnitID");
            sb.append(" where rc.FDestID = ?  order by rc.FBillTypeID ,rc.FSourceNumber,rp2.FSourceEntrySeq ");
            try {
                conn = EJBFactory.getConnection((Context)ctx);
                String sql_t = sb.toString();
                batchStatement = conn.prepareStatement(sql_t);
                batchStatement.setString(1, requirementPlanId);
                reqRow = batchStatement.executeQuery();
                while (reqRow.next()) {
                    ReqPlanManulWriteOffDataVO billVO = new ReqPlanManulWriteOffDataVO();
                    billVO.setBillID(reqRow.getString("FSourceID"));
                    billVO.setBillEntryID(reqRow.getString("FSourceEntryID"));
                    billVO.setBillTypeID(reqRow.getString("FBillTypeID"));
                    billVO.setBillTypeName(reqRow.getString("FBillTypeName"));
                    billVO.setQty(reqRow.getBigDecimal("FQty"));
                    billVO.setContactQty(reqRow.getBigDecimal("FContactQty"));
                    billVO.setContactBaseQty(reqRow.getBigDecimal("FContactBaseQty"));
                    billVO.setReqType(reqRow.getString("FReqType"));
                    billVO.setCustomer(reqRow.getString("FCustomer"));
                    billVO.setProject(reqRow.getString("fproject"));
                    billVO.setTrackNumber(reqRow.getString("ftracknumber"));
                    billVO.setId(reqRow.getString("fid"));
                    billVO.setNumber(reqRow.getString("FSourceNumber"));
                    billVO.setBillEntrySeq(reqRow.getInt("FSourceEntrySeq"));
                    list.add(billVO);
                }
            }
            catch (SQLException e) {
                try {
                    throw new SQLDataException(e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(reqRow, batchStatement, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)reqRow, (Statement)batchStatement, (Connection)conn);
        }
        map.put("list", list);
        return map;
    }
}

