/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.cssp.app.DataImportUtils;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.ManufactureStrategyInfo;
import com.kingdee.eas.basedata.master.material.MaterialBaseException;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialPlanFactory;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.master.material.PerminsionUtil;
import com.kingdee.eas.basedata.master.material.PlanningModeEnum;
import com.kingdee.eas.basedata.master.material.app.DataImportTools;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mm.basedata.ITrackNumber;
import com.kingdee.eas.mm.basedata.TrackNumberCollection;
import com.kingdee.eas.mm.basedata.TrackNumberFactory;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.common.util.MMConstant;
import com.kingdee.eas.mm.common.util.MMUtils;
import com.kingdee.eas.mm.common.util.ResourceManage;
import com.kingdee.eas.mm.planning.IRequirementPlan;
import com.kingdee.eas.mm.planning.ReqPlanStatusEnum;
import com.kingdee.eas.mm.planning.ReqPlanWriteOffFacadeFactory;
import com.kingdee.eas.mm.planning.RequireSourceEnum;
import com.kingdee.eas.mm.planning.RequirementPlanFactory;
import com.kingdee.eas.mm.planning.RequirementPlanInfo;
import com.kingdee.eas.mm.planning.RequirementTypeInfo;
import com.kingdee.eas.mm.project.IProject;
import com.kingdee.eas.mm.project.ProjectCollection;
import com.kingdee.eas.mm.project.ProjectFactory;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.TypeConversionUtils;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;

public class RequirementPlanDataTransmission
extends AbstractDataTransmission {
    public static final BigDecimal zero = new BigDecimal(0);
    public static final String REQPLAN_RESOURCE_PATH = "com.kingdee.eas.mm.planning.ReqPlanResource";
    public static final String PROJECT_RESOURCE_PATH = "com.kingdee.eas.mm.project.ProjectResource";
    public static final String TRACK_NUMBER_RESOURCE_PATH = "com.kingdee.eas.mm.basedata.TrackNumberResource";
    Map cacheStorageOrgUnit = new HashMap();
    Map cacheMaterial = new HashMap();
    Map cacheProject = new HashMap();
    Map cacheTrackNumber = new HashMap();

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return RequirementPlanFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        try {
            return this.innerTransmit(hsData, ctx);
        }
        catch (TaskExternalException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        try {
            RequirementPlanInfo info = (RequirementPlanInfo)coreBaseInfo;
            this.getController(ctx).submit(coreBaseInfo);
            ReqPlanWriteOffFacadeFactory.getLocalInstance(ctx).batchDealCounteract(info.getStorageOrgUnit().getId().toString());
        }
        catch (EASBizException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    protected CoreBaseInfo innerTransmit(Hashtable hsData, Context ctx) throws TaskExternalException, Exception {
        Object data = ((DataToken)hsData.get((Object)"FStorageOrgUnit_number")).data;
        if (data == null) {
            throw new TaskExternalException(DataImportUtils.getResource((String)"com.kingdee.eas.basedata.master.material.MaterialAddResource", (String)"GetInventoryOrgUnitFailed", (Context)ctx));
        }
        StorageOrgUnitInfo storageOrgUnit = this.getStorageOrgByNumber(ctx, data.toString());
        if (storageOrgUnit == null) {
            storageOrgUnit = ContextUtil.getCurrentStorageUnit((Context)ctx);
        }
        if (storageOrgUnit == null) {
            throw new TaskExternalException(DataImportUtils.getResource((String)"com.kingdee.eas.basedata.master.material.MaterialAddResource", (String)"GetInventoryOrgUnitFailed", (Context)ctx));
        }
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        if (!PerminsionUtil.isUserBizOrgRange((Context)ctx, (String)userId, (String)storageOrgUnit.getId().toString())) {
            throw new TaskExternalException(new MaterialBaseException(MaterialBaseException.OUT_BIZ_ORG, new Object[]{storageOrgUnit.getName()}).getMessage());
        }
        RequirementPlanInfo info = new RequirementPlanInfo();
        info.setStorageOrgUnit(storageOrgUnit);
        info.setSourceSU(storageOrgUnit);
        info.setCU(storageOrgUnit.getCU());
        String strTemp = (String)((DataToken)hsData.get((Object)"FMaterial_number")).data;
        MaterialInfo materialInfo = this.getMaterialInfo(ctx, storageOrgUnit.getCU(), strTemp);
        info.setMaterial(materialInfo);
        IMaterial imaterial = MaterialFactory.getLocalInstance((Context)ctx);
        MaterialPlanInfo materialPlanInfo = MaterialPlanFactory.getLocalInstance((Context)ctx).getPlanInfo(materialInfo.getId().toString(), storageOrgUnit.getId().toString());
        if (materialPlanInfo == null) {
            throw new TaskExternalException(DataImportUtils.getResource((String)REQPLAN_RESOURCE_PATH, (String)"IMPORT_MATERIALPLAN_NULL", (Context)ctx));
        }
        if (materialPlanInfo.getPlanningMode() != PlanningModeEnum.MPS && materialPlanInfo.getPlanningMode() != PlanningModeEnum.MRP) {
            throw new TaskExternalException(DataImportUtils.getResource((String)REQPLAN_RESOURCE_PATH, (String)"IMPORT_PLANINGMODE_INVALID", (Context)ctx));
        }
        if (materialPlanInfo.getManufactureStrategy() == null) {
            throw new TaskExternalException(DataImportUtils.getResource((String)REQPLAN_RESOURCE_PATH, (String)"IMPORT_MANUSTRATEGY_NULL", (Context)ctx));
        }
        info.setPlanMode(materialPlanInfo.getPlanningMode());
        info.setManuStrategy(materialPlanInfo.getManufactureStrategy());
        strTemp = (String)((DataToken)hsData.get((Object)"FUnit_number")).data;
        if (null != strTemp && !"".equals(strTemp) && materialPlanInfo.getProductUnit() != null && !materialPlanInfo.getProductUnit().getNumber().equals(strTemp)) {
            throw new TaskExternalException(DataImportUtils.getResource((String)REQPLAN_RESOURCE_PATH, (String)"IMPORT_PRODUCTUNITNOTCONSIS", (Context)ctx));
        }
        info.setBaseUnit(materialInfo.getBaseUnit());
        MeasureUnitInfo unit = materialPlanInfo.getProductUnit();
        unit = MeasureUnitFactory.getLocalInstance((Context)ctx).getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(unit.getId().toString()));
        info.setUnit(materialPlanInfo.getProductUnit());
        BigDecimal reqQty = DataImportTools.getDataBigDecimal((Hashtable)hsData, (String)"FQty");
        if (reqQty == null || reqQty.compareTo(zero) <= 0) {
            throw new TaskExternalException(DataImportUtils.getResource((String)REQPLAN_RESOURCE_PATH, (String)"IMPORT_REQQTY_INVALID", (Context)ctx));
        }
        BigDecimal baseReqQty = SCMUtils.getExchangeQtyForServer((Context)ctx, (String)materialInfo.getId().toString(), (String)materialPlanInfo.getProductUnit().getId().toString(), (BigDecimal)reqQty, (String)materialInfo.getBaseUnit().getId().toString());
        reqQty = SCMUtils.getExchangeQtyForServer((Context)ctx, (String)materialInfo.getId().toString(), (String)materialPlanInfo.getProductUnit().getId().toString(), (BigDecimal)reqQty, (String)materialPlanInfo.getProductUnit().getId().toString());
        info.setQty(reqQty);
        info.setBaseQty(baseReqQty);
        Date reqDate = RequirementPlanDataTransmission.getDataDate(hsData, "FRequireDate");
        String fieldValue = (String)((DataToken)hsData.get((Object)"FRequireDate")).data;
        if (reqDate == null) {
            throw new TaskExternalException(DataImportUtils.getResource((String)REQPLAN_RESOURCE_PATH, (String)"IMPORT_REQDATE_CANNOTNULL", (Context)ctx));
        }
        reqDate = MMUtils.stringToDate((String)fieldValue, (String)"yyyy-MM-dd");
        info.setRequireDate(reqDate);
        strTemp = (String)((DataToken)hsData.get((Object)"FReqType_number")).data;
        RequirementTypeInfo reqTypeInfo = new RequirementTypeInfo();
        if (strTemp == null || strTemp.equals("")) {
            throw new TaskExternalException(DataImportUtils.getResource((String)REQPLAN_RESOURCE_PATH, (String)"IMPORT_REQTYPE_CANNOTNULL", (Context)ctx));
        }
        if (strTemp.equalsIgnoreCase("PIC")) {
            reqTypeInfo.setId(BOSUuid.read((String)"NcvxPgEcEADgAAiqwKgL09hs+cg="));
            reqTypeInfo.setNumber(strTemp);
            reqTypeInfo.setName(strTemp);
        } else if (strTemp.equalsIgnoreCase("PID")) {
            reqTypeInfo.setId(BOSUuid.read((String)"NcvxPgEcEADgAAiowKgL09hs+cg="));
            reqTypeInfo.setNumber(strTemp);
            reqTypeInfo.setName(strTemp);
        } else {
            throw new TaskExternalException(DataImportUtils.getResource((String)REQPLAN_RESOURCE_PATH, (String)"IMPORT_REQTYPE_INVALIDE", (Context)ctx));
        }
        ManufactureStrategyInfo manufactureStrategyinfo = materialPlanInfo.getManufactureStrategy();
        if (manufactureStrategyinfo.getId().toString().equals("NUnM+gEcEADgAA3cwKgL09g0uEU=") && reqTypeInfo.getId().toString().equals("NcvxPgEcEADgAAiqwKgL09hs+cg=")) {
            throw new TaskExternalException(MMUtils.getResourceWithParam((String)REQPLAN_RESOURCE_PATH, (String)"IMPORT_STRATEGY_REQTYPE_NOTMATCH", (Locale)ctx.getLocale(), (String[])new String[]{"MTS10", "PID"}));
        }
        if (manufactureStrategyinfo.getId().toString().equals("NUnM+gEcEADgAA3cwKgL09g0uEU=") && reqTypeInfo.getId().toString().equals("NcvxPgEcEADgAAiqwKgL09hs+cg=")) {
            throw new TaskExternalException(MMUtils.getResourceWithParam((String)REQPLAN_RESOURCE_PATH, (String)"IMPORT_STRATEGY_REQTYPE_NOTMATCH", (Locale)ctx.getLocale(), (String[])new String[]{"MTS11", "PID"}));
        }
        info.setReqType(reqTypeInfo);
        info.setCntactTotalQty(zero);
        info.setBaseCntactTotalQty(zero);
        info.setNotCntactQty(zero);
        info.setBaseNotCntactQty(zero);
        info.setReqSource(RequireSourceEnum.MANUAL);
        info.setStatus(ReqPlanStatusEnum.ACTIVE);
        strTemp = (String)((DataToken)hsData.get((Object)"FProject_number")).data;
        ProjectInfo prj = null;
        if (strTemp != null && strTemp.trim().length() != 0) {
            prj = this.getProjectInfo(ctx, storageOrgUnit.getCU(), strTemp);
        }
        info.setProject(prj);
        strTemp = (String)((DataToken)hsData.get((Object)"FTrackNumber_number")).data;
        TrackNumberInfo trace = null;
        if (strTemp != null && strTemp.trim().length() != 0) {
            trace = this.getTrackNumberInfo(ctx, storageOrgUnit.getCU(), prj, strTemp);
        }
        info.setTrackNumber(trace);
        String reqPlanNumber = this.getNewNumberByUnit(ctx, storageOrgUnit.getId().toString(), (IObjectValue)info);
        if (reqPlanNumber == null) {
            throw new TaskExternalException(DataImportUtils.getResource((String)REQPLAN_RESOURCE_PATH, (String)"EXCEPTION_NOCODEINGRULE", (Context)ctx));
        }
        info.setNumber(reqPlanNumber);
        strTemp = (String)((DataToken)hsData.get((Object)"FIsDirectTransport")).data;
        if (strTemp != null && strTemp.trim().length() != 0) {
            if (EASResource.getString((String)"com.kingdee.eas.mm.planning.ReqPlanResource.isTrue").equalsIgnoreCase(strTemp)) {
                info.setIsDirectTransport(true);
            } else {
                info.setIsDirectTransport(false);
            }
        }
        strTemp = (String)((DataToken)hsData.get((Object)"FPlanner_number")).data;
        PersonInfo planner = null;
        if (strTemp != null && strTemp.trim().length() != 0) {
            planner = this.getPlannerInfo(ctx, storageOrgUnit.getCU(), strTemp);
            info.setPlanner(planner);
        }
        strTemp = (String)((DataToken)hsData.get((Object)"FProductionDept_number")).data;
        AdminOrgUnitInfo dept = null;
        if (strTemp != null && strTemp.trim().length() != 0) {
            dept = this.getProductionDeptInfo(ctx, strTemp);
            info.setProductionDept(dept);
        }
        return info;
    }

    public static Date getDataDate(Hashtable hsData, String fieldName) throws Exception {
        Object o = ((DataToken)hsData.get((Object)fieldName)).data;
        if (o == null) {
            return null;
        }
        String str = o.toString();
        if (str == null || "".equals(str)) {
            return null;
        }
        if (str.length() == 5) {
            Calendar calendar = Calendar.getInstance();
            calendar.set(1900, 1, 1);
            calendar.add(6, new Integer(str));
            Date curTime = calendar.getTime();
            return curTime;
        }
        return TypeConversionUtils.objToDate((Object)str);
    }

    private String getNewNumberByUnit(Context ctx, String bizOrgUnitID, IObjectValue info) throws BOSException, EASBizException {
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        if (iCodingRuleManager.isExist(info, bizOrgUnitID)) {
            return iCodingRuleManager.getNumber(info, bizOrgUnitID);
        }
        return null;
    }

    private String removeBigDecimalZero(BigDecimal qty) {
        String qtyString = "0";
        if (qty.compareTo(MMConstant.BIGDECIMAL_ZERO) == 0) {
            qtyString = "0";
        } else {
            qtyString = qty.toString();
            int pointIndex = qtyString.indexOf(".");
            if (pointIndex == -1) {
                return qtyString;
            }
            while (qtyString.lastIndexOf("0") == qtyString.length() - 1 && qtyString.lastIndexOf("0") > pointIndex) {
                qtyString = qtyString.substring(0, qtyString.length() - 1);
            }
            if (qtyString.lastIndexOf(".") == qtyString.length() - 1) {
                qtyString = qtyString.substring(0, qtyString.length() - 1);
            }
        }
        return qtyString;
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable result = new Hashtable();
        try {
            Locale currentLocale = ctx.getLocale();
            RequirementPlanDataTransmission.putTable(result, "FStorageOrgUnit_number", rs.getString("storageOrgUnit.number"));
            RequirementPlanDataTransmission.putTable(result, "FMaterial_number", rs.getString("material.number"));
            RequirementPlanDataTransmission.putTable(result, "FMaterial_name_" + currentLocale.getLanguage(), rs.getString("material.name"));
            String qtyString = this.removeBigDecimalZero(rs.getBigDecimal("qty"));
            RequirementPlanDataTransmission.putTable(result, "FQty", qtyString);
            RequirementPlanDataTransmission.putTable(result, "FCntactTotalQty", this.removeBigDecimalZero(rs.getBigDecimal("cntactTotalQty")));
            RequirementPlanDataTransmission.putTable(result, "FUnit_number", rs.getString("unit.number"));
            RequirementPlanDataTransmission.putTable(result, "FUnit_name_" + currentLocale.getLanguage(), rs.getString("unit.name"));
            RequirementPlanDataTransmission.putTable(result, "FRequireDate", rs.getString("requireDate"));
            RequirementPlanDataTransmission.putTable(result, "FPlanMode", PlanningModeEnum.getEnum((int)rs.getInt("planMode")).getAlias(currentLocale));
            RequirementPlanDataTransmission.putTable(result, "FManuStrategy_number", rs.getString("manuStrategy.number"));
            RequirementPlanDataTransmission.putTable(result, "FReqType_number", rs.getString("reqType.number"));
            RequirementPlanDataTransmission.putTable(result, "FReqSource", RequireSourceEnum.getEnum(rs.getInt("reqSource")).getAlias(currentLocale));
            RequirementPlanDataTransmission.putTable(result, "FSourceBillNum", rs.getString("sourceBillNum"));
            RequirementPlanDataTransmission.putTable(result, "FSourceEntrySeq", rs.getString("sourceEntrySeq"));
            RequirementPlanDataTransmission.putTable(result, "FSourceSU_number", rs.getString("sourceSU.number"));
            RequirementPlanDataTransmission.putTable(result, "FStatus", ReqPlanStatusEnum.getEnum(rs.getInt("status")).getAlias(currentLocale));
            RequirementPlanDataTransmission.putTable(result, "FProject_number", rs.getString("project.number"));
            RequirementPlanDataTransmission.putTable(result, "FTrackNumber_number", rs.getString("trackNumber.number"));
            String direntTransport = null;
            direntTransport = rs.getBoolean("isDirectTransport") ? EASResource.getString((String)"com.kingdee.eas.mm.planning.ReqPlanResource.isTrue") : EASResource.getString((String)"com.kingdee.eas.mm.planning.ReqPlanResource.isFalse");
            RequirementPlanDataTransmission.putTable(result, "FIsDirectTransport", direntTransport);
            if (rs.getString("calculateTime") != null) {
                String cTime = rs.getString("calculateTime");
                RequirementPlanDataTransmission.putTable(result, "FCalculateTime", cTime.substring(0, cTime.indexOf(".")));
            }
            if (rs.getString("planner.number") != null) {
                RequirementPlanDataTransmission.putTable(result, "FPlanner_number", rs.getString("planner.number"));
            }
            if (rs.getString("productionDept.number") != null) {
                RequirementPlanDataTransmission.putTable(result, "FProductionDept_number", rs.getString("productionDept.number"));
            }
        }
        catch (Exception e) {
            throw new TaskExternalException("", (Throwable)e);
        }
        return result;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.mm.planning.app.RequirementPlanQuery";
    }

    public static void putTable(Hashtable htable, Object key, Object value) {
        if (value != null) {
            htable.put(key, value);
        }
    }

    public StorageOrgUnitInfo getStorageOrgByNumber(Context ctx, String number) throws BOSException, EASBizException, TaskExternalException {
        if (number == null || "".equals(number)) {
            return null;
        }
        Object result = this.cacheStorageOrgUnit.get(number);
        if (result == null) {
            result = DataImportTools.getStorageOrgUnitInfoFromNumber((Context)ctx, (String)number);
            this.cacheStorageOrgUnit.put(number, result);
        }
        return (StorageOrgUnitInfo)result;
    }

    protected MaterialInfo getMaterialInfo(Context ctx, CtrlUnitInfo ctrlUnit, String number) throws BOSException, EASBizException, TaskExternalException {
        Object result;
        try {
            IMaterial iMat = MaterialFactory.getLocalInstance((Context)ctx);
            if (ctrlUnit == null) {
                ctrlUnit = ContextUtil.getCurrentCtrlUnit((Context)ctx);
            }
            if ((result = this.cacheMaterial.get(ctrlUnit.getId().toString() + number)) == null) {
                EntityViewInfo viewInfo = new EntityViewInfo();
                FilterInfo filter = iMat.getDatabaseDFilter((IObjectPK)new ObjectUuidPK(ctrlUnit.getId()), "id", "adminCU.id");
                FilterInfo filterNumber = new FilterInfo();
                filterNumber.getFilterItems().add(new FilterItemInfo("number", (Object)number));
                filter.mergeFilter(filterNumber, "and");
                viewInfo.setFilter(filter);
                MaterialCollection matCollection = iMat.getMaterialCollection(viewInfo);
                if (matCollection == null || matCollection.size() <= 0) {
                    throw new TaskExternalException(DataImportTools.getResString((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"DataImport_MaterialNumber_Error", (Locale)ctx.getLocale()));
                }
                result = matCollection.get(0);
                this.cacheMaterial.put(ctrlUnit.getId().toString() + number, result);
            }
        }
        catch (BOSException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
        return (MaterialInfo)result;
    }

    protected ProjectInfo getProjectInfo(Context ctx, CtrlUnitInfo ctrlUnit, String number) throws BOSException, EASBizException, TaskExternalException {
        Object result;
        try {
            IProject iProject = ProjectFactory.getLocalInstance((Context)ctx);
            if (ctrlUnit == null) {
                ctrlUnit = ContextUtil.getCurrentCtrlUnit((Context)ctx);
            }
            if ((result = this.cacheProject.get(ctrlUnit.getId().toString() + number)) == null) {
                EntityViewInfo viewInfo = new EntityViewInfo();
                FilterInfo filter = iProject.getDatabaseDFilter((IObjectPK)new ObjectUuidPK(ctrlUnit.getId()), "id", "CU.id");
                FilterInfo filterNumber = new FilterInfo();
                filterNumber.getFilterItems().add(new FilterItemInfo("number", (Object)number));
                filter.mergeFilter(filterNumber, "and");
                viewInfo.setFilter(filter);
                ProjectCollection collection = iProject.getProjectCollection(viewInfo);
                if (collection == null || collection.size() <= 0) {
                    throw new TaskExternalException(DataImportTools.getResString((String)PROJECT_RESOURCE_PATH, (String)"DataImport_ProjectNumber_Error", (Locale)ctx.getLocale()));
                }
                result = collection.get(0);
                this.cacheProject.put(ctrlUnit.getId().toString() + number, result);
            }
        }
        catch (BOSException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
        return (ProjectInfo)result;
    }

    protected TrackNumberInfo getTrackNumberInfo(Context ctx, CtrlUnitInfo ctrlUnit, ProjectInfo project, String number) throws BOSException, EASBizException, TaskExternalException {
        Object result;
        try {
            StringBuffer str = new StringBuffer();
            if (project != null) {
                str.append(" select t.fid from T_MM_TRACKNUMBER as t ").append("inner join T_MM_ProjectCar as p on p.FTrackNumberID = t.fid ").append(" where t.fnumber = '").append(number).append("'").append(" and p.FProjectID = '").append(project.getId().toString()).append("'");
            }
            ITrackNumber iTrackNumber = TrackNumberFactory.getLocalInstance((Context)ctx);
            if (ctrlUnit == null) {
                ctrlUnit = ContextUtil.getCurrentCtrlUnit((Context)ctx);
            }
            if ((result = this.cacheTrackNumber.get(ctrlUnit.getId().toString() + number)) == null) {
                EntityViewInfo viewInfo = new EntityViewInfo();
                FilterInfo filter = iTrackNumber.getDatabaseDFilter((IObjectPK)new ObjectUuidPK(ctrlUnit.getId()), "id", "CU.id");
                FilterInfo filterNumber = new FilterInfo();
                filterNumber.getFilterItems().add(new FilterItemInfo("number", (Object)number));
                if (project != null) {
                    filterNumber.getFilterItems().add(new FilterItemInfo("id", (Object)str.toString(), CompareType.INNER));
                }
                filter.mergeFilter(filterNumber, "and");
                viewInfo.setFilter(filter);
                TrackNumberCollection collection = iTrackNumber.getTrackNumberCollection(viewInfo);
                if ((collection == null || collection.size() <= 0) && number != null && project != null) {
                    throw new TaskExternalException(DataImportTools.getResString((String)REQPLAN_RESOURCE_PATH, (String)"traceNumberNotInProject", (Locale)ctx.getLocale()));
                }
                if (collection == null || collection.size() <= 0) {
                    throw new TaskExternalException(DataImportTools.getResString((String)TRACK_NUMBER_RESOURCE_PATH, (String)"DataImport_TrackNumberNumber_Error", (Locale)ctx.getLocale()));
                }
                result = collection.get(0);
                this.cacheTrackNumber.put(ctrlUnit.getId().toString() + number, result);
            }
        }
        catch (BOSException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
        return (TrackNumberInfo)result;
    }

    private PersonInfo getPlannerInfo(Context ctx, CtrlUnitInfo ctrlUnit, String number) throws BOSException, EASBizException, TaskExternalException {
        PersonInfo planner = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        IPerson iPerson = PersonFactory.getLocalInstance((Context)ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        viewInfo.setFilter(filter);
        PersonCollection collection = iPerson.getPersonCollection(viewInfo);
        if (collection != null && collection.size() > 0) {
            planner = collection.get(0);
        }
        return planner;
    }

    private AdminOrgUnitInfo getProductionDeptInfo(Context ctx, String number) throws BOSException, EASBizException, TaskExternalException {
        AdminOrgUnitInfo productionDept = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        IAdminOrgUnit iAdminOrgUnit = AdminOrgUnitFactory.getLocalInstance((Context)ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        viewInfo.setFilter(filter);
        AdminOrgUnitCollection collection = iAdminOrgUnit.getAdminOrgUnitCollection(viewInfo);
        if (collection != null && collection.size() > 0) {
            productionDept = collection.get(0);
        }
        return productionDept;
    }

    protected void verifyReqDup(Context ctx, RequirementPlanInfo info) throws Exception {
        String materialID = info.getMaterial().getId().toString();
        String reqTypeID = info.getReqType().getId().toString();
        Integer reqSource = new Integer(info.getReqSource().getValue());
        Date reqDateFrom = info.getRequireDate();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(reqDateFrom);
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 23, 59, 59);
        Date reqDateTo = calendar.getTime();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialID, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("requireDate", (Object)reqDateFrom, CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("requireDate", (Object)reqDateTo, CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("reqType.id", (Object)reqTypeID, CompareType.EQUALS));
        if (info.getProject() == null) {
            filter.getFilterItems().add(new FilterItemInfo("project.id", null, CompareType.EQUALS));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("project.id", (Object)info.getProject().getId().toString(), CompareType.EQUALS));
        }
        if (info.getTrackNumber() == null) {
            filter.getFilterItems().add(new FilterItemInfo("trackNumber.id", null, CompareType.EQUALS));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("trackNumber.id", (Object)info.getTrackNumber().getId().toString(), CompareType.EQUALS));
        }
        filter.getFilterItems().add(new FilterItemInfo("reqSource", (Object)reqSource, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)info.getStorageOrgUnit().getId().toString(), CompareType.EQUALS));
        IRequirementPlan irequirementPlan = RequirementPlanFactory.getLocalInstance(ctx);
        if (irequirementPlan.exists(filter)) {
            StringBuffer sb = new StringBuffer();
            sb.append(ResourceManage.getResource((String)REQPLAN_RESOURCE_PATH, (String)"sameMaterial", (Locale)ctx.getLocale()));
            sb.append(info.getMaterial().getNumber());
            sb.append(",");
            sb.append(ResourceManage.getResource((String)REQPLAN_RESOURCE_PATH, (String)"sameDate", (Locale)ctx.getLocale()));
            sb.append(reqDateFrom);
            sb.append(",");
            sb.append(ResourceManage.getResource((String)REQPLAN_RESOURCE_PATH, (String)"sameType", (Locale)ctx.getLocale()));
            sb.append(info.getReqType().getName());
            sb.append(",");
            if (info.getProject() != null) {
                sb.append(ResourceManage.getResource((String)REQPLAN_RESOURCE_PATH, (String)"sameProject", (Locale)ctx.getLocale()));
                sb.append(info.getProject().getNumber());
                sb.append(",");
            }
            if (info.getTrackNumber() != null) {
                sb.append(ResourceManage.getResource((String)REQPLAN_RESOURCE_PATH, (String)"sameTrackNumber", (Locale)ctx.getLocale()));
                sb.append(info.getTrackNumber().getNumber());
                sb.append(",");
            }
            sb.append(ResourceManage.getResource((String)REQPLAN_RESOURCE_PATH, (String)"sameReqSource", (Locale)ctx.getLocale()));
            sb.append(info.getReqSource().getAlias());
            sb.append(ResourceManage.getResource((String)REQPLAN_RESOURCE_PATH, (String)"suffix", (Locale)ctx.getLocale()));
            throw new TaskExternalException(sb.toString());
        }
    }
}

