/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.codingrule.RuleStatus;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.app.dao.ReferenceDAO;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.Result;
import com.kingdee.eas.mm.basedata.MMBasedataStatusEnum;
import com.kingdee.eas.mm.common.app.CodingRulerSrvHelper;
import com.kingdee.eas.mm.planning.IRequirementUniteRule;
import com.kingdee.eas.mm.planning.ReqUniteRuleException;
import com.kingdee.eas.mm.planning.RequirementUniteRuleCollection;
import com.kingdee.eas.mm.planning.RequirementUniteRuleFactory;
import com.kingdee.eas.mm.planning.RequirementUniteRuleInfo;
import com.kingdee.eas.mm.planning.app.AbstractRequirementUniteRuleControllerBean;
import com.kingdee.eas.util.BizReference;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class RequirementUniteRuleControllerBean
extends AbstractRequirementUniteRuleControllerBean {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.planning.app.RequirementUniteRuleControllerBean");
    private ICodingRuleManager codingRuleManager;
    private RuleStatus ruleStatus;

    @Override
    public Result save(Context ctx, CoreBaseCollection colls) throws BOSException, EASBizException {
        RequirementUniteRuleInfo model = null;
        Result rt = new Result();
        for (int i = 0; i < colls.size(); ++i) {
            model = (RequirementUniteRuleInfo)colls.get(i);
            this.save(ctx, (CoreBaseInfo)model);
        }
        return rt;
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        RequirementUniteRuleInfo info = (RequirementUniteRuleInfo)model;
        info.setStatus(MMBasedataStatusEnum.SAVED);
        this.checkNumber(ctx, model);
        return super._save(ctx, (IObjectValue)info);
    }

    protected FilterInfo getFilterForDefaultCU(Context ctx, IObjectValue model) {
        FilterInfo filter = new FilterInfo();
        RequirementUniteRuleInfo info = (RequirementUniteRuleInfo)model;
        if (info == null) {
            return null;
        }
        filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)info.getStorageOrgUnit().getId().toString(), CompareType.EQUALS));
        return filter;
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        RequirementUniteRuleInfo info = this.getRequirementUniteRuleInfo(ctx, pk);
        if (info.getStatus().getValue() == 20) {
            throw new ReqUniteRuleException(ReqUniteRuleException.OPEN_CANT_DELETE, new Object[]{info.getNumber()});
        }
        if ("MQR-001".equals(info.getNumber())) {
            throw new ReqUniteRuleException(ReqUniteRuleException.DEFAULT, new Object[]{info.getNumber()});
        }
        super._delete(ctx, pk);
    }

    @Override
    protected StringBuffer _setCancel(Context ctx, ArrayList ids) throws BOSException, EASBizException {
        RequirementUniteRuleCollection collection = this.getRequirementUniteRuleCollectionByIds(ctx, ids);
        StringBuffer errors = new StringBuffer();
        errors = this.doCancelCancelOrCancel(ctx, collection, MMBasedataStatusEnum.CLOSE, ids);
        return errors;
    }

    @Override
    protected StringBuffer _setCancelCancel(Context ctx, ArrayList ids) throws BOSException, EASBizException {
        RequirementUniteRuleCollection collection = this.getRequirementUniteRuleCollectionByIds(ctx, ids);
        StringBuffer errors = new StringBuffer();
        errors = this.doCancelCancelOrCancel(ctx, collection, MMBasedataStatusEnum.OPEN, ids);
        return errors;
    }

    private RequirementUniteRuleCollection getRequirementUniteRuleCollectionByIds(Context ctx, ArrayList ids) throws BOSException {
        RequirementUniteRuleCollection ruleColl = null;
        if (ids != null) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(ids), CompareType.INCLUDE));
            viewInfo.setFilter(filter);
            viewInfo.getSelector().add(new SelectorItemInfo("status"));
            viewInfo.getSelector().add(new SelectorItemInfo("number"));
            ruleColl = this.getRequirementUniteRuleCollection(ctx, viewInfo);
        }
        return ruleColl;
    }

    private StringBuffer doCancelCancelOrCancel(Context ctx, RequirementUniteRuleCollection collection, MMBasedataStatusEnum status, List ids) throws BOSException {
        StringBuffer errors = new StringBuffer();
        RequirementUniteRuleInfo ruleInfo = null;
        Object[] number = null;
        String id = null;
        RequirementUniteRuleCollection successInfo = new RequirementUniteRuleCollection();
        IMutexServiceControl mutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        Map requestResult = mutex.batchRequestObjIDForUpdate(ids);
        HashSet<IObjectPK> pks = new HashSet<IObjectPK>();
        IObjectPK pk2 = null;
        for (int i = 0; i < collection.size(); ++i) {
            try {
                ruleInfo = collection.get(i);
                number = new String[]{ruleInfo.getNumber()};
                id = ruleInfo.getId().toString();
                String logNumber = "mm_requirementUniteRule_cancel";
                if (status.getValue() == 20) {
                    logNumber = "mm_requirementUniteRule_cancelcancel";
                }
                pk2 = LogUtil.beginLog((Context)ctx, (String)ruleInfo.getStatus().getName(), (BOSObjectType)ruleInfo.getBOSType(), null, (String)ruleInfo.getNumber(), (String)logNumber);
                if (!((Boolean)requestResult.get(id)).booleanValue()) {
                    throw new ReqUniteRuleException(ReqUniteRuleException.RULE_MUTEX, number);
                }
                if (status.getValue() == 20 && ruleInfo.getStatus().getValue() == 20) {
                    throw new ReqUniteRuleException(ReqUniteRuleException.RULE_IS_OPEND, number);
                }
                if (status.getValue() == 30) {
                    if (ruleInfo.getStatus().getValue() != 20) {
                        throw new ReqUniteRuleException(ReqUniteRuleException.RULE_NOT_OPEND, number);
                    }
                    if (this.checkReference(ctx, id)) {
                        throw new ReqUniteRuleException(ReqUniteRuleException.RULE_IS_REFERENCE, number);
                    }
                }
                ruleInfo.setStatus(status);
                successInfo.add(ruleInfo);
                pks.add(pk2);
                continue;
            }
            catch (EASBizException ee) {
                errors.append(ee.getMessage());
                if (i == collection.size()) continue;
                errors.append("\n");
            }
        }
        this.doUpdate(ctx, successInfo);
        for (IObjectPK pk2 : pks) {
            LogUtil.afterLog((Context)ctx, (IObjectPK)pk2);
        }
        mutex.batchReleaseObjIDForUpdate(ids);
        return errors;
    }

    private boolean checkReference(Context ctx, String id) throws EASBizException {
        boolean isReference = false;
        BizReference ref = null;
        ref = ReferenceDAO.getReference((Context)ctx, (BOSUuid)BOSUuid.read((String)id));
        if (ref != null) {
            isReference = true;
        }
        return isReference;
    }

    private void doUpdate(Context ctx, RequirementUniteRuleCollection collection) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("update t_mm_requirementuniterule set FStatus= ?  where FID = ? ");
        Connection con = null;
        PreparedStatement statement = null;
        try {
            con = this.getConnection(ctx);
            statement = con.prepareStatement(sql.toString());
            for (int i = 0; i < collection.size(); ++i) {
                RequirementUniteRuleInfo ruleInfo = collection.get(i);
                statement.setInt(1, ruleInfo.getStatus().getValue());
                statement.setString(2, ruleInfo.getId().toString());
                statement.addBatch();
            }
            statement.executeBatch();
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(statement, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)statement, (Connection)con);
    }

    protected void checkNumber(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        RequirementUniteRuleInfo ruleInfo = (RequirementUniteRuleInfo)model;
        CodingRulerSrvHelper codeHelper = new CodingRulerSrvHelper();
        codeHelper.setBizOrgPropertyName("storageOrgUnit");
        IRequirementUniteRule base = RequirementUniteRuleFactory.getLocalInstance(ctx);
        codeHelper.checkNumber(ctx, (ICoreBase)base, model, (OrgUnitInfo)ruleInfo.getStorageOrgUnit());
    }

    private String getCodingRuleManager(Context ctx, StorageOrgUnitInfo storage) throws BOSException, EASBizException {
        String newNum = null;
        if (this.codingRuleManager == null) {
            this.codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        }
        if (storage != null) {
            this.ruleStatus = this.codingRuleManager.getRuleStatus((IObjectValue)new RequirementUniteRuleInfo(), storage.getId().toString());
            if (this.ruleStatus.isExist() && this.ruleStatus.isAddView()) {
                newNum = this.codingRuleManager.getNumber((IObjectValue)new RequirementUniteRuleInfo(), storage.getId().toString());
            }
        }
        return newNum;
    }

    @Override
    protected RequirementUniteRuleInfo _initLineNumberAndDate(Context ctx, StorageOrgUnitInfo storageUnitInfo) throws BOSException, EASBizException {
        RequirementUniteRuleInfo ruleInfo = new RequirementUniteRuleInfo();
        String number = this.getCodingRuleManager(ctx, storageUnitInfo);
        if (this.ruleStatus.isExist()) {
            if (number == null) {
                number = "NewAddWhenSave";
            }
            ruleInfo.setNumber(number);
        }
        ruleInfo.setNumber(number);
        Date date = new Date();
        ruleInfo.setCreateTime(new Timestamp(date.getTime()));
        return ruleInfo;
    }
}

