/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.common.MMCommonException;
import com.kingdee.eas.mm.common.app.BillUpdater;
import com.kingdee.eas.mm.common.app.BillUpdaterFactory;
import com.kingdee.eas.mm.common.app.MMExternalProcessor;
import com.kingdee.eas.mm.common.app.SQLUtils;
import com.kingdee.eas.mm.common.util.SQLUtil;
import com.kingdee.eas.mm.planning.CooperatePlanOrderCloseEnum;
import com.kingdee.eas.mm.planning.CooperatePlanOrderFactory;
import com.kingdee.eas.mm.planning.CooperatePlanOrderInfo;
import com.kingdee.eas.mm.planning.ICooperatePlanOrder;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;

public class SCMWriteBackCOrder
extends BillUpdater
implements MMExternalProcessor {
    private String billTypeID = null;
    private String[] billIds = null;

    public SCMWriteBackCOrder() {
    }

    public SCMWriteBackCOrder(Context ctx) {
        super(ctx);
    }

    protected boolean beforeExecute() throws BOSException, EASBizException {
        StringBuffer processTempTableSql = new StringBuffer();
        processTempTableSql.append("select count(*) as orderNum from t_bot_relation where fsrcentityid='375FC562' ");
        IRowSet rs = SQLUtils.executeQuery((Context)this.ctx, (String)processTempTableSql.toString());
        int orderNum = 0;
        try {
            if (rs.next()) {
                orderNum = rs.getInt("orderNum");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (orderNum == 0) {
            return false;
        }
        processTempTableSql.setLength(0);
        if ("50957179-0105-1000-e003-3152c0a812fd463ED552".equals(this.billTypeID) || "Eg5BUQEVEADgAAABwKgOEEY+1VI=".equals(this.billTypeID)) {
            this.setBaseQtyFields(new String[]{"FTransferedBaseQty"});
            this.setQtyFields(new String[]{"FTransferedQty"});
            this.setUnBaseQtyExpression("FBaseQty-FTransferedBaseQty");
            if ("50957179-0105-1000-e003-3152c0a812fd463ED552".equals(this.billTypeID)) {
                processTempTableSql.append("insert into ").append(this.sourceDataTable).append(" (FBillID, FSourceBillID, FSourceBillEntryId, FBaseQty, FQty) ").append("select T.FID, T.FSourceBillID, Entry.FSourceBillEntryId, Entry.FBaseQty, Entry.FQty ").append("from T_IM_StockTransferBill T ").append("inner join T_IM_StockTransferBillEntry entry on T.FID = entry.FParentId ").append("where T.FID in (").append(SQLUtil.arrayToString((Object[])this.billIds)).append(") and T.FsourceBillTypeID = '").append("tMCsjuu0TMO+jMoUTkrsSkY+1VI=").append("' ");
            } else {
                processTempTableSql.append("insert into ").append(this.sourceDataTable).append(" (FBillID, FSourceBillID, FSourceBillEntryId, FBaseQty, FQty) ").append("select T.FID, T.FSourceBillID, Entry.FSourceBillEntryId, Entry.FBaseQty, Entry.FQty ").append("from T_IM_TransferOrderBill T ").append("inner join T_IM_TransferOrderBillEntry entry on T.FID = entry.FParentId ").append("where T.FID in (").append(SQLUtil.arrayToString((Object[])this.billIds)).append(") and T.FsourceBillTypeID = '").append("tMCsjuu0TMO+jMoUTkrsSkY+1VI=").append("' ");
            }
            SQLUtils.execute((Context)this.ctx, (String)processTempTableSql.toString());
        } else if ("50957179-0105-1000-e000-0172c0a812fd463ED552".equals(this.billTypeID) || "50957179-0105-1000-e000-015fc0a812fd463ED552".equals(this.billTypeID)) {
            this.setBaseQtyFields(new String[]{"FSuppliedBaseQty"});
            this.setQtyFields(new String[]{"FSuppliedQty"});
            this.setUnBaseQtyExpression("FBaseQty-FSuppliedBaseQty");
            String[] binBillTypes = null;
            String[] triBillTypes = null;
            String targetBillTable = null;
            String targetBillIds = SQLUtil.arrayToString((Object[])this.billIds);
            if ("50957179-0105-1000-e000-0172c0a812fd463ED552".equals(this.billTypeID)) {
                binBillTypes = new String[]{"375FC562", "2239F30A", "E3DAFF63"};
                triBillTypes = new String[]{"375FC562", "2239F30A", "71D272F1", "E3DAFF63"};
                targetBillTable = "T_IM_MoveInWarehsBillEntry";
            } else {
                binBillTypes = new String[]{"375FC562", "5C2A1F0C", "783061E3"};
                triBillTypes = new String[]{"375FC562", "5C2A1F0C", "CC3E933B", "783061E3"};
                targetBillTable = "T_IM_PurInWarehsEntry";
            }
            processTempTableSql.setLength(0);
            processTempTableSql.append("insert into ").append(this.sourceDataTable).append(" (FBillID, FSourceBillID, FSourceBillEntryId, FBaseQty, FQty) \n");
            processTempTableSql.append(BillUpdaterFactory.getBinLayerBillRelationSql((String[])binBillTypes, (String)targetBillTable, (String)targetBillIds));
            processTempTableSql.append("\n union \n");
            processTempTableSql.append(BillUpdaterFactory.getTriLayerBillRelationSql((String[])triBillTypes, (String)targetBillTable, (String)targetBillIds));
            SQLUtils.execute((Context)this.ctx, (String)processTempTableSql.toString());
        } else {
            return false;
        }
        if (this.isAuditAction) {
            this.setBaseQtyOperation(new String[]{"+", "-"});
            this.setQtyOperation(new String[]{"+", "-"});
        } else {
            this.setBaseQtyOperation(new String[]{"-", "+"});
            this.setQtyOperation(new String[]{"-", "+"});
        }
        this.setTargetTable("T_MM_CooperatePlanOrderEntry");
        this.setUpdateHead(false);
        this.setTransfUnit(true);
        this.setReleaseTempTable(true);
        this.setThrowException(true);
        this.setThrowExcpetion((EASBizException)new MMCommonException(MMCommonException.REWRITEQTY_GT_UNQTY));
        return true;
    }

    protected void afterExecute() throws BOSException, EASBizException {
        StringBuffer updateCoPlanOrderSql = new StringBuffer();
        updateCoPlanOrderSql.append("update T_MM_CooperatePlanOrderEntry set FAssociateQty = ").append("FQty-FTransferedQty ").append("where FID in (select FSourceBillEntryId from ").append(this.sourceDataTable).append(")");
        SQLUtils.execute((Context)this.ctx, (String)updateCoPlanOrderSql.toString());
        updateCoPlanOrderSql.setLength(0);
        if ("50957179-0105-1000-e000-0172c0a812fd463ED552".equals(this.billTypeID) || "50957179-0105-1000-e000-015fc0a812fd463ED552".equals(this.billTypeID)) {
            if (this.isAuditAction()) {
                updateCoPlanOrderSql.append("update T_MM_CooperatePlanOrderEntry set FCloseStatus = ").append(20).append(" where FID in (select FSourceBillEntryId from ").append(this.sourceDataTable).append(")").append(" and FSuppliedQty >= FQty and FCloseStatus <> ").append(30);
                SQLUtils.execute((Context)this.ctx, (String)updateCoPlanOrderSql.toString());
                updateCoPlanOrderSql.setLength(0);
                updateCoPlanOrderSql.append(" select CoPlanOrder.FID CoPlanOrderID from ").append(this.sourceDataTable).append(" temp ").append("inner join T_MM_CooperatePlanOrderEntry CoEntry ").append("on temp.FSourceBillEntryId = CoEntry.FID ").append("inner join T_MM_CooperatePlanOrder CoPlanOrder ").append("on CoEntry.FparentID = CoPlanOrder.FID group by CoPlanOrder.FID ");
                CooperatePlanOrderInfo coPlanOrder = null;
                IRowSet coPlanOrderSet = SQLUtils.executeQuery((Context)this.ctx, (String)updateCoPlanOrderSql.toString());
                try {
                    while (coPlanOrderSet.next()) {
                        boolean hasUnClosedEntry = false;
                        ICooperatePlanOrder iCoPlanOrder = CooperatePlanOrderFactory.getLocalInstance(this.ctx);
                        ObjectUuidPK orderPK = new ObjectUuidPK(coPlanOrderSet.getString("CoPlanOrderID"));
                        coPlanOrder = iCoPlanOrder.getCooperatePlanOrderInfo((IObjectPK)orderPK);
                        for (int j = 0; j < coPlanOrder.getEntries().size(); ++j) {
                            if (!coPlanOrder.getEntries().get(j).getCloseStatus().equals((Object)CooperatePlanOrderCloseEnum.UNCLOSED)) continue;
                            hasUnClosedEntry = true;
                            break;
                        }
                        if (hasUnClosedEntry) continue;
                        updateCoPlanOrderSql.setLength(0);
                        updateCoPlanOrderSql.append("update T_MM_CooperatePlanOrder ").append("set FBaseStatus = ").append(7).append(" where FID = '").append(coPlanOrder.getId().toString()).append("'");
                        SQLUtils.execute((Context)this.ctx, (String)updateCoPlanOrderSql.toString());
                    }
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
            } else {
                updateCoPlanOrderSql.append("update T_MM_CooperatePlanOrderEntry set FCloseStatus = ").append(10).append(" where FID in (select FSourceBillEntryId from ").append(this.sourceDataTable).append(")").append(" and FSuppliedQty < FQty and FcloseStatus <> ").append(30);
                SQLUtils.execute((Context)this.ctx, (String)updateCoPlanOrderSql.toString());
                updateCoPlanOrderSql.setLength(0);
                updateCoPlanOrderSql.append("update T_MM_CooperatePlanOrder set FbaseStatus = ").append(5).append(" where FID in (select CoPlanOrder.FID from ").append(this.sourceDataTable).append(" temp").append(" inner join  T_MM_CooperatePlanOrderEntry CoEntry ").append("on temp.FSourceBillEntryId = CoEntry.FID ").append("inner join  T_MM_CooperatePlanOrder CoPlanOrder ").append("on CoEntry.FparentID = CoPlanOrder.FID ").append("and CoPlanOrder.FbaseStatus = ").append(7).append(" group by CoPlanOrder.FID) ");
                SQLUtils.execute((Context)this.ctx, (String)updateCoPlanOrderSql.toString());
            }
        }
        super.afterExecute();
    }

    public void process(Context ctx, int bizAction, String billTypeId, String[] billIds) throws BOSException, EASBizException {
        this.ctx = ctx;
        this.setBillTypeID(billTypeId);
        this.setSourceDataTable(BillUpdaterFactory.createTempTable((Context)ctx));
        this.setBillIds(billIds);
        this.setAuditAction(bizAction == 103);
        this.execute();
    }

    public boolean qtyCheck() throws BOSException, EASBizException {
        StringBuffer checkSql = new StringBuffer();
        checkSql.append("select SrcTable.FNumber SrcNumber from ").append(this.sourceDataTable).append(" temp ").append("inner join  T_MM_CooperatePlanOrderEntry CoEntry ").append("on temp.FSourceBillEntryId = CoEntry.FID ").append("inner join ").append(this.getSourceTableName()).append(" SrcTable ").append("on temp.FBillID = SrcTable.FID ").append(" where CoEntry.FCloseStatus <> 10  ");
        IRowSet rs = SQLUtils.executeQuery((Context)this.ctx, (String)checkSql.toString());
        if (rs.size() > 0) {
            Object[] srcBills = new String[rs.size()];
            int i = 0;
            try {
                while (rs.next()) {
                    srcBills[i] = rs.getString("SrcNumber");
                    ++i;
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            throw new MMCommonException(MMCommonException.COPLANENTRY_ALREADY_CLOSED, srcBills);
        }
        return super.qtyCheck();
    }

    public String getBillTypeID() {
        return this.billTypeID;
    }

    public void setBillTypeID(String billTypeID) {
        this.billTypeID = billTypeID;
    }

    public String[] getBillIds() {
        return this.billIds;
    }

    public void setBillIds(String[] billIds) {
        this.billIds = billIds;
    }

    private String getSourceTableName() {
        String srcTable = null;
        srcTable = "50957179-0105-1000-e003-3152c0a812fd463ED552".equals(this.billTypeID) ? "T_IM_StockTransferBill" : ("Eg5BUQEVEADgAAABwKgOEEY+1VI=".equals(this.billTypeID) ? "T_IM_TransferOrderBill" : ("50957179-0105-1000-e000-0172c0a812fd463ED552".equals(this.billTypeID) ? "T_IM_MoveInWarehsBill" : "T_IM_PurInWarehsBill"));
        return srcTable;
    }
}

