/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.DataLimitExceedException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.JDBCExceptionHandler;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.mm.common.app.SQLUtils;
import com.kingdee.eas.mm.planning.ISOPFacade;
import com.kingdee.eas.mm.planning.ISOPPermissionFacade;
import com.kingdee.eas.mm.planning.MatInfo;
import com.kingdee.eas.mm.planning.ReqPlanSOPFacadeFactory;
import com.kingdee.eas.mm.planning.RequirementPlanInfo;
import com.kingdee.eas.mm.planning.SOPEditModeEnum;
import com.kingdee.eas.mm.planning.SOPException;
import com.kingdee.eas.mm.planning.SOPFacadeFactory;
import com.kingdee.eas.mm.planning.SOPPeriod;
import com.kingdee.eas.mm.planning.SOPPermissionFacadeFactory;
import com.kingdee.eas.mm.planning.SOPPlanVersionFactory;
import com.kingdee.eas.mm.planning.SOPPlanVersionInfo;
import com.kingdee.eas.mm.planning.SOPPlannedTypeEnum;
import com.kingdee.eas.mm.planning.SOPSysParams;
import com.kingdee.eas.mm.planning.SopBillInfo;
import com.kingdee.eas.mm.planning.SopDateUtil;
import com.kingdee.eas.mm.planning.SopPlanInfo;
import com.kingdee.eas.mm.planning.app.AbstractSOPFacadeControllerBean;
import com.kingdee.eas.mm.planning.app.SopPlanAlgorithm;
import com.kingdee.eas.mm.planning.app.mrp.MRPUtil;
import com.kingdee.eas.mm.planning.util.SOPUtil;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class SOPFacadeControllerBean
extends AbstractSOPFacadeControllerBean {
    private static final long serialVersionUID = 8762562246711975924L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.planning.app.SOPFacadeControllerBean");
    Map precisionMap = new HashMap();
    Map rateMap = new HashMap();
    public static final String RESOURCE = "com.kingdee.eas.mm.planning.SOPResource";

    @Override
    protected Map _getDataForCopySOP(Context ctx, Map params) throws BOSException, EASBizException {
        String orgId = (String)params.get("org");
        String srcVerId = (String)params.get("sourceVersion");
        SOPEditModeEnum sopEditMode = (SOPEditModeEnum)((Object)params.get("sopeditmode"));
        SOPSysParams sopParam = this.getSOPSysParams(ctx, orgId);
        HashMap<String, Object> outMap = new HashMap<String, Object>();
        SelectorItemCollection si = new SelectorItemCollection();
        si.add(new SelectorItemInfo("id"));
        si.add(new SelectorItemInfo("number"));
        si.add(new SelectorItemInfo("name"));
        StorageOrgUnitInfo org = (StorageOrgUnitInfo)StorageOrgUnitFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectStringPK(orgId), si);
        outMap.put("org", org);
        SOPPlanVersionInfo srcVerInfo = (SOPPlanVersionInfo)SOPPlanVersionFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectStringPK(srcVerId), si);
        outMap.put("sourceVersion", srcVerInfo);
        if (20 == sopEditMode.getValue()) {
            outMap.put("NumberOfTerm", new Integer(sopParam.getSOPMonthHorizon()));
        } else {
            outMap.put("NumberOfTerm", new Integer(sopParam.getSOPWeekHorizon()));
        }
        SOPPeriod currentPeriod = this.getCurrentPeriod(ctx, sopEditMode, orgId);
        outMap.put("StartSOPPeriod", currentPeriod);
        return outMap;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void _copySOP(Context ctx, Map param) throws BOSException, EASBizException {
        String orgId = (String)param.get("org");
        String sourceVerId = (String)param.get("sourceVersion");
        SOPEditModeEnum sopEditMode = (SOPEditModeEnum)((Object)param.get("sopeditmode"));
        List materialLst = (List)param.get("materials");
        Map storageMatIds = (Map)param.get("matStorageIds");
        String targetVerId = (String)param.get("targetVerID");
        SOPPeriod fromPeriod = (SOPPeriod)param.get("StartSOPPeriod");
        SOPPeriod toPeriod = (SOPPeriod)param.get("EndSOPPeriod");
        int numOfPeriod = (Integer)param.get("NumberOfTerm");
        Integer planType = (Integer)param.get("PlanType");
        Integer copyMode = (Integer)param.get("CopyMode");
        String userID = ctx.getCaller().toString();
        String[] permItems = null;
        this.rateMap.putAll((Map)param.get("rate"));
        this.precisionMap.putAll((Map)param.get("precision"));
        HashMap<String, Map> map = new HashMap<String, Map>();
        map.put("rate", this.rateMap);
        map.put("precision", this.precisionMap);
        Set keySet = this.rateMap.keySet();
        Map together = SOPFacadeFactory.getLocalInstance(ctx).convertMap(keySet, map);
        Map newRateMap = (Map)together.get("rate");
        Map newPrecisionMap = (Map)together.get("precision");
        switch (planType) {
            case 0: {
                permItems = new String[]{"mm_sopsaleplan_edit"};
                break;
            }
            case 1: {
                permItems = new String[]{"mm_sopprodplan_edit"};
                break;
            }
            case 2: {
                permItems = new String[]{"mm_sopsaleplan_edit", "mm_sopprodplan_edit"};
                break;
            }
        }
        HashMap bopMap = (HashMap)param.get("bop");
        boolean isCopyBop = (Boolean)param.get("isCopyBop");
        ISOPPermissionFacade sopPermFacade = SOPPermissionFacadeFactory.getLocalInstance(ctx);
        Map permMap = sopPermFacade.checkPermissions(userID, orgId, permItems);
        for (String key : permMap.keySet()) {
            if (((Boolean)permMap.get(key)).booleanValue()) continue;
            if (!key.equals("mm_sopsaleplan_edit")) throw new SOPException(SOPException.NO_SOPEDIT_PROD_PERM);
            throw new SOPException(SOPException.NO_SOPEDIT_SALE_PERM);
        }
        if (!SOPUtil.requestMutex(ctx, userID, orgId, targetVerId)) {
            throw new SOPException(SOPException.TARGETVER_LOCKED);
        }
        String clr = "\r\n";
        Connection conn = null;
        PreparedStatement stmtUpdateBop = null;
        try {
            String materialId;
            String ids;
            String materialId22;
            String storageid;
            String ids22;
            int i;
            conn = EJBFactory.getConnection((Context)ctx);
            String sopPlanBostype = new SopPlanInfo().getBOSType().toString();
            String sopBillBostype = new SopBillInfo().getBOSType().toString();
            StringBuffer sqlSB = new StringBuffer();
            ArrayList<Object> paramLst = new ArrayList<Object>();
            sqlSB.append("update T_MM_SopPlan as t0 ").append(clr);
            switch (planType) {
                case 0: {
                    sqlSB.append("set (FSalesQty,FBaseSalesQty) = (").append(clr);
                    if (copyMode == 0) {
                        sqlSB.append("select distinct t1.FSalesQty,t1.FBaseSalesQty ").append(clr);
                        break;
                    }
                    sqlSB.append("select distinct t3.FSalesQty + t1.FSalesQty ,t3.FBaseSalesQty+t1.FBaseSalesQty").append(clr);
                    break;
                }
                case 1: {
                    if (copyMode == 0) {
                        sqlSB.append("set (FProdTheoryQty,FProductionQty,FTargetInvQty,FBaseProdTheoryQty,FBaseProductionQty,FBaseTargetInvQty) = (").append(clr);
                        sqlSB.append("select distinct t1.FProdTheoryQty,t1.FProductionQty,t1.FTargetInvQty,t1.FBaseProdTheoryQty,t1.FBaseProductionQty,t1.FBaseTargetInvQty ").append(clr);
                        break;
                    }
                    sqlSB.append("set (FProdTheoryQty,FProductionQty,FBaseProdTheoryQty,FBaseProductionQty) = (").append(clr);
                    sqlSB.append("select distinct t3.FProdTheoryQty + t1.FProdTheoryQty,t3.FProductionQty + t1.FProductionQty ,t3.FBaseProdTheoryQty+t1.FBaseProdTheoryQty,t3.FBaseProductionQty+t1.FBaseProductionQty ").append(clr);
                    break;
                }
                case 2: {
                    if (copyMode == 0) {
                        sqlSB.append("set (FSalesQty,FProdTheoryQty,FProductionQty,FTargetInvQty,FBaseSalesQty,FBaseProdTheoryQty,FBaseProductionQty,FBaseTargetInvQty ) = (").append(clr);
                        sqlSB.append("select distinct t1.FSalesQty,t1.FProdTheoryQty,t1.FProductionQty,t1.FTargetInvQty,t1.FBaseSalesQty,t1.FBaseProdTheoryQty,t1.FBaseProductionQty,t1.FBaseTargetInvQty ").append(clr);
                        break;
                    }
                    sqlSB.append("set (FSalesQty,FProdTheoryQty,FProductionQty,FBaseSalesQty,FBaseProdTheoryQty,FBaseProductionQty) = (").append(clr);
                    sqlSB.append("select distinct t3.FSalesQty + t1.FSalesQty,").append(clr).append("t3.FProdTheoryQty + t1.FProdTheoryQty, ").append(clr).append("t3.FProductionQty + t1.FProductionQty,t3.FBaseSalesQty+t1.FBaseSalesQty,t3.FBaseProdTheoryQty+t1.FBaseProdTheoryQty,t3.FBaseProductionQty+t1.FBaseProductionQty ").append(clr);
                    break;
                }
            }
            sqlSB.append("from T_MM_SopPlan as t1, ").append(clr).append("T_MM_SopBill as t2, ").append(clr).append("T_MM_SopPlan as t3, ").append(clr).append("T_MM_SopBill as t4 ").append(clr).append("where t2.FStorageOrgUnitID = '").append(orgId).append("' ").append(clr).append("and t2.FPlanVersionID = '").append(sourceVerId).append("' ").append(clr).append("and t1.FEditMode = ").append(sopEditMode.getValue()).append(" ").append(clr).append("and t1.FPeriodNumber >= ").append(fromPeriod.toNumber()).append(" ").append(clr).append("and t1.FPeriodNumber <= ").append(toPeriod.toNumber()).append(" ").append(clr).append("and t1.FParentID = t2.FID ").append(clr).append("and t4.FPlanVersionID = '").append(targetVerId).append("' ").append(clr).append("and t2.FStorageOrgUnitID = t4.FStorageOrgUnitID ").append(clr).append("and t2.FMaterialID = t4.FMaterialID ").append("and t2.FSupplyStorageOrgUnitID = t4.FSupplyStorageOrgUnitID").append(clr).append("and t1.FEditMode = t3.FEditMode ").append(clr).append("and t1.FPeriodNumber = t3.FPeriodNumber ").append(clr).append("and t3.FParentID = t4.FID ").append(clr).append("and t0.FID = t3.FID ").append(clr).append("and (");
            for (i = 0; i < materialLst.size(); ++i) {
                ids22 = (String)materialLst.get(i);
                storageid = (String)storageMatIds.get(ids22 + "storage");
                materialId22 = (String)storageMatIds.get(ids22 + "material");
                sqlSB.append("( t2.FMaterialID='" + materialId22 + "' and t2.FSupplyStorageOrgUnitID='" + storageid + "' )");
                if (i != materialLst.size() - 1) {
                    sqlSB.append(" or ");
                    continue;
                }
                sqlSB.append(" ) ");
            }
            sqlSB.append(" ) ");
            DbUtil.execute((Context)ctx, (String)sqlSB.toString(), (Object[])new Object[0]);
            sqlSB.setLength(0);
            sqlSB.append("insert into T_MM_SopBill ").append(clr).append("(FID,FPlanVersionID,FStorageOrgUnitID,FMaterialID,FSupplyStorageOrgUnitID,FBaseUnitID,FAssistUnitID) ").append(clr).append("select newbosid('").append(sopBillBostype).append("'),'").append(targetVerId).append("',t0.FStorageOrgUnitID,t0.FMaterialID ,t0.FSupplyStorageOrgUnitID,t0.FBaseUnitID,t0.FAssistUnitID").append(clr);
            sqlSB.append("from T_MM_SopBill t0 left outer join T_MM_SopBill t1 ").append(clr).append("ON t1.FStorageOrgUnitID = t0.FStorageOrgUnitID ").append(clr).append("and t1.FMaterialID = t0.FMaterialID and t1.FSupplyStorageOrgUnitID=t0.FSupplyStorageOrgUnitID and t1.FPlanVersionID = ? ").append(clr).append("where t1.FID is null ").append(clr).append("and t0.FStorageOrgUnitID = ? ").append(clr).append("and t0.FPlanVersionID = ? ").append(clr).append("and (");
            for (i = 0; i < materialLst.size(); ++i) {
                ids22 = (String)materialLst.get(i);
                storageid = (String)storageMatIds.get(ids22 + "storage");
                materialId22 = (String)storageMatIds.get(ids22 + "material");
                sqlSB.append("( t0.FMaterialID='" + materialId22 + "' and t0.FSupplyStorageOrgUnitID='" + storageid + "' )");
                if (i != materialLst.size() - 1) {
                    sqlSB.append(" or ");
                    continue;
                }
                sqlSB.append(" ) ");
            }
            paramLst.clear();
            paramLst.add(targetVerId);
            paramLst.add(orgId);
            paramLst.add(sourceVerId);
            DbUtil.execute((Context)ctx, (String)sqlSB.toString(), (Object[])paramLst.toArray());
            sqlSB.setLength(0);
            sqlSB.append("insert into T_MM_SopPlan ").append(clr).append("(FID,FParentID,FEditMode,FPeriodNumber,FYear,FPeriod,").append(clr).append("FSalesQty,FProdTheoryQty,FProductionQty,FTargetInvQty,FBaseSalesQty,FBaseProdTheoryQty,FBaseProductionQty,FBaseTargetInvQty) ").append(clr).append("select newbosid('").append(sopPlanBostype).append("'),").append("t2.FID,t0.FEditMode,t0.FPeriodNumber,t0.FYear,t0.FPeriod,").append(clr);
            switch (planType) {
                case 0: {
                    if (copyMode == 0) {
                        sqlSB.append(" t0.FSalesQty,0,0,t0.FTargetInvQty,t0.FBaseSalesQty,0,0,t0.FBaseTargetInvQty ").append(clr);
                        break;
                    }
                    sqlSB.append("t0.FSalesQty,0,0,0,t0.FBaseSalesQty,0,0,0").append(clr);
                    break;
                }
                case 1: {
                    if (copyMode == 0) {
                        sqlSB.append(" 0,t0.FProdTheoryQty,t0.FProductionQty,t0.FTargetInvQty,0,t0.FBaseProdTheoryQty,t0.FBaseProductionQty,t0.FBaseTargetInvQty ").append(clr);
                        break;
                    }
                    sqlSB.append("0,t0.FProdTheoryQty,t0.FProductionQty,0,0,t0.FBaseProdTheoryQty,t0.FBaseProductionQty,0").append(clr);
                    break;
                }
                case 2: {
                    if (copyMode == 0) {
                        sqlSB.append(" t0.FSalesQty,t0.FProdTheoryQty,t0.FProductionQty,t0.FTargetInvQty,t0.FBaseSalesQty,t0.FBaseProdTheoryQty,t0.FBaseProductionQty,t0.FBaseTargetInvQty ").append(clr);
                        break;
                    }
                    sqlSB.append("t0.FSalesQty,t0.FProdTheoryQty,t0.FProductionQty,0,t0.FBaseSalesQty,t0.FBaseProdTheoryQty,t0.FBaseProductionQty,0").append(clr);
                    break;
                }
            }
            sqlSB.append("from (select t0.*,t1.FEditMode,t1.FPeriodNumber,t1.FYear,t1.FPeriod,t1.FSalesQty,t1.FProdTheoryQty,t1.FProductionQty,t1.FTargetInvQty,t1.FBaseSalesQty,t1.FBaseProdTheoryQty,t1.FBaseProductionQty,t1.FBaseTargetInvQty ").append("from T_MM_SOPBill t0 inner join T_MM_SopPlan t1 on t0.FID = t1.FParentID ").append(clr).append("where t0.FStorageOrgUnitID = ? ").append(clr).append("and t0.FPlanVersionID = ? ").append(clr).append("and  (");
            for (i = 0; i < materialLst.size(); ++i) {
                ids22 = (String)materialLst.get(i);
                storageid = (String)storageMatIds.get(ids22 + "storage");
                materialId22 = (String)storageMatIds.get(ids22 + "material");
                sqlSB.append("( t0.FMaterialID='" + materialId22 + "' and t0.FSupplyStorageOrgUnitID='" + storageid + "' )");
                if (i != materialLst.size() - 1) {
                    sqlSB.append(" or ");
                    continue;
                }
                sqlSB.append(" ) ");
            }
            sqlSB.append("and t1.FEditMode = ? ").append(clr).append("and t1.FPeriodNumber >= ? ").append(clr).append("and t1.FPeriodNumber <= ? ").append(clr).append(") as t0 ").append(clr).append("inner join T_MM_SOPBill t2 on t0.FStorageOrgUnitID = t2.FStorageOrgUnitID ").append(clr).append("and t0.FMaterialID = t2.FMaterialID and t0.FSupplyStorageOrgUnitID=t2.FSupplyStorageOrgUnitID and t2.FPlanVersionID = ? ").append(clr).append("left outer join  ").append(clr).append("(select  t0.FMaterialID,t0.FSupplyStorageOrgUnitID,t1.* from T_MM_SOPBill t0 inner join T_MM_SopPlan t1 on t1.FParentID = t0.FID ").append(clr).append("where t0.FStorageOrgUnitID = ? ").append(clr).append("and t0.FPlanVersionID = ? ").append(clr).append("and (");
            for (i = 0; i < materialLst.size(); ++i) {
                ids22 = (String)materialLst.get(i);
                storageid = (String)storageMatIds.get(ids22 + "storage");
                materialId22 = (String)storageMatIds.get(ids22 + "material");
                sqlSB.append("( t0.FMaterialID='" + materialId22 + "' and t0.FSupplyStorageOrgUnitID='" + storageid + "' )");
                if (i != materialLst.size() - 1) {
                    sqlSB.append(" or ");
                    continue;
                }
                sqlSB.append(" ) ");
            }
            sqlSB.append(clr).append("and t1.FEditMode = ? ").append(clr).append("and t1.FPeriodNumber >= ? ").append(clr).append("and t1.FPeriodNumber <= ? ").append(clr).append(") as t1 on t0.FEditMode = t1.FEditMode and t0.FPeriodNumber = t1.FPeriodNumber and t0.FMaterialID = t1.FMaterialID and t0.FSupplyStorageOrgUnitID=t1.FSupplyStorageOrgUnitID ").append(clr).append("where t1.FID is null ").append(clr);
            paramLst.clear();
            paramLst.add(orgId);
            paramLst.add(sourceVerId);
            paramLst.add(new Integer(sopEditMode.getValue()));
            paramLst.add(new Integer(fromPeriod.toNumber()));
            paramLst.add(new Integer(toPeriod.toNumber()));
            paramLst.add(targetVerId);
            paramLst.add(orgId);
            paramLst.add(targetVerId);
            paramLst.add(new Integer(sopEditMode.getValue()));
            paramLst.add(new Integer(fromPeriod.toNumber()));
            paramLst.add(new Integer(toPeriod.toNumber()));
            DbUtil.execute((Context)ctx, (String)sqlSB.toString(), (Object[])paramLst.toArray());
            if (isCopyBop) {
                ISOPFacade sopBop = SOPFacadeFactory.getLocalInstance(ctx);
                sqlSB.setLength(0);
                if (copyMode == 0) {
                    sqlSB.append(" UPDATE T_MM_SopBill ").append(clr).append("SET FBopDate = ?, FBop = ? ,FBaseBop=? ").append(clr).append(" WHERE FStorageOrgUnitId = ? ").append(clr).append("   AND FPlanVersionId = ? ").append(clr).append("   AND ").append(clr);
                    sqlSB.append(" FMaterialID=? and FSupplyStorageOrgUnitID=? ");
                    Calendar date = Calendar.getInstance();
                    Date datesql = new Date(date.getTimeInMillis());
                    stmtUpdateBop = conn.prepareStatement(sqlSB.toString());
                    for (int i2 = 0; i2 < materialLst.size(); ++i2) {
                        String ids3 = (String)materialLst.get(i2);
                        BigDecimal bop = null;
                        bop = bopMap.get((String)materialLst.get(i2)) == null ? new BigDecimal(0.0) : (BigDecimal)bopMap.get((String)materialLst.get(i2));
                        if (newRateMap.get((String)materialLst.get(i2)) == null) {
                            Map newmap = sopBop.getBopRate(orgId, (String)storageMatIds.get(ids3 + "material"));
                            newRateMap.putAll((Map)newmap.get("rate"));
                            newPrecisionMap.putAll((Map)newmap.get("qtyPrecision"));
                        }
                        stmtUpdateBop.setDate(1, datesql);
                        stmtUpdateBop.setBigDecimal(2, bop);
                        stmtUpdateBop.setBigDecimal(3, bop.multiply((BigDecimal)newRateMap.get((String)materialLst.get(i2))).setScale((int)((Integer)newPrecisionMap.get((String)materialLst.get(i2))), 4));
                        stmtUpdateBop.setString(4, orgId);
                        stmtUpdateBop.setString(5, targetVerId);
                        String storageid2 = (String)storageMatIds.get(ids3 + "storage");
                        String materialId3 = (String)storageMatIds.get(ids3 + "material");
                        stmtUpdateBop.setString(6, materialId3);
                        stmtUpdateBop.setString(7, storageid2);
                        stmtUpdateBop.addBatch();
                    }
                    stmtUpdateBop.executeBatch();
                } else {
                    sqlSB.append(" SELECT FSupplyStorageOrgUnitID||FMaterialId FmatStorageIds,FBop from T_MM_SopBill").append(clr).append(" WHERE FStorageOrgUnitId = ? ").append(clr).append("   AND FPlanVersionId = ? ").append(clr).append("   AND ( ");
                    for (int i3 = 0; i3 < materialLst.size(); ++i3) {
                        ids = (String)materialLst.get(i3);
                        String storageid3 = (String)storageMatIds.get(ids + "storage");
                        materialId = (String)storageMatIds.get(ids + "material");
                        sqlSB.append("( FMaterialID='" + materialId + "' and FSupplyStorageOrgUnitID='" + storageid3 + "' )");
                        if (i3 != materialLst.size() - 1) {
                            sqlSB.append(" or ");
                            continue;
                        }
                        sqlSB.append(" ) ");
                    }
                    paramLst.clear();
                    paramLst.add(orgId);
                    paramLst.add(targetVerId);
                    IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlSB.toString(), (Object[])paramLst.toArray());
                    BigDecimal oldBop = null;
                    BigDecimal newBop = null;
                    while (rs.next()) {
                        oldBop = rs.getBigDecimal("FBop");
                        newBop = (BigDecimal)bopMap.get(rs.getString("FmatStorageIds"));
                        if (newBop == null) {
                            newBop = new BigDecimal(0.0);
                        }
                        bopMap.put(rs.getString("FmatStorageIds"), newBop.add(oldBop));
                    }
                    sqlSB.setLength(0);
                    sqlSB.append(" UPDATE T_MM_SopBill ").append(clr).append("SET FBopDate = ?, FBop = ?,FBaseBop=? ").append(clr).append(" WHERE FStorageOrgUnitId = ? ").append(clr).append("   AND FPlanVersionId = ? ").append(clr).append("   AND FMaterialId = ? and FSupplyStorageOrgUnitID=? ; ").append(clr);
                    Calendar date = Calendar.getInstance();
                    Date datesql = new Date(date.getTimeInMillis());
                    stmtUpdateBop = conn.prepareStatement(sqlSB.toString());
                    for (int i4 = 0; i4 < materialLst.size(); ++i4) {
                        BigDecimal bop = null;
                        String ids4 = (String)materialLst.get(i4);
                        bop = bopMap.get((String)materialLst.get(i4)) == null ? new BigDecimal(0.0) : (BigDecimal)bopMap.get((String)materialLst.get(i4));
                        if (newRateMap.get((String)materialLst.get(i4)) == null) {
                            Map newmap = sopBop.getBopRate((String)storageMatIds.get(ids4 + "storage"), (String)storageMatIds.get(ids4 + "material"));
                            newRateMap.putAll((Map)newmap.get("rate"));
                            newPrecisionMap.putAll((Map)newmap.get("qtyPrecision"));
                        }
                        stmtUpdateBop.setDate(1, datesql);
                        stmtUpdateBop.setBigDecimal(2, bop);
                        stmtUpdateBop.setBigDecimal(3, bop.multiply((BigDecimal)newRateMap.get((String)materialLst.get(i4))).setScale((int)((Integer)newPrecisionMap.get((String)materialLst.get(i4))), 4));
                        stmtUpdateBop.setString(4, orgId);
                        stmtUpdateBop.setString(5, targetVerId);
                        stmtUpdateBop.setString(6, (String)storageMatIds.get(ids4 + "material"));
                        stmtUpdateBop.setString(7, (String)storageMatIds.get(ids4 + "storage"));
                        stmtUpdateBop.addBatch();
                    }
                    stmtUpdateBop.executeBatch();
                }
            }
            StringBuffer sql = new StringBuffer();
            sql.append(" SELECT sb.fid fid,u2.fqtyPrecision fqtyPrecision,round(mu.FBaseConvsRate/mu2.FBaseConvsRate,8) rate from T_MM_SopBill sb ").append(clr);
            sql.append(" inner join t_bd_material m on m.fid=sb.fmaterialid ");
            sql.append(" inner join t_bd_materialplan mp on mp.fmaterialid=m.fid and sb.FStorageOrgUnitID=mp.forgunit ");
            sql.append(" inner join t_bd_multimeasureunit mu on mu.fmaterialid=m.fid and sb.FAssistUnitID =mu.FMeasureUnitId ");
            sql.append(" inner join t_bd_measureUnit u on  mu.FMeasureUnitId = u.FId ");
            sql.append(" inner join T_BD_MultiMeasureUnit mu2 on  sb.FBaseUnitID = mu2.FMeasureUnitId and mp.FMaterialId = mu2.FMaterialId");
            sql.append(" inner join t_bd_measureunit u2 on u2.fid=sb.fbaseunitid ").append(" WHERE sb.FStorageOrgUnitId = ? ").append(clr).append("   AND sb.FPlanVersionId = ? ").append(clr).append("   AND ( ");
            for (int i5 = 0; i5 < materialLst.size(); ++i5) {
                ids = (String)materialLst.get(i5);
                String storageid4 = (String)storageMatIds.get(ids + "storage");
                materialId = (String)storageMatIds.get(ids + "material");
                sql.append("( sb.FMaterialID='" + materialId + "' and sb.FSupplyStorageOrgUnitID='" + storageid4 + "' )");
                if (i5 != materialLst.size() - 1) {
                    sql.append(" or ");
                    continue;
                }
                sql.append(" ) ");
            }
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{orgId, targetVerId});
            while (rowSet.next()) {
                String billId = rowSet.getString("fid");
                String precision = rowSet.getString("fqtyPrecision");
                String rate = rowSet.getString("rate");
                this.rateMap.put(billId, new BigDecimal(rate));
                this.precisionMap.put(billId, new Integer(precision));
            }
            SOPPeriod[] range = fromPeriod.forwardPeriods(numOfPeriod);
            SopPlanAlgorithm helper = new SopPlanAlgorithm(this, ctx, conn, range, sopEditMode);
            helper.setRateMap(this.rateMap);
            helper.setPrecisionMap(this.precisionMap);
            helper.setStorageOrgUnitId(orgId);
            helper.setPlanVersionId(targetVerId);
            helper.init();
            helper.syncSopPlan(materialLst, storageMatIds);
        }
        catch (SQLException sqlExp) {
            try {
                if (!(JDBCExceptionHandler.convertException((SQLException)sqlExp) instanceof DataLimitExceedException)) throw new SQLDataException(sqlExp);
                throw new SOPException(SOPException.VALUE_TOO_LARGE, new String[]{""});
                catch (BOSException e) {
                    if (e.getCause() == null) throw e;
                    if ((SQLException)e.getCause() == null) throw e;
                    if (!(JDBCExceptionHandler.convertException((SQLException)((SQLException)e.getCause())) instanceof DataLimitExceedException)) throw e;
                    throw new SOPException(SOPException.VALUE_TOO_LARGE, new String[]{""});
                }
            }
            catch (Throwable throwable) {
                SOPUtil.releaseMutex(ctx, orgId, targetVerId);
                com.kingdee.util.db.SQLUtils.cleanup((Connection)conn);
                com.kingdee.util.db.SQLUtils.cleanup(stmtUpdateBop, null);
                throw throwable;
            }
        }
        SOPUtil.releaseMutex(ctx, orgId, targetVerId);
        com.kingdee.util.db.SQLUtils.cleanup((Connection)conn);
        com.kingdee.util.db.SQLUtils.cleanup((Statement)stmtUpdateBop, null);
    }

    @Override
    protected SOPPeriod _getPeriod(Context ctx, java.util.Date date, SOPEditModeEnum type, String storageOrgUnitID) throws BOSException, EASBizException {
        Calendar theDate = Calendar.getInstance();
        theDate.setTime(date);
        SOPSysParams sopParam = this.getSOPSysParams(ctx, storageOrgUnitID);
        if (sopParam == null) {
            throw new SOPException(SOPException.NO_DEFINED_SOPPARAM);
        }
        int paramMonthStart = 1;
        int number = 0;
        int theYear = 0;
        Calendar beginDate = null;
        Calendar endDate = null;
        if (20 == type.getValue()) {
            int iMonthStart;
            paramMonthStart = iMonthStart = sopParam.getSOPMonthStartDate();
            int lastDay = SOPUtil.getLastDayOfMonth(theDate.get(1), theDate.get(2));
            if (iMonthStart > lastDay) {
                iMonthStart = lastDay;
            }
            int bYear = theDate.get(1);
            int bMonth = theDate.get(2) + 1;
            theYear = bYear;
            int theDay = theDate.get(5);
            int eYear = bYear--;
            int eMonth = bMonth;
            if (iMonthStart <= 15) {
                if (theDay - iMonthStart < 0) {
                    number = bMonth - 1;
                    if (number <= 0) {
                        bMonth = 12;
                        eMonth = 1;
                        number = 12;
                        theYear = bYear;
                    } else {
                        --bMonth;
                    }
                } else {
                    number = bMonth;
                    if (number == 12) {
                        ++eYear;
                        eMonth = 1;
                    } else {
                        ++eMonth;
                    }
                }
            } else if (theDay - iMonthStart < 0) {
                number = bMonth--;
                if (bMonth < 1) {
                    bMonth = 12;
                    theYear = eYear;
                    --bYear;
                }
            } else {
                number = bMonth + 1;
                if (number > 12) {
                    number = 1;
                    theYear = ++eYear;
                    eMonth = 1;
                } else {
                    ++eMonth;
                }
            }
            beginDate = Calendar.getInstance();
            beginDate.set(1, bYear);
            beginDate.set(2, bMonth - 1);
            beginDate = SOPUtil.getMonthStartDay(beginDate, paramMonthStart);
            endDate = Calendar.getInstance();
            endDate.set(1, eYear);
            endDate.set(2, eMonth - 1);
            endDate = SOPUtil.getMonthEndDay(endDate, paramMonthStart);
        } else {
            int firstDayOfWeek = sopParam.getSOPWeekStartDay();
            firstDayOfWeek = firstDayOfWeek == 0 ? 2 : 1;
            theDate.setFirstDayOfWeek(firstDayOfWeek);
            number = theDate.get(3);
            int bWeekday = theDate.get(7);
            int diffDays = bWeekday - firstDayOfWeek;
            if (diffDays < 0) {
                diffDays = 6;
            }
            beginDate = SOPUtil.copyDate(theDate);
            beginDate.add(5, -diffDays);
            endDate = SOPUtil.copyDate(beginDate);
            endDate.add(5, 6);
            theYear = endDate.get(1);
        }
        SOPPeriod thePeriod = new SOPPeriod();
        thePeriod.setType(type);
        thePeriod.setYear(theYear);
        thePeriod.setNumber(number);
        thePeriod.setBeginDate(beginDate);
        thePeriod.setEndDate(endDate);
        thePeriod.setParamMonthStartDay(paramMonthStart);
        return thePeriod;
    }

    @Override
    protected SOPPeriod _getCurrentPeriod(Context ctx, SOPEditModeEnum type, String storageOrgUnitID) throws BOSException, EASBizException {
        return this._getPeriod(ctx, new java.util.Date(), type, storageOrgUnitID);
    }

    @Override
    protected IRowSet _getMaterial(Context ctx, Map params) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        IRowSet rs = null;
        String orgId = (String)params.get("org");
        String planVerId = (String)params.get("planVersion");
        String matFrom = (String)params.get("matFrom");
        String matTo = (String)params.get("matTo");
        ArrayList materialIds = (ArrayList)params.get("materials");
        ArrayList storageOrgIds = (ArrayList)params.get("executStorageOrg");
        Boolean isEditing = (Boolean)params.get("isEditing");
        List supplyOrgUnitId = (List)params.get("supplyOrgUnitId");
        if (materialIds != null) {
            if (isEditing.booleanValue()) {
                sql.append(" select * from ( ");
            }
            sql.append(" SELECT distinct storage.fid||m.fid FMatStorageIds,storage.fid FStorageId,m.FID FMatId,mi.FDaysPlanTurnover,storage.fname_" + ctx.getLocale().getDisplayLanguage() + " FExecutOrg ,m.FNumber FMatNumber, ").append("m.FName_" + ctx.getLocale().getDisplayLanguage()).append(" FMatName,m.FModel FMatModel, ").append("u.FName_" + ctx.getLocale().getDisplayLanguage()).append(" FBaseUnit, ").append("mu.FQtyPrecision, 0 FBop \n").append(" FROM T_BD_Material m,T_BD_MaterialPlan mp,T_BD_MultiMeasureUnit mu, T_BD_MeasureUnit u,T_ORG_Storage storage,t_bd_materialInventory mi\n").append(" where  m.FID = mi.FMaterialId \n").append(" AND mi.FStatus = 1 \n").append(" AND mi.FOrgUnit = storage.fid\n").append(" and m.FID = mp.FMaterialId \n").append("  AND mp.FOrgUnit = ? \n").append(" AND mp.FStatus = 1 \n").append(" and mp.FProductunitid = mu.FMeasureUnitId \n").append(" and mp.FMaterialId = mu.FMaterialId \n").append(" and mu.FMeasureUnitId = u.FId \n").append(" and m.FStatus = 1  and ( \n");
            for (int i = 0; i < materialIds.size(); ++i) {
                String storageId = (String)storageOrgIds.get(i);
                String materialId = (String)materialIds.get(i);
                if (i == materialIds.size() - 1) {
                    sql.append("  ( m.FID = '" + materialId + "' and storage.fid='" + storageId + "')");
                    continue;
                }
                sql.append(" ( m.FID = '" + materialId + "' and storage.fid='" + storageId + "') or ");
            }
            if (isEditing.booleanValue()) {
                sql.append(" )) as t \n");
                ArrayList mutexList = new ArrayList(SOPUtil.getObjIDForUpdateList(ctx, orgId, planVerId));
                if (mutexList.size() > 0) {
                    sql.append(" where t.FMatStorageIds not in ").append(SopPlanAlgorithm.getInPredicateFromList(mutexList));
                }
            }
            sql.append(" ORDER BY t.FMatNumber asc");
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{orgId});
        } else {
            if (isEditing.booleanValue()) {
                sql.append(" select * from ( ");
            }
            sql.append(" SELECT distinct storage.fid||m.fid FMatStorageIds,storage.fid FStorageId,m.fid FMatId,mi2.FDaysPlanTurnover, storage.fname_" + ctx.getLocale().getDisplayLanguage() + " FExecutOrg ,m.FNumber FMatNumber, ").append("m.FName_" + ctx.getLocale().getDisplayLanguage()).append(" FMatName,m.FModel FMatModel, ").append("u.FName_" + ctx.getLocale().getDisplayLanguage()).append(" FBaseUnit,mu.FQtyPrecision,sb.FBop \n ").append(" from t_mm_sopbill sb ").append(" inner join t_bd_material m on m.fid=sb.fmaterialid ").append(" inner join t_bd_materialInventory mi2 on m.FID = mi2.FMaterialId and mi2.FOrgUnit =sb.FSupplyStorageOrgUnitID  ").append(" INNER JOIN T_BD_MultiMeasureUnit mu on sb.FAssistUnitID = mu.FMeasureUnitId and sb.FMaterialId = mu.FMaterialId \n ").append(" INNER JOIN T_BD_MeasureUnit u on mu.FMeasureUnitId = u.FId \n ").append(" inner JOIN  T_ORG_Storage storage on  sb.FSupplyStorageOrgUnitID=storage.fid \n").append(" where sb.FStorageOrgUnitId=? and sb.FPlanVersionID=?");
            if (matFrom != null && matTo != null) {
                sql.append("   AND m.FNumber>='").append(matFrom).append("' \n");
                sql.append("   AND m.FNumber<='").append(matTo).append("' \n");
            } else if (matFrom != null) {
                sql.append("   AND m.FNumber>='").append(matFrom).append("' \n");
            } else if (matTo != null) {
                sql.append("   AND m.FNumber<='").append(matTo).append("'");
            }
            if (supplyOrgUnitId != null && supplyOrgUnitId.size() != 0) {
                sql.append(" and storage.fnumber in ").append(SopPlanAlgorithm.getInPredicateFromList(supplyOrgUnitId));
            }
            if (isEditing.booleanValue()) {
                sql.append(" ) as t \n");
                ArrayList mutexList = new ArrayList(SOPUtil.getObjIDForUpdateList(ctx, orgId, planVerId));
                if (mutexList.size() > 0) {
                    sql.append(" where t.FMatStorageIds not in ").append(SopPlanAlgorithm.getInPredicateFromList(mutexList));
                }
            }
            sql.append(" ORDER BY FExecutOrg,FMatNumber asc ");
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{orgId, planVerId});
        }
        return rs;
    }

    private void appendTransferSQl(Context ctx, StringBuffer sql, String matFrom, String matTo, boolean needMeasureUnit, Object[] supplyStorages, boolean isGetPlan, boolean isFromEditUI, String orgId) throws BOSException {
        String planVersionId;
        ArrayList billIDList;
        sql.append("  FROM T_BD_Material m \n").append(" INNER JOIN T_MM_SOPBill s on m.FID = s.FMaterialId \n").append(" and s.FStorageOrgUnitId =  ? \n");
        if (!isFromEditUI && (billIDList = SOPUtil.getHasMutexBillID(ctx, orgId, planVersionId = new String("MhhE36S+Qcy2gimEuZuUj5eYTjA="))).size() > 0) {
            sql.append(" and s.fid not in ").append(SopPlanAlgorithm.getInPredicateFromList(billIDList));
        }
        if (null != supplyStorages && supplyStorages.length > 0 && null != supplyStorages[0]) {
            boolean isFirst = true;
            sql.append(" and s.FSUPPLYSTORAGEORGUNITID in (");
            for (int i = 0; i < supplyStorages.length; ++i) {
                if (isFirst) {
                    sql.append("'").append(((StorageOrgUnitInfo)supplyStorages[i]).getId().toString()).append("'");
                    isFirst = false;
                    continue;
                }
                sql.append(",").append(" '").append(((StorageOrgUnitInfo)supplyStorages[i]).getId().toString()).append("' ");
            }
            sql.append(") \n");
        }
        sql.append(" --INNER JOIN t_bd_materialInventory mi on m.FID = mi.FMaterialId \n").append(" --AND mi.FStatus = 1 \n").append(" --AND mi.FOrgUnit = s.FSUPPLYSTORAGEORGUNITID \n").append(" INNER JOIN T_BD_MaterialPlan mp on m.FID = mp.FMaterialId \n").append("  AND mp.FOrgUnit = s.FSUPPLYSTORAGEORGUNITID \n");
        if (isGetPlan) {
            sql.append(" and mp.fManufacturestrategyid not in ('");
            sql.append("fpPxtypCS/ihJ30GjB/UJtg0uEU=");
            sql.append("','");
            sql.append("GE2FIa4GQ6uhdx0RDGuibtg0uEU=");
            sql.append("','");
            sql.append("qAXoUB/tBg/gQKjAYj0WQ9g0uEU=");
            sql.append("','");
            sql.append("qAXoUB/uBg/gQKjAYj0WQ9g0uEU=");
            sql.append("')");
        }
        sql.append(" INNER JOIN T_MM_SOPPlanVersion pv on pv.FID = s.fplanversionid \n").append(" and pv.FNumber='000' \n").append(" INNER JOIN T_MM_SOPPlan sp on s.FId = sp.FParentId \n").append(" AND sp.FPeriodNumber >= ? \n").append(" AND sp.FPeriodNumber <= ? \n").append(" AND sp.FEditMode = ? \n");
        if (needMeasureUnit) {
            sql.append(" LEFT JOIN T_BD_ManufactureStrategy ms on ms.FID=mp.FManufactureStrategyID \n").append(" INNER JOIN T_BD_MultiMeasureUnit mu1 on mp.FProductunitid = mu1.FMeasureUnitId \n").append(" and mp.FMaterialId = mu1.FMaterialId \n").append(" INNER JOIN T_BD_MeasureUnit u on s.FAssistUnitID = u.FId  \n").append(" INNER JOIN T_BD_MultiMeasureUnit mu2 on m.FBaseUnit = mu2.FMeasureUnitId \n").append(" and m.FId = mu2.FMaterialId \n");
        }
        sql.append(" inner join T_ORG_Storage as storage on s.FSUPPLYSTORAGEORGUNITID = storage.fid ");
        sql.append(" inner join t_bd_MultiMeasureUnit as mu on mu.FMeasureUnitID=s.FAssistUnitID and mu.fmaterialid=m.fid ");
        sql.append(" WHERE m.FStatus = 1 \n");
        if (matFrom != null && matFrom.trim().length() > 0) {
            sql.append("   AND m.FNumber>='").append(matFrom).append("' \n");
        }
        if (matTo != null && matTo.trim().length() > 0) {
            sql.append("   AND m.FNumber<='").append(matTo).append("' \n");
        }
        sql.append(" ORDER BY").append("  storage.FName_").append(ctx.getLocale().getDisplayLanguage()).append(" ,m.FNumber asc;");
    }

    private void sqlFetchMaterial4Transfer(Context ctx, StringBuffer sql, String matFrom, String matTo, String orgId, Object[] supplyStorages, boolean isFromEditUI) throws BOSException, EASBizException {
        sql.append(" SELECT distinct FStatus='false', m.FID FMaterialId, m.FNumber FMatNumber, ").append("   m.FName_" + ctx.getLocale().getDisplayLanguage()).append(" FMatName,m.FModel FMatModel, ").append("   ms.fnumber").append(" FStrategy, \n").append("   FReqType=case when ms.FNumber='MTS10' or ms.FNumber='MTS11' then 'PID' ").append(" when mp.FIsComReqConsume = 1 then 'PID' ").append(" when ms.FNumber='MTS20' or ms.FNumber='ATO10' or ms.FNumber='ATO20' or ms.FNumber='ATO30' then 'PIC' else '' end,\n").append("   u.FName_" + ctx.getLocale().getDisplayLanguage()).append(" FUnitName, ").append("   mp.FProductUnitID FPlanUnitId, mu1.FBaseConvsRate, mu1.FQtyPrecision FPlanPrecision, m.FBaseUnit FBaseUnitId, mu2.FQtyPrecision FBasePrecision, \n");
        sql.append("  storage.FName_").append(ctx.getLocale().getDisplayLanguage()).append(" FsupplyStorageName,storage.Fid FsupplyStorageID, m.FNumber||storage.Fid as FKey ");
        this.appendTransferSQl(ctx, sql, matFrom, matTo, true, supplyStorages, false, isFromEditUI, orgId);
    }

    private void sqlFetchSopPlan4Transfer(Context ctx, SOPPlannedTypeEnum planType, StringBuffer sql, String matFrom, String matTo, Object[] supplyStorages, boolean isFromEditUI, String orgId) throws BOSException {
        sql.append(" SELECT m.FNumber FMatNumber,m.fid fmatid, sp.FPeriodNumber FDisplayPeriod, ").append(planType.equals((Object)SOPPlannedTypeEnum.SALEPLAN) ? "sp.FSalesQty FQty , sp.FBaseSalesQty FBaseQty" : "sp.FProductionQty FQty, sp.FBaseProductionQty  FBaseQty");
        sql.append(" , storage.FName_").append(ctx.getLocale().getDisplayLanguage()).append(" FsupplyStorageName,storage.Fid FsupplyStorageID, m.FNumber||storage.Fid as FKey,mu.FBaseConvsRate as frate  ");
        this.appendTransferSQl(ctx, sql, matFrom, matTo, true, supplyStorages, true, isFromEditUI, orgId);
    }

    private Object[] getData4Transfer(Context ctx, Map params) throws BOSException, EASBizException {
        SOPEditModeEnum editMode = (SOPEditModeEnum)((Object)params.get("sopeditmode"));
        SOPPlannedTypeEnum planType = (SOPPlannedTypeEnum)((Object)params.get("PlanType"));
        String orgId = (String)params.get("org");
        String matFrom = (String)params.get("matFrom");
        String matTo = (String)params.get("matTo");
        Object[] supplyStorages = (Object[])params.get("executStorageOrg");
        SOPPeriod[] range = (SOPPeriod[])params.get("periodFrom");
        Boolean isFromEditUI = (Boolean)params.get("isFromEditUI");
        Integer periodFrom = new Integer(range[0].toNumber());
        Integer periodTo = new Integer(range[range.length - 1].toNumber());
        StringBuffer sql = new StringBuffer(1000);
        this.sqlFetchMaterial4Transfer(ctx, sql, matFrom, matTo, orgId, supplyStorages, isFromEditUI);
        IRowSet rsMat = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{orgId, periodFrom, periodTo, new Integer(editMode.getValue())});
        sql = new StringBuffer(1000);
        this.sqlFetchSopPlan4Transfer(ctx, planType, sql, matFrom, matTo, supplyStorages, isFromEditUI, orgId);
        IRowSet rsPlan = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{orgId, periodFrom, periodTo, new Integer(editMode.getValue())});
        IRowSet rsPlanVersion = DbUtil.executeQuery((Context)ctx, (String)"select FID from t_mm_sopplanversion where FNumber='000'");
        String planVersion = null;
        String supplyStorageId = "";
        HashMap<String, String> idMap = new HashMap<String, String>();
        try {
            while (rsPlan.next()) {
                supplyStorageId = rsPlan.getString("FsupplyStorageID");
                if (idMap.containsKey(supplyStorageId)) continue;
                idMap.put(supplyStorageId, supplyStorageId);
            }
        }
        catch (SQLException e1) {
            throw new BOSException((Throwable)e1);
        }
        Object[] ids = idMap.keySet().toArray();
        HashMap period2Days = new HashMap();
        Map testMap = new HashMap();
        for (int i = 0; i < ids.length; ++i) {
            testMap = SopDateUtil.getPeriod2DayMap(ctx, (String)ids[i], range, this._getSOPSysParams(ctx, (String)ids[i]));
            period2Days.put((String)ids[i], testMap);
        }
        try {
            rsPlanVersion.next();
            planVersion = rsPlanVersion.getString("FID");
        }
        catch (SQLException e) {
            throw new SOPException(SOPException.AVERAGE_EXCEPTION);
        }
        return new Object[]{rsMat, rsPlan, planVersion, period2Days};
    }

    @Override
    protected IRowSet _getSopPlan(Context ctx, Map params) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        SOPEditModeEnum editMode = (SOPEditModeEnum)((Object)params.get("sopeditmode"));
        String orgId = (String)params.get("org");
        String planVerId = (String)params.get("planVersion");
        String matFrom = (String)params.get("matFrom");
        String matTo = (String)params.get("matTo");
        ArrayList materialIds = (ArrayList)params.get("materials");
        ArrayList storageOrgIds = (ArrayList)params.get("executStorageOrg");
        Integer periodFrom = (Integer)params.get("periodFrom");
        Integer periodTo = (Integer)params.get("periodTo");
        Boolean isEditing = (Boolean)params.get("isEditing");
        if (isEditing.booleanValue()) {
            sql.append("select * from ( \n");
        }
        sql.append(" SELECT b.FSupplyStorageOrgUnitID||m.fid FMatStorageIds, m.FNumber FMatNumber, ").append(" p.FPeriodNumber FDisplayPeriod,").append(" p.FSalesQty, p.FProdTheoryQty, p.FProductionQty, p.FTargetInvQty \n").append(" FROM T_MM_SOPPlan p, T_MM_SopBill b, T_BD_Material m \n").append(" WHERE b.FMaterialId = m.FID \n").append("   AND m.FStatus = 1 \n").append("   AND b.FId = p.FParentId \n").append("AND b.FStorageOrgUnitId = ? \n").append("   AND b.FPlanVersionId = ? \n").append("   AND p.FEditMode = ? ").append("   AND p.FPeriodNumber >= ? ").append("   AND p.FPeriodNumber <= ? ");
        if (materialIds == null) {
            if (matFrom != null) {
                sql.append("   AND m.FNumber>='").append(matFrom).append("' \n");
            }
            if (matTo != null) {
                sql.append("   AND m.FNumber<='").append(matTo).append("' ");
            }
        } else {
            sql.append(" AND ( ");
            for (int i = 0; i < materialIds.size(); ++i) {
                String materialId = (String)materialIds.get(i);
                String storageId = (String)storageOrgIds.get(i);
                sql.append(" ( b.FSupplyStorageOrgUnitID='" + storageId + "' and m.fid='" + materialId + "')");
                if (i >= materialIds.size() - 1) continue;
                sql.append(" or ");
            }
            sql.append(" )");
        }
        if (isEditing.booleanValue()) {
            sql.append(" ) as t \n");
            ArrayList mutexList = new ArrayList(SOPUtil.getObjIDForUpdateList(ctx, orgId, planVerId));
            if (mutexList.size() > 0) {
                sql.append(" where t.FMatStorageIds not in ").append(SopPlanAlgorithm.getInPredicateFromList(mutexList));
            }
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{orgId, planVerId, new Integer(editMode.getValue()), periodFrom, periodTo});
        return rs;
    }

    @Override
    protected SOPSysParams _getSOPSysParams(Context ctx, String storageOrgUnitID) throws BOSException, EASBizException {
        SOPSysParams sysParams = new SOPSysParams();
        String pValue = ParamManager.getParamValue((Context)ctx, (IObjectPK)new ObjectUuidPK(storageOrgUnitID), (String)"SOP_MONTH_HORIZON");
        sysParams.setSOPMonthHorizon(new Integer(pValue));
        pValue = ParamManager.getParamValue((Context)ctx, (IObjectPK)new ObjectUuidPK(storageOrgUnitID), (String)"SOP_WEEK_HORIZON");
        sysParams.setSOPWeekHorizon(new Integer(pValue));
        pValue = ParamManager.getParamValue((Context)ctx, (IObjectPK)new ObjectUuidPK(storageOrgUnitID), (String)"SOP_MONTH_STARTDATE");
        sysParams.setSOPMonthStartDate(new Integer(pValue));
        pValue = ParamManager.getParamValue((Context)ctx, (IObjectPK)new ObjectUuidPK(storageOrgUnitID), (String)"SOP_WEEK_STARTDAY");
        sysParams.setSOPWeekStartDay(new Integer(pValue));
        pValue = ParamManager.getParamValue((Context)ctx, (IObjectPK)new ObjectUuidPK(storageOrgUnitID), (String)"SOP_MONTH_REQDAY");
        sysParams.setSOPMonthReqDay(new Integer(pValue));
        pValue = ParamManager.getParamValue((Context)ctx, (IObjectPK)new ObjectUuidPK(storageOrgUnitID), (String)"SOP_WEEK_REQDAY");
        sysParams.setSOPWeekReqDay(new Integer(pValue));
        pValue = ParamManager.getParamValue((Context)ctx, (IObjectPK)new ObjectUuidPK(storageOrgUnitID), (String)"SOP_TRANSFER_AVERAGE");
        sysParams.setSOPTransferAverage(Boolean.valueOf(pValue));
        return sysParams;
    }

    @Override
    protected Object[] _getTransferData(Context ctx, Map map) throws BOSException, EASBizException {
        return this.getData4Transfer(ctx, map);
    }

    protected Object[] olGetTransferDat(Context ctx, Map map) throws BOSException, EASBizException {
        String sqlTableName = (String)map.get("sqlTableName");
        String StorageOrgUnitID = (String)map.get("StorageOrgUnitID");
        Boolean bRefreshData = (Boolean)map.get("RefreshData");
        SOPSysParams sysParams = (SOPSysParams)map.get("sysParams");
        SOPPeriod[] periods = (SOPPeriod[])map.get("periods");
        if (bRefreshData.equals(false)) {
            if ("".equalsIgnoreCase(sqlTableName) || sqlTableName == null) {
                sqlTableName = this.getSOPTransferTempTableName(ctx);
            } else {
                DbUtil.execute((Context)ctx, (String)("delete from " + sqlTableName + " where FStorageOrgUnitID='" + StorageOrgUnitID + "'"));
            }
            BOSObjectType sopBosObjectType = new BOSObjectType("259EA739");
            IObjectPK pk = LogUtil.beginLog((Context)ctx, (String)"1", (BOSObjectType)sopBosObjectType, null, (String)(periods[0].toString() + "~" + periods[periods.length - 1].toString()), (String)"mm_sop_plan_transfer");
            map.put("sqlTableName", sqlTableName);
            this.prepareEnvironment(ctx, map);
            if (sysParams.getSOPTransferAverage()) {
                this.processAverager(ctx, map);
            }
            LogUtil.afterLog((Context)ctx, (IObjectPK)pk);
        }
        Object[] obj = this.getAveragePlan(ctx, map);
        return obj;
    }

    protected Object[] getData2Transfer(Context ctx, Map map) throws BOSException, EASBizException {
        SOPPeriod[] periods = (SOPPeriod[])map.get("periods");
        BOSObjectType sopBosObjectType = new BOSObjectType("259EA739");
        IObjectPK pk = LogUtil.beginLog((Context)ctx, (String)"1", (BOSObjectType)sopBosObjectType, null, (String)(periods[0].toString() + "~" + periods[periods.length - 1].toString()), (String)"mm_sop_plan_transfer");
        Object[] obj = this.getAveragePlan(ctx, map);
        LogUtil.afterLog((Context)ctx, (IObjectPK)pk);
        return obj;
    }

    private Object[] getAveragePlan(Context ctx, Map map) throws BOSException {
        String sqlTableName = (String)map.get("sqlTableName");
        String StorageOrgUnitID = (String)map.get("StorageOrgUnitID");
        SOPPlannedTypeEnum planType = (SOPPlannedTypeEnum)((Object)map.get("PlanType"));
        String sql = "select distinct FStatus='false',t3.FMaterialID,FMatNumber=t2.FNumber, FMatName_L1=t2.FName_L1,FMatName=t2.FName_l2,FMatName_L3=t2.FName_L3, FMatModel=t2.FModel,FStrategy_l1=t4.FName_L1,FStrategy=t4.FName_l2,FStrategy_l3=t4.FName_l3, FReqType=case when t4.FNumber='MTS10' or t4.FNumber='MTS11' then 'PID' when t4.FNumber='MTS20' then 'PIC' else '' end, FUnitName_l1=t5.FName_l1,FUnitName=t5.FName_l2,FUnitName_l3=t5.FName_l3, t1.FQtyprecision FPlanPrecision from " + sqlTableName + " t1,t_bd_material t2,t_bd_materialplan t3 left join T_BD_ManufactureStrategy t4 on t3.FManufactureStrategyID=t4.FID \r\n inner join t_bd_measureunit t5 on t3.FProductUnitid=t5.FID \r\n where t1.FMaterialID=t2.FID  and t1.FMaterialID=t3.FMaterialID  and t1.FStorageOrgUnitID=t3.FOrgUnit  and t1.FStorageOrgUnitID='" + StorageOrgUnitID + "' \r\n and t1.FPlanType=" + Integer.toString(planType.getValue()) + " and t1.FStatus=0 order by t2.FNumber";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        String sql1 = "select distinct FMatNumber=t2.FNumber,FDisplayPeriod=to_char(t1.FDate,'yyyy-mm-dd'),t1.FQty from " + sqlTableName + " t1,t_bd_material t2 where t1.FStatus=0 and t1.FMaterialID=t2.FID and t1.FStorageOrgUnitID='" + StorageOrgUnitID + "' \r\nand t1.FPlanType=" + Integer.toString(planType.getValue()) + "  order by  FMatNumber,FDisplayPeriod";
        IRowSet rs1 = DbUtil.executeQuery((Context)ctx, (String)sql1);
        IRowSet rs2 = DbUtil.executeQuery((Context)ctx, (String)"select FID from t_mm_sopplanversion where FNumber='000'");
        String sDefaultVersion = null;
        try {
            rs2.next();
            sDefaultVersion = rs2.getString("FID");
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return new Object[]{sqlTableName, rs, rs1, sDefaultVersion};
    }

    private void processAverager(Context ctx, Map map) throws BOSException, EASBizException {
        String sqlTableName = (String)map.get("sqlTableName");
        String StorageOrgUnitID = (String)map.get("StorageOrgUnitID");
        String materialFrom = (String)map.get("matFrom");
        String materialTo = (String)map.get("matTo");
        String periodFrom = (String)map.get("periodFrom");
        String periodTo = (String)map.get("periodTo");
        SOPPlannedTypeEnum planType = (SOPPlannedTypeEnum)((Object)map.get("PlanType"));
        SOPEditModeEnum editMode = (SOPEditModeEnum)((Object)map.get("sopeditmode"));
        SOPPeriod[] periods = (SOPPeriod[])map.get("periods");
        String sql = "select distinct a.FMaterialID,FPeriod=to_char(b.FYear*100+b.FPeriod),b.FSalesQty,b.FProductionQty,b.FTargetInvQty,d.FBaseConvsrate \r\n from T_mm_SopBill a \r\n inner join T_MM_SopPlan b on a.fid=b.fparentid \r\n inner join t_bd_material c on a.FMaterialID=c.fid \r\n inner join t_bd_materialplan e on e.FMaterialID=c.fid and e.FOrgUnit=a.FStorageOrgUnitID \r\n inner join t_bd_multimeasureunit d on e.FMaterialID=d.FMaterialID and e.FProductUnitid=d.FMeasureUnitID \r\n where a.FStorageOrgUnitID='" + StorageOrgUnitID + "' and b.FEditMode=" + Integer.toString(editMode.getValue());
        if (!"".equalsIgnoreCase(materialFrom)) {
            sql = sql + " and c.Fnumber>='" + materialFrom + "'";
        }
        if (!"".equalsIgnoreCase(materialTo)) {
            sql = sql + " and c.FNumber<='" + materialTo + "'";
        }
        sql = sql + " and to_char(b.FYear*100+b.FPeriod)>='" + periodFrom + "'";
        sql = sql + " and to_char(b.FYear*100+b.FPeriod)<='" + periodTo + "'";
        sql = sql + " and a.FPlanVersionID=(select FID from T_MM_SOPPlanVersion where FNumber='000' and FActivation>0) union select '' as FMaterialID,'0' as FPeriod,0 as FSalesQty,0 as FProductionQty,0 as FTargetInvQty,0 as FBaseConvsrate";
        String sql1 = "select t1.FMaterialID,t1.FPeriod,t1.FsalesQty,t1.FProductionQty,t1.FTargetInvQty,t1.FBaseConvsrate,FDays=count(*),a.FQtyPrecision,a.FBaseQtyPrecision from " + sqlTableName + " a inner join ( \r\n" + sql + " ) t1 \r\n on a.FMaterialID=t1.FmaterialID and a.FPeriod=t1.FPeriod  \r\n where a.FStorageOrgUnitID='" + StorageOrgUnitID + "'  and a.FPlanType=" + Integer.toString(planType.getValue()) + " group by t1.FMaterialID,t1.FPeriod,t1.FsalesQty,t1.FProductionQty,t1.FTargetInvQty,t1.FBaseConvsrate,a.FQtyPrecision,a.FBaseQtyPrecision";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql1);
        sql = "Update " + sqlTableName + " as t0 set FQty=?,FBaseQty=? where FPlanType=" + Integer.toString(planType.getValue()) + " and FMaterialID=? and FStorageOrgUnitID='" + StorageOrgUnitID + "' and to_char(FDate,'yyyy-mm-dd')=?";
        BigDecimal qty = new BigDecimal("0.00");
        BigDecimal qtyAverage = new BigDecimal("0.00");
        BigDecimal qtyTotal = new BigDecimal("0.00");
        BigDecimal qtyDay = new BigDecimal("0.00");
        BigDecimal baseQty = new BigDecimal("0.00");
        BigDecimal baseQtyAverage = new BigDecimal("0.00");
        BigDecimal baseQtyTotal = new BigDecimal("0.00");
        BigDecimal baseQtyDay = new BigDecimal("0.00");
        BigDecimal qtyTmp = null;
        int qtyPrecision = 0;
        int baseQtyPrecision = 0;
        BigDecimal iDays = new BigDecimal("0.00");
        BigDecimal qtyZero = new BigDecimal("0.00");
        int i = 0;
        int j = 0;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String sDate = "";
        if (rs != null) {
            Connection conn = null;
            PreparedStatement stmt = null;
            List datePeriodList = null;
            try {
                conn = EJBFactory.getConnection((Context)ctx);
                stmt = conn.prepareStatement(sql);
                while (rs.next()) {
                    qtyPrecision = rs.getInt("FQtyPrecision");
                    baseQtyPrecision = rs.getInt("FBaseQtyPrecision");
                    iDays = rs.getBigDecimal("FDays");
                    switch (planType.getValue()) {
                        case 2: {
                            qty = rs.getBigDecimal("FProductionQty");
                            break;
                        }
                        case 1: {
                            qty = rs.getBigDecimal("FsalesQty");
                        }
                    }
                    baseQty = qty.multiply(rs.getBigDecimal("FBaseConvsrate"));
                    i = this.getSOPPeriodIndexOf(periods, rs.getString("FPeriod"));
                    qtyTotal = qtyTotal.subtract(qtyTotal);
                    baseQtyTotal = baseQtyTotal.subtract(baseQtyTotal);
                    if (iDays.compareTo(qtyZero) <= 0) continue;
                    qtyAverage = qty.divide(iDays, qtyPrecision, 2);
                    baseQtyAverage = baseQty.divide(iDays, baseQtyPrecision, 2);
                    datePeriodList = this.getPeriodsRangeDateList(ctx, sqlTableName, periods[i]);
                    java.util.Date dateBegin = (java.util.Date)datePeriodList.get(0);
                    java.util.Date dateEnd = (java.util.Date)datePeriodList.get(datePeriodList.size() - 1);
                    java.util.Date dateTmp = dateBegin;
                    j = 1;
                    while (!dateTmp.after(dateEnd) && qtyTotal.compareTo(qty) < 0) {
                        if (dateTmp.equals(dateBegin)) {
                            qtyDay = qtyAverage;
                            baseQtyDay = baseQtyAverage;
                        } else if (dateTmp.equals(dateEnd)) {
                            qtyDay = qty.subtract(qtyTotal);
                            baseQtyDay = baseQty.subtract(baseQtyTotal);
                        } else if (dateTmp.after(dateBegin) && dateTmp.before(dateEnd)) {
                            qtyTmp = qtyAverage.multiply(new BigDecimal(Integer.toString(j)));
                            qtyDay = qtyTmp.compareTo(qty) < 0 ? qtyTmp.subtract(qtyTotal) : qty.subtract(qtyTotal);
                            qtyTmp = baseQtyAverage.multiply(new BigDecimal(Integer.toString(j)));
                            baseQtyDay = qtyTmp.compareTo(baseQty) < 0 ? qtyTmp.subtract(baseQtyTotal) : baseQty.subtract(baseQtyTotal);
                        }
                        qtyTotal = qtyTotal.add(qtyDay);
                        baseQtyTotal = baseQtyTotal.add(baseQtyDay);
                        if (qtyTotal.compareTo(qty) > 0) {
                            qtyDay = qtyDay.subtract(qtyTotal.subtract(qty));
                            baseQtyDay = baseQtyAverage.subtract(baseQtyTotal.subtract(baseQty));
                        }
                        stmt.setBigDecimal(1, qtyDay);
                        stmt.setBigDecimal(2, baseQtyDay);
                        stmt.setString(3, rs.getString("FMaterialID"));
                        sDate = sdf.format(dateTmp);
                        stmt.setString(4, sDate);
                        stmt.addBatch();
                        if (j >= datePeriodList.size()) break;
                        dateTmp = (java.util.Date)datePeriodList.get(j);
                        ++j;
                    }
                    stmt.executeBatch();
                }
            }
            catch (SQLException e1) {
                try {
                    throw new SOPException(SOPException.AVERAGE_EXCEPTION);
                }
                catch (Throwable throwable) {
                    com.kingdee.util.db.SQLUtils.cleanup(stmt, (Connection)conn);
                    throw throwable;
                }
            }
            com.kingdee.util.db.SQLUtils.cleanup((Statement)stmt, (Connection)conn);
        }
    }

    private List getPeriodsRangeDateList(Context ctx, String sqlTableName, SOPPeriod sopPeriod) throws BOSException {
        ArrayList<Date> dateList = new ArrayList<Date>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String sDateFrom = sdf.format(sopPeriod.getBeginDate().getTime());
        String sDateTo = sdf.format(sopPeriod.getEndDate().getTime());
        String sql = "select distinct FDate from " + sqlTableName + " where FDate>=to_date('" + sDateFrom + "') and FDate<=to_date('" + sDateTo + "') order by FDate";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rs.next()) {
                dateList.add(rs.getDate("FDate"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return dateList;
    }

    private void prepareEnvironment(Context ctx, Map map) throws BOSException, EASBizException {
        String sqlTableName = (String)map.get("sqlTableName");
        String StorageOrgUnitID = (String)map.get("StorageOrgUnitID");
        String materialFrom = (String)map.get("matTo");
        String materialTo = (String)map.get("matTo");
        String periodFrom = (String)map.get("periodFrom");
        String periodTo = (String)map.get("periodTo");
        SOPPlannedTypeEnum planType = (SOPPlannedTypeEnum)((Object)map.get("PlanType"));
        SOPEditModeEnum editMode = (SOPEditModeEnum)((Object)map.get("sopeditmode"));
        SOPPeriod[] periods = (SOPPeriod[])map.get("periods");
        SOPSysParams sysParams = (SOPSysParams)map.get("sysParams");
        String sQty = planType.getValue() == 2 ? "b.FProductionQty" : "b.FSalesQty";
        String sql = "delete from " + sqlTableName + " where fid in (select a.fid from " + sqlTableName + " a inner join t_bd_material b on a.fmaterialid=b.fid and a.fstorageorgunitid='" + StorageOrgUnitID + "' and a.FPlanType=" + Integer.toString(planType.getValue()) + " )";
        DbUtil.execute((Context)ctx, (String)sql);
        if (!sysParams.getSOPTransferAverage()) {
            this.processRequestAverageIsNot(ctx, map);
            return;
        }
        sql = "select distinct a.FMaterialID \r\n from T_mm_SopBill a \r\n inner join T_MM_SopPlan b on a.FID=b.FParentID \r\n inner join t_bd_material c on a.FMaterialID=c.fid  where a.FStorageOrgUnitID='" + StorageOrgUnitID + "'  and b.FEditMode=" + Integer.toString(editMode.getValue());
        if (!"".equalsIgnoreCase(materialFrom)) {
            sql = sql + " and c.Fnumber>='" + materialFrom + "'";
        }
        if (!"".equalsIgnoreCase(materialTo)) {
            sql = sql + " and c.FNumber<='" + materialTo + "'";
        }
        sql = sql + " and to_char(b.FYear*100+b.FPeriod)>='" + periodFrom + "' and to_char(b.FYear*100+b.FPeriod)<='" + periodTo + "' and " + sQty + ">0";
        sql = sql + " and a.FPlanVersionID=(select FID from T_MM_SOPPlanVersion where FNumber='000' and FActivation>0)";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        int i = 0;
        int j = periods.length;
        Connection conn = null;
        Statement stmt = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        StringBuffer sqlInit = new StringBuffer();
        String sDate = "";
        String sDate1 = "";
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            stmt = conn.createStatement();
            while (rs.next()) {
                for (i = 0; i < j; ++i) {
                    sDate = sdf.format(periods[i].getBeginDate().getTime());
                    sDate1 = sdf.format(periods[i].getEndDate().getTime());
                    sqlInit.append("Insert into " + sqlTableName + "(FID,FStatus,FStorageOrgUnitID,FMaterialID,FPlanType,FDate,FPeriod,FQty,FQtyPrecision) \r\nselect newbosid('C3651DB1'),0,'" + StorageOrgUnitID + "','" + rs.getString("FMaterialID") + "'," + Integer.toString(planType.getValue()) + ",b.FWorkDate,'" + Integer.toString(periods[i].toNumber()) + "',0,0 \r\n from T_MM_FactoryCalendar a inner join T_MM_FactoryCalendarEntry b on a.fid=b.FParentID where b.FWorkDateSeq>0 and a.FStorageOrgUnitID='" + StorageOrgUnitID + "' and to_char(b.FWorkDate,'yyyy-mm-dd')>='" + sDate + "' and to_char(b.FWorkDate,'yyyy-mm-dd')<='" + sDate1 + "'");
                    stmt.addBatch(sqlInit.toString());
                    sqlInit.delete(0, sqlInit.length());
                }
                stmt.executeBatch();
            }
        }
        catch (SQLException er) {
            try {
                throw new SQLDataException(er);
            }
            catch (Throwable throwable) {
                com.kingdee.util.db.SQLUtils.cleanup(stmt, (Connection)conn);
                throw throwable;
            }
        }
        com.kingdee.util.db.SQLUtils.cleanup((Statement)stmt, (Connection)conn);
        this.processTempTableUnit(ctx, sqlTableName);
    }

    @Override
    protected BigDecimal[] _getWorkDayCount(Context ctx, String storageOrgUnitId, SOPPeriod[] periodRange) throws BOSException, EASBizException {
        BigDecimal[] dayCounts = new BigDecimal[periodRange.length];
        String clr = "\n";
        Calendar curDate = Calendar.getInstance();
        curDate.set(10, 0);
        curDate.set(12, 0);
        curDate.set(13, 0);
        curDate.set(14, 0);
        int curDateNumber = SopPlanAlgorithm.getNumberFromCalendar(curDate);
        for (int i = 0; i < periodRange.length; ++i) {
            Calendar begin = (Calendar)periodRange[i].getBeginDate().clone();
            if (SopPlanAlgorithm.getNumberFromCalendar(begin) < curDateNumber) {
                begin = curDate;
            }
            Calendar end = (Calendar)periodRange[i].getEndDate().clone();
            StringBuffer sql = new StringBuffer();
            sql.append(" SELECT count(t0.FWorkDate)*1.0 DayCount ").append(clr).append("  FROM t_mm_Factorycalendarentry t0 ,t_mm_factorycalendar t1 ").append(clr).append(" WHERE t0.fparentid = t1.fid ").append(clr).append("   AND t0.fworkdate >= to_date('").append(MRPUtil.dateToString(begin.getTime(), "yyyy-MM-dd")).append("') ").append("   AND t0.fworkdate <= to_date('").append(MRPUtil.dateToString(end.getTime(), "yyyy-MM-dd")).append("') ").append("   AND t1.fstorageorgunitid = ? ").append(clr).append("   AND t0.FWorkDateSeq > 0");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{storageOrgUnitId});
            try {
                if (!rs.next()) continue;
                dayCounts[i] = rs.getBigDecimal("DayCount");
                logger.info((Object)(storageOrgUnitId + "," + rs.getBigDecimal("DayCount") + "," + sql.toString()));
                continue;
            }
            catch (SQLException er) {
                throw new SQLDataException(er);
            }
        }
        return dayCounts;
    }

    private int getSOPPeriodIndexOf(SOPPeriod[] periods, String sPeriod) {
        int i = 0;
        for (i = 0; i < periods.length && periods[i].toNumber() != Integer.parseInt(sPeriod); ++i) {
        }
        return i;
    }

    private void processTempTableUnit(Context ctx, String sqlTableName) throws BOSException, EASBizException {
        String sql = "update " + sqlTableName + " as t0 set FUnitID=(select t1.Fproductunitid from " + sqlTableName + " tt2,t_bd_materialplan as t1 where tt2.FMaterialID=t1.FMaterialID and tt2.FStorageOrgUnitID=t1.FOrgUnit and tt2.fid=t0.fid),FQtyPrecision=(select t3.FQtyPrecision from " + sqlTableName + " tt1,t_bd_materialplan t2,t_bd_multimeasureunit t3 where tt1.FMaterialID=t2.fMaterialID and tt1.FStorageOrgUnitID=t2.FOrgUnit and t2.fmaterialID=t3.fmaterialid and t2.fproductunitid=t3.fmeasureunitid and tt1.fid=t0.fid ),FBaseUnitID=(select t10.fbaseunit from t_bd_material t10," + sqlTableName + " t11 where t10.fid=t11.FMaterialID and t11.fid=t0.FID),FBaseQtyPrecision=(select t22.FQtyPrecision from " + sqlTableName + " t20,t_bd_material t21,t_bd_multimeasureunit t22 where t20.FMaterialID=t21.FID and t21.FID=t22.fmaterialid and t21.FBaseUnit=t22.fmeasureunitid and t20.fid=t0.fid ) where t0.funitid is null";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    private void processRequestAverageIsNot(Context ctx, Map map) throws BOSException, EASBizException {
        String sqlTableName = (String)map.get("sqlTableName");
        String StorageOrgUnitID = (String)map.get("StorageOrgUnitID");
        String materialFrom = (String)map.get("materialFrom");
        String materialTo = (String)map.get("materialTo");
        String periodFrom = (String)map.get("periodFrom");
        String periodTo = (String)map.get("periodTo");
        SOPPlannedTypeEnum planType = (SOPPlannedTypeEnum)((Object)map.get("planType"));
        SOPEditModeEnum editMode = (SOPEditModeEnum)((Object)map.get("editMode"));
        SOPPeriod[] periods = (SOPPeriod[])map.get("periods");
        SOPSysParams sysParams = (SOPSysParams)map.get("sysParams");
        String sQty = planType.getValue() == 2 ? "b.FProductionQty" : "b.FSalesQty";
        String sql = "Insert into " + sqlTableName + "(FID,FStatus,FStorageOrgUnitID,FMaterialID,FPlanType,FDate,FPeriod,FQty,FQtyPrecision,FBaseQty) \r\nselect newbosid('C3651DB1'),0,a.FStorageOrgUnitID,a.FMaterialID," + Integer.toString(planType.getValue()) + ", to_date('1999-1-1'),to_char(b.FYear*100+b.FPeriod)," + sQty + ",0," + sQty + "*d.FBaseConvsRate \r\n from T_MM_SopBill a \r\n inner join T_MM_SopPlan b on a.FID=b.FParentID \r\n inner join t_bd_material c on a.FMaterialID=c.fid \r\n inner join t_bd_materialplan e on e.FMaterialID=c.fid and e.FOrgUnit=a.FStorageOrgUnitID \r\n inner join t_bd_multimeasureunit d on e.FProductUnitid=d.fmeasureunitid and e.FMaterialID=d.fmaterialid \r\n where a.FStorageOrgUnitID='" + StorageOrgUnitID + "' and b.FEditMode=" + Integer.toString(editMode.getValue()) + ("".equalsIgnoreCase(materialFrom) ? "" : " and c.Fnumber>='" + materialFrom + "'") + ("".equalsIgnoreCase(materialTo) ? "" : " and c.FNumber<='" + materialTo + "'") + " and to_char(b.FYear*100+b.FPeriod)>='" + periodFrom + "' and to_char(b.FYear*100+b.FPeriod)<='" + periodTo + "' and " + sQty + ">0 and a.FPlanVersionID=(select FID from T_MM_SOPPlanVersion where FNumber='000' and FActivation>0)";
        DbUtil.execute((Context)ctx, (String)sql);
        sql = "select FID,FPeriod from " + sqlTableName + " where FStorageOrgUnitID='" + StorageOrgUnitID + "' and FPlanType=" + Integer.toString(planType.getValue());
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        if (rs == null) {
            return;
        }
        Connection conn = null;
        Statement stmt = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        java.util.Date dateTmp = null;
        int iPeriod = 0;
        int iTrans = 0;
        Calendar calDate = Calendar.getInstance();
        Calendar calDateTmp = Calendar.getInstance();
        String sFID = null;
        String sDate = null;
        int iWeekStartDay = sysParams.getSOPWeekReqDay();
        iWeekStartDay = iWeekStartDay + 2 > 7 ? iWeekStartDay + 2 - 7 : iWeekStartDay + 2;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            stmt = conn.createStatement();
            while (rs.next()) {
                sFID = rs.getString("FID");
                iPeriod = this.getSOPPeriodIndexOf(periods, rs.getString("FPeriod"));
                java.util.Date dateBegin = periods[iPeriod].getBeginDate().getTime();
                java.util.Date dateEnd = periods[iPeriod].getEndDate().getTime();
                if (editMode.equals((Object)SOPEditModeEnum.MONTHLY)) {
                    if (dateEnd.getMonth() == dateBegin.getMonth()) {
                        calDateTmp.setTime(dateEnd);
                        calDate.set(1, calDateTmp.get(1));
                        calDate.set(2, calDateTmp.get(2));
                        calDate.set(5, sysParams.getSOPMonthReqDay());
                        calDate = this.checkCalendarMaxDatOfMonth(calDate, calDateTmp);
                    } else if (sysParams.getSOPMonthReqDay() >= dateBegin.getDate()) {
                        calDateTmp.setTime(dateBegin);
                        calDate.set(1, calDateTmp.get(1));
                        calDate.set(2, calDateTmp.get(2));
                        calDate.set(5, sysParams.getSOPMonthReqDay());
                        calDate = this.checkCalendarMaxDatOfMonth(calDate, calDateTmp);
                    } else if (sysParams.getSOPMonthReqDay() < dateBegin.getDate()) {
                        calDateTmp.setTime(dateEnd);
                        calDate.set(1, calDateTmp.get(1));
                        calDate.set(2, calDateTmp.get(2));
                        calDate.set(5, sysParams.getSOPMonthReqDay());
                        calDate = this.checkCalendarMaxDatOfMonth(calDate, calDateTmp);
                    }
                } else {
                    calDateTmp.setTime(dateBegin);
                    calDate.set(1, calDateTmp.get(1));
                    calDate.set(2, calDateTmp.get(2));
                    calDate.set(5, calDateTmp.get(5));
                    if (iWeekStartDay >= calDate.get(7)) {
                        calDate.add(6, iWeekStartDay - calDate.get(7));
                    } else {
                        calDate.add(6, 7 - calDate.get(7) + iWeekStartDay);
                    }
                }
                dateTmp = calDate.getTime();
                sDate = sdf.format(dateTmp);
                sql = "update " + sqlTableName + " set FDate=to_date('" + sDate + "') where FID='" + sFID + "'";
                stmt.addBatch(sql);
                if (++iTrans <= 100) continue;
                stmt.executeBatch();
                iTrans = 0;
            }
            if (iTrans > 0) {
                stmt.executeBatch();
            }
        }
        catch (SQLException er) {
            try {
                throw new SQLDataException(er);
            }
            catch (Throwable throwable) {
                com.kingdee.util.db.SQLUtils.cleanup(stmt, (Connection)conn);
                throw throwable;
            }
        }
        com.kingdee.util.db.SQLUtils.cleanup((Statement)stmt, (Connection)conn);
        this.processTempTableUnit(ctx, sqlTableName);
    }

    private Calendar checkCalendarMaxDatOfMonth(Calendar calDate, Calendar calDateTmp) {
        if (calDateTmp.get(2) != calDate.get(2)) {
            calDateTmp.set(1, calDate.get(1));
            calDateTmp.set(2, calDate.get(2));
            calDateTmp.set(5, 1);
            calDateTmp.add(6, -1);
            calDate.set(1, calDateTmp.get(1));
            calDate.set(2, calDateTmp.get(2));
            calDate.set(5, calDateTmp.get(5));
        }
        return calDate;
    }

    @Override
    protected Map _saveSopPlan(Context ctx, Object[] data) throws BOSException, EASBizException {
        PreparedStatement ustmt;
        PreparedStatement istmt;
        Connection conn;
        block15: {
            String planVersionId = (String)data[0];
            String storageOrgId = (String)data[1];
            SOPEditModeEnum editMode = (SOPEditModeEnum)((Object)data[2]);
            String[] mat = (String[])data[3];
            int[] precision = (int[])data[4];
            SOPPeriod[] range = (SOPPeriod[])data[5];
            Map matId2Bop = (Map)data[6];
            conn = null;
            istmt = null;
            ustmt = null;
            String sopPlanBostype = new SopPlanInfo().getBOSType().toString();
            String materialId = new String();
            String storageId = new String();
            StringBuffer isql = new StringBuffer();
            isql.append("INSERT INTO T_MM_SOPPLAN \n").append("(FID,FEditMode,FSalesQty,FProdTheoryQty,FProductionQty,FTargetInvQty,FYear,FPeriod,FPeriodNumber,FParentId,FBaseSalesQty,FBaseProdTheoryQty,FBaseProductionQty,FBaseTargetInvQty) \n").append("VALUES(NEWBOSID('").append(sopPlanBostype).append("'),").append(editMode.getValue()).append(",").append("?,?,?,?,?,?,?,?,?,?,?,?);");
            StringBuffer usql = new StringBuffer();
            usql.append("UPDATE T_MM_SOPPLAN ").append("SET FSalesQty = ?, FProdTheoryQty = ?, FProductionQty = ?, FTargetInvQty = ?,\n").append(" FBaseSalesQty = ?, FBaseProdTheoryQty = ?, FBaseProductionQty = ?, FBaseTargetInvQty = ? \n").append(" WHERE FParentId in ").append("   ( SELECT FID FROM T_MM_SOPBILL \n").append(" WHERE FPlanVersionId = ? \n").append(" AND FStorageOrgUnitId = ? \n").append(" AND FMaterialId = ?  and FSupplyStorageOrgUnitID = ?) \n").append("  AND FPeriodNumber = ? and feditmode = ? ; \n");
            try {
                conn = EJBFactory.getConnection((Context)ctx);
                String sql_t = isql.toString();
                String sql_t2 = usql.toString();
                istmt = conn.prepareStatement(sql_t);
                ustmt = conn.prepareStatement(sql_t2);
                IRowSet rs = (IRowSet)data[7];
                Map rateMap1 = (Map)data[8];
                this.rateMap.putAll(rateMap1);
                Map precisionMap1 = (Map)data[9];
                this.precisionMap.putAll(precisionMap1);
                Map storageMatIds = (Map)data[10];
                SopPlanAlgorithm helper = new SopPlanAlgorithm(this, ctx, conn, range, editMode);
                helper.setStorageOrgUnitId(storageOrgId);
                helper.setPlanVersionId(planVersionId);
                helper.setRateMap(this.rateMap);
                helper.setPrecisionMap(this.precisionMap);
                helper.init();
                if (rs == null) {
                    for (Map.Entry entry : matId2Bop.entrySet()) {
                        String matId = (String)entry.getKey();
                        storageId = (String)storageMatIds.get(matId + "storage");
                        materialId = (String)storageMatIds.get(matId + "material");
                        BigDecimal bop = (BigDecimal)entry.getValue();
                        if (bop == null) {
                            bop = new BigDecimal(0.0);
                        }
                        helper.updateSopBillAndGetBillId(storageId, materialId, bop, false);
                        this.rateMap.putAll(helper.getRateMap());
                        this.precisionMap.putAll(helper.getPrecisionMap());
                    }
                    break block15;
                }
                helper.addTargetInv2Map(mat, rs, storageMatIds, false);
                rs.beforeFirst();
                BigDecimal baseSales = new BigDecimal("0.0");
                BigDecimal baseProdTheory = new BigDecimal("0.0");
                BigDecimal baseProd = new BigDecimal("0.0");
                BigDecimal baseTargetInv = new BigDecimal("0.0");
                while (rs.next()) {
                    int isInsert = rs.getInt(8);
                    BigDecimal sales = rs.getBigDecimal(4);
                    BigDecimal prodTheory = rs.getBigDecimal(5);
                    BigDecimal prod = rs.getBigDecimal(6);
                    BigDecimal targetInv = rs.getBigDecimal(7);
                    int year = rs.getInt(2);
                    int month = rs.getInt(3);
                    int matIdx = rs.getInt(1);
                    BigDecimal bop = (BigDecimal)matId2Bop.get(mat[matIdx]);
                    storageId = (String)storageMatIds.get(mat[matIdx] + "storage");
                    materialId = (String)storageMatIds.get(mat[matIdx] + "material");
                    if (bop == null && matId2Bop.keySet().contains(mat[matIdx])) {
                        bop = new BigDecimal(0.0);
                    }
                    String billId = helper.updateSopBillAndGetBillId(storageId, materialId, bop);
                    this.rateMap.putAll(helper.getRateMap());
                    this.precisionMap.putAll(helper.getPrecisionMap());
                    int addPrecision = (Integer)this.precisionMap.get(billId);
                    baseSales = sales.multiply((BigDecimal)this.rateMap.get(billId)).setScale(addPrecision, 4);
                    baseProdTheory = prodTheory.multiply((BigDecimal)this.rateMap.get(billId)).setScale(addPrecision, 4);
                    baseProd = prod.multiply((BigDecimal)this.rateMap.get(billId)).setScale(addPrecision, 4);
                    baseTargetInv = targetInv.multiply((BigDecimal)this.rateMap.get(billId)).setScale(addPrecision, 4);
                    if (baseSales.compareTo(new BigDecimal("10000000000000")) > 0) {
                        throw new SOPException(SOPException.VALUE_TOO_LARGE, new String[]{this.getResource("SALES")});
                    }
                    if (baseProdTheory.compareTo(new BigDecimal("10000000000000")) > 0) {
                        throw new SOPException(SOPException.VALUE_TOO_LARGE, new String[]{this.getResource("PRODTHOERY")});
                    }
                    if (baseProd.compareTo(new BigDecimal("10000000000000")) > 0) {
                        throw new SOPException(SOPException.VALUE_TOO_LARGE, new String[]{this.getResource("PROD")});
                    }
                    if (baseTargetInv.compareTo(new BigDecimal("10000000000000")) > 0) {
                        throw new SOPException(SOPException.VALUE_TOO_LARGE, new String[]{this.getResource("TARGETINV")});
                    }
                    if (isInsert == 0) {
                        istmt.setBigDecimal(1, sales);
                        istmt.setBigDecimal(2, prodTheory);
                        istmt.setBigDecimal(3, prod);
                        istmt.setBigDecimal(4, targetInv);
                        istmt.setInt(5, year);
                        istmt.setInt(6, month);
                        istmt.setInt(7, year * 100 + month);
                        istmt.setString(8, billId);
                        istmt.setBigDecimal(9, baseSales);
                        istmt.setBigDecimal(10, baseProdTheory);
                        istmt.setBigDecimal(11, baseProd);
                        istmt.setBigDecimal(12, baseTargetInv);
                        istmt.addBatch();
                    } else {
                        ustmt.setBigDecimal(1, sales);
                        ustmt.setBigDecimal(2, prodTheory);
                        ustmt.setBigDecimal(3, prod);
                        ustmt.setBigDecimal(4, targetInv);
                        ustmt.setBigDecimal(5, baseSales);
                        ustmt.setBigDecimal(6, baseProdTheory);
                        ustmt.setBigDecimal(7, baseProd);
                        ustmt.setBigDecimal(8, baseTargetInv);
                        ustmt.setString(9, planVersionId);
                        ustmt.setString(10, storageOrgId);
                        ustmt.setString(11, materialId);
                        ustmt.setString(12, storageId);
                        ustmt.setInt(13, year * 100 + month);
                        ustmt.setInt(14, editMode.getValue());
                        ustmt.addBatch();
                    }
                    helper.syncOnePeriodPlan(year * 100 + month, storageId, materialId, billId, precision[matIdx], sales, prodTheory, prod, targetInv);
                }
                istmt.executeBatch();
                ustmt.executeBatch();
                helper.executeBatch();
            }
            catch (SQLException e) {
                try {
                    throw new SQLDataException(e);
                }
                catch (Throwable throwable) {
                    com.kingdee.util.db.SQLUtils.cleanup(ustmt, null);
                    com.kingdee.util.db.SQLUtils.cleanup(istmt, (Connection)conn);
                    throw throwable;
                }
            }
        }
        com.kingdee.util.db.SQLUtils.cleanup((Statement)ustmt, null);
        com.kingdee.util.db.SQLUtils.cleanup((Statement)istmt, (Connection)conn);
        HashMap<String, Map> map = new HashMap<String, Map>();
        map.put("rate", this.rateMap);
        map.put("precision", this.precisionMap);
        return map;
    }

    private String getSOPTransferTempTableName(Context ctx) throws BOSException {
        String sqlTableName = "";
        String sql = " CREATE TABLE T_SOP_TransferData(FID VARCHAR(44),FStorageOrgUnitID varchar(44),FSupplyStorageID varchar(44),FStatus int default 0,FMaterialID VARCHAR(44),FPlanType INTEGER,FDate DATETIME,FPeriod VARCHAR(44),FQty NUMERIC(21,8) default 0,FUnitID VARCHAR(44),FQtyPrecision INTEGER default 1,FBaseQty NUMERIC(21,8) default 0,FBaseUnitID VARCHAR(44),FBaseQtyPrecision INTEGER default 1,FPeriodStartDate DATETIME,FPeriodEndDate DATETIME)";
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        try {
            sqlTableName = pool.createTempTable(sql);
        }
        catch (Exception e1) {
            throw new BOSException((Throwable)e1);
        }
        return sqlTableName;
    }

    @Override
    protected void _saveDataForTransfer(Context ctx, Map map) throws BOSException, EASBizException {
        this.savePlan2InterfaceTable(ctx, map);
    }

    protected void savePlan2InterfaceTable(Context ctx, Map map) throws BOSException, EASBizException {
        Map data = (Map)map.get("materials");
        Map period2Day = (Map)map.get("periodFrom");
        Boolean deleteDataB4 = (Boolean)map.get("DeleteB4Data");
        String storageOrgUnitId = (String)map.get("org");
        SOPPlannedTypeEnum planType = (SOPPlannedTypeEnum)((Object)map.get("PlanType"));
        java.util.Date beginDate = (java.util.Date)map.get("yearFrom");
        java.util.Date endDate = (java.util.Date)map.get("yearTo");
        Map period = (Map)map.get("periodParam");
        BOSObjectType sopBosObjectType = new BOSObjectType("259EA739");
        IObjectPK pk = LogUtil.beginLog((Context)ctx, (String)"1", (BOSObjectType)sopBosObjectType, null, (String)ResourceBase.getString((String)RESOURCE, (String)"SOPPLANTRANSFER_LOG", (Locale)ctx.getLocale()), (String)"mm_sop_plan_transfer");
        SOPEditModeEnum editMode = (SOPEditModeEnum)((Object)map.get("sopeditmode"));
        StringBuffer sql = new StringBuffer(400);
        String sqlSubTableName = this.getSOPTransferTempTableName(ctx);
        DbUtil.execute((Context)ctx, (String)("delete from " + sqlSubTableName));
        sql.append(" INSERT INTO ").append(sqlSubTableName).append(" (FID,FStorageOrgUnitID,FStatus,FMaterialID,FPlanType,FDate,FPeriod,FQty, \r\n").append(" FUnitID,FQtyPrecision,FBaseQty,FBaseUnitID,FBaseQtyPrecision,FPeriodStartDate,FPeriodEndDate,FSupplyStorageID) \r\n").append(" VALUES \r\n").append(" (?,'").append(storageOrgUnitId).append("',1,").append(" ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?)");
        Connection conn = null;
        PreparedStatement istmt = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            String sql_t = sql.toString();
            istmt = conn.prepareStatement(sql_t);
            Calendar dateStart = null;
            Calendar dateEnd = null;
            String supplyStorageID = "";
            String id = "";
            Map tmp = null;
            for (Map.Entry entry : data.entrySet()) {
                MatInfo mat = (MatInfo)entry.getKey();
                List matPlans = (List)entry.getValue();
                supplyStorageID = mat.getSupplyStorageID();
                for (Object[] periodPlan : matPlans) {
                    tmp = (Map)period2Day.get(supplyStorageID);
                    if (null == tmp) continue;
                    List days = (List)tmp.get(periodPlan[0]);
                    BigDecimal[] dayPlans = (BigDecimal[])periodPlan[1];
                    Map test = (Map)period.get(supplyStorageID);
                    if (null == test) continue;
                    List periodDays = (List)test.get(periodPlan[0]);
                    if (periodDays.size() > 0) {
                        dateStart = (Calendar)periodDays.get(0);
                        dateEnd = (Calendar)periodDays.get(periodDays.size() - 1);
                    }
                    for (int i = 0; i < dayPlans.length; ++i) {
                        id = BOSUuid.create((String)"C3651DB1").toString();
                        istmt.setString(1, id);
                        istmt.setString(2, mat.getMatId());
                        istmt.setInt(3, planType.getValue());
                        Calendar date = (Calendar)days.get(i);
                        istmt.setDate(4, new Date(date.getTimeInMillis()));
                        istmt.setString(5, (String)periodPlan[0]);
                        istmt.setBigDecimal(6, dayPlans[i].divide(mat.getBaseConvsRate(), mat.getPlanUnitPrecision(), 2));
                        istmt.setString(7, mat.getPlanUnitId());
                        istmt.setInt(8, mat.getPlanUnitPrecision());
                        istmt.setBigDecimal(9, dayPlans[i]);
                        istmt.setString(10, mat.getBaseUnitId());
                        istmt.setInt(11, mat.getBaseUnitPrecision());
                        istmt.setDate(12, new Date(dateStart.getTimeInMillis()));
                        istmt.setDate(13, new Date(dateEnd.getTimeInMillis()));
                        istmt.setString(14, supplyStorageID);
                        istmt.addBatch();
                    }
                }
            }
            istmt.executeBatch();
            StringBuffer insertLogSql = new StringBuffer();
            insertLogSql.append("insert into T_MM_SopPlanTranferLog(fid,FPeriod,FReqDate,FQty,FBaseQty,FTransferDate,FStorageOrgUnitID,");
            insertLogSql.append("FBaseUnitID,FUnitID,FTransferUserID,FPlanType,FEditMode,FMaterialID,fcontrolunitid,FSupplyStorageOrgUnitID) ");
            insertLogSql.append("select newbosid('5D66ED44'),FPeriod,FDate,FQty,FBaseQty,to_date('");
            insertLogSql.append(SCMServerUtils.getCurrentDateTime());
            insertLogSql.append("'),FStorageOrgUnitID,FBaseUnitID,FUnitID,'");
            insertLogSql.append(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString());
            insertLogSql.append("',FPlanType,");
            insertLogSql.append(editMode.getValue());
            insertLogSql.append(",FMaterialID ,'");
            insertLogSql.append(ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString());
            insertLogSql.append("',FSupplyStorageID  from ");
            insertLogSql.append(sqlSubTableName);
            SQLUtils.execute((Context)ctx, (String)insertLogSql.toString());
            ReqPlanSOPFacadeFactory.getLocalInstance(ctx).requireFromSOP(storageOrgUnitId, sqlSubTableName, beginDate, endDate, deleteDataB4);
        }
        catch (SQLException ex1) {
            try {
                throw new SOPException(SOPException.TRANSFER_ERR_DATA_LONG);
            }
            catch (Throwable throwable) {
                com.kingdee.util.db.SQLUtils.cleanup(istmt, (Connection)conn);
                throw throwable;
            }
        }
        com.kingdee.util.db.SQLUtils.cleanup((Statement)istmt, (Connection)conn);
        LogUtil.afterLog((Context)ctx, (IObjectPK)pk);
    }

    protected void oldSaveDataForTransferImp(Context ctx, Map map) throws BOSException, EASBizException {
        Map idList = (Map)map.get("idlist");
        Map matList = (Map)map.get("matList");
        Map paramMap = (Map)map.get("param");
        String sqlTableName = (String)paramMap.get("sqlTableName");
        String storageOrgUnitID = (String)paramMap.get("StorageOrgUnitID");
        String sMaterialID = null;
        int k = 0;
        BOSObjectType sopBosObjectType = new BOSObjectType("259EA739");
        IObjectPK pk = LogUtil.beginLog((Context)ctx, (String)"1", (BOSObjectType)sopBosObjectType, null, (String)matList.values().toString(), (String)"mm_sop_plan_transfer");
        String sql = "update " + sqlTableName + " as t0 set FStatus=1 where FStorageOrgUnitID='" + storageOrgUnitID + "' and FMaterialID=?";
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            stmt = conn.prepareStatement(sql);
            Iterator it = idList.keySet().iterator();
            while (it.hasNext()) {
                sMaterialID = (String)idList.get((String)it.next());
                stmt.setString(1, sMaterialID);
                stmt.addBatch();
                if (++k < 100) continue;
                stmt.executeBatch();
                k = 0;
            }
            if (k > 0) {
                stmt.executeBatch();
            }
        }
        catch (SQLException ex) {
            try {
                throw new SOPException(SOPException.SAVE_ERR_EXCEPTION);
            }
            catch (Throwable throwable) {
                com.kingdee.util.db.SQLUtils.cleanup(stmt, (Connection)conn);
                throw throwable;
            }
        }
        com.kingdee.util.db.SQLUtils.cleanup((Statement)stmt, (Connection)conn);
        java.util.Date beginDate = (java.util.Date)paramMap.get("beginDate");
        java.util.Date endDate = (java.util.Date)paramMap.get("endDate");
        k = Integer.parseInt((String)paramMap.get("delRequireBefore"));
        boolean chkDelete = k == 32;
        try {
            String sqlSubTableName = this.getSOPTransferTempTableName(ctx);
            DbUtil.execute((Context)ctx, (String)("delete from " + sqlSubTableName));
            String sql2 = "Insert Into " + sqlSubTableName + "(FID,FStorageOrgUnitID,FStatus,FMaterialID,FPlanType,FDate,FPeriod,FQty, \r\n FUnitID,FQtyPrecision,FBaseQty,FBaseUnitID,FBaseQtyPrecision) \r\n select FID,FStorageOrgUnitID,FStatus,FMaterialID,FPlanType,FDate,FPeriod,FQty, \r\n FUnitID,FQtyPrecision,FBaseQty,FBaseUnitID,FBaseQtyPrecision \r\n from " + sqlTableName + " \r\n where FStatus=1 and FStorageOrgUnitID='" + storageOrgUnitID + "'";
            DbUtil.execute((Context)ctx, (String)sql2);
            ReqPlanSOPFacadeFactory.getLocalInstance(ctx).requireFromSOP(storageOrgUnitID, sqlSubTableName, beginDate, endDate, chkDelete);
            String sql3 = "delete from " + sqlTableName + " where FStorageOrgUnitID='" + storageOrgUnitID + "' and FStatus=1";
            DbUtil.execute((Context)ctx, (String)sql3);
        }
        catch (SOPException ex1) {
            throw new SOPException(SOPException.TRANSFER_ERR_EXCEPTION);
        }
        LogUtil.afterLog((Context)ctx, (IObjectPK)pk);
    }

    @Override
    protected boolean _deleteSopPlan(Context ctx, Map params) throws BOSException, EASBizException {
        Set matIdSet = (Set)params.get("materials");
        String storageOrgUnitId = (String)params.get("org");
        String planVersionId = (String)params.get("planVersion");
        SOPPlannedTypeEnum planType = (SOPPlannedTypeEnum)((Object)params.get("PlanType"));
        Map storageMatIds = (Map)params.get("matStorageIds");
        StringBuffer matId = new StringBuffer();
        int i = 0;
        for (String matStorageIds : matIdSet) {
            String storageId = (String)storageMatIds.get(matStorageIds + "storage");
            String materialId = (String)storageMatIds.get(matStorageIds + "material");
            if (i != matIdSet.size() - 1) {
                matId.append("( FMaterialId='" + materialId + "' and FSupplyStorageOrgUnitID='" + storageId + "') or");
            } else {
                matId.append("( FMaterialId='" + materialId + "' and FSupplyStorageOrgUnitID='" + storageId + "')");
            }
            ++i;
        }
        if (matId.length() > 0) {
            StringBuffer sql = new StringBuffer();
            StringBuffer predicates = new StringBuffer();
            predicates.append(" WHERE FParentId in ").append("( SELECT FID FROM T_MM_SOPBILL \n").append(" WHERE FPlanVersionId = '").append(planVersionId).append("' \n").append("      AND FStorageOrgUnitId = '").append(storageOrgUnitId).append("' \n").append("      AND ( ").append(matId.toString()).append(")); \n");
            switch (planType.getValue()) {
                case 1: {
                    sql.append("UPDATE T_MM_SOPPLAN \n").append(" SET FSalesQty = 0 \n").append(predicates);
                    DbUtil.execute((Context)ctx, (String)sql.toString());
                    sql = new StringBuffer();
                    sql.append("UPDATE T_MM_SOPDAYPLAN \n").append(" SET FSalesQty = 0 \n").append(predicates);
                    DbUtil.execute((Context)ctx, (String)sql.toString());
                    break;
                }
                case 2: {
                    sql.append("UPDATE T_MM_SOPPLAN \n").append(" SET FProductionQty = 0, FTargetInvQty = 0 \n").append(predicates);
                    DbUtil.execute((Context)ctx, (String)sql.toString());
                    sql = new StringBuffer();
                    sql.append("UPDATE T_MM_SOPDAYPLAN \n").append(" SET FProductionQty = 0, FTargetInvQty = 0 \n").append(predicates);
                    DbUtil.execute((Context)ctx, (String)sql.toString());
                    break;
                }
                case 3: {
                    sql.append("DELETE FROM T_MM_SOPPLAN \n").append(predicates);
                    DbUtil.execute((Context)ctx, (String)sql.toString());
                    sql = new StringBuffer();
                    sql.append("DELETE FROM T_MM_SOPDayPLAN \n").append(predicates);
                    DbUtil.execute((Context)ctx, (String)sql.toString());
                    sql = new StringBuffer();
                    sql.append("DELETE FROM T_MM_SOPBILL \n").append("   WHERE FPlanVersionId = '").append(planVersionId).append("' \n").append("      AND FStorageOrgUnitId = '").append(storageOrgUnitId).append("' \n").append("      AND (").append(matId.toString()).append("); \n");
                    DbUtil.execute((Context)ctx, (String)sql.toString());
                }
            }
        }
        return true;
    }

    @Override
    protected IRowSet _getSopSalesPlan(Context ctx, Map params) throws BOSException, EASBizException {
        Set matIdSet = (Set)params.get("materials");
        Map storageMatIds = (Map)params.get("matStorageIds");
        ArrayList<String> matIdList = new ArrayList<String>();
        String storageOrgUnitId = (String)params.get("org");
        String planVersionId = (String)params.get("planVersion");
        Integer periodNumber = (Integer)params.get("periodFrom");
        SOPEditModeEnum editMode = (SOPEditModeEnum)((Object)params.get("sopeditmode"));
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT b.FSupplyStorageOrgUnitID||b.FMaterialId FMatId, p.FSalesQty \n").append(" FROM T_MM_SOPPlan p, T_MM_SopBill b \n").append(" WHERE b.FId = p.FParentId \n").append("   AND b.FStorageOrgUnitId = ? \n").append("   AND b.FPlanVersionId = ? \n").append("   AND p.FEditMode = ? ").append("   AND p.FPeriodNumber = ? ").append("   AND ( ");
        Iterator it = matIdSet.iterator();
        while (it.hasNext()) {
            matIdList.add((String)it.next());
        }
        for (int i = 0; i < matIdList.size(); ++i) {
            String ids = (String)matIdList.get(i);
            String storageId = (String)storageMatIds.get(ids + "storage");
            String materialId = (String)storageMatIds.get(ids + "material");
            sql.append(" ( b.FSupplyStorageOrgUnitID ='" + storageId + "' and  b.FMaterialId='" + materialId + "')");
            if (i != matIdList.size() - 1) {
                sql.append("or");
                continue;
            }
            sql.append(")");
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{storageOrgUnitId, planVersionId, new Integer(editMode.getValue()), periodNumber});
        return rs;
    }

    @Override
    protected void _releaseTransferTempTable(Context ctx, String tempTableName) throws BOSException, EASBizException {
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        pool.releaseTable(tempTableName);
    }

    @Override
    protected IRowSet _getHighLowTargetInv(Context ctx, Map params) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        List matIdList = (List)params.get("materials");
        Map storageMatIds = (Map)params.get("matStorageIds");
        StringBuffer materialParam = new StringBuffer();
        for (int i = 0; i < matIdList.size(); ++i) {
            String ids = (String)matIdList.get(i);
            String storageId = (String)storageMatIds.get(ids + "storage");
            String materialId = (String)storageMatIds.get(ids + "material");
            materialParam.append(" ( mi.FOrgUnit ='" + storageId + "' and  mi.FMaterialId='" + materialId + "')");
            if (i != matIdList.size() - 1) {
                materialParam.append("or");
                continue;
            }
            materialParam.append(")");
        }
        sql.append(" SELECT distinct mi.FOrgUnit||m.FID FMaterialId,mi.FQtyMin,mi.FQtyMax,m.FNumber FMatNumber \n").append(" FROM T_BD_Material m \n").append(" INNER JOIN t_bd_materialInventory mi on m.FID = mi.FMaterialId \n").append(" AND mi.FStatus = 1 and (\n").append(materialParam).append("  WHERE m.FStatus = 1 \n");
        sql.append(" ORDER BY m.FNumber asc;");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        return rs;
    }

    @Override
    protected Map _getSOPPlanBill(Context ctx, Map params) throws BOSException, EASBizException {
        try {
            String storageOrgUnitID = (String)params.get("org");
            String sopVerID = (String)params.get("planVersion");
            StringBuffer sqlSB = new StringBuffer();
            sqlSB.setLength(0);
            String clr = "\r\n";
            ArrayList<String> paramLst = new ArrayList<String>();
            HashMap<String, String> sopPlanBillMap = new HashMap<String, String>();
            sqlSB.append(" SELECT FID,FSupplyStorageOrgUnitID||FMaterialID as matStorageIds from T_MM_SopBill").append(clr).append(" WHERE FStorageOrgUnitId = ? ").append(clr).append("   AND FPlanVersionId = ? ").append(clr);
            paramLst.clear();
            paramLst.add(storageOrgUnitID);
            paramLst.add(sopVerID);
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlSB.toString(), (Object[])paramLst.toArray());
            while (rs.next()) {
                sopPlanBillMap.put(rs.getString("FID"), rs.getString("matStorageIds"));
            }
            HashMap<String, String> hashMap = sopPlanBillMap;
            return hashMap;
        }
        catch (SQLException sqlExp) {
            throw new SQLDataException(sqlExp);
        }
    }

    @Override
    protected List _getSOPPlanBillIDList(Context ctx, Map params) throws BOSException, EASBizException {
        ArrayList<String> billIDList;
        block7: {
            String storageOrgUnitID = (String)params.get("org");
            String sopVerID = (String)params.get("planVersion");
            List materialLst = (List)params.get("materials");
            Map storageMatIds = (Map)params.get("matStorageIds");
            billIDList = new ArrayList<String>();
            if (materialLst.size() <= 0) break block7;
            StringBuffer sqlSB = new StringBuffer();
            sqlSB.setLength(0);
            String clr = "\r\n";
            StringBuffer materialParam = new StringBuffer();
            ArrayList<String> paramLst = new ArrayList<String>();
            for (int i = 0; i < materialLst.size(); ++i) {
                String ids = (String)materialLst.get(i);
                String storageId = (String)storageMatIds.get(ids + "storage");
                String materialId = (String)storageMatIds.get(ids + "material");
                materialParam.append("( FSupplyStorageOrgUnitID='" + storageId + "' and FMaterialId='" + materialId + "')");
                if (i >= materialLst.size() - 1) continue;
                materialParam.append("or");
            }
            sqlSB.append(" SELECT FID from T_MM_SopBill").append(clr).append(" WHERE FStorageOrgUnitId = ? ").append(clr).append("   AND FPlanVersionId = ? ").append(clr).append("   AND (").append(materialParam).append(clr).append(") ").append(clr);
            paramLst.clear();
            paramLst.add(storageOrgUnitID);
            paramLst.add(sopVerID);
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlSB.toString(), (Object[])paramLst.toArray());
            while (rs.next()) {
                billIDList.add(rs.getString("FID"));
            }
            ArrayList<String> arrayList = billIDList;
            return arrayList;
        }
        try {
            ArrayList<String> arrayList = billIDList;
            return arrayList;
        }
        catch (SQLException sqlExp) {
            throw new SQLDataException(sqlExp);
        }
    }

    @Override
    protected Map _getSOPPlanBillIDAndMatIDList(Context ctx, Map params) throws BOSException, EASBizException {
        HashMap<String, Cloneable> sopPlanBillMap;
        block7: {
            String ids;
            String storageOrgUnitID = (String)params.get("org");
            String sopVerID = (String)params.get("planVersion");
            List materialLst = (List)params.get("materials");
            Map storageMatIds = (Map)params.get("matStorageIds");
            ArrayList<String> billIDList = new ArrayList<String>();
            sopPlanBillMap = new HashMap<String, Cloneable>();
            if (materialLst.size() <= 0) break block7;
            StringBuffer sqlSB = new StringBuffer();
            sqlSB.setLength(0);
            String clr = "\r\n";
            StringBuffer materialParam = new StringBuffer();
            ArrayList<String> paramLst = new ArrayList<String>();
            HashMap<String, String> sopPlanMap = new HashMap<String, String>();
            for (int i = 0; i < materialLst.size(); ++i) {
                ids = (String)materialLst.get(i);
                String storageId = (String)storageMatIds.get(ids + "storage");
                String materialId = (String)storageMatIds.get(ids + "material");
                materialParam.append("( FSupplyStorageOrgUnitID='" + storageId + "' and FMaterialId='" + materialId + "')");
                if (i >= materialLst.size() - 1) continue;
                materialParam.append("or");
            }
            sqlSB.append(" SELECT FID,FSupplyStorageOrgUnitID,FMaterialId from T_MM_SopBill").append(clr).append(" WHERE FStorageOrgUnitId = ? ").append(clr).append("   AND FPlanVersionId = ? ").append(clr).append("   AND (").append(materialParam).append(clr).append(") ").append(clr);
            paramLst.clear();
            paramLst.add(storageOrgUnitID);
            paramLst.add(sopVerID);
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlSB.toString(), (Object[])paramLst.toArray());
            while (rs.next()) {
                ids = rs.getString("FID");
                billIDList.add(ids);
                sopPlanMap.put(ids + "storage", rs.getString("FSupplyStorageOrgUnitID"));
                sopPlanMap.put(ids + "material", rs.getString("FMaterialId"));
            }
            sopPlanBillMap.put("sopIds", billIDList);
            sopPlanBillMap.put("sopIdToMatId", sopPlanMap);
            HashMap<String, Cloneable> hashMap = sopPlanBillMap;
            return hashMap;
        }
        try {
            HashMap<String, Cloneable> hashMap = sopPlanBillMap;
            return hashMap;
        }
        catch (SQLException sqlExp) {
            throw new SQLDataException(sqlExp);
        }
    }

    @Override
    protected String _buildIDs(Context ctx, Collection cols) throws BOSException, EASBizException {
        StringBuffer ids = new StringBuffer();
        Iterator it = cols.iterator();
        String tempID = null;
        ids.append("(");
        int i = 0;
        while (it.hasNext()) {
            tempID = it.next().toString();
            if (i == cols.size() - 1) {
                ids.append("'" + tempID + "'");
            } else {
                ids.append("'" + tempID + "',");
            }
            ++i;
        }
        ids.append(")");
        return ids.toString();
    }

    @Override
    protected Map _getSopData(Context ctx, IObjectValue storageInfo, SOPPeriod[] periods, Set materialNums, IObjectValue verison) throws BOSException, EASBizException {
        StorageOrgUnitInfo storageOrg = (StorageOrgUnitInfo)storageInfo;
        SOPPlanVersionInfo versionInfo = (SOPPlanVersionInfo)verison;
        StringBuffer buffer = new StringBuffer();
        String startPeriods = null;
        String endPeriods = null;
        HashMap<String, BigDecimal[]> rsMap = new HashMap<String, BigDecimal[]>();
        SOPEditModeEnum type = null;
        if (materialNums.size() > 0) {
            if (periods != null) {
                type = periods[0].getType();
                startPeriods = Integer.toString(periods[0].toNumber());
                endPeriods = Integer.toString(periods[periods.length - 1].toNumber());
            }
            buffer.append("select m.fnumber AS MATERIALNUMBER,p.FPeriodNumber, \n ");
            buffer.append("sum(FProductionQty) AS QTY \n");
            buffer.append("from T_MM_SOPPlan p, T_BD_Material m ,T_MM_SopBill b \n");
            buffer.append(" WHERE b.FMaterialId = m.FID \n");
            buffer.append(" AND m.fnumber in " + this._buildIDs(ctx, materialNums) + " \n");
            buffer.append(" AND b.FId = p.FParentId  \n");
            buffer.append(" AND b.FStorageOrgUnitId = '" + storageOrg.getId() + "'  \n");
            buffer.append(" AND b.FPlanVersionId = '" + versionInfo.getId() + "'  \n");
            buffer.append(" AND p.FEditMode = " + new Integer(type.getValue()) + "  \n");
            buffer.append(" AND p.FPeriodNumber >= " + new Integer(startPeriods) + " \n");
            buffer.append(" AND p.FPeriodNumber <= " + new Integer(endPeriods) + "");
            buffer.append(" group by m.fnumber,p.FPeriodNumber");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)buffer.toString());
            try {
                block2: while (rs.next()) {
                    String key = rs.getString("MATERIALNUMBER");
                    BigDecimal qty = rs.getBigDecimal("QTY");
                    int periodNum = rs.getInt("FPeriodNumber");
                    BigDecimal[] qtys = null;
                    if (rsMap.containsKey(key)) {
                        qtys = (BigDecimal[])rsMap.get(key);
                    } else {
                        qtys = new BigDecimal[periods.length];
                        rsMap.put(key, qtys);
                    }
                    int n = periods.length;
                    for (int i = 0; i < n; ++i) {
                        if (periodNum != periods[i].toNumber()) continue;
                        qtys[i] = qty;
                        continue block2;
                    }
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        return rsMap;
    }

    @Override
    protected ArrayList _getMatStorageIds(Context ctx, ArrayList billId) throws BOSException {
        StringBuffer sql = new StringBuffer("");
        ArrayList<String> list = new ArrayList<String>();
        sql.append(" select FSupplyStorageOrgUnitID,FMaterialID from t_mm_sopbill where fid in (");
        Iterator iterator = billId.iterator();
        while (iterator.hasNext()) {
            sql.append("'");
            sql.append(iterator.next().toString());
            sql.append("'");
            sql.append(",");
        }
        sql.deleteCharAt(sql.length() - 1);
        sql.append(")");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rowSet.next()) {
                list.add(rowSet.getString("FSupplyStorageOrgUnitID") + rowSet.getString("FMaterialID"));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return list;
    }

    @Override
    protected ArrayList _getFilterInventory(Context ctx, List list) throws BOSException {
        ArrayList<String> objectList = new ArrayList<String>();
        StringBuffer sql = new StringBuffer();
        sql.append(" select m.fid storageMatIds from t_bd_material m  INNER JOIN t_bd_materialInventory mi on m.FID = mi.FMaterialId AND mi.FStatus = 1 ");
        sql.append(" AND mi.FOrgUnit in ").append(SopPlanAlgorithm.getInPredicateFromList(list)).append(" INNER JOIN T_BD_MaterialPlan mp on m.FID = mp.FMaterialId ").append(" AND mp.FOrgUnit in").append(SopPlanAlgorithm.getInPredicateFromList(list)).append(" AND (mp.FMaterialAttr = 10030 or ").append(" mp.FMaterialAttr = 10040 or ").append(" mp.FMaterialAttr = 10050) ").append(" AND mp.FStatus = 1 ").append(" INNER JOIN T_BD_MultiMeasureUnit mu on mp.FProductunitid = mu.FMeasureUnitId ").append(" and mp.FMaterialId = mu.FMaterialId ").append(" INNER JOIN T_BD_MeasureUnit u on mu.FMeasureUnitId = u.FId ");
        sql.append(" where m.fstatus=1 ");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rowSet.next()) {
                objectList.add(rowSet.getString("storageMatIds"));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return objectList;
    }

    @Override
    protected HashMap _getInventory(Context ctx, List paramValue, ArrayList matList, Map storageMatIds, String storageOrgUnitId) throws BOSException {
        int i;
        if (matList == null || matList.size() < 1 || matList.size() == 1 && matList.get(0).toString().length() < 1) {
            return null;
        }
        ArrayList<String> materialList = new ArrayList<String>();
        ArrayList<String> storageList = new ArrayList<String>();
        ArrayList orgCol = new ArrayList();
        ArrayList companyOrg = new ArrayList();
        Object cou = null;
        int removeIndex = 0;
        HashMap<String, BigDecimal> hashMap = new HashMap<String, BigDecimal>();
        for (i = 0; i < matList.size(); ++i) {
            String tempId = (String)matList.get(i);
            hashMap.put(tempId, null);
        }
        for (i = 0; i < matList.size(); ++i) {
            removeIndex = storageList.size();
            String ids = (String)matList.get(i);
            String storageId = (String)storageMatIds.get(ids + "storage");
            String materialId = (String)storageMatIds.get(ids + "material");
            storageList.add(storageId);
            materialList.add(materialId);
        }
        if (materialList.size() == 0) {
            return hashMap;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" select  inventory.fstorageorgunitid as ftorageid, inventory.fmaterialid as fmaterialid,sum( inventory.fbaseqty) as fbaseqty , ").append(" mu.fqtyPrecision as qtyPrecision ,mu.FBaseConvsRate as rate ").append("  from t_im_inventory  inventory ").append(" inner join  T_BD_MaterialPlan mp on mp.fmaterialid=inventory.fmaterialid and ").append("  mp.forgunit='" + storageOrgUnitId + "'").append(" inner join  t_bd_multimeasureunit mu on inventory.fmaterialid= mu.fmaterialid  and  mp.FProductunitid =mu.FMeasureUnitId").append(" inner join  t_im_storestate storestate on  inventory.fstorestatusid  = storestate.fid ").append("  inner join  t_im_storetype storetype  on  inventory.fstoretypeid = storetype.fid ").append(" and  storestate.fnumber in ").append(SopPlanAlgorithm.getInPredicateFromList(paramValue)).append(" and (storetype.fnumber='G' or storetype.fnumber='S'   or storetype.fnumber='R') and (");
        for (int i2 = 0; i2 < materialList.size(); ++i2) {
            if (i2 != materialList.size() - 1) {
                sql.append(" ( inventory.fstorageorgunitid='" + storageList.get(i2).toString() + "' and inventory.fmaterialid = '" + materialList.get(i2).toString() + "' ) or");
                continue;
            }
            sql.append(" ( inventory.fstorageorgunitid='" + storageList.get(i2).toString() + "' and inventory.fmaterialid = '" + materialList.get(i2).toString() + "' ) ");
        }
        sql.append(" )");
        sql.append(" group by inventory.fstorageorgunitid,inventory.fmaterialid ,mu.fqtyPrecision ,mu.FBaseConvsRate  ");
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            stmt = conn.createStatement();
            String sql_t = sql.toString();
            rs = stmt.executeQuery(sql_t);
            String materialTempId = null;
            String storageid = null;
            String materialid = null;
            int precision = 0;
            BigDecimal qty = new BigDecimal("0.0");
            while (rs.next()) {
                materialid = rs.getString("fmaterialid");
                storageid = rs.getString("ftorageid");
                BigDecimal baseQty = rs.getBigDecimal("fbaseqty");
                BigDecimal rate = rs.getBigDecimal("rate");
                precision = rs.getInt("qtyPrecision");
                qty = baseQty.divide(rate, precision, 4);
                materialTempId = storageid + materialid;
                hashMap.put(materialTempId, qty);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                com.kingdee.util.db.SQLUtils.cleanup(rs, (Statement)stmt, (Connection)conn);
                throw throwable;
            }
        }
        com.kingdee.util.db.SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return hashMap;
    }

    @Override
    protected HashMap _getPrePeroidInventoryBalance(Context ctx, List paramValue, ArrayList matList, Map storageMatIds, String storageOrgUnitId) throws BOSException {
        String storageid;
        int i;
        if (matList == null || matList.size() < 1 || matList.size() == 1 && matList.get(0).toString().length() < 1) {
            return null;
        }
        StringBuffer sql = new StringBuffer("");
        ArrayList<String> materialList = new ArrayList<String>();
        ArrayList<String> storageList = new ArrayList<String>();
        ArrayList<OrgUnitCollection> col = new ArrayList<OrgUnitCollection>();
        ArrayList<CompanyOrgUnitInfo> companyOrg = new ArrayList<CompanyOrgUnitInfo>();
        ArrayList<PeriodInfo> prePeriodList = new ArrayList<PeriodInfo>();
        CompanyOrgUnitInfo cou = null;
        PeriodInfo currentPeriodInfo = null;
        PeriodInfo prePeriodInfo = null;
        int removeIndex = 0;
        HashMap<String, BigDecimal> hashMap = new HashMap<String, BigDecimal>();
        for (int i2 = 0; i2 < matList.size(); ++i2) {
            String tempId = (String)matList.get(i2);
            hashMap.put(tempId, null);
        }
        IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        for (i = 0; i < matList.size(); ++i) {
            removeIndex = storageList.size();
            String ids = (String)matList.get(i);
            storageid = (String)storageMatIds.get(ids + "storage");
            String materialId = (String)storageMatIds.get(ids + "material");
            storageList.add(storageid);
            materialList.add(materialId);
            try {
                col.add(iUnitRel.getToUnit(storageid, 4, 1));
            }
            catch (EASBizException e) {
                throw new BOSException((Throwable)e);
            }
            if ((OrgUnitCollection)col.get(removeIndex) == null || ((OrgUnitCollection)col.get(removeIndex)).size() < 1) {
                storageList.remove(removeIndex);
                materialList.remove(removeIndex);
                col.remove(removeIndex);
                continue;
            }
            cou = (CompanyOrgUnitInfo)((OrgUnitCollection)col.get(removeIndex)).get(0);
            if (cou == null) {
                storageList.remove(removeIndex);
                materialList.remove(removeIndex);
                col.remove(removeIndex);
                continue;
            }
            companyOrg.add(cou);
            try {
                currentPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)cou);
            }
            catch (EASBizException e) {
                throw new BOSException((Throwable)e);
            }
            if (currentPeriodInfo == null) {
                storageList.remove(removeIndex);
                materialList.remove(removeIndex);
                col.remove(removeIndex);
                companyOrg.remove(removeIndex);
                continue;
            }
            try {
                prePeriodInfo = PeriodUtils.getPrePeriodInfo((Context)ctx, (PeriodInfo)currentPeriodInfo);
            }
            catch (EASBizException e) {
                throw new BOSException((Throwable)e);
            }
            if (prePeriodInfo == null) {
                storageList.remove(removeIndex);
                materialList.remove(removeIndex);
                col.remove(removeIndex);
                companyOrg.remove(removeIndex);
                continue;
            }
            prePeriodList.add(prePeriodInfo);
        }
        if (materialList.size() == 0) {
            return hashMap;
        }
        sql.append(" select balance.fstorageorgunitid as ftorageid,balance.fmaterialid as fmaterialid,sum(balance.fperiodendqty) as fperiodendqty, ").append(" mu.FBaseConvsRate as rate,mu.fqtyPrecision as  qtyPrecision ").append(" from t_im_inventorybalance balance ").append(" inner join  T_BD_MaterialPlan mp on mp.fmaterialid= balance.fmaterialid and ").append("  mp.forgunit='" + storageOrgUnitId + "'").append(" inner join  t_im_storestate storestate on balance.fstorestatusid = storestate.fid ").append(" inner join  t_bd_multimeasureunit mu on balance.fmaterialid= mu.fmaterialid and  mp.FProductunitid =mu.FMeasureUnitId ").append(" where  balance.fstorestatusid = storestate.fid  and  ").append(" storestate.fnumber in ").append(SopPlanAlgorithm.getInPredicateFromList(paramValue)).append(" and ( ");
        for (i = 0; i < materialList.size(); ++i) {
            sql.append(" ( balance.fstorageorgunitid='" + storageList.get(i).toString() + "' and balance.fmaterialid = '" + materialList.get(i).toString() + "'");
            sql.append("and balance.fyear = " + ((PeriodInfo)prePeriodList.get(i)).getPeriodYear() + " and balance.fperiod = " + ((PeriodInfo)prePeriodList.get(i)).getPeriodNumber());
            sql.append(" and balance.fcompanyorgunitid = '" + ((CompanyOrgUnitInfo)companyOrg.get(i)).getId().toString() + "') ");
            if (i != materialList.size() - 1) {
                sql.append(" or ");
                continue;
            }
            sql.append(" ) ");
        }
        sql.append(" group by balance.fstorageorgunitid,balance.fmaterialid , mu.FBaseConvsRate,mu.fqtyPrecision ");
        IRowSet rs = null;
        try {
            rs = SQLUtils.executeQuery((Context)ctx, (String)sql.toString());
            String materialTempId = null;
            storageid = null;
            String materialid = null;
            int precision = 0;
            BigDecimal qty = new BigDecimal("0.0");
            while (rs.next()) {
                materialid = rs.getString("fmaterialid");
                storageid = rs.getString("ftorageid");
                BigDecimal baseQty = rs.getBigDecimal("fperiodendqty");
                BigDecimal rate = rs.getBigDecimal("rate");
                precision = rs.getInt("qtyPrecision");
                qty = baseQty.divide(rate, precision, 4);
                materialTempId = storageid + materialid;
                hashMap.put(materialTempId, qty);
            }
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        return hashMap;
    }

    @Override
    protected List _getSopParamValue(Context ctx) throws BOSException {
        StringBuffer sql = new StringBuffer("");
        ArrayList<String> list = new ArrayList<String>();
        sql.append("select * from t_mm_sopparamvalue");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        list.add(String.valueOf(1));
        try {
            if (rs.next()) {
                if (rs.getInt("Frozen") == 1) {
                    list.add(String.valueOf(301));
                }
                if (rs.getInt("FReceivingUninSpected") == 1) {
                    list.add(String.valueOf(201));
                }
                if (rs.getInt("FDeliveryUninSpected") == 1) {
                    list.add(String.valueOf(203));
                }
                if (rs.getInt("FStockUninSpected") == 1) {
                    list.add(String.valueOf(202));
                }
            }
            return list;
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    @Override
    protected Map _getSOPSysParams(Context ctx, Map storageIds) throws BOSException, EASBizException {
        HashMap<String, SOPSysParams> resultMap = new HashMap<String, SOPSysParams>();
        Object[] ids = storageIds.keySet().toArray();
        if (ids.length < 1) {
            return null;
        }
        SOPSysParams sysParams = new SOPSysParams();
        String storageOrgUnitID = null;
        int size = ids.length;
        for (int i = 0; i < size; ++i) {
            storageOrgUnitID = ids[i].toString();
            sysParams = this.getSOPSysParams(ctx, storageOrgUnitID);
            resultMap.put(storageOrgUnitID, sysParams);
        }
        return resultMap;
    }

    public static String getResource(String path, Context ctx, String strKey) {
        String strTemp = ResourceBase.getString((String)path, (String)strKey, (Locale)ctx.getLocale());
        return strTemp;
    }

    public static String getFormatResource(Context ctx, String path, String strKey, Object[] parameter) {
        return MessageFormat.format(SOPFacadeControllerBean.getResource(path, ctx, strKey), parameter);
    }

    @Override
    protected Map _checkSOPTransParam(Context ctx, Map storageIdAndNames) throws BOSException, EASBizException {
        String resourcePath = RESOURCE;
        HashMap<String, Object> result = new HashMap<String, Object>();
        boolean isPass = true;
        if (null != storageIdAndNames && storageIdAndNames.keySet().size() > 0) {
            Object[] ids = storageIdAndNames.keySet().toArray();
            StringBuffer info = new StringBuffer();
            RequirementPlanInfo reqInfo = new RequirementPlanInfo();
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            String orgId = "";
            for (int i = 0; i < ids.length; ++i) {
                orgId = (String)ids[i];
                if (!iCodingRuleManager.isExist((IObjectValue)reqInfo, orgId)) {
                    info.append(SOPFacadeControllerBean.getFormatResource(ctx, resourcePath, "REQUIREMENT_PLAN_CODE_RULE_UNDEFINED_DETAIL", new String[]{(String)storageIdAndNames.get(orgId)})).append("\r\n");
                    isPass = false;
                    continue;
                }
                try {
                    iCodingRuleManager.getBatchNumber((IObjectValue)reqInfo, orgId, 1);
                    continue;
                }
                catch (Exception e) {
                    isPass = false;
                    info.append(SOPFacadeControllerBean.getFormatResource(ctx, resourcePath, "REQUIREMENT_PLAN_CODE_RULE_ERROR", new String[]{(String)storageIdAndNames.get(orgId)})).append("\r\n");
                }
            }
            result.put("ISPASS", isPass);
            result.put("INFO", info.toString());
            return result;
        }
        return null;
    }

    @Override
    protected IRowSet _getRatePrecision(Context ctx, Map map) throws BOSException {
        String orgId = (String)map.get("org");
        String planVerId = (String)map.get("planVersion");
        String matFrom = (String)map.get("matFrom");
        String matTo = (String)map.get("matTo");
        StringBuffer sql = new StringBuffer("");
        sql.append(" select s.fid billId,round(mu.FBaseConvsRate/mu2.FBaseConvsRate,8) rate,mu2.fqtyPrecision qtyPrecision FROM T_BD_Material m ");
        sql.append("  INNER JOIN t_bd_materialInventory mi on m.FID = mi.FMaterialId AND mi.FStatus =1  AND mi.FOrgUnit =?");
        sql.append("  INNER JOIN T_BD_MaterialPlan mp on m.FID = mp.FMaterialId  AND mp.FOrgUnit =?");
        sql.append("  AND  mp.FStatus = 1 ");
        sql.append(" INNER  JOIN T_MM_SOPBill s on m.FID = s.FMaterialId and s.FStorageOrgUnitId =? and s.fplanversionid=? ");
        sql.append(" INNER JOIN T_BD_MultiMeasureUnit mu on s.FAssistUnitID= mu.FMeasureUnitId and mp.FMaterialId = mu.FMaterialId ");
        sql.append(" INNER JOIN T_BD_MeasureUnit u on mu.FMeasureUnitId = u.FId ");
        sql.append(" inner join T_BD_MultiMeasureUnit mu2 on  s.FBaseUnitID = mu2.FMeasureUnitId and mp.FMaterialId = mu2.FMaterialId");
        sql.append(" inner JOIN  T_ORG_Storage storage on  s.FSupplyStorageOrgUnitID=storage.fid ");
        sql.append(" inner join T_BD_MeasureUnit u2 on u2.fid=s.fbaseunitid ");
        sql.append(" where  m.FStatus = 1 ");
        if (matFrom != null && matTo != null) {
            sql.append("   AND m.FNumber>='").append(matFrom).append("' \n");
            sql.append("   AND m.FNumber<='").append(matTo).append("' \n");
        } else if (matFrom != null) {
            sql.append("   AND m.FNumber>='").append(matFrom).append("' \n");
        } else if (matTo != null) {
            sql.append("   AND m.FNumber<='").append(matTo).append("' \n");
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{orgId, orgId, orgId, planVerId});
        return rs;
    }

    @Override
    protected BigDecimal _convertBopRate(Context ctx, String storageOrgUnit, String materialId, String SupplyStorageOrgUnit, String planversion) throws BOSException {
        StringBuffer sql = new StringBuffer();
        BigDecimal rate = new BigDecimal("0.0");
        sql.append("SELECT sb.FID fid,round(mu.FBaseConvsRate,8) rate,u2.fqtyPrecision qtyPrecision FROM T_MM_SOPBILL sb ");
        sql.append(" inner join t_bd_material m on sb.fmaterialid=m.fid ");
        sql.append(" inner join T_BD_MaterialPlan mp on mp.FMaterialId=m.fid and mp.forgunit=sb.FStorageOrgUnitId ");
        sql.append(" inner join T_BD_MultiMeasureUnit mu on  sb.FAssistUnitID = mu.FMeasureUnitId and mp.FMaterialId = mu.FMaterialId ");
        sql.append(" inner join T_BD_MeasureUnit u on mu.FMeasureUnitId = u.FId ");
        sql.append(" inner join T_BD_MeasureUnit u2 on u2.fid=sb.FBaseUnitID ");
        sql.append(" WHERE sb.FPlanVersionId = ? AND sb.FStorageOrgUnitId = ? AND sb.FMaterialId =?  and sb.FSupplyStorageOrgUnitID = ?");
        IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{planversion, storageOrgUnit, materialId, SupplyStorageOrgUnit});
        if (row.size() == 0) {
            sql.setLength(0);
            sql.append(" select round(mu.FBaseConvsRate,8) rate from  t_bd_material m ").append(" inner join t_bd_materialplan mp on mp.fmaterialid=m.fid").append(" inner join t_bd_multimeasureunit mu on mu.fmaterialid=m.fid").append(" and mp.FProductunitid =mu.FMeasureUnitId ").append(" inner join t_bd_measureUnit u on mu.FMeasureUnitId = u.FId ").append(" where m.fid=? and mp.forgunit=? ");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{materialId, storageOrgUnit});
            try {
                while (rowSet.next()) {
                    rate = rowSet.getBigDecimal("rate");
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        try {
            while (row.next()) {
                rate = row.getBigDecimal("rate");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return rate;
    }

    @Override
    protected Map _convertMap(Context ctx, Set keySet, Map map) throws BOSException {
        StringBuffer sql = new StringBuffer();
        ArrayList<String> list = new ArrayList<String>();
        HashMap rateMap = new HashMap();
        HashMap precisionMap = new HashMap();
        Map passRateMap = (Map)map.get("rate");
        Map passPrecisionMap = (Map)map.get("precision");
        HashMap preRateMap = new HashMap();
        Iterator it = keySet.iterator();
        while (it.hasNext()) {
            list.add((String)it.next());
        }
        if (list.size() == 0) {
            preRateMap.put("rate", rateMap);
            preRateMap.put("precision", precisionMap);
            return preRateMap;
        }
        sql.append(" select FSupplyStorageOrgUnitID||FMaterialID FMatStorageIds,fid from t_mm_sopbill where fid in ").append(SopPlanAlgorithm.getInPredicateFromList(list));
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rowSet.next()) {
                String matStorageIds = rowSet.getString("FMatStorageIds");
                String billId = rowSet.getString("fid");
                rateMap.put(matStorageIds, passRateMap.get(billId));
                precisionMap.put(matStorageIds, passPrecisionMap.get(billId));
            }
            preRateMap.put("rate", rateMap);
            preRateMap.put("precision", precisionMap);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return preRateMap;
    }

    @Override
    protected Map _getBopRate(Context ctx, String storageOrg, String matStorageIds) throws BOSException {
        HashMap map = new HashMap();
        StringBuffer sql = new StringBuffer();
        sql.append(" select mu.FBaseConvsRate rate,u2.fqtyPrecision qtyPrecision from  t_bd_material m ").append(" inner join t_bd_materialplan mp on mp.fmaterialid=m.fid").append(" inner join t_bd_multimeasureunit mu on mu.fmaterialid=m.fid").append(" and mp.FProductunitid =mu.FMeasureUnitId ").append(" inner join t_bd_measureUnit u on mu.FMeasureUnitId = u.FId ").append(" inner join T_BD_MeasureUnit u2 on u2.fid=m.FBaseUnit").append(" where m.fid=? and mp.forgunit=? ");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{matStorageIds, storageOrg});
        try {
            while (rowSet.next()) {
                HashMap<String, BigDecimal> rateMap = new HashMap<String, BigDecimal>();
                HashMap<String, Integer> precisionMap = new HashMap<String, Integer>();
                String rate = rowSet.getString("rate");
                String qtyPrecision = rowSet.getString("qtyPrecision");
                rateMap.put(storageOrg + matStorageIds, new BigDecimal(rate));
                precisionMap.put(storageOrg + matStorageIds, new Integer(qtyPrecision));
                map.put("rate", rateMap);
                map.put("qtyPrecision", precisionMap);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return map;
    }

    private String getResource(String sKey) {
        return EASResource.getString((String)RESOURCE, (String)sKey);
    }

    @Override
    protected String _getAIS(Context ctx) throws BOSException {
        String ais = ctx.getAIS();
        return ais;
    }
}

