/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.mm.planning.ISOPPlanVersion;
import com.kingdee.eas.mm.planning.SOPPlanVersionException;
import com.kingdee.eas.mm.planning.SOPPlanVersionFactory;
import com.kingdee.eas.mm.planning.SOPPlanVersionInfo;
import com.kingdee.eas.mm.planning.app.AbstractSOPPlanVersionControllerBean;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class SOPPlanVersionControllerBean
extends AbstractSOPPlanVersionControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.planning.app.SOPPlanVersionControllerBean");
    private static final String defaultVersionId = "MhhE36S+Qcy2gimEuZuUj5eYTjA=";

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        SOPPlanVersionInfo info = (SOPPlanVersionInfo)model;
        BOSUuid id = BOSUuid.create((BOSObjectType)info.getBOSType());
        info.setId(id);
        info.setCU(this.getCU(ctx, info));
        Connection con = null;
        StringBuffer sql = new StringBuffer("");
        sql.append("SELECT COUNT(*) FROM T_MM_SOPPlanVersion WHERE FNUMBER=?");
        PreparedStatement statement = null;
        try {
            con = this.getConnection(ctx);
            statement = con.prepareStatement(sql.toString());
            statement.setString(1, info.getNumber());
            ResultSet rs = statement.executeQuery();
            if (rs.next() && rs.getInt(1) == 1) {
                throw new SOPPlanVersionException(SOPPlanVersionException.CANT_SAME_VERSION);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(statement, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)statement, (Connection)con);
        return super._addnew(ctx, model);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (pk.toString().equals(defaultVersionId)) {
            throw new SOPPlanVersionException(SOPPlanVersionException.CANT_DELETE);
        }
        Connection con = null;
        StringBuffer sql = new StringBuffer("");
        sql.append("SELECT COUNT(*) FROM T_MM_SOPBILL WHERE FPlanVersionID=?");
        PreparedStatement statement = null;
        try {
            con = this.getConnection(ctx);
            statement = con.prepareStatement(sql.toString());
            statement.setString(1, pk.toString());
            ResultSet rs = statement.executeQuery();
            if (rs.next() && rs.getInt(1) > 0) {
                throw new SOPPlanVersionException(SOPPlanVersionException.IS_INUSE);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(statement, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)statement, (Connection)con);
        ISOPPlanVersion sopPlanVersion = SOPPlanVersionFactory.getLocalInstance(ctx);
        SOPPlanVersionInfo info = sopPlanVersion.getSOPPlanVersionInfo(pk);
        IObjectPK pkLog = LogUtil.beginLog((Context)ctx, (String)"1", (BOSObjectType)info.getBOSType(), (IObjectPK)pk, (String)info.getNumber(), (String)"mm_sop_planversion_delete");
        super._delete(ctx, pk);
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkLog);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        SOPPlanVersionInfo info = (SOPPlanVersionInfo)model;
        IObjectPK pkLog = LogUtil.beginLog((Context)ctx, (String)"1", (BOSObjectType)info.getBOSType(), (IObjectPK)pk, (String)info.getNumber(), (String)"mm_sop_planversion_update");
        super._update(ctx, pk, model);
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkLog);
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        CoreBillBaseInfo info = (CoreBillBaseInfo)super._getValue(ctx, pk);
        return info.getNumber();
    }
}

