/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mm.planning.ISOPFacade;
import com.kingdee.eas.mm.planning.SOPEditModeEnum;
import com.kingdee.eas.mm.planning.SOPFacadeFactory;
import com.kingdee.eas.mm.planning.SOPPeriod;
import com.kingdee.eas.mm.planning.SOPPlanVersionCollection;
import com.kingdee.eas.mm.planning.SOPPlanVersionFactory;
import com.kingdee.eas.mm.planning.SOPSysParams;
import com.kingdee.eas.mm.planning.SopBillInfo;
import com.kingdee.eas.mm.planning.SopPlanInfo;
import com.kingdee.eas.mm.planning.app.SopPlanAlgorithm;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.DIETemplateCollection;
import com.kingdee.eas.tools.datatask.DIETemplateFactory;
import com.kingdee.eas.tools.datatask.DIETemplateInfo;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;

public class SopPlanTransformer
extends AbstractDataTransmission {
    public static final String strResource = "com.kingdee.eas.mm.planning.SOPResource.";
    private ISOPFacade sopFacade = null;
    private Map SOPParams = new HashMap();
    private Map planVersions = new HashMap();
    private Map rateMap = new HashMap();
    private Map precisionMap = new HashMap();
    int precision = 0;
    BigDecimal rate = new BigDecimal(0.0);
    String baseUnit = new String();
    String productUnit = null;
    SopPlanAlgorithm sopPlanHelper = null;
    private FullOrgUnitCollection storageUnits4Sales = null;
    private FullOrgUnitCollection storageUnits4Prod = null;
    private static final String IMPORT_SALES_PERMISSION = "mm_sopsaleplan_import";
    private static final String IMPORT_PROD_PERMISSION = "mm_sopprodplan_import";
    private static final String STORAGE_NUMBER = "storageOrgUnit.number";
    private static final String PLAN_VERSION = "planVersion.number";
    private static final String PLAN_TYPE = "planType";
    private static final String BEGIN_PERIOD = "beginPeriod";
    private static final String NUM_OF_PERIOD = "numberOfPeriod";
    private static final String MATERIAL_NUMBER = "material.number";
    private static final String UNIT_NUMBER = "unit.number";
    private static final String EDIT_MODE = "editMode";
    private static final String BOP_VALUE = "openingInventory";
    private static final String SUPPLYORGUNIT_NUMBER = "supplyOrgUnit.number";
    private static final int PTM_SALES = 1;
    private static final int PTM_PROD_THEORY = 2;
    private static final int PTM_PROD_AMENDED = 4;
    private static final int PTM_TARGET_INV = 8;
    private static final int PTM_BOP = 16;
    private BigDecimal ZERO = new BigDecimal("0");

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        return null;
    }

    public int getSubmitType() {
        return 0;
    }

    public boolean isSameBlock(Hashtable firstData, Hashtable currentData) {
        return firstData != null && currentData != null && firstData.get(STORAGE_NUMBER).equals(currentData.get(STORAGE_NUMBER)) && firstData.get(PLAN_VERSION).equals(currentData.get(PLAN_VERSION)) && firstData.get(MATERIAL_NUMBER).equals(currentData.get(MATERIAL_NUMBER));
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        super.submit(coreBaseInfo, ctx);
    }

    private String getFieldValue(Context ctx, Hashtable hsData, String fieldName, String excepDesc) throws TaskExternalException {
        String fieldValue;
        DataToken data = (DataToken)hsData.get(fieldName);
        String string = fieldValue = data == null ? "" : (String)data.data;
        if (excepDesc != null) {
            this.assertTrue(ctx, fieldValue != null, excepDesc, fieldName);
        }
        return fieldValue;
    }

    private String getFieldValue(Context ctx, Hashtable hsData, String fieldName) throws TaskExternalException {
        return this.getFieldValue(ctx, hsData, fieldName, null);
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        String storageNumber = this.getFieldValue(ctx, hsData, STORAGE_NUMBER);
        int planType = this.getPlanType(ctx, hsData);
        String storageOrgUnitId = this.verifyPermission(ctx, storageNumber, planType);
        SOPEditModeEnum editMode = this.getEditModeByNumber(ctx, this.getFieldValue(ctx, hsData, EDIT_MODE));
        String planVersionId = this.getPlanVersionByNumber(ctx, this.getFieldValue(ctx, hsData, PLAN_VERSION));
        int periodHorizon = this.getPeriodHorizon(ctx, storageOrgUnitId, editMode);
        int numOfPeriod = this.getIntValue(ctx, this.getFieldValue(ctx, hsData, NUM_OF_PERIOD), 1, 36, "INVALID_NUM_OF_PERIOD");
        numOfPeriod = numOfPeriod <= periodHorizon ? numOfPeriod : periodHorizon;
        SOPPeriod curPeriod = null;
        SOPPeriod[] periods = null;
        String supplyOrgUnit = null;
        try {
            curPeriod = this.sopFacade.getCurrentPeriod(editMode, storageOrgUnitId);
            periods = curPeriod.forwardPeriods(periodHorizon);
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage());
        }
        periods = this.getPeriodRange(ctx, this.getFieldValue(ctx, hsData, BEGIN_PERIOD), periods, numOfPeriod);
        try {
            try {
                supplyOrgUnit = this.getSupplyOrgUnitByNumber(ctx, this.getFieldValue(ctx, hsData, SUPPLYORGUNIT_NUMBER));
            }
            catch (EASBizException e) {
                throw new TaskExternalException(e.getMessage(), e.getCause());
            }
        }
        catch (BOSException e1) {
            throw new TaskExternalException(e1.getMessage(), e1.getCause());
        }
        catch (SQLException e1) {
            throw new TaskExternalException(e1.getMessage(), e1.getCause());
        }
        String material = this.getFieldValue(ctx, hsData, MATERIAL_NUMBER);
        Object[] materialInfo = null;
        try {
            materialInfo = this.getMaterialByNumber(ctx, storageOrgUnitId, material, supplyOrgUnit, planVersionId);
        }
        catch (BOSException e2) {
            throw new TaskExternalException(e2.getMessage(), e2.getCause());
        }
        String unitNumber = this.getFieldValue(ctx, hsData, UNIT_NUMBER);
        Map map = null;
        try {
            map = this.getMeasureUnitCoefficient(ctx, unitNumber, material, storageOrgUnitId);
        }
        catch (BOSException e1) {
            throw new TaskExternalException(e1.getMessage(), e1.getCause());
        }
        catch (SQLException e1) {
            throw new TaskExternalException(e1.getMessage(), e1.getCause());
        }
        this.rate = (BigDecimal)materialInfo[1];
        this.precision = (Integer)materialInfo[2];
        this.baseUnit = (String)materialInfo[4];
        this.productUnit = (String)materialInfo[5];
        if (16 == planType) {
            BigDecimal bop = this.getBopData(ctx, hsData, this.precision, this.rate, map);
            this.InsertSopPlanBop(ctx, bop, (String)materialInfo[0], storageOrgUnitId, supplyOrgUnit, planVersionId, this.rate, this.precision, this.baseUnit, this.productUnit);
            return null;
        }
        BigDecimal[][] dataImported = this.getImportedData(ctx, hsData, periods.length, this.precision, this.rate, map, planType);
        IRowSet rs = this.getSopPlan(ctx, storageOrgUnitId, planVersionId, supplyOrgUnit, (String)materialInfo[0], editMode, periods[0].toNumber(), periods[periods.length - 1].toNumber());
        this.updateWithValueInDB(planType, rs, dataImported, periods);
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            ISOPFacade sop = SOPFacadeFactory.getLocalInstance(ctx);
            this.sopPlanHelper = new SopPlanAlgorithm(sop, ctx, conn, periods, editMode);
            if (!(storageOrgUnitId.equals(this.sopPlanHelper.getStorageOrgUnitId()) && planVersionId.equals(this.sopPlanHelper.getPlanVersionId()) && editMode.equals((Object)this.sopPlanHelper.getEditMode()))) {
                this.sopPlanHelper.setStorageOrgUnitId(storageOrgUnitId);
                this.sopPlanHelper.setPlanVersionId(planVersionId);
                this.sopPlanHelper.setEditMode(editMode);
                this.sopPlanHelper.setConn(conn);
                this.sopPlanHelper.init();
            } else {
                this.sopPlanHelper.setConn(conn);
            }
            this.InsertSopPlan(ctx, editMode, dataImported, supplyOrgUnit, (String)materialInfo[0], periods, this.rate, this.precision);
            ArrayList<String> mat = new ArrayList<String>();
            HashMap<String, Object> storageMatIds = new HashMap<String, Object>();
            String ids = supplyOrgUnit + materialInfo[0];
            mat.add(ids);
            storageMatIds.put(ids + "storage", supplyOrgUnit);
            storageMatIds.put(ids + "material", materialInfo[0]);
            this.sopPlanHelper.syncSopPlan(mat, storageMatIds);
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage());
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return null;
    }

    private void InsertSopPlan(Context ctx, SOPEditModeEnum editMode, BigDecimal[][] data, String supplyOrgUnit, String materialId, SOPPeriod[] periods, BigDecimal rate, int qtyPrecision) throws TaskExternalException {
        String sopPlanBosType = new SopPlanInfo().getBOSType().toString();
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO T_MM_SOPPLAN \n").append("(FID,FEditMode,FSalesQty,FProdTheoryQty,FProductionQty,FTargetInvQty,FYear,FPeriod,FPeriodNumber,FParentId,FBaseSalesQty,FBaseProdTheoryQty,FBaseProductionQty,FBaseTargetInvQty) \n").append("VALUES(NEWBOSID('").append(sopPlanBosType).append("'),").append(editMode.getValue()).append(",").append("?,?,?,?,?,?,?,?,?,?,?,?);");
        Connection conn = this.sopPlanHelper.getConn();
        PreparedStatement istmt = null;
        try {
            this.sopPlanHelper.DeleteSopPlan(supplyOrgUnit, materialId, periods[0].toNumber(), periods[periods.length - 1].toNumber(), editMode);
            String sql_t = sql.toString();
            istmt = conn.prepareStatement(sql_t);
            String billId = this.sopPlanHelper.updateSopBillAndGetBillId(supplyOrgUnit, materialId, null);
            this.rateMap.put(billId, rate);
            this.precisionMap.put(billId, new Integer(qtyPrecision));
            this.rateMap.putAll(this.sopPlanHelper.getRateMap());
            this.precisionMap.putAll(this.sopPlanHelper.getPrecisionMap());
            this.sopPlanHelper.setRateMap(this.rateMap);
            this.sopPlanHelper.setPrecisionMap(this.precisionMap);
            for (int i = 0; i < periods.length; ++i) {
                istmt.setBigDecimal(1, data[0][i] == null ? this.ZERO : data[0][i]);
                istmt.setBigDecimal(2, data[1][i] == null ? this.ZERO : data[1][i]);
                istmt.setBigDecimal(3, data[2][i] == null ? this.ZERO : data[2][i]);
                istmt.setBigDecimal(4, data[3][i] == null ? this.ZERO : data[3][i]);
                istmt.setInt(5, periods[i].getYear());
                istmt.setInt(6, periods[i].getNumber());
                istmt.setInt(7, periods[i].toNumber());
                istmt.setString(8, billId);
                istmt.setBigDecimal(9, data[0][i] == null ? this.ZERO : data[0][i].multiply(rate).setScale(qtyPrecision, 4));
                istmt.setBigDecimal(10, data[1][i] == null ? this.ZERO : data[1][i].multiply(rate).setScale(qtyPrecision, 4));
                istmt.setBigDecimal(11, data[2][i] == null ? this.ZERO : data[2][i].multiply(rate).setScale(qtyPrecision, 4));
                istmt.setBigDecimal(12, data[3][i] == null ? this.ZERO : data[3][i].multiply(rate).setScale(qtyPrecision, 4));
                istmt.addBatch();
            }
            istmt.executeBatch();
        }
        catch (Exception e) {
            try {
                throw new TaskExternalException(e.getMessage());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(istmt, null);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)istmt, null);
    }

    private BigDecimal getNumericValue(Context ctx, Hashtable hsData, String key, String msg) throws TaskExternalException {
        String qty = this.getFieldValue(ctx, hsData, key);
        if ("".equals(qty)) {
            qty = "0";
        }
        BigDecimal data = null;
        try {
            double number = Double.valueOf(qty);
            data = qty == null || qty.trim().length() == 0 ? this.ZERO : new BigDecimal(qty);
        }
        catch (Exception e) {
            this.assertTrue(ctx, false, "INVALID_NUMERIC", msg);
        }
        if (data.compareTo(new BigDecimal("10000000000000")) >= 0) {
            this.assertTrue(ctx, false, "VALUE_TOO_LARGE", msg);
        }
        return data;
    }

    private BigDecimal[][] getImportedData(Context ctx, Hashtable hsData, int numOfPeriod, int precision, BigDecimal planUnit2Default, Map importUnit2Default, int planType) throws TaskExternalException {
        int rows = hsData.size();
        BigDecimal[][] data = new BigDecimal[4][numOfPeriod];
        BigDecimal importRate = (BigDecimal)importUnit2Default.get("rate");
        int importPrecision = (Integer)importUnit2Default.get("precision");
        int i = 0;
        switch (planType) {
            case 1: {
                i = 0;
                break;
            }
            case 2: {
                i = 1;
                break;
            }
            case 4: {
                i = 2;
                break;
            }
            case 8: {
                i = 3;
            }
        }
        for (int j = 0; j < numOfPeriod; ++j) {
            BigDecimal qty = this.getNumericValue(ctx, hsData, "" + (j + 1), "" + (j + 1));
            this.assertTrue(ctx, qty.compareTo(this.ZERO) >= 0, "NUMBER_NOT_NEGATIVE", null);
            try {
                if (planUnit2Default.compareTo(importRate) == 0) {
                    data[i][j] = qty;
                    data[i][j] = data[i][j].setScale(importPrecision, 4);
                    continue;
                }
                if (precision > qty.scale()) {
                    qty = qty.setScale(importPrecision);
                }
                data[i][j] = qty.multiply(importRate).divide(planUnit2Default, 4).setScale(precision, 4);
                continue;
            }
            catch (NumberFormatException e) {
                throw new TaskExternalException(e.getMessage());
            }
        }
        return data;
    }

    private int getPlanType(Context ctx, Hashtable hsData) throws TaskExternalException {
        int planType = 0;
        int thisType = this.getIntValue(ctx, this.getFieldValue(ctx, hsData, PLAN_TYPE), 1, 5, "INVALID_PLAN_TYPE");
        this.assertTrue(ctx, ((thisType = 1 << thisType - 1) & planType) != thisType, "INVALID_PLAN_TYPE_DUPLICATION", null);
        return planType |= thisType;
    }

    private int getPeriodHorizon(Context ctx, String storageId, SOPEditModeEnum editMode) throws TaskExternalException {
        int horizon = 0;
        horizon = editMode.equals((Object)SOPEditModeEnum.MONTHLY) ? this.getSopParams(ctx, storageId).getSOPMonthHorizon() : this.getSopParams(ctx, storageId).getSOPWeekHorizon();
        return horizon;
    }

    private SOPEditModeEnum getEditModeByNumber(Context ctx, String number) throws TaskExternalException {
        int value = this.getIntValue(ctx, number, 1, 2, "INVALID_EDIT_MODE");
        SOPEditModeEnum editMode = null;
        switch (value) {
            case 1: {
                editMode = SOPEditModeEnum.MONTHLY;
                break;
            }
            case 2: {
                editMode = SOPEditModeEnum.WEEKLY;
            }
        }
        return editMode;
    }

    private void updateWithValueInDB(int planType, IRowSet dataInDB, BigDecimal[][] dataImported, SOPPeriod[] periods) throws TaskExternalException {
        try {
            dataInDB.beforeFirst();
            while (dataInDB.next()) {
                int period = dataInDB.getInt(1);
                BigDecimal salesQty = dataInDB.getBigDecimal(2);
                BigDecimal prodTheoryQty = dataInDB.getBigDecimal(3);
                BigDecimal prodAmendedQty = dataInDB.getBigDecimal(4);
                BigDecimal TargetInvQty = dataInDB.getBigDecimal(5);
                int index = this.getIndex(period, periods);
                if ((planType & 1) == 0) {
                    BigDecimal bigDecimal = dataImported[0][index] = salesQty == null ? this.ZERO : salesQty;
                }
                if ((planType & 2) == 0) {
                    BigDecimal bigDecimal = dataImported[1][index] = prodTheoryQty == null ? this.ZERO : prodTheoryQty;
                }
                if ((planType & 4) == 0) {
                    BigDecimal bigDecimal = dataImported[2][index] = prodAmendedQty == null ? this.ZERO : prodAmendedQty;
                }
                if ((planType & 8) != 0) continue;
                dataImported[3][index] = TargetInvQty == null ? this.ZERO : TargetInvQty;
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage());
        }
    }

    private int getIndex(int period, SOPPeriod[] periods) {
        int index = -1;
        for (int i = 0; i < periods.length; ++i) {
            int thisPeriod = periods[i].toNumber();
            if (thisPeriod != period) continue;
            index = i;
            break;
        }
        return index;
    }

    private IRowSet getSopPlan(Context ctx, String storageId, String planVerId, String supplyOrgUnit, String matId, SOPEditModeEnum editMode, int beginPeriod, int endPeriod) throws TaskExternalException {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT p.FPeriodNumber, p.FSalesQty, p.FProdTheoryQty, p.FProductionQty, p.FTargetInvQty \n").append(" FROM T_MM_SOPPlan p, T_MM_SopBill b \n").append(" WHERE b.FId = p.FParentId \n").append("   AND b.FStorageOrgUnitId = ? \n").append("   AND b.FSupplyStorageOrgUnitID = ? \n").append("   AND b.FMaterialId = ? \n").append("   AND b.FPlanVersionId = ? \n").append("   AND p.FEditMode = ? \n").append("   AND p.FPeriodNumber >= ? \n").append("   AND p.FPeriodNumber <= ? \n;");
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{storageId, supplyOrgUnit, matId, planVerId, new Integer(editMode.getValue()), new Integer(beginPeriod), new Integer(endPeriod)});
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage());
        }
        return rs;
    }

    private SOPPeriod[] getPeriodRange(Context ctx, String period, SOPPeriod[] periods, int numOfPeriod) throws TaskExternalException {
        int matchedPos = -1;
        SOPPeriod[] periodRange = null;
        for (int i = 0; i < periods.length; ++i) {
            if (matchedPos > -1) {
                if (i - matchedPos >= numOfPeriod) break;
                periodRange[i - matchedPos] = periods[i];
                continue;
            }
            String thisPeriod = periods[i].toString();
            if (!period.equalsIgnoreCase(thisPeriod)) continue;
            matchedPos = i;
            numOfPeriod = Math.min(numOfPeriod, periods.length - matchedPos);
            periodRange = new SOPPeriod[numOfPeriod];
            periodRange[0] = periods[i];
        }
        this.assertTrue(ctx, matchedPos > -1, "INVALID_PERIOD", periods[0].toString() + " ~ " + periods[periods.length - 1].toString());
        return periodRange;
    }

    private int getIntValue(Context ctx, String number, int min, int max, String excepDesc) throws TaskExternalException {
        Integer value = new Integer(-1);
        try {
            value = new Integer(number);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.assertBetween(ctx, value, min, max, excepDesc);
        return value;
    }

    private SOPSysParams getSopParams(Context ctx, String storageId) throws TaskExternalException {
        SOPSysParams sopParam = (SOPSysParams)this.SOPParams.get(storageId);
        if (sopParam == null) {
            try {
                if (this.sopFacade == null) {
                    this.sopFacade = SOPFacadeFactory.getLocalInstance(ctx);
                }
                sopParam = this.sopFacade.getSOPSysParams(storageId);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.assertTrue(ctx, sopParam != null, "NO_PARAM_FOUND", null);
        this.SOPParams.put(storageId, sopParam);
        return sopParam;
    }

    private String verifyPermission(Context ctx, String storageNumber, int planType) throws TaskExternalException {
        boolean isImportSalesPlan = (planType & 1) == 1;
        String storageOrgUnitId = null;
        if (this.storageUnits4Sales == null && isImportSalesPlan) {
            this.storageUnits4Sales = this.getStorageUnitsWithPremission(ctx, IMPORT_SALES_PERMISSION);
        }
        if (this.storageUnits4Prod == null && !isImportSalesPlan) {
            this.storageUnits4Prod = this.getStorageUnitsWithPremission(ctx, IMPORT_PROD_PERMISSION);
        }
        FullOrgUnitCollection storageUnits = null;
        storageUnits = isImportSalesPlan ? this.storageUnits4Sales : this.storageUnits4Prod;
        if (storageUnits != null) {
            for (FullOrgUnitInfo org : storageUnits) {
                if (!org.getNumber().equalsIgnoreCase(storageNumber)) continue;
                storageOrgUnitId = org.getId().toString();
                break;
            }
        }
        this.assertTrue(ctx, storageOrgUnitId != null, "NO_ORG_PERMISSION_OR_NOT_EXIST", storageNumber);
        return storageOrgUnitId;
    }

    private FullOrgUnitCollection getStorageUnitsWithPremission(Context ctx, String permissionItem) throws TaskExternalException {
        ObjectUuidPK userPK = new ObjectUuidPK(BOSUuid.read((String)ctx.getCaller().toString()));
        ObjectUuidPK treePK = new ObjectUuidPK(NewOrgViewHelper.convert2TreeId((OrgType)OrgType.Storage));
        FullOrgUnitCollection orgUnits = null;
        try {
            orgUnits = PermissionFactory.getLocalInstance((Context)ctx).getAuthorizedOrg((IObjectPK)userPK, OrgType.Storage, (IObjectPK)treePK, permissionItem);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (orgUnits != null && orgUnits.size() == 0) {
            orgUnits = null;
        }
        return orgUnits;
    }

    private void assertBetween(Context ctx, int val, int min, int max, String excepDesc) throws TaskExternalException {
        StringBuffer param = new StringBuffer();
        if (val < min || val > max) {
            if (max - min < 5) {
                for (int i = min; i <= max; ++i) {
                    param.append(",").append(i);
                }
            } else {
                param.append(min).append(" ~ ").append(max);
            }
            this.reportException(ctx, excepDesc, param.substring(1));
        }
    }

    private void assertTrue(Context ctx, boolean predicate, String excepDesc, String excepDescParam) throws TaskExternalException {
        if (!predicate) {
            this.reportException(ctx, excepDesc, excepDescParam);
        }
    }

    private void reportException(Context ctx, String excepDesc, String excepDescParam) throws TaskExternalException {
        String msg = ResourceBase.getString((String)(strResource + excepDesc), (Locale)ctx.getLocale());
        if (excepDescParam != null) {
            MessageFormat msgFmt = new MessageFormat(msg);
            msg = msgFmt.format(new String[]{excepDescParam});
        }
        throw new TaskExternalException(msg);
    }

    public EntityObjectInfo getEntityMetaData(Context ctx, BOSObjectType bosType) {
        EntityObjectInfo entityInfo = null;
        IMetaDataLoader loader = null;
        loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        if (loader == null) {
            return entityInfo;
        }
        entityInfo = loader.getEntity(bosType);
        return entityInfo;
    }

    private DIETemplateInfo getTemplate(Context ctx, BOSObjectType bosType) {
        DIETemplateInfo template = null;
        try {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)"SopPlanTemplate", CompareType.EQUALS));
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.setFilter(filter);
            DIETemplateCollection baseCollection = DIETemplateFactory.getLocalInstance((Context)ctx).getDIETemplateCollection(viewInfo);
            if (baseCollection != null && baseCollection.size() > 0) {
                template = (DIETemplateInfo)baseCollection.iterator().next();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return template;
    }

    private String getPlanVersionByNumber(Context ctx, String number) throws TaskExternalException {
        String planVersionId = (String)this.planVersions.get(number);
        if (planVersionId == null) {
            try {
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
                EntityViewInfo viewInfo = new EntityViewInfo();
                viewInfo.setFilter(filter);
                SOPPlanVersionCollection baseCollection = SOPPlanVersionFactory.getLocalInstance(ctx).getSOPPlanVersionCollection(viewInfo);
                if (baseCollection != null && baseCollection.size() > 0) {
                    planVersionId = baseCollection.get(0).getId().toString();
                    this.planVersions.put(number, planVersionId);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.assertTrue(ctx, planVersionId != null, "INVALID_PLAN_VERSION", null);
        return planVersionId;
    }

    private Map getMeasureUnitCoefficient(Context ctx, String unitNumber, String material, String storageOrgUnitId) throws BOSException, SQLException, TaskExternalException {
        StringBuffer sql = new StringBuffer();
        HashMap<String, Number> map = new HashMap<String, Number>();
        sql.append(" SELECT distinct m.FID FID, mu.FBaseConvsRate FBaseConvsRate, mu.FQtyPrecision FQtyPrecision, u.FGroupID FGroupID, mp.FMaterialAttr FMaterialAttr").append(" FROM T_BD_Material m \n").append(" INNER JOIN t_bd_materialInventory mi on m.FID = mi.FMaterialId \n").append("                                  AND mi.FStatus = 1 \n").append("                                  AND mi.FOrgUnit = ? \n").append(" INNER JOIN T_BD_MaterialPlan mp on m.FID = mp.FMaterialId \n").append("                                  AND mp.FStatus = 1 \n").append("                                  AND mp.FOrgUnit = ? \n").append(" INNER JOIN T_BD_MultiMeasureUnit mu on  mp.FMaterialId = mu.FMaterialId \n").append(" INNER JOIN T_BD_MeasureUnit u on mu.FMeasureUnitId =u.FId \n").append(" and u.fnumber=? \n").append(" WHERE m.FStatus=1 AND m.FNumber = ?; \n");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{storageOrgUnitId, storageOrgUnitId, unitNumber, material});
        this.assertTrue(ctx, rowSet.size() != 0, "INVALID_MEASURE_UNIT", unitNumber);
        while (rowSet.next()) {
            String importRate = rowSet.getString("FBaseConvsRate");
            String importPrecision = rowSet.getString("FQtyPrecision");
            map.put("rate", new BigDecimal(importRate));
            map.put("precision", new Integer(importPrecision));
        }
        return map;
    }

    private Object[] getMaterialByNumber(Context ctx, String storageId, String materialNumber, String supplyOrgUnit, String planVersionId) throws TaskExternalException, BOSException {
        Object[] ret = null;
        IRowSet rs = null;
        StringBuffer sql = new StringBuffer(400);
        StringBuffer sql2 = new StringBuffer("");
        StringBuffer sql3 = new StringBuffer("");
        String unit = new String();
        sql.append(" SELECT distinct m.FID,  mp.FMaterialAttr").append(" FROM T_BD_Material m \n").append(" INNER JOIN t_bd_materialInventory mi on m.FID = mi.FMaterialId \n").append("                                  AND mi.FStatus = 1 \n").append("                                  AND mi.FOrgUnit = ? \n").append(" INNER JOIN T_BD_MaterialPlan mp on m.FID = mp.FMaterialId \n").append("                                  AND mp.FStatus = 1 \n").append("                                  AND mp.FOrgUnit = ? \n").append(" WHERE m.FStatus=1 AND m.FNumber = ?; \n");
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{supplyOrgUnit, supplyOrgUnit, materialNumber});
        }
        catch (BOSException e1) {
            throw new TaskExternalException(e1.getMessage(), e1.getCause());
        }
        this.assertTrue(ctx, rs.size() != 0, "MAY_NOT_IN_SUPPLYORGUNIT", null);
        sql3.append(" select sb.FAssistUnitID from t_mm_sopbill sb inner join t_bd_material m on sb.fmaterialid=m.fid where sb.FPlanVersionID=? and sb.FStorageOrgUnitID=? and m.FNumber=? and sb.FSupplyStorageOrgUnitID=? ");
        IRowSet it = DbUtil.executeQuery((Context)ctx, (String)sql3.toString(), (Object[])new Object[]{planVersionId, storageId, materialNumber, supplyOrgUnit});
        sql2.append(" SELECT distinct m.FID FID, mu.FBaseConvsRate FBaseConvsRate, mu.FQtyPrecision FQtyPrecision, u.FGroupID FGroupID, mp.FMaterialAttr FMaterialAttr,m.fbaseunit fbaseunit,mu.FMeasureUnitId FProductunitid ");
        sql2.append(" FROM T_BD_Material m \n");
        sql2.append(" INNER JOIN t_bd_materialInventory mi on m.FID = mi.FMaterialId \n");
        sql2.append("                                  AND mi.FStatus = 1 \n");
        sql2.append("                                  AND mi.FOrgUnit = ? \n");
        sql2.append(" INNER JOIN T_BD_MaterialPlan mp on m.FID = mp.FMaterialId \n");
        sql2.append("                                  AND mp.FStatus = 1 \n");
        sql2.append("                                  AND mp.FOrgUnit = ? \n");
        if (it.size() == 0) {
            unit = "mp.FProductunitid";
            sql2.append(" INNER JOIN T_BD_MultiMeasureUnit mu on " + unit + " = mu.FMeasureUnitId \n");
        } else {
            try {
                while (it.next()) {
                    unit = it.getString("FAssistUnitID");
                    sql2.append(" INNER JOIN T_BD_MultiMeasureUnit mu on '" + unit + "' = mu.FMeasureUnitId \n");
                }
            }
            catch (SQLException e) {
                throw new TaskExternalException(e.getMessage(), e.getCause());
            }
        }
        sql2.append("                                    and mp.FMaterialId = mu.FMaterialId \n");
        sql2.append(" INNER JOIN T_BD_MeasureUnit u on mu.FMeasureUnitId = u.FId \n");
        sql2.append(" WHERE m.FStatus=1 AND m.FNumber = ?; \n");
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql2.toString(), (Object[])new Object[]{storageId, storageId, materialNumber});
            if (rowSet.next()) {
                ret = new Object[6];
                String matAttribute = rowSet.getString("FMaterialAttr");
                this.assertTrue(ctx, matAttribute.equals("10030") || matAttribute.equals("10040") || matAttribute.equals("10050"), "INVALID_MATERIAL_ATTRIBUTE", null);
                ret[0] = rowSet.getString("FID");
                ret[1] = rowSet.getBigDecimal("FBaseConvsRate");
                ret[2] = new Integer(rowSet.getInt("FQtyPrecision"));
                ret[3] = rowSet.getString("FGroupID");
                ret[4] = rowSet.getString("fbaseunit");
                ret[5] = rowSet.getString("FProductunitid");
            }
            this.assertTrue(ctx, rowSet.size() != 0, "MAT_NOT_IN_STORAGEORGUNIT", null);
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage());
        }
        return ret;
    }

    private String getSupplyOrgUnitByNumber(Context ctx, String supplyOrgUnitNumber) throws BOSException, SQLException, TaskExternalException, EASBizException {
        String supplyOrgUnitId = null;
        StringBuffer sql = new StringBuffer("");
        ISOPFacade sop = SOPFacadeFactory.getLocalInstance(ctx);
        sql.append(" select fid id from t_org_storage where fnumber='" + supplyOrgUnitNumber + "'");
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            this.assertTrue(ctx, rowSet.size() != 0, "NO_SUCH_SUPPLYORGUNIT", supplyOrgUnitNumber);
            while (rowSet.next()) {
                supplyOrgUnitId = rowSet.getString("id");
            }
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
        SOPSysParams params = sop.getSOPSysParams(supplyOrgUnitId);
        this.assertTrue(ctx, params != null, "PLAESE_SET_PARAMS", supplyOrgUnitNumber);
        return supplyOrgUnitId;
    }

    private CoreBaseInfo getValueObject(EntityObjectInfo entityInfo) {
        CoreBaseInfo objbase = null;
        try {
            Class<?> cls = Class.forName(entityInfo.getObjectValueClass());
            objbase = (CoreBaseInfo)cls.newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return objbase;
    }

    private BigDecimal getBopData(Context ctx, Hashtable hsData, int precision, BigDecimal planUnit2Default, Map importUnit2Default) throws TaskExternalException {
        String msg = ResourceBase.getString((String)"com.kingdee.eas.mm.planning.SOPResource.BOP", (Locale)ctx.getLocale());
        BigDecimal bop = this.getNumericValue(ctx, hsData, BOP_VALUE, msg);
        BigDecimal importRate = (BigDecimal)importUnit2Default.get("rate");
        int importPrecision = (Integer)importUnit2Default.get("precision");
        try {
            if (planUnit2Default.compareTo(importRate) == 0) {
                bop = bop.setScale(precision, 4);
            } else {
                if (precision > bop.scale()) {
                    bop = bop.setScale(precision);
                }
                bop = bop.multiply(importRate).divide(planUnit2Default, 4).setScale(precision, 4);
            }
        }
        catch (NumberFormatException e) {
            throw new TaskExternalException(e.getMessage());
        }
        return bop;
    }

    private void InsertSopPlanBop(Context ctx, BigDecimal data, String materialId, String storageId, String supplyOrgUnit, String planVerId, BigDecimal rate, int precision, String importBaseUnit, String importProductUnit) throws TaskExternalException {
        StringBuffer sqlSB = new StringBuffer();
        String clr = "\r\n";
        ArrayList<Object> paramLst = new ArrayList<Object>();
        try {
            sqlSB.setLength(0);
            sqlSB.append(" SELECT distinct FID ").append(clr).append(" FROM T_MM_SopBill ").append(clr).append(" WHERE FStorageOrgUnitId = ? ").append(clr).append("   AND FPlanVersionId = ? ").append(clr).append("   AND FSupplyStorageOrgUnitID = ? ").append(clr).append("   AND FMaterialId = ?; ").append(clr);
            paramLst.clear();
            paramLst.add(storageId);
            paramLst.add(planVerId);
            paramLst.add(supplyOrgUnit);
            paramLst.add(materialId);
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlSB.toString(), (Object[])paramLst.toArray());
            if (rs != null && rs.next()) {
                sqlSB.setLength(0);
                sqlSB.append(" UPDATE T_MM_SopBill ").append(clr).append("    SET FBopDate = ?, FBop = ? ,FBaseBop=?").append(clr).append(" WHERE FStorageOrgUnitId = ? ").append(clr).append("   AND FPlanVersionId = ? ").append(clr).append("   AND FSupplyStorageOrgUnitID = ? ").append(clr).append("   AND FMaterialId = ?; ").append(clr);
                Calendar date = Calendar.getInstance();
                Date datesql = new Date(date.getTimeInMillis());
                paramLst.clear();
                paramLst.add(datesql);
                paramLst.add(data);
                paramLst.add(data.multiply(rate).setScale(precision, 4));
                paramLst.add(storageId);
                paramLst.add(planVerId);
                paramLst.add(supplyOrgUnit);
                paramLst.add(materialId);
                DbUtil.execute((Context)ctx, (String)sqlSB.toString(), (Object[])paramLst.toArray());
            } else {
                String sopPlanBosType = new SopBillInfo().getBOSType().toString();
                sqlSB.setLength(0);
                sqlSB.append("insert into T_MM_SopBill ").append(clr).append("(FID,FPlanVersionID,FStorageOrgUnitID,FSupplyStorageOrgUnitID,FMaterialID,FBop,FBaseBop,FBaseUnitID,FAssistUnitID) ").append(clr).append("VALUES( newbosid('").append(sopPlanBosType).append("'),").append(clr).append("'").append(planVerId).append("',").append(clr).append("'").append(storageId).append("',").append(clr).append("'").append(supplyOrgUnit).append("',").append(clr).append("'").append(materialId).append("',").append(clr).append(data).append(",").append(data.multiply(rate).setScale(precision, 4)).append(",'").append(importBaseUnit).append("','").append(importProductUnit).append("'").append(clr).append(")");
                DbUtil.execute((Context)ctx, (String)sqlSB.toString(), (Object[])new Object[0]);
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage());
        }
    }
}

