/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.BatchPolicyEnum;
import com.kingdee.eas.basedata.master.material.MaterialInventoryCollection;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.master.material.MaterialPlanCollection;
import com.kingdee.eas.basedata.master.material.MaterialPlanFactory;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.master.material.MaterialScrapRateExpressionEnum;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitCollection;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.basedata.BOMTypeEnum;
import com.kingdee.eas.mm.basedata.IPlanVersionSet;
import com.kingdee.eas.mm.basedata.IPlanningHorizonSet;
import com.kingdee.eas.mm.basedata.LineSchedulingModelCollection;
import com.kingdee.eas.mm.basedata.LineSchedulingModelFactory;
import com.kingdee.eas.mm.basedata.LineSchedulingModelInfo;
import com.kingdee.eas.mm.basedata.MaterialRangeEnum;
import com.kingdee.eas.mm.basedata.PlanVersionSetEntryCollection;
import com.kingdee.eas.mm.basedata.PlanVersionSetEntryInfo;
import com.kingdee.eas.mm.basedata.PlanVersionSetFactory;
import com.kingdee.eas.mm.basedata.PlanVersionSetInfo;
import com.kingdee.eas.mm.basedata.PlanVersionSetMatEntryCollection;
import com.kingdee.eas.mm.basedata.PlanVersionSetMatEntryInfo;
import com.kingdee.eas.mm.basedata.PlanningHorizonSetFactory;
import com.kingdee.eas.mm.basedata.PlanningHorizonSetInfo;
import com.kingdee.eas.mm.basedata.WarehouseRangeEnum;
import com.kingdee.eas.mm.planning.ActionAdviseTypeEnum;
import com.kingdee.eas.mm.planning.IProductLineSupplyMaterialPlan;
import com.kingdee.eas.mm.planning.ProductLineSupplyMaterialPlanFactory;
import com.kingdee.eas.mm.planning.SchedulingException;
import com.kingdee.eas.mm.planning.SupplyMaterCalcException;
import com.kingdee.eas.mm.planning.SupplyMaterialCalculateScaleEnum;
import com.kingdee.eas.mm.planning.app.AbstractSupplyMaterialCalculateFacadeControllerBean;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;

public class SupplyMaterialCalculateFacadeControllerBean
extends AbstractSupplyMaterialCalculateFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.planning.app.SupplyMaterialCalculateFacadeControllerBean");
    private static final int ONE_HANDRED = 100;
    private static final String ROW_KEY_SPLIT = "-";
    private String storageOrgID;
    private String planVersionID;
    private PlanVersionSetInfo planVersionSetInfo;
    private Set statusSet;
    private SupplyMaterialCalculateScaleEnum calculateScale;
    private boolean isInteAdjust;
    private boolean isPartAdjust;
    private int forwardDay;
    private int backDay;
    private String tmpExpandedTable = "";

    @Override
    protected void _calculateSupplyMaterial(Context ctx, HashMap filterMap) throws BOSException, EASBizException {
        this.prepareData(ctx, filterMap);
        String ruqTableName = this.getRuqData(ctx);
        this._modifyTempTable(ctx, ruqTableName);
        String gRuqTableName = this.bomFormulaExpand(ctx, ruqTableName);
        if (!this.planVersionSetInfo.isIsCalNetting() || SupplyMaterialCalculateScaleEnum.productLineSupplyMaterial.equals((Object)this.calculateScale)) {
            this.saveProductLSMP(ctx, gRuqTableName);
            return;
        }
        if (this.planVersionSetInfo.isIsShopBuildding()) {
            this.productionOrderStockCal(ctx, gRuqTableName);
        }
        Set materialSet = this.getMaterialSetMap(ctx, gRuqTableName);
        HashMap materialPlanInfoMap = this.getMaterialPlan(ctx, materialSet);
        HashMap materialInventoryInfoMap = this.getMaterialInventory(ctx, materialSet);
        HashMap materialMultiUnitMap = this.getMaterialMultiMeasureUnit(ctx, materialSet);
        String supplyBillTableName = this.getSupplyBill(ctx, gRuqTableName);
        HashMap gRuqQtyMap = this.getFirGRuqQty(ctx, gRuqTableName);
        HashMap supplyQtyMap = this.getFirSupplyQty(ctx, supplyBillTableName);
        HashMap leavingsDataMap = this.getLeavingsData(ctx, gRuqTableName, gRuqQtyMap, supplyQtyMap);
        String refinedStockPlanTableName = this.getRefinedStockPlan(ctx, materialPlanInfoMap, materialInventoryInfoMap, materialMultiUnitMap, gRuqQtyMap, gRuqTableName, supplyBillTableName, leavingsDataMap);
        this.saveProductLSMP(ctx, gRuqTableName);
        this.saveRefinedPurPlan(ctx, refinedStockPlanTableName);
        this.saveSupplyBill(ctx, supplyBillTableName, materialPlanInfoMap, materialMultiUnitMap);
        this.releaseTempTable(ctx, ruqTableName);
        this.releaseTempTable(ctx, gRuqTableName);
        this.releaseTempTable(ctx, supplyBillTableName);
        this.releaseTempTable(ctx, refinedStockPlanTableName);
    }

    @Override
    protected void _calculateSupplyMaterial(Context ctx, String storageOrgUnitNumber, String planVersionSetNumber, long calculateScale, boolean isInteAdjust, boolean isPartAdjust, long forwardDay, long backDay) throws BOSException, EASBizException {
        int intCalculateScale = (int)calculateScale;
        StorageOrgUnitInfo storageOrgUnit = this.getStorageOrgUnit(ctx, storageOrgUnitNumber);
        String storageOrgUnitID = storageOrgUnit.getId().toString();
        UserInfo caller = ContextUtil.getCurrentUserInfo((Context)ctx);
        IPermission perm = PermissionFactory.getLocalInstance((Context)ctx);
        ObjectStringPK userPk = new ObjectStringPK(caller.getId().toString());
        ObjectStringPK orgPK = new ObjectStringPK(storageOrgUnit.getId().toString());
        if (!"00000000-0000-0000-0000-00000000000013B7DE7F".equals(caller.getId().toString()) && !perm.hasFunctionPermission((IObjectPK)userPk, (IObjectPK)orgPK, "mm_SupplyMaterialCalc")) {
            throw new SupplyMaterCalcException(SupplyMaterCalcException.BACKRUNUSERNOPERMISSION_ERROR);
        }
        PlanVersionSetInfo planVersionSetInfo = this.getPlanVersionSet(ctx, storageOrgUnitID, planVersionSetNumber);
        if (forwardDay < 0L || forwardDay > 9999L) {
            throw new SupplyMaterCalcException(SupplyMaterCalcException.FORWARDDAYSCALE_ERROR);
        }
        if (backDay < 0L || backDay > 9999L) {
            throw new SupplyMaterCalcException(SupplyMaterCalcException.BACKDAYSCALE_ERROR);
        }
        if (backDay < 0L || backDay > 9999L) {
            throw new SupplyMaterCalcException(SupplyMaterCalcException.BACKDAYSCALE_ERROR);
        }
        if (calculateScale != 10L && calculateScale != 20L) {
            throw new SupplyMaterCalcException(SupplyMaterCalcException.CALCULATESCALE_ERROR);
        }
        HashMap<String, Object> filterMap = new HashMap<String, Object>();
        filterMap.put("storageOrgUnit", storageOrgUnit);
        String planVersionID = planVersionSetInfo.getId().toString();
        filterMap.put("planVersionID", planVersionID);
        filterMap.put("calculateScale", (Object)SupplyMaterialCalculateScaleEnum.getEnum(intCalculateScale));
        HashSet<EntryBaseStatusEnum> statusSet = new HashSet<EntryBaseStatusEnum>();
        statusSet.add(EntryBaseStatusEnum.SUBMITED);
        statusSet.add(EntryBaseStatusEnum.AUDITED);
        filterMap.put("entryBaseStatus", statusSet);
        filterMap.put("isInteAdjust", new Boolean(isInteAdjust));
        filterMap.put("isPartAdjust", new Boolean(isPartAdjust));
        filterMap.put("forwardDay", new Integer((int)forwardDay));
        filterMap.put("backDay", new Integer((int)backDay));
        this._calculateSupplyMaterial(ctx, filterMap);
    }

    private void prepareData(Context ctx, HashMap filterMap) throws BOSException, EASBizException {
        StorageOrgUnitInfo storageOrgUnit = (StorageOrgUnitInfo)filterMap.get("storageOrgUnit");
        this.storageOrgID = storageOrgUnit.getId().toString();
        this.calculateScale = (SupplyMaterialCalculateScaleEnum)((Object)filterMap.get("calculateScale"));
        this.statusSet = (Set)filterMap.get("entryBaseStatus");
        this.isInteAdjust = (Boolean)filterMap.get("isInteAdjust");
        this.isPartAdjust = (Boolean)filterMap.get("isPartAdjust");
        this.forwardDay = (Integer)filterMap.get("forwardDay");
        this.backDay = (Integer)filterMap.get("backDay");
        this.planVersionID = (String)filterMap.get("planVersionID");
        IPlanVersionSet iPlanVersionSet = PlanVersionSetFactory.getLocalInstance((Context)ctx);
        ObjectUuidPK pk = new ObjectUuidPK(this.planVersionID);
        this.planVersionSetInfo = iPlanVersionSet.getPlanVersionSetInfo((IObjectPK)pk);
        ObjectUuidPK planningHorizonPk = new ObjectUuidPK(this.planVersionSetInfo.getPlanningHorizon().getId());
        IPlanningHorizonSet iPlanningHorizonSet = PlanningHorizonSetFactory.getLocalInstance((Context)ctx);
        PlanningHorizonSetInfo planningHorizonSetInfo = iPlanningHorizonSet.getPlanningHorizonSetInfo((IObjectPK)planningHorizonPk);
        this.planVersionSetInfo.getPlanningHorizon().setHorizonLength(planningHorizonSetInfo.getHorizonLength());
    }

    private String getRuqData(Context ctx) throws BOSException, EASBizException {
        String ruqTableName = null;
        try {
            String createTableRuqSQL = "CREATE TABLE tempRequire (FPlanVersionID VARCHAR(44),FStorageOrgUnitID VARCHAR(44),FWorkShopID  VARCHAR(44),FProductLineID  VARCHAR(44),FMaterialID VARCHAR(44),FBeginDate DateTime,FQty NUMERIC(21,8),FBaseQty NUMERIC(21,8),FUnitId VARCHAR(44),FSrcType INT,FExpandStrategy INT,FPLSEntryID VARCHAR(44),FTrackNumberID VARCHAR(44),FFormulaID VARCHAR(44),FSourceBillID  VARCHAR(44))";
            ruqTableName = this.createTempTable(ctx, createTableRuqSQL);
            StringBuffer sqlBuf = new StringBuffer();
            sqlBuf.append("INSERT INTO ");
            sqlBuf.append(ruqTableName);
            sqlBuf.append("(FPlanVersionID,");
            sqlBuf.append("FStorageOrgUnitID,");
            sqlBuf.append("FWorkShopID,");
            sqlBuf.append("FProductLineID,");
            sqlBuf.append("FMaterialID,");
            sqlBuf.append("FBeginDate,");
            sqlBuf.append("FQty,");
            sqlBuf.append("FUnitId,");
            sqlBuf.append("FBaseQty,");
            sqlBuf.append("FSrcType,");
            sqlBuf.append("FExpandStrategy,");
            sqlBuf.append("FPLSEntryID,");
            sqlBuf.append("FTrackNumberID,");
            sqlBuf.append("FFormulaID,");
            sqlBuf.append("FSourceBillID)");
            sqlBuf.append(" select '");
            sqlBuf.append(this.planVersionID);
            sqlBuf.append("',a.FstorageOrgUnitID,b.FWorkShopID,b.FProductLineID,b.FMaterialID,");
            sqlBuf.append("b.FBeginDate,b.FQty,b.FUnitId,b.FBaseQty,");
            sqlBuf.append(10);
            sqlBuf.append(",c.FExpandStrategy");
            sqlBuf.append(",b.FID");
            sqlBuf.append(",b.FTrackNumberID");
            sqlBuf.append(",b.FFormulaID");
            sqlBuf.append(",b.FID");
            sqlBuf.append(" from T_MM_ProductionLineScheduling a inner join T_MM_PLSEntry b on a.FID = b.FParent ");
            sqlBuf.append(" inner join T_MM_PLSMODEL c on a.fplSModelID = c.fid");
            sqlBuf.append(" where a.FBaseStatus = 2");
            sqlBuf.append(" and a.FStorageOrgUnitID = '" + this.storageOrgID);
            sqlBuf.append("' and (");
            Iterator iter = this.statusSet.iterator();
            int i = 1;
            while (iter.hasNext()) {
                if (i == 1) {
                    sqlBuf.append(" b.FBaseStatus =" + ((EntryBaseStatusEnum)iter.next()).getValue());
                } else {
                    sqlBuf.append(" or b.FBaseStatus =" + ((EntryBaseStatusEnum)iter.next()).getValue());
                }
                ++i;
            }
            sqlBuf.append(")");
            DbUtil.execute((Context)ctx, (String)sqlBuf.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return ruqTableName;
    }

    private String bomFormulaExpand(Context ctx, String ruqTableName) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement batchStatement = null;
        String gRuqTableName = null;
        try {
            String createTableSQLGrossRuq = "CREATE TABLE tempGrossRuqire (FPlanVersionID VARCHAR(44),FStorageOrgUnitID VARCHAR(44),FWorkShopID  VARCHAR(44),FProductLineID  VARCHAR(44),FMaterialID VARCHAR(44),FBeginDate DateTime,FQty NUMERIC(21,8),FBaseQty NUMERIC(21,8),FUnitId VARCHAR(44),FIssMode INT,FSrcType INT,FSourceBillID  VARCHAR(44))";
            gRuqTableName = this.createTempTable(ctx, createTableSQLGrossRuq);
            conn = EJBFactory.getConnection((Context)ctx);
            StringBuffer sqlBuf = new StringBuffer();
            sqlBuf.append("INSERT INTO ");
            sqlBuf.append(gRuqTableName);
            sqlBuf.append("(FPlanVersionID,");
            sqlBuf.append("FStorageOrgUnitID,");
            sqlBuf.append("FWorkShopID,");
            sqlBuf.append("FProductLineID,");
            sqlBuf.append("FMaterialID,");
            sqlBuf.append("FBeginDate,");
            sqlBuf.append("FQty,");
            sqlBuf.append("FUnitId,");
            sqlBuf.append("FBaseQty,");
            sqlBuf.append("FIssMode,");
            sqlBuf.append("FSrcType,");
            sqlBuf.append("FSourceBillID) values(?,?,?,?,?,?,?,?,?,?,?,?) ");
            batchStatement = conn.prepareStatement(sqlBuf.toString());
            this.tmpExpandedTable = this.createTempTable(ctx, this.createExpandTable());
            StringBuffer sqlAll = new StringBuffer();
            sqlAll.append(this.getInsertExpandSQL(this.tmpExpandedTable));
            sqlAll.append(this.getExpandBomSQL(ruqTableName, BOMTypeEnum.OrderBOM, null));
            sqlAll.append("\n union all \n");
            sqlAll.append(this.getExpandFormulaSQL(ruqTableName));
            DbUtil.execute((Context)ctx, (String)sqlAll.toString());
            sqlAll.setLength(0);
            sqlAll.append(this.getInsertExpandSQL(this.tmpExpandedTable));
            String selectSQL = "select distinct FPLSEntryID from " + this.tmpExpandedTable;
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSQL);
            int index = 0;
            StringBuffer plsEntryIDs = new StringBuffer();
            while (rs.next()) {
                if (index > 0) {
                    plsEntryIDs.append(",");
                }
                plsEntryIDs.append("'" + rs.getString("FPLSEntryID") + "'");
                ++index;
            }
            sqlAll.append(this.getExpandBomSQL(ruqTableName, BOMTypeEnum.MfgBOM, plsEntryIDs));
            DbUtil.execute((Context)ctx, (String)sqlAll.toString());
            IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)this.getSelectExpandSQL(this.tmpExpandedTable));
            while (rows.next()) {
                double childBaseQty;
                double childQty;
                String planVersionID = rows.getString("FPlanVersionID");
                String storageOrgUnitID = rows.getString("FStorageOrgUnitID");
                String workShopID = rows.getString("FWorkShopID");
                String productLineID = rows.getString("FProductLineID");
                String materialID = rows.getString("FMaterialID");
                String sourceBillID = rows.getString("FSourceBillID");
                java.util.Date beginDate = rows.getDate("FBeginDate");
                int srcType = rows.getInt("FSrcType");
                BigDecimal qty = rows.getBigDecimal("FQty");
                BigDecimal baseQty = rows.getBigDecimal("FBaseQty");
                int leadtime = rows.getInt("Fleadtime");
                int consumetype = rows.getInt("FConsumetype");
                int issMode = rows.getInt("FIssMode");
                int issLeadTime = rows.getInt("FIssLeadTime");
                String unitId = rows.getString("FUnitId");
                BigDecimal consumeFixQty = rows.getBigDecimal("FConsumeFixQty");
                BigDecimal productqty = rows.getBigDecimal("FProductQty");
                BigDecimal consumeFixBaseQty = rows.getBigDecimal("FConsumeFixBaseQty");
                BigDecimal productBaseqty = rows.getBigDecimal("FProductBaseqty");
                BigDecimal proportion = rows.getBigDecimal("Fproportion");
                BigDecimal baseproductrate = rows.getBigDecimal("FBaseproductrate");
                BigDecimal baserate = rows.getBigDecimal("FBaserate");
                BigDecimal scrapRatio = rows.getBigDecimal("FScrapRatio");
                int scrapRateExpression = rows.getInt("FScrapRateExpression");
                double productQty = 0.0;
                double productBaseQty = 0.0;
                if (scrapRateExpression == 10610) {
                    productQty = qty.doubleValue() / (1.0 - scrapRatio.doubleValue() / 100.0);
                    productBaseQty = baseQty.doubleValue() / (1.0 - scrapRatio.doubleValue() / 100.0);
                } else if (scrapRateExpression == 10620) {
                    productQty = qty.doubleValue() * (1.0 + scrapRatio.doubleValue() / 100.0);
                    productBaseQty = baseQty.doubleValue() * (1.0 + scrapRatio.doubleValue() / 100.0);
                }
                if (consumetype == 20) {
                    childQty = productQty * (consumeFixQty.doubleValue() / productqty.doubleValue());
                    childBaseQty = productBaseQty * (consumeFixBaseQty.doubleValue() / productBaseqty.doubleValue());
                } else {
                    childBaseQty = productBaseQty * (proportion.doubleValue() / 100.0) / baseproductrate.doubleValue();
                    childQty = childBaseQty / baserate.doubleValue();
                }
                Calendar cal = Calendar.getInstance();
                cal.setTime(beginDate);
                cal.add(5, leadtime);
                cal.add(5, -issLeadTime);
                beginDate = cal.getTime();
                batchStatement.setString(1, planVersionID);
                batchStatement.setString(2, storageOrgUnitID);
                batchStatement.setString(3, workShopID);
                batchStatement.setString(4, productLineID);
                batchStatement.setString(5, materialID);
                batchStatement.setDate(6, new Date(beginDate.getTime()));
                batchStatement.setDouble(7, childQty);
                batchStatement.setString(8, unitId);
                batchStatement.setDouble(9, childBaseQty);
                batchStatement.setInt(10, issMode);
                batchStatement.setInt(11, srcType);
                batchStatement.setString(12, sourceBillID);
                batchStatement.addBatch();
            }
            batchStatement.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(batchStatement, conn);
                this.releaseTempTable(ctx, this.tmpExpandedTable);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)batchStatement, (Connection)conn);
        this.releaseTempTable(ctx, this.tmpExpandedTable);
        return gRuqTableName;
    }

    private String bomFormulaExpand(Context ctx, String ruqTableName, StorageOrgUnitInfo storageOrgUnit, PlanVersionSetInfo planVersionSetInfo, SupplyMaterialCalculateScaleEnum calculateScale) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement batchStatement = null;
        String gRuqTableName = null;
        IProductLineSupplyMaterialPlan iPLSMP = ProductLineSupplyMaterialPlanFactory.getLocalInstance(ctx);
        String materialFilter = iPLSMP.needFilter();
        try {
            String materialIDStr;
            String materialID;
            PlanVersionSetMatEntryInfo matEntryInfo;
            Object[] materialIDArray;
            String createTableSQLGrossRuq = "CREATE TABLE tempGrossRuqire (FPlanVersionID VARCHAR(44),FStorageOrgUnitID VARCHAR(44),FWorkShopID  VARCHAR(44),FProductLineID  VARCHAR(44),FMaterialID VARCHAR(44),FBeginDate DateTime,FQty NUMERIC(21,8),FBaseQty NUMERIC(21,8),FUnitId VARCHAR(44),FIssMode INT,FSrcType INT,FSourceBillID  VARCHAR(44))";
            gRuqTableName = this.createTempTable(ctx, createTableSQLGrossRuq);
            MaterialRangeEnum materialRange = planVersionSetInfo.getMaterialRange();
            PlanVersionSetMatEntryCollection matEntrys = planVersionSetInfo.getMatEntrys();
            conn = EJBFactory.getConnection((Context)ctx);
            StringBuffer sqlBuf = new StringBuffer();
            sqlBuf.append("INSERT INTO ");
            sqlBuf.append(gRuqTableName);
            sqlBuf.append("(FPlanVersionID,");
            sqlBuf.append("FStorageOrgUnitID,");
            sqlBuf.append("FWorkShopID,");
            sqlBuf.append("FProductLineID,");
            sqlBuf.append("FMaterialID,");
            sqlBuf.append("FBeginDate,");
            sqlBuf.append("FQty,");
            sqlBuf.append("FUnitId,");
            sqlBuf.append("FBaseQty,");
            sqlBuf.append("FIssMode,");
            sqlBuf.append("FSrcType,");
            sqlBuf.append("FSourceBillID) values(?,?,?,?,?,?,?,?,?,?,?,?) ");
            batchStatement = conn.prepareStatement(sqlBuf.toString());
            StringBuffer sqlAll = new StringBuffer();
            sqlAll.append("select ");
            sqlAll.append("a.FProductQty,");
            sqlAll.append("a.FProductBaseqty,");
            sqlAll.append("b.Fproportion,");
            sqlAll.append("b.FBaseproductrate,");
            sqlAll.append("b.FBaserate,");
            sqlAll.append("b.Fleadtime,");
            sqlAll.append("b.FConsumetype,");
            sqlAll.append("b.FConsumeFixQty,");
            sqlAll.append("b.FConsumeFixBaseQty,");
            sqlAll.append("c.FIssMode,");
            sqlAll.append("c.FIssLeadTime,");
            sqlAll.append("d.FPlanVersionID,");
            sqlAll.append("d.FStorageOrgUnitID,");
            sqlAll.append("d.FWorkShopID,");
            sqlAll.append("d.FProductLineID,");
            sqlAll.append("b.FMaterialID,");
            sqlAll.append("d.FBeginDate,");
            sqlAll.append("d.FQty,");
            sqlAll.append("b.FUnitId,");
            sqlAll.append("d.FSrcType,");
            sqlAll.append("d.FSourceBillID,");
            sqlAll.append("a.FYield,");
            sqlAll.append("b.FScrapRatio,");
            sqlAll.append("c.FScrapRateExpression,");
            sqlAll.append("d.FBaseQty");
            sqlAll.append(" from t_mm_bom a inner join t_mm_bomentry b on a.fid = b.fparentid ");
            sqlAll.append(" inner join t_bd_materialplan c on b.fmaterialinventoid = c.fid");
            sqlAll.append(" inner join " + ruqTableName + " d on d.FMaterialID = a.FMaterialid and d.FStorageOrgUnitID = a.FStorageOrgUnitID");
            sqlAll.append(" where a.fbomType = 40 and a.fusageType = 10 and a.fbasestatus = 4 and c.fstatus = 1 ");
            sqlAll.append(" and d.FExpandStrategy = 10");
            sqlAll.append(" and b.FEffectiveDate <= now() and b.FDisableDate >=  now()");
            if (calculateScale == SupplyMaterialCalculateScaleEnum.productLineSupplyMaterial) {
                if (materialFilter.trim() != null || materialFilter.trim().length() != 0) {
                    sqlAll.append(" and ").append(materialFilter);
                }
            } else if (calculateScale == SupplyMaterialCalculateScaleEnum.finePur) {
                sqlAll.append(" and ((c.fmaterialattr = 10050 and c.FIssMode = 11050) or (c.fmaterialattr = 10040)) ");
            }
            if (materialRange.getValue() == 30) {
                materialIDArray = new String[matEntrys.size()];
                for (int i = 0; i < matEntrys.size(); ++i) {
                    matEntryInfo = matEntrys.get(i);
                    materialID = matEntryInfo.getMaterial().getId().toString();
                    materialIDArray[i] = materialID;
                }
                materialIDStr = StringUtils.arrayToString((Object[])materialIDArray, (String)"','");
                sqlAll.append(" and b.fmaterialid in ('" + materialIDStr + "') ");
            }
            sqlAll.append(" union all ");
            sqlAll.append("select ");
            sqlAll.append("a.FProductQty,");
            sqlAll.append("a.FProductBaseqty,");
            sqlAll.append("b.Fproportion,");
            sqlAll.append("b.FBaseproductrate,");
            sqlAll.append("b.FBaserate,");
            sqlAll.append("b.Fleadtime,");
            sqlAll.append("b.FConsumetype,");
            sqlAll.append("b.FConsumeFixQty,");
            sqlAll.append("b.FConsumeFixBaseQty,");
            sqlAll.append("c.FIssMode,");
            sqlAll.append("c.FIssLeadTime,");
            sqlAll.append("d.FPlanVersionID,");
            sqlAll.append("d.FStorageOrgUnitID,");
            sqlAll.append("d.FWorkShopID,");
            sqlAll.append("d.FProductLineID,");
            sqlAll.append("b.FMaterialID,");
            sqlAll.append("d.FBeginDate,");
            sqlAll.append("d.FQty,");
            sqlAll.append("b.FUnitId,");
            sqlAll.append("d.FSrcType,");
            sqlAll.append("d.FSourceBillID,");
            sqlAll.append("a.FYield,");
            sqlAll.append("c.FScrapRate as FScrapRatio,");
            sqlAll.append("c.FScrapRateExpression,");
            sqlAll.append("d.FBaseQty");
            sqlAll.append(" from T_MM_ProductionFormula a inner join T_MM_ProductionFormulaEntry b on a.fid = b.fparentid ");
            sqlAll.append(" inner join t_bd_materialplan c on b.FMaterialInventoyID = c.fid ");
            sqlAll.append(" inner join " + ruqTableName + " d on d.FMaterialID = a.FMaterialid ");
            sqlAll.append(" and d.FProductLineID = a.FProductLineID and d.FStorageOrgUnitID = a.FStorageOrgUnitID ");
            sqlAll.append(" where a.FISDEFAULT =1 and a.fbasestatus = 4 and c.fstatus = 1 ");
            sqlAll.append(" and d.FExpandStrategy = 20");
            sqlAll.append(" and b.feffectivedate <= now() and b.fdisabledate >=  now() ");
            if (calculateScale == SupplyMaterialCalculateScaleEnum.productLineSupplyMaterial) {
                if (materialFilter.trim() != null || materialFilter.trim().length() != 0) {
                    sqlAll.append(" and ").append(materialFilter);
                }
            } else if (calculateScale == SupplyMaterialCalculateScaleEnum.finePur) {
                sqlAll.append(" and ((c.fmaterialattr = 10050 and c.FIssMode = 11050) or (c.fmaterialattr = 10040)) ");
            }
            if (materialRange.getValue() == 30) {
                materialIDArray = new String[matEntrys.size()];
                for (int i = 0; i < matEntrys.size(); ++i) {
                    matEntryInfo = matEntrys.get(i);
                    materialID = matEntryInfo.getMaterial().getId().toString();
                    materialIDArray[i] = materialID;
                }
                materialIDStr = StringUtils.arrayToString((Object[])materialIDArray, (String)"','");
                sqlAll.append(" and b.fmaterialid in ('" + materialIDStr + "') ");
            }
            IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sqlAll.toString());
            while (rows.next()) {
                double childBaseQty;
                double childQty;
                String planVersionID = rows.getString("FPlanVersionID");
                String storageOrgUnitID = rows.getString("FStorageOrgUnitID");
                String workShopID = rows.getString("FWorkShopID");
                String productLineID = rows.getString("FProductLineID");
                String materialID2 = rows.getString("FMaterialID");
                String sourceBillID = rows.getString("FSourceBillID");
                java.util.Date beginDate = rows.getDate("FBeginDate");
                int srcType = rows.getInt("FSrcType");
                BigDecimal qty = rows.getBigDecimal("FQty");
                BigDecimal baseQty = rows.getBigDecimal("FBaseQty");
                int leadtime = rows.getInt("Fleadtime");
                int consumetype = rows.getInt("FConsumetype");
                int issMode = rows.getInt("FIssMode");
                int issLeadTime = rows.getInt("FIssLeadTime");
                String unitId = rows.getString("FUnitId");
                BigDecimal consumeFixQty = rows.getBigDecimal("FConsumeFixQty");
                BigDecimal productqty = rows.getBigDecimal("FProductQty");
                BigDecimal consumeFixBaseQty = rows.getBigDecimal("FConsumeFixBaseQty");
                BigDecimal productBaseqty = rows.getBigDecimal("FProductBaseqty");
                BigDecimal proportion = rows.getBigDecimal("Fproportion");
                BigDecimal baseproductrate = rows.getBigDecimal("FBaseproductrate");
                BigDecimal baserate = rows.getBigDecimal("FBaserate");
                BigDecimal scrapRatio = rows.getBigDecimal("FScrapRatio");
                int scrapRateExpression = rows.getInt("FScrapRateExpression");
                double productQty = 0.0;
                double productBaseQty = 0.0;
                if (scrapRateExpression == 10610) {
                    productQty = qty.doubleValue() / (1.0 - scrapRatio.doubleValue() / 100.0);
                    productBaseQty = baseQty.doubleValue() / (1.0 - scrapRatio.doubleValue() / 100.0);
                } else if (scrapRateExpression == 10620) {
                    productQty = qty.doubleValue() * (1.0 + scrapRatio.doubleValue() / 100.0);
                    productBaseQty = baseQty.doubleValue() * (1.0 + scrapRatio.doubleValue() / 100.0);
                }
                if (consumetype == 20) {
                    childQty = productQty * (consumeFixQty.doubleValue() / productqty.doubleValue());
                    childBaseQty = productBaseQty * (consumeFixBaseQty.doubleValue() / productBaseqty.doubleValue());
                } else {
                    childBaseQty = productBaseQty * (proportion.doubleValue() / 100.0) / baseproductrate.doubleValue();
                    childQty = childBaseQty / baserate.doubleValue();
                }
                Calendar cal = Calendar.getInstance();
                cal.setTime(beginDate);
                cal.add(5, leadtime);
                cal.add(5, -issLeadTime);
                beginDate = cal.getTime();
                batchStatement.setString(1, planVersionID);
                batchStatement.setString(2, storageOrgUnitID);
                batchStatement.setString(3, workShopID);
                batchStatement.setString(4, productLineID);
                batchStatement.setString(5, materialID2);
                batchStatement.setDate(6, new Date(beginDate.getTime()));
                batchStatement.setDouble(7, childQty);
                batchStatement.setString(8, unitId);
                batchStatement.setDouble(9, childBaseQty);
                batchStatement.setInt(10, issMode);
                batchStatement.setInt(11, srcType);
                batchStatement.setString(12, sourceBillID);
                batchStatement.addBatch();
            }
            batchStatement.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(batchStatement, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)batchStatement, (Connection)conn);
        return gRuqTableName;
    }

    private String getInsertExpandSQL(String ruqValueTable) {
        String insertSQL = "INSERT INTO " + ruqValueTable + "(FProductQty,FProductBaseqty,FYield,FParentMaterialID,Fproportion,FBaseproductrate,FBaserate,Fleadtime,FConsumetype,FConsumeFixQty,FConsumeFixBaseQty,FMaterialID,FUnitId,FScrapRatio,FIssMode,FIssLeadTime,FScrapRateExpression,FPLSEntryID,FPlanVersionID,FStorageOrgUnitID,FWorkShopID,FProductLineID,FBeginDate,FQty,FSrcType,FSourceBillID,FBaseQty) \n";
        return insertSQL;
    }

    private String getSelectExpandSQL(String expandTable) {
        return "select FProductQty,FProductBaseqty,FYield,FParentMaterialID,Fproportion,FBaseproductrate,FBaserate,Fleadtime,FConsumetype,FConsumeFixQty,FConsumeFixBaseQty,FMaterialID,FUnitId,FScrapRatio,FIssMode,FIssLeadTime,FScrapRateExpression,FPlanVersionID,FStorageOrgUnitID,FWorkShopID,FProductLineID,FBeginDate,FQty,FSrcType,FSourceBillID,FBaseQty \nfrom " + expandTable + "\n";
    }

    private String createExpandTable() {
        String createGrossReqValues = "CREATE TABLE tempExpandItems(FProductQty Numeric(21,8),FProductBaseqty Numeric(21,8),FYield Numeric(21,8),FParentMaterialID VARCHAR(44),Fproportion Numeric(21,8),FBaseproductrate Numeric(21,8),FBaserate Numeric(21,8),Fleadtime INT,FConsumetype INT,FConsumeFixQty Numeric(21,8),FConsumeFixBaseQty Numeric(21,8),FMaterialID VARCHAR(44),FUnitId VARCHAR(44),FScrapRatio Numeric(21,8),FIssMode INT,FIssLeadTime INT,FScrapRateExpression INT,FPLSEntryID VARCHAR(44),FPlanVersionID VARCHAR(44),FStorageOrgUnitID VARCHAR(44),FWorkShopID VARCHAR(44),FProductLineID VARCHAR(44),FBeginDate DateTime,FQty Numeric(21,8),FSrcType INT,FSourceBillID VARCHAR(44),FBaseQty NUMERIC(21,8))";
        return createGrossReqValues;
    }

    private String getExpandFormulaSQL(String ruqTableName) {
        StringBuffer sql = new StringBuffer();
        sql.append(" select ");
        sql.append(" formula.FProductQty,");
        sql.append(" formula.FProductBaseqty,");
        sql.append(" formula.FYield,");
        sql.append(" formula.FMaterialID as pMaterialID,");
        sql.append(" formulaEntry.Fproportion,");
        sql.append(" formulaEntry.FBaseproductrate,");
        sql.append(" formulaEntry.FBaserate,");
        sql.append(" formulaEntry.Fleadtime,");
        sql.append(" formulaEntry.FConsumetype,");
        sql.append(" formulaEntry.FConsumeFixQty,");
        sql.append(" formulaEntry.FConsumeFixBaseQty,");
        sql.append(" formulaEntry.FMaterialID as sMaterialID,");
        sql.append(" formulaEntry.FUnitId,");
        sql.append(" matPlan.FScrapRate as FScrapRatio,");
        sql.append(" matPlan.FIssMode,");
        sql.append(" matPlan.FIssLeadTime,");
        sql.append(" matPlan.FScrapRateExpression,");
        sql.append(" ruqTable.FPLSEntryID,");
        sql.append(" ruqTable.FPlanVersionID,");
        sql.append(" ruqTable.FStorageOrgUnitID,");
        sql.append(" ruqTable.FWorkShopID,");
        sql.append(" ruqTable.FProductLineID,");
        sql.append(" ruqTable.FBeginDate,");
        sql.append(" ruqTable.FQty,");
        sql.append(" ruqTable.FSrcType,");
        sql.append(" ruqTable.FSourceBillID,");
        sql.append(" ruqTable.FBaseQty \n");
        sql.append(" from T_MM_ProductionFormula formula \n");
        sql.append(" inner join T_MM_ProductionFormulaEntry formulaEntry on formula.FID = formulaEntry.FParentID \n");
        sql.append(" inner join T_BD_MaterialPlan matPlan on formulaEntry.FMaterialInventoyID = matPlan.FID \n");
        sql.append(" inner join " + ruqTableName + " ruqTable on ruqTable.FMaterialID = formula.FMaterialid ");
        sql.append(" and ruqTable.FProductLineID = formula.FProductLineID and ruqTable.FStorageOrgUnitID = formula.FStorageOrgUnitID \n");
        sql.append(" where formula.FBaseStatus = 4");
        sql.append(" and matPlan.FStatus = 1 \n");
        sql.append(" and (");
        sql.append(" \t(ruqTable.FFormulaID is not null and ruqTable.FTrackNumberID is not null and formula.FID = ruqTable.FFormulaID)");
        sql.append(" \tor (ruqTable.FTrackNumberID is not null and ruqTable.FFormulaID is null and formula.FTrackID = ruqTable.FTrackNumberID)");
        sql.append(" \tor (ruqTable.FTrackNumberID is null and formula.FISDEFAULT =1)");
        sql.append(" ) \n");
        sql.append(" and ruqTable.FExpandStrategy = 20 \n");
        sql.append(" and formulaEntry.feffectivedate <= now() and formulaEntry.fdisabledate >=  now() \n");
        if (this.calculateScale == SupplyMaterialCalculateScaleEnum.productLineSupplyMaterial) {
            sql.append(" and ((matPlan.FMaterialAttr = 10050 or matPlan.FMaterialAttr = 10040) and matPlan.FIssMode = 11050) \n");
        } else if (this.calculateScale == SupplyMaterialCalculateScaleEnum.finePur) {
            sql.append(" and ((matPlan.FMaterialAttr = 10050 and matPlan.FIssMode = 11050) or (matPlan.FMaterialAttr = 10040)) \n");
        }
        if (MaterialRangeEnum.CUSTOM.equals((Object)this.planVersionSetInfo.getMaterialRange())) {
            PlanVersionSetMatEntryCollection matEntrys = this.planVersionSetInfo.getMatEntrys();
            Object[] materialIDArray = new String[matEntrys.size()];
            for (int i = 0; i < matEntrys.size(); ++i) {
                PlanVersionSetMatEntryInfo matEntryInfo = matEntrys.get(i);
                String materialID = matEntryInfo.getMaterial().getId().toString();
                materialIDArray[i] = materialID;
            }
            String materialIDStr = StringUtils.arrayToString((Object[])materialIDArray, (String)"','");
            sql.append(" and formulaEntry.FMaterialID in ('" + materialIDStr + "') \n");
        }
        return sql.toString();
    }

    private String getExpandBomSQL(String ruqTableName, BOMTypeEnum bomType, StringBuffer insertedPLSEntryIDs) {
        StringBuffer sql = new StringBuffer();
        boolean isOrderBom = BOMTypeEnum.OrderBOM.equals((Object)bomType);
        sql.append(" select ");
        sql.append(" bom.FProductQty,");
        sql.append(" bom.FProductBaseqty,");
        sql.append(" bom.FYield,");
        sql.append(" bom.FMaterialID as pMaterialID,");
        sql.append(" bomEntry.Fproportion,");
        sql.append(" bomEntry.FBaseproductrate,");
        sql.append(" bomEntry.FBaserate,");
        sql.append(" bomEntry.Fleadtime,");
        sql.append(" bomEntry.FConsumetype,");
        sql.append(" bomEntry.FConsumeFixQty,");
        sql.append(" bomEntry.FConsumeFixBaseQty,");
        sql.append(" bomEntry.FMaterialID as sMaterialID,");
        sql.append(" bomEntry.FUnitId,");
        sql.append(" bomEntry.FScrapRatio,");
        sql.append(" matPlan.FIssMode,");
        sql.append(" matPlan.FIssLeadTime,");
        sql.append(" matPlan.FScrapRateExpression,");
        sql.append(" ruqTable.FPLSEntryID,");
        sql.append(" ruqTable.FPlanVersionID,");
        sql.append(" ruqTable.FStorageOrgUnitID,");
        sql.append(" ruqTable.FWorkShopID,");
        sql.append(" ruqTable.FProductLineID,");
        sql.append(" ruqTable.FBeginDate,");
        sql.append(" ruqTable.FQty,");
        sql.append(" ruqTable.FSrcType,");
        sql.append(" ruqTable.FSourceBillID,");
        sql.append(" ruqTable.FBaseQty \n");
        sql.append(" from T_MM_BOM as bom \n");
        sql.append(" inner join T_MM_BOMEntry as bomEntry on bom.FID = bomEntry.FParentID \n");
        sql.append(" inner join T_BD_MaterialPlan as matPlan on bomEntry.FMaterialInventoID = matPlan.FID \n");
        if (isOrderBom) {
            sql.append(" inner join T_MM_OrderBOMPT as orderBomT on orderBomT.FOrderID = bom.FID \n");
        }
        sql.append(" inner join " + ruqTableName + " as ruqTable");
        sql.append(" on ruqTable.FMaterialID = bom.FMaterialID and ruqTable.FStorageOrgUnitID = bom.FStorageOrgUnitID \n");
        sql.append(" where bom.FBaseStatus = 4");
        if (isOrderBom) {
            sql.append(" and bom.FBomType = 45");
        } else {
            sql.append(" and bom.FBomType = 40");
            sql.append(" and bom.FUsageType = 10");
            if (insertedPLSEntryIDs != null && insertedPLSEntryIDs.length() > 0) {
                sql.append(" and ruqTable.FPLSEntryID not in (" + insertedPLSEntryIDs + ")");
            }
        }
        sql.append(" and bomEntry.FEffectiveDate <= now() and bomEntry.FDisableDate >=  now() \n");
        if (MaterialRangeEnum.CUSTOM.equals((Object)this.planVersionSetInfo.getMaterialRange())) {
            PlanVersionSetMatEntryCollection matEntrys = this.planVersionSetInfo.getMatEntrys();
            Object[] materialIDArray = new String[matEntrys.size()];
            for (int i = 0; i < matEntrys.size(); ++i) {
                PlanVersionSetMatEntryInfo matEntryInfo = matEntrys.get(i);
                materialIDArray[i] = matEntryInfo.getMaterial().getId().toString();
            }
            String materialIDStr = StringUtils.arrayToString((Object[])materialIDArray, (String)"','");
            sql.append(" and bomEntry.FMaterialID in ('" + materialIDStr + "') \n");
        }
        sql.append(" and matPlan.FStatus = 1");
        if (SupplyMaterialCalculateScaleEnum.productLineSupplyMaterial.equals((Object)this.calculateScale)) {
            sql.append(" and ((matPlan.FMaterialAttr = 10050 or matPlan.FMaterialAttr = 10040) and matPlan.FIssMode = 11050) \n");
        } else if (SupplyMaterialCalculateScaleEnum.finePur.equals((Object)this.calculateScale)) {
            sql.append(" and ((matPlan.FMaterialAttr = 10050 and matPlan.FIssMode = 11050) or (matPlan.FMaterialAttr = 10040)) \n");
        }
        sql.append(" and ruqTable.FExpandStrategy = 10");
        if (isOrderBom) {
            sql.append(" and (ruqTable.FTrackNumberID is not null and ruqTable.FTrackNumberID = orderBomT.FTrackID) \n");
        }
        return sql.toString();
    }

    private void productionOrderStockCal(Context ctx, String gRuqTableName) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement batchStatement = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            StringBuffer sqlBuf = new StringBuffer();
            sqlBuf.append("INSERT INTO ");
            sqlBuf.append(gRuqTableName);
            sqlBuf.append("(FPlanVersionID,");
            sqlBuf.append("FStorageOrgUnitID,");
            sqlBuf.append("FMaterialID,");
            sqlBuf.append("FBeginDate,");
            sqlBuf.append("FQty,");
            sqlBuf.append("FUnitId,");
            sqlBuf.append("FBaseQty,");
            sqlBuf.append("FIssMode,");
            sqlBuf.append("FSrcType,");
            sqlBuf.append("FSourceBillID) values(?,?,?,?,?,?,?,?,?,?) ");
            batchStatement = conn.prepareStatement(sqlBuf.toString());
            StringBuffer sqlBuffer = new StringBuffer();
            sqlBuffer.append("select c.FPlanVersionID,");
            sqlBuffer.append("c.FStorageOrgUnitID,");
            sqlBuffer.append("c.FMaterialID,");
            sqlBuffer.append("c.FIssMode,");
            sqlBuffer.append("a.FId,");
            sqlBuffer.append("a.FStartDate,");
            sqlBuffer.append("b.fqty,");
            sqlBuffer.append("b.FUnitId,");
            sqlBuffer.append("b.fbaseQty,");
            sqlBuffer.append("b.fsendOutTotalQty,");
            sqlBuffer.append("b.fbaseSendOutTotalQty,");
            sqlBuffer.append("b.FUntreadTotalQty,");
            sqlBuffer.append("b.FBaseUntreadTotalQty ");
            sqlBuffer.append("from T_MM_ProductionOrder a inner join  T_MM_ProductionOrderSEntry b on a.fid = b.FParentID ");
            sqlBuffer.append("inner join (select distinct FMaterialID,FPlanVersionID,FStorageOrgUnitID,FIssMode from ");
            sqlBuffer.append(gRuqTableName);
            sqlBuffer.append(" ) c on b.FMaterialID = c.FMaterialID and a.FStorageOrgUnitID = c.FStorageOrgUnitID ");
            sqlBuffer.append(" where (a.fSourceBillID is null and (a.fbasestatus = 4 or  a.fbasestatus = 5)) ");
            sqlBuffer.append(" or (a.fSourceBillID is not null and (a.fbasestatus = 4 or  a.fbasestatus = 5 or a.fbasestatus = 2 or a.fbasestatus = 1)) ");
            IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sqlBuffer.toString());
            while (rows.next()) {
                String planVersionID = rows.getString("FPlanVersionID");
                String storageOrgUnitID = rows.getString("FStorageOrgUnitID");
                String materialID = rows.getString("FMaterialID");
                String ID = rows.getString("FId");
                int issMode = rows.getInt("FIssMode");
                Date startDate = rows.getDate("FStartDate");
                BigDecimal qty = rows.getBigDecimal("fqty");
                String unitId = rows.getString("FUnitId");
                BigDecimal baseQty = rows.getBigDecimal("fbaseQty");
                BigDecimal sendOutTotalQty = rows.getBigDecimal("fsendOutTotalQty");
                BigDecimal baseSendOutTotalQty = rows.getBigDecimal("fbaseSendOutTotalQty");
                BigDecimal untreadTotalQty = rows.getBigDecimal("FUntreadTotalQty");
                BigDecimal baseUntreadTotalQty = rows.getBigDecimal("FBaseUntreadTotalQty");
                batchStatement.setString(1, planVersionID);
                batchStatement.setString(2, storageOrgUnitID);
                batchStatement.setString(3, materialID);
                batchStatement.setDate(4, new Date(startDate.getTime()));
                batchStatement.setDouble(5, qty.subtract(sendOutTotalQty).add(untreadTotalQty).doubleValue());
                batchStatement.setString(6, unitId);
                batchStatement.setDouble(7, baseQty.subtract(baseSendOutTotalQty).add(baseUntreadTotalQty).doubleValue());
                batchStatement.setInt(8, issMode);
                batchStatement.setInt(9, 20);
                batchStatement.setString(10, ID);
                batchStatement.addBatch();
            }
            batchStatement.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(batchStatement, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)batchStatement, (Connection)conn);
    }

    private String getSupplyBill(Context ctx, String gRuqTableName) throws BOSException, EASBizException {
        String supplyBillTableName = null;
        try {
            boolean isProjectedS = this.planVersionSetInfo.isIsProjectedS();
            int intHorizonLength = this.planVersionSetInfo.getPlanningHorizon().getHorizonLength();
            String createTableSQLSupplyBill = "CREATE TABLE tempSupplyBill (FID VARCHAR(44),FPlanVersionID VARCHAR(44),FStorageOrgUnitID VARCHAR(44),FBillType INT,FBillID  VARCHAR(44),FNumber  VARCHAR(80),FSeq  INT,FMaterialID VARCHAR(44),FDeliveryDate DateTime,FUsedDate DateTime,FQty NUMERIC(21,8),FBaseQty NUMERIC(21,8),FTotalReceiptQty NUMERIC(21,8),FTotalReceiptBaseQty NUMERIC(21,8),FIntendReceiptQty NUMERIC(21,8),FIntendReceiptBaseQty NUMERIC(21,8),FAdviseDate DateTime,FAdviseDeliveryDate DateTime,FAdjustQty NUMERIC(21,8),FAdjustBaseQty NUMERIC(21,8),FActionAdviseType INT,FUnitId VARCHAR(44))";
            supplyBillTableName = this.createTempTable(ctx, createTableSQLSupplyBill);
            if (!isProjectedS) {
                return supplyBillTableName;
            }
            StringBuffer sqlBuf = new StringBuffer();
            sqlBuf.append("insert into ");
            sqlBuf.append(supplyBillTableName);
            sqlBuf.append("(FID,FPlanVersionID,FStorageOrgUnitID,FBillType,FBillID,");
            sqlBuf.append("FNumber,FSeq,FMaterialID,FDeliveryDate,FUsedDate,FQty,FBaseQty,");
            sqlBuf.append("FTotalReceiptQty,FTotalReceiptBaseQty,FIntendReceiptQty,FIntendReceiptBaseQty,");
            sqlBuf.append("FAdviseDate,FAdviseDeliveryDate,FAdjustQty,FAdjustBaseQty,FUnitId,FActionAdviseType) ");
            sqlBuf.append("select newbosid('4E375F0B'),a.FPlanVersionID,a.FStorageOrgUnitID,");
            sqlBuf.append(30);
            sqlBuf.append(",c.FID,c.FNumber,b.fseq,b.FMaterialID,b.FProposeDeliveryDate,add_days(b.FProposeDeliveryDate,e.FRecevingLeadTime),");
            sqlBuf.append("b.FQty,b.FBaseQty,b.FOrderedQty,b.FOrderedBaseQty,b.FQty-b.FOrderedQty,b.FBaseQty-b.FOrderedBaseQty,");
            sqlBuf.append("case when add_days(b.FProposeDeliveryDate,e.FRecevingLeadTime) < now() then now() else add_days(b.FProposeDeliveryDate,e.FRecevingLeadTime) end,");
            sqlBuf.append("case when add_days(b.FProposeDeliveryDate,e.FRecevingLeadTime) < now() then add_days(now(),-1*e.FRecevingLeadTime) else b.FProposeDeliveryDate end,");
            sqlBuf.append(" b.FQty-b.FOrderedQty,b.FBaseQty-b.FOrderedBaseQty,");
            sqlBuf.append("b.FUnitId,");
            sqlBuf.append("case when to_char(add_days(b.FProposeDeliveryDate,e.FRecevingLeadTime),'yyyy-mm-dd') < to_char(now(),'yyyy-mm-dd') and b.FOrderedBaseQty = 0  then 30");
            sqlBuf.append(" when to_char(add_days(b.FProposeDeliveryDate,e.FRecevingLeadTime),'yyyy-mm-dd') < to_char(now(),'yyyy-mm-dd') and b.FOrderedBaseQty > 0  then 40 else null end ");
            sqlBuf.append("from ");
            sqlBuf.append(" (select distinct FMaterialID,FPlanVersionID,FStorageOrgUnitID,FIssMode from ");
            sqlBuf.append(gRuqTableName);
            sqlBuf.append(" ) a ");
            sqlBuf.append("inner join T_SM_PurRequestEntry b on a.FMaterialID = b.FMaterialID and a.FStorageOrgUnitID = b.FReceivedOrgUnitID ");
            sqlBuf.append("inner join T_SM_PurRequest c on c.FID = b.FParentID ");
            sqlBuf.append("inner join T_BD_MaterialPlan e on e.FMaterialID = b.FMaterialID and e.FOrgUnit = b.FStorageOrgUnitID ");
            sqlBuf.append("where ((c.FSourceBillTypeID is not null and b.fbasestatus = 2) or b.fbasestatus = 4) ");
            sqlBuf.append("and to_char(add_days(b.FProposeDeliveryDate,e.FRecevingLeadTime),'yyyy-mm-dd') <= to_char(add_days(now()," + intHorizonLength + "),'yyyy-mm-dd')");
            DbUtil.execute((Context)ctx, (String)sqlBuf.toString());
            sqlBuf = new StringBuffer();
            sqlBuf.append("insert into ");
            sqlBuf.append(supplyBillTableName);
            sqlBuf.append("(FID,FPlanVersionID,FStorageOrgUnitID,FBillType,FBillID,");
            sqlBuf.append("FNumber,FSeq,FMaterialID,FDeliveryDate,FUsedDate,FQty,FBaseQty,");
            sqlBuf.append("FTotalReceiptQty,FTotalReceiptBaseQty,FIntendReceiptQty,FIntendReceiptBaseQty,");
            sqlBuf.append("FAdviseDate,FAdviseDeliveryDate,FAdjustQty,FAdjustBaseQty,FUnitId,FActionAdviseType) ");
            sqlBuf.append("select newbosid('4E375F0B'),a.FPlanVersionID,a.FStorageOrgUnitID,");
            sqlBuf.append(40);
            sqlBuf.append(",c.FID,c.FNumber,b.fseq,b.FMaterialID,b.FDeliveryDate,");
            sqlBuf.append("add_days(b.FDeliveryDate,e.FRecevingLeadTime),");
            sqlBuf.append("b.FQty,b.FBaseQty,b.FTotalReceiptQty,b.FTotalReceiptBaseQty,b.FQty-b.FTotalReceiptQty+b.FTotalSupplyStockQty,b.FBaseQty-b.FTotalReceiptBaseQty+b.FTotalSupplyStockBaseQty,");
            sqlBuf.append("case when add_days(b.FDeliveryDate,e.FRecevingLeadTime) < now() then now() else add_days(b.FDeliveryDate,e.FRecevingLeadTime) end,");
            sqlBuf.append("case when add_days(b.FDeliveryDate,e.FRecevingLeadTime) < now() then add_days(now(),-1*e.FRecevingLeadTime) else b.FDeliveryDate end,");
            sqlBuf.append("b.FQty-b.FTotalReceiptQty+FTotalSupplyStockQty,b.FBaseQty-b.FTotalReceiptBaseQty+FTotalSupplyStockBaseQty,");
            sqlBuf.append("b.FUnitId ,");
            sqlBuf.append("case when to_char(add_days(b.FDeliveryDate,e.FRecevingLeadTime),'yyyy-mm-dd') < to_char(now(),'yyyy-mm-dd') and b.FTotalReceiptBaseQty = 0  then 30");
            sqlBuf.append(" when to_char(add_days(b.FDeliveryDate,e.FRecevingLeadTime),'yyyy-mm-dd') < to_char(now(),'yyyy-mm-dd') and b.FTotalReceiptBaseQty > 0  then  40 else null end from ");
            sqlBuf.append(" (select distinct FMaterialID,FPlanVersionID,FStorageOrgUnitID,FIssMode from ");
            sqlBuf.append(gRuqTableName);
            sqlBuf.append(" ) a ");
            sqlBuf.append("inner join T_SM_PurOrderEntry b on a.FMaterialID = b.FMaterialID and a.FStorageOrgUnitID = b.FStorageOrgUnitID ");
            sqlBuf.append("inner join T_SM_PurOrder c on c.FID = b.FParentID ");
            sqlBuf.append("inner join T_BD_MaterialPlan e on e.FMaterialID = b.FMaterialID and e.FOrgUnit = b.FStorageOrgUnitID ");
            sqlBuf.append("where b.fbasestatus = 4 ");
            sqlBuf.append("and to_char(add_days(b.FDeliveryDate,e.FRecevingLeadTime),'yyyy-mm-dd') <= to_char(add_days(now()," + intHorizonLength + "),'yyyy-mm-dd')");
            DbUtil.execute((Context)ctx, (String)sqlBuf.toString());
            sqlBuf = new StringBuffer();
            sqlBuf.append("insert into ");
            sqlBuf.append(supplyBillTableName);
            sqlBuf.append("(FID,FPlanVersionID,FStorageOrgUnitID,FBillType,FBillID,");
            sqlBuf.append("FNumber,FSeq,FMaterialID,FDeliveryDate,FUsedDate,FQty,FBaseQty,");
            sqlBuf.append("FTotalReceiptQty,FTotalReceiptBaseQty,FIntendReceiptQty,FIntendReceiptBaseQty,");
            sqlBuf.append("FAdviseDate,FAdviseDeliveryDate,FAdjustQty,FAdjustBaseQty,FUnitId,FActionAdviseType) ");
            sqlBuf.append("select newbosid('4E375F0B'),a.FPlanVersionID,a.FStorageOrgUnitID,");
            sqlBuf.append(50);
            sqlBuf.append(",c.FID,c.FNumber,b.fseq,b.FMaterialID,b.FReceiptPlanDate,");
            sqlBuf.append("add_days(b.FReceiptPlanDate,e.FRecevingLeadTime),");
            sqlBuf.append("b.FQty,b.FBaseQty,b.FReceiptQty,b.FReceiptBaseQty,b.FQty-b.FReceiptQty,b.FBaseQty-b.FReceiptBaseQty,");
            sqlBuf.append("case when add_days(b.FReceiptPlanDate,e.FRecevingLeadTime) < now() then now() else add_days(b.FReceiptPlanDate,e.FRecevingLeadTime) end,");
            sqlBuf.append("case when add_days(b.FReceiptPlanDate,e.FRecevingLeadTime) < now() then add_days(now(),-1*e.FRecevingLeadTime) else b.FReceiptPlanDate end,");
            sqlBuf.append("b.FQty-b.FReceiptQty,b.FBaseQty-b.FReceiptBaseQty,");
            sqlBuf.append("b.FUnitId,");
            sqlBuf.append("case when to_char(add_days(b.FReceiptPlanDate,e.FRecevingLeadTime),'yyyy-mm-dd') < to_char(now(),'yyyy-mm-dd') and b.FReceiptBaseQty = 0 then 30");
            sqlBuf.append(" when to_char(add_days(b.FReceiptPlanDate,e.FRecevingLeadTime),'yyyy-mm-dd') < to_char(now(),'yyyy-mm-dd') and b.FReceiptBaseQty > 0 then 40 else null end from ");
            sqlBuf.append(" (select distinct FMaterialID,FPlanVersionID,FStorageOrgUnitID,FIssMode from ");
            sqlBuf.append(gRuqTableName);
            sqlBuf.append(" ) a ");
            sqlBuf.append("inner join T_IM_TransferOrderBillEntry b on a.FMaterialID = b.FMaterialID and a.FStorageOrgUnitID = b.FReceiveStorageOrgUnitID ");
            sqlBuf.append("inner join T_IM_TransferOrderBill c on c.FID = b.FParentID ");
            sqlBuf.append("inner join T_BD_MaterialPlan e on e.FMaterialID = b.FMaterialID and e.FOrgUnit = b.FReceiveStorageOrgUnitID ");
            sqlBuf.append("where ((c.FSourceBillTypeID is not null and b.fbasestatus = 2) or b.fbasestatus = 4) ");
            sqlBuf.append("and to_char(add_days(b.FReceiptPlanDate,e.FRecevingLeadTime),'yyyy-mm-dd') <= to_char(add_days(now()," + intHorizonLength + "),'yyyy-mm-dd')");
            DbUtil.execute((Context)ctx, (String)sqlBuf.toString());
            sqlBuf = new StringBuffer();
            sqlBuf.append("insert into ");
            sqlBuf.append(supplyBillTableName);
            sqlBuf.append("(FID,FPlanVersionID,FStorageOrgUnitID,FBillType,FBillID,");
            sqlBuf.append("FNumber,FSeq,FMaterialID,FDeliveryDate,FUsedDate,FQty,FBaseQty,");
            sqlBuf.append("FTotalReceiptQty,FTotalReceiptBaseQty,FIntendReceiptQty,FIntendReceiptBaseQty,");
            sqlBuf.append("FAdviseDate,FAdviseDeliveryDate,FAdjustQty,FAdjustBaseQty,FUnitId,FActionAdviseType) ");
            sqlBuf.append("select newbosid('4E375F0B'),a.FPlanVersionID,a.FStorageOrgUnitID,");
            sqlBuf.append(60);
            sqlBuf.append(",c.FID,c.FNumber,b.fseq,b.FMaterialID,b.FReceiptPlanDate,");
            sqlBuf.append("add_days(b.FReceiptPlanDate,e.FRecevingLeadTime),");
            sqlBuf.append("b.FQty,b.FBaseQty,b.FReceiptQty,b.FReceiptBaseQty,b.FQty-b.FReceiptQty,b.FBaseQty-b.FReceiptBaseQty,");
            sqlBuf.append("case when add_days(b.FReceiptPlanDate,e.FRecevingLeadTime) < now() then now() else add_days(b.FReceiptPlanDate,e.FRecevingLeadTime) end,");
            sqlBuf.append("case when add_days(b.FReceiptPlanDate,e.FRecevingLeadTime) < now() then add_days(now(),-1*e.FRecevingLeadTime) else b.FReceiptPlanDate end,");
            sqlBuf.append("b.FQty-b.FReceiptQty,b.FBaseQty-b.FReceiptBaseQty,");
            sqlBuf.append("b.FUnitId,");
            sqlBuf.append("case when to_char(add_days(b.FReceiptPlanDate,e.FRecevingLeadTime),'yyyy-mm-dd') < to_char(now(),'yyyy-mm-dd') and b.FReceiptBaseQty = 0 then 30");
            sqlBuf.append("  when to_char(add_days(b.FReceiptPlanDate,e.FRecevingLeadTime),'yyyy-mm-dd') < to_char(now(),'yyyy-mm-dd') and b.FReceiptBaseQty > 0 then 40 else null end from ");
            sqlBuf.append(" (select distinct FMaterialID,FPlanVersionID,FStorageOrgUnitID,FIssMode from ");
            sqlBuf.append(gRuqTableName);
            sqlBuf.append(" ) a ");
            sqlBuf.append("inner join T_IM_StockTransferBillEntry b on a.FMaterialID = b.FMaterialID ");
            sqlBuf.append("inner join T_IM_StockTransferBill c on c.FID = b.FParentID and a.FStorageOrgUnitID = c.FReceiptStorageOrgUnitID ");
            sqlBuf.append("inner join T_BD_MaterialPlan e on e.FMaterialID = b.FMaterialID and e.FOrgUnit = c.FReceiptStorageOrgUnitID ");
            sqlBuf.append("where c.FReceiptStorageOrgUnitID <> c.FIssueStorageOrgUnitID and ((c.FSourceBillTypeID is not null and b.fbasestatus = 2) or b.fbasestatus = 4) ");
            sqlBuf.append("and to_char(add_days(b.FReceiptPlanDate,e.FRecevingLeadTime),'yyyy-mm-dd') <= to_char(add_days(now()," + intHorizonLength + "),'yyyy-mm-dd')");
            DbUtil.execute((Context)ctx, (String)sqlBuf.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return supplyBillTableName;
    }

    private String getRefinedStockPlan(Context ctx, HashMap materialPlanInfoMap, HashMap materialInventoryInfoMap, HashMap materialMultiMeasureUnitMap, HashMap gRuqQtyMap, String gRuqTableName, String supplyBillTableName, HashMap leavingsDataMap) throws BOSException, EASBizException {
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
        ArrayList refinedStockList = new ArrayList();
        String refinedStockPlanTableName = null;
        try {
            String createTableSQLRefinedStockPlan = "CREATE TABLE tempRefinedStockPlan (FPlanVersionID VARCHAR(44),FStorageOrgUnitID VARCHAR(44),FMaterialID VARCHAR(44),FRefinedStockDate DateTime,FGRuqQty NUMERIC(21,8),FGRuqBaseQty NUMERIC(21,8),FQtySafety NUMERIC(21,8),FBaseQtySafety NUMERIC(21,8),FCurStoreQty NUMERIC(21,8),FCurStoreBaseQty NUMERIC(21,8),FRuqQty NUMERIC(21,8),FRuqBaseQty NUMERIC(21,8),FInitSupplyQty NUMERIC(21,8),FSupplyQty NUMERIC(21,8),FSupplyBaseQty NUMERIC(21,8),FPreUseQty NUMERIC(21,8),FPreUseBaseQty NUMERIC(21,8),FAdvisePurQty NUMERIC(21,8),FAdvisePurBaseQty NUMERIC(21,8),FAdvisePurDate DateTime,FUnitId VARCHAR(44),FPutIn  INT )";
            refinedStockPlanTableName = this.createTempTable(ctx, createTableSQLRefinedStockPlan);
            WarehouseRangeEnum warehouseRange = this.planVersionSetInfo.getWarehouseRange();
            int intHorizonLength = this.planVersionSetInfo.getPlanningHorizon().getHorizonLength();
            HashMap initStoreMap = this.getInitStore(ctx, warehouseRange);
            StringBuffer sqlBuf = new StringBuffer();
            sqlBuf.append("select FPlanVersionID,FStorageOrgUnitID,FMaterialID from ");
            sqlBuf.append(gRuqTableName);
            sqlBuf.append(" group by FPlanVersionID,FStorageOrgUnitID,FMaterialID ");
            IRowSet gRuqRows = DbUtil.executeQuery((Context)ctx, (String)sqlBuf.toString());
            while (gRuqRows.next()) {
                String planVersionId = gRuqRows.getString("FPlanVersionID");
                String materialId = gRuqRows.getString("FMaterialID");
                String storageOrgUnitId = gRuqRows.getString("FStorageOrgUnitID");
                MaterialPlanInfo materialPlanInfo = (MaterialPlanInfo)materialPlanInfoMap.get(materialId);
                MaterialInventoryInfo materialInventoryInfo = (MaterialInventoryInfo)materialInventoryInfoMap.get(materialId);
                if (materialPlanInfo == null || materialInventoryInfo == null) continue;
                MeasureUnitInfo measureUnitInfo = materialPlanInfo.getProductUnit();
                String unitId = measureUnitInfo.getId().toString();
                String key = materialId + ROW_KEY_SPLIT + unitId;
                MultiMeasureUnitInfo multiUnifInfo = (MultiMeasureUnitInfo)materialMultiMeasureUnitMap.get(key);
                BigDecimal baseConvsRate = multiUnifInfo.getBaseConvsRate();
                int precision = multiUnifInfo.getQtyPrecision();
                int recevingLeadTime = materialPlanInfo.getRecevingLeadTime();
                int forwardProcessTime = materialPlanInfo.getForwardProcessTime();
                int produceLeadTime = materialPlanInfo.getProduceLeadTime();
                int backwardProcessTime = materialPlanInfo.getBackwardProcessTime();
                BigDecimal initStore = (BigDecimal)initStoreMap.get(materialId);
                if (initStore == null) {
                    initStore = new BigDecimal(0);
                }
                BigDecimal qtySafety = materialInventoryInfo.getQtySafety();
                BigDecimal qtyMax = materialInventoryInfo.getQtyMax();
                qtySafety = this.transQty(ctx, qtySafety, materialInventoryInfo, materialMultiMeasureUnitMap);
                qtyMax = this.transQty(ctx, qtyMax, materialInventoryInfo, materialMultiMeasureUnitMap);
                BigDecimal curStoreQty = initStore;
                BigDecimal preUseQty = initStore;
                java.util.Date startDate = new java.util.Date();
                java.util.Date endDate = this.addDate(startDate, intHorizonLength);
                java.util.Date curDate = startDate;
                String strCurDate = sf.format(curDate);
                ArrayList everyMaterialList = (ArrayList)leavingsDataMap.get(materialId);
                do {
                    ArrayList updateSupplyBillList = new ArrayList();
                    ArrayList splitSupplyBillList = new ArrayList();
                    BigDecimal curUseableQty = preUseQty;
                    HashMap<String, Object> refinedStockMap = new HashMap<String, Object>();
                    java.util.Date advisePurDate = null;
                    BigDecimal advisePurQty = new BigDecimal(0);
                    BigDecimal gRuqQty = this.getGRuqQty(ctx, everyMaterialList, strCurDate);
                    BigDecimal supplyQty = this.getSupplyQty(ctx, everyMaterialList, strCurDate);
                    BigDecimal initSupplyQty = this.getInitSupplyQty(ctx, everyMaterialList, strCurDate);
                    BigDecimal ruqQty = gRuqQty.subtract(preUseQty).subtract(supplyQty).add(qtySafety);
                    if (this.isInteAdjust) {
                        java.util.Date adviseDeliveryDate;
                        java.util.Date adviseDate;
                        BigDecimal adjustQty;
                        IRowSet rows;
                        java.util.Date fromDate = this.addDate(curDate, 1);
                        java.util.Date toDate = this.addDate(fromDate, this.forwardDay);
                        String strFromDate = sf.format(fromDate);
                        String strToDate = sf.format(toDate);
                        BigDecimal leavingsSumQty = this.getSumLeavingsQty(ctx, everyMaterialList, strFromDate, strToDate);
                        if (ruqQty.compareTo(new BigDecimal(0)) > 0) {
                            if (leavingsSumQty.compareTo(ruqQty) >= 0) {
                                java.util.Date firDate = this.getFirDateByLeavingsQty(ctx, everyMaterialList, strCurDate);
                                while (ruqQty.compareTo(new BigDecimal(0)) > 0 && firDate != null) {
                                    String strFirDate = sf.format(firDate);
                                    BigDecimal leavingsQty = this.getLeavingsQty(ctx, leavingsDataMap, materialId, strFirDate);
                                    BigDecimal advanceQty = null;
                                    advanceQty = leavingsQty.compareTo(ruqQty) < 0 ? leavingsQty : ruqQty;
                                    ruqQty = ruqQty.subtract(advanceQty);
                                    leavingsQty = leavingsQty.subtract(advanceQty);
                                    supplyQty = supplyQty.add(advanceQty);
                                    rows = this.getSupplyBillOrderAdance(ctx, supplyBillTableName, materialId, strFirDate);
                                    while (rows.next() && advanceQty.compareTo(new BigDecimal(0)) > 0) {
                                        HashMap<String, Object> supplyBillMap;
                                        adjustQty = rows.getBigDecimal("FAdjustBaseQty");
                                        String strId = rows.getString("FID");
                                        BigDecimal baseBillQty = rows.getBigDecimal("FBaseQty");
                                        if (baseBillQty.compareTo(adjustQty) > 0 && !this.isPartAdjust) continue;
                                        if (adjustQty.compareTo(advanceQty) <= 0) {
                                            adviseDate = curDate;
                                            adviseDeliveryDate = this.addDate(adviseDate, -recevingLeadTime);
                                            HashMap<String, Object> supplyBillMap2 = new HashMap<String, Object>();
                                            supplyBillMap2.put("id", strId);
                                            supplyBillMap2.put("adviseDate", adviseDate);
                                            supplyBillMap2.put("adviseDeliveryDate", adviseDeliveryDate);
                                            if (baseBillQty.compareTo(adjustQty) > 0) {
                                                supplyBillMap2.put("actionAdviseType", (Object)ActionAdviseTypeEnum.PartAdvance);
                                            } else {
                                                supplyBillMap2.put("actionAdviseType", (Object)ActionAdviseTypeEnum.WholeAdvance);
                                            }
                                            updateSupplyBillList.add(supplyBillMap2);
                                            advanceQty = advanceQty.subtract(adjustQty);
                                            continue;
                                        }
                                        if (this.isPartAdjust) {
                                            adviseDate = curDate;
                                            adviseDeliveryDate = this.addDate(adviseDate, -recevingLeadTime);
                                            BigDecimal changeQty = advanceQty.divide(baseConvsRate, 4);
                                            supplyBillMap = new HashMap<String, Object>();
                                            supplyBillMap.put("id", strId);
                                            supplyBillMap.put("adviseDate", adviseDate);
                                            supplyBillMap.put("adviseDeliveryDate", adviseDeliveryDate);
                                            supplyBillMap.put("actionAdviseType", (Object)ActionAdviseTypeEnum.PartAdvance);
                                            supplyBillMap.put("changeBaseQty", advanceQty);
                                            supplyBillMap.put("changeQty", changeQty);
                                            splitSupplyBillList.add(supplyBillMap);
                                            advanceQty = new BigDecimal(0);
                                            continue;
                                        }
                                        if (baseBillQty.compareTo(adjustQty) != 0) continue;
                                        BigDecimal adjustAddQty = adjustQty.subtract(advanceQty);
                                        if (qtyMax.compareTo(new BigDecimal(0)) > 0 && qtySafety.add(adjustAddQty).compareTo(qtyMax) >= 0) continue;
                                        java.util.Date adviseDate2 = curDate;
                                        java.util.Date adviseDeliveryDate2 = this.addDate(adviseDate2, -recevingLeadTime);
                                        supplyBillMap = new HashMap();
                                        supplyBillMap.put("id", strId);
                                        supplyBillMap.put("adviseDate", adviseDate2);
                                        supplyBillMap.put("adviseDeliveryDate", adviseDeliveryDate2);
                                        supplyBillMap.put("actionAdviseType", (Object)ActionAdviseTypeEnum.WholeAdvance);
                                        updateSupplyBillList.add(supplyBillMap);
                                        ruqQty = ruqQty.subtract(adjustAddQty);
                                        supplyQty = supplyQty.add(adjustAddQty);
                                        leavingsQty = leavingsQty.subtract(adjustAddQty);
                                        advanceQty = new BigDecimal(0);
                                        break;
                                    }
                                    if (advanceQty.compareTo(new BigDecimal(0)) > 0) {
                                        ruqQty = ruqQty.add(advanceQty);
                                        leavingsQty = leavingsQty.add(advanceQty);
                                        supplyQty = supplyQty.subtract(advanceQty);
                                    }
                                    this.updateLeavingsQty(ctx, everyMaterialList, precision, strFirDate, leavingsQty, baseConvsRate);
                                    firDate = this.getFirDateByLeavingsQty(ctx, everyMaterialList, strFirDate);
                                }
                                if (ruqQty.compareTo(new BigDecimal(0)) > 0) {
                                    advisePurQty = this.batchJudge(ruqQty, materialPlanInfo);
                                } else {
                                    ruqQty = new BigDecimal(0);
                                    advisePurQty = new BigDecimal(0);
                                }
                            } else {
                                advisePurQty = this.batchJudge(ruqQty, materialPlanInfo);
                            }
                        } else {
                            advisePurQty = new BigDecimal(0);
                            ruqQty = new BigDecimal(0);
                            curUseableQty = preUseQty.add(supplyQty).subtract(gRuqQty);
                            if (qtyMax.compareTo(new BigDecimal(0)) > 0 && curUseableQty.compareTo(qtyMax) > 0) {
                                if (leavingsSumQty.compareTo(new BigDecimal(0)) >= 0) {
                                    BigDecimal cancalQty = curUseableQty.subtract(qtySafety);
                                    supplyQty = supplyQty.subtract(cancalQty);
                                    curUseableQty = curUseableQty.subtract(cancalQty);
                                    IRowSet rows2 = this.getSupplyBillOrderCancel(ctx, supplyBillTableName, materialId, strCurDate);
                                    while (rows2.next() && cancalQty.compareTo(new BigDecimal(0)) > 0) {
                                        HashMap<String, Object> supplyBillMap;
                                        BigDecimal adjustQty2 = rows2.getBigDecimal("FAdjustBaseQty");
                                        int oldActionAdviseType = rows2.getInt("FActionAdviseType");
                                        BigDecimal qty = rows2.getBigDecimal("FBaseQty");
                                        Date adviseDate3 = rows2.getDate("FAdviseDate");
                                        Date adviseDeliveryDate3 = rows2.getDate("FAdviseDeliveryDate");
                                        if (qty.compareTo(adjustQty2) > 0 && !this.isPartAdjust) continue;
                                        String strId = rows2.getString("FID");
                                        if (adjustQty2.compareTo(cancalQty) <= 0) {
                                            if (qty.compareTo(adjustQty2) == 0) {
                                                supplyBillMap = new HashMap<String, Object>();
                                                supplyBillMap.put("id", strId);
                                                supplyBillMap.put("adviseDate", adviseDate3);
                                                supplyBillMap.put("adviseDeliveryDate", adviseDeliveryDate3);
                                                supplyBillMap.put("actionAdviseType", (Object)ActionAdviseTypeEnum.WholeCancel);
                                                updateSupplyBillList.add(supplyBillMap);
                                            } else {
                                                supplyBillMap = new HashMap();
                                                supplyBillMap.put("id", strId);
                                                supplyBillMap.put("adviseDate", adviseDate3);
                                                supplyBillMap.put("adviseDeliveryDate", adviseDeliveryDate3);
                                                supplyBillMap.put("actionAdviseType", (Object)ActionAdviseTypeEnum.PartCancel);
                                                updateSupplyBillList.add(supplyBillMap);
                                            }
                                            cancalQty = cancalQty.subtract(adjustQty2);
                                            continue;
                                        }
                                        if (!this.isPartAdjust) continue;
                                        if (oldActionAdviseType == 30 || oldActionAdviseType == 40) {
                                            supplyBillMap = new HashMap();
                                            supplyBillMap.put("id", strId);
                                            supplyBillMap.put("adviseDate", adviseDate3);
                                            supplyBillMap.put("adviseDeliveryDate", adviseDeliveryDate3);
                                            supplyBillMap.put("actionAdviseType", (Object)ActionAdviseTypeEnum.PartStay);
                                            updateSupplyBillList.add(supplyBillMap);
                                        }
                                        BigDecimal changeQty = cancalQty.divide(baseConvsRate, 4);
                                        HashMap<String, Object> supplyBillMap3 = new HashMap<String, Object>();
                                        supplyBillMap3.put("id", strId);
                                        supplyBillMap3.put("adviseDate", adviseDate3);
                                        supplyBillMap3.put("adviseDeliveryDate", adviseDeliveryDate3);
                                        supplyBillMap3.put("actionAdviseType", (Object)ActionAdviseTypeEnum.PartCancel);
                                        supplyBillMap3.put("changeBaseQty", cancalQty);
                                        supplyBillMap3.put("changeQty", changeQty);
                                        splitSupplyBillList.add(supplyBillMap3);
                                        cancalQty = new BigDecimal(0);
                                        break;
                                    }
                                    supplyQty = supplyQty.add(cancalQty);
                                } else {
                                    BigDecimal stayQty = curUseableQty.subtract(qtySafety);
                                    BigDecimal realStayQty = new BigDecimal(0);
                                    supplyQty = supplyQty.subtract(stayQty);
                                    String strNextDate = sf.format(this.addDate(curDate, 1));
                                    BigDecimal leavingsQty = this.getLeavingsQty(ctx, leavingsDataMap, materialId, strNextDate);
                                    rows = this.getSupplyBillOrderStay(ctx, supplyBillTableName, materialId, strCurDate);
                                    while (rows.next() && stayQty.compareTo(new BigDecimal(0)) > 0) {
                                        HashMap<String, Object> supplyBillMap;
                                        BigDecimal changeQty;
                                        HashMap<String, Object> supplyBillMap4;
                                        adjustQty = rows.getBigDecimal("FAdjustBaseQty");
                                        int oldActionAdviseType = rows.getInt("FActionAdviseType");
                                        BigDecimal qty = rows.getBigDecimal("FBaseQty");
                                        adviseDate = rows.getDate("FAdviseDate");
                                        adviseDeliveryDate = rows.getDate("FAdviseDeliveryDate");
                                        Date usedDate = rows.getDate("FUsedDate");
                                        if (qty.compareTo(adjustQty) > 0 && !this.isPartAdjust) continue;
                                        String strId = rows.getString("FID");
                                        if (adjustQty.compareTo(stayQty) <= 0) {
                                            adviseDate = this.addDate(adviseDate, 1);
                                            adviseDeliveryDate = this.addDate(adviseDate, -recevingLeadTime);
                                            if (adviseDate.after(this.addDate(usedDate, this.backDay))) {
                                                adviseDate = this.addDate(adviseDate, -1);
                                                adviseDeliveryDate = this.addDate(adviseDate, -recevingLeadTime);
                                                if (qty.compareTo(adjustQty) == 0) {
                                                    supplyBillMap4 = new HashMap();
                                                    supplyBillMap4.put("id", strId);
                                                    supplyBillMap4.put("adviseDate", adviseDate);
                                                    supplyBillMap4.put("adviseDeliveryDate", adviseDeliveryDate);
                                                    supplyBillMap4.put("actionAdviseType", (Object)ActionAdviseTypeEnum.WholeCancel);
                                                    updateSupplyBillList.add(supplyBillMap4);
                                                } else {
                                                    supplyBillMap4 = new HashMap();
                                                    supplyBillMap4.put("id", strId);
                                                    supplyBillMap4.put("adviseDate", adviseDate);
                                                    supplyBillMap4.put("adviseDeliveryDate", adviseDeliveryDate);
                                                    supplyBillMap4.put("actionAdviseType", (Object)ActionAdviseTypeEnum.PartCancel);
                                                    updateSupplyBillList.add(supplyBillMap4);
                                                }
                                            } else {
                                                if (qty.compareTo(adjustQty) == 0) {
                                                    supplyBillMap4 = new HashMap();
                                                    supplyBillMap4.put("id", strId);
                                                    supplyBillMap4.put("adviseDate", adviseDate);
                                                    supplyBillMap4.put("adviseDeliveryDate", adviseDeliveryDate);
                                                    supplyBillMap4.put("actionAdviseType", (Object)ActionAdviseTypeEnum.WholeStay);
                                                    updateSupplyBillList.add(supplyBillMap4);
                                                } else {
                                                    supplyBillMap4 = new HashMap();
                                                    supplyBillMap4.put("id", strId);
                                                    supplyBillMap4.put("adviseDate", adviseDate);
                                                    supplyBillMap4.put("adviseDeliveryDate", adviseDeliveryDate);
                                                    supplyBillMap4.put("actionAdviseType", (Object)ActionAdviseTypeEnum.PartStay);
                                                    updateSupplyBillList.add(supplyBillMap4);
                                                }
                                                realStayQty = realStayQty.add(adjustQty);
                                            }
                                            stayQty = stayQty.subtract(adjustQty);
                                            continue;
                                        }
                                        if (!this.isPartAdjust) continue;
                                        if (oldActionAdviseType == 30 || oldActionAdviseType == 40) {
                                            supplyBillMap4 = new HashMap<String, Object>();
                                            supplyBillMap4.put("id", strId);
                                            supplyBillMap4.put("adviseDate", adviseDate);
                                            supplyBillMap4.put("adviseDeliveryDate", adviseDeliveryDate);
                                            supplyBillMap4.put("actionAdviseType", (Object)ActionAdviseTypeEnum.PartStay);
                                            updateSupplyBillList.add(supplyBillMap4);
                                        }
                                        adviseDate = this.addDate(adviseDate, 1);
                                        adviseDeliveryDate = this.addDate(adviseDate, -recevingLeadTime);
                                        if (adviseDate.after(this.addDate(usedDate, this.backDay))) {
                                            changeQty = stayQty.divide(baseConvsRate, 4);
                                            adviseDate = this.addDate(adviseDate, -1);
                                            adviseDeliveryDate = this.addDate(adviseDate, -recevingLeadTime);
                                            supplyBillMap = new HashMap();
                                            supplyBillMap.put("id", strId);
                                            supplyBillMap.put("adviseDate", this.addDate(adviseDate, -1));
                                            supplyBillMap.put("adviseDeliveryDate", adviseDeliveryDate);
                                            supplyBillMap.put("actionAdviseType", (Object)ActionAdviseTypeEnum.PartCancel);
                                            supplyBillMap.put("changeBaseQty", stayQty);
                                            supplyBillMap.put("changeQty", changeQty);
                                            splitSupplyBillList.add(supplyBillMap);
                                        } else {
                                            changeQty = stayQty.divide(baseConvsRate, 4);
                                            supplyBillMap = new HashMap<String, Object>();
                                            supplyBillMap.put("id", strId);
                                            supplyBillMap.put("adviseDate", adviseDate);
                                            supplyBillMap.put("adviseDeliveryDate", adviseDeliveryDate);
                                            supplyBillMap.put("actionAdviseType", (Object)ActionAdviseTypeEnum.PartStay);
                                            supplyBillMap.put("changeBaseQty", stayQty);
                                            supplyBillMap.put("changeQty", changeQty);
                                            splitSupplyBillList.add(supplyBillMap);
                                            realStayQty = realStayQty.add(stayQty);
                                        }
                                        stayQty = new BigDecimal(0);
                                        break;
                                    }
                                    supplyQty = supplyQty.add(stayQty);
                                    if (realStayQty.compareTo(new BigDecimal(0)) > 0) {
                                        leavingsQty = leavingsQty.add(realStayQty);
                                        this.updateLeavingsQty(ctx, everyMaterialList, precision, strNextDate, leavingsQty, baseConvsRate);
                                    }
                                }
                            }
                        }
                    } else if (ruqQty.compareTo(new BigDecimal(0)) > 0) {
                        advisePurQty = this.batchJudge(ruqQty, materialPlanInfo);
                    } else {
                        advisePurQty = new BigDecimal(0);
                        ruqQty = new BigDecimal(0);
                    }
                    if (advisePurQty.compareTo(new BigDecimal(0)) > 0) {
                        advisePurDate = this.addDate(curDate, -recevingLeadTime);
                        advisePurDate = this.addDate(advisePurDate, -forwardProcessTime);
                        advisePurDate = this.addDate(advisePurDate, -produceLeadTime);
                        advisePurDate = this.addDate(advisePurDate, -backwardProcessTime);
                    }
                    preUseQty = preUseQty.add(supplyQty).subtract(gRuqQty).add(advisePurQty);
                    BigDecimal convs_gRuqQty = gRuqQty.divide(baseConvsRate, precision, 4);
                    BigDecimal convs_qtySafety = qtySafety.divide(baseConvsRate, precision, 4);
                    BigDecimal convs_curStoreQty = curStoreQty.divide(baseConvsRate, precision, 4);
                    BigDecimal convs_ruqQty = ruqQty.divide(baseConvsRate, precision, 4);
                    BigDecimal convs_supplyQty = supplyQty.divide(baseConvsRate, precision, 4);
                    BigDecimal convs_initSupplyQty = initSupplyQty.divide(baseConvsRate, precision, 4);
                    BigDecimal convs_preUseQty = preUseQty.divide(baseConvsRate, precision, 4);
                    BigDecimal convs_advisePurQty = advisePurQty.divide(baseConvsRate, precision, 4);
                    refinedStockMap.put("planVersionID", planVersionId);
                    refinedStockMap.put("storageOrgUnitID", storageOrgUnitId);
                    refinedStockMap.put("materialId", materialId);
                    refinedStockMap.put("refinedStockDate", curDate);
                    refinedStockMap.put("gRuqQty", convs_gRuqQty);
                    refinedStockMap.put("qtySafety", convs_qtySafety);
                    refinedStockMap.put("curStoreQty", convs_curStoreQty);
                    refinedStockMap.put("ruqQty", convs_ruqQty);
                    refinedStockMap.put("initSupplyQty", convs_initSupplyQty);
                    refinedStockMap.put("supplyQty", convs_supplyQty);
                    refinedStockMap.put("preUseQty", convs_preUseQty);
                    refinedStockMap.put("advisePurQty", convs_advisePurQty);
                    refinedStockMap.put("advisePurDate", advisePurDate);
                    refinedStockMap.put("unitId", unitId);
                    refinedStockList.add(refinedStockMap);
                    this.updateSupplyBill(ctx, supplyBillTableName, updateSupplyBillList);
                    this.splitSupplyBill(ctx, supplyBillTableName, splitSupplyBillList);
                    curDate = this.addDate(curDate, 1);
                    strCurDate = sf.format(curDate);
                } while (!curDate.after(endDate));
            }
            this.insertRefinedStockPlan(ctx, refinedStockPlanTableName, refinedStockList);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        catch (BOSException e) {
            throw e;
        }
        catch (EASBizException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return refinedStockPlanTableName;
    }

    private void insertRefinedStockPlan(Context ctx, String refinedStockPlanTableName, ArrayList refinedStockPlanList) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement batchStatement = null;
        try {
            if (refinedStockPlanList.isEmpty()) {
                return;
            }
            StringBuffer sqlBuf = new StringBuffer();
            sqlBuf.append("INSERT INTO ");
            sqlBuf.append(refinedStockPlanTableName);
            sqlBuf.append("(FPlanVersionID,FStorageOrgUnitID,");
            sqlBuf.append("FMaterialID,");
            sqlBuf.append("FRefinedStockDate,");
            sqlBuf.append("FGRuqQty,");
            sqlBuf.append("FQtySafety,");
            sqlBuf.append("FCurStoreQty,");
            sqlBuf.append("FRuqQty,");
            sqlBuf.append("FInitSupplyQty,");
            sqlBuf.append("FSupplyQty,");
            sqlBuf.append("FPreUseQty,");
            sqlBuf.append("FAdvisePurQty,");
            sqlBuf.append("FAdvisePurDate,");
            sqlBuf.append("FPutIn,FUnitId) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?) ");
            conn = EJBFactory.getConnection((Context)ctx);
            batchStatement = conn.prepareStatement(sqlBuf.toString());
            int iCount = 0;
            for (int i = 0; i < refinedStockPlanList.size(); ++i) {
                BigDecimal preUseQty;
                HashMap refinedStockMap = (HashMap)refinedStockPlanList.get(i);
                String planVersionID = (String)refinedStockMap.get("planVersionID");
                String storageOrgUnitID = (String)refinedStockMap.get("storageOrgUnitID");
                String materialId = (String)refinedStockMap.get("materialId");
                java.util.Date refinedStockDate = (java.util.Date)refinedStockMap.get("refinedStockDate");
                BigDecimal gRuqQty = (BigDecimal)refinedStockMap.get("gRuqQty");
                BigDecimal qtySafety = (BigDecimal)refinedStockMap.get("qtySafety");
                BigDecimal curStoreQty = (BigDecimal)refinedStockMap.get("curStoreQty");
                BigDecimal ruqQty = (BigDecimal)refinedStockMap.get("ruqQty");
                BigDecimal initSupplyQty = (BigDecimal)refinedStockMap.get("initSupplyQty");
                BigDecimal supplyQty = (BigDecimal)refinedStockMap.get("supplyQty");
                if (initSupplyQty.compareTo(new BigDecimal(9.9999999999999E12)) > 0) {
                    initSupplyQty = new BigDecimal(9.9999999999999E12);
                }
                if (supplyQty.compareTo(new BigDecimal(9.9999999999999E12)) > 0) {
                    supplyQty = new BigDecimal(9.9999999999999E12);
                }
                if ((preUseQty = (BigDecimal)refinedStockMap.get("preUseQty")).compareTo(new BigDecimal(9.9999999999999E12)) > 0) {
                    preUseQty = new BigDecimal(9.9999999999999E12);
                }
                BigDecimal advisePurQty = (BigDecimal)refinedStockMap.get("advisePurQty");
                java.util.Date advisePurDate = (java.util.Date)refinedStockMap.get("advisePurDate");
                String unitId = (String)refinedStockMap.get("unitId");
                batchStatement.setString(1, planVersionID);
                batchStatement.setString(2, storageOrgUnitID);
                batchStatement.setString(3, materialId);
                batchStatement.setDate(4, new Date(refinedStockDate.getTime()));
                batchStatement.setBigDecimal(5, gRuqQty);
                batchStatement.setBigDecimal(6, qtySafety);
                batchStatement.setBigDecimal(7, curStoreQty);
                batchStatement.setBigDecimal(8, ruqQty);
                batchStatement.setBigDecimal(9, initSupplyQty);
                batchStatement.setBigDecimal(10, supplyQty);
                batchStatement.setBigDecimal(11, preUseQty);
                batchStatement.setBigDecimal(12, advisePurQty);
                if (advisePurDate == null) {
                    batchStatement.setDate(13, null);
                } else {
                    batchStatement.setDate(13, new Date(advisePurDate.getTime()));
                }
                batchStatement.setInt(14, 0);
                batchStatement.setString(15, unitId);
                batchStatement.addBatch();
                if (++iCount != 100) continue;
                iCount = 0;
                batchStatement.executeBatch();
            }
            if (iCount > 0) {
                batchStatement.executeBatch();
            }
            SQLUtils.cleanup((Statement)batchStatement, (Connection)conn);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup(batchStatement, conn);
        }
    }

    private HashMap getInitStore(Context ctx, WarehouseRangeEnum warehouseRange) throws BOSException, EASBizException {
        HashMap<String, BigDecimal> initStoreMap = new HashMap<String, BigDecimal>();
        PlanVersionSetEntryCollection planVersionSetentryCol = this.planVersionSetInfo.getEntrys();
        try {
            if (this.planVersionSetInfo.isIsAvailablStock()) {
                String planVersionId = this.planVersionSetInfo.getId().toString();
                StringBuffer sqlBuf = new StringBuffer();
                sqlBuf.append("select sum(a.FBaseQty) as curStoreQtySum,");
                sqlBuf.append("a.FmaterialID ");
                sqlBuf.append("from T_IM_Inventory a ");
                sqlBuf.append("inner join T_MM_PlanVersionSetStoreType b on a.FStoreTypeID = b.FStoreTypeID ");
                sqlBuf.append("inner join T_MM_PlanVersionSetStoreState c on a.FStoreStatusID = c.FStoreStateID ");
                sqlBuf.append("inner join T_MM_PlanVersionSet d on b.FParentID = d.FID ");
                sqlBuf.append("inner join T_MM_PlanVersionSet e on c.FParentID = e.FID ");
                sqlBuf.append("where b.FIsMrpRun = 1 ");
                sqlBuf.append("and c.FIsMrpRun = 1 ");
                sqlBuf.append("and d.FID = '" + planVersionId + "' ");
                sqlBuf.append("and e.FID = '" + planVersionId + "' ");
                sqlBuf.append("and a.FStorageOrgUnitID = '" + this.storageOrgID + "' ");
                if (warehouseRange.getValue() == 20) {
                    Object[] warehouseIDArray = new String[planVersionSetentryCol.size()];
                    for (int col = 0; col < planVersionSetentryCol.size(); ++col) {
                        PlanVersionSetEntryInfo planVersionSetEntryInfo = planVersionSetentryCol.get(col);
                        String warehouse = planVersionSetEntryInfo.getWarehouse().getId().toString();
                        warehouseIDArray[col] = warehouse;
                    }
                    String materialIDStr = StringUtils.arrayToString((Object[])warehouseIDArray, (String)"','");
                    sqlBuf.append(" and a.FWarehouseID in ('" + materialIDStr + "') ");
                }
                sqlBuf.append("group by a.FmaterialID");
                IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sqlBuf.toString());
                while (rows.next()) {
                    String materialId = rows.getString("FmaterialID");
                    BigDecimal initStore = rows.getBigDecimal("curStoreQtySum");
                    initStoreMap.put(materialId, initStore);
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return initStoreMap;
    }

    private BigDecimal scrapRateJudge(BigDecimal ruqQty, MaterialPlanInfo materialPlanInfo) {
        MaterialScrapRateExpressionEnum scrapRateExpression = materialPlanInfo.getScrapRateExpression();
        BigDecimal scrapRate = materialPlanInfo.getScrapRate();
        if (scrapRateExpression.equals((Object)MaterialScrapRateExpressionEnum.BYDIVIDE)) {
            ruqQty = ruqQty.divide(new BigDecimal(1).subtract(scrapRate.divide(new BigDecimal(100), 4)), 4);
        } else if (scrapRateExpression.equals((Object)MaterialScrapRateExpressionEnum.MUTIPLE)) {
            ruqQty = ruqQty.multiply(new BigDecimal(1).add(scrapRate.divide(new BigDecimal(100), 4)));
        }
        return ruqQty;
    }

    private BigDecimal batchJudge(BigDecimal ruqQty, MaterialPlanInfo materialPlanInfo) {
        BigDecimal retRuqQty = new BigDecimal(0);
        BatchPolicyEnum batchPolicy = materialPlanInfo.getBatchPolicy();
        if (batchPolicy.equals((Object)BatchPolicyEnum.FIXATIONBATCH)) {
            BigDecimal fixationBatchQty = materialPlanInfo.getFixationBatchQty();
            retRuqQty = fixationBatchQty == null || fixationBatchQty.compareTo(new BigDecimal(0)) == 0 ? ruqQty : ruqQty.divide(fixationBatchQty, 0, 0).multiply(fixationBatchQty);
        } else if (batchPolicy.equals((Object)BatchPolicyEnum.STRAIGHTBATCH) || batchPolicy.equals((Object)BatchPolicyEnum.FIXCYCLEBATCH) || batchPolicy.equals((Object)BatchPolicyEnum.DYNAMICCYCLEBATCH)) {
            BigDecimal roundUpMulitpleQty;
            BigDecimal batchIncQty;
            BigDecimal minBatchQty = materialPlanInfo.getMinBatchQty();
            if (minBatchQty == null) {
                minBatchQty = new BigDecimal(0);
            }
            if ((batchIncQty = materialPlanInfo.getBatchIncQty()) == null) {
                batchIncQty = new BigDecimal(0);
            }
            if ((roundUpMulitpleQty = materialPlanInfo.getRoundUpMulitpleQty()) == null || roundUpMulitpleQty.compareTo(new BigDecimal(0)) == 0) {
                retRuqQty = ruqQty.compareTo(minBatchQty) < 0 ? minBatchQty.add(batchIncQty) : ruqQty.add(batchIncQty);
            } else if (ruqQty.compareTo(minBatchQty) < 0) {
                BigDecimal batchMulitpleRound = minBatchQty.divide(roundUpMulitpleQty, 0, 0).multiply(roundUpMulitpleQty);
                retRuqQty = batchMulitpleRound.add(batchIncQty);
            } else {
                BigDecimal batchMulitpleRound = ruqQty.divide(roundUpMulitpleQty, 0, 0).multiply(roundUpMulitpleQty);
                retRuqQty = batchMulitpleRound.add(batchIncQty);
            }
        }
        return retRuqQty;
    }

    private LineSchedulingModelInfo getLineSchedulingModel(Context ctx, StorageOrgUnitInfo storageOrgUnit) throws BOSException, EASBizException {
        LineSchedulingModelInfo retLineSchedulingModelInfo = null;
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgUnit.getId().toString(), CompareType.EQUALS));
        entityViewInfo.setFilter(filterInfo);
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add(new SelectorItemInfo("*"));
        entityViewInfo.setSelector(selectorItemCollection);
        LineSchedulingModelCollection lineSchedulingModelCollection = LineSchedulingModelFactory.getLocalInstance((Context)ctx).getLineSchedulingModelCollection(entityViewInfo);
        if (lineSchedulingModelCollection == null || lineSchedulingModelCollection.size() <= 0) {
            throw new SchedulingException(SchedulingException.NOMODEL, new Object[]{storageOrgUnit.getName()});
        }
        retLineSchedulingModelInfo = lineSchedulingModelCollection.get(0);
        return retLineSchedulingModelInfo;
    }

    private HashMap getMaterialInventory(Context ctx, Set materialIds) throws BOSException, EASBizException {
        HashMap<String, MaterialInventoryInfo> materialInventoryInfoMap = new HashMap<String, MaterialInventoryInfo>();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialIds, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)this.storageOrgID, CompareType.EQUALS));
        entityViewInfo.setFilter(filterInfo);
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add(new SelectorItemInfo("*"));
        entityViewInfo.setSelector(selectorItemCollection);
        MaterialInventoryCollection materialInventoryCollection = MaterialInventoryFactory.getLocalInstance((Context)ctx).getMaterialInventoryCollection(entityViewInfo);
        if (materialInventoryCollection != null) {
            for (int i = 0; i < materialInventoryCollection.size(); ++i) {
                MaterialInventoryInfo materialInventoryInfo = materialInventoryCollection.get(i);
                String materialId = materialInventoryInfo.getMaterial().getId().toString();
                if (materialInventoryInfoMap.containsKey(materialId)) continue;
                materialInventoryInfoMap.put(materialId, materialInventoryInfo);
            }
        }
        return materialInventoryInfoMap;
    }

    private HashMap getMaterialPlan(Context ctx, Set materialIds) throws BOSException, EASBizException {
        HashMap<String, MaterialPlanInfo> materialPlanInfoMap = new HashMap<String, MaterialPlanInfo>();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialIds, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)this.storageOrgID, CompareType.EQUALS));
        entityViewInfo.setFilter(filterInfo);
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add(new SelectorItemInfo("*"));
        entityViewInfo.setSelector(selectorItemCollection);
        MaterialPlanCollection materialPlanCollection = MaterialPlanFactory.getLocalInstance((Context)ctx).getMaterialPlanCollection(entityViewInfo);
        if (materialPlanCollection != null) {
            for (int i = 0; i < materialPlanCollection.size(); ++i) {
                MaterialPlanInfo materialPlanInfo = materialPlanCollection.get(i);
                String materialId = materialPlanInfo.getMaterial().getId().toString();
                if (materialPlanInfoMap.containsKey(materialId)) continue;
                materialPlanInfoMap.put(materialId, materialPlanInfo);
            }
        }
        return materialPlanInfoMap;
    }

    private HashMap getMaterialMultiMeasureUnit(Context ctx, Set materialIds) throws BOSException, EASBizException {
        HashMap<String, MultiMeasureUnitInfo> multiMeasureUnitInfoMap = new HashMap<String, MultiMeasureUnitInfo>();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialIds, CompareType.INCLUDE));
        entityViewInfo.setFilter(filterInfo);
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add(new SelectorItemInfo("*"));
        selectorItemCollection.add(new SelectorItemInfo("measureUnit.id"));
        entityViewInfo.setSelector(selectorItemCollection);
        MultiMeasureUnitCollection multiMeasureUnitCollection = MultiMeasureUnitFactory.getLocalInstance((Context)ctx).getMultiMeasureUnitCollection(entityViewInfo);
        if (multiMeasureUnitCollection != null) {
            for (int i = 0; i < multiMeasureUnitCollection.size(); ++i) {
                MultiMeasureUnitInfo multiMeasureUnitInfo = multiMeasureUnitCollection.get(i);
                String materialId = multiMeasureUnitInfo.getMaterial().getId().toString();
                String measureUnitId = multiMeasureUnitInfo.getMeasureUnit().getId().toString();
                String key = materialId + ROW_KEY_SPLIT + measureUnitId;
                if (multiMeasureUnitInfoMap.containsKey(key)) continue;
                multiMeasureUnitInfoMap.put(key, multiMeasureUnitInfo);
            }
        }
        return multiMeasureUnitInfoMap;
    }

    public StorageOrgUnitInfo getStorageOrgUnit(Context ctx, String number) throws BOSException, EASBizException {
        StorageOrgUnitInfo storageOrgUnit = null;
        String sql = "select fid,fcontrolunitid from t_org_storage where fnumber = ?";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{number});
        try {
            if (rs.next()) {
                storageOrgUnit = new StorageOrgUnitInfo();
                storageOrgUnit.setId(BOSUuid.read((String)rs.getString("fid")));
                CtrlUnitInfo ctrlUnitInfo = new CtrlUnitInfo();
                ctrlUnitInfo.setId(BOSUuid.read((String)rs.getString("fcontrolunitid")));
                storageOrgUnit.setCU(ctrlUnitInfo);
                storageOrgUnit.setNumber(number);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        if (storageOrgUnit == null) {
            throw new SupplyMaterCalcException(SupplyMaterCalcException.STORAGEORGUNITNUMBER_ERROR);
        }
        return storageOrgUnit;
    }

    public PlanVersionSetInfo getPlanVersionSet(Context ctx, String storageOrgUnitId, String number) throws BOSException, EASBizException {
        PlanVersionSetInfo planVersionSetInfo = null;
        String sql = "select fid,fcontrolunitid from T_MM_PlanVersionSet where fnumber = ? and FStorageOrgUnitID = ?";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{number, storageOrgUnitId});
        try {
            if (rs.next()) {
                planVersionSetInfo = new PlanVersionSetInfo();
                planVersionSetInfo.setId(BOSUuid.read((String)rs.getString("fid")));
                CtrlUnitInfo ctrlUnitInfo = new CtrlUnitInfo();
                ctrlUnitInfo.setId(BOSUuid.read((String)rs.getString("fcontrolunitid")));
                planVersionSetInfo.setCU(ctrlUnitInfo);
                planVersionSetInfo.setNumber(number);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        if (planVersionSetInfo == null) {
            throw new SupplyMaterCalcException(SupplyMaterCalcException.PLANVERSIONSETNUMBER_ERROR);
        }
        return planVersionSetInfo;
    }

    private String createTempTable(Context ctx, String createTableSQL) throws BOSException {
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        try {
            return pool.createTempTable(createTableSQL);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void releaseTempTable(Context ctx, String tableName) throws BOSException {
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        pool.releaseTable(tableName);
    }

    private void saveRefinedPurPlan(Context ctx, String refinedStockPlanTableName) throws BOSException, EASBizException {
        try {
            StringBuffer delSqlBuf = new StringBuffer();
            delSqlBuf.append(" delete from T_MM_RefinedPurPlan ");
            delSqlBuf.append(" where FPlanVersionID = '" + this.planVersionID + "'");
            delSqlBuf.append(" and FStorageOrgUnitID ='" + this.storageOrgID + "'");
            DbUtil.execute((Context)ctx, (String)delSqlBuf.toString());
            StringBuffer sqlBuf = new StringBuffer();
            sqlBuf.append("insert into T_MM_RefinedPurPlan  ");
            sqlBuf.append("(FID,FPlanVersionID,FStorageOrgUnitID,");
            sqlBuf.append("FMaterialID,FRefinedPurDate,FGRuqQty,FSafetyQty,");
            sqlBuf.append("FCurStoreQty,FRuqQty,FInitSupplyQty,FSupplyQty,FPreUseQty,");
            sqlBuf.append("FAdvisePurQty,FPlanPurQty,FAdvisePurDate,fisPutIn,FUnitId ) ");
            sqlBuf.append("select newbosid('7147E334'),FPlanVersionID,FStorageOrgUnitID,");
            sqlBuf.append("FMaterialID,FRefinedStockDate,FGRuqQty,");
            sqlBuf.append("FQtySafety,FCurStoreQty,FRuqQty,");
            sqlBuf.append("FInitSupplyQty,FSupplyQty,FPreUseQty,FAdvisePurQty,FAdvisePurQty,FAdvisePurDate,");
            sqlBuf.append("FPutIn,FUnitId from ");
            sqlBuf.append(refinedStockPlanTableName);
            DbUtil.execute((Context)ctx, (String)sqlBuf.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void saveSupplyBill(Context ctx, String supplyBillTableName, HashMap materialPlanInfoMap, HashMap materialMultiMeasureUnitMap) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement batchStatement = null;
        try {
            StringBuffer delSqlBuf = new StringBuffer();
            delSqlBuf.append(" delete from T_MM_SupplyBill  ");
            delSqlBuf.append(" where FPlanVersionID = '" + this.planVersionID + "'");
            delSqlBuf.append(" and FStorageOrgUnitID ='" + this.storageOrgID + "'");
            DbUtil.execute((Context)ctx, (String)delSqlBuf.toString());
            StringBuffer selBuf = new StringBuffer();
            selBuf.append("select FID,FBillType,FBillID,");
            selBuf.append("FNumber,FSeq,FMaterialID,FStorageOrgUnitID,FDeliveryDate,FUsedDate,FBaseQty,");
            selBuf.append("FTotalReceiptBaseQty,FIntendReceiptBaseQty,");
            selBuf.append("FAdviseDeliveryDate,FAdviseDate,FActionAdviseType,FAdjustBaseQty from ");
            selBuf.append(supplyBillTableName);
            selBuf.append(" where FActionAdviseType is not null");
            StringBuffer insertBuf = new StringBuffer();
            insertBuf.append("insert into T_MM_SupplyBill ");
            insertBuf.append("(FID,FPlanVersionID,FStorageOrgUnitID,FBillType,FBillID,");
            insertBuf.append("FNumber,FSeq,FMaterialID,FDeliveryDate,FUsedDate,FQty,");
            insertBuf.append("FTotalReceiptQty,FIntendReceiptQty,");
            insertBuf.append("FUnitId,FAdviseDeliveryDate,FActionAdviseType,FAdviseDate,FAdjustQty) ");
            insertBuf.append("values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            conn = EJBFactory.getConnection((Context)ctx);
            String sql_t = insertBuf.toString();
            batchStatement = conn.prepareStatement(sql_t);
            IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)selBuf.toString());
            while (rows.next()) {
                String ID = rows.getString("FID");
                int billType = rows.getInt("FBillType");
                String billID = rows.getString("FBillID");
                String number = rows.getString("FNumber");
                int seq = rows.getInt("FSeq");
                String materialId = rows.getString("FMaterialID");
                Date deliveryDate = rows.getDate("FDeliveryDate");
                Date usedDate = rows.getDate("FUsedDate");
                BigDecimal baseQty = rows.getBigDecimal("FBaseQty");
                BigDecimal totalReceiptBaseQty = rows.getBigDecimal("FTotalReceiptBaseQty");
                BigDecimal intendReceiptBaseQty = rows.getBigDecimal("FIntendReceiptBaseQty");
                Date adviseDeliveryDate = rows.getDate("FAdviseDeliveryDate");
                Date adviseDate = rows.getDate("FAdviseDate");
                int actionAdviseType = rows.getInt("FActionAdviseType");
                BigDecimal adjustBaseQty = rows.getBigDecimal("FAdjustBaseQty");
                MaterialPlanInfo materialPlanInfo = (MaterialPlanInfo)materialPlanInfoMap.get(materialId);
                if (materialPlanInfo == null) continue;
                MeasureUnitInfo measureUnitInfo = materialPlanInfo.getProductUnit();
                String unitId = measureUnitInfo.getId().toString();
                String key = materialId + ROW_KEY_SPLIT + unitId;
                MultiMeasureUnitInfo multiUnifInfo = (MultiMeasureUnitInfo)materialMultiMeasureUnitMap.get(key);
                BigDecimal baseConvsRate = multiUnifInfo.getBaseConvsRate();
                int precision = multiUnifInfo.getQtyPrecision();
                BigDecimal qty = baseQty.divide(baseConvsRate, precision, 4);
                BigDecimal totalReceiptQty = totalReceiptBaseQty.divide(baseConvsRate, precision, 4);
                BigDecimal intendReceiptQty = intendReceiptBaseQty.divide(baseConvsRate, precision, 4);
                BigDecimal adjustQty = adjustBaseQty.divide(baseConvsRate, precision, 4);
                switch (actionAdviseType) {
                    case 10: {
                        adjustQty = null;
                        break;
                    }
                    case 20: {
                        break;
                    }
                    case 30: {
                        adjustQty = null;
                        break;
                    }
                    case 40: {
                        break;
                    }
                    case 50: {
                        adviseDate = null;
                        adjustQty = null;
                        break;
                    }
                    case 60: {
                        adviseDate = null;
                        break;
                    }
                }
                batchStatement.setString(1, ID);
                batchStatement.setString(2, this.planVersionID);
                batchStatement.setString(3, this.storageOrgID);
                batchStatement.setInt(4, billType);
                batchStatement.setString(5, billID);
                batchStatement.setString(6, number);
                batchStatement.setInt(7, seq);
                batchStatement.setString(8, materialId);
                batchStatement.setDate(9, new Date(deliveryDate.getTime()));
                batchStatement.setDate(10, new Date(usedDate.getTime()));
                batchStatement.setBigDecimal(11, qty);
                batchStatement.setBigDecimal(12, totalReceiptQty);
                batchStatement.setBigDecimal(13, intendReceiptQty);
                batchStatement.setString(14, unitId);
                batchStatement.setDate(15, new Date(adviseDeliveryDate.getTime()));
                batchStatement.setInt(16, actionAdviseType);
                if (adviseDate == null) {
                    batchStatement.setDate(17, null);
                } else {
                    batchStatement.setDate(17, new Date(adviseDate.getTime()));
                }
                if (adjustQty == null) {
                    batchStatement.setBigDecimal(18, new BigDecimal(0));
                } else {
                    batchStatement.setBigDecimal(18, adjustQty);
                }
                batchStatement.addBatch();
            }
            batchStatement.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
                catch (Exception e2) {
                    throw new BOSException((Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(batchStatement, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)batchStatement, (Connection)conn);
    }

    private void saveProductLSMP(Context ctx, String gRuqTableName) throws BOSException, EASBizException {
        try {
            StringBuffer delSqlBuf = new StringBuffer();
            delSqlBuf.append(" delete from T_MM_ProductLSMP ");
            delSqlBuf.append(" where FPlanVersionID = '" + this.planVersionID + "'");
            delSqlBuf.append(" and FStorageOrgUnitID ='" + this.storageOrgID + "'");
            DbUtil.execute((Context)ctx, (String)delSqlBuf.toString());
            StringBuffer sqlBuf = new StringBuffer();
            sqlBuf.append("insert into T_MM_ProductLSMP ");
            sqlBuf.append("(fid,FPlanVersionID,FStorageOrgUnitID,");
            sqlBuf.append("FWorkShopID,FProductLineID,");
            sqlBuf.append("FMaterialID,FRequireDate,");
            sqlBuf.append("FQty,FIssMode,FSrcType,FSourceBillID,FUnitId) ");
            sqlBuf.append("select newbosid('9ABF96CD'),FPlanVersionID,FStorageOrgUnitID,");
            sqlBuf.append("FWorkShopID,FProductLineID,FMaterialID,");
            sqlBuf.append("FBeginDate,FQty,FIssMode,");
            sqlBuf.append("FSrcType,FSourceBillID,FUnitId from ");
            sqlBuf.append(gRuqTableName);
            DbUtil.execute((Context)ctx, (String)sqlBuf.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private Set getMaterialSetMap(Context ctx, String gRuqTableName) throws BOSException, EASBizException {
        HashSet<String> materialSet = new HashSet<String>();
        try {
            StringBuffer sqlBuf = new StringBuffer();
            sqlBuf.append("select FPlanVersionID,FStorageOrgUnitID,FMaterialID from ");
            sqlBuf.append(gRuqTableName);
            sqlBuf.append(" group by FPlanVersionID,FStorageOrgUnitID,FMaterialID ");
            IRowSet gRuqRows = DbUtil.executeQuery((Context)ctx, (String)sqlBuf.toString());
            while (gRuqRows.next()) {
                String materialId = gRuqRows.getString("FMaterialID");
                materialSet.add(materialId);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return materialSet;
    }

    private HashMap getLeavingsData(Context ctx, String gRuqTableName, HashMap gRuqQtyMap, HashMap supplyQtyMap) throws BOSException, EASBizException {
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
        HashMap leavingsDataMap = new HashMap();
        try {
            int intHorizonLength = this.planVersionSetInfo.getPlanningHorizon().getHorizonLength();
            StringBuffer sqlBuf = new StringBuffer();
            sqlBuf.append("select FPlanVersionID,FStorageOrgUnitID,FMaterialID from ");
            sqlBuf.append(gRuqTableName);
            sqlBuf.append(" group by FPlanVersionID,FStorageOrgUnitID,FMaterialID ");
            IRowSet gRuqRows = DbUtil.executeQuery((Context)ctx, (String)sqlBuf.toString());
            while (gRuqRows.next()) {
                ArrayList everyMaterialList = new ArrayList();
                String materialId = gRuqRows.getString("FMaterialID");
                java.util.Date startDate = new java.util.Date();
                java.util.Date endDate = this.addDate(startDate, intHorizonLength);
                java.util.Date curDate = startDate;
                String strCurDate = sf.format(curDate);
                do {
                    HashMap supplyQtyOneMap;
                    HashMap<String, Object> everyDayMap = new HashMap<String, Object>();
                    BigDecimal qty = new BigDecimal(0);
                    BigDecimal baseQty = new BigDecimal(0);
                    BigDecimal intendReceiptQty = new BigDecimal(0);
                    BigDecimal intendReceiptBaseQty = new BigDecimal(0);
                    String key = materialId + ROW_KEY_SPLIT + strCurDate;
                    HashMap gRuqQtyOneMap = (HashMap)gRuqQtyMap.get(key);
                    if (gRuqQtyOneMap != null) {
                        qty = (BigDecimal)gRuqQtyOneMap.get("FQty");
                        baseQty = (BigDecimal)gRuqQtyOneMap.get("FBaseQty");
                    }
                    if ((supplyQtyOneMap = (HashMap)supplyQtyMap.get(key)) != null) {
                        intendReceiptQty = (BigDecimal)supplyQtyOneMap.get("FIntendReceiptQty");
                        intendReceiptBaseQty = (BigDecimal)supplyQtyOneMap.get("FIntendReceiptBaseQty");
                    }
                    BigDecimal leavingsQty = intendReceiptQty.subtract(qty);
                    BigDecimal leavingsBaseQty = intendReceiptBaseQty.subtract(baseQty);
                    everyDayMap.put("materialId", materialId);
                    everyDayMap.put("date", strCurDate);
                    everyDayMap.put("gRuqQty", qty);
                    everyDayMap.put("gRuqBaseQty", baseQty);
                    everyDayMap.put("intendReceiptQty", intendReceiptQty);
                    everyDayMap.put("intendReceiptBaseQty", intendReceiptBaseQty);
                    everyDayMap.put("leavingsQty", leavingsQty);
                    everyDayMap.put("leavingsBaseQty", leavingsBaseQty);
                    everyDayMap.put("initIntendReceiptBaseQty", new BigDecimal(intendReceiptBaseQty.doubleValue()));
                    everyMaterialList.add(everyDayMap);
                    leavingsDataMap.put(materialId, everyMaterialList);
                    curDate = this.addDate(curDate, 1);
                    strCurDate = sf.format(curDate);
                } while (!curDate.after(endDate));
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return leavingsDataMap;
    }

    private BigDecimal transQty(Context ctx, BigDecimal qty, MaterialInventoryInfo materialInventoryInfo, HashMap materialMultiMeasureUnitMap) throws BOSException, EASBizException {
        BigDecimal retQty = null;
        String materialId = materialInventoryInfo.getMaterial().getId().toString();
        String unitId = materialInventoryInfo.getUnit().getId().toString();
        String key = materialId + ROW_KEY_SPLIT + unitId;
        MultiMeasureUnitInfo multiUnifInfo = (MultiMeasureUnitInfo)materialMultiMeasureUnitMap.get(key);
        BigDecimal baseConvsRate = multiUnifInfo.getBaseConvsRate();
        retQty = qty == null ? new BigDecimal(0) : qty.multiply(baseConvsRate);
        return retQty;
    }

    private java.util.Date addDate(java.util.Date date, int addDay) {
        Calendar curCal = Calendar.getInstance();
        curCal.setTime(date);
        curCal.add(5, addDay);
        date = curCal.getTime();
        return date;
    }

    private BigDecimal getSumLeavingsQty(Context ctx, ArrayList everyMaterialList, String fromDate, String toDate) throws BOSException, EASBizException {
        BigDecimal sumLeavingsQty = new BigDecimal(0);
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            java.util.Date startDate = sf.parse(fromDate);
            java.util.Date endDate = sf.parse(toDate);
            for (int i = 0; i < everyMaterialList.size(); ++i) {
                HashMap everyDayMap = (HashMap)everyMaterialList.get(i);
                String date = (String)everyDayMap.get("date");
                java.util.Date curDate = sf.parse(date);
                if (startDate.after(curDate) || endDate.before(curDate)) continue;
                BigDecimal leavingsBaseQty = (BigDecimal)everyDayMap.get("leavingsBaseQty");
                sumLeavingsQty = sumLeavingsQty.add(leavingsBaseQty);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return sumLeavingsQty;
    }

    private IRowSet getSupplyBillOrderAdance(Context ctx, String supplyBillTableName, String materialId, String strDate) throws BOSException, EASBizException {
        IRowSet rows = null;
        try {
            StringBuffer sqlBuf = new StringBuffer();
            sqlBuf.append(" select FID,FTotalReceiptBaseQty,FAdjustBaseQty,FBaseQty,FUnitId from ");
            sqlBuf.append(supplyBillTableName);
            sqlBuf.append(" where FMaterialID = '" + materialId + "'");
            sqlBuf.append(" and TO_CHAR(FAdviseDate,'yyyy-mm-dd') = '" + strDate + "'");
            sqlBuf.append(" order by FTotalReceiptBaseQty,FAdjustBaseQty desc");
            rows = DbUtil.executeQuery((Context)ctx, (String)sqlBuf.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return rows;
    }

    private IRowSet getSupplyBillOrderCancel(Context ctx, String supplyBillTableName, String materialId, String strDate) throws BOSException, EASBizException {
        IRowSet rows = null;
        try {
            StringBuffer sqlBuf = new StringBuffer();
            sqlBuf.append(" select FID,FActionAdviseType,FTotalReceiptBaseQty,FAdviseDate,FAdviseDeliveryDate,FAdjustBaseQty,FBaseQty,FUnitId from ");
            sqlBuf.append(supplyBillTableName);
            sqlBuf.append(" where FMaterialID = '" + materialId + "'");
            sqlBuf.append(" and TO_CHAR(FAdviseDate,'yyyy-mm-dd') = '" + strDate + "'");
            sqlBuf.append(" order by FTotalReceiptBaseQty,FUsedDate,FAdjustBaseQty desc");
            rows = DbUtil.executeQuery((Context)ctx, (String)sqlBuf.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return rows;
    }

    private IRowSet getSupplyBillOrderStay(Context ctx, String supplyBillTableName, String materialId, String strDate) throws BOSException, EASBizException {
        IRowSet rows = null;
        try {
            StringBuffer sqlBuf = new StringBuffer();
            sqlBuf.append(" select FID,FActionAdviseType,FAdviseDate,FAdviseDeliveryDate,FAdjustBaseQty,FBaseQty,FUsedDate,FUnitId from ");
            sqlBuf.append(supplyBillTableName);
            sqlBuf.append(" where FMaterialID = '" + materialId + "'");
            sqlBuf.append(" and TO_CHAR(FAdviseDate,'yyyy-mm-dd') = '" + strDate + "'");
            sqlBuf.append(" order by FUsedDate,FAdjustBaseQty desc");
            rows = DbUtil.executeQuery((Context)ctx, (String)sqlBuf.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return rows;
    }

    private java.util.Date getFirDateByLeavingsQty(Context ctx, ArrayList everyMaterialList, String fromDate) throws BOSException, EASBizException {
        java.util.Date firDate = null;
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            java.util.Date startDate = sf.parse(fromDate);
            for (int i = 0; i < everyMaterialList.size(); ++i) {
                HashMap everyDayMap = (HashMap)everyMaterialList.get(i);
                String date = (String)everyDayMap.get("date");
                java.util.Date curDate = sf.parse(date);
                BigDecimal leavingsBaseQty = (BigDecimal)everyDayMap.get("leavingsBaseQty");
                if (!curDate.after(startDate) || leavingsBaseQty.compareTo(new BigDecimal(0)) <= 0) continue;
                firDate = curDate;
                break;
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return firDate;
    }

    private HashMap getFirGRuqQty(Context ctx, String gRuqTableName) throws BOSException, EASBizException {
        HashMap gRuqQtyMap = new HashMap();
        try {
            StringBuffer sqlBuf = new StringBuffer();
            sqlBuf = new StringBuffer();
            sqlBuf.append("select a.FPlanVersionID,a.FStorageOrgUnitID,a.FMaterialID,");
            sqlBuf.append("to_char(a.FBeginDate,'yyyy-mm-dd') as FDate,");
            sqlBuf.append("sum(isNull(a.FQty,0)) as FQty,sum(isNull(a.FBaseQty,0)) as FBaseQty ");
            sqlBuf.append("from (select FPlanVersionID,FStorageOrgUnitID,FMaterialID,");
            sqlBuf.append("case when FBeginDate < now() then now() else FBeginDate end as FBeginDate,");
            sqlBuf.append("FQty,FBaseQty from " + gRuqTableName + " ) a ");
            sqlBuf.append("group by a.FPlanVersionID,a.FStorageOrgUnitID,a.FMaterialID,to_char(a.FBeginDate,'yyyy-mm-dd')");
            IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sqlBuf.toString());
            while (rows.next()) {
                String date = rows.getString("FDate");
                String materialID = rows.getString("FMaterialID");
                BigDecimal qty = rows.getBigDecimal("FQty");
                BigDecimal baseQty = rows.getBigDecimal("FBaseQty");
                HashMap<String, BigDecimal> datas = new HashMap<String, BigDecimal>();
                datas.put("FQty", qty);
                datas.put("FBaseQty", baseQty);
                String key = materialID + ROW_KEY_SPLIT + date;
                gRuqQtyMap.put(key, datas);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return gRuqQtyMap;
    }

    private HashMap getFirSupplyQty(Context ctx, String supplyBillTableName) throws BOSException, EASBizException {
        HashMap supplyQtyMap = new HashMap();
        try {
            StringBuffer sqlBuf = new StringBuffer();
            sqlBuf = new StringBuffer();
            sqlBuf.append("select FPlanVersionID,FStorageOrgUnitID,FMaterialID,to_char(FAdviseDate,'yyyy-mm-dd') as FDate,");
            sqlBuf.append("sum(isNull(FIntendReceiptQty,0)) as FIntendReceiptQty ,sum(isNull(FIntendReceiptBaseQty,0)) as FIntendReceiptBaseQty from ");
            sqlBuf.append(supplyBillTableName);
            sqlBuf.append(" group by FPlanVersionID,FStorageOrgUnitID,FMaterialID,to_char(FAdviseDate,'yyyy-mm-dd')");
            IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sqlBuf.toString());
            while (rows.next()) {
                String date = rows.getString("FDate");
                String materialID = rows.getString("FMaterialID");
                BigDecimal intendReceiptQty = rows.getBigDecimal("FIntendReceiptQty");
                BigDecimal intendReceiptBaseQty = rows.getBigDecimal("FIntendReceiptBaseQty");
                HashMap<String, BigDecimal> datas = new HashMap<String, BigDecimal>();
                datas.put("FIntendReceiptQty", intendReceiptQty);
                datas.put("FIntendReceiptBaseQty", intendReceiptBaseQty);
                String key = materialID + ROW_KEY_SPLIT + date;
                supplyQtyMap.put(key, datas);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return supplyQtyMap;
    }

    private BigDecimal getGRuqQty(Context ctx, ArrayList everyMaterialList, String strDate) throws BOSException, EASBizException {
        BigDecimal gRuqBaseQty = new BigDecimal(0);
        try {
            for (int i = 0; i < everyMaterialList.size(); ++i) {
                HashMap everyDayMap = (HashMap)everyMaterialList.get(i);
                String curDate = (String)everyDayMap.get("date");
                if (!curDate.equals(strDate)) continue;
                gRuqBaseQty = (BigDecimal)everyDayMap.get("gRuqBaseQty");
                break;
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return gRuqBaseQty;
    }

    private BigDecimal getSupplyQty(Context ctx, ArrayList everyMaterialList, String strDate) throws BOSException, EASBizException {
        BigDecimal intendReceiptBaseQty = new BigDecimal(0);
        try {
            for (int i = 0; i < everyMaterialList.size(); ++i) {
                HashMap everyDayMap = (HashMap)everyMaterialList.get(i);
                String curDate = (String)everyDayMap.get("date");
                if (!curDate.equals(strDate)) continue;
                intendReceiptBaseQty = (BigDecimal)everyDayMap.get("intendReceiptBaseQty");
                break;
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return intendReceiptBaseQty;
    }

    private BigDecimal getInitSupplyQty(Context ctx, ArrayList everyMaterialList, String strDate) throws BOSException, EASBizException {
        BigDecimal intendReceiptBaseQty = new BigDecimal(0);
        try {
            for (int i = 0; i < everyMaterialList.size(); ++i) {
                HashMap everyDayMap = (HashMap)everyMaterialList.get(i);
                String curDate = (String)everyDayMap.get("date");
                if (!curDate.equals(strDate)) continue;
                intendReceiptBaseQty = (BigDecimal)everyDayMap.get("initIntendReceiptBaseQty");
                break;
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return intendReceiptBaseQty;
    }

    private BigDecimal getLeavingsQty(Context ctx, HashMap leavingsDataMap, String materialId, String strDate) throws BOSException, EASBizException {
        BigDecimal leavingsBaseQty = new BigDecimal(0);
        try {
            ArrayList everyMaterialList = (ArrayList)leavingsDataMap.get(materialId);
            for (int i = 0; i < everyMaterialList.size(); ++i) {
                HashMap everyDayMap = (HashMap)everyMaterialList.get(i);
                String date = (String)everyDayMap.get("date");
                if (!date.equals(strDate)) continue;
                leavingsBaseQty = (BigDecimal)everyDayMap.get("leavingsBaseQty");
                break;
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return leavingsBaseQty;
    }

    private void updateLeavingsQty(Context ctx, ArrayList everyMaterialList, int precision, String strDate, BigDecimal baseLeavingsQty, BigDecimal baseConvsRate) throws BOSException, EASBizException {
        try {
            for (int i = 0; i < everyMaterialList.size(); ++i) {
                HashMap everyDayMap = (HashMap)everyMaterialList.get(i);
                String curDate = (String)everyDayMap.get("date");
                BigDecimal gRuqBaseQty = (BigDecimal)everyDayMap.get("gRuqBaseQty");
                BigDecimal gRuqQty = (BigDecimal)everyDayMap.get("gRuqQty");
                if (!curDate.equals(strDate)) continue;
                BigDecimal leavingsBaseQty = baseLeavingsQty.setScale(precision, 4);
                BigDecimal leavingsQty = baseLeavingsQty.divide(baseConvsRate, precision, 4);
                BigDecimal intendReceiptBaseQty = gRuqBaseQty.add(baseLeavingsQty.setScale(precision, 4));
                BigDecimal intendReceiptQty = gRuqQty.add(baseLeavingsQty.divide(baseConvsRate, precision, 4));
                everyDayMap.put("intendReceiptQty", intendReceiptQty);
                everyDayMap.put("intendReceiptBaseQty", intendReceiptBaseQty);
                everyDayMap.put("leavingsQty", leavingsQty);
                everyDayMap.put("leavingsBaseQty", leavingsBaseQty);
                break;
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void updateSupplyBill(Context ctx, String supplyBillTableName, ArrayList supplyBillList) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement batchStatement = null;
        try {
            if (supplyBillList.isEmpty()) {
                return;
            }
            StringBuffer sql = new StringBuffer();
            sql.append("update ");
            sql.append(supplyBillTableName);
            sql.append(" set FActionAdviseType =?,FAdviseDate =?,FAdviseDeliveryDate =? where FId = ?");
            conn = EJBFactory.getConnection((Context)ctx);
            batchStatement = conn.prepareStatement(sql.toString());
            for (int i = 0; i < supplyBillList.size(); ++i) {
                HashMap supplyBillMap = (HashMap)supplyBillList.get(i);
                String id = (String)supplyBillMap.get("id");
                java.util.Date adviseDate = (java.util.Date)supplyBillMap.get("adviseDate");
                java.util.Date adviseDeliveryDate = (java.util.Date)supplyBillMap.get("adviseDeliveryDate");
                int actionAdviseType = ((ActionAdviseTypeEnum)((Object)supplyBillMap.get("actionAdviseType"))).getValue();
                batchStatement.setInt(1, actionAdviseType);
                batchStatement.setDate(2, new Date(adviseDate.getTime()));
                batchStatement.setDate(3, new Date(adviseDeliveryDate.getTime()));
                batchStatement.setString(4, id);
                batchStatement.addBatch();
            }
            batchStatement.executeBatch();
            SQLUtils.cleanup((Statement)batchStatement, (Connection)conn);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup(batchStatement, conn);
        }
    }

    private void splitSupplyBill(Context ctx, String supplyBillTableName, ArrayList supplyBillList) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement insertBatchStatement = null;
        PreparedStatement updateBatchStatement = null;
        try {
            if (supplyBillList.isEmpty()) {
                return;
            }
            conn = EJBFactory.getConnection((Context)ctx);
            StringBuffer selectBuf = new StringBuffer();
            selectBuf.append("select FPlanVersionID,FStorageOrgUnitID,FBillType,FBillID,");
            selectBuf.append("FNumber,FSeq,FMaterialID,FDeliveryDate,FUsedDate,FQty,FBaseQty,");
            selectBuf.append("FTotalReceiptQty,FTotalReceiptBaseQty,FIntendReceiptQty,FIntendReceiptBaseQty,");
            selectBuf.append("FUnitId from ");
            selectBuf.append(supplyBillTableName);
            selectBuf.append(" where Fid = ");
            StringBuffer insertBuf = new StringBuffer();
            insertBuf.append("insert into ");
            insertBuf.append(supplyBillTableName);
            insertBuf.append("(FID,FPlanVersionID,FStorageOrgUnitID,FBillType,FBillID,");
            insertBuf.append("FNumber,FSeq,FMaterialID,FDeliveryDate,FUsedDate,FQty,FBaseQty,");
            insertBuf.append("FTotalReceiptQty,FTotalReceiptBaseQty,FIntendReceiptQty,FIntendReceiptBaseQty,");
            insertBuf.append("FUnitId,FAdviseDeliveryDate,FAdviseDate,FActionAdviseType,FAdjustQty,FAdjustBaseQty) ");
            insertBuf.append("values (newbosid('4E375F0B'),?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            insertBatchStatement = conn.prepareStatement(insertBuf.toString());
            StringBuffer updateBuf = new StringBuffer();
            updateBuf.append("update ");
            updateBuf.append(supplyBillTableName);
            updateBuf.append(" set FAdjustBaseQty = FAdjustBaseQty-?,FAdjustQty = FAdjustQty-? where FId = ?");
            updateBatchStatement = conn.prepareStatement(updateBuf.toString());
            for (int i = 0; i < supplyBillList.size(); ++i) {
                HashMap supplyBillMap = (HashMap)supplyBillList.get(i);
                String id = (String)supplyBillMap.get("id");
                java.util.Date adviseDate = (java.util.Date)supplyBillMap.get("adviseDate");
                java.util.Date adviseDeliveryDate = (java.util.Date)supplyBillMap.get("adviseDeliveryDate");
                int actionAdviseType = ((ActionAdviseTypeEnum)((Object)supplyBillMap.get("actionAdviseType"))).getValue();
                BigDecimal changeBaseQty = (BigDecimal)supplyBillMap.get("changeBaseQty");
                BigDecimal changeQty = (BigDecimal)supplyBillMap.get("changeQty");
                String selectSql = selectBuf.toString() + "'" + id + "'";
                IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)selectSql);
                if (rows.next()) {
                    String planVersionID = rows.getString("FPlanVersionID");
                    String storageOrgUnitID = rows.getString("FStorageOrgUnitID");
                    int billType = rows.getInt("FBillType");
                    String billID = rows.getString("FBillID");
                    String number = rows.getString("FNumber");
                    int seq = rows.getInt("FSeq");
                    String materialId = rows.getString("FMaterialID");
                    Date deliveryDate = rows.getDate("FDeliveryDate");
                    Date usedDate = rows.getDate("FUsedDate");
                    BigDecimal qty = rows.getBigDecimal("FQty");
                    BigDecimal baseQty = rows.getBigDecimal("FBaseQty");
                    BigDecimal totalReceiptQty = rows.getBigDecimal("FTotalReceiptQty");
                    BigDecimal totalReceiptBaseQty = rows.getBigDecimal("FTotalReceiptBaseQty");
                    BigDecimal intendReceiptQty = rows.getBigDecimal("FIntendReceiptQty");
                    BigDecimal intendReceiptBaseQty = rows.getBigDecimal("FIntendReceiptBaseQty");
                    String unitId = rows.getString("FUnitId");
                    insertBatchStatement.setString(1, planVersionID);
                    insertBatchStatement.setString(2, storageOrgUnitID);
                    insertBatchStatement.setInt(3, billType);
                    insertBatchStatement.setString(4, billID);
                    insertBatchStatement.setString(5, number);
                    insertBatchStatement.setInt(6, seq);
                    insertBatchStatement.setString(7, materialId);
                    insertBatchStatement.setDate(8, new Date(deliveryDate.getTime()));
                    insertBatchStatement.setDate(9, new Date(usedDate.getTime()));
                    insertBatchStatement.setBigDecimal(10, qty);
                    insertBatchStatement.setBigDecimal(11, baseQty);
                    insertBatchStatement.setBigDecimal(12, totalReceiptQty);
                    insertBatchStatement.setBigDecimal(13, totalReceiptBaseQty);
                    insertBatchStatement.setBigDecimal(14, intendReceiptQty);
                    insertBatchStatement.setBigDecimal(15, intendReceiptBaseQty);
                    insertBatchStatement.setString(16, unitId);
                    insertBatchStatement.setDate(17, new Date(adviseDeliveryDate.getTime()));
                    insertBatchStatement.setDate(18, new Date(adviseDate.getTime()));
                    insertBatchStatement.setInt(19, actionAdviseType);
                    insertBatchStatement.setBigDecimal(20, changeQty);
                    insertBatchStatement.setBigDecimal(21, changeBaseQty);
                    insertBatchStatement.addBatch();
                }
                updateBatchStatement.setBigDecimal(1, changeBaseQty);
                updateBatchStatement.setBigDecimal(2, changeQty);
                updateBatchStatement.setString(3, id);
                updateBatchStatement.addBatch();
            }
            insertBatchStatement.executeBatch();
            updateBatchStatement.executeBatch();
            SQLUtils.cleanup((Statement)insertBatchStatement, (Connection)conn);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup(insertBatchStatement, conn);
            SQLUtils.cleanup(updateBatchStatement);
        }
        SQLUtils.cleanup((Statement)updateBatchStatement);
    }

    @Override
    protected void _modifyTempTable(Context ctx, String tableName) throws BOSException {
    }
}

