/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.app.mrp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.util.backport.concurrent.Callable;
import com.kingdee.bos.util.backport.concurrent.ExecutionException;
import com.kingdee.bos.util.backport.concurrent.Executor;
import com.kingdee.bos.util.backport.concurrent.ExecutorCompletionService;
import com.kingdee.bos.util.backport.concurrent.ExecutorService;
import com.kingdee.bos.util.backport.concurrent.Executors;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.planning.MRPException;
import com.kingdee.eas.mm.planning.app.mrp.MRPAjustMent;
import com.kingdee.eas.mm.planning.app.mrp.MRPAjustResult;
import com.kingdee.eas.mm.planning.app.mrp.MRPCalcParam;
import com.kingdee.eas.mm.planning.app.mrp.MRPResource;
import com.kingdee.eas.mm.planning.app.mrp.MRPStep;
import java.util.List;

public abstract class MRPCalcLevelCode
extends MRPStep {
    protected static final int THREADCOUNT = Runtime.getRuntime().availableProcessors() * 2;
    protected int materialCount = 0;
    protected int threadCount = 1;
    protected MRPAjustResult result = null;

    @Override
    protected String getStepDesc(MRPCalcParam runParam) throws BOSException, EASBizException {
        return MRPResource.getString(runParam.getCtx(), "NO") + String.valueOf(runParam.getLevel()) + MRPResource.getString(runParam.getCtx(), "LEVEL") + "," + MRPResource.getString(runParam.getCtx(), "SP_CALCLEVELCODE");
    }

    @Override
    protected String getStepDesc() throws MRPException, EASBizException, BOSException {
        return this.getStepDesc(this.runParam) + "," + MRPResource.getString(this.runParam.getCtx(), "SYM_LLC") + ":" + String.valueOf(this.runParam.getLevel()) + "," + MRPResource.getString(this.runParam.getCtx(), "SYM_MATERIAL") + MRPResource.getString(this.runParam.getCtx(), "SYM_NUMBER") + String.valueOf(this.materialCount) + ",thread : " + String.valueOf(this.threadCount);
    }

    @Override
    protected Object innerExecute(MRPCalcParam runParam) throws EASBizException, BOSException {
        this.result = new MRPAjustResult();
        this.doCalcNetDemand(runParam);
        return this.result;
    }

    private void doCalcNetDemand(MRPCalcParam mrpCalcParam) throws BOSException, EASBizException {
        List idList = this.distrubteMaterials(mrpCalcParam);
        int size = idList.size();
        if (size == 0) {
            return;
        }
        if (size > 0) {
            this.threadCount = size;
        }
        ExecutorService exec = Executors.newFixedThreadPool((int)this.threadCount);
        ExecutorCompletionService ecs = new ExecutorCompletionService((Executor)exec);
        for (int i = 0; i < size; ++i) {
            MRPAjustMent calc = this.getcalcThread((List)idList.get(i), mrpCalcParam);
            ecs.submit((Callable)calc);
        }
        idList.clear();
        MRPAjustResult singleResult = null;
        try {
            for (int j = 0; j < size; ++j) {
                singleResult = (MRPAjustResult)ecs.take().get();
                this.result.mergeResult(singleResult);
            }
        }
        catch (InterruptedException e) {
            throw new BOSException(e.getCause());
        }
        catch (ExecutionException e) {
            throw new BOSException(e.getCause());
        }
        finally {
            exec.shutdown();
        }
    }

    protected int getThreadCount(int materialCount) {
        int threadNum = THREADCOUNT;
        if (materialCount <= 500) {
            return 1;
        }
        if (threadNum > 10) {
            threadNum = 10;
        }
        if (threadNum < 5) {
            threadNum = 7;
        }
        if (materialCount < 5000) {
            threadNum = materialCount / 500;
        }
        return threadNum;
    }

    @Override
    protected boolean isNeedUpdateProgress() {
        return true;
    }

    public abstract List distrubteMaterials(MRPCalcParam var1) throws EASBizException, BOSException;

    public abstract MRPAjustMent getcalcThread(List var1, MRPCalcParam var2) throws MRPException, BOSException;

    @Override
    protected int getDataAmount() {
        return this.result.getDataAmount();
    }
}

