/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.app.mrp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.sql.util.UUTN;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.basedata.app.BomMatch;
import com.kingdee.eas.mm.common.app.SQLUtils;
import com.kingdee.eas.mm.common.util.MMUtils;
import com.kingdee.eas.mm.planning.MRPException;
import com.kingdee.eas.mm.planning.MRPRunStepLogInfo;
import com.kingdee.eas.mm.planning.app.mrp.MRPAjustResult;
import com.kingdee.eas.mm.planning.app.mrp.MRPCalcNoSubMaterials;
import com.kingdee.eas.mm.planning.app.mrp.MRPCalcParam;
import com.kingdee.eas.mm.planning.app.mrp.MRPCalcSubstituteMaterials;
import com.kingdee.eas.mm.planning.app.mrp.MRPCalcSurplusDivertMaterials;
import com.kingdee.eas.mm.planning.app.mrp.MRPDependentReqGenerator;
import com.kingdee.eas.mm.planning.app.mrp.MRPGetSubstitueMaterial;
import com.kingdee.eas.mm.planning.app.mrp.MRPMaterialTableDAO;
import com.kingdee.eas.mm.planning.app.mrp.MRPPlanStrategyUtil;
import com.kingdee.eas.mm.planning.app.mrp.MRPResource;
import com.kingdee.eas.mm.planning.app.mrp.MRPSeqUtil;
import com.kingdee.eas.mm.planning.app.mrp.MRPStep;
import com.kingdee.eas.mm.planning.app.mrp.MRPUtil;
import com.kingdee.eas.util.ResourceBase;
import java.math.BigDecimal;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Vector;

public class MRPCalcNetDemand
extends MRPStep {
    protected MRPDependentReqGenerator depReqGen = null;
    protected boolean isGetBill = true;

    public void setDepReqGen(MRPDependentReqGenerator depReqGen) {
        this.depReqGen = depReqGen;
    }

    @Override
    protected boolean isNeedUpdateProgress() {
        return true;
    }

    @Override
    protected int getProgressPercent() {
        return 90;
    }

    @Override
    protected String getStepDesc(MRPCalcParam runParam) throws MRPException, BOSException {
        return MRPResource.getString(runParam.getCtx(), "SP_CALCNETDEMAND");
    }

    @Override
    protected void logBegin() throws BOSException, EASBizException {
        super.logBegin();
        String msg = "60.00:" + this.getStepDesc() + MRPResource.getString(this.runParam.getCtx(), "SYM_BEGIN");
        this.logInfo(msg);
    }

    @Override
    protected Object innerExecute(MRPCalcParam runParam) throws EASBizException, BOSException {
        MRPCalcNoSubMaterials netCalcLevel = new MRPCalcNoSubMaterials();
        if (this.depReqGen == null) {
            this.depReqGen = new MRPDependentReqGenerator();
        }
        logger.info((Object)"getAllLevelCode");
        MRPCalcSubstituteMaterials netCalcLevelForSub = null;
        MRPCalcSurplusDivertMaterials netCalcLevelForSurplusDivert = null;
        List lowerLevelCodeLst = MRPMaterialTableDAO.getAllLevelCode(runParam);
        if (runParam.isReplaceCon()) {
            this.subStitute(runParam);
            netCalcLevelForSub = new MRPCalcSubstituteMaterials();
        }
        Vector materialFristPeriodList = null;
        if (runParam.getAdvanceType() == 0 && runParam.getCPlanVersion() == null) {
            netCalcLevelForSurplusDivert = new MRPCalcSurplusDivertMaterials();
        }
        int level = 0;
        int stepSepIndex = this.getLogInfo().getSeq() + 1;
        int currentLevelAmount = 0;
        int levelPercent = 0;
        if (lowerLevelCodeLst.size() > 0) {
            levelPercent = this.getProgressPercent() / lowerLevelCodeLst.size();
        }
        for (int index = 0; index < lowerLevelCodeLst.size(); ++index) {
            level = (Integer)lowerLevelCodeLst.get(index);
            currentLevelAmount = 0;
            runParam.setLevel(level);
            logger.info((Object)("1:level : " + String.valueOf(level)));
            if (runParam.getStatisticsTable() != null) {
                TempTablePool.getInstance((Context)runParam.getCtx()).releaseTable(runParam.getStatisticsTable());
            }
            logger.info((Object)("2:daysStatistics level : " + String.valueOf(level)));
            this.daysStatistics(runParam, level);
            this.updateIsMatch(runParam, level);
            logger.info((Object)("3:searchBom level : " + String.valueOf(level)));
            this.searchBom(runParam);
            logger.info((Object)("4:netCalcLevel level : " + String.valueOf(level)));
            netCalcLevel.createLogInfo(runParam, this.getLogInfo(), stepSepIndex++);
            netCalcLevel.setProgressPercent((int)((double)levelPercent * 0.33));
            MRPAjustResult result = (MRPAjustResult)netCalcLevel.execute(runParam);
            currentLevelAmount += result.getDataAmount();
            logger.info((Object)("5:netCalcLevelForSub level : " + String.valueOf(level)));
            if (netCalcLevelForSub != null) {
                netCalcLevelForSub.createLogInfo(runParam, this.getLogInfo(), stepSepIndex++);
                netCalcLevelForSub.setProgressPercent((int)((double)levelPercent * 0.1));
                MRPAjustResult substituteResult = (MRPAjustResult)netCalcLevelForSub.execute(runParam);
                currentLevelAmount += substituteResult.getDataAmount();
                logger.info((Object)("6:inventoryStatistics level : " + String.valueOf(level)));
            }
            if (netCalcLevelForSurplusDivert != null) {
                materialFristPeriodList = new Vector();
                netCalcLevelForSurplusDivert.setSqlList(materialFristPeriodList);
                List materials = netCalcLevelForSurplusDivert.distrubteMaterials(runParam);
                if (materials != null && materials.size() > 0) {
                    logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"30_MRPCalcNetDemand", (Locale)runParam.getCtx().getLocale()) + String.valueOf(level)));
                    netCalcLevelForSurplusDivert.createLogInfo(runParam, this.getLogInfo(), stepSepIndex++);
                    netCalcLevelForSurplusDivert.setProgressPercent((int)((double)levelPercent * 0.1));
                    MRPAjustResult divertResult = (MRPAjustResult)netCalcLevelForSurplusDivert.execute(runParam);
                    currentLevelAmount += divertResult.getDataAmount();
                }
                netCalcLevelForSurplusDivert.setProgressPercent((int)((double)levelPercent * 0.1));
            }
            logger.info((Object)("7:depReqGen level : " + String.valueOf(level)));
            this.depReqGen.createLogInfo(runParam, this.getLogInfo(), stepSepIndex++);
            this.depReqGen.execute(runParam);
            logger.info((Object)("8:inventoryStatistics level : " + String.valueOf(level)));
            if (netCalcLevelForSub != null) {
                this.inventoryStatistics(true);
            }
            this.inventoryStatistics(false);
            logger.info((Object)("9:insertNullInv level : " + String.valueOf(level)));
            this.insertNullInv(materialFristPeriodList);
            logger.info((Object)("10:afterInnerExecute level : " + String.valueOf(level)));
            this.afterInnerExecute(runParam, lowerLevelCodeLst, level, index);
            this.dataAmount += currentLevelAmount;
        }
        logger.info((Object)"11:undistributeInvStatistics ");
        this.undistributeInvStatistics();
        logger.info((Object)"12:releaseTable ");
        if (runParam.getStatisticsTable() != null) {
            TempTablePool.getInstance((Context)runParam.getCtx()).releaseTable(runParam.getStatisticsTable());
        }
        return null;
    }

    protected void afterInnerExecute(MRPCalcParam runParam, List lowerLevelCodeLst, int level, int index) throws BOSException, EASBizException {
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void searchBom(MRPCalcParam runParam) throws BOSException, MRPException {
        String tmpTable = null;
        try {
            BomMatch bomMatch;
            String retTable;
            String mto10 = "'fpPxtypCS/ihJ30GjB/UJtg0uEU='";
            String mto20 = "'qAXoUB/tBg/gQKjAYj0WQ9g0uEU='";
            String ato10 = "'qAYbemEdG9ngQKjAYj0V1dg0uEU='";
            String ato20 = "'qAYfaBzTrmLgQKjAYj0f3dg0uEU='";
            tmpTable = this.createTempTableForBom(runParam.getCtx());
            StringBuffer sqlBuf = new StringBuffer();
            sqlBuf.append(" insert into ").append(tmpTable).append(" (FID,FMaterialID,fTrackId,FProjectID,FStorageOrgUnitID,fManufactureStrategyId,").append(" FExpandTraceId,fLevel,fMaterialAttr,fIsolatedRule,fbomType) ").append(" select t1.FID,t1.FMaterialID,").append(" case when ( ").append("\t\tt2.FPlanStrategy = ").append(mto10).append(" or ").append("       t2.FPlanStrategy = ").append(mto20).append(" or ").append("       t2.FPlanStrategy = ").append(ato10).append(" or ").append("       t2.FPlanStrategy = ").append(ato20).append("\t) then isnull(t1.FBTrackID,'").append(runParam.getTrackID()).append("') ").append(" else isnull(t1.FBTrackID,'").append("999999999").append("') ").append(" end FTrackID,").append(" isnull(t1.FBProjectID, '").append("999999999").append("') FProjectID,").append("'").append(runParam.getStorageOrgUnitID()).append("' ,t2.FPlanStrategy,t1.FID,0,t2.FMaterialAttr,t2.FisolateRules,").append(45).append(" from ").append(runParam.getMrpCalcDetailTableName()).append(" t1 inner join ").append(runParam.getMaterialTableName()).append(" t2 on t2.FMaterialID = t1.FMaterialID ").append(" where t1.FBOMID is null and t1.FMRPClassify in (30,10) ").append(" and (t2.FMaterialAttr = ").append(10030).append(" or t2.FMaterialAttr = ").append(10020).append(" or t2.FMaterialAttr = ").append(10050).append(")").append(" and t2.FLowsetCode = ?");
            int count = MRPUtil.executeUpdate(runParam.getCtx(), sqlBuf.toString(), new Object[]{new Integer(runParam.getLevel())});
            if (count > 0 && (retTable = (bomMatch = new BomMatch()).matchBomForMRP(runParam.getCtx(), tmpTable)) != null) {
                sqlBuf.setLength(0);
                sqlBuf.append("update ").append(runParam.getMrpCalcDetailTableName()).append(" as  t0 set (fbomid,FYield,fbomtype )= ( select t1.fbomid ,t1.FYield ,t1.fbomtype from ").append(retTable).append(" t1  where t1.fid = t0.fid and  t1.fbomid  is not null )");
                MRPUtil.executeUpdate(runParam.getCtx(), sqlBuf.toString());
            }
            if (tmpTable == null) return;
        }
        catch (EASBizException e) {
            try {
                throw new BOSException((Throwable)e);
                catch (BOSException e2) {
                    throw new BOSException((Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                if (tmpTable == null) throw throwable;
                TempTablePool.getInstance((Context)runParam.getCtx()).releaseTable(tmpTable);
                throw throwable;
            }
        }
        TempTablePool.getInstance((Context)runParam.getCtx()).releaseTable(tmpTable);
    }

    private void daysStatistics(MRPCalcParam runParam, int level) throws EASBizException, BOSException {
        String tableName = this.createTempTableForStatistics(runParam.getCtx());
        runParam.setStatisticsTable(tableName);
        StringBuffer sql = new StringBuffer();
        sql.append("Insert into ").append(runParam.getStatisticsTable()).append(" ( KSQL_SEQ,FID,FMaterialId, FPlanStrategy, FPeriod, FProjectNumber, FTrackNumber, FSQty,FRQty,").append(" FDetailcount,FIsDefaultTNO,FSubstituteGroup,FCalcSeq,FMaterialNumber,FSurplusQty) ").append("select ").append("newbosid('").append("F94043EF").append("'), ").append("d.FMaterialId, m.FPlanStrategy, d.FPeriod, d.FProjectNumber, d.FTrackNumber,  sum(d.fsr) ").append(",sum(case when m.FIsSurplusDivert=1 and d.fmrpitem=120 then 0 else d.FIndependent+ d.FDependent end)").append(",count(1),d.FIsDefaultTNO,m.FSubstituteGroup,m.FCalcSeq,m.FMaterialNumber,\n ").append("sum(d.fsr) + sum(case when m.FIsSurplusDivert=1 and d.fmrpitem=120 then 0 else d.FIndependent+ d.FDependent end) ").append("\n from ").append(runParam.getMrpCalcDetailTableName()).append(" d ").append("inner join ").append(runParam.getMaterialTableName()).append(" m on d.FMaterialId = m.FMaterialId ").append("where m.FLowsetCode = ? and m.FRunLogID = ? and d.FSupplyType<10930 ").append("and d.FMRPItem<>").append(110).append(" group by d.FPeriod,m.FSubstituteGroup,m.FCalcSeq,d.FMaterialId ,m.FPlanStrategy, m.FMaterialNumber, ").append(" d.FProjectNumber,d.FTrackNumber ,d.FIsDefaultTNO ").append(" order by d.FPeriod,m.FSubstituteGroup,m.FCalcSeq,m.FMaterialNumber,d.FProjectNumber,d.FIsDefaultTNO,d.FTrackNumber");
        ArrayList<Object> paramList = new ArrayList<Object>();
        paramList.add(new Integer(level));
        paramList.add(runParam.getRunLogID());
        MRPUtil.executeUpdate(runParam.getCtx(), sql.toString(), paramList.toArray());
    }

    private void updateIsMatch(MRPCalcParam runParam, int level) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("update ").append(runParam.getMrpCalcDetailTableName()).append("  t ").append(" set FIsMatch = 1").append(" where exists(select 1 from ").append(runParam.getMaterialTableName()).append(" where FMaterialId = t.FMaterialId and FLowsetCode = ? and FRunLogID = ?").append(")").append(" and exists(select 1 from ").append(runParam.getMrpCalcDetailTableName()).append(" where FSaleOrderNumber = t.FSaleOrderNumber and FSaleOrderEntrySeq =t.FSaleOrderEntrySeq and FMRPClassify=30").append(")").append(" and FSaleOrderNumber is not null and FSaleOrderEntrySeq is not null").append(" and FSR-FAjustQty > 0 and FIsAjust = 1 and FMRPClassify = 20");
        ArrayList<Object> paramList = new ArrayList<Object>();
        paramList.add(new Integer(level));
        paramList.add(runParam.getRunLogID());
        MRPUtil.executeUpdate(runParam.getCtx(), sql.toString(), paramList.toArray());
    }

    private void subStitute(MRPCalcParam runParam) throws EASBizException, BOSException {
        MRPGetSubstitueMaterial getSubstitueMaterial = new MRPGetSubstitueMaterial(null, runParam);
        getSubstitueMaterial.materialReplaceGrouping(runParam.getCtx(), runParam.getMaterialTableName(), runParam.getStorageOrgUnitID());
    }

    private String createTempTableForBom(Context ctx) throws BOSException, EASBizException {
        String expandTablName = null;
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        try {
            BomMatch bomMatch = new BomMatch();
            String expandTableSQL = bomMatch.getExpandTmpTableSQL();
            expandTablName = pool.createTempTable(expandTableSQL);
            pool.createIndex(expandTablName, "FID,FBOMID,FBomType,FYield", false, false);
        }
        catch (Exception e1) {
            throw new BOSException((Throwable)e1);
        }
        return expandTablName;
    }

    private String createTempTableForStatistics(Context ctx) throws BOSException, EASBizException {
        String expandTablName = null;
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        try {
            StringBuffer sqlBuf = new StringBuffer();
            sqlBuf.append("create table tttttt (").append("KSQL_SEQ INT IDENTITY (1, 1) NOT NULL,").append("FID VARCHAR(44) NOT NULL, ").append("FMaterialID varchar(44) NOT NULL,").append("FPlanStrategy varchar(44),").append("FPeriod INT NOT NULL ,").append("FTrackNumber Nvarchar(80) NOT NULL,").append("FProjectNumber Nvarchar(80) NOT NULL,").append("FSQty  NUMERIC(24,8) DEFAULT 0 NOT NULL,").append("FRQty NUMERIC(24,8)DEFAULT 0 NOT NULL,").append("FOnHand  NUMERIC(24,8)DEFAULT 0 NOT NULL , ").append("FPreQty  NUMERIC(24,8) DEFAULT 0 NOT NULL,").append("FIsDefaultTNO INTEGER DEFAULT 1 NOT NULL,").append("FSubstituteGroup INTEGER DEFAULT 0 NOT NULL ,").append("FDetailCount INTEGER DEFAULT 0 NOT NULL , ").append("FProjectId varchar(44) ,").append("FTrackNumberId varchar(44) ,").append("FCalcSeq INTEGER DEFAULT 0 NOT NULL ,").append("FMaterialNumber NVARCHAR(80), ").append("FSurplusQty NUMERIC(24,8) DEFAULT 0 NOT NULL, ").append("CONSTRAINT ").append(new UUTN("ZC").toString()).append(" PRIMARY KEY (FID) )");
            expandTablName = pool.createTempTable(sqlBuf.toString());
            pool.createIndex(expandTablName, "FMaterialID,FPeriod,FProjectNumber,FTrackNumber", false, false);
            pool.createIndex(expandTablName, "KSQL_SEQ", false, false);
        }
        catch (Exception e1) {
            throw new BOSException((Throwable)e1);
        }
        return expandTablName;
    }

    private void inventoryStatistics(boolean isSubstitute) throws BOSException, MRPException {
        StringBuffer sql = new StringBuffer();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String date = dateFormat.format(this.runParam.getRunStartTime());
        sql.append("Insert into ").append(this.runParam.getStatisticsTable()).append(" ( KSQL_SEQ, FID,FMaterialId, FPlanStrategy, FPeriod, FProjectNumber, FTrackNumber,FDetailcount ").append(" ,FIsDefaultTNO,FSubstituteGroup)").append("select ").append("newbosid('").append("F94043EF").append("'), ").append(" m.FMaterialId, m.FPlanStrategy, 0 as FPeriod, '").append(this.runParam.getProjectNumber()).append("' as FProjectNumber,'").append(this.runParam.getTrackNumber());
        if (isSubstitute) {
            sql.append("' as FTrackNumber,0 as FDetailcount ,1,1 as FIsDefaultTNO ");
        } else {
            sql.append("' as FTrackNumber,0 as FDetailcount ,1,0 as FIsDefaultTNO ");
        }
        sql.append("from ").append(this.runParam.getMaterialTableName()).append(" m ").append("where m.FLowsetCode = ? and m.FRunLogID = ?  and m.FOnHand-m.FSafeStock<0").append(" and m.FPlanStrategy<>?");
        if (isSubstitute) {
            sql.append(" and m.FSubstituteGroup > 0");
        } else {
            sql.append(" and m.FSubstituteGroup = 0");
        }
        ArrayList<Object> paramList = new ArrayList<Object>();
        paramList.add(new Integer(this.runParam.getLevel()));
        paramList.add(this.runParam.getRunLogID());
        paramList.add("GE2FIa4GQ6uhdx0RDGuibtg0uEU=");
        MRPUtil.executeUpdate(this.runParam.getCtx(), sql.toString(), paramList.toArray());
        sql.setLength(0);
        sql.append("insert into ").append(this.runParam.getMrpCalcDetailTableName()).append(" ( FID ,FMRPItem,FMaterialID,FProjectNumber,FTrackNumber,FBProjectNumber,FBTrackNumber,FAvaliable ").append(",FPLANVERSIONID,FRUNLOGID,FBILLDATE,FPeriod,FIsDefaultTNO,FMrpSeq) ").append(" select newbosid('").append("F94043EF").append("'), ").append(132).append(" ,FMaterialID ,FProjectNumber,FTrackNumber, FProjectNumber,").append(" FTrackNumber,FAvaliable, '  ',' ',TO_DATE('").append(date).append("'),").append(this.runParam.getPlanDate().getPeriod()).append(",FIsDefaultTNO,'").append(MRPSeqUtil.DISTRIBUTE_INV_SEQ).append("' ").append(" from ( select ").append(" s.FMaterialID,s.FProjectNumber,s.FTrackNumber ,sum(s.FOnHand) as FAvaliable ,max(FIsDefaultTNO) as FIsDefaultTNO ").append(" from  ").append(this.runParam.getStatisticsTable()).append(" s").append("  where s.FOnHand >=0 ");
        if (isSubstitute) {
            sql.append(" and s.FSubstituteGroup > 0");
        } else {
            sql.append(" and s.FSubstituteGroup = 0");
        }
        sql.append(" and s.FPlanStrategy in(").append(MRPPlanStrategyUtil.getDistributeInvPlanStrategyStr()).append(")");
        sql.append(" group by s.FMaterialID,s.FProjectNumber,s.FTrackNumber ) as t");
        SQLUtils.execute((Context)this.runParam.getCtx(), (String)sql.toString());
    }

    private void undistributeInvStatistics() throws BOSException, MRPException {
        StringBuffer sql = new StringBuffer();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String date = dateFormat.format(this.runParam.getRunStartTime());
        sql.append("insert into ").append(this.runParam.getMrpCalcDetailTableName()).append(" (FID ,FMRPItem,FMaterialID,FProjectNumber,FTrackNumber,FBProjectNumber,FBTrackNumber,FAvaliable,").append("FPLANVERSIONID,FRUNLOGID,FBILLDATE,FPeriod,FIsDefaultTNO,FMrpSeq)").append("select newbosid('").append("F94043EF").append("'), ").append(131).append(" ,").append("mt.FMaterialID,").append("'").append(this.runParam.getProjectNumber()).append("',").append("'").append(this.runParam.getTrackNumber()).append("',").append("'', '',").append("mt.FONHAND - FAmount,").append(" '  ',' ',TO_DATE('").append(date).append("'),").append(this.runParam.getPlanDate().getPeriod()).append(",1,'").append(MRPSeqUtil.UNDISTRIBUTE_INV_SEQ).append("' from ").append(this.runParam.getMaterialTableName()).append(" mt ,").append("(select s.FMaterialID,sum(s.FAvaliable) as FAmount,").append("max(FIsDefaultTNO) as FIsDefaultTNO ").append(" from  ").append(this.runParam.getMrpCalcDetailTableName()).append(" s ").append(" where s.FMRPItem=").append(132).append(" group by s.FMaterialID ) as t ").append(" where mt.fmaterialid = t.fmaterialid");
        SQLUtils.execute((Context)this.runParam.getCtx(), (String)sql.toString());
    }

    private void insertNullInv(List materialFristPeriodList) throws BOSException, MRPException {
        StringBuffer sql = new StringBuffer();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String date = dateFormat.format(this.runParam.getRunStartTime());
        if (MMUtils.isEmptyString((String)this.runParam.getInvDetailTableName())) {
            sql.append("insert into ").append(this.runParam.getMrpCalcDetailTableName()).append(" ( FID ,FMRPItem,FMaterialID,FProjectNumber,FTrackNumber,FBProjectNumber,FBTrackNumber,FAvaliable ").append(",FPLANVERSIONID,FRUNLOGID,FBILLDATE,FPeriod,FIsDefaultTNO,FMrpSeq)").append(" select newbosid('").append("F94043EF").append("'), ").append(110).append(" ,sta.FMaterialID ,sta.FProjectNumber,sta.FTrackNumber,sta.FProjectNumber,").append(" sta.FTrackNumber,0, '  ',' ',TO_DATE('").append(date).append("'),").append(this.runParam.getPlanDate().getPeriod()).append(",FIsDefaultTNO,'").append(MRPSeqUtil.INV_SEQ).append("' ").append(" from ").append(this.runParam.getStatisticsTable()).append(" sta  ").append(" where sta.FPlanStrategy in(").append(MRPPlanStrategyUtil.getInvPlanStrategyStr(true)).append(")").append(" group by sta.FMaterialID ,sta.FProjectNumber,sta.FTrackNumber,FIsDefaultTNO");
        } else {
            sql.append("insert into ").append(this.runParam.getMrpCalcDetailTableName()).append(" ( FID ,FMRPItem,FMaterialID,FProjectNumber,FTrackNumber,FBProjectNumber,FBTrackNumber,FAvaliable ").append(",FPLANVERSIONID,FRUNLOGID,FBILLDATE,FPeriod,FIsDefaultTNO,FMrpSeq)").append(" select newbosid('").append("F94043EF").append("'), ").append(110).append(" ,sta.FMaterialID ,sta.FProjectNumber,sta.FTrackNumber,sta.FProjectNumber,").append(" sta.FTrackNumber,0, '  ',' ',TO_DATE('").append(date).append("'),").append(this.runParam.getPlanDate().getPeriod()).append(",FIsDefaultTNO,'").append(MRPSeqUtil.INV_SEQ).append("' ").append(" from ").append(this.runParam.getStatisticsTable()).append(" sta left join ").append(this.runParam.getInvDetailTableName()).append(" inv on sta.fmaterialid = inv.fmaterialid ").append(" and sta.fprojectNumber=inv.fprojectNumber and sta.ftrackNumber=inv.ftrackNumber ").append(" where inv.fid is null and sta.FPlanStrategy in(").append(MRPPlanStrategyUtil.getInvPlanStrategyStr(true)).append(")").append(" group by sta.FMaterialID ,sta.FProjectNumber,sta.FTrackNumber,FIsDefaultTNO");
        }
        SQLUtils.execute((Context)this.runParam.getCtx(), (String)sql.toString());
        if (materialFristPeriodList != null && materialFristPeriodList.size() != 0) {
            StringBuffer str = new StringBuffer();
            str.append("update ").append(this.runParam.getMrpCalcDetailTableName()).append(" set FPeriod=?").append(" ,FBILLDATE=?").append(" ,FSR=FAvaliable").append(" ,FPAB=FAvaliable").append(" where (FMRPItem = ").append(110).append(" OR FMRPItem =").append(120).append(")").append(" AND FMaterialID =?");
            SQLUtils.executeBatch((Context)this.runParam.getCtx(), (String)str.toString(), (List)materialFristPeriodList);
        }
    }

    private void updateStepLog(MRPRunStepLogInfo stepLogInfo, int dataAmount) throws BOSException, MRPException {
        BigDecimal e = new BigDecimal(String.valueOf(stepLogInfo.getEndTime().getTime()));
        BigDecimal b = new BigDecimal(String.valueOf(stepLogInfo.getBeginTime().getTime()));
        BigDecimal runSecs = e.subtract(b).divide(new BigDecimal("1000"), 2, 4);
        BigDecimal min = runSecs.divide(new BigDecimal("60"), 2, 4);
        StringBuffer sql = new StringBuffer();
        sql.append("update T_MM_MRPRunStepLog set FEndTime = ?,FStatus = ?,FTime = ?,FDataAmount=? where FID = ?");
        SQLUtils.execute((Context)this.runParam.getCtx(), (String)sql.toString(), (Object[])new Object[]{new Date(stepLogInfo.getEndTime().getTime()), new Integer(20), min, new BigDecimal(dataAmount), stepLogInfo.getId().toString()});
    }

    public boolean isGetBill() {
        return this.isGetBill;
    }

    public void setGetBill(boolean isGetBill) {
        this.isGetBill = isGetBill;
    }
}

