/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.app.mrp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.basedata.IPlanVersionSet;
import com.kingdee.eas.mm.basedata.PlanVersionSetFactory;
import com.kingdee.eas.mm.common.app.SQLUtils;
import com.kingdee.eas.mm.planning.MRPException;
import com.kingdee.eas.mm.planning.app.mrp.MRPCalcParam;
import com.kingdee.eas.mm.planning.app.mrp.MRPDate;
import com.kingdee.eas.mm.planning.app.mrp.MRPResource;
import com.kingdee.eas.mm.planning.app.mrp.MRPStep;
import com.kingdee.eas.mm.planning.app.mrp.MRPUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;

public class MRPCalculateDateRange
extends MRPStep {
    @Override
    protected Object innerExecute(MRPCalcParam runParam) throws EASBizException, BOSException {
        IPlanVersionSet iplanver = PlanVersionSetFactory.getLocalInstance((Context)runParam.getCtx());
        HashMap has = iplanver.calculateEndDateByPlan(runParam.getPlanVersionID(), runParam.getPlanDate().getDate().getTime());
        this.setMRPBeginDate(runParam, has);
        this.setMRPEndDate(runParam, has);
        this.getCalendarTable(runParam);
        this.setMaxCalendarWorkDaySeq(runParam);
        return null;
    }

    private void setMRPBeginDate(MRPCalcParam runParam, HashMap has) throws BOSException, MRPException {
        if (runParam.isCooperatePlan()) {
            this.setBegin4Cooperate(runParam, has);
        } else {
            this.setBeginDate4Require(runParam, has);
            this.setBeginDate4Supply(runParam, has);
            if (runParam.getBeginDate4Require().getWorkDaySeqID() <= runParam.getBeginDate4Supply().getWorkDaySeqID()) {
                runParam.setMRPBeginDate(runParam.getBeginDate4Require());
            } else {
                runParam.setMRPBeginDate(runParam.getBeginDate4Supply());
            }
        }
    }

    private void setBegin4Cooperate(MRPCalcParam runParam, HashMap has) {
        Calendar beginDate = Calendar.getInstance();
        MRPDate beginMRPDate = new MRPDate();
        beginDate.setTime((Date)has.get("StartDate"));
        beginMRPDate.setWorkDaySeqID((Integer)has.get("StartDateSeq"));
        beginMRPDate.setCalendarID((String)has.get("StartDateID"));
        beginMRPDate.setDate(beginDate);
        beginMRPDate.setPeriod(beginMRPDate.getWorkDaySeqID());
        runParam.setBeginDate4Require(beginMRPDate);
        runParam.setBeginDate4Supply(beginMRPDate);
        runParam.setMRPBeginDate(beginMRPDate);
    }

    private void setMaxCalendarWorkDaySeq(MRPCalcParam runParam) throws BOSException, MRPException {
        StringBuffer sql = new StringBuffer();
        sql.append("select max(FWorkDateSeq) FSeq  from ").append(runParam.getCalendarTable());
        IRowSet rs = SQLUtils.executeQuery((Context)runParam.getCtx(), (String)sql.toString());
        try {
            if (rs.next()) {
                runParam.setMaxCalendarWorkDaySeq(rs.getInt("FSeq"));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    private void setMRPEndDate(MRPCalcParam runParam, HashMap has) {
        Calendar endDate = Calendar.getInstance();
        endDate.setTime((Date)has.get("EndDate"));
        MRPDate endMRPDate = new MRPDate();
        endMRPDate.setDate(endDate);
        endMRPDate.setCalendarID((String)has.get("EndDateID"));
        endMRPDate.setWorkDaySeqID((Integer)has.get("EndDateSeq"));
        runParam.setMRPEndDate(endMRPDate);
    }

    private void getCalendarTable(MRPCalcParam runParam) throws EASBizException, BOSException {
        String tmp = this.createTempTable(runParam.getCtx());
        StringBuffer sql = new StringBuffer();
        sql.append(" Insert into ").append(tmp).append("(FID,FRWorkDate,FRWorkDateSeq,FRWeekSeq,FRMonthSeq,").append("FSWorkDate,FSWorkDateSeq ,FSWeekSeq,FSMonthSeq,").append("FWorkDate,FWorkDateSeq ,FWeekSeq,FMonthSeq,").append("FNextWorkDaySeq,FPreWorkDaySeq,FRealDate) ").append("select e.FID, e.FWorkDate ,e.FWorkDateSeq,e.FWeekSeq,e.FMonthSeq ,").append("e.FWorkDate ,e.FWorkDateSeq,e.FWeekSeq,e.FMonthSeq,").append("e.FWorkDate ,e.FWorkDateSeq,e.FWeekSeq,e.FMonthSeq,").append("e.FNextWorkDaySeq,e.FPreWorkDaySeq,e.FWorkDate").append(" from  T_MM_FactoryCalendarEntry e ").append(" inner join  T_MM_FactoryCalendar c on c.FID = e.FParentID").append(" where c.FStorageOrgUnitID='").append(runParam.getStorageOrgUnitID()).append("' and c.FIsDefault = 1 ");
        MRPUtil.executeUpdate(runParam.getCtx(), sql.toString());
        sql.setLength(0);
        sql.append("update ").append(tmp).append(" t ").append(" set (FRWorkDate,FRWorkDateSeq,FRWeekSeq,FRMonthSeq)").append(" = ( select t1.FWorkDate,t1.FWorkDateSeq ,t1.FWeekSeq,t1.FMonthSeq from ").append(tmp).append(" t1 ").append("  where t1.FWorkDateSeq = t.FPreWorkDaySeq ").append(" and t.FRWorkDateSeq <=0  and t.FPreWorkDaySeq>0 )");
        MRPUtil.executeUpdate(runParam.getCtx(), sql.toString());
        sql.setLength(0);
        sql.append("update ").append(tmp).append(" t ").append(" set (FRWorkDate,FRWorkDateSeq,FRWeekSeq,FRMonthSeq)").append(" = ( select t1.FWorkDate,t1.FWorkDateSeq ,t1.FWeekSeq,t1.FMonthSeq from ").append(tmp).append(" t1 ").append("  where t1.FWorkDateSeq = t.FNextWorkDaySeq ").append(" and t.FRWorkDateSeq <=0  and t.FNextWorkDaySeq>0 )");
        MRPUtil.executeUpdate(runParam.getCtx(), sql.toString());
        sql.setLength(0);
        sql.append("update ").append(tmp).append(" t ").append(" set (FSWorkDate,FSWorkDateSeq,FSWeekSeq,FSMonthSeq)").append(" = ( select t1.FWorkDate,t1.FWorkDateSeq ,t1.FWeekSeq,t1.FMonthSeq from ").append(tmp).append(" t1 ").append("  where t1.FWorkDateSeq = t.FNextWorkDaySeq ").append(" and t.FSWorkDateSeq <=0  and t.FNextWorkDaySeq>0 )");
        MRPUtil.executeUpdate(runParam.getCtx(), sql.toString());
        runParam.setCalendarTable(tmp);
    }

    private void setBeginDate4Require(MRPCalcParam runParam, HashMap has) throws BOSException, MRPException {
        Calendar beginDate = Calendar.getInstance();
        MRPDate beginMRPDate = new MRPDate();
        if (runParam.getPlanVersion().isIsDelayReq()) {
            if (runParam.getPlanVersion().getDelayReqDay() == 0) {
                beginDate.setTime((Date)has.get("StartDate"));
                beginMRPDate.setWorkDaySeqID((Integer)has.get("StartDateSeq"));
            } else {
                StringBuffer sql = new StringBuffer();
                sql.append("select caentry.FWorkDate FWorkDate,caentry.FWorkDateSeq FWorkDateSeq ").append("from T_MM_FactoryCalendarEntry caentry inner join T_MM_FactoryCalendar ca ").append("on ca.FID = caentry.FParentID ").append("where ca.FStorageOrgUnitID='").append(runParam.getStorageOrgUnitID()).append("' and ca.FIsDefault = 1 ").append("and caentry.FWorkDateSeq = ").append(runParam.getPlanDate().getWorkDaySeqID() - runParam.getPlanVersion().getDelayReqDay());
                IRowSet rs = SQLUtils.executeQuery((Context)runParam.getCtx(), (String)sql.toString());
                try {
                    if (rs.next()) {
                        beginDate.setTime(rs.getDate("FWorkDate"));
                        beginMRPDate.setWorkDaySeqID(rs.getInt("FWorkDateSeq"));
                    }
                    beginDate.setTime((Date)has.get("StartDate"));
                    beginMRPDate.setWorkDaySeqID((Integer)has.get("StartDateSeq"));
                }
                catch (SQLException e) {
                    throw new SQLDataException(e);
                }
            }
        } else {
            beginDate.setTime(runParam.getPlanDate().getDate().getTime());
            beginMRPDate.setWorkDaySeqID(runParam.getPlanDate().getWorkDaySeqID());
        }
        beginMRPDate.setCalendarID((String)has.get("StartDateID"));
        beginMRPDate.setDate(beginDate);
        beginMRPDate.setPeriod(beginMRPDate.getWorkDaySeqID());
        runParam.setBeginDate4Require(beginMRPDate);
    }

    private void setBeginDate4Supply(MRPCalcParam runParam, HashMap has) throws BOSException, MRPException {
        Calendar beginDate = Calendar.getInstance();
        MRPDate beginMRPDate = new MRPDate();
        if (runParam.getPlanVersion().isIsDelaySupply()) {
            if (runParam.getPlanVersion().getDelaySupplyDay() == 0) {
                beginDate.setTime((Date)has.get("StartDate"));
                beginMRPDate.setWorkDaySeqID((Integer)has.get("StartDateSeq"));
            } else {
                StringBuffer sql = new StringBuffer();
                sql.append("select caentry.FWorkDate FWorkDate,caentry.FWorkDateSeq FWorkDateSeq ").append("from T_MM_FactoryCalendarEntry caentry inner join T_MM_FactoryCalendar ca ").append("on ca.FID = caentry.FParentID ").append("where ca.FStorageOrgUnitID='").append(runParam.getStorageOrgUnitID()).append("' and ca.FIsDefault=1 ").append("and caentry.FWorkDateSeq = ").append(runParam.getPlanDate().getWorkDaySeqID() - runParam.getPlanVersion().getDelaySupplyDay());
                IRowSet rs = SQLUtils.executeQuery((Context)runParam.getCtx(), (String)sql.toString());
                try {
                    if (rs.next()) {
                        beginDate.setTime(rs.getDate("FWorkDate"));
                        beginMRPDate.setWorkDaySeqID(rs.getInt("FWorkDateSeq"));
                    }
                    beginDate.setTime((Date)has.get("StartDate"));
                    beginMRPDate.setWorkDaySeqID((Integer)has.get("StartDateSeq"));
                }
                catch (SQLException e) {
                    throw new SQLDataException(e);
                }
            }
        } else {
            beginDate.setTime(runParam.getPlanDate().getDate().getTime());
            beginMRPDate.setWorkDaySeqID(runParam.getPlanDate().getWorkDaySeqID());
        }
        beginMRPDate.setCalendarID((String)has.get("StartDateID"));
        beginMRPDate.setDate(beginDate);
        beginMRPDate.setPeriod(beginMRPDate.getWorkDaySeqID());
        runParam.setBeginDate4Supply(beginMRPDate);
    }

    private String createTempTable(Context ctx) throws BOSException, EASBizException {
        String expandTablName = null;
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        try {
            StringBuffer sqlBuf = new StringBuffer();
            sqlBuf.append("create table tttttt (").append("FID varchar(44) not null, ").append("FRWorkDate DATETIME  not null,").append("FRWorkDateSeq int  not null,").append("FRWeekSeq int not null,").append("FRMonthSeq int not null,").append("FSWorkDate DATETIME  not null,").append("FSWorkDateSeq int  not null,").append("FSWeekSeq int not null,").append("FSMonthSeq int not null,").append("FWorkDate DATETIME  not null,").append("FWorkDateSeq int  not null,").append("FWeekSeq int not null,").append("FMonthSeq int not null, ").append("FNextWorkDaySeq int not null,").append("FPreWorkDaySeq int not null,").append("FRealDate DATETIME not null ").append(")");
            expandTablName = pool.createTempTable(sqlBuf.toString());
            pool.createIndex(expandTablName, "FRealDate,FRWorkDate,FRWorkDateSeq", false, false);
            pool.createIndex(expandTablName, "FRealDate,FSWorkDateSeq", false, false);
            pool.createIndex(expandTablName, "FWorkDateSeq,FWorkDate", false, false);
        }
        catch (Exception e1) {
            throw new BOSException((Throwable)e1);
        }
        return expandTablName;
    }

    @Override
    protected String getStepDesc(MRPCalcParam runParam) throws MRPException, BOSException {
        StringBuffer sb = new StringBuffer(MRPResource.getString(runParam.getCtx(), "SP_CALCDATERANGE")).append("\r\n");
        DateFormat dtformat = BOSLocaleUtil.getDateFormat();
        if (runParam.getMRPBeginDate() != null) {
            sb.append(MRPResource.getString(runParam.getCtx(), "RUNSRART_TIME")).append(dtformat.format(runParam.getMRPBeginDate().getDate().getTime()));
        }
        if (runParam.getMRPEndDate() != null) {
            sb.append(MRPResource.getString(runParam.getCtx(), "RUNEND_TIME")).append(dtformat.format(runParam.getMRPEndDate().getDate().getTime()));
        }
        if (this.getLogInfo() != null) {
            this.getLogInfo().setName(sb.toString());
        }
        return sb.toString();
    }

    @Override
    protected boolean isNeedUpdateProgress() {
        return true;
    }
}

