/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.app.mrp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.basedata.AllocationStrategyInfo;
import com.kingdee.eas.mm.basedata.CollabMaterialEntryFactory;
import com.kingdee.eas.mm.basedata.CollabMaterialEntryInfo;
import com.kingdee.eas.mm.basedata.CollabSupplyOrgEntryCollection;
import com.kingdee.eas.mm.basedata.CollabSupplyOrgEntryInfo;
import com.kingdee.eas.mm.basedata.ICollabMaterialEntry;
import com.kingdee.eas.mm.basedata.RequirementAllotRuleEnum;
import com.kingdee.eas.mm.planning.MRPClassifyEnum;
import com.kingdee.eas.mm.planning.MRPElementEnum;
import com.kingdee.eas.mm.planning.MRPException;
import com.kingdee.eas.mm.planning.app.mrp.MRPAjustMent;
import com.kingdee.eas.mm.planning.app.mrp.MRPCalcParam;
import com.kingdee.eas.mm.planning.app.mrp.MRPConstant;
import com.kingdee.eas.mm.planning.app.mrp.MRPDate;
import com.kingdee.eas.mm.planning.app.mrp.MRPDetailInfo;
import com.kingdee.eas.mm.planning.app.mrp.MRPMaterialDataInfo;
import com.kingdee.eas.mm.planning.app.mrp.MRPMaterialStatisticsInfo;
import com.kingdee.eas.mm.planning.app.mrp.MRPUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class MRPCmpsAjustMent
extends MRPAjustMent {
    protected static Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.planning.app.mrp.MRPcmpsAjustMent");
    private HashMap collabMaterial = new HashMap();
    private static final String bomid = " ";
    private int precision = 0;

    public MRPCmpsAjustMent(List materialIDLst, MRPCalcParam runParam) throws MRPException, BOSException {
        super(materialIDLst, runParam);
    }

    @Override
    protected boolean doAdvance(MRPMaterialDataInfo materialDataInfo, MRPMaterialStatisticsInfo statisticsInfo, MRPDetailInfo detailInfo, BigDecimal pab_t_1, int period, boolean isMergeSign) throws BOSException, EASBizException {
        detailInfo.setNetReqQty(pab_t_1);
        return false;
    }

    @Override
    protected void delayCancle(MRPMaterialDataInfo materialDataInfo, MRPMaterialStatisticsInfo statisticsInfo, ArrayList detailDatas, int period) throws BOSException, EASBizException {
        BigDecimal pab = statisticsInfo.getRQty().add(statisticsInfo.getOnHand()).add((BigDecimal)this.preQty.get(this.key)).add(statisticsInfo.getPreQty()).add(statisticsInfo.getSQty());
        this.preQty.put(this.key, pab);
    }

    @Override
    protected MRPDetailInfo createPlanOrder(MRPMaterialDataInfo materialDataInfo, BigDecimal pab_t_1, BigDecimal avaliableSupply, MRPDate orderDate, MRPDate replanDate, MRPDetailInfo theLineInfo, boolean isMergeSign) throws EASBizException, BOSException {
        MRPDetailInfo orderLineInfo = new MRPDetailInfo();
        this.precision = materialDataInfo.getBaseQtyPrc();
        String collabMaterialEntryID = null;
        orderLineInfo.setID(BOSUuid.create((String)"F94043EF").toString());
        orderLineInfo.setMaterialID(materialDataInfo.getMaterialID());
        orderLineInfo.setPlanningMode(materialDataInfo.getPlanningMode());
        orderLineInfo.setMrpClassify(MRPClassifyEnum.Supply);
        orderLineInfo.setMrpItem(MRPElementEnum.S_CPlannedOrder);
        orderLineInfo.setBillSeqNo(270);
        orderLineInfo.setBillType("tMCsjuu0TMO+jMoUTkrsSkY+1VI=");
        orderLineInfo.setPriority(0 + this.runParam.getGenOrderCount());
        orderLineInfo.setBillID(BOSUuid.create((String)"375FC562").toString());
        orderLineInfo.setRePlanDATE(orderDate);
        if (!this.runParam.getRunLogInfo().isIsDelayOrder() && orderDate.before(this.runParam.getPlanDate())) {
            orderLineInfo.setBillDate(this.runParam.getPlanDate());
        } else {
            orderLineInfo.setBillDate(orderDate);
        }
        orderLineInfo.setNewOrder(true);
        orderLineInfo.setBaseStatus(2);
        String orderNumber = this.getOrderNumber();
        orderLineInfo.setBillNumber(orderNumber);
        orderLineInfo.setAvaliableQty(pab_t_1);
        orderLineInfo.setNetReqQty(pab_t_1);
        orderLineInfo.setTotalLine(isMergeSign);
        orderLineInfo.setIsDeaultTNO(theLineInfo.getIsDeaultTNO());
        orderLineInfo.setBProjectID(theLineInfo.getBProjectID());
        orderLineInfo.setBTrackID(theLineInfo.getBTrackID());
        orderLineInfo.setProjectID(theLineInfo.getProjectID());
        orderLineInfo.setTrackID(theLineInfo.getTrackID());
        orderLineInfo.setProjectNumber(theLineInfo.getProjectNumber());
        orderLineInfo.setTrackNumber(theLineInfo.getTrackNumber());
        orderLineInfo.setBProjectNumber(theLineInfo.getBProjectNumber());
        orderLineInfo.setBTrackNumber(theLineInfo.getBTrackNumber());
        orderLineInfo.setPeriod(theLineInfo.getPeriod());
        orderLineInfo.setBomID(theLineInfo.getBomID());
        orderLineInfo.setYield(theLineInfo.getYield());
        orderLineInfo.setBomType(theLineInfo.getBomType());
        Calendar tDate = MRPUtil.copyDate(orderDate.getDate());
        if (!isMergeSign) {
            if (theLineInfo.getMrpItem().equals((Object)MRPElementEnum.R_SID) || theLineInfo.getMrpItem().equals((Object)MRPElementEnum.R_SID)) {
                orderLineInfo.setSrcBillID(theLineInfo.getSrcBillID());
                orderLineInfo.setSrcBillType(theLineInfo.getSrcBillType());
                orderLineInfo.setSrcBillEntryID(theLineInfo.getSrcBillEntryID());
                orderLineInfo.setSrcBillNumber(theLineInfo.getSrcBillNumber());
                orderLineInfo.setSrcBillRowSeq(theLineInfo.getBillRowSeq());
            } else {
                orderLineInfo.setSrcBillID(theLineInfo.getBillID());
                orderLineInfo.setSrcBillType(theLineInfo.getBillType());
                orderLineInfo.setSrcBillNumber(theLineInfo.getBillNumber());
                orderLineInfo.setSrcBillEntryID(theLineInfo.getBillEntryID());
            }
        }
        tDate.add(5, materialDataInfo.getReceiveLeadTime() * -1);
        orderLineInfo.setPlanBeginDate(this.getMRPDate(tDate));
        orderLineInfo.setPlanEndDate(orderLineInfo.getPlanBeginDate());
        orderLineInfo.setYield(new BigDecimal("100.00"));
        orderLineInfo.setPlannedQty(theLineInfo.getPlannedQty());
        collabMaterialEntryID = materialDataInfo.getCollabMaterialEntryID();
        CollabMaterialEntryInfo collabMaterialEntryInfo = this.getAllocationInfo(collabMaterialEntryID);
        orderLineInfo.setScheduledReceiptQty(orderLineInfo.getPlannedQty());
        orderLineInfo.setSsrQty(orderLineInfo.getPlannedQty());
        this.distributeNetQty(materialDataInfo, orderLineInfo, collabMaterialEntryInfo);
        this.dataSaver.addInsertList(orderLineInfo);
        this.dataSaver.addMrpPlanOrder(orderLineInfo);
        this.runParam.generateOrder();
        orderLineInfo.setBomID(bomid);
        orderLineInfo.setBomType(45);
        this.genExceptions(materialDataInfo, orderLineInfo, pab_t_1.add(orderLineInfo.getScheduledReceiptQty()));
        return orderLineInfo;
    }

    private CollabMaterialEntryInfo getAllocationInfo(String collabMaterialEntryID) throws BOSException, EASBizException {
        CollabMaterialEntryInfo collabMaterialEntryInfo = null;
        collabMaterialEntryInfo = (CollabMaterialEntryInfo)this.collabMaterial.get(collabMaterialEntryID);
        if (collabMaterialEntryInfo == null) {
            ICollabMaterialEntry i = CollabMaterialEntryFactory.getLocalInstance((Context)this.runParam.getCtx());
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.setSelector(this.getSelectors());
            SorterItemInfo seq_SorterItemInfo = new SorterItemInfo("seq");
            seq_SorterItemInfo.setSortType(SortType.DESCEND);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)collabMaterialEntryID, CompareType.EQUALS));
            viewInfo.setFilter(filter);
            viewInfo.getSorter().add(seq_SorterItemInfo);
            collabMaterialEntryInfo = i.getCollabMaterialEntryInfo((IObjectPK)new ObjectUuidPK(collabMaterialEntryID), this.getSelectors());
            this.collabMaterial.put(collabMaterialEntryID, collabMaterialEntryInfo);
        }
        collabMaterialEntryInfo.getCollabReqOrgEntrys().get(0).getCollabSupplyOrgEntrys();
        return collabMaterialEntryInfo;
    }

    private void distributeNetQty(MRPMaterialDataInfo materialDataInfo, MRPDetailInfo orderLineInfo, CollabMaterialEntryInfo collabMaterialEntryInfo) throws BOSException, EASBizException {
        AllocationStrategyInfo strategyInfo = collabMaterialEntryInfo.getAllocationStrategy();
        RequirementAllotRuleEnum requirementAllotRuleEnum = strategyInfo.getReqAllocationStrategy();
        switch (requirementAllotRuleEnum.getValue()) {
            case 10: {
                this.fixProportion(orderLineInfo, collabMaterialEntryInfo);
                break;
            }
            case 20: {
                this.costPriority(orderLineInfo, collabMaterialEntryInfo);
                break;
            }
            case 30: {
                this.servicePriority(orderLineInfo, collabMaterialEntryInfo);
                break;
            }
        }
    }

    private void fixProportion(MRPDetailInfo orderLineInfo, CollabMaterialEntryInfo collabMaterialEntryInfo) throws BOSException, EASBizException {
        int i;
        CollabSupplyOrgEntryCollection collection = collabMaterialEntryInfo.getCollabReqOrgEntrys().get(0).getCollabSupplyOrgEntrys();
        CollabSupplyOrgEntryInfo supplyOrgEntryInfo = null;
        MRPDetailInfo entryLineInfo = (MRPDetailInfo)orderLineInfo.clone();
        entryLineInfo.setPlannedQty(MRPConstant.ZERO);
        entryLineInfo.setYield(MRPConstant.ZERO);
        BigDecimal proporttion = null;
        BigDecimal totalQty = new BigDecimal(0);
        totalQty = totalQty.setScale(this.precision, 0);
        int index = 0;
        for (i = collection.size() - 1; i >= 0; --i) {
            supplyOrgEntryInfo = collection.get(i);
            proporttion = supplyOrgEntryInfo.getReqAllotProportion();
            if (proporttion.compareTo(MRPConstant.ZERO) <= 0) continue;
            index = i;
            break;
        }
        for (i = 0; i < collection.size(); ++i) {
            entryLineInfo.setID(BOSUuid.create((String)"F94043EF").toString());
            supplyOrgEntryInfo = collection.get(i);
            Calendar tDate = MRPUtil.copyDate(entryLineInfo.getPlanBeginDate().getDate());
            tDate.add(5, supplyOrgEntryInfo.getTransportLeadTime() * -1);
            entryLineInfo.setPlanEndDate(this.getMRPDate(tDate));
            proporttion = supplyOrgEntryInfo.getReqAllotProportion();
            entryLineInfo.setYield(proporttion);
            proporttion = proporttion.divide(new BigDecimal("100"), 4, 0);
            entryLineInfo.setSupplyStorageOrgUnitID(supplyOrgEntryInfo.getSupplyOrgUnit().getId().toString());
            if (i == index) {
                entryLineInfo.setScheduledReceiptQty(orderLineInfo.getPlannedQty().subtract(totalQty).setScale(this.precision, 0));
            } else {
                entryLineInfo.setScheduledReceiptQty(proporttion.multiply(orderLineInfo.getPlannedQty()).setScale(this.precision, 0));
            }
            totalQty = totalQty.add(entryLineInfo.getScheduledReceiptQty());
            totalQty = totalQty.setScale(this.precision, 0);
            this.dataSaver.addInsertList(entryLineInfo);
            entryLineInfo = (MRPDetailInfo)entryLineInfo.clone();
        }
    }

    private void costPriority(MRPDetailInfo orderLineInfo, CollabMaterialEntryInfo collabMaterialEntryInfo) throws BOSException, EASBizException {
        CollabSupplyOrgEntryCollection collection = collabMaterialEntryInfo.getCollabReqOrgEntrys().get(0).getCollabSupplyOrgEntrys();
        CollabSupplyOrgEntryCollection mincollection = new CollabSupplyOrgEntryCollection();
        CollabSupplyOrgEntryInfo supplyOrgEntryInfo = null;
        MRPDetailInfo entryLineInfo = (MRPDetailInfo)orderLineInfo.clone();
        entryLineInfo.setPlannedQty(MRPConstant.ZERO);
        entryLineInfo.setYield(MRPConstant.ZERO);
        BigDecimal costQty = null;
        BigDecimal lastcostQty = null;
        BigDecimal totalQty = MRPConstant.ZERO;
        for (int i = 0; i < collection.size(); ++i) {
            supplyOrgEntryInfo = collection.get(i);
            if (supplyOrgEntryInfo.getBatch().compareTo(MRPConstant.ZERO) == 0) {
                supplyOrgEntryInfo.setBatch(new BigDecimal("1.0"));
            }
            costQty = orderLineInfo.getPlannedQty().divide(supplyOrgEntryInfo.getBatch(), 0).multiply(supplyOrgEntryInfo.getBatchCost()).add(orderLineInfo.getPlannedQty().multiply(supplyOrgEntryInfo.getUnitCost())).add(supplyOrgEntryInfo.getFixedCost());
            if (i == 0) {
                lastcostQty = costQty;
            }
            if (lastcostQty.compareTo(costQty) > 0) {
                lastcostQty = costQty;
                mincollection.clear();
                mincollection.add(supplyOrgEntryInfo);
            }
            if (lastcostQty.compareTo(costQty) != 0) continue;
            mincollection.add(supplyOrgEntryInfo);
        }
        BigDecimal size = new BigDecimal(mincollection.size());
        BigDecimal qty = orderLineInfo.getPlannedQty().divide(size, this.precision, 0);
        for (int i = 0; i < mincollection.size(); ++i) {
            supplyOrgEntryInfo = mincollection.get(i);
            Calendar tDate = MRPUtil.copyDate(entryLineInfo.getPlanBeginDate().getDate());
            tDate.add(5, supplyOrgEntryInfo.getTransportLeadTime() * -1);
            entryLineInfo.setPlanEndDate(this.getMRPDate(tDate));
            entryLineInfo.setID(BOSUuid.create((String)"F94043EF").toString());
            entryLineInfo.setSupplyStorageOrgUnitID(supplyOrgEntryInfo.getSupplyOrgUnit().getId().toString());
            if (i < mincollection.size() - 1) {
                entryLineInfo.setScheduledReceiptQty(qty);
            } else {
                entryLineInfo.setScheduledReceiptQty(orderLineInfo.getPlannedQty().subtract(totalQty).setScale(this.precision, 0));
            }
            totalQty = totalQty.add(qty);
            totalQty = totalQty.setScale(this.precision, 0);
            this.dataSaver.addInsertList(entryLineInfo);
            entryLineInfo = (MRPDetailInfo)entryLineInfo.clone();
        }
    }

    private void servicePriority(MRPDetailInfo orderLineInfo, CollabMaterialEntryInfo collabMaterialEntryInfo) throws BOSException, EASBizException {
        CollabSupplyOrgEntryCollection collection = collabMaterialEntryInfo.getCollabReqOrgEntrys().get(0).getCollabSupplyOrgEntrys();
        CollabSupplyOrgEntryCollection mincollection = new CollabSupplyOrgEntryCollection();
        CollabSupplyOrgEntryInfo supplyOrgEntryInfo = null;
        MRPDetailInfo entryLineInfo = (MRPDetailInfo)orderLineInfo.clone();
        entryLineInfo.setPlannedQty(MRPConstant.ZERO);
        entryLineInfo.setYield(MRPConstant.ZERO);
        int time = 0;
        int lasttime = 0;
        BigDecimal totalQty = MRPConstant.ZERO;
        for (int i = 0; i < collection.size(); ++i) {
            supplyOrgEntryInfo = collection.get(i);
            time = supplyOrgEntryInfo.getTotalLeadTime() + supplyOrgEntryInfo.getTransportLeadTime();
            if (i == 0) {
                lasttime = time;
            }
            if (lasttime > time) {
                lasttime = time;
                mincollection.clear();
                mincollection.add(supplyOrgEntryInfo);
            }
            if (lasttime != time) continue;
            mincollection.add(supplyOrgEntryInfo);
        }
        BigDecimal size = new BigDecimal(mincollection.size());
        BigDecimal qty = orderLineInfo.getPlannedQty().divide(size, this.precision, 0);
        for (int i = 0; i < mincollection.size(); ++i) {
            supplyOrgEntryInfo = mincollection.get(i);
            Calendar tDate = MRPUtil.copyDate(entryLineInfo.getPlanBeginDate().getDate());
            tDate.add(5, supplyOrgEntryInfo.getTransportLeadTime() * -1);
            entryLineInfo.setPlanEndDate(this.getMRPDate(tDate));
            entryLineInfo.setID(BOSUuid.create((String)"F94043EF").toString());
            entryLineInfo.setSupplyStorageOrgUnitID(supplyOrgEntryInfo.getSupplyOrgUnit().getId().toString());
            if (i < mincollection.size() - 1) {
                entryLineInfo.setScheduledReceiptQty(qty);
            } else {
                entryLineInfo.setScheduledReceiptQty(orderLineInfo.getPlannedQty().subtract(totalQty).setScale(this.precision, 0));
            }
            totalQty = totalQty.add(qty);
            totalQty = totalQty.setScale(this.precision, 0);
            this.dataSaver.addInsertList(entryLineInfo);
            entryLineInfo = (MRPDetailInfo)entryLineInfo.clone();
        }
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("collabReqOrgEntrys.collabSupplyOrgEntrys.supplyOrgUnit.name"));
        sic.add(new SelectorItemInfo("collabReqOrgEntrys.collabSupplyOrgEntrys.reqAllotProportion"));
        sic.add(new SelectorItemInfo("collabReqOrgEntrys.collabSupplyOrgEntrys.fixedCost"));
        sic.add(new SelectorItemInfo("collabReqOrgEntrys.collabSupplyOrgEntrys.batch"));
        sic.add(new SelectorItemInfo("collabReqOrgEntrys.collabSupplyOrgEntrys.batchCost"));
        sic.add(new SelectorItemInfo("collabReqOrgEntrys.collabSupplyOrgEntrys.unitCost"));
        sic.add(new SelectorItemInfo("collabReqOrgEntrys.collabSupplyOrgEntrys.supplyOrgUnit.id"));
        sic.add(new SelectorItemInfo("collabReqOrgEntrys.collabSupplyOrgEntrys.*"));
        sic.add(new SelectorItemInfo("allocationStrategy.*"));
        return sic;
    }
}

