/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.app.mrp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.sql.DbType;
import com.kingdee.bos.sql.SqlTranslateException;
import com.kingdee.bos.sql.TransUtil;
import com.kingdee.bos.sql.util.UUTN;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.common.app.SQLUtils;
import com.kingdee.eas.mm.common.util.MMUtils;
import com.kingdee.eas.mm.planning.MRPRunLogInfo;
import com.kingdee.eas.mm.planning.app.mrp.MRPCalcParam;
import com.kingdee.eas.mm.planning.app.mrp.MRPRunningTablesInfo;
import com.kingdee.eas.mm.planning.app.mrp.MRPStrategySelectGenerator;
import com.kingdee.eas.mm.planning.app.mrp.MRPTableUpgrader;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MRPDynamicTableManager {
    public static final int TABLE_VERSION = 120;
    private static final String CLR = "\r\n";
    private static final String TABLE_PREFIX_MATERAIL = "T_MM_MT";
    private static final String TABLE_PREFIX_DETAIL = "T_MM_DT";
    private static final String TABLE_PREFIX_EXCEPTION = "T_MM_EX";
    private static final String CONSTRAINT_PREFIX = "PK_MM";
    private static final String INDEX_PREFIX = "IX_MM";
    public static final String INV = "T_MM_INV";
    public static final String MATERIALTABLE = "material";
    public static final String DETAILTABLE = "detail";
    public static final String EXCEPTION = "exception";
    public static final String SQL_CREATE_MATERIALTABLE = "Create Table {0} ( \r\nFID VARCHAR(44) NOT NULL,\r\nFPlanVersionID VARCHAR(44) NOT NULL,\r\nFRunLogID VARCHAR(44) NOT NULL,\r\nFMaterialID VARCHAR(44) NOT NULL,\r\nFMaterialNumber NVARCHAR(80),\r\nFBaseUnitID VARCHAR(44) NOT NULL,\r\nFBaseQtyPrc Integer not null default 4,FProdUnitID VARCHAR(44) NOT NULL,\r\nFProdQtyPrc Integer not null default 4,FConvertRate NUMERIC(21,8) not null default 1,FPlanner VARCHAR(44) null,FLowsetCode INTEGER not null default 999,\r\nFOnHand NUMERIC(21,8) not null default 0,\r\nFSafeStock NUMERIC(21,8) not null default 0,\r\nFQtyMax NUMERIC(21,8) not null default 0,\r\nFIsMergeSign INTEGER not null default 0,\r\nFYield NUMERIC(21,8) not null default 100,\r\nFPlanStrategy VARCHAR(44) NOT NULL,\r\nFBatchPolicy INTEGER not null default 1,\r\nFFixationBatchQty NUMERIC(21,8) ,\r\nFMinBatchQty NUMERIC(21,8), \r\nFRoundUpMultipleQty NUMERIC(21,8), \r\nFBatchIncQty NUMERIC(21,8), \r\nFQtyMinPackage NUMERIC(21,8), \r\nFMaterialAttr INTEGER not null default 10060,\r\nFPlanningMode INTEGER not null default 0,\r\nFRecevingLeadTime INTEGER not null default 0,\r\nFProduceLeadTime INTEGER not null default 0,\r\nFForwardProcessTime INTEGER not null default 0,\r\nFBackwardProcessTime INTEGER not null default 0,\r\nFBOMID VARCHAR(44),\r\nFIsProcessed INTEGER not null default 0,\r\nFSupplyType INTEGER null,\r\nFSupplyOrgUnitID varchar(44) null,\r\nFSubstitute  INTEGER DEFAULT 0 NOT NULL , FSubstituteGroup INTEGER DEFAULT 0 NOT NULL, FCalcSeq INTEGER DEFAULT 0 NOT NULL,  FfixStock NUMERIC(21,8) DEFAULT 0 NOT NULL , FManufactureDepartment VARCHAR(44) ,\r\nFisNewOrder INTEGER not null default 0,\r\nFhasExceptions INTEGER not null default 0,\r\nFhasStockExp INTEGER not null default 0,\r\nFCollabMaterialEntryID  varchar(44),FRequirementUniteRuleID varchar(44),FProductTranTypeID varchar(44), FLeadTimeType INTEGER not null default 0,\r\nFChangeLeadTime INTEGER not null default 0,\r\nFChangeBatch INTEGER not null default 0,\r\nFisCanNotThrow INTEGER not null default 0,\r\nFisolateRules varchar(30) not null default ''ITEM_TRACKNO'' ,\r\nFInvDetailId varchar(44),\r\nFPartitionQty INTEGER not null default 0, \r\nFMaxBatchQty NUMERIC(21,8),\r\nFBatchCycle INTEGER not null default 0,\r\nFIsSurplusDivert INTEGER not null default 0,\r\nFisComReqConsume INTEGER not null default 0,\r\nFPlanOrgUnit varchar(44),\r\nCONSTRAINT {1} PRIMARY KEY (FID))";
    public static final String SQL_CREATE_MATERIALTABLE_IX_1 = "CREATE INDEX {0} ON {1} (FMaterialID,FRunLogID)";
    public static final String SQL_CREATE_MATERIALTABLE_IX_2 = "CREATE INDEX {0} ON {1} (FLowsetCode,FRunLogID)";
    public static final String SQL_CREATE_DETAILTABLE = "Create Table {0} ( FID VARCHAR(44) NOT NULL,FPlanVersionID VARCHAR(44) NOT NULL,\r\nFRunLogID VARCHAR(44) NOT NULL,\r\nFPlanningMode INTEGER not null default 0,\r\nFMaterialID VARCHAR(44) NOT NULL,FMRPClassify INTEGER not null default 0,\r\nFMRPItem INTEGER not null default 0,\r\nFParentMateiralID VARCHAR(44),\r\nFSrcBillType VARCHAR(44),\r\nFSrcBillID VARCHAR(44),\r\nFSrcBillNumber NVARCHAR(80),\r\nFSrcBillEntryID VARCHAR(44),\r\nFSrcBillEntrySeq INTEGER not null default 0,\r\nFBillID VARCHAR(44),\r\nFBillEntryID VARCHAR(44),\r\nFBillDate DATETIME NOT NULL,\r\nFCalendarID VARCHAR(44),\r\nFWorkDaySeqID INTEGER not null default 0,\r\nFWeekSeqID INTEGER not null default 0,\r\nFMonthSeqID INTEGER not null default 0,\r\nFBillType VARCHAR(44),\r\nFBillNumber NVARCHAR(80),\r\nFBillSeqNo INTEGER not null default 99,\r\nFBillRowSeq INTEGER not null default 0,\r\nFDisplaySeq INTEGER not null default 0,\r\nFAvaliable NUMERIC(21,8) not null default 0,\r\nFSR NUMERIC(21,8) not null default 0,\r\nFSSR NUMERIC(21,8) not null default 0,\r\nFAllocation NUMERIC(21,8)not null default 0,\r\nFIndependent NUMERIC(21,8) not null default 0,\r\nFDependent NUMERIC(21,8) not null default 0,\r\nFNetReq NUMERIC(21,8) not null default 0,\r\nFPlannedQty NUMERIC(21,8) not null default 0,\r\nFPlanBeginDate DATETIME,\r\nFBeginDateWorkdayID Integer,\r\nFPlanEndDate DATETIME,\r\nFEndDateWorkdayID Integer,\r\nFPAB NUMERIC(21,8) not null default 0,\r\nFException1 Integer not null default 0,\r\nFException2 Integer not null default 0,\r\nFException3 Integer not null default 0,\r\nFException4 Integer not null default 0,\r\nFException5 Integer not null default 0,\r\nFException6 Integer not null default 0,\r\nFException7 Integer not null default 0,\r\nFIsDayEnd INTEGER not null default 0,\r\nFIsWeekEnd INTEGER not null default 0,\r\nFIsMonthEnd INTEGER not null default 0,\r\nFIsDelay INTEGER not null default 0,\r\nFIsTotalLine INTEGER not null default 0,\r\nFIsCalc INTEGER not null default 0,\r\nFSupplyOrgUnitID varchar(44) null,\r\nFIsNewOrder int not null default 0,\r\nFOutputType int not null default 0,\r\nFPROJECTID  VARCHAR(44),\r\nFTRACKID    VARCHAR(44),\r\nFBomID    VARCHAR(44),\r\nFYield NUMERIC(21,8) ,\r\nFAjustFlag INTEGER DEFAULT 0 NOT NULL, FAjustQty  NUMERIC(21,8) DEFAULT 0 NOT NULL ,FIsAjust  INTEGER DEFAULT 0 NOT NULL, FPriority INTEGER DEFAULT 0 NOT NULL, FSID varchar(44), FProjectNumber nvarchar(80), FTrackNumber  nvarchar(80),FBProjectID varchar(44), FBTrackID varchar(44), FBProjectNumber nvarchar(80), FBTrackNumber nvarchar(80),FParentBomID varchar(44),FIsDefaultTNO INTEGER DEFAULT 1 NOT NULL,FPeriod INTEGER DEFAULT 1 NOT NULL,FRePlanDATE  DATETIME,FBizTypeID varchar(44) , FBaseStatus Integer not null default 0 , FBomType Integer not null default 0 , FSPeriod INTEGER DEFAULT 0 NOT NULL,FSupplyType Integer not null default 0 , FIsDirectTransport Integer not null default 0,  FRequireMentID varchar(44), FUnitQty NUMERIC(21,8) not null default 1 ,FReplaceVersionID varchar(44) ,FReplaceVersionEntryID varchar(44) ,FSaleOrderID varchar(44) ,\r\nFSaleOrderEntryID varchar(44) ,\r\nFSaleOrderNumber nvarchar(80) ,\r\nFSaleOrderEntrySeq INTEGER not null default 0,\r\nFisCanNotThrow INTEGER not null default 0,\r\nFMrpSeq varchar(100),\r\nFHierarchyCode varchar(500),\r\nFexception8 Integer not null default 0,\r\nFHasSplit INTEGER not null default 0,\r\nFDesc64 varchar(255),\r\nFIsMatch Integer not null default 0,\r\nCONSTRAINT {1} PRIMARY KEY (FID))";
    public static final String SQL_CREATE_DETAILTABLE_IX_PlanID = "CREATE INDEX {0} ON {1} (FMaterialID,FPeriod,FProjectNumber,FTrackNumber)";
    public static final String SQL_CREATE_DETAILTABLE_IX_PERIOD = "CREATE INDEX {0} ON {1} (FPeriod,FMRPClassify)";
    public static final String SQL_INSERT_MRP_TABLE = "INSERT INTO T_MM_RunningTables (FID,FStorageOrgUnitID,FPlanVerID,FPlanVerNum,FTableName,FTableType,FVersion,FIsFormal,FmaterialRange) VALUES (?,?,?,?,?,?,?,?,?) ";

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized List getTableName(Context ctx, String storageOrgUnitID, String planVerID, boolean isFormal) throws BOSException, EASBizException {
        void var9_13;
        String sql = "select * from T_MM_RunningTables where fstorageOrgUnitId = ? and fplanverid = ? and FIsFormal=? order by FTableType desc";
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        String planVerNum = null;
        ArrayList<MRPRunningTablesInfo> arrayList = new ArrayList<MRPRunningTablesInfo>();
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, storageOrgUnitID);
            pstmt.setString(2, planVerID);
            pstmt.setBoolean(3, isFormal);
            rs = pstmt.executeQuery();
            int tableVersion = 0;
            while (rs.next()) {
                arrayList.add(MRPRunningTablesInfo.readRow(rs));
                if (tableVersion == 0) {
                    tableVersion = rs.getInt("FVersion");
                    continue;
                }
                tableVersion = rs.getInt("FVersion") < tableVersion ? rs.getInt("FVersion") : tableVersion;
            }
            if (arrayList.size() == 0) {
                rs.close();
                pstmt.close();
                String sqlGetPlan = "select FNumber from T_MM_PlanVersionSet where FID = ? ";
                pstmt = conn.prepareStatement(sqlGetPlan);
                pstmt.setString(1, planVerID);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    planVerNum = rs.getString("FNumber");
                    List list = MRPDynamicTableManager.createPhysicalTableAndInsert(ctx, conn, storageOrgUnitID, planVerID, planVerNum, isFormal);
                } else {
                    sqlGetPlan = "select FNumber from T_MM_CollabPlanVersion where FID = ? ";
                    pstmt = conn.prepareStatement(sqlGetPlan);
                    pstmt.setString(1, planVerID);
                    rs = pstmt.executeQuery();
                    if (!rs.next()) throw new BOSException("planver id is not exits.");
                    planVerNum = rs.getString("FNumber");
                    List list = MRPDynamicTableManager.createPhysicalTableAndInsert(ctx, conn, storageOrgUnitID, planVerID, planVerNum, isFormal);
                }
            } else if (tableVersion < 120) {
                MRPTableUpgrader.upgrade(ctx, storageOrgUnitID, planVerID, arrayList, tableVersion, isFormal);
            }
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        return var9_13;
    }

    protected static List getTableNameForRunStrategy(MRPCalcParam runParam) throws EASBizException, BOSException {
        List runningTableList = MRPDynamicTableManager.getTableName(runParam.getCtx(), runParam.getStorageOrgUnitID(), runParam.getPlanVersionID(), runParam.isTransform());
        boolean isSelectResultTable = MRPStrategySelectGenerator.tableStrategySelect(runParam, ((MRPRunningTablesInfo)runningTableList.get(0)).getMaterialRange());
        if (isSelectResultTable) {
            runParam.setNeedUpdateResultTable(false);
            MRPDynamicTableManager.clearResultTable(runParam.getCtx(), runningTableList);
        } else {
            Map tableNameMap = MRPDynamicTableManager.createPhysicalTable(runParam.getCtx(), null);
            runningTableList.clear();
            MRPRunningTablesInfo info = new MRPRunningTablesInfo();
            info.setTableName((String)tableNameMap.get(MATERIALTABLE));
            runningTableList.add(info);
            info = new MRPRunningTablesInfo();
            info.setTableName((String)tableNameMap.get(DETAILTABLE));
            runningTableList.add(info);
            runParam.setNeedUpdateResultTable(true);
        }
        return runningTableList;
    }

    private static void clearResultTable(Context ctx, List runningTableList) throws SQLDataException {
        Connection conn = null;
        Statement statement = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            statement = conn.createStatement();
            String materialTableName = ((MRPRunningTablesInfo)runningTableList.get(0)).getTableName();
            String detailTableName = ((MRPRunningTablesInfo)runningTableList.get(1)).getTableName();
            String sql = "truncate table " + materialTableName;
            statement.addBatch(sql);
            sql = "truncate table " + detailTableName;
            statement.addBatch(sql);
            statement.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(statement, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)statement, (Connection)conn);
    }

    public static Map getStorageOrgTables(Context ctx, String storageOrgUnitID) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("select t.FTableName,t.FTableType,t.FVersion,t.fplanverNum ").append(" from T_MM_RunningTables t").append(" left join T_MM_PlanVersionSet cp on cp.fid =t. fplanverid").append(" where t.fstorageOrgUnitId = ? and cp.fid is not null");
        HashMap planMap = new HashMap();
        Map<String, String> tableMap = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, storageOrgUnitID);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                String planVerNum = rs.getString("fplanverNum");
                if (planMap.containsKey(planVerNum)) {
                    tableMap = (Map)planMap.get(planVerNum);
                } else {
                    tableMap = new HashMap();
                    planMap.put(planVerNum, tableMap);
                }
                String tableType = rs.getString("FTableType");
                tableMap.put(tableType, rs.getString("FTableName"));
            }
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        return planMap;
    }

    public static Map getStorageOrgCTables(Context ctx, String storageOrgUnitID) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("select t.FTableName,t.FTableType,t.FVersion,t.fplanverNum ").append(" from T_MM_RunningTables t").append(" left join T_MM_CollabPlanVersion cp on cp.fid =t. fplanverid").append(" where t.fstorageOrgUnitId = ? and cp.fid is not null");
        HashMap planMap = new HashMap();
        Map<String, String> tableMap = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, storageOrgUnitID);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                String planVerNum = rs.getString("fplanverNum");
                if (planMap.containsKey(planVerNum)) {
                    tableMap = (Map)planMap.get(planVerNum);
                } else {
                    tableMap = new HashMap();
                    planMap.put(planVerNum, tableMap);
                }
                String tableType = rs.getString("FTableType");
                tableMap.put(tableType, rs.getString("FTableName"));
            }
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        return planMap;
    }

    private static List createPhysicalTableAndInsert(Context ctx, Connection conn, String storageOrgUnitID, String planVerID, String planVerNum, boolean isFormal) throws BOSException {
        ArrayList<MRPRunningTablesInfo> runningTableList;
        PreparedStatement pstmtInsert = null;
        try {
            Map tableMap = MRPDynamicTableManager.createPhysicalTable(ctx, conn);
            pstmtInsert = conn.prepareStatement(SQL_INSERT_MRP_TABLE);
            BOSObjectType bosType = new MRPRunLogInfo().getBOSType();
            pstmtInsert.setString(1, BOSUuid.create((BOSObjectType)bosType).toString());
            pstmtInsert.setString(2, storageOrgUnitID);
            pstmtInsert.setString(3, planVerID);
            pstmtInsert.setString(4, planVerNum);
            pstmtInsert.setString(5, (String)tableMap.get(MATERIALTABLE));
            pstmtInsert.setString(6, MATERIALTABLE);
            pstmtInsert.setInt(7, 120);
            pstmtInsert.setBoolean(8, isFormal);
            pstmtInsert.setString(9, "0&0");
            pstmtInsert.addBatch();
            pstmtInsert.setString(1, BOSUuid.create((BOSObjectType)bosType).toString());
            pstmtInsert.setString(2, storageOrgUnitID);
            pstmtInsert.setString(3, planVerID);
            pstmtInsert.setString(4, planVerNum);
            pstmtInsert.setString(5, (String)tableMap.get(DETAILTABLE));
            pstmtInsert.setString(6, DETAILTABLE);
            pstmtInsert.setInt(7, 120);
            pstmtInsert.setBoolean(8, isFormal);
            pstmtInsert.addBatch();
            pstmtInsert.executeBatch();
            runningTableList = new ArrayList<MRPRunningTablesInfo>();
            MRPRunningTablesInfo info = new MRPRunningTablesInfo();
            info.setTableType(MATERIALTABLE);
            info.setTableName((String)tableMap.get(MATERIALTABLE));
            info.setStorageOrgUnitID(storageOrgUnitID);
            info.setPlanVerID(planVerID);
            info.setPlanVerNum(planVerNum);
            info.setVersion(120);
            info.setFormal(isFormal);
            info.setMaterialRange("0&0");
            runningTableList.add(info);
            info = new MRPRunningTablesInfo();
            info.setTableType(DETAILTABLE);
            info.setTableName((String)tableMap.get(DETAILTABLE));
            info.setStorageOrgUnitID(storageOrgUnitID);
            info.setPlanVerID(planVerID);
            info.setPlanVerNum(planVerNum);
            info.setVersion(120);
            info.setFormal(isFormal);
            runningTableList.add(info);
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmtInsert);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmtInsert);
        return runningTableList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map createPhysicalTable(Context ctx, Connection conn) throws BOSException {
        HashMap<String, Object> tableMap = new HashMap<String, Object>();
        Statement pstmt = null;
        boolean connRecover = false;
        try {
            if (conn == null) {
                conn = EJBFactory.getConnection((Context)ctx);
                connRecover = true;
            }
            Object[] tableNames = MRPDynamicTableManager.GetRandomTableName(ctx, TABLE_PREFIX_MATERAIL);
            String sql = MessageFormat.format(SQL_CREATE_MATERIALTABLE, tableNames);
            pstmt = conn.createStatement();
            pstmt.execute(sql);
            tableMap.put(MATERIALTABLE, tableNames[0]);
            String inxName = MRPDynamicTableManager.getValidIndexName(ctx);
            sql = MessageFormat.format(SQL_CREATE_MATERIALTABLE_IX_1, inxName, tableNames[0]);
            pstmt.execute(sql);
            inxName = MRPDynamicTableManager.getValidIndexName(ctx);
            sql = MessageFormat.format(SQL_CREATE_MATERIALTABLE_IX_2, inxName, tableNames[0]);
            pstmt.execute(sql);
            tableNames = MRPDynamicTableManager.GetRandomTableName(ctx, TABLE_PREFIX_DETAIL);
            sql = MessageFormat.format(SQL_CREATE_DETAILTABLE, tableNames);
            String dbType = ctx.get((Object)"dbType").toString();
            int idbType = DbType.getValue((String)dbType);
            if (idbType == 2 || idbType == 2 || idbType == 2) {
                String d_sql = null;
                try {
                    d_sql = TransUtil.Translate((String)sql, (int)idbType);
                }
                catch (SqlTranslateException e) {
                    throw new BOSException((Throwable)e);
                }
                sql = "/*dialect*/ ".intern() + d_sql + " nologging ";
            }
            pstmt.execute(sql);
            tableMap.put(DETAILTABLE, tableNames[0]);
            inxName = MRPDynamicTableManager.getValidIndexName(ctx);
            sql = MessageFormat.format(SQL_CREATE_DETAILTABLE_IX_PlanID, inxName, tableNames[0]);
            pstmt.execute(sql);
            inxName = MRPDynamicTableManager.getValidIndexName(ctx);
            sql = MessageFormat.format(SQL_CREATE_DETAILTABLE_IX_PERIOD, inxName, tableNames[0]);
            pstmt.execute(sql);
        }
        catch (SQLException sqlExp) {
            try {
                Statement stmt = null;
                try {
                    stmt = conn.createStatement();
                    Iterator iter = tableMap.keySet().iterator();
                    while (iter.hasNext()) {
                        String tableName = (String)tableMap.get(iter.next());
                        stmt.execute("drop table " + tableName);
                    }
                }
                catch (SQLException e) {
                    throw new SQLDataException(e);
                }
                finally {
                    SQLUtils.cleanup((Statement)stmt);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt);
                if (connRecover) {
                    SQLUtils.cleanup((Connection)conn);
                }
                throw throwable;
            }
            SQLUtils.cleanup((Statement)pstmt);
            if (connRecover) {
                SQLUtils.cleanup((Connection)conn);
            }
        }
        SQLUtils.cleanup((Statement)pstmt);
        if (connRecover) {
            SQLUtils.cleanup((Connection)conn);
        }
        return tableMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String createPhysicalTable4Inv(Context ctx) throws BOSException {
        Object[] tableNames;
        block11: {
            Object object;
            Statement pstmt = null;
            Connection conn = null;
            tableNames = null;
            try {
                conn = EJBFactory.getConnection((Context)ctx);
                StringBuffer createTable = new StringBuffer();
                tableNames = MRPDynamicTableManager.GetRandomTableName(ctx, INV);
                createTable.append("create table {0} (").append("FID VARCHAR(44) NOT NULL,").append("FMaterialID varchar(44) not null,").append("FBaseQty NUMERIC(21,8) not null default 0,").append(" FProjectID varchar(44),").append(" FTrackID varchar(44),").append(" FProjectNumber nvarchar(80),").append(" FTrackNumber nvarchar(80),").append(" FLowsetCode INTEGER not null default 999").append(" )");
                String sql = MessageFormat.format(createTable.toString(), tableNames);
                pstmt = conn.createStatement();
                pstmt.execute(sql);
                String inxName = MRPDynamicTableManager.getValidIndexName(ctx);
                sql = "CREATE INDEX {0} ON {1} (FMaterialID)";
                sql = MessageFormat.format(sql, inxName, tableNames[0]);
                pstmt.execute(sql);
                object = tableNames[0];
                SQLUtils.cleanup((Statement)pstmt);
            }
            catch (SQLException sqlExp) {
                Statement stmt = null;
                try {
                    stmt = conn.createStatement();
                    if (tableNames != null) {
                        stmt.execute("drop table " + tableNames[0]);
                    }
                    break block11;
                }
                catch (SQLException e) {
                    throw new SQLDataException(e);
                }
                finally {
                    SQLUtils.cleanup((Statement)stmt);
                }
            }
            finally {
                SQLUtils.cleanup(pstmt);
                SQLUtils.cleanup((Connection)conn);
            }
            SQLUtils.cleanup((Connection)conn);
            return object;
        }
        return tableNames[0];
    }

    public static void dropPhysicalTable(Context ctx, String[] tableName) throws BOSException {
        if (tableName == null || tableName.length == 0) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        for (int i = 0; i < tableName.length; ++i) {
            if (MMUtils.isEmptyString((String)tableName[i])) continue;
            sql.setLength(0);
            sql.append("IF EXISTS (SELECT 1 FROM KSQL_USERTABLES WHERE KSQL_TABNAME = '").append(tableName[i]).append("')").append("drop table ").append(tableName[i]);
            SQLUtils.execute((Context)ctx, (String)sql.toString());
        }
    }

    public static boolean isEmptyTable(Context ctx, String tableName) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select top 1 1 from ").append(tableName);
        IRowSet rs = SQLUtils.executeQuery((Context)ctx, (String)sql.toString());
        try {
            return !rs.next();
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static String[] GetRandomTableName(Context ctx, String perfix) throws SQLException, BOSException {
        String tablePkConstrait;
        String tableName;
        do {
            tableName = new UUTN(true).toString();
            if ((tableName = tableName.replaceFirst("VT", perfix)).length() > 28) {
                tableName = tableName.substring(0, 28);
            }
            tablePkConstrait = new UUTN("ZC").toString();
            if ((tablePkConstrait = tablePkConstrait.replaceFirst("ZC", CONSTRAINT_PREFIX)).length() <= 10) continue;
            tablePkConstrait = tablePkConstrait.substring(0, 10);
        } while (MRPDynamicTableManager.isTableExists(ctx, tableName) || MRPDynamicTableManager.isConstrainsExists(ctx, tablePkConstrait));
        return new String[]{tableName, tablePkConstrait};
    }

    public static String getValidIndexName(Context ctx) throws SQLException {
        String indexName;
        do {
            indexName = new UUTN("ZC").toString();
            if ((indexName = indexName.replaceFirst("ZC", INDEX_PREFIX)).length() <= 10) continue;
            indexName = indexName.substring(0, 10);
        } while (MRPDynamicTableManager.isIndexExists(ctx, indexName));
        return indexName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isTableExists(Context ctx, String tableName) throws SQLException {
        boolean bl;
        String sql = "SELECT 1 WHERE EXISTS(SELECT 1 FROM KSQL_USERTABLES WHERE KSQL_TABNAME = ?)";
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, tableName);
            rs = pstmt.executeQuery();
            bl = rs.next();
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs, pstmt, (Connection)conn);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        return bl;
    }

    private static boolean isConstrainsExists(Context ctx, String consName) throws SQLException, BOSException {
        String sql = "SELECT 1 WHERE EXISTS(SELECT 1 FROM KSQL_CONSTRAINTS WHERE  KSQL_CONS_NAME = '" + consName + "' )";
        IRowSet rs = SQLUtils.executeQuery((Context)ctx, (String)sql);
        return rs.next();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isIndexExists(Context ctx, String indexName) throws SQLException {
        boolean bl;
        String sql = "SELECT 1 WHERE EXISTS(SELECT 1 FROM KSQL_INDEXES WHERE KSQL_INDNAME = ? )";
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, indexName);
            rs = pstmt.executeQuery();
            bl = rs.next();
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs, pstmt, (Connection)conn);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        return bl;
    }

    public static Map getMRPRunningTables(Context ctx, String storageOrgUnitId, String planVersionId, boolean isFormal) throws EASBizException, BOSException {
        HashMap<String, String> tableMap = new HashMap<String, String>();
        List list = MRPDynamicTableManager.getTableName(ctx, storageOrgUnitId, planVersionId, isFormal);
        tableMap.put(MATERIALTABLE, ((MRPRunningTablesInfo)list.get(0)).getTableName());
        tableMap.put(DETAILTABLE, ((MRPRunningTablesInfo)list.get(1)).getTableName());
        return tableMap;
    }

    public static String getMaterialTableFields(String prefix) {
        prefix = prefix == null ? "" : prefix + ".";
        StringBuffer allFields = new StringBuffer();
        allFields.append(prefix).append("FID").append(",").append(prefix).append("FPlanVersionID").append(",").append(prefix).append("FRunLogID").append(",").append(prefix).append("FMaterialID").append(",").append(prefix).append("FMaterialNumber").append(",").append(prefix).append("FBaseUnitID").append(",").append(prefix).append("FBaseQtyPrc").append(",").append(prefix).append("FProdUnitID").append(",").append(prefix).append("FProdQtyPrc").append(",").append(prefix).append("FConvertRate").append(",").append(prefix).append("FPlanner").append(",").append(prefix).append("FLowsetCode").append(",").append(prefix).append("FOnHand").append(",").append(prefix).append("FSafeStock").append(",").append(prefix).append("FQtyMax").append(",").append(prefix).append("FIsMergeSign").append(",").append(prefix).append("FYield").append(",").append(prefix).append("FPlanStrategy").append(",").append(prefix).append("FBatchPolicy").append(",").append(prefix).append("FFixationBatchQty").append(",").append(prefix).append("FMinBatchQty").append(",").append(prefix).append("FRoundUpMultipleQty").append(",").append(prefix).append("FBatchIncQty").append(",").append(prefix).append("FQtyMinPackage").append(",").append(prefix).append("FMaterialAttr").append(",").append(prefix).append("FPlanningMode").append(",").append(prefix).append("FRecevingLeadTime").append(",").append(prefix).append("FProduceLeadTime").append(",").append(prefix).append("FForwardProcessTime").append(",").append(prefix).append("FBackwardProcessTime").append(",").append(prefix).append("FBOMID").append(",").append(prefix).append("FIsProcessed").append(",").append(prefix).append("FSupplyType").append(",").append(prefix).append("FSupplyOrgUnitID").append(",").append(prefix).append("FSubstitute").append(",").append(prefix).append("FSubstituteGroup").append(",").append(prefix).append("FCalcSeq").append(",").append(prefix).append("FfixStock").append(",").append(prefix).append("FManufactureDepartment").append(",").append(prefix).append("FisNewOrder").append(",").append(prefix).append("FhasExceptions").append(",").append(prefix).append("FhasStockExp").append(",").append(prefix).append("FCollabMaterialEntryID").append(",").append(prefix).append("FRequirementUniteRuleID").append(",").append(prefix).append("FProductTranTypeID").append(",").append(prefix).append("FLeadTimeType").append(",").append(prefix).append("FChangeLeadTime").append(",").append(prefix).append("FChangeBatch").append(",").append(prefix).append("FisCanNotThrow").append(",").append(prefix).append("FisolateRules").append(",").append(prefix).append("FInvDetailId").append(",").append(prefix).append("FPartitionQty").append(",").append(prefix).append("FMaxBatchQty").append(",").append(prefix).append("FBatchCycle").append(",").append(prefix).append("FIsSurplusDivert").append(",").append(prefix).append("FisComReqConsume").append(",").append(prefix).append("FPlanOrgUnit");
        return allFields.toString();
    }

    public static String getDetailTableFields(String prefix) {
        prefix = prefix == null ? "" : prefix + ".";
        StringBuffer allFields = new StringBuffer();
        allFields.append(prefix).append("FID").append(",").append(prefix).append("FPlanVersionID").append(",").append(prefix).append("FRunLogID").append(",").append(prefix).append("FPlanningMode").append(",").append(prefix).append("FMaterialID").append(",").append(prefix).append("FMRPClassify").append(",").append(prefix).append("FMRPItem").append(",").append(prefix).append("FParentMateiralID").append(",").append(prefix).append("FSrcBillType").append(",").append(prefix).append("FSrcBillID").append(",").append(prefix).append("FSrcBillNumber").append(",").append(prefix).append("FSrcBillEntryID").append(",").append(prefix).append("FSrcBillEntrySeq").append(",").append(prefix).append("FBillID").append(",").append(prefix).append("FBillEntryID").append(",").append(prefix).append("FBillDate").append(",").append(prefix).append("FCalendarID").append(",").append(prefix).append("FWorkDaySeqID").append(",").append(prefix).append("FWeekSeqID").append(",").append(prefix).append("FMonthSeqID").append(",").append(prefix).append("FBillType").append(",").append(prefix).append("FBillNumber").append(",").append(prefix).append("FBillSeqNo").append(",").append(prefix).append("FBillRowSeq").append(",").append(prefix).append("FDisplaySeq").append(",").append(prefix).append("FAvaliable").append(",").append(prefix).append("FSR").append(",").append(prefix).append("FSSR").append(",").append(prefix).append("FAllocation").append(",").append(prefix).append("FIndependent").append(",").append(prefix).append("FDependent").append(",").append(prefix).append("FNetReq").append(",").append(prefix).append("FPlannedQty").append(",").append(prefix).append("FPlanBeginDate").append(",").append(prefix).append("FBeginDateWorkdayID").append(",").append(prefix).append("FPlanEndDate").append(",").append(prefix).append("FEndDateWorkdayID").append(",").append(prefix).append("FPAB").append(",").append(prefix).append("FException1").append(",").append(prefix).append("FException2").append(",").append(prefix).append("FException3").append(",").append(prefix).append("FException4").append(",").append(prefix).append("FException5").append(",").append(prefix).append("FException6").append(",").append(prefix).append("FException7").append(",").append(prefix).append("FIsDayEnd").append(",").append(prefix).append("FIsWeekEnd").append(",").append(prefix).append("FIsMonthEnd").append(",").append(prefix).append("FIsDelay").append(",").append(prefix).append("FIsTotalLine").append(",").append(prefix).append("FIsCalc").append(",").append(prefix).append("FSupplyOrgUnitID").append(",").append(prefix).append("FIsNewOrder").append(",").append(prefix).append("FOutputType").append(",").append(prefix).append("FPROJECTID").append(",").append(prefix).append("FTRACKID").append(",").append(prefix).append("FBomID").append(",").append(prefix).append("FYield").append(",").append(prefix).append("FAjustFlag").append(",").append(prefix).append("FAjustQty").append(",").append(prefix).append("FIsAjust").append(",").append(prefix).append("FPriority").append(",").append(prefix).append("FSID").append(",").append(prefix).append("FProjectNumber").append(",").append(prefix).append("FTrackNumber").append(",").append(prefix).append("FBProjectID").append(",").append(prefix).append("FBTrackID").append(",").append(prefix).append("FBProjectNumber").append(",").append(prefix).append("FBTrackNumber").append(",").append(prefix).append("FParentBomID").append(",").append(prefix).append("FIsDefaultTNO").append(",").append(prefix).append("FPeriod").append(",").append(prefix).append("FRePlanDATE").append(",").append(prefix).append("FBizTypeID").append(",").append(prefix).append("FBaseStatus").append(",").append(prefix).append("FBomType").append(",").append(prefix).append("FSPeriod").append(",").append(prefix).append("FSupplyType").append(",").append(prefix).append("FIsDirectTransport").append(",").append(prefix).append("FRequireMentID").append(",").append(prefix).append("FUnitQty").append(",").append(prefix).append("FReplaceVersionID").append(",").append(prefix).append("FReplaceVersionEntryID").append(",").append(prefix).append("FSaleOrderID").append(",").append(prefix).append("FSaleOrderEntryID").append(",").append(prefix).append("FSaleOrderNumber").append(",").append(prefix).append("FSaleOrderEntrySeq").append(",").append(prefix).append("FisCanNotThrow").append(",").append(prefix).append("FMrpSeq").append(",").append(prefix).append("FHierarchyCode").append(",").append(prefix).append("Fexception8").append(",").append(prefix).append("FHasSplit").append(",").append(prefix).append("FDesc64");
        return allFields.toString();
    }
}

