/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.app.mrp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.common.app.SQLUtils;
import com.kingdee.eas.mm.common.util.MMUtils;
import com.kingdee.eas.mm.common.util.SQLUtil;
import com.kingdee.eas.mm.planning.MRPClassifyEnum;
import com.kingdee.eas.mm.planning.MRPElementEnum;
import com.kingdee.eas.mm.planning.MRPException;
import com.kingdee.eas.mm.planning.app.mrp.MRPCalcParam;
import com.kingdee.eas.mm.planning.app.mrp.MRPConstant;
import com.kingdee.eas.mm.planning.app.mrp.MRPDetailInfo;
import com.kingdee.eas.mm.planning.app.mrp.MRPDynamicTableManager;
import com.kingdee.eas.mm.planning.app.mrp.MRPFetchMaterialDataUtil;
import com.kingdee.eas.mm.planning.app.mrp.MRPMaterialStatisticsInfo;
import com.kingdee.eas.mm.planning.app.mrp.MRPStep;
import com.kingdee.eas.mm.planning.app.mrp.MRPUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class MRPFetchDetailDataUtil {
    protected static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.planning.app.mrp.MRPFetchDetailDataUtil");
    private HashMap materialDetials;
    private int lastSeq;
    private int hitCount;
    private String advance_tmp;
    private String qtyAjust_tmp;
    private List materialIds;
    private MRPFetchMaterialDataUtil materialDataUtil;
    private int detailCount;

    public MRPFetchDetailDataUtil() {
        if (MRPStep.isMoreInfo.booleanValue()) {
            logger.setLevel(Level.INFO);
        } else {
            logger.setLevel(Level.ERROR);
        }
        this.materialDetials = new HashMap();
        this.lastSeq = -1;
        this.hitCount = 0;
        this.advance_tmp = null;
        this.qtyAjust_tmp = null;
        this.materialIds = null;
        this.materialDataUtil = null;
        this.detailCount = 0;
    }

    public void setMaterialIds(List materialIds, MRPFetchMaterialDataUtil materialDataUtil) {
        this.materialIds = materialIds;
        this.materialDataUtil = materialDataUtil;
    }

    public void calcAdvanceDetails(MRPCalcParam runParam, List idList) throws EASBizException, BOSException {
        if (this.canNotDoAdvance(runParam)) {
            return;
        }
        this.createTempTable(runParam);
        StringBuffer sql = new StringBuffer();
        String idStr = SQLUtil.arrayToString((Object[])idList.toArray());
        if (runParam.getAdvanceType() == 0) {
            sql.append("Insert into ").append(this.advance_tmp).append("(KSQL_SEQ,FID,FMaterialID,FProjectNumber,FTrackNumber,FPeriod,FSurplusQty)").append(" select d.FID,d.FMaterialID,d.FProjectNumber,d.FTrackNumber,d.FPeriod,d.Fsr").append(" from ").append(runParam.getMrpCalcDetailTableName()).append(" d").append(" where d.FMaterialID in (").append(idStr).append(" ) and ").append(" d.FPeriod in (").append("   select s.FPeriod FROM ").append(runParam.getStatisticsTable()).append(" s").append(" \twhere s.fsqty+s.frqty>0 and s.FMaterialID in (").append(idStr).append(") )").append(" and d.FMRPClassify = 20 ").append(" and exists( select 1 from ").append(runParam.getMrpCalcDetailTableName()).append(" t").append("             inner join ").append(runParam.getStatisticsTable()).append(" s1 on t.FMaterialID = s1.FMaterialID").append(" and t.fperiod = s1.fperiod and t.FProjectNumber = s1.FProjectNumber and t.FTrackNumber = s1.FTrackNumber ").append("    where t.FMaterialID = d.FMaterialID and t.fperiod = d.fperiod and t.FProjectNumber = d.FProjectNumber").append("    and t.FTrackNumber = d.FTrackNumber and t.FMRPClassify = d.FMRPClassify ").append("    and t.FMRPSEQ <= d.FMRPSEQ ").append("    group by t.FMaterialID ,s1.FRQty having sum(t.FSr)+s1.FRQty>0 )").append(" order by d.fperiod ,d.FMaterialID,d.FProjectNumber,d.FTrackNumber, d.FMRPSEQ ");
            MRPUtil.executeUpdate(runParam.getCtx(), sql.toString());
            sql.setLength(0);
            sql.append("Insert into ").append(this.qtyAjust_tmp).append("(FSeq ,FQty)").append(" select A.FSeq, A.FSurplusQty-(s.FSQty+s.FRQty) from ( ").append("  ( select sum(FSurplusQty) FSurplusQty ,min(KSQL_SEQ) FSeq,t1.FPeriod, t1.FMaterialID,").append("  t1.FProjectNumber,t1.FTrackNumber  from ").append(this.advance_tmp).append(" t1 ").append("       group by t1.FPeriod ,t1.FMaterialID , t1.FProjectNumber ,t1.FTrackNumber ) A").append("  inner join ").append(runParam.getStatisticsTable()).append(" s").append("    on s.FPeriod = A.FPeriod and s.FMaterialID = A.FMaterialID ").append("    and  s.FProjectNumber = A.FProjectNumber and s.FTrackNumber = A.FTrackNumber  )").append("  where  A.FSurplusQty-(s.FSQty+s.FRQty)>0 ");
            MRPUtil.executeUpdate(runParam.getCtx(), sql.toString());
            sql.setLength(0);
            sql.append(" update ").append(this.advance_tmp).append(" t set (FSurplusQty) = ").append(" ( select  t.FSurplusQty-Fqty from ").append(this.qtyAjust_tmp).append(" a").append(" where a.FSeq = t.KSQL_SEQ  )");
            MRPUtil.executeUpdate(runParam.getCtx(), sql.toString());
        } else {
            sql.append("Insert into ").append(this.advance_tmp).append("( ").append(" KSQL_SEQ,FID,FMaterialID,FProjectNumber,FTrackNumber,FPeriod,FSurplusQty ) ").append(" select d.FID,d.FMaterialID,d.FProjectNumber,d.FTrackNumber,d.FPeriod,d.Fsr").append(" from ").append(runParam.getMrpCalcDetailTableName()).append(" d").append(" where d.FMaterialID in (").append(idStr).append(" ) and ").append(" d.FPeriod in (").append("        select s.FPeriod FROM ").append(runParam.getStatisticsTable()).append(" s").append("               where s.fsqty>0 and s.FMaterialID in ( ").append(idStr).append(" ) )").append(" and d.FMRPClassify = 20 ").append(" order by d.fperiod ,d.FMaterialID,d.FProjectNumber,d.FTrackNumber, d.FPriority ,d.FBillNumber ,d.FBillRowSeq");
            MRPUtil.executeUpdate(runParam.getCtx(), sql.toString());
        }
    }

    public List getAdvanceDetailsData(MRPCalcParam runParam, String materialID, String projectNumber, String trackNumber, int period) throws BOSException, MRPException {
        ArrayList<MRPDetailInfo> adetail = new ArrayList<MRPDetailInfo>();
        if (this.canNotDoAdvance(runParam)) {
            return adetail;
        }
        int periodMore = runParam.getPlanDate().getPeriod() + runParam.getPlanVersion().getAdjustPeriod();
        if (period > periodMore) {
            return adetail;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select d.*, s.FRQty FRQty, s.KSQL_SEQ from ").append(runParam.getMrpCalcDetailTableName()).append(" d \n").append("inner join ").append(runParam.getStatisticsTable()).append(" s \n").append(" on s.fMaterialId = d.fMaterialId and s.FPeriod = d.FPeriod ").append(" and s.FProjectNumber = d.FProjectNumber and s.FTrackNumber = d.FTrackNumber \n").append("where s.FMaterialID = ? and s.FPeriod> ? and  s.FPeriod<= ? ").append(" and s.FProjectNumber = ? and s.FTrackNumber = ? ").append(" and d.FIsMatch = 0 ");
        if (runParam.getAdvanceType() == 0) {
            sql.append(" and s.FSurplusQty > 0 ");
        }
        sql.append(" and d.FSR-d.FAjustQty > 0 and d.FIsAjust = 1 and d.FMRPClassify = 20 ").append(" and (d.fsid is null or d.fid = d.fsid) \n").append("order by d.FMrpSeq ");
        IRowSet rs = SQLUtils.executeQuery((Context)runParam.getCtx(), (String)sql.toString(), (Object[])new Object[]{materialID, new Integer(period), new Integer(periodMore), projectNumber, trackNumber});
        logger.debug((Object)("material: " + materialID + " period: " + period + " advance bills: " + rs.size()));
        try {
            MRPDetailInfo detailInfo = null;
            BigDecimal periodReqQty = MRPConstant.ZERO;
            BigDecimal surplusQty = MRPConstant.ZERO;
            BigDecimal amountQty = MRPConstant.ZERO;
            int lastPeriod = -1;
            int curPeriod = -1;
            while (rs.next()) {
                detailInfo = this.getDetailInMemory(rs.getString("FMaterialID"), rs.getInt("FPeriod"), rs.getString("FProjectNumber"), rs.getString("FTrackNumber"), rs.getString("FID"));
                if (detailInfo == null) {
                    detailInfo = MRPDetailInfo.readRow(rs);
                }
                surplusQty = detailInfo.getScheduledReceiptQty().subtract(detailInfo.getAjustQty());
                if (runParam.getAdvanceType() == 0) {
                    curPeriod = detailInfo.getPeriod();
                    if (curPeriod != lastPeriod) {
                        amountQty = MRPConstant.ZERO;
                        periodReqQty = rs.getBigDecimal("FRQty").abs();
                    }
                    if ((amountQty = amountQty.add(surplusQty)).compareTo(periodReqQty) > 0) {
                        if (amountQty.subtract(periodReqQty).compareTo(surplusQty) < 0) {
                            surplusQty = amountQty.subtract(periodReqQty);
                        }
                        detailInfo.setSurplusQty(surplusQty);
                        adetail.add(detailInfo);
                        logger.debug((Object)("material: " + materialID + " billNumber: " + detailInfo.getBillNumber() + " surplusQty: " + detailInfo.getSurplusQty() + " srQty: " + detailInfo.getScheduledReceiptQty()));
                    }
                    lastPeriod = curPeriod;
                    continue;
                }
                detailInfo.setSurplusQty(surplusQty);
                adetail.add(detailInfo);
                logger.debug((Object)("material: " + materialID + " billNumber: " + detailInfo.getBillNumber() + " surplusQty: " + detailInfo.getSurplusQty() + " srQty: " + detailInfo.getScheduledReceiptQty()));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return adetail;
    }

    public Object[] getAdvanceDetailsDataForSaleMatch(MRPCalcParam runParam, String materialID, String projectNumber, String trackNumber, int period) throws BOSException, MRPException {
        if (this.canNotDoAdvance(runParam)) {
            return null;
        }
        int periodMore = runParam.getPlanDate().getPeriod() + runParam.getPlanVersion().getAdjustPeriod();
        if (period > periodMore) {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select d.*, s.FRQty FRQty, s.KSQL_SEQ from ").append(runParam.getMrpCalcDetailTableName()).append(" d \n").append("inner join ").append(runParam.getStatisticsTable()).append(" s \n").append(" on s.fMaterialId = d.fMaterialId and s.FPeriod = d.FPeriod ").append(" and s.FProjectNumber = d.FProjectNumber and s.FTrackNumber = d.FTrackNumber \n").append("where s.FMaterialID = ? and s.FPeriod> ? and  s.FPeriod<= ? ").append(" and s.FProjectNumber = ? and s.FTrackNumber = ? ");
        sql.append(" and ((d.FSR-d.FAjustQty > 0 and d.FIsAjust = 1 and d.FMRPClassify = 20) ");
        sql.append(" or ((d.FIndependent != 0 or d.FDependent !=0) and d.FMRPClassify = 30)) ").append(" and d.FSaleOrderID is not null and FSaleOrderEntryID is not null  \n").append(" and (d.fsid is null or d.fid = d.fsid) \n").append("order by d.FMrpSeq ");
        IRowSet rs = SQLUtils.executeQuery((Context)runParam.getCtx(), (String)sql.toString(), (Object[])new Object[]{materialID, new Integer(period), new Integer(periodMore), projectNumber, trackNumber});
        logger.debug((Object)("material: " + materialID + " period: " + period + " advance bills: " + rs.size()));
        int mrpSeq = 0;
        ArrayList<MRPDetailInfo> rDetails = new ArrayList<MRPDetailInfo>();
        ArrayList<MRPDetailInfo> sDetails = new ArrayList<MRPDetailInfo>();
        try {
            MRPDetailInfo detailInfo = null;
            BigDecimal surplusQty = MRPConstant.ZERO;
            ArrayList<MRPDetailInfo> rDetailsForPeriod = new ArrayList<MRPDetailInfo>();
            ArrayList<MRPDetailInfo> sDetailsForPeriod = new ArrayList<MRPDetailInfo>();
            while (rs.next()) {
                detailInfo = this.getDetailInMemory(rs.getString("FMaterialID"), rs.getInt("FPeriod"), rs.getString("FProjectNumber"), rs.getString("FTrackNumber"), rs.getString("FID"));
                if (detailInfo == null) {
                    detailInfo = MRPDetailInfo.readRow(rs);
                }
                if (mrpSeq != rs.getInt("KSQL_SEQ")) {
                    mrpSeq = rs.getInt("KSQL_SEQ");
                    this.dealRSForSale(rDetailsForPeriod, sDetailsForPeriod);
                    rDetails.addAll(rDetailsForPeriod);
                    sDetails.addAll(sDetailsForPeriod);
                    rDetailsForPeriod = new ArrayList();
                    sDetailsForPeriod = new ArrayList();
                }
                if (detailInfo.getMrpItem() == MRPElementEnum.R_SID || detailInfo.getMrpItem() == MRPElementEnum.R_PlannedOrder || detailInfo.getMrpItem() == MRPElementEnum.R_ManufauctureOrder || detailInfo.getMrpItem() == MRPElementEnum.R_ProductOrder || detailInfo.getMrpItem() == MRPElementEnum.R_OUTERORDER || detailInfo.getMrpItem() == MRPElementEnum.R_OUTERPURREQORDER) {
                    rDetailsForPeriod.add(detailInfo);
                }
                if (detailInfo.getMrpItem() == MRPElementEnum.S_ProductOrder || detailInfo.getMrpItem() == MRPElementEnum.S_ManufactureOrder || detailInfo.getMrpItem() == MRPElementEnum.S_OUTERPURREQUEST || detailInfo.getMrpItem() == MRPElementEnum.S_OUTERORDER || detailInfo.getMrpItem() == MRPElementEnum.S_PurOrder || detailInfo.getMrpItem() == MRPElementEnum.S_PurRequest || detailInfo.getMrpItem() == MRPElementEnum.S_PlannedOrder) {
                    surplusQty = detailInfo.getScheduledReceiptQty().subtract(detailInfo.getAjustQty());
                    detailInfo.setSurplusQty(surplusQty);
                    sDetailsForPeriod.add(detailInfo);
                }
                logger.debug((Object)("material: " + materialID + " billNumber: " + detailInfo.getBillNumber() + " surplusQty: " + detailInfo.getSurplusQty() + " srQty: " + detailInfo.getScheduledReceiptQty()));
            }
            this.dealRSForSale(rDetailsForPeriod, sDetailsForPeriod);
            rDetails.addAll(rDetailsForPeriod);
            sDetails.addAll(sDetailsForPeriod);
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        Object[] result = new Object[]{rDetails, sDetails};
        return result;
    }

    private void dealRSForSale(List<MRPDetailInfo> rDetailsForPeriod, List<MRPDetailInfo> sDetailsForPeriod) {
        MRPDetailInfo rdetailInfo;
        int i;
        for (i = rDetailsForPeriod.size() - 1; i >= 0; --i) {
            rdetailInfo = rDetailsForPeriod.get(i);
            for (int j = 0; j < sDetailsForPeriod.size(); ++j) {
                MRPDetailInfo sdetailInfo = sDetailsForPeriod.get(j);
                if (!rdetailInfo.getSaleOrderNumber().equals(sdetailInfo.getSaleOrderNumber()) || rdetailInfo.getSaleOrderEntryNum() != sdetailInfo.getSaleOrderEntryNum()) continue;
                rdetailInfo.setMatch(true);
                sdetailInfo.setMatch(true);
            }
        }
        for (i = rDetailsForPeriod.size() - 1; i >= 0; --i) {
            rdetailInfo = rDetailsForPeriod.get(i);
            if (!rdetailInfo.isMatch()) continue;
            rDetailsForPeriod.remove(i);
        }
        for (i = sDetailsForPeriod.size() - 1; i >= 0; --i) {
            MRPDetailInfo sdetailInfo = sDetailsForPeriod.get(i);
            if (!sdetailInfo.isMatch()) continue;
            sDetailsForPeriod.remove(i);
        }
    }

    public Object[] getAdvanceDetailsData(MRPCalcParam runParam, String materialID, int period, int lastSeq, boolean isPeroid) throws BOSException, MRPException {
        ArrayList<MRPDetailInfo> adetail = new ArrayList<MRPDetailInfo>();
        if (this.canNotDoAdvance(runParam)) {
            return new Object[]{adetail, null, null};
        }
        int periodMore = runParam.getPlanDate().getPeriod() + runParam.getPlanVersion().getAdjustPeriod();
        StringBuffer sql = new StringBuffer();
        sql.append("select top 20 d.*,a.FSurplusQty,a.KSQL_SEQ from ").append(this.advance_tmp).append(" a ").append(" inner join ").append(runParam.getMrpCalcDetailTableName()).append(" d").append(" on a.fid = d.fid").append(" where a.FMaterialID = ? and a.KSQL_SEQ > ?");
        if (isPeroid) {
            sql.append(" and d.FPeriod = ? ");
        } else {
            sql.append(" and d.FPeriod > ? and  a.FPeriod <= ?");
        }
        sql.append(" and a.FSurplusQty-d.FAjustQty>0").append(" and ((d.fajustflag>0 and d.FAjustQty>0)or (d.fajustflag<=0))").append(" order by a.KSQL_SEQ");
        Object[] params = null;
        params = isPeroid ? new Object[]{materialID, new Integer(lastSeq), new Integer(period)} : new Object[]{materialID, new Integer(lastSeq), new Integer(period), new Integer(periodMore)};
        IRowSet rs = SQLUtils.executeQuery((Context)runParam.getCtx(), (String)sql.toString(), (Object[])params);
        int lastPeriod = -1;
        try {
            MRPDetailInfo detailInfo = null;
            BigDecimal surplusQty = null;
            while (rs.next()) {
                detailInfo = this.getDetailInMemory(rs.getString("FMaterialID"), rs.getInt("FPeriod"), rs.getString("FProjectNumber"), rs.getString("FTrackNumber"), rs.getString("FID"));
                if (detailInfo == null) {
                    detailInfo = MRPDetailInfo.readRow(rs);
                }
                if ((surplusQty = rs.getBigDecimal("FSurplusQty")).compareTo(detailInfo.getScheduledReceiptQty()) < 0 && MRPConstant.ZERO.compareTo(detailInfo.getAjustQty()) == 0) {
                    detailInfo.setAjustQty(detailInfo.getScheduledReceiptQty().subtract(surplusQty));
                    detailInfo.setSurplusQty(surplusQty);
                } else {
                    detailInfo.setSurplusQty(detailInfo.getSsrQty().subtract(detailInfo.getAjustQty()));
                }
                if (detailInfo.getSurplusQty().compareTo(MRPConstant.ZERO) <= 0) continue;
                adetail.add(detailInfo);
                lastPeriod = detailInfo.getPeriod();
                lastSeq = detailInfo.getSeq();
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return new Object[]{adetail, new Integer(lastPeriod), new Integer(lastSeq)};
    }

    private boolean canNotDoAdvance(MRPCalcParam runParam) {
        if (runParam.isCooperatePlan()) {
            return true;
        }
        if (!runParam.isCalNetting()) {
            return true;
        }
        return !runParam.getPlanVersion().isIsConsiderAjustPeriod();
    }

    private void createTempTable(MRPCalcParam runParam) throws BOSException, EASBizException {
        TempTablePool pool = TempTablePool.getInstance((Context)runParam.getCtx());
        try {
            StringBuffer sqlBuf = new StringBuffer();
            sqlBuf.append("create table tttttt (").append("KSQL_SEQ INT IDENTITY (1, 1) NOT NULL,").append("FID varchar(44) NOT NULL,").append("FMaterialID varchar(44) not null,").append("FTrackNumber Nvarchar(80) NOT NULL,").append("FProjectNumber Nvarchar(80) NOT NULL,").append("FPeriod INT NOT NULL ,").append("FSurplusQty  NUMERIC(21,8) DEFAULT 0 NOT NULL,").append("FAjustQty  NUMERIC(21,8) DEFAULT 0 NOT NULL,").append("FIsAjust  INT DEFAULT 0 NOT NULL) ");
            this.advance_tmp = pool.createTempTable(sqlBuf.toString());
            String index = "IX_" + this.advance_tmp.substring(0, 15);
            boolean flag = MRPDynamicTableManager.isIndexExists(runParam.getCtx(), index);
            if (!flag) {
                index = " create index " + index + " on " + this.advance_tmp + " (FMaterialID,FPeriod,FProjectNumber,FTrackNumber)";
                SQLUtils.execute((Context)runParam.getCtx(), (String)index);
            }
            sqlBuf.setLength(0);
            sqlBuf.append("create table tttttt (").append("FSeq INT  DEFAULT 0 NOT NULL ,").append("FQty NUMERIC(21,8) DEFAULT 0 NOT NULL )");
            this.qtyAjust_tmp = pool.createTempTable(sqlBuf.toString());
        }
        catch (Exception e1) {
            throw new BOSException((Throwable)e1);
        }
    }

    public void clear() {
        logger.info((Object)("detail data buffer hit count:" + String.valueOf(this.hitCount)));
        this.materialDetials.clear();
        this.lastSeq = -1;
        this.hitCount = 0;
        this.detailCount = 0;
    }

    private void getNextData(MRPCalcParam runParam, List seqList) throws BOSException, MRPException {
        int i;
        StringBuffer sql = new StringBuffer();
        sql.append("select d.* ,s.KSQL_seq from ").append(runParam.getMrpCalcDetailTableName()).append(" d").append(" inner join ").append(runParam.getStatisticsTable()).append(" s on ").append("d.FMaterialID = s.FMaterialID  and s.FProjectNumber = d.FProjectNumber ").append("and s.FTrackNumber = d.FTrackNumber and s.FPeriod = d.FPeriod ").append("where ( ");
        for (i = 0; i < this.materialIds.size(); ++i) {
            sql.append(" s.FMaterialID = ?");
            if (i == this.materialIds.size() - 1) continue;
            sql.append(" OR ");
        }
        sql.append(") and (");
        for (i = 0; i < this.materialIds.size(); ++i) {
            sql.append(" d.FMaterialID = ?");
            if (i == this.materialIds.size() - 1) continue;
            sql.append(" OR ");
        }
        sql.append(") and (");
        for (i = 0; i < seqList.size(); ++i) {
            sql.append(" s.KSQL_seq = ?");
            if (i == seqList.size() - 1) continue;
            sql.append(" OR ");
        }
        sql.append(") and d.FSupplyType <10930").append(" and d.FMRPItem<>").append(110).append(" order by s.KSQL_seq,d.FMRPSeq  ");
        ArrayList idList = new ArrayList();
        idList.addAll(this.materialIds);
        idList.addAll(this.materialIds);
        idList.addAll(seqList);
        IRowSet rs = SQLUtils.executeQuery((Context)runParam.getCtx(), (String)sql.toString(), (Object[])idList.toArray());
        if (rs.size() > 0) {
            this.detailCount += rs.size();
            logger.debug((Object)("get detail data count:" + rs.size()));
            this.toMap(rs);
        }
    }

    private MRPDetailInfo toMap(IRowSet rs) throws BOSException {
        String key = null;
        List<MRPDetailInfo> detList = null;
        MRPDetailInfo detailInfo = null;
        try {
            while (rs.next()) {
                key = this.getKey(rs.getInt("FPeriod"), rs.getString("FMaterialID"), rs.getString("FProjectNumber"), rs.getString("FTrackNumber"));
                if (this.materialDetials.containsKey(key)) {
                    detList = (List)this.materialDetials.get(key);
                } else {
                    detList = new ArrayList();
                    this.materialDetials.put(key, detList);
                }
                this.lastSeq = rs.getInt("KSQL_seq");
                detailInfo = MRPDetailInfo.readRow(rs);
                detList.add(detailInfo);
            }
            rs = null;
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return detailInfo;
    }

    public List getOneMaterialDetialData(MRPCalcParam runParam, int period, String materialId, String projectNumber, String trackNumber, int theSeq) throws BOSException, MRPException {
        String key = this.getKey(period, materialId, projectNumber, trackNumber);
        if (this.materialDetials.containsKey(key)) {
            List detialList = (List)this.materialDetials.get(key);
            this.materialDetials.remove(key);
            ++this.hitCount;
            return detialList;
        }
        List seqList = this.materialDataUtil.getNextSeq(theSeq);
        int nextSeq = (Integer)seqList.get(0);
        if (this.lastSeq < nextSeq) {
            this.getNextData(runParam, seqList);
            if (this.materialDetials.containsKey(key)) {
                List detialList = (List)this.materialDetials.get(key);
                this.materialDetials.remove(key);
                return detialList;
            }
            return new ArrayList();
        }
        return new ArrayList();
    }

    private String getKey(MRPMaterialStatisticsInfo statisticsInfo) {
        return this.getKey(statisticsInfo.getPeriod(), statisticsInfo.getMaterialID(), statisticsInfo.getProjectNumber(), statisticsInfo.getTrackNumber());
    }

    private String getKey(MRPDetailInfo detailInfo) {
        return this.getKey(detailInfo.getPeriod(), detailInfo.getMaterialID(), detailInfo.getProjectNumber(), detailInfo.getTrackNumber());
    }

    private String getKey(int period, String materialId, String projectNumber, String trackNumber) {
        StringBuffer keyBuf = new StringBuffer();
        keyBuf.append(period);
        keyBuf.append(materialId);
        keyBuf.append(projectNumber);
        keyBuf.append(trackNumber);
        String key = keyBuf.toString();
        return key;
    }

    public void addDetailDataToMemory(MRPDetailInfo detailInfo, MRPMaterialStatisticsInfo statisticsInfo) {
        List<Object> detailList = null;
        String key = null;
        key = statisticsInfo != null ? this.getKey(statisticsInfo) : this.getKey(detailInfo);
        if (this.materialDetials.containsKey(key)) {
            detailList = (List)this.materialDetials.get(key);
            if (detailInfo.getMrpClassify().equals((Object)MRPClassifyEnum.Supply)) {
                detailList.add(0, detailInfo.clone());
            } else {
                detailList.add(detailInfo.clone());
            }
        } else {
            detailList = new ArrayList<MRPDetailInfo>();
            detailList.add(detailInfo);
            this.materialDetials.put(key, detailList);
        }
    }

    public MRPDetailInfo getDetailInMemory(MRPDetailInfo adetailInfo) throws BOSException {
        int period = adetailInfo.getSperiod();
        if (period <= 0) {
            period = adetailInfo.getPeriod();
        }
        return this.getDetailInMemory(adetailInfo.getMaterialID(), period, adetailInfo.getProjectNumber(), adetailInfo.getTrackNumber(), adetailInfo.getID());
    }

    public MRPDetailInfo getDetailInMemory(String materialId, int period, String projectNumber, String TrackNumber, String ID) throws BOSException {
        String key = this.getKey(period, materialId, projectNumber, TrackNumber);
        if (this.materialDetials.containsKey(key)) {
            List detialList = (List)this.materialDetials.get(key);
            for (int i = 0; i < detialList.size(); ++i) {
                MRPDetailInfo detailInfo = (MRPDetailInfo)detialList.get(i);
                if (!detailInfo.getID().equals(ID)) continue;
                return detailInfo;
            }
        }
        return null;
    }

    public MRPDetailInfo getDetailInfo(MRPCalcParam runParam, String materialId, int period, String billId) throws BOSException, MRPException {
        MRPDetailInfo detailInfo = this.getDetailInfoFromDB(runParam, materialId, period, billId);
        MRPDetailInfo tempInfo = null;
        if (detailInfo == null) {
            return detailInfo;
        }
        String key = this.getKey(period, materialId, detailInfo.getProjectNumber(), detailInfo.getTrackNumber());
        if (this.materialDetials.containsKey(key)) {
            List detialList = (List)this.materialDetials.get(key);
            for (int i = 0; i < detialList.size(); ++i) {
                tempInfo = (MRPDetailInfo)detialList.get(i);
                if (!billId.equals(tempInfo.getBillID()) || !materialId.equals(tempInfo.getMaterialID()) || !detailInfo.getMrpItem().equals((Object)tempInfo.getMrpItem())) continue;
                detailInfo = tempInfo;
                break;
            }
        }
        return detailInfo;
    }

    private MRPDetailInfo getDetailInfoFromDB(MRPCalcParam runParam, String materialId, int period, String billId) throws MRPException, BOSException {
        MRPDetailInfo info = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select * from ").append(runParam.getMrpCalcDetailTableName()).append(" d \n ");
        sql.append(" inner join ").append(runParam.getStatisticsTable()).append(" s on \n ");
        sql.append("d.FMaterialID = s.FMaterialID  and s.FProjectNumber = d.FProjectNumber ");
        sql.append(" and s.FTrackNumber = d.FTrackNumber and s.FPeriod = d.FPeriod ");
        sql.append("where d.FBillId=? and d.FMaterialId=? and d.FPeriod=?  ");
        Object[] param = new Object[]{billId, materialId, period};
        IRowSet rs = SQLUtils.executeQuery((Context)runParam.getCtx(), (String)sql.toString(), (Object[])param);
        try {
            if (rs.next()) {
                info = MRPDetailInfo.readRow(rs);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return info;
    }

    public boolean removeDetailInMemory(MRPDetailInfo adetailInfo) throws BOSException {
        int period = adetailInfo.getSperiod();
        if (period <= 0) {
            period = adetailInfo.getPeriod();
        }
        return this.removeDetailInMemory(adetailInfo.getMaterialID(), period, adetailInfo.getProjectNumber(), adetailInfo.getTrackNumber(), adetailInfo.getID());
    }

    public boolean removeDetailInMemory(String materialId, int period, String projectNumber, String TrackNumber, String ID) throws BOSException {
        String key = this.getKey(period, materialId, projectNumber, TrackNumber);
        if (this.materialDetials.containsKey(key)) {
            List detialList = (List)this.materialDetials.get(key);
            for (int i = 0; i < detialList.size(); ++i) {
                MRPDetailInfo detailInfo = (MRPDetailInfo)detialList.get(i);
                if (!detailInfo.getID().equals(ID)) continue;
                detialList.remove(i);
                return true;
            }
        }
        return false;
    }

    public void clearDetailInMemory(MRPDetailInfo adetailInfo) throws BOSException {
        int period = adetailInfo.getSperiod();
        if (period <= 0) {
            period = adetailInfo.getPeriod();
        }
        this.clearDetailInMemory(adetailInfo.getMaterialID(), period, adetailInfo.getProjectNumber(), adetailInfo.getTrackNumber(), adetailInfo.getID());
    }

    public void clearDetailInMemory(String materialId, int period, String projectNumber, String TrackNumber, String ID) throws BOSException {
        String key = this.getKey(period, materialId, projectNumber, TrackNumber);
        if (this.materialDetials.containsKey(key)) {
            List detialList = (List)this.materialDetials.get(key);
            for (int i = 0; i < detialList.size(); ++i) {
                MRPDetailInfo detailInfo = (MRPDetailInfo)detialList.get(i);
                if (!detailInfo.getID().equals(ID)) continue;
                detialList.remove(i);
            }
        }
    }

    public void releaseTemptable(MRPCalcParam runParam) throws BOSException, EASBizException {
        TempTablePool pool = TempTablePool.getInstance((Context)runParam.getCtx());
        if (!MMUtils.isEmptyString((String)this.advance_tmp)) {
            pool.releaseTable(this.advance_tmp);
        }
        if (!MMUtils.isEmptyString((String)this.qtyAjust_tmp)) {
            pool.releaseTable(this.qtyAjust_tmp);
        }
    }

    public Map getIsolatorOnhandDetail(MRPCalcParam runParam, String materialID) throws BOSException, MRPException {
        HashMap<String, MRPDetailInfo> map = new HashMap<String, MRPDetailInfo>();
        StringBuffer sql = new StringBuffer();
        sql.append("select t0.*, 0 KSQL_seq from ").append(runParam.getMrpCalcDetailTableName()).append(" t0 where FMaterialID='").append(materialID).append("'").append(" and FMRPItem = ").append(110);
        IRowSet rs = SQLUtils.executeQuery((Context)runParam.getCtx(), (String)sql.toString());
        try {
            while (rs.next()) {
                MRPDetailInfo info = MRPDetailInfo.readRow(rs);
                map.put(info.getTrackNumber(), info);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return map;
    }

    public MRPDetailInfo getSafeStockDetail(MRPCalcParam runParam, String materialID) throws BOSException, MRPException {
        StringBuffer sql = new StringBuffer();
        sql.append("select t0.*, 0 KSQL_seq from ").append(runParam.getMrpCalcDetailTableName()).append(" t0 where t0.FMaterialID='").append(materialID).append("'").append(" and t0.FMRPItem = ").append(120);
        IRowSet rs = SQLUtils.executeQuery((Context)runParam.getCtx(), (String)sql.toString());
        MRPDetailInfo info = null;
        try {
            while (rs.next()) {
                info = MRPDetailInfo.readRow(rs);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return info;
    }

    public int getDetailCount() {
        return this.detailCount;
    }

    public void setDetailCount(int detailCount) {
        this.detailCount = detailCount;
    }
}

