/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.app.mrp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.common.app.SQLUtils;
import com.kingdee.eas.mm.planning.MRPException;
import com.kingdee.eas.mm.planning.app.mrp.MRPCalcParam;
import com.kingdee.eas.mm.planning.app.mrp.MRPDetailInfo;
import com.kingdee.eas.mm.planning.app.mrp.MRPMaterialDataInfo;
import com.kingdee.eas.mm.planning.app.mrp.MRPMaterialStatisticsInfo;
import com.kingdee.eas.mm.planning.app.mrp.MRPMaterialTableDAO;
import com.kingdee.eas.mm.planning.app.mrp.MRPNetReqSaver;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MRPFetchSurplusDivertDataUtil {
    private String materialId;
    private MRPMaterialDataInfo materialDataInfo;
    private MRPCalcParam runParam = null;
    private HashMap materialDetials = new HashMap();
    private int detailType;
    private final int REQ = 10;
    private final int SUPPLY = 20;
    private final int ALL = 30;
    private List statisticsBufferList = new ArrayList();
    private int lastSeq = 0;
    private int lastDetailSeq = 0;
    private MRPMaterialStatisticsInfo lastStatisticsInfo;
    private boolean hasGetAllData = false;
    private MRPNetReqSaver dataSaver;

    public MRPFetchSurplusDivertDataUtil(MRPCalcParam runParam) {
        this.runParam = runParam;
    }

    public void setDataSaver(MRPNetReqSaver dataSaver) {
        this.dataSaver = dataSaver;
    }

    public void setMaterialId(String strId) throws EASBizException, BOSException {
        this.materialId = strId;
        this.statisticsBufferList.clear();
        this.materialDetials.clear();
        this.lastSeq = 0;
        this.hasGetAllData = false;
        this.materialDataInfo = this.getMRPMaterialDataInfo();
    }

    private MRPMaterialDataInfo getMRPMaterialDataInfo() throws EASBizException, BOSException {
        ArrayList<String> idList = new ArrayList<String>();
        idList.add(this.materialId);
        HashMap materials = MRPMaterialTableDAO.getLevelMaterialInfo(this.runParam, idList);
        return (MRPMaterialDataInfo)materials.get(this.materialId);
    }

    public int[] getCalcPeriod() throws BOSException, MRPException {
        StringBuffer sql = new StringBuffer();
        sql.append("select distinct FPeriod from ").append(this.runParam.getStatisticsTable()).append(" where ");
        sql.append(" FMaterialID = ?");
        if (this.detailType == this.REQ) {
            sql.append(" and FSurplusQty < 0 ");
        } else if (this.detailType == this.SUPPLY) {
            sql.append(" and FSurplusQty > 0 ");
        } else {
            sql.append(" and FSurplusQty <> 0 ");
        }
        sql.append(" order by FPeriod ");
        IRowSet rs = SQLUtils.executeQuery((Context)this.runParam.getCtx(), (String)sql.toString(), (Object[])new Object[]{this.materialId});
        int[] periods = new int[rs.size()];
        try {
            int i = 0;
            while (rs.next()) {
                periods[i++] = rs.getInt("FPeriod");
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return periods;
    }

    public MRPMaterialDataInfo getMaterialInfo(String materialID) {
        if (this.materialId != null && this.materialId.equals(materialID)) {
            return this.materialDataInfo;
        }
        return null;
    }

    private void fillBuffer4Req() throws MRPException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select top ").append(2000).append("  * from ").append(this.runParam.getStatisticsTable()).append(" where ");
        sql.append(" FMaterialID = ? ");
        sql.append(" AND FSurplusQty < 0 ");
        sql.append(" AND KSQL_seq> ? ");
        sql.append(" order by KSQL_seq ");
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(this.materialId);
        params.add(new Integer(this.lastSeq));
        IRowSet rs = SQLUtils.executeQuery((Context)this.runParam.getCtx(), (String)sql.toString(), (Object[])params.toArray());
        if (rs.size() > 0) {
            try {
                MRPMaterialStatisticsInfo statisticsInfo = null;
                while (rs.next()) {
                    statisticsInfo = MRPMaterialStatisticsInfo.readrs(rs);
                    this.statisticsBufferList.add(statisticsInfo);
                }
                this.lastSeq = statisticsInfo.getSeq();
                this.lastStatisticsInfo = statisticsInfo;
                this.hasGetAllData = rs.size() < 2000;
                rs = null;
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        } else {
            this.hasGetAllData = true;
        }
    }

    private void fillBuffer4Supply(int period, String projectNumber, String trackNumber) throws MRPException, BOSException {
        int minPeriod = this.runParam.getPlanDate().getPeriod() - this.runParam.getPlanVersion().getAdjustPeriod();
        int maxPeriod = this.runParam.getPlanDate().getPeriod() + this.runParam.getPlanVersion().getAdjustPeriod();
        StringBuffer sql = new StringBuffer();
        sql.append("select top ").append(2000).append("  * from ");
        sql.append(this.runParam.getStatisticsTable()).append(" where ");
        sql.append(" FMaterialID = ?");
        sql.append(" AND FPeriod <= ? ");
        if (projectNumber != null) {
            sql.append(" AND FProjectNumber = ? ");
        }
        if (trackNumber != null) {
            sql.append(" AND FTrackNumber = ? ");
        }
        sql.append(" AND KSQL_seq > ? ");
        sql.append(" AND FSurplusQty > 0 ");
        sql.append(" order by KSQL_seq ");
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(this.materialId);
        params.add(new Integer(maxPeriod));
        if (projectNumber != null) {
            params.add(projectNumber);
        }
        if (trackNumber != null) {
            params.add(trackNumber);
        }
        params.add(new Integer(this.lastSeq));
        IRowSet rs = SQLUtils.executeQuery((Context)this.runParam.getCtx(), (String)sql.toString(), (Object[])params.toArray());
        if (rs.size() > 0) {
            try {
                MRPMaterialStatisticsInfo statisticsInfo = null;
                while (rs.next()) {
                    statisticsInfo = MRPMaterialStatisticsInfo.readrs(rs);
                    this.statisticsBufferList.add(statisticsInfo);
                }
                this.lastSeq = statisticsInfo.getSeq();
                this.lastStatisticsInfo = statisticsInfo;
                this.hasGetAllData = rs.size() < 2000;
                rs = null;
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        } else {
            this.hasGetAllData = true;
        }
    }

    public List getOneMaterialDetialData(MRPCalcParam runParam, int period, String materialId, String projectNumber, String trackNumber, int theSeq) throws BOSException, MRPException {
        String key = this.getKey(period, materialId, projectNumber, trackNumber);
        if (this.materialDetials.containsKey(key)) {
            List detialList = (List)this.materialDetials.get(key);
            this.materialDetials.remove(key);
            return detialList;
        }
        List seqList = this.getNextSeq(theSeq);
        int nextSeq = (Integer)seqList.get(0);
        if (this.lastDetailSeq < nextSeq) {
            this.getNextData(runParam, seqList);
            if (this.materialDetials.containsKey(key)) {
                List detialList = (List)this.materialDetials.get(key);
                this.materialDetials.remove(key);
                return detialList;
            }
            return new ArrayList();
        }
        return new ArrayList();
    }

    private void getNextData(MRPCalcParam runParam2, List seqList) throws BOSException, MRPException {
        StringBuffer sql = new StringBuffer();
        sql.append("select d.* ,s.KSQL_seq from ").append(this.runParam.getMrpCalcDetailTableName()).append(" d");
        sql.append(" inner join ").append(this.runParam.getStatisticsTable()).append(" s ");
        sql.append(" on d.FMaterialID = s.FMaterialID  and s.FProjectNumber = d.FProjectNumber ");
        sql.append(" and s.FTrackNumber = d.FTrackNumber and s.FPeriod = d.FPeriod ");
        sql.append(" where s.FMaterialID = ?");
        sql.append(" and d.FMaterialID = ?");
        sql.append(" and (");
        for (int i = 0; i < seqList.size(); ++i) {
            sql.append(" s.KSQL_seq = ?");
            if (i == seqList.size() - 1) continue;
            sql.append(" OR ");
        }
        sql.append(") and d.FSupplyType <10930");
        sql.append(" and d.FMRPItem<>").append(110);
        sql.append(" and d.FMRPItem<>").append(120);
        if (this.detailType == this.REQ) {
            sql.append(" and d.FNetReq < 0 ");
        } else if (this.detailType == this.SUPPLY) {
            sql.append(" and d.FNetReq > 0 ");
            sql.append(" and d.FIsAjust = 1 ");
        }
        sql.append(" order by s.KSQL_seq,d.FMRPSeq  ");
        ArrayList<String> idList = new ArrayList<String>();
        idList.add(this.materialId);
        idList.add(this.materialId);
        idList.addAll(seqList);
        IRowSet rs = SQLUtils.executeQuery((Context)this.runParam.getCtx(), (String)sql.toString(), (Object[])idList.toArray());
        if (rs.size() > 0) {
            this.toMap(rs);
        }
    }

    private MRPDetailInfo toMap(IRowSet rs) throws BOSException {
        String key = null;
        List<MRPDetailInfo> detList = null;
        MRPDetailInfo detailInfo = null;
        try {
            while (rs.next()) {
                key = this.getKey(rs.getInt("FPeriod"), rs.getString("FMaterialID"), rs.getString("FProjectNumber"), rs.getString("FTrackNumber"));
                if (this.materialDetials.containsKey(key)) {
                    detList = (List)this.materialDetials.get(key);
                } else {
                    detList = new ArrayList();
                    this.materialDetials.put(key, detList);
                }
                this.lastDetailSeq = rs.getInt("KSQL_seq");
                detailInfo = MRPDetailInfo.readRow(rs);
                detList.add(detailInfo);
            }
            rs = null;
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return detailInfo;
    }

    public List getNextSeq(int fromSeq) {
        int detailCount = 0;
        ArrayList<Integer> seqList = new ArrayList<Integer>();
        seqList.add(new Integer(fromSeq));
        MRPMaterialStatisticsInfo statisticsInfo = null;
        for (int i = 0; i < this.statisticsBufferList.size(); ++i) {
            statisticsInfo = (MRPMaterialStatisticsInfo)this.statisticsBufferList.get(i);
            if (statisticsInfo.getSeq() <= fromSeq) continue;
            if ((detailCount += statisticsInfo.getDetailCount()) >= 2000) break;
            seqList.add(new Integer(statisticsInfo.getSeq()));
        }
        return seqList;
    }

    private String getKey(int period, String materialId, String projectNumber, String trackNumber) {
        StringBuffer keyBuf = new StringBuffer();
        keyBuf.append(period);
        keyBuf.append(materialId);
        keyBuf.append(projectNumber);
        keyBuf.append(trackNumber);
        String key = keyBuf.toString();
        return key;
    }

    public void clearSeq() {
        this.lastDetailSeq = 0;
    }

    public MRPMaterialDataInfo getNextMaterial(int period) throws BOSException {
        MRPMaterialStatisticsInfo statisticsInfo;
        MRPMaterialDataInfo materialInfo = null;
        if (this.statisticsBufferList.size() > 0 && period == (statisticsInfo = (MRPMaterialStatisticsInfo)this.statisticsBufferList.get(0)).getPeriod()) {
            materialInfo = this.getMaterialInfo(statisticsInfo.getMaterialID());
        }
        return materialInfo;
    }

    public boolean hasNextMaterial(int period) throws BOSException, MRPException {
        return this.hasNextStatisticData(period, null, null, null);
    }

    public boolean hasNextStatisticData(int period, String materialID, String projectNumber, String trackNumber) throws BOSException, MRPException {
        boolean bret = false;
        if (this.statisticsBufferList.size() <= 0 && !this.hasGetAllData) {
            if (this.detailType == 10) {
                this.fillBuffer4Req();
            } else if (this.detailType == 20) {
                this.fillBuffer4Supply(period, projectNumber, trackNumber);
            } else {
                this.fillBuffer();
            }
        }
        MRPMaterialStatisticsInfo statisticsInfo = null;
        if (this.statisticsBufferList.size() > 0) {
            statisticsInfo = (MRPMaterialStatisticsInfo)this.statisticsBufferList.get(0);
        }
        if (statisticsInfo != null) {
            bret = materialID != null ? this.isMatch(statisticsInfo, period, materialID, projectNumber, trackNumber) : period == statisticsInfo.getPeriod();
        }
        return bret;
    }

    private void fillBuffer() throws BOSException, MRPException {
        StringBuffer sql = new StringBuffer();
        sql.append("select top ").append(2000).append("  * from ");
        sql.append(this.runParam.getStatisticsTable()).append(" where ");
        sql.append(" FMaterialID = ?");
        sql.append(" AND KSQL_seq > ? ");
        sql.append(" AND FSurplusQty <> 0 ");
        sql.append(" order by KSQL_seq ");
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(this.materialId);
        params.add(new Integer(this.lastSeq));
        IRowSet rs = SQLUtils.executeQuery((Context)this.runParam.getCtx(), (String)sql.toString(), (Object[])params.toArray());
        if (rs.size() > 0) {
            try {
                MRPMaterialStatisticsInfo statisticsInfo = null;
                while (rs.next()) {
                    statisticsInfo = MRPMaterialStatisticsInfo.readrs(rs);
                    this.statisticsBufferList.add(statisticsInfo);
                }
                this.lastSeq = statisticsInfo.getSeq();
                this.lastStatisticsInfo = statisticsInfo;
                this.hasGetAllData = rs.size() < 2000;
                rs = null;
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        } else {
            this.hasGetAllData = true;
        }
    }

    public MRPMaterialStatisticsInfo getNextStatisticData(int period, String materialID, String projectNumber, String trackNumber) throws BOSException {
        MRPMaterialStatisticsInfo statisticsInfo = null;
        if (this.statisticsBufferList.size() > 0) {
            statisticsInfo = (MRPMaterialStatisticsInfo)this.statisticsBufferList.get(0);
            if (this.isMatch(statisticsInfo, period, materialID, projectNumber, trackNumber)) {
                this.statisticsBufferList.remove(0);
            } else {
                statisticsInfo = null;
            }
        }
        return statisticsInfo;
    }

    private boolean isMatch(MRPMaterialStatisticsInfo statisticsInfo, int period, String materialID, String projectNumber, String trackNumber) {
        boolean ret = false;
        if (this.detailType == 20) {
            if (projectNumber != null && trackNumber != null) {
                if (materialID.equals(statisticsInfo.getMaterialID()) && projectNumber.equals(statisticsInfo.getProjectNumber()) && trackNumber.equals(statisticsInfo.getTrackNumber())) {
                    ret = true;
                }
            } else if (materialID.equals(statisticsInfo.getMaterialID())) {
                ret = true;
            }
        } else if (materialID.equals(statisticsInfo.getMaterialID()) && period == statisticsInfo.getPeriod()) {
            ret = true;
        }
        return ret;
    }

    public Map getIsolatorOnhandDetail() throws BOSException, MRPException {
        HashMap<String, MRPDetailInfo> map = new HashMap<String, MRPDetailInfo>();
        StringBuffer sql = new StringBuffer();
        sql.append("select t0.*, 0 KSQL_seq from ").append(this.runParam.getMrpCalcDetailTableName()).append(" t0 where FMaterialID='").append(this.materialId).append("'").append(" and FMRPItem = ").append(110);
        IRowSet rs = SQLUtils.executeQuery((Context)this.runParam.getCtx(), (String)sql.toString());
        try {
            while (rs.next()) {
                MRPDetailInfo info = MRPDetailInfo.readRow(rs);
                info.setNetReqQty(info.getAvaliableQty());
                map.put(info.getProjectNumber() + info.getTrackNumber(), info);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return map;
    }

    public int getDetailType() {
        return this.detailType;
    }

    public void setDetailType(int detailType) {
        this.detailType = detailType;
    }
}

