/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.app.mrp;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.common.util.SQLUtil;
import com.kingdee.eas.mm.planning.MRPException;
import com.kingdee.eas.mm.planning.RequirementUniteRuleInfo;
import com.kingdee.eas.mm.planning.app.mrp.MRPBillParamInfo;
import com.kingdee.eas.mm.planning.app.mrp.MRPCalcParam;
import com.kingdee.eas.mm.planning.app.mrp.MRPStep;
import com.kingdee.eas.mm.planning.app.mrp.MRPUtil;
import java.util.ArrayList;
import java.util.List;

public abstract class MRPGetData
extends MRPStep {
    private MRPBillParamInfo info;
    private int level = -1;
    protected int billCount = 0;

    @Override
    protected Object innerExecute(MRPCalcParam runParam) throws EASBizException, BOSException {
        this.info = (MRPBillParamInfo)runParam.getBillParamMap().get(this.getBillTypeId());
        StringBuffer sql = new StringBuffer();
        ArrayList paramList = new ArrayList();
        this.getBillDateSQL(runParam, sql, paramList);
        sql.append(this.getLevelFilter());
        this.billCount = MRPUtil.executeUpdate(runParam.getCtx(), sql.toString(), paramList.toArray());
        this.afterGetBillData(runParam);
        return null;
    }

    protected void afterGetBillData(MRPCalcParam runParam) throws BOSException, EASBizException {
    }

    protected abstract Object getBillDateSQL(MRPCalcParam var1, StringBuffer var2, List var3) throws BOSException, EASBizException;

    protected abstract String getBillTypeId();

    protected int getPriority() {
        return this.info.getPriority();
    }

    protected int getIsAdjust() {
        if (this.runParam.isCooperatePlan()) {
            return 0;
        }
        return this.info.isAdjust() ? 1 : 0;
    }

    protected String getBizType() {
        if (this.info != null && this.info.getBizTypeIdArray() != null && this.info.getBizTypeIdArray().length != 0) {
            StringBuffer sql = new StringBuffer(" and bill.FBizTypeID in (");
            sql.append(SQLUtil.arrayToString((Object[])this.info.getBizTypeIdArray())).append(")");
            return sql.toString();
        }
        return "";
    }

    private String getLevelFilter() {
        if (this.level > -1) {
            return " and mm.FLowsetCode = " + this.level;
        }
        return "";
    }

    protected StringBuffer priorityJoint() {
        StringBuffer sql = new StringBuffer();
        if (this.planVerHasRequirementUniteRule()) {
            RequirementUniteRuleInfo info = this.runParam.getPlanVersion().getRequirementUniteRule();
            sql.append(info.getCorrelativeReqType() + 0);
        } else {
            sql.append(" isnull(TB.FcorrelativeReqType,0)+").append(0);
        }
        return sql;
    }

    protected boolean planVerHasRequirementUniteRule() {
        if (this.runParam.isCooperatePlan()) {
            return false;
        }
        return this.runParam.getPlanVersion().getRequirementUniteRule() != null;
    }

    protected void setLevel(int level) {
        this.level = level;
    }

    protected boolean needUpdateBillDate() {
        return true;
    }

    @Override
    protected int getDataAmount() {
        return this.billCount;
    }

    protected String getInsert() throws MRPException, BOSException {
        return MRPUtil.getInsert(this.runParam);
    }
}

