/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.app.mrp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.basedata.PlanVersionSetStoreStateInfo;
import com.kingdee.eas.mm.basedata.PlanVersionSetStoreTypeInfo;
import com.kingdee.eas.mm.basedata.WarehouseRangeEnum;
import com.kingdee.eas.mm.common.CommonUtils;
import com.kingdee.eas.mm.common.app.SQLUtils;
import com.kingdee.eas.mm.common.util.MMUtils;
import com.kingdee.eas.mm.planning.MRPException;
import com.kingdee.eas.mm.planning.app.mrp.MRPCalcParam;
import com.kingdee.eas.mm.planning.app.mrp.MRPDynamicTableManager;
import com.kingdee.eas.mm.planning.app.mrp.MRPPlanStrategyUtil;
import com.kingdee.eas.mm.planning.app.mrp.MRPResource;
import com.kingdee.eas.mm.planning.app.mrp.MRPSeqUtil;
import com.kingdee.eas.mm.planning.app.mrp.MRPStep;
import com.kingdee.eas.mm.planning.app.mrp.MRPUtil;
import java.text.SimpleDateFormat;

public class MRPGetMaterialOnHand
extends MRPStep {
    private int updateCount = 0;
    private int level = -1;

    @Override
    protected String getStepDesc() throws MRPException, BOSException {
        return this.getStepDesc(this.runParam) + "," + MRPResource.getString(this.runParam.getCtx(), "SYM_NUMBER") + ":" + String.valueOf(this.updateCount);
    }

    @Override
    protected String getStepDesc(MRPCalcParam runParam) throws MRPException, BOSException {
        return MRPResource.getString(runParam.getCtx(), "SP_GETMATERIALONHAND");
    }

    @Override
    protected boolean isNeedUpdateProgress() {
        return true;
    }

    @Override
    protected Object innerExecute(MRPCalcParam runParam) throws EASBizException, BOSException {
        if (runParam.isMaterialPlan() && this.level == -1) {
            this.setLevel(runParam.getLevel());
        }
        try {
            if (!runParam.isCalNetting()) {
                this.setSafeStockToZero(runParam);
                return null;
            }
            if (!runParam.isSafeStock()) {
                this.setSafeStockToZero(runParam);
            } else {
                this.insertSafeInv();
            }
            if (runParam.isIsAvailablStock()) {
                this.setOnHand();
                this.setOnHandForIsolator();
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    private void setSafeStockToZero(MRPCalcParam runParam) throws BOSException, MRPException {
        StringBuffer sql = new StringBuffer();
        sql.append("update ").append(runParam.getMaterialTableName()).append(" set FSafeStock = 0");
        this.updateCount = SQLUtils.execute((Context)runParam.getCtx(), (String)sql.toString());
    }

    private void setOnHand() throws BOSException, MRPException {
        TempTablePool pool;
        String inTempTableName;
        block9: {
            String strIXName = null;
            inTempTableName = null;
            StringBuffer sql = new StringBuffer();
            String materialTableName = this.runParam.getMaterialTableName();
            String strPlanVersionID = this.runParam.getPlanVersionID();
            pool = TempTablePool.getInstance((Context)this.runParam.getCtx());
            try {
                sql.append("create table ttt (").append("FMaterialID varchar(44) not null,").append("FBaseQty NUMERIC(21,8) not null default 0").append(")");
                inTempTableName = pool.createTempTable(sql.toString());
                sql.setLength(0);
                sql.append("insert into ").append(inTempTableName).append("(FMaterialID,FBaseQty)").append(" select inv.FMaterialID,sum(inv.FBaseQty) as FBaseQty");
                sql.append(this.getFromPart(false));
                sql.append(this.getWherePart(false));
                this.updateCount = SQLUtils.execute((Context)this.runParam.getCtx(), (String)sql.toString());
                strIXName = MRPDynamicTableManager.getValidIndexName(this.runParam.getCtx());
                sql.setLength(0);
                sql.append("Create Index ").append(strIXName).append(" on ").append(inTempTableName).append("(FMaterialID)");
                SQLUtils.execute((Context)this.runParam.getCtx(), (String)sql.toString());
                sql.setLength(0);
                sql.append("update ").append(materialTableName).append(" as t0 set (FOnHand) =  (").append("\r\n").append(" select invtemp.FBaseQty").append("\r\n").append(" from ").append("\r\n").append(materialTableName).append(" m ").append("\r\n").append(" inner join ").append(inTempTableName).append(" invtemp").append(" on m.fmaterialid = invtemp.FMaterialID").append("\r\n").append(" where m.FPlanVersionID = '").append(strPlanVersionID).append("'").append(" and t0.FID = m.FID )");
                this.updateCount = SQLUtils.execute((Context)this.runParam.getCtx(), (String)sql.toString());
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                String date = dateFormat.format(this.runParam.getRunStartTime());
                String mode = CommonUtils.getProperties((String)"firstconsume");
                String startDate = dateFormat.format(this.runParam.getMRPBeginDate().getDate().getTime());
                StringBuffer insertSql = new StringBuffer();
                insertSql.append("Insert Into ").append(this.runParam.getMrpCalcDetailTableName()).append("(FID,FPlanVersionID,FRunLogID,FMRPClassify,FMRPItem,FMaterialID,FAvaliable,").append("FprojectId,FTrackId,FProjectNumber,FTrackNumber,").append("FBProjectNumber,FBTrackNumber,FIsDefaultTNO,FPeriod,FBILLDATE,FMrpSeq) ");
                insertSql.append(" select newbosid('").append("F94043EF").append("'),").append("'").append(this.runParam.getPlanVersionID()).append("',").append("'").append(this.runParam.getRunLogID()).append("',").append(10).append(",").append(110).append(",").append("FMaterialId,FOnHand,").append("'").append(this.runParam.getProjectID()).append("',").append("'").append(this.runParam.getTrackID()).append("',").append("'").append(this.runParam.getProjectNumber()).append("',").append("'").append(this.runParam.getTrackNumber()).append("',").append("'").append(this.runParam.getProjectNumber()).append("',").append("'").append(this.runParam.getTrackNumber()).append("',").append(1).append(",");
                if ("0".equals(mode)) {
                    insertSql.append(this.runParam.getPlanDate().getPeriod()).append(",").append(" TO_DATE('").append(date).append("'),");
                } else {
                    insertSql.append(this.runParam.getMRPBeginDate().getPeriod()).append(",").append(" TO_DATE('").append(startDate).append("'),");
                }
                insertSql.append("'").append(MRPSeqUtil.INV_SEQ).append("'").append(" from ").append(materialTableName).append(" mm ").append(" where FPlanStrategy in (").append(MRPPlanStrategyUtil.getInvPlanStrategyStr(false)).append(")").append(this.getLevelFilter());
                MRPUtil.executeUpdate(this.runParam.getCtx(), insertSql.toString());
                if (strIXName == null) break block9;
                sql.setLength(0);
                sql.append("Drop Index ").append(inTempTableName).append(".").append(strIXName);
            }
            catch (Exception e) {
                try {
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    if (strIXName != null) {
                        sql.setLength(0);
                        sql.append("Drop Index ").append(inTempTableName).append(".").append(strIXName);
                        SQLUtils.execute((Context)this.runParam.getCtx(), (String)sql.toString());
                    }
                    if (inTempTableName != null) {
                        pool.releaseTable(inTempTableName);
                    }
                    throw throwable;
                }
            }
            SQLUtils.execute((Context)this.runParam.getCtx(), (String)sql.toString());
        }
        if (inTempTableName != null) {
            pool.releaseTable(inTempTableName);
        }
    }

    private void setOnHandForIsolator() throws BOSException, MRPException {
        String tableName = null;
        if (MMUtils.isEmptyString((String)this.runParam.getInvDetailTableName())) {
            tableName = MRPDynamicTableManager.createPhysicalTable4Inv(this.runParam.getCtx());
            this.runParam.setInvDetailTableName(tableName);
        } else {
            tableName = this.runParam.getInvDetailTableName();
        }
        StringBuffer sql = new StringBuffer();
        String projectNumber = "'" + this.runParam.getProjectNumber() + "'";
        String trackNumber = "'" + this.runParam.getTrackNumber() + "'";
        String projectID = "'" + this.runParam.getProjectID() + "'";
        String trackID = "'" + this.runParam.getTrackID() + "'";
        String def_ProjectID = "'EgkAAABc3Xza3gXu'";
        String def_TrackID = "'EgkAAABc3X0Ibpg9'";
        sql.append("insert into ").append(tableName).append("(FID,FMaterialID,FBaseQty,FProjectID,FTrackID,FProjectNumber,FTrackNumber,FLowsetCode)").append("select newbosid('").append(MRPUtil.getBosType()).append("'),").append("inv.FMaterialID,sum(inv.FBaseQty) as FBaseQty,").append("case when inv.FProjectID = ").append(def_ProjectID).append(" then ").append(projectID).append(" else inv.FProjectID end,").append("case when inv.FTrackNumberID = ").append(def_TrackID).append(" then ").append(trackID).append(" else inv.FTrackNumberID end,").append("isnull(P.FNumber,").append(projectNumber).append("),").append("isnull(T.FNumber,").append(trackNumber).append("),").append(this.level);
        sql.append(this.getFromPart(true));
        sql.append(this.getWherePart(true));
        this.updateCount = MRPUtil.executeUpdate(this.runParam.getCtx(), sql.toString()) + this.updateCount;
        sql.setLength(0);
        sql.append("insert into ").append(tableName).append("(FID,FMaterialID,FBaseQty,FProjectID,FTrackID,FProjectNumber,FTrackNumber,FLowsetCode)").append("select newbosid('").append(MRPUtil.getBosType()).append("'),").append("mm.FMaterialID,0 as FBaseQty,").append("'").append(this.runParam.getProjectID()).append("',").append("'").append(this.runParam.getTrackID()).append("',").append(projectNumber).append(",").append(trackNumber).append(",").append(this.level).append(" from ").append(this.runParam.getMaterialTableName()).append(" mm left join ").append(tableName).append(" t2 ").append(" on mm.FMaterialID = t2.FMaterialID ").append(" and t2.FProjectNumber=").append(projectNumber).append(" and t2.FTrackNumber=").append(trackNumber).append(" where t2.FID is null and mm.FPlanStrategy in (").append(MRPPlanStrategyUtil.getInvPlanStrategyStr(true)).append(")").append(this.getLevelFilter());
        MRPUtil.executeUpdate(this.runParam.getCtx(), sql.toString());
        try {
            String mode = CommonUtils.getProperties((String)"firstconsume");
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            String date = dateFormat.format(this.runParam.getRunStartTime());
            String startDate = dateFormat.format(this.runParam.getMRPBeginDate().getDate().getTime());
            StringBuffer insertSql = new StringBuffer();
            insertSql.append("Insert Into ").append(this.runParam.getMrpCalcDetailTableName()).append("(FID,FPlanVersionID,FRunLogID,FMRPClassify,FMRPItem,FMaterialID,FAvaliable,").append("FProjectID,FTrackID,FProjectNumber,FTrackNumber,").append("FBProjectNumber,FBTrackNumber,FIsDefaultTNO,FPeriod,FBILLDATE,FMrpSeq) ");
            insertSql.append(" select newbosid('").append("F94043EF").append("'),").append("'").append(this.runParam.getPlanVersionID()).append("',").append("'").append(this.runParam.getRunLogID()).append("',").append(10).append(",").append(110).append(",").append("FMaterialId,FBaseQty,FProjectID,FTrackID,FProjectNumber,FTrackNumber,FProjectNumber,FTrackNumber,").append("case when FTrackNumber=").append(trackNumber).append(" then ").append(1).append(" else ").append(2).append(" end,");
            if ("0".equals(mode)) {
                insertSql.append(this.runParam.getPlanDate().getPeriod()).append(",").append(" TO_DATE('").append(date).append("'), ");
            } else {
                insertSql.append(this.runParam.getMRPBeginDate().getPeriod()).append(",").append(" TO_DATE('").append(startDate).append("'),");
            }
            insertSql.append("'").append(MRPSeqUtil.INV_SEQ).append("'").append(" from ").append(tableName).append(" mm where 1=1 ").append(this.getLevelFilter());
            MRPUtil.executeUpdate(this.runParam.getCtx(), insertSql.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected StringBuffer getFromPart(boolean isolation) {
        StringBuffer sqlFromPart = new StringBuffer();
        sqlFromPart.append("\r\n").append(" from T_IM_Inventory inv ").append(" inner join ").append(this.runParam.getMaterialTableName()).append(" mm on inv.FMaterialID = mm.FMaterialID").append("\r\n");
        if (WarehouseRangeEnum.CUSTOM.equals((Object)this.runParam.getRunLogInfo().getPlanVersion().getWarehouseRange())) {
            sqlFromPart.append(" inner join T_MM_PlanVersionSetEntrys pv ").append("on inv.FWarehouseID = pv.FWarehouseID ");
        }
        if (isolation) {
            sqlFromPart.append(" Left join T_MM_TrackNumber T on inv.FTrackNumberID = T.FID").append(" Left join T_MM_Project P on inv.FProjectID = P.FID");
        }
        return sqlFromPart;
    }

    protected StringBuffer getWherePart(boolean isolation) {
        StringBuffer sql = new StringBuffer();
        sql.append(" where inv.FStorageorgunitid = '").append(this.runParam.getStorageOrgUnitID()).append("' ").append("\r\n");
        sql.append(this.storeTypeJoint()).append("\r\n");
        sql.append(this.storeStateJoint()).append("\r\n");
        sql.append(this.getLevelFilter());
        sql.append(" and mm.FPlanStrategy in (").append(MRPPlanStrategyUtil.getInvPlanStrategyStr(isolation)).append(")");
        if (WarehouseRangeEnum.CUSTOM.equals((Object)this.runParam.getRunLogInfo().getPlanVersion().getWarehouseRange())) {
            sql.append(" and pv.FParentID = '").append(this.runParam.getPlanVersionID()).append("' ");
        }
        sql.append(" and inv.FBaseQty<>0 ");
        this.groupByPart(sql, isolation);
        return sql;
    }

    protected StringBuffer storeStateJoint() {
        StringBuffer sql = new StringBuffer();
        String conSym = " ";
        for (PlanVersionSetStoreStateInfo storeStateInfo : this.runParam.getPlanVersion().getStorestate()) {
            if (!storeStateInfo.isIsMrpRun()) continue;
            sql.append(conSym).append("inv.FStoreStatusID='").append(storeStateInfo.getStoreState().getId()).append("'");
            conSym = " or ";
        }
        if (sql.length() != 0) {
            sql.insert(0, " and (").append(") ");
        } else {
            sql.append(" and 1<>1 ");
        }
        return sql;
    }

    protected StringBuffer storeTypeJoint() {
        StringBuffer sql = new StringBuffer();
        String conSym = " ";
        for (PlanVersionSetStoreTypeInfo storeTypeInfo : this.runParam.getPlanVersion().getStoretype()) {
            if (!storeTypeInfo.isIsMrpRun()) continue;
            sql.append(conSym).append("inv.FStoreTypeID='").append(storeTypeInfo.getStoreType().getId()).append("'");
            conSym = " or ";
        }
        if (sql.length() != 0) {
            sql.insert(0, " and (").append(") ");
        } else {
            sql.append(" and 1<>1 ");
        }
        return sql;
    }

    protected void groupByPart(StringBuffer sql, boolean isolation) {
        sql.append(" group by inv.FMaterialID ");
        if (isolation) {
            sql.append(",inv.FProjectID,inv.FTrackNumberID,P.FNumber,T.FNumber");
        }
    }

    private String getLevelFilter() {
        if (this.level > -1) {
            return " and mm.FLowsetCode = " + this.level;
        }
        return "";
    }

    private void insertSafeInv() throws BOSException, MRPException {
        StringBuffer sql = new StringBuffer();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String date = dateFormat.format(this.runParam.getRunStartTime());
        String startDate = dateFormat.format(this.runParam.getMRPBeginDate().getDate().getTime());
        try {
            String mode = CommonUtils.getProperties((String)"firstconsume");
            sql.append("Insert Into ").append(this.runParam.getMrpCalcDetailTableName()).append("(FID,FPlanVersionID,FRunLogID,FMRPClassify,FMRPItem,FMaterialID,FAvaliable,FDependent,").append("FProjectId,FTrackId,FBProjectId,FBTrackId,FProjectNumber,FTrackNumber,").append("FBProjectNumber,FBTrackNumber,FIsDefaultTNO,FPeriod,FBILLDATE,FMrpSeq) ");
            sql.append(" select newbosid('").append("F94043EF").append("'),").append("'").append(this.runParam.getPlanVersionID()).append("',").append("'").append(this.runParam.getRunLogID()).append("',").append(10).append(",").append(120).append(",").append("FMaterialId,-1*FSafeStock,-1*FSafeStock,").append("'").append(this.runParam.getProjectID()).append("',").append("'").append(this.runParam.getTrackID()).append("',").append("'").append(this.runParam.getProjectID()).append("',").append("'").append(this.runParam.getTrackID()).append("',").append("'").append(this.runParam.getProjectNumber()).append("',").append("'").append(this.runParam.getTrackNumber()).append("',").append("'").append(this.runParam.getProjectNumber()).append("',").append("'").append(this.runParam.getTrackNumber()).append("',").append(1).append(",");
            if ("0".equals(mode)) {
                sql.append(this.runParam.getPlanDate().getPeriod()).append(",").append(" TO_DATE('").append(date).append("'),");
            } else {
                sql.append(this.runParam.getMRPBeginDate().getPeriod()).append(",").append(" TO_DATE('").append(startDate).append("'),");
            }
            sql.append("'").append("00133").append("'").append(" from ").append(this.runParam.getMaterialTableName()).append(" mm where 1=1 ").append(this.getLevelFilter()).append(" and mm.fplanStrategy<>'").append("NUnM+gEcEADgAA3ewKgL09g0uEU=").append("' ");
            MRPUtil.executeUpdate(this.runParam.getCtx(), sql.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    public void setLevel(int level) {
        this.level = level;
    }

    @Override
    protected int getDataAmount() {
        return this.updateCount;
    }
}

