/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.app.mrp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.common.app.SQLUtils;
import com.kingdee.eas.mm.planning.MRPException;
import com.kingdee.eas.mm.planning.app.mrp.MRPCalcParam;
import com.kingdee.eas.mm.planning.app.mrp.MRPMaterialTableDAO;
import com.kingdee.eas.mm.planning.app.mrp.MRPResource;
import com.kingdee.eas.mm.planning.app.mrp.MRPStep;
import com.kingdee.eas.mm.planning.app.mrp.MRPUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class MRPGetMaterials
extends MRPStep {
    private int updateCount = 0;
    protected static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.planning.app.mrp.MRPGetAllMaterials");

    public MRPGetMaterials() {
        if (isMoreInfo.booleanValue()) {
            logger.setLevel(Level.INFO);
        } else {
            logger.setLevel(Level.ERROR);
        }
    }

    @Override
    protected String getStepDesc() throws MRPException, BOSException {
        return this.getStepDesc(this.runParam) + "," + MRPResource.getString(this.runParam.getCtx(), "SYM_NUMBER") + ":" + String.valueOf(this.updateCount);
    }

    @Override
    protected String getStepDesc(MRPCalcParam runParam) throws MRPException, BOSException {
        return MRPResource.getString(runParam.getCtx(), "SP_GETALLMATERIAL");
    }

    @Override
    protected boolean isNeedUpdateProgress() {
        return true;
    }

    @Override
    protected Object innerExecute(MRPCalcParam runParam) throws EASBizException, BOSException {
        StringBuffer sql_getAllMaterials = new StringBuffer();
        sql_getAllMaterials.append(this.getInsertPart(runParam));
        sql_getAllMaterials.append(this.getSelectPart(runParam));
        sql_getAllMaterials.append(this.getFromPart(runParam));
        sql_getAllMaterials.append(this.getWherePart(runParam));
        this.updateCount = MRPUtil.executeUpdate(runParam.getCtx(), sql_getAllMaterials.toString());
        runParam.setMaterialCount(this.updateCount);
        this.checkMateiral(runParam.getMaterialTableName());
        MRPMaterialTableDAO.updateMaterialInfo(runParam);
        return null;
    }

    protected void checkMateiral(String tempTable) throws MRPException, BOSException {
        String checkSql = "select FMaterialNumber,count(*) from " + tempTable + " group by FMaterialNumber having count(*) > 1 ";
        IRowSet rowSet = SQLUtils.executeQuery((Context)this.runParam.getCtx(), (String)checkSql);
        try {
            StringBuffer dbMsgBuf = new StringBuffer();
            StringBuffer fileMsgBuf = new StringBuffer();
            while (rowSet.next()) {
                if (dbMsgBuf.length() + rowSet.getString("FMaterialNumber").length() < 963) {
                    dbMsgBuf.append(rowSet.getString("FMaterialNumber")).append(",");
                } else {
                    dbMsgBuf.append("......");
                }
                fileMsgBuf.append(rowSet.getString("FMaterialNumber")).append(",");
            }
            if (dbMsgBuf.length() > 0) {
                MRPException exp = new MRPException(MRPException.MATERIAL_REDUPLICATE, new Object[]{fileMsgBuf.toString()});
                logger.info((Object)exp.getMessage());
                exp = new MRPException(MRPException.MATERIAL_REDUPLICATE, new Object[]{dbMsgBuf.toString()});
                throw exp;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected StringBuffer getInsertPart(MRPCalcParam runParam) {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into ").append(runParam.getMaterialTableName()).append(" ( ").append("\r\n").append("FID,").append("FPlanVersionID,").append("FRunLogID,").append("FMaterialID,").append("FMaterialNumber,").append("FBaseUnitID,").append("FBaseQtyPrc,").append("FProdUnitID,").append("FProdQtyPrc,").append("FConvertRate,").append("FPlanner,").append("FLowsetCode,").append("FSafeStock,").append("FQtyMax,").append("FIsMergeSign,").append("FYield,").append("FPlanStrategy,").append("FBatchPolicy,").append("FFixationBatchQty,").append("FMinBatchQty,").append("FRoundUpMultipleQty,").append("FBatchIncQty,").append("FMaterialAttr,").append("FPlanningMode,").append("FRecevingLeadTime,").append("FProduceLeadTime,").append("FForwardProcessTime,").append("FBackwardProcessTime,").append("FSupplyType,").append("FSupplyOrgUnitID,").append("FQtyMinPackage,").append("FRequirementUniteRuleID , ").append("FManufactureDepartment,").append("FProductTranTypeID ,").append("FLeadTimeType,").append("FChangeLeadTime,").append("FChangeBatch,").append("FIsCanNotThrow,").append("FPartitionQty,").append("FMaxBatchQty,").append("FBatchCycle,").append("FisolateRules,").append("FIsSurplusDivert,").append("FisComReqConsume,").append("FPlanOrgUnit").append(")");
        return sql;
    }

    protected StringBuffer getSelectPart(MRPCalcParam runParam) {
        StringBuffer sql = new StringBuffer();
        sql.append("\r\n").append(" select ").append("newbosid('").append(MRPUtil.getBosType()).append("'),").append("\r\n").append("'").append(runParam.getPlanVersionID()).append("',").append("\r\n").append("'").append(runParam.getRunLogID()).append("',").append("\r\n").append("m.FID,").append("\r\n").append("m.FNumber,").append("m.FBaseUnit,").append("u1.FQtyPrecision,").append("mp.FProductUnitID,").append("u3.FQTYPRECISION,").append("u3.FBASECONVSRATE,").append("mp.FPlanner,").append("lc.FLowCode,").append("round(decimal(isnull(mi.FQtySafety,0) * u2.FBASECONVSRATE,21,8),u1.FQTYPRECISION),").append("round(decimal(isnull(mi.FQtyMax,-1) * u2.FBASECONVSRATE,21,8),u1.FQTYPRECISION),").append("mp.FIsMergeSign,").append("100, ").append("mp.FManufactureStrategyID,").append("mp.FBatchPolicy,").append("round(decimal(isnull(mp.FFixationBatchQty,0) * u3.FBASECONVSRATE,21,8),u1.FQTYPRECISION),").append("round(decimal(isnull(mp.FMinBatchQty,0) * u3.FBASECONVSRATE,21,8),u1.FQTYPRECISION),").append("round(decimal(isnull(mp.FRoundUpMultipleQty,0) * u3.FBASECONVSRATE,21,8),u1.FQTYPRECISION),").append("round(decimal(isnull(mp.FBatchIncQty,0) * u3.FBASECONVSRATE,21,8),u1.FQTYPRECISION),").append("mp.FMaterialAttr,").append("mp.FPlanningMode,").append("mp.FRecevingLeadTime,").append("mp.FProduceLeadTime,").append("mp.FForwardProcessTime,").append("mp.FBackwardProcessTime,").append("mp.FProvideType,").append("mp.FSupplyOrgUnit ,").append("round(decimal(isnull(mi.FQtyMinPackage ,0) * u2.FBASECONVSRATE,21,8),u1.FQTYPRECISION),").append("mp.FReqUniteRuleID, ").append("mp.FdutyDepartment , ").append("case when mp.FMaterialAttr = 10030 then pt.FID else null end ,").append("mp.FLeadTimeType,").append("isnull(mp.FChangeLeadTime,0),").append("isnull(mp.FChangeBatch,0),").append("mp.FIsPlanNoRelease,").append("case when mp.FPartitionType = 10 then mp.FPartitionDays else 0 - mp.FPartitionDays end,").append("round(decimal(isnull(mp.FMaxBatchQty,0) * u3.FBASECONVSRATE,21,8),u1.FQTYPRECISION),").append("mp.FBatchCycle,").append("mp.FISOLATEDRULE,").append(this.getSurplusDivertJudgeStr()).append("mp.FisComReqConsume,").append("mp.FPlanOrgID ");
        return sql;
    }

    private StringBuffer getSurplusDivertJudgeStr() {
        StringBuffer str = new StringBuffer();
        if (this.runParam.getAdvanceType() == 0 && this.runParam.isCalNetting()) {
            str.append("mp.FIsMargin,");
        } else {
            str.append("0,");
        }
        return str;
    }

    protected StringBuffer getFromPart(MRPCalcParam runParam) {
        StringBuffer sql = new StringBuffer();
        String strOrgUnitid = runParam.getRunLogInfo().getStorageOrgUnit().getId().toString();
        sql.append(" from t_bd_material m ").append("\r\n").append(" inner join T_BD_MaterialPlan mp on m.FID=mp.FMaterialID and mp.FStatus<>2 and mp.FOrgUnit= '").append(strOrgUnitid).append("'").append("\r\n").append(" left outer join t_mm_producttransactiontype pt on mp.FProductTranType=pt.FID ").append(" and pt.FStatus=20 ").append("\r\n").append(" inner join T_BD_MaterialInventory mi on m.FID=mi.FMaterialID and mi.FStatus<>2 and mi.FOrgUnit='").append(strOrgUnitid).append("'").append("\r\n").append(" inner join T_BD_MultiMeasureUnit u1 on m.fid=u1.FMaterialID and m.FBaseUnit=u1.FMeasureUnitID ").append("\r\n").append(" inner join T_BD_MultiMeasureUnit u2 on mi.FMaterialID=u2.FMaterialID and mi.FUnitID=u2.FMeasureUnitID ").append("\r\n").append(" inner join T_BD_MultiMeasureUnit u3 on mp.FMaterialID=u3.FMaterialID and mp.FProductUnitID=u3.FMeasureUnitID ").append("\r\n").append(" inner join T_MM_LowLevelCode lc on m.FID=lc.FMaterialID and lc.FStorageOrgUnitID='").append(strOrgUnitid).append("'").append("\r\n");
        return sql;
    }

    protected StringBuffer getWherePart(MRPCalcParam runParam) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" where ").append("\r\n");
        sql.append(" m.FStatus<>2 and m.FStatus<>3 ").append("\r\n");
        sql.append(" and (mp.FOutputType = 10710 or mp.FOutputType = 10740) ").append("\r\n");
        return sql;
    }

    @Override
    protected int getDataAmount() {
        return this.updateCount;
    }
}

