/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.app.mrp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.mm.common.app.SQLUtils;
import com.kingdee.eas.mm.planning.MRPElementEnum;
import com.kingdee.eas.mm.planning.app.mrp.MRPDetailInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MRPHierarchyCodeGenerator {
    private Map hierarchyCodeMap = new HashMap();
    private Map childSeqMap = new HashMap();
    private List newTrackNumbers = new ArrayList();
    private String storageOrgUnitId = null;
    private Context ctx = null;
    private int codeLength = 3;
    private String tempTable = null;

    public MRPHierarchyCodeGenerator(Context ctx, String storageOrgUnitId) throws BOSException {
        this.ctx = ctx;
        this.storageOrgUnitId = storageOrgUnitId;
        this.tempTable = this.createTempTable();
    }

    public void clearSeq() throws BOSException {
        this.insertTempData();
        this.childSeqMap.clear();
    }

    public void updateCode() throws BOSException {
        this.insertNewTrackNumbers();
        this.updateExistedTrackNumbers();
        this.releaseTempTable(this.tempTable);
    }

    public String getHierarchyCode(MRPDetailInfo detailInfo) throws BOSException {
        String hierarchyCode = null;
        String trackNumberId = detailInfo.getBTrackID();
        if (trackNumberId == null) {
            return hierarchyCode;
        }
        if (detailInfo.getHierarchyCode() == null) {
            if (!detailInfo.getMrpItem().equals((Object)MRPElementEnum.R_PlannedOrder)) {
                hierarchyCode = this.getCodeByTrackNumber(trackNumberId);
            }
        } else {
            hierarchyCode = this.getCodeByParent(detailInfo);
        }
        return hierarchyCode;
    }

    public int getCodeLength() {
        return this.codeLength;
    }

    public void setCodeLength(int codeLength) {
        this.codeLength = codeLength;
    }

    private String getCodeByParent(MRPDetailInfo detailInfo) throws BOSException {
        String hierarchyCode = detailInfo.getHierarchyCode();
        hierarchyCode = hierarchyCode + this.getSeqByParent(hierarchyCode);
        return hierarchyCode;
    }

    private synchronized String getCodeByTrackNumber(String trackNumberId) throws BOSException {
        String hierarchyCode = null;
        Integer code = null;
        Integer currentCode = null;
        if (this.hierarchyCodeMap.get(trackNumberId) == null) {
            code = this.queryHierarchyCodeFromDB(trackNumberId);
            if (code == null) {
                this.newTrackNumbers.add(trackNumberId);
                code = new Integer(1);
            }
            this.hierarchyCodeMap.put(trackNumberId, code);
        }
        currentCode = (Integer)this.hierarchyCodeMap.get(trackNumberId);
        hierarchyCode = this.formateHierarchyCode(currentCode);
        this.hierarchyCodeMap.put(trackNumberId, new Integer(currentCode + 1));
        return hierarchyCode;
    }

    private synchronized String getSeqByParent(String hierarchyCode) throws BOSException {
        String childSeq = null;
        Integer seq = null;
        Integer currentSeq = null;
        Integer tempSeq = null;
        if (this.childSeqMap.get(hierarchyCode) == null) {
            seq = this.querySeqFromTempTable(hierarchyCode);
            if (seq == null) {
                currentSeq = new Integer(1);
                childSeq = this.formateHierarchyCode(currentSeq);
                this.childSeqMap.put(hierarchyCode, new Integer(currentSeq + 1));
            } else {
                currentSeq = seq;
                tempSeq = new Integer(currentSeq + 1);
                this.updateSeqFromTempTable(hierarchyCode, tempSeq);
            }
            childSeq = this.formateHierarchyCode(currentSeq);
        } else {
            currentSeq = (Integer)this.childSeqMap.get(hierarchyCode);
            childSeq = this.formateHierarchyCode(currentSeq);
            this.childSeqMap.put(hierarchyCode, new Integer(currentSeq + 1));
        }
        return childSeq;
    }

    private Integer queryHierarchyCodeFromDB(String trackNumberId) throws BOSException {
        Integer hierarchyCode = null;
        StringBuffer querySql = new StringBuffer();
        querySql.append("select FHierarchyCode from T_MM_HierachyCode \n");
        querySql.append("where FStorageOrgUnitId=? and FTrackNumberId=?");
        Object[] param = new Object[]{this.storageOrgUnitId, trackNumberId};
        IRowSet rs = SQLUtils.executeQuery((Context)this.ctx, (String)querySql.toString(), (Object[])param);
        try {
            if (rs.next()) {
                hierarchyCode = new Integer(rs.getInt("FHierarchyCode"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return hierarchyCode;
    }

    private Integer querySeqFromTempTable(String hierarchyCode) throws BOSException {
        Integer seq = null;
        StringBuffer querySql = new StringBuffer();
        querySql.append("select FChildSeq from ").append(this.tempTable).append(" where FHierarchyCode=?");
        Object[] param = new Object[]{hierarchyCode};
        IRowSet rs = SQLUtils.executeQuery((Context)this.ctx, (String)querySql.toString(), (Object[])param);
        try {
            if (rs.next()) {
                seq = new Integer(rs.getInt("FChildSeq"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return seq;
    }

    private Integer updateSeqFromTempTable(String hierarchyCode, Integer tempSeq) throws BOSException {
        Integer seq = null;
        StringBuffer updateSql = new StringBuffer();
        updateSql.append("update ").append(this.tempTable).append(" set FChildSeq=? where FHierarchyCode=?");
        Object[] param = new Object[]{tempSeq, hierarchyCode};
        SQLUtils.execute((Context)this.ctx, (String)updateSql.toString(), (Object[])param);
        return seq;
    }

    private void insertNewTrackNumbers() throws BOSException {
        if (this.newTrackNumbers.size() == 0) {
            return;
        }
        StringBuffer insertSql = new StringBuffer();
        insertSql.append("insert into T_MM_HierachyCode (FID,FStorageOrgUnitId,FTrackNumberId,FHierarchyCode) ");
        insertSql.append("select newbosid('F94043EF'),?,?,? ");
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        Object[] param = null;
        String trackNumberId = null;
        Integer hierarchyCode = null;
        String formattedHierarchyCode = null;
        for (int i = 0; i < this.newTrackNumbers.size(); ++i) {
            trackNumberId = (String)this.newTrackNumbers.get(i);
            hierarchyCode = (Integer)this.hierarchyCodeMap.get(trackNumberId);
            formattedHierarchyCode = this.formateHierarchyCode(hierarchyCode);
            param = new Object[]{this.storageOrgUnitId, trackNumberId, formattedHierarchyCode};
            paramList.add(param);
        }
        SQLUtils.executeBatch((Context)this.ctx, (String)insertSql.toString(), paramList);
    }

    private void updateExistedTrackNumbers() throws BOSException {
        StringBuffer updateSql = new StringBuffer();
        updateSql.append("update T_MM_HierachyCode set FHierarchyCode=? where FStorageOrgUnitId=?");
        updateSql.append(" and FTrackNumberId=? ");
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        Object[] updateParam = null;
        Iterator trackNumberIds = this.hierarchyCodeMap.keySet().iterator();
        String trackNumberId = null;
        Integer hierarchyCode = null;
        String formattedHierarchyCode = null;
        while (trackNumberIds.hasNext()) {
            trackNumberId = (String)trackNumberIds.next();
            if (this.newTrackNumbers.contains(trackNumberId)) continue;
            hierarchyCode = (Integer)this.hierarchyCodeMap.get(trackNumberId);
            formattedHierarchyCode = this.formateHierarchyCode(hierarchyCode);
            updateParam = new Object[]{formattedHierarchyCode, this.storageOrgUnitId, trackNumberId};
            paramList.add(updateParam);
        }
        SQLUtils.executeBatch((Context)this.ctx, (String)updateSql.toString(), paramList);
    }

    private void insertTempData() throws BOSException {
        if (this.childSeqMap.size() == 0) {
            return;
        }
        StringBuffer insertSql = new StringBuffer();
        insertSql.append("insert into ").append(this.tempTable).append(" (FHierarchyCode,FChildSeq) ");
        insertSql.append("values(?,?)");
        Iterator hierarchyCodes = this.childSeqMap.keySet().iterator();
        String hierarchyCode = null;
        Integer childSeq = null;
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        Object[] updateParam = null;
        while (hierarchyCodes.hasNext()) {
            hierarchyCode = (String)hierarchyCodes.next();
            this.childSeqMap.get(hierarchyCode);
            childSeq = (Integer)this.childSeqMap.get(hierarchyCode);
            updateParam = new Object[]{hierarchyCode, childSeq};
            paramList.add(updateParam);
        }
        SQLUtils.executeBatch((Context)this.ctx, (String)insertSql.toString(), paramList);
    }

    private String createTempTable() throws BOSException {
        StringBuffer createTableSQL = new StringBuffer();
        String tableName = null;
        createTableSQL.append(" CREATE TABLE tmpSeqData (");
        createTableSQL.append(" FHierarchyCode varchar(500),");
        createTableSQL.append(" FChildSeq INT)");
        TempTablePool pool = TempTablePool.getInstance((Context)this.ctx);
        try {
            tableName = pool.createTempTable(createTableSQL.toString());
            pool.createIndex(tableName, "FHierarchyCode", false, false);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tableName;
    }

    private void releaseTempTable(String tableName) {
        TempTablePool pool = TempTablePool.getInstance((Context)this.ctx);
        pool.releaseTable(tableName);
    }

    private String formateHierarchyCode(Integer hierarchyCode) {
        StringBuffer formateHierarchyCode = new StringBuffer();
        String codeString = hierarchyCode.toString();
        int hierarchyCodeLength = this.getCodeLength();
        int different = hierarchyCodeLength - codeString.length();
        for (int i = 0; i < different; ++i) {
            formateHierarchyCode.append("0");
        }
        formateHierarchyCode.append(codeString);
        return formateHierarchyCode.toString();
    }
}

