/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.app.mrp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.master.material.IsolatedRuleEnum;
import com.kingdee.eas.basedata.master.material.MaterialLeadTimeTypeEnum;
import com.kingdee.eas.basedata.master.material.MaterialProvideTypeEnum;
import com.kingdee.eas.mm.common.app.SQLUtils;
import com.kingdee.eas.mm.planning.MRPException;
import com.kingdee.eas.mm.planning.app.batchPolicy.BatchPolicy;
import com.kingdee.eas.mm.planning.app.batchPolicy.BatchPolicyVO;
import com.kingdee.eas.mm.planning.app.mrp.MRPCalcParam;
import com.kingdee.eas.mm.planning.app.mrp.MRPConstant;
import com.kingdee.eas.mm.planning.app.mrp.MRPSeqUtil;
import com.kingdee.eas.mm.planning.app.mrp.MRPUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class MRPMaterialDataInfo
extends BatchPolicyVO
implements Cloneable {
    private String ID;
    private String materialID;
    private String materialNumber;
    private String baseUnitID;
    private int baseQtyPrc;
    private String prodUnitID;
    private int prodQtyPrc;
    private BigDecimal convertRate;
    private int lowsetCode;
    private BigDecimal stockQty;
    private BigDecimal onHandQty;
    private BigDecimal qtyMax;
    private BigDecimal safeStockQty;
    private boolean isMergeSign;
    private BigDecimal yield;
    private String planStrategy;
    private int batchPolicy;
    private BigDecimal fixationBatchQty;
    private boolean isMaxBatchMethod;
    private BigDecimal maxBatchQty;
    private int inteval;
    private boolean isMinBatchMethod;
    private BigDecimal minBatchQty;
    private boolean isRoundUpMultiple;
    private BigDecimal roundUpMultipleQty;
    private boolean isBatchIncMethod;
    private BigDecimal batchIncQty;
    private BigDecimal qtyMinPackage;
    private int materialAttr;
    private int planningMode;
    private MaterialLeadTimeTypeEnum leadTimeType;
    private int receiveLeadTime;
    private int prodLeadTime;
    private int changeLeadTime;
    private int changeBatch;
    private int forwardProcessTime;
    private int backwardProcessTime;
    private int isNewOrder;
    private int hasExceptions;
    private int hasStockExp;
    private String bomID;
    private MaterialProvideTypeEnum supplyType = null;
    private String supplyStorageOrgUnitID = null;
    private String collabMaterialEntryID = null;
    private String productTranTypeID = null;
    private String manufactureDepartmentId = null;
    private String planner = null;
    private int substituteGroup = 0;
    private int calcSeq = 0;
    private String planOrgUnitId = null;
    private IsolatedRuleEnum isolatedRule;
    private Map stockQtyMap;
    private Map onHandQtyMap;
    private boolean isCanNotThrow = false;
    private ArrayList slistInfo = new ArrayList();
    private BatchPolicy iBatchPolicy = null;
    private String invDetailId;
    private boolean isSurplusDivert;
    private Map invDetailMap = new HashMap();

    public Object clone() {
        MRPMaterialDataInfo info = null;
        try {
            info = (MRPMaterialDataInfo)super.clone();
        }
        catch (CloneNotSupportedException e) {
            MRPUtil.logBegin(new Date(), e.toString());
        }
        return info;
    }

    public ArrayList getSlistInfo() {
        return this.slistInfo;
    }

    public void setSlistInfo(ArrayList slistInfo) {
        this.slistInfo = slistInfo;
    }

    public BigDecimal getQtyMinPackage() {
        return this.qtyMinPackage;
    }

    public void setQtyMinPackage(BigDecimal qtyMinPackage) {
        this.qtyMinPackage = qtyMinPackage;
    }

    public static MRPMaterialDataInfo readRow(MRPCalcParam runParam, IRowSet rs, Map materialInvSet) throws SQLException, MRPException, BOSException {
        MRPMaterialDataInfo vo = new MRPMaterialDataInfo();
        vo.setID(rs.getString("FID"));
        vo.setMaterialID(rs.getString("FMaterialID"));
        vo.setMaterialNumber(rs.getString("FMaterialNumber"));
        vo.setBaseUnitID(rs.getString("FBaseUnitID"));
        vo.setBaseQtyPrc(rs.getInt("FBaseQtyPrc"));
        vo.setProdUnitID(rs.getString("FProdUnitID"));
        vo.setProdQtyPrc(rs.getInt("FProdQtyPrc"));
        vo.setConvertRate(rs.getBigDecimal("FConvertRate"));
        vo.setLowsetCode(rs.getInt("FLowsetCode"));
        vo.setStockQty(rs.getBigDecimal("FOnHand"));
        vo.setOnHandQty(rs.getBigDecimal("FOnHand"));
        vo.setQtyMax(rs.getBigDecimal("FQtyMax"));
        vo.setSafeStockQty(rs.getBigDecimal("FSafeStock"));
        vo.setMergeSign(rs.getBoolean("FIsMergeSign"));
        vo.setYield(rs.getBigDecimal("FYield"));
        vo.setPlanStrategy(rs.getString("FPlanStrategy"));
        vo.setBatchPolicy(rs.getInt("FBatchPolicy"));
        vo.setFixationBatchQty(rs.getBigDecimal("FFixationBatchQty"));
        vo.setMinBatchQty(rs.getBigDecimal("FMinBatchQty"));
        vo.setRoundUpMultipleQty(rs.getBigDecimal("FRoundUpMultipleQty"));
        vo.setBatchIncQty(rs.getBigDecimal("FBatchIncQty"));
        vo.setMaterialAttr(rs.getInt("FMaterialAttr"));
        vo.setPlanningMode(rs.getInt("FPlanningMode"));
        vo.setReceiveLeadTime(rs.getInt("FRecevingLeadTime"));
        vo.setProdLeadTime(rs.getInt("FProduceLeadTime"));
        vo.setForwardProcessTime(rs.getInt("FForwardProcessTime"));
        vo.setBackwardProcessTime(rs.getInt("FBackwardProcessTime"));
        vo.setManufactureDepartmentId(rs.getString("FManufactureDepartment"));
        vo.setBomID(rs.getString("FBOMID"));
        vo.setYield(rs.getBigDecimal("FYield"));
        vo.setSupplyType(MaterialProvideTypeEnum.getEnum((int)rs.getInt("FSupplyType")));
        vo.setSupplyStorageOrgUnitID(rs.getString("FSupplyOrgUnitID"));
        vo.setQtyMinPackage(rs.getBigDecimal("FQtyMinPackage"));
        vo.setConvertRate(rs.getBigDecimal("FConvertRate"));
        vo.setCollabMaterialEntryID(rs.getString("FCollabMaterialEntryID"));
        vo.setProductTranTypeID(rs.getString("FProductTranTypeID"));
        vo.setLeadTimeType(MaterialLeadTimeTypeEnum.getEnum((int)rs.getInt("FLeadTimeType")));
        vo.setChangeLeadTime(rs.getInt("FChangeLeadTime"));
        vo.setChangeBatch(rs.getInt("FChangeBatch"));
        vo.setCanNotThrow(rs.getBoolean("FIsCanNotThrow"));
        if (materialInvSet != null) {
            vo.setInvDetailId((String)materialInvSet.get(rs.getString("FMaterialID")));
        }
        vo.setPartitionQty(rs.getInt("FPartitionQty"));
        vo.setMaxBatchQty(rs.getBigDecimal("FMaxBatchQty"));
        vo.setCycle(rs.getInt("FBatchCycle"));
        vo.setIsolatedRule(IsolatedRuleEnum.getEnum((String)rs.getString("FisolateRules")));
        vo.setSurplusDivert(rs.getBoolean("FIsSurplusDivert"));
        vo.setPlanner(rs.getString("FPlanner"));
        vo.setSubstituteGroup(rs.getInt("FSubstituteGroup"));
        vo.setCalcSeq(rs.getInt("FCalcSeq"));
        vo.setPlanOrgUnitId(rs.getString("FPlanOrgUnit"));
        MRPMaterialDataInfo.checkMaterialData(runParam.getCtx(), vo);
        return vo;
    }

    public static void checkMaterialData(Context ctx, MRPMaterialDataInfo vo) {
        StringBuffer err = null;
        if (vo.getPlanStrategy() == null) {
            if (err == null) {
                err = new StringBuffer();
            }
            err.append("Plan Strategy is null;");
        }
        if (vo.getYield() == null || vo.getYield().compareTo(MRPConstant.ZERO) == 0) {
            if (err == null) {
                err = new StringBuffer();
            }
            err.append("Yield is zero;");
        }
        if (err != null) {
            err.insert(0, ",data error: ");
            err.insert(0, vo.getMaterialNumber());
            err.insert(0, "material number ");
            MRPUtil.logBegin(new Date(), err.toString());
        }
    }

    public String getID() {
        return this.ID;
    }

    public void setID(String id) {
        this.ID = id;
    }

    public String getMaterialID() {
        return this.materialID;
    }

    public void setMaterialID(String materialID) {
        this.materialID = materialID;
    }

    @Override
    public String getMaterialNumber() {
        return this.materialNumber;
    }

    @Override
    public void setMaterialNumber(String materialNumber) {
        this.materialNumber = materialNumber;
    }

    public String getBaseUnitID() {
        return this.baseUnitID;
    }

    public void setBaseUnitID(String baseUnitID) {
        this.baseUnitID = baseUnitID;
    }

    public int getBaseQtyPrc() {
        return this.baseQtyPrc;
    }

    public void setBaseQtyPrc(int baseQtyPrc) {
        this.baseQtyPrc = baseQtyPrc;
    }

    public String getProdUnitID() {
        return this.prodUnitID;
    }

    public void setProdUnitID(String prodUnitID) {
        this.prodUnitID = prodUnitID;
    }

    public int getProdQtyPrc() {
        return this.prodQtyPrc;
    }

    public void setProdQtyPrc(int prodQtyPrc) {
        this.prodQtyPrc = prodQtyPrc;
    }

    public BigDecimal getConvertRate() {
        return this.convertRate;
    }

    public void setConvertRate(BigDecimal convertRate) {
        this.convertRate = convertRate;
    }

    public int getLowsetCode() {
        return this.lowsetCode;
    }

    public void setLowsetCode(int lowsetCode) {
        this.lowsetCode = lowsetCode;
    }

    public BigDecimal getStockQty(String projectNumber, String trackNumber) {
        if ("qAXoUB/uBg/gQKjAYj0WQ9g0uEU=".equals(this.getPlanStrategy()) || "qAXoUB/tBg/gQKjAYj0WQ9g0uEU=".equals(this.getPlanStrategy()) || "qAYfaBzTrmLgQKjAYj0f3dg0uEU=".equals(this.getPlanStrategy())) {
            BigDecimal qty = (BigDecimal)this.getStockQtyMap().get(projectNumber + trackNumber);
            return qty != null ? qty : MRPConstant.ZERO;
        }
        if (this.stockQty == null) {
            this.stockQty = MRPConstant.ZERO;
        }
        return this.stockQty;
    }

    public void setStockQty(BigDecimal stockQty) {
        this.stockQty = stockQty;
    }

    public void setOnHandQty(BigDecimal onHandQty) {
        this.onHandQty = onHandQty;
    }

    public BigDecimal getOnHandQty(String projectNumber, String trackNumber) {
        if ("qAXoUB/uBg/gQKjAYj0WQ9g0uEU=".equals(this.getPlanStrategy()) || "qAXoUB/tBg/gQKjAYj0WQ9g0uEU=".equals(this.getPlanStrategy()) || "qAYfaBzTrmLgQKjAYj0f3dg0uEU=".equals(this.getPlanStrategy())) {
            BigDecimal qty = (BigDecimal)this.getOnHandQtyMap().get(projectNumber + trackNumber);
            return qty != null ? qty : MRPConstant.ZERO;
        }
        if (this.onHandQty == null) {
            this.onHandQty = MRPConstant.ZERO;
        }
        return this.onHandQty;
    }

    public void setOnHandQty(BigDecimal onHandQty, String projectNumber, String trackNumber) {
        if ("qAXoUB/uBg/gQKjAYj0WQ9g0uEU=".equals(this.getPlanStrategy()) || "qAXoUB/tBg/gQKjAYj0WQ9g0uEU=".equals(this.getPlanStrategy()) || "qAYfaBzTrmLgQKjAYj0f3dg0uEU=".equals(this.getPlanStrategy())) {
            this.getOnHandQtyMap().put(projectNumber + trackNumber, onHandQty);
        } else {
            this.onHandQty = onHandQty;
        }
    }

    public BigDecimal getSafeStockQty() {
        return this.safeStockQty;
    }

    public void setSafeStockQty(BigDecimal safeStockQty) {
        this.safeStockQty = safeStockQty;
    }

    public boolean isMergeSign() {
        return this.isMergeSign;
    }

    public void setMergeSign(boolean isMergeSign) {
        this.isMergeSign = isMergeSign;
    }

    @Override
    public BigDecimal getYield() {
        return this.yield;
    }

    public void setYield(BigDecimal yield) {
        this.yield = yield;
    }

    public String getPlanStrategy() {
        return this.planStrategy;
    }

    public void setPlanStrategy(String planStrategy) {
        this.planStrategy = planStrategy;
    }

    @Override
    public int getBatchPolicy() {
        return this.batchPolicy;
    }

    @Override
    public void setBatchPolicy(int batchPolicy) {
        this.batchPolicy = batchPolicy;
    }

    @Override
    public BigDecimal getFixationBatchQty() {
        return this.fixationBatchQty;
    }

    @Override
    public void setFixationBatchQty(BigDecimal fixationBatchQty) {
        this.fixationBatchQty = fixationBatchQty;
    }

    public boolean isMaxBatchMethod() {
        return this.isMaxBatchMethod;
    }

    public void setMaxBatchMethod(boolean isMaxBatchMethod) {
        this.isMaxBatchMethod = isMaxBatchMethod;
    }

    @Override
    public BigDecimal getMaxBatchQty() {
        return this.maxBatchQty;
    }

    @Override
    public void setMaxBatchQty(BigDecimal maxBatchQty) {
        this.maxBatchQty = maxBatchQty;
    }

    public int getInteval() {
        return this.inteval;
    }

    public void setInteval(int inteval) {
        this.inteval = inteval;
    }

    public boolean isMinBatchMethod() {
        return this.isMinBatchMethod;
    }

    public void setMinBatchMethod(boolean isMinBatchMethod) {
        this.isMinBatchMethod = isMinBatchMethod;
    }

    @Override
    public BigDecimal getMinBatchQty() {
        return this.minBatchQty;
    }

    @Override
    public void setMinBatchQty(BigDecimal minBatchQty) {
        this.minBatchQty = minBatchQty;
    }

    public boolean getIsRoundUpMultiple() {
        return this.isRoundUpMultiple;
    }

    public void setRoundUpMultiple(boolean isRoundUpMultiple) {
        this.isRoundUpMultiple = isRoundUpMultiple;
    }

    @Override
    public BigDecimal getRoundUpMultipleQty() {
        return this.roundUpMultipleQty;
    }

    @Override
    public void setRoundUpMultipleQty(BigDecimal roundUpMultipleQty) {
        this.roundUpMultipleQty = roundUpMultipleQty;
    }

    public boolean isBatchIncMethod() {
        return this.isBatchIncMethod;
    }

    public void setBatchIncMethod(boolean isBatchIncMethod) {
        this.isBatchIncMethod = isBatchIncMethod;
    }

    @Override
    public BigDecimal getBatchIncQty() {
        return this.batchIncQty;
    }

    @Override
    public void setBatchIncQty(BigDecimal batchIncQty) {
        this.batchIncQty = batchIncQty;
    }

    public int getMaterialAttr() {
        return this.materialAttr;
    }

    public void setMaterialAttr(int materialAttr) {
        this.materialAttr = materialAttr;
    }

    public int getForwardProcessTime() {
        return this.forwardProcessTime;
    }

    public int getBackwardProcessTime() {
        return this.backwardProcessTime;
    }

    public void setForwardProcessTime(int forwardProcessTime) {
        this.forwardProcessTime = forwardProcessTime;
    }

    public void setBackwardProcessTime(int backwardProcessTime) {
        this.backwardProcessTime = backwardProcessTime;
    }

    public int getReceiveLeadTime() {
        return this.receiveLeadTime;
    }

    public int getProdLeadTime() {
        return this.prodLeadTime;
    }

    public void setReceiveLeadTime(int receiveLeadTime) {
        this.receiveLeadTime = receiveLeadTime;
    }

    public void setProdLeadTime(int prodLeadTime) {
        this.prodLeadTime = prodLeadTime;
    }

    public BigDecimal getQtyMax() {
        return this.qtyMax;
    }

    public void setQtyMax(BigDecimal qtyMax) {
        this.qtyMax = qtyMax;
    }

    public String getBomID() {
        return this.bomID;
    }

    public void setBomID(String bomID) {
        this.bomID = bomID;
    }

    public int getPlanningMode() {
        return this.planningMode;
    }

    public void setPlanningMode(int planningMode) {
        this.planningMode = planningMode;
    }

    public MaterialProvideTypeEnum getSupplyType() {
        return this.supplyType;
    }

    public void setSupplyType(MaterialProvideTypeEnum supplyType) {
        this.supplyType = supplyType;
    }

    public String getSupplyStorageOrgUnitID() {
        return this.supplyStorageOrgUnitID;
    }

    public void setSupplyStorageOrgUnitID(String supplyStorageOrgUnitID) {
        this.supplyStorageOrgUnitID = supplyStorageOrgUnitID;
    }

    public int getIsNewOrder() {
        return this.isNewOrder;
    }

    public void setIsNewOrder(int isNewOrder) {
        this.isNewOrder = isNewOrder;
    }

    public int getHasExceptions() {
        return this.hasExceptions;
    }

    public void setHasExceptions(int hasExceptions) {
        this.hasExceptions = hasExceptions;
    }

    public int getHasStockExp() {
        return this.hasStockExp;
    }

    public void setHasStockExp(int hasStockExp) {
        if (this.hasStockExp == 0) {
            this.hasStockExp = hasStockExp;
        }
    }

    public String getCollabMaterialEntryID() {
        return this.collabMaterialEntryID;
    }

    public void setCollabMaterialEntryID(String collabMaterialEntryID) {
        this.collabMaterialEntryID = collabMaterialEntryID;
    }

    public String getProductTranTypeID() {
        return this.productTranTypeID;
    }

    public void setProductTranTypeID(String productTranTypeID) {
        this.productTranTypeID = productTranTypeID;
    }

    public IsolatedRuleEnum getIsolatedRule() {
        return this.isolatedRule;
    }

    public void setIsolatedRule(IsolatedRuleEnum isolatedRule) {
        this.isolatedRule = isolatedRule;
    }

    public Map getOnHandQtyMap() {
        if (this.onHandQtyMap == null) {
            this.onHandQtyMap = new HashMap();
        }
        return this.onHandQtyMap;
    }

    public void setOnHandQtyMap(Map onHandQtyMap) {
        this.onHandQtyMap = onHandQtyMap;
    }

    public Map getStockQtyMap() {
        if (this.stockQtyMap == null) {
            this.stockQtyMap = new HashMap();
        }
        return this.stockQtyMap;
    }

    public void setStockQtyMap(Map stockQtyMap) {
        this.stockQtyMap = stockQtyMap;
    }

    public int getChangeLeadTime() {
        return this.changeLeadTime;
    }

    public void setChangeLeadTime(int changeLeadTime) {
        this.changeLeadTime = changeLeadTime;
    }

    public int getChangeBatch() {
        return this.changeBatch;
    }

    public void setChangeBatch(int changeBatch) {
        this.changeBatch = changeBatch;
    }

    public MaterialLeadTimeTypeEnum getLeadTimeType() {
        return this.leadTimeType;
    }

    public void setLeadTimeType(MaterialLeadTimeTypeEnum leadTimeType) {
        this.leadTimeType = leadTimeType;
    }

    public boolean isCanNotThrow() {
        return this.isCanNotThrow;
    }

    public void setCanNotThrow(boolean isCanNotThrow) {
        this.isCanNotThrow = isCanNotThrow;
    }

    public BatchPolicy getiBatchPolicy() {
        return this.iBatchPolicy;
    }

    public void setiBatchPolicy(BatchPolicy iBatchPolicy) {
        this.iBatchPolicy = iBatchPolicy;
    }

    public String getInvDetailId(MRPCalcParam runParam, String projectNumber, String trackNumber) throws MRPException, BOSException {
        String detailId = null;
        if (("qAXoUB/uBg/gQKjAYj0WQ9g0uEU=".equals(this.getPlanStrategy()) || "qAXoUB/tBg/gQKjAYj0WQ9g0uEU=".equals(this.getPlanStrategy()) || "qAYfaBzTrmLgQKjAYj0f3dg0uEU=".equals(this.getPlanStrategy())) && (detailId = (String)this.invDetailMap.get(projectNumber + projectNumber)) == null) {
            detailId = this.getMaterialInvDetail(runParam, projectNumber, trackNumber);
            this.invDetailMap.put(projectNumber + projectNumber, detailId);
        }
        if (detailId == null) {
            detailId = this.invDetailId;
        }
        return detailId;
    }

    public void setInvDetailId(String invDetailId) {
        this.invDetailId = invDetailId;
    }

    private String getMaterialInvDetail(MRPCalcParam runParam, String projectNumber, String trackNumber) throws BOSException, MRPException {
        StringBuffer sql = new StringBuffer();
        sql.append("select t1.FID from ").append(runParam.getMrpCalcDetailTableName()).append(" t1 where t1.fmaterialid = '").append(this.materialID).append("' ").append("and t1.FProjectNumber='").append(projectNumber).append("' ").append("and t1.FTrackNumber='").append(trackNumber).append("' ").append("and t1.FPeriod=").append(runParam.getPlanDate().getPeriod()).append(" ").append("and t1.FMrpSeq='").append(MRPSeqUtil.INV_SEQ).append("' ");
        IRowSet rs = SQLUtils.executeQuery((Context)runParam.getCtx(), (String)sql.toString());
        String id = null;
        try {
            if (rs.next()) {
                id = rs.getString("FID");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return id;
    }

    public boolean isSurplusDivert() {
        return this.isSurplusDivert;
    }

    public void setSurplusDivert(boolean isSurplusDivert) {
        this.isSurplusDivert = isSurplusDivert;
    }

    public String getManufactureDepartmentId() {
        return this.manufactureDepartmentId;
    }

    public void setManufactureDepartmentId(String mnufactureDepartmentId) {
        this.manufactureDepartmentId = mnufactureDepartmentId;
    }

    public String getPlanner() {
        return this.planner;
    }

    public void setPlanner(String planner) {
        this.planner = planner;
    }

    public int getSubstituteGroup() {
        return this.substituteGroup;
    }

    public void setSubstituteGroup(int substituteGroup) {
        this.substituteGroup = substituteGroup;
    }

    public int getCalcSeq() {
        return this.calcSeq;
    }

    public void setCalcSeq(int calcSeq) {
        this.calcSeq = calcSeq;
    }

    public String getPlanOrgUnitId() {
        return this.planOrgUnitId;
    }

    public void setPlanOrgUnitId(String planOrgUnitId) {
        this.planOrgUnitId = planOrgUnitId;
    }
}

