/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.app.mrp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.common.app.SQLUtils;
import com.kingdee.eas.mm.common.util.MMUtils;
import com.kingdee.eas.mm.planning.MRPException;
import com.kingdee.eas.mm.planning.MrpRunEnum;
import com.kingdee.eas.mm.planning.app.mrp.MRPCalcParam;
import com.kingdee.eas.mm.planning.app.mrp.MRPMaterialDataInfo;
import com.kingdee.eas.mm.planning.app.mrp.MRPMaterialStatisticsInfo;
import com.kingdee.eas.mm.planning.app.mrp.MRPPlanStrategyUtil;
import com.kingdee.eas.mm.planning.app.mrp.MRPSeqUtil;
import com.kingdee.eas.mm.planning.app.mrp.MRPStep;
import com.kingdee.eas.mm.planning.app.mrp.MRPUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class MRPMaterialTableDAO {
    protected static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.planning.app.mrp.MRPMaterialTableDAO");

    public MRPMaterialTableDAO() {
        if (MRPStep.isMoreInfo.booleanValue()) {
            logger.setLevel(Level.INFO);
        } else {
            logger.setLevel(Level.ERROR);
        }
    }

    public static int getLevelMaterialCount(MRPCalcParam runParam) throws EASBizException, BOSException {
        return MRPMaterialTableDAO.getLevelMaterialCount(runParam, runParam.getLevel());
    }

    public static int getLevelMaterialCount(MRPCalcParam runParam, int level) throws EASBizException, BOSException {
        String sql = "select count(*) materialcount from " + runParam.getMaterialTableName() + " where FRunLogID = ? and FLowsetCode = ? ";
        IRowSet rs = SQLUtils.executeQuery((Context)runParam.getCtx(), (String)sql, (Object[])new Object[]{runParam.getRunLogID(), new Integer(level)});
        try {
            if (rs.next() && rs.getObject("materialcount") != null) {
                return rs.getInt("materialcount");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return 0;
    }

    public static List getAllLevelCode(MRPCalcParam runParam) throws EASBizException, BOSException {
        ArrayList<Integer> lowerLevelCodeLst = new ArrayList<Integer>(10);
        String sql = "select distinct FLowsetCode from " + runParam.getMaterialTableName() + " where FRunLogID = ? order by FLowsetCode asc";
        IRowSet rs = SQLUtils.executeQuery((Context)runParam.getCtx(), (String)sql, (Object[])new Object[]{runParam.getRunLogID()});
        try {
            while (rs.next()) {
                lowerLevelCodeLst.add(new Integer(rs.getInt(1)));
                if (!runParam.getPlanType().equals((Object)MrpRunEnum.MPS_GROSS)) continue;
                return lowerLevelCodeLst;
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return lowerLevelCodeLst;
    }

    public static int getNextLevelCode(MRPCalcParam runParam, int lastLevelCode) throws BOSException, MRPException {
        int levelCode = lastLevelCode;
        String sql = "select distinct FLowsetCode from " + runParam.getMaterialTableName() + " where FLowsetCode > ? order by FLowsetCode asc";
        IRowSet rs = SQLUtils.executeQuery((Context)runParam.getCtx(), (String)sql, (Object[])new Object[]{new Integer(lastLevelCode)});
        try {
            levelCode = rs.next() ? rs.getInt(1) : -1;
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return levelCode;
    }

    public static List getLevelMaterialIDs(MRPCalcParam runParam, boolean isMaterialReplace) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select FMaterialID ,FSubstituteGroup, FCalcSeq from  ").append(runParam.getMaterialTableName()).append(" where FRunLogID = ? and FLowsetCode = ?");
        if (isMaterialReplace) {
            sql.append(" and FCalcSeq>=0 and FSubstituteGroup>0 ");
        } else {
            sql.append(" and FCalcSeq=0 and FSubstituteGroup=0 ");
        }
        sql.append(" and FIsSurplusDivert = 0 ");
        sql.append(" order by FCalcSeq ,FSubstituteGroup ,FMaterialNumber");
        ArrayList<Object> idList = new ArrayList<Object>();
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)runParam.getCtx());
            ps = conn.prepareStatement(sql.toString());
            ps.setString(1, runParam.getRunLogID());
            ps.setInt(2, runParam.getLevel());
            rs = ps.executeQuery();
            boolean substituteGroup = false;
            int calcSeq = -1;
            ArrayList<String> subidList = new ArrayList<String>();
            boolean hasData = false;
            while (rs.next()) {
                if (isMaterialReplace) {
                    hasData = true;
                    if (calcSeq != rs.getInt("FCalcSeq")) {
                        subidList = new ArrayList();
                        subidList.add(rs.getString("FMaterialID"));
                        idList.add(subidList);
                        calcSeq = rs.getInt("FCalcSeq");
                        continue;
                    }
                    subidList.add(rs.getString("FMaterialID"));
                    calcSeq = rs.getInt("FCalcSeq");
                    continue;
                }
                idList.add(rs.getString("FMaterialID"));
            }
        }
        catch (SQLException exc) {
            try {
                throw new BOSException("Sql execute exception : " + sql, (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
        return idList;
    }

    public static List getSurplusDivertMaterialIDs(MRPCalcParam runParam) throws BOSException, MRPException {
        StringBuffer sql = new StringBuffer();
        sql.append("select FMaterialID from  ").append(runParam.getMaterialTableName()).append(" where FRunLogID = ? and FLowsetCode = ?");
        sql.append(" and FIsSurplusDivert = 1 ");
        sql.append(" order by FCalcSeq ,FMaterialNumber");
        ArrayList<String> idList = new ArrayList<String>();
        try {
            IRowSet rs = SQLUtils.executeQuery((Context)runParam.getCtx(), (String)sql.toString(), (Object[])new Object[]{runParam.getRunLogID(), new Integer(runParam.getLevel())});
            while (rs.next()) {
                idList.add(rs.getString("FMaterialID"));
            }
        }
        catch (SQLException exc) {
            throw new BOSException("Sql execute exception : " + sql, (Throwable)exc);
        }
        return idList;
    }

    public static MRPMaterialDataInfo[] getLevelMaterials(MRPCalcParam runParam, List idList) throws EASBizException, BOSException {
        if (idList == null || idList.size() == 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer("select * from ").append(runParam.getMaterialTableName()).append(" where ");
        for (int i = 0; i < idList.size(); ++i) {
            sb.append(" FID = ?");
            if (i == idList.size() - 1) continue;
            sb.append(" OR ");
        }
        Map materialInvSet = MRPMaterialTableDAO.getMaterialInvDetail(runParam, idList);
        IRowSet rs = SQLUtils.executeQuery((Context)runParam.getCtx(), (String)sb.toString(), (Object[])idList.toArray());
        MRPMaterialDataInfo[] materialDatas = new MRPMaterialDataInfo[rs.size()];
        int i = 0;
        try {
            while (rs.next()) {
                materialDatas[i++] = MRPMaterialDataInfo.readRow(runParam, rs, materialInvSet);
            }
            rs = null;
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return materialDatas;
    }

    public static HashMap getLevelMaterialInfo(MRPCalcParam runParam, List idList) throws EASBizException, BOSException {
        if (idList == null || idList.size() == 0) {
            return null;
        }
        HashMap<String, MRPMaterialDataInfo> materialDatas = new HashMap<String, MRPMaterialDataInfo>();
        try {
            StringBuffer sb = new StringBuffer("select * from ").append(runParam.getMaterialTableName()).append(" where ");
            for (int i = 0; i < idList.size(); ++i) {
                sb.append(" FMaterialID = ?");
                if (i == idList.size() - 1) continue;
                sb.append(" OR ");
            }
            Map materialInvSet = MRPMaterialTableDAO.getMaterialInvDetail(runParam, idList);
            IRowSet rs = SQLUtils.executeQuery((Context)runParam.getCtx(), (String)sb.toString(), (Object[])idList.toArray());
            MRPMaterialDataInfo dataInfo = null;
            while (rs.next()) {
                dataInfo = MRPMaterialDataInfo.readRow(runParam, rs, materialInvSet);
                materialDatas.put(dataInfo.getMaterialID(), dataInfo);
            }
            rs = null;
            if (!MMUtils.isEmptyString((String)runParam.getInvDetailTableName())) {
                sb.setLength(0);
                sb.append("select * from ").append(runParam.getInvDetailTableName()).append(" where ");
                for (int i = 0; i < idList.size(); ++i) {
                    sb.append(" FMaterialID = ?");
                    if (i == idList.size() - 1) continue;
                    sb.append(" OR ");
                }
                sb.append(" order by FMaterialID");
                rs = SQLUtils.executeQuery((Context)runParam.getCtx(), (String)sb.toString(), (Object[])idList.toArray());
                dataInfo = null;
                while (rs.next()) {
                    dataInfo = (MRPMaterialDataInfo)materialDatas.get(rs.getString("FMaterialID"));
                    if (dataInfo == null) continue;
                    String key = rs.getString("FProjectNumber") + rs.getString("FTrackNumber");
                    dataInfo.getOnHandQtyMap().put(key, rs.getBigDecimal("FBaseQty"));
                    dataInfo.getStockQtyMap().put(key, rs.getBigDecimal("FBaseQty"));
                }
                rs = null;
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return materialDatas;
    }

    public static MRPMaterialDataInfo[] getNoDataMaterials(MRPCalcParam runParam, List idList) throws EASBizException, BOSException {
        StringBuffer sb = new StringBuffer("select m.* from ").append(runParam.getMaterialTableName()).append(" m ").append("left join ").append(runParam.getStatisticsTable()).append(" s").append(" on m.FMaterialid = s.FMaterialid  ").append(" where s.FMaterialid is null  and ( ");
        for (int i = 0; i < idList.size(); ++i) {
            sb.append(" m.FMaterialID = ?");
            if (i == idList.size() - 1) continue;
            sb.append(" OR ");
        }
        sb.append(" )");
        Map materialInvSet = MRPMaterialTableDAO.getMaterialInvDetail(runParam, idList);
        IRowSet rs = SQLUtils.executeQuery((Context)runParam.getCtx(), (String)sb.toString(), (Object[])idList.toArray());
        MRPMaterialDataInfo[] materialDatas = new MRPMaterialDataInfo[rs.size()];
        int index = 0;
        try {
            while (rs.next()) {
                materialDatas[index++] = MRPMaterialDataInfo.readRow(runParam, rs, materialInvSet);
            }
            rs = null;
            if (!MMUtils.isEmptyString((String)runParam.getInvDetailTableName())) {
                sb.setLength(0);
                sb.append("select m.* from ").append(runParam.getInvDetailTableName()).append(" m ").append("left join ").append(runParam.getStatisticsTable()).append(" s").append(" on m.FMaterialid = s.FMaterialid  ").append(" where s.FMaterialid is null  and ( ");
                for (int i = 0; i < idList.size(); ++i) {
                    sb.append(" m.FMaterialID = ?");
                    if (i == idList.size() - 1) continue;
                    sb.append(" OR ");
                }
                sb.append(" )");
                rs = SQLUtils.executeQuery((Context)runParam.getCtx(), (String)sb.toString(), (Object[])idList.toArray());
                while (rs.next()) {
                    for (int i = 0; i < materialDatas.length; ++i) {
                        if (!materialDatas[i].getMaterialID().equals(rs.getString("FMaterialID"))) continue;
                        String key = rs.getString("FProjectNumber") + rs.getString("FTrackNumber");
                        materialDatas[i].getOnHandQtyMap().put(key, rs.getBigDecimal("FBaseQty"));
                        materialDatas[i].getStockQtyMap().put(key, rs.getBigDecimal("FBaseQty"));
                    }
                }
                rs = null;
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return materialDatas;
    }

    public static Map getMaterialInvDetail(MRPCalcParam runParam, List idList) throws BOSException, MRPException {
        if (idList == null || idList.size() <= 0) {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select t1.FMaterialID,t1.FID from ").append(runParam.getMrpCalcDetailTableName()).append(" t1 where t1.FProjectNumber='").append(runParam.getProjectNumber()).append("' ").append("and t1.FTrackNumber='").append(runParam.getTrackNumber()).append("' ").append("and t1.FPeriod='").append(runParam.getPlanDate().getPeriod()).append("' ").append("and t1.FMrpSeq='").append(MRPSeqUtil.INV_SEQ).append("' ").append("and (");
        for (int i = 0; i < idList.size(); ++i) {
            sql.append(" t1.FMaterialID = ?");
            if (i == idList.size() - 1) continue;
            sql.append(" OR ");
        }
        sql.append(" )");
        IRowSet rs = SQLUtils.executeQuery((Context)runParam.getCtx(), (String)sql.toString(), (Object[])idList.toArray());
        String detialId = null;
        String materialId = null;
        HashMap<String, String> materialInvSet = new HashMap<String, String>();
        try {
            while (rs.next()) {
                materialId = rs.getString("FMaterialID");
                detialId = rs.getString("FID");
                materialInvSet.put(materialId, detialId);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return materialInvSet;
    }

    public static List getNoDataProjectNumberAndTrackNumber(MRPCalcParam runParam, List idList) throws EASBizException, BOSException {
        ArrayList<MRPMaterialStatisticsInfo> materialDatas = new ArrayList<MRPMaterialStatisticsInfo>();
        MRPMaterialStatisticsInfo statisticsInfo = null;
        try {
            StringBuffer sb = new StringBuffer();
            sb.append("select m.FID FID, m.FMaterialId FMaterialID from  ").append(runParam.getMaterialTableName()).append(" m ").append("left join ").append(runParam.getStatisticsTable()).append(" s").append(" on m.FMaterialid = s.FMaterialid  ").append(" where s.FMaterialid is null  and ( ");
            for (int i = 0; i < idList.size(); ++i) {
                sb.append(" m.FMaterialID = ?");
                if (i == idList.size() - 1) continue;
                sb.append(" OR ");
            }
            sb.append(" ) and (m.FPlanStrategy in (").append(MRPPlanStrategyUtil.getInvPlanStrategyStr(false)).append(")").append(" or m.FIsSurplusDivert = 1)");
            IRowSet rs = SQLUtils.executeQuery((Context)runParam.getCtx(), (String)sb.toString(), (Object[])idList.toArray());
            while (rs.next()) {
                statisticsInfo = new MRPMaterialStatisticsInfo();
                statisticsInfo.setId(rs.getString("FID"));
                statisticsInfo.setMaterialID(rs.getString("FmaterialId"));
                statisticsInfo.setProjectNumber(runParam.getProjectNumber());
                statisticsInfo.setTrackNumber(runParam.getTrackNumber());
                statisticsInfo.setProjectId(runParam.getProjectID());
                statisticsInfo.setTrackNumberId(runParam.getTrackID());
                materialDatas.add(statisticsInfo);
            }
            if (!MMUtils.isEmptyString((String)runParam.getInvDetailTableName())) {
                sb.setLength(0);
                sb.append("select m.FID FID, m.FMaterialId FMaterialID, inv.FProjectNumber FProjectNumber, ").append("inv.FTrackNumber FtrackNumber, inv.FProjectID FProjectID, inv.FTrackID FTrackID  from  ").append(runParam.getMaterialTableName()).append(" m ").append("left outer join ").append(runParam.getInvDetailTableName()).append(" inv ").append("on m.FMaterialId=inv.FMaterialId ").append("left join ").append(runParam.getStatisticsTable()).append(" s").append(" on m.FMaterialid = s.FMaterialid ").append(" and s.FProjectNumber=inv.FProjectNumber ").append(" and s.FTrackNumber=inv.FTrackNumber ").append(" where s.FMaterialid is null  and ( ");
                for (int i = 0; i < idList.size(); ++i) {
                    sb.append(" m.FMaterialID = ?");
                    if (i == idList.size() - 1) continue;
                    sb.append(" OR ");
                }
                sb.append(" ) and m.FPlanStrategy in (").append(MRPPlanStrategyUtil.getInvPlanStrategyStr(true)).append(")").append(" and m.FIsSurplusDivert = 0 ");
                rs = SQLUtils.executeQuery((Context)runParam.getCtx(), (String)sb.toString(), (Object[])idList.toArray());
                while (rs.next()) {
                    statisticsInfo = new MRPMaterialStatisticsInfo();
                    statisticsInfo.setId(rs.getString("FID"));
                    statisticsInfo.setMaterialID(rs.getString("FMaterialId"));
                    statisticsInfo.setProjectNumber(rs.getString("FProjectNumber"));
                    statisticsInfo.setTrackNumber(rs.getString("FTrackNumber"));
                    statisticsInfo.setProjectId(rs.getString("FProjectID"));
                    statisticsInfo.setTrackNumberId(rs.getString("FTrackID"));
                    materialDatas.add(statisticsInfo);
                }
                rs = null;
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return materialDatas;
    }

    public static void getOneLevelMaterials(MRPCalcParam runParam, String tempTable) throws BOSException, MRPException {
        StringBuffer sql_getAllMaterials = new StringBuffer();
        String strOrgUnitid = runParam.getRunLogInfo().getStorageOrgUnit().getId().toString();
        String strPlanVersionID = runParam.getPlanVersionID();
        String strRunLogID = runParam.getRunLogInfo().getId().toString();
        String strPlanningMode = " (mp.FPlanningMode=2 or mp.FPlanningMode=3) ";
        sql_getAllMaterials.append("insert into ").append(runParam.getMaterialTableName()).append(" ( ").append("\r\n").append("FID,").append("FPlanVersionID,").append("FRunLogID,").append("FMaterialID,").append("FMaterialNumber,").append("FBaseUnitID,").append("FBaseQtyPrc,").append("FProdUnitID,").append("FProdQtyPrc,").append("FConvertRate,").append("FPlanner,").append("FLowsetCode,").append("FSafeStock,").append("FQtyMax,").append("FIsMergeSign,").append("FYield,").append("FPlanStrategy,").append("FBatchPolicy,").append("FFixationBatchQty,").append("FMinBatchQty,").append("FRoundUpMultipleQty,").append("FBatchIncQty,").append("FMaterialAttr,").append("FPlanningMode,").append("FRecevingLeadTime,").append("FProduceLeadTime,").append("FForwardProcessTime,").append("FBackwardProcessTime,").append("FSupplyType,").append("FSupplyOrgUnitID,").append("FQtyMinPackage,").append("FManufactureDepartment ,").append("FRequirementUniteRuleID , ").append("FProductTranTypeID,").append("FLeadTimeType,").append("FChangeLeadTime,").append("FChangeBatch,").append("FIsCanNotThrow,").append("FPartitionQty,").append("FMaxBatchQty,").append("FBatchCycle,").append("FisolateRules,").append("FIsSurplusDivert,").append("FisComReqConsume,").append("FPlanOrgUnit").append(")").append("\r\n").append(" select ").append("newbosid('").append(MRPUtil.getBosType()).append("'),").append("\r\n").append("'").append(strPlanVersionID).append("',").append("\r\n").append("'").append(strRunLogID).append("',").append("\r\n").append("m.FID,").append("\r\n").append("m.FNumber,").append("m.FBaseUnit,").append("u1.FQtyPrecision,").append("mp.FProductUnitID,").append("u3.FQTYPRECISION,").append("u3.FBASECONVSRATE,").append("mp.FPlanner,").append("lc.FLowCode,");
        if (runParam.getRunLogInfo().getRunName().equals((Object)MrpRunEnum.MPS_GROSS)) {
            sql_getAllMaterials.append("0,").append("0,");
        } else {
            sql_getAllMaterials.append("round(decimal(isnull(mi.FQtySafety,0) * u2.FBASECONVSRATE,21,8),u1.FQTYPRECISION),").append("round(decimal(isnull(mi.FQtyMax,-1) * u2.FBASECONVSRATE,21,8),u1.FQTYPRECISION),");
        }
        sql_getAllMaterials.append("mp.FIsMergeSign,").append("100,").append("mp.FManufactureStrategyID,").append("mp.FBatchPolicy,").append("round(decimal(isnull(mp.FFixationBatchQty,0) * u3.FBASECONVSRATE,21,8),u1.FQTYPRECISION),").append("round(decimal(isnull(mp.FMinBatchQty,0) * u3.FBASECONVSRATE,21,8),u1.FQTYPRECISION),").append("round(decimal(isnull(mp.FRoundUpMultipleQty,0)*u3.FBASECONVSRATE ,21,8), u1.FQTYPRECISION),").append("round(decimal(isnull(mp.FBatchIncQty,0) * u3.FBASECONVSRATE,21,8),u1.FQTYPRECISION),").append("mp.FMaterialAttr,").append("mp.FPlanningMode,").append("mp.FRecevingLeadTime,").append("mp.FProduceLeadTime,").append("mp.FForwardProcessTime,").append("mp.FBackwardProcessTime,").append("mp.FProvideType,").append("mp.FSupplyOrgUnit ,").append("mi.FQtyMinPackage ,").append("mp.FdutyDepartment, ").append("mp.FReqUniteRuleID ,").append("case when mp.FMaterialAttr = 10030 then pt.FID else null end, ").append("mp.FLeadTimeType,").append("isnull(mp.FChangeLeadTime,0),").append("isnull(mp.FChangeBatch,0),").append("mp.FIsPlanNoRelease,").append("case when mp.FPartitionType = 10 then mp.FPartitionDays else 0 - mp.FPartitionDays end,").append("round(decimal(isnull(mp.FMaxBatchQty,0) * u3.FBASECONVSRATE,21,8),u1.FQTYPRECISION),").append("mp.FBatchCycle,").append("mp.FISOLATEDRULE,").append(MRPMaterialTableDAO.getSurplusDivertJudgeStr(runParam)).append("mp.FisComReqConsume, ").append("mp.FPlanOrgID ").append(" from t_bd_material m ").append("\r\n");
        if (tempTable.equalsIgnoreCase(runParam.getMrpCalcDetailTableName())) {
            sql_getAllMaterials.append(" inner join ( select distinct FMaterialID  as  FMaterialID  from ").append(tempTable).append(" ) tm on tm.FMaterialID =  m.fid   ");
        } else {
            sql_getAllMaterials.append(" inner join ( select distinct FChildMaterialID  as  FMaterialID  from ").append(tempTable).append(") tm on tm.FMaterialID =  m.fid");
        }
        sql_getAllMaterials.append(" inner join T_BD_MaterialPlan mp on m.FID=mp.FMaterialID and mp.FStatus<>2 and mp.FOrgUnit= '").append(strOrgUnitid).append("'").append("\r\n").append(" left outer join t_mm_producttransactiontype pt on mp.FProductTranType=pt.FID ").append(" and pt.FStatus=20 ").append("\r\n").append(" inner join T_BD_MaterialInventory mi on m.FID=mi.FMaterialID and mi.FStatus<>2 and mi.FOrgUnit='").append(strOrgUnitid).append("'").append("\r\n").append(" inner join T_BD_MultiMeasureUnit u1 on m.fid=u1.FMaterialID and m.FBaseUnit=u1.FMeasureUnitID ").append("\r\n").append(" inner join T_BD_MultiMeasureUnit u2 on mi.FMaterialID=u2.FMaterialID and mi.FUnitID=u2.FMeasureUnitID ").append("\r\n").append(" inner join T_BD_MultiMeasureUnit u3 on mp.FMaterialID=u3.FMaterialID and mp.FProductUnitID=u3.FMeasureUnitID ").append("\r\n").append(" inner join T_MM_LowLevelCode lc on m.FID=lc.FMaterialID and lc.FStorageOrgUnitID='").append(strOrgUnitid).append("'").append("\r\n").append(" left join ").append(runParam.getMaterialTableName()).append(" mm on tm.FMaterialID = mm.FMaterialID ");
        sql_getAllMaterials.append(" where ").append("\r\n").append(" m.FStatus<>2 ").append("\r\n");
        sql_getAllMaterials.append(" and (mp.FOutputType = 10710 or mp.FOutputType = 10740) ").append("\r\n");
        sql_getAllMaterials.append(" and " + strPlanningMode).append(" and mm.fid is null ").append("\r\n");
        int updateCount = MRPUtil.executeUpdate(runParam.getCtx(), sql_getAllMaterials.toString());
        logger.info((Object)("choosebillrun  subMaterial counts " + updateCount));
        runParam.setMaterialCount(runParam.getMaterialCount() + updateCount);
        MRPMaterialTableDAO.updateMaterialInfo(runParam);
    }

    private static StringBuffer getSurplusDivertJudgeStr(MRPCalcParam runParam) {
        StringBuffer str = new StringBuffer();
        if (runParam.getAdvanceType() == 0 && runParam.isCalNetting() && !runParam.getPlanType().equals((Object)MrpRunEnum.MPS_GROSS)) {
            str.append("mp.FIsMargin,");
        } else {
            str.append("0,");
        }
        return str;
    }

    public static void updateMaterialInfo(MRPCalcParam runParam) throws MRPException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("update ").append(runParam.getMaterialTableName()).append(" t \n");
        sql.append("set (FProductTranTypeID)=\n");
        sql.append("  (select distinct pt.FID from t_mm_producttransactiontype pt \n");
        sql.append("  where pt.FAdminDepartmentID=t.FManufactureDepartment and pt.FStorageOrgUnitId='");
        sql.append(runParam.getStorageOrgUnitID()).append("' and pt.FIsDefault=1 and pt.FBizTypeID='");
        sql.append("vGXRx5fFSsCYz9Zv7CzzgyQHQ1w=").append("') ");
        sql.append(" where t.FMaterialAttr=10030 and t.FProductTranTypeID is null ");
        MRPUtil.executeUpdate(runParam.getCtx(), sql.toString());
        sql.setLength(0);
        sql.append("update ").append(runParam.getMaterialTableName()).append(" t \n");
        sql.append("set (FProductTranTypeID)=\n");
        sql.append("  (select isnull((select distinct pt.FID from t_mm_producttransactiontype pt \n");
        sql.append("  where pt.FAdminDepartmentID is null and pt.FStorageOrgUnitId='");
        sql.append(runParam.getStorageOrgUnitID()).append("' and pt.FIsDefault=1 and pt.FBizTypeID='");
        sql.append("vGXRx5fFSsCYz9Zv7CzzgyQHQ1w=").append("'), '");
        sql.append(runParam.getProductTranTypeID()).append("')) \n");
        sql.append(" where t.FMaterialAttr=10030 and t.FProductTranTypeID is null ");
        MRPUtil.executeUpdate(runParam.getCtx(), sql.toString());
    }
}

