/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.app.mrp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.common.app.SQLUtils;
import com.kingdee.eas.mm.planning.MRPClassifyEnum;
import com.kingdee.eas.mm.planning.MRPElementEnum;
import com.kingdee.eas.mm.planning.MRPException;
import com.kingdee.eas.mm.planning.app.mrp.MRPCalcParam;
import com.kingdee.eas.mm.planning.app.mrp.MRPDetailInfo;
import com.kingdee.eas.mm.planning.app.mrp.MRPMaterialDataInfo;
import com.kingdee.eas.mm.planning.app.mrp.MRPMaterialStatisticsInfo;
import com.kingdee.eas.mm.planning.app.mrp.MRPResource;
import com.kingdee.eas.mm.planning.app.mrp.MRPStep;
import com.kingdee.eas.scm.common.util.KsqlUtil;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class MRPNetReqSaver {
    protected static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.planning.app.mrp.MRPNetReqSaver");
    private static final int MAX_DATA_SIZE = 500;
    private static final int PLANORDER_FILEDS_SIZE = 49;
    private static final int PLANORDERENTRY_FILEDS_SIZE = 32;
    private ArrayList listUpdateData;
    private ArrayList listUpdateData4Split;
    private ArrayList listInsertData;
    private ArrayList listUpdateData_d;
    private ArrayList listUpdateData_a;
    private ArrayList listUpdateData_n;
    private ArrayList listInsertS;
    private ArrayList listUpdatePlanOrder;
    private ArrayList listUpdateMaterial;
    private ArrayList listUpdateStockExcetion;
    private ArrayList mrpPlanOrderDatas;
    private ArrayList mrpPlanOrderEntryDatas;
    private ArrayList mrpPlanOrderEntryUpdate;
    private String insertSql;
    private String insertPlanOrder;
    private String insertPlanOrderEntry;
    private String updatePlanOrderEntry;
    private String updateSql;
    private String updateSql4Split;
    private String updateSqld;
    private String updateSqla;
    private String updateSqln;
    private String insertSqlS;
    private String updatePlanOrder;
    private String updateMaterial;
    private StringBuffer updateStockException;
    private int updateCount;
    private int insertCount;
    private MRPCalcParam runParam;
    private StringBuffer updateDetailField;
    private List detailField;
    private StringBuffer updateDetailNetReq;
    private ArrayList listUpdateDetailNetReq;
    private StringBuffer updateSurplusQty;
    private ArrayList listUpdateSurplusQty;

    public MRPNetReqSaver(MRPCalcParam runParam) throws MRPException, BOSException {
        if (MRPStep.isMoreInfo.booleanValue()) {
            logger.setLevel(Level.INFO);
        } else {
            logger.setLevel(Level.ERROR);
        }
        this.listUpdateData = new ArrayList();
        this.listUpdateData4Split = new ArrayList();
        this.listInsertData = new ArrayList();
        this.listUpdateData_d = new ArrayList();
        this.listUpdateData_a = new ArrayList();
        this.listUpdateData_n = new ArrayList();
        this.listInsertS = new ArrayList();
        this.listUpdatePlanOrder = new ArrayList();
        this.listUpdateMaterial = new ArrayList();
        this.listUpdateStockExcetion = new ArrayList();
        this.mrpPlanOrderDatas = new ArrayList();
        this.mrpPlanOrderEntryDatas = new ArrayList();
        this.mrpPlanOrderEntryUpdate = new ArrayList();
        this.updateCount = 0;
        this.insertCount = 0;
        this.runParam = null;
        this.detailField = new ArrayList();
        this.listUpdateDetailNetReq = new ArrayList();
        this.listUpdateSurplusQty = new ArrayList();
        this.runParam = runParam;
        String updateSqlTemp = "update {0} set FIsCalc = 1,FAvaliable = ?,FNetReq = ?,FPAB = ?,FPeriod=?,FAjustFlag=?,FAjustQty=?,FPriority=?,FRePlanDATE=?,FIsDayEnd=?,FIsWeekEnd=?,FIsMonthEnd=?,FIsDelay=?,FDisplaySeq=? ,FException1=?,FException2=?,FException3=?,FException4=?,FException5=?,FException6=?,FException7=?,FException8=?, FSID=? ,FSPeriod=?,FDependent = FDependent+ ? ,fsr = fsr+?  where FID = ?";
        String updateSqlTemp4Split = "update {0} set FIsCalc = 1,FAvaliable = ?,FNetReq = ?,FPAB = ?,FPeriod=?,FAjustFlag=?,FAjustQty=?,FPriority=?,FRePlanDATE=?,FIsDayEnd=?,FIsWeekEnd=?,FIsMonthEnd=?,FIsDelay=?,FDisplaySeq=? ,FException1=?,FException2=?,FException3=?,FException4=?,FException5=?,FException6=?,FException7=?,FException8=?,FSID=? ,FSPeriod=?,fsr = ?,FBillDate=?,FTrackNumber=?,FHasSplit=?,FDesc64=?  where FID = ?";
        String updateDqlsTemp = "update {0} set  FSQty = ? ,FRQty = ?, FPreQty = ? ,FOnHand= ?, FDetailCount= ? where FMaterialID = ? and FPeriod = ?  and FProjectNumber = ? and FTrackNumber = ?  ";
        String updateAqlsTemp = "update {0} set  FSQty = ? ,FRQty =  ?, FPreQty = ? where FID = ? ";
        StringBuffer updateSql_nextPeriod = new StringBuffer();
        updateSql_nextPeriod.append("update {0}  set  FSQty = ? ,FRQty = ?, FPreQty = ? , FDetailCount= ? where KSQL_SEQ in ( select ").append(" min(KSQL_SEQ) from {1}  where FMaterialID = ? and FPeriod > ? and FProjectNumber = ?").append("  and FTrackNumber = ? ) ");
        StringBuffer insertSB = new StringBuffer();
        insertSB.append("insert into {0} ").append("(FID,FPlanVersionID,FRunLogID,FMaterialID,FMRPClassify,").append("FMRPItem,FParentMateiralID,FSrcBillID,FSrcBillType,").append("FSrcBillNumber,FSrcBillEntryID,FSrcBillEntrySeq,FBillID,FBillEntryID,FBillType,").append("FBillNumber,FBillSeqNo,FBillRowSeq,FDisplaySeq,").append("FBillDate,FWorkDaySeqID,FWeekSeqID,FMonthSeqID,").append("FAvaliable,FSR,FIndependent,FDependent,FNetReq,FPlannedQty,FPAB,").append("FPlanBeginDate,FBeginDateWorkdayID,FPlanEndDate,FEndDateWorkdayID,FIsDayEnd,FIsWeekEnd,FIsMonthEnd,").append("FException1,FException2,FException3,FIsDelay,FIsTotalLine,FIsCalc,FPlanningMode,FSupplyOrgUnitID,FIsNewOrder,").append("FProjectID,FTrackID,FBomID,FYield,FAjustFlag,FAjustQty,FIsAjust,FPriority,FSID,FProjectNumber,").append("FTrackNumber,FBProjectID,FBTrackID,FBProjectNumber,FBTrackNumber,FParentBomID,FIsDefaultTNO ,").append("FPeriod,FRePlanDATE,FException4,FException5,FException6,FException7,FException8,FBaseStatus").append(" ,FBizTypeID,FSPeriod,FSSR,FIsDirectTransport ,FRequireMentID ,FSupplyType, ").append("FSaleOrderID, FSaleOrderEntryID, FSaleOrderNumber, FSaleOrderEntrySeq, FisCanNotThrow,FHierarchyCode,FMrpSeq,").append("FDesc64 )").append(" values (");
        for (int i = 0; i < 84; ++i) {
            insertSB.append("?,");
        }
        insertSB.append("?)");
        StringBuffer insertSBS = new StringBuffer();
        insertSBS.append("insert into {0} ( KSQL_SEQ,FID,FMaterialId, FPlanStrategy, FPeriod, FProjectNumber, FTrackNumber,FOnHand, ");
        if (KsqlUtil.isSQLServer((Context)runParam.getCtx())) {
            insertSBS.append(" FIsDefaultTNO,FSubstituteGroup,FRQty,FCalcSeq,FMaterialNumber)values(?,?,?,?,?,?,?,?,?,?,?,? )");
        } else {
            insertSBS.append(" FIsDefaultTNO,FSubstituteGroup,FRQty,FCalcSeq,FMaterialNumber)values(?,?,?,?,?,?,?,?,?,?,?,?,? )");
        }
        String insertSqlTemp = insertSB.toString();
        StringBuffer sqlBuf1 = new StringBuffer();
        sqlBuf1.append("update {0} set FisNewOrder = ? ,FhasExceptions = ? , FhasStockExp = ? where FMaterialid = ?");
        StringBuffer insertPlanOrderSB = new StringBuffer();
        insertPlanOrderSB.append("insert into {0} (FID,FDetailID,FNumber,FBizDate,FSourceBillID,");
        insertPlanOrderSB.append("FMaterialID,FProductionOrgUnitID,FStartDate,");
        insertPlanOrderSB.append("FEndDate,FAvilableDate,FBaseQty,FUnitID,");
        insertPlanOrderSB.append("FBomInterID,FSchemeID,FSourceBillTypeID,FSourceOrderID,");
        insertPlanOrderSB.append("FSourceNumber,FSourceEntryID,FRelatingOrderID,FRelatingEntryID,FRelatingOrderNum,FRelatingEntrySeq,");
        insertPlanOrderSB.append("FProjectID,FTrackID,FBProjectID,FBTrackID,FProjectNumber,FTrackNumber,FBProjectNumber,FBTrackNumber,");
        insertPlanOrderSB.append("FIsDefaultTNO,FIsStraightIssueMode,FIsCannotRelease,FHierarchyCode,FYield,");
        insertPlanOrderSB.append("FMaterialAttr,FProductUnitID,FManufactureDepartment,FConvertRate,FTransactionTypeID,FLowsetCode,FPlanner, ");
        insertPlanOrderSB.append("FProdQtyPrc,FBaseQtyPrc,FBeginDateWorkdayID,FParentBomID,FFinalProductsQty, FQty,FPlanOrgUnit)");
        insertPlanOrderSB.append(" values(");
        for (int i = 0; i < 48; ++i) {
            insertPlanOrderSB.append("?,");
        }
        insertPlanOrderSB.append("?)");
        this.insertPlanOrder = MessageFormat.format(insertPlanOrderSB.toString(), runParam.getMrpPlanOrder());
        StringBuffer insertPlanOrderEntrySB = new StringBuffer();
        insertPlanOrderEntrySB.append("insert into {0} (FID,FParentID,FMaterialID,FParentMaterialID,FUnitID,FBaseDemandQty,").append("FReqDate,FStorageOrgUnitID,FSeq,FSourceBillEntryID,FProvideType,FUnitQty,").append("FIssMode,FDefaultWarehouseID,FLocationID,FTransferOrgUnitID,FTransferWarehouseID,FBackFlush,FIsStockTransfer,").append("FProductUnitID,FDemandQty,FMaterialSubsID,FReplaceVersionID,FReplaceVersionEntryID,FLineSeq,").append("FIsReplaced,FReplacePriority,FMatReplaceType,FOriginalPlanQty,FStandardQty,FScrapRate,FScrapQty)");
        insertPlanOrderEntrySB.append(" values(");
        for (int i = 0; i < 31; ++i) {
            insertPlanOrderEntrySB.append("?,");
        }
        insertPlanOrderEntrySB.append("?)");
        this.insertPlanOrderEntry = MessageFormat.format(insertPlanOrderEntrySB.toString(), runParam.getMrpPlanOrderEntry());
        StringBuffer updatePlanOrderEntrySB = new StringBuffer();
        updatePlanOrderEntrySB.append("update {0} set FBaseDemandQty = FBaseDemandQty+?,FDemandQty = FDemandQty + ?,").append(" FStandardQty=FStandardQty-?,FOriginalPlanQty=FOriginalPlanQty-?,FIsReplaced=?,FMatReplaceType=?,").append(" FScrapQty=(FDemandQty + ?)-(FStandardQty - ?) where FID = ?");
        this.updatePlanOrderEntry = MessageFormat.format(updatePlanOrderEntrySB.toString(), runParam.getMrpPlanOrderEntry());
        this.updatePlanOrder = MessageFormat.format(updatePlanOrderEntrySB.toString(), "T_MM_PlannedOrderEntry");
        this.insertSql = MessageFormat.format(insertSqlTemp, runParam.getMrpCalcDetailTableName());
        this.updateSql = MessageFormat.format(updateSqlTemp, runParam.getMrpCalcDetailTableName());
        this.updateSql4Split = MessageFormat.format(updateSqlTemp4Split, runParam.getMrpCalcDetailTableName());
        this.updateSqld = MessageFormat.format(updateDqlsTemp, runParam.getStatisticsTable());
        this.updateSqla = MessageFormat.format(updateAqlsTemp, runParam.getStatisticsTable());
        this.updateSqln = MessageFormat.format(updateSql_nextPeriod.toString(), runParam.getStatisticsTable(), runParam.getStatisticsTable());
        this.insertSqlS = MessageFormat.format(insertSBS.toString(), runParam.getStatisticsTable());
        this.updateMaterial = MessageFormat.format(sqlBuf1.toString(), runParam.getMaterialTableName());
        this.updateStockException = new StringBuffer();
        this.updateStockException.append("update ").append(runParam.getMrpCalcDetailTableName()).append(" set FException4=? where fid = ?");
        this.updateDetailField = new StringBuffer();
        this.updateDetailField.append("update ").append(runParam.getMrpCalcDetailTableName()).append(" set FDesc64=? where fid = ?");
        this.updateDetailNetReq = new StringBuffer();
        this.updateDetailNetReq.append("update ").append(runParam.getMrpCalcDetailTableName()).append(" set FNetReq = ?,FDesc64=?  where fid = ?");
        this.updateSurplusQty = new StringBuffer();
        this.updateSurplusQty.append("update ").append(runParam.getStatisticsTable()).append(" set FSurplusQty = ? where fid = ?");
    }

    public void updateStatisticsInfo() {
    }

    public void addUpdateList(MRPDetailInfo data) throws EASBizException, BOSException {
        this.listUpdateData.add(data);
        this.execute(false);
    }

    public void addUpdateList4Split(MRPDetailInfo data) throws EASBizException, BOSException {
        this.listUpdateData4Split.add(data);
        this.execute(false);
    }

    public void addUpdateList4Split(List dataList) throws EASBizException, BOSException {
        this.listUpdateData4Split.addAll(dataList);
        this.execute(false);
    }

    public void addUpdateDetailNetReqList(MRPDetailInfo data) throws EASBizException, BOSException {
        this.listUpdateDetailNetReq.add(data);
        this.execute(false);
    }

    public void addDUpdateList(MRPMaterialStatisticsInfo data) throws EASBizException, BOSException {
        this.listUpdateData_d.add(data);
        this.execute(false);
    }

    public void addAUpdateList(MRPMaterialStatisticsInfo data) {
        this.listUpdateData_a.add(data);
    }

    public void addInsertList(MRPMaterialStatisticsInfo data) throws EASBizException, BOSException {
        if (data.getSeq() == 0) {
            this.listInsertS.add(data);
            if (this.listInsertS.size() >= 500) {
                this.executeInsertS();
            }
        }
    }

    public void addUpdateMaterialList(MRPMaterialDataInfo data) throws EASBizException, BOSException {
        this.listUpdateMaterial.add(data);
        if (this.listUpdateMaterial.size() >= 500) {
            this.executeUpdateMaterial();
        }
    }

    public void addUpdatePLannedList(MRPDetailInfo data) throws EASBizException, BOSException {
        this.listUpdatePlanOrder.add(data);
        if (this.listUpdatePlanOrder.size() >= 500) {
            this.executeUpdatePlannedOrder();
        }
    }

    public void addUpdateStockException(MRPDetailInfo data) throws EASBizException, BOSException {
        this.listUpdateStockExcetion.add(data);
        if (data.getDescription64() != null) {
            this.detailField.add(data);
        }
        if (this.listUpdateStockExcetion.size() >= 500) {
            this.executeUpdateStockException();
        }
        if (this.detailField.size() >= 500) {
            this.executeUpdateDetailField();
        }
    }

    public void addInsertList(MRPDetailInfo data) throws EASBizException, BOSException {
        this.listInsertData.add(data);
        this.execute(false);
    }

    public void addMrpPlanOrder(MRPDetailInfo data) throws EASBizException, BOSException {
        if (data.getParentID() != null) {
            this.mrpPlanOrderEntryDatas.add(data);
        } else {
            this.mrpPlanOrderDatas.add(data);
        }
        if (this.mrpPlanOrderDatas.size() >= 500 || this.mrpPlanOrderEntryDatas.size() >= 500) {
            this.insertMrpPlanOrder();
            this.insertMrpPlanOrderEntry();
            this.mrpPlanOrderDatas.clear();
            this.mrpPlanOrderEntryDatas.clear();
        }
    }

    public void addMrpPlanOrderEntryU(MRPDetailInfo data) throws EASBizException, BOSException {
        this.mrpPlanOrderEntryUpdate.add(data);
        if (this.mrpPlanOrderEntryUpdate.size() >= 500) {
            this.updateMrpPlanOrderEntry();
            this.mrpPlanOrderEntryUpdate.clear();
        }
    }

    private void executeInsert(String sql) throws EASBizException, BOSException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)this.runParam.getCtx());
            pstmt = conn.prepareStatement(sql);
            int index = 1;
            MRPDetailInfo detInfo = null;
            for (int i = 0; i < this.listInsertData.size(); ++i) {
                index = 1;
                detInfo = (MRPDetailInfo)this.listInsertData.get(i);
                pstmt.setString(index++, detInfo.getID());
                pstmt.setString(index++, this.runParam.getPlanVersionID());
                pstmt.setString(index++, this.runParam.getRunLogID());
                pstmt.setString(index++, detInfo.getMaterialID());
                pstmt.setInt(index++, detInfo.getMrpClassify().getValue());
                pstmt.setInt(index++, detInfo.getMrpItem().getValue());
                pstmt.setString(index++, detInfo.getParentMateiralID());
                pstmt.setString(index++, detInfo.getSrcBillID());
                pstmt.setString(index++, detInfo.getSrcBillType());
                pstmt.setString(index++, detInfo.getSrcBillNumber());
                pstmt.setString(index++, detInfo.getSrcBillEntryID());
                pstmt.setInt(index++, detInfo.getSrcBillRowSeq());
                pstmt.setString(index++, detInfo.getBillID());
                pstmt.setString(index++, detInfo.getBillEntryID());
                pstmt.setString(index++, detInfo.getBillType());
                pstmt.setString(index++, detInfo.getBillNumber());
                pstmt.setInt(index++, detInfo.getBillSeqNo());
                pstmt.setInt(index++, detInfo.getBillRowSeq());
                pstmt.setInt(index++, detInfo.getDisplaySeq());
                if (detInfo.getBillDate().getDate() != null) {
                    Date billDate = new Date(detInfo.getBillDate().getDate().getTimeInMillis());
                    pstmt.setDate(index++, billDate);
                } else {
                    pstmt.setDate(index++, new Date(System.currentTimeMillis()));
                }
                pstmt.setInt(index++, detInfo.getBillDate().getWorkDaySeqID());
                pstmt.setInt(index++, detInfo.getBillDate().getWeekSeqID());
                pstmt.setInt(index++, detInfo.getBillDate().getMonthSeqID());
                pstmt.setBigDecimal(index++, detInfo.getAvaliableQty());
                pstmt.setBigDecimal(index++, detInfo.getScheduledReceiptQty());
                pstmt.setBigDecimal(index++, detInfo.getIndependentQty());
                pstmt.setBigDecimal(index++, detInfo.getDependentQty());
                pstmt.setBigDecimal(index++, detInfo.getNetReqQty());
                pstmt.setBigDecimal(index++, detInfo.getPlannedQty());
                pstmt.setBigDecimal(index++, detInfo.getAvailableBalanceQty());
                if (detInfo.getPlanBeginDate().getDate() != null) {
                    Date beginDate = new Date(detInfo.getPlanBeginDate().getDate().getTimeInMillis());
                    pstmt.setDate(index++, beginDate);
                } else {
                    pstmt.setDate(index++, null);
                }
                pstmt.setInt(index++, detInfo.getPlanBeginDate().getWorkDaySeqID());
                if (detInfo.getPlanEndDate().getDate() != null) {
                    Date endDate = new Date(detInfo.getPlanEndDate().getDate().getTimeInMillis());
                    pstmt.setDate(index++, endDate);
                } else {
                    pstmt.setDate(index++, null);
                }
                pstmt.setInt(index++, detInfo.getPlanEndDate().getWorkDaySeqID());
                pstmt.setBoolean(index++, detInfo.isDayEnd());
                pstmt.setBoolean(index++, detInfo.isWeekEnd());
                pstmt.setBoolean(index++, detInfo.isMonthEnd());
                pstmt.setInt(index++, detInfo.getException1());
                pstmt.setInt(index++, detInfo.getException2());
                pstmt.setInt(index++, detInfo.getException3());
                pstmt.setBoolean(index++, detInfo.isDelay());
                pstmt.setBoolean(index++, detInfo.isTotalLine());
                pstmt.setBoolean(index++, true);
                pstmt.setInt(index++, detInfo.getPlanningMode());
                pstmt.setString(index++, detInfo.getSupplyStorageOrgUnitID());
                pstmt.setBoolean(index++, detInfo.isNewOrder());
                pstmt.setString(index++, detInfo.getProjectID());
                pstmt.setString(index++, detInfo.getTrackID());
                pstmt.setString(index++, detInfo.getBomID());
                pstmt.setBigDecimal(index++, detInfo.getYield());
                pstmt.setInt(index++, detInfo.getAjustFlag());
                pstmt.setBigDecimal(index++, detInfo.getAjustQty());
                pstmt.setInt(index++, detInfo.getIsAjust());
                pstmt.setInt(index++, detInfo.getPriority());
                pstmt.setString(index++, detInfo.getSID());
                pstmt.setString(index++, detInfo.getProjectNumber());
                pstmt.setString(index++, detInfo.getTrackNumber());
                pstmt.setString(index++, detInfo.getBProjectID());
                pstmt.setString(index++, detInfo.getBTrackID());
                pstmt.setString(index++, detInfo.getBProjectNumber());
                pstmt.setString(index++, detInfo.getBTrackNumber());
                pstmt.setString(index++, detInfo.getParentBomID());
                pstmt.setInt(index++, detInfo.getIsDeaultTNO());
                pstmt.setInt(index++, detInfo.getPeriod());
                if (detInfo.getRePlanDATE() != null && detInfo.getRePlanDATE().getDate() != null) {
                    Date replanDate = new Date(detInfo.getRePlanDATE().getDate().getTimeInMillis());
                    pstmt.setDate(index++, replanDate);
                } else {
                    pstmt.setDate(index++, null);
                }
                pstmt.setInt(index++, detInfo.getException4());
                pstmt.setInt(index++, detInfo.getException5());
                pstmt.setInt(index++, detInfo.getException6());
                pstmt.setInt(index++, detInfo.getException7());
                pstmt.setInt(index++, detInfo.getException8());
                pstmt.setInt(index++, detInfo.getBaseStatus());
                pstmt.setString(index++, detInfo.getBizTypeID());
                pstmt.setInt(index++, detInfo.getSperiod());
                pstmt.setBigDecimal(index++, detInfo.getSsrQty());
                pstmt.setBoolean(index++, detInfo.isDirectTransport());
                pstmt.setString(index++, detInfo.getRequireMentID());
                pstmt.setInt(index++, detInfo.getSupplyType());
                pstmt.setString(index++, detInfo.getSaleOrderID());
                pstmt.setString(index++, detInfo.getSaleOrderEntryID());
                pstmt.setString(index++, detInfo.getSaleOrderNumber());
                pstmt.setInt(index++, detInfo.getSaleOrderEntryNum());
                pstmt.setBoolean(index++, detInfo.isCanNotThrow());
                pstmt.setString(index++, detInfo.getHierarchyCode());
                pstmt.setString(index++, detInfo.getMrpSeq());
                pstmt.setString(index++, detInfo.getDescription64());
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rs, (Statement)pstmt, (Connection)conn);
    }

    private void updateMrpPlanOrderEntry() throws MRPException, BOSException {
        MRPDetailInfo detInfo = null;
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        int index = 0;
        for (int i = 0; i < this.mrpPlanOrderEntryUpdate.size(); ++i) {
            index = 0;
            Object[] param = new Object[9];
            detInfo = (MRPDetailInfo)this.mrpPlanOrderEntryUpdate.get(i);
            param[index++] = detInfo.getAvaliableQty();
            param[index++] = detInfo.getPlannedSubQty();
            param[index++] = detInfo.getStandardQty();
            param[index++] = detInfo.getStandardQty();
            param[index++] = new Integer(detInfo.getIsReplaced());
            param[index++] = new Integer(detInfo.getReplaceMode());
            param[index++] = detInfo.getPlannedSubQty();
            param[index++] = detInfo.getStandardQty();
            param[index++] = detInfo.getBillEntryID();
            params.add(param);
        }
        SQLUtils.executeBatch((Context)this.runParam.getCtx(), (String)this.updatePlanOrderEntry, params);
    }

    private void insertMrpPlanOrder() throws BOSException, MRPException {
        MRPDetailInfo detInfo = null;
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        int index = 0;
        for (int i = 0; i < this.mrpPlanOrderDatas.size(); ++i) {
            index = 0;
            Object[] param = new Object[49];
            detInfo = (MRPDetailInfo)this.mrpPlanOrderDatas.get(i);
            param[index++] = detInfo.getBillID();
            param[index++] = detInfo.getID();
            param[index++] = detInfo.getBillNumber();
            Date billDate = null;
            billDate = detInfo.getBillDate().getDate() != null ? new Date(detInfo.getBillDate().getDate().getTimeInMillis()) : new Date(System.currentTimeMillis());
            param[index++] = billDate;
            param[index++] = detInfo.getRequireMentID();
            param[index++] = detInfo.getMaterialID();
            param[index++] = detInfo.getSupplyStorageOrgUnitID();
            int benginDateSeq = -1;
            if (detInfo.getPlanBeginDate().getDate() != null && !detInfo.getMrpItem().equals((Object)MRPElementEnum.S_StockTransfer) && !detInfo.getMrpItem().equals((Object)MRPElementEnum.S_TransferOrder)) {
                Date beginDate = new Date(detInfo.getPlanBeginDate().getDate().getTimeInMillis());
                benginDateSeq = detInfo.getPlanBeginDate().getWorkDaySeqID();
                param[index++] = beginDate;
            } else {
                param[index++] = null;
            }
            param[index++] = new Date(detInfo.getPlanEndDate().getDate().getTimeInMillis());
            param[index++] = billDate;
            param[index++] = detInfo.getPlannedQty();
            param[index++] = detInfo.getBaseUnitID();
            param[index++] = detInfo.getBomID();
            param[index++] = this.runParam.getPlanVersionID();
            param[index++] = detInfo.getSrcBillType();
            param[index++] = detInfo.getSrcBillID();
            param[index++] = detInfo.getSrcBillNumber();
            param[index++] = detInfo.getSrcBillEntryID();
            param[index++] = detInfo.getSaleOrderID();
            param[index++] = detInfo.getSaleOrderEntryID();
            param[index++] = detInfo.getSaleOrderNumber();
            param[index++] = new Integer(detInfo.getSaleOrderEntryNum());
            param[index++] = detInfo.getProjectID();
            param[index++] = detInfo.getTrackID();
            param[index++] = "F7InW/cZQ1iofHY+Qq1KnACyBQ4=".equals(detInfo.getBProjectID()) ? null : detInfo.getBProjectID();
            param[index++] = "iZWLs5RwQe6CEVd5I2L2lghumD0=".equals(detInfo.getBTrackID()) ? null : detInfo.getBTrackID();
            param[index++] = detInfo.getProjectNumber();
            param[index++] = detInfo.getTrackNumber();
            param[index++] = detInfo.getBProjectNumber();
            param[index++] = detInfo.getBTrackNumber();
            param[index++] = new Integer(detInfo.getIsDeaultTNO());
            param[index++] = detInfo.isDirectTransport();
            param[index++] = detInfo.isCanNotThrow();
            param[index++] = detInfo.getHierarchyCode();
            param[index++] = detInfo.getYield4PlanOrder();
            param[index++] = new Integer(detInfo.getMaterialAttr());
            param[index++] = detInfo.getProdUnitID();
            param[index++] = detInfo.getManufactureDepartmentId();
            param[index++] = detInfo.getConvertRate();
            param[index++] = detInfo.getProductTranTypeID();
            param[index++] = new Integer(detInfo.getLowsetCode());
            param[index++] = detInfo.getPlanner();
            param[index++] = new Integer(detInfo.getProdQtyPrc());
            param[index++] = new Integer(detInfo.getBaseQtyPrc());
            param[index++] = new Integer(benginDateSeq);
            param[index++] = detInfo.getParentBomID();
            param[index++] = detInfo.getFinalProductsQty();
            param[index++] = detInfo.getPlanOrderQty();
            param[index++] = detInfo.getPlanOrgUnitId();
            params.add(param);
        }
        SQLUtils.executeBatch((Context)this.runParam.getCtx(), (String)this.insertPlanOrder, params);
    }

    private void insertMrpPlanOrderEntry() throws BOSException, MRPException {
        MRPDetailInfo detInfo = null;
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        int index = 0;
        String sOrgUnit = this.runParam.getRunLogInfo().getStorageOrgUnit().getId().toString();
        for (int i = 0; i < this.mrpPlanOrderEntryDatas.size(); ++i) {
            Object[] param = new Object[32];
            detInfo = (MRPDetailInfo)this.mrpPlanOrderEntryDatas.get(i);
            index = 0;
            param[index++] = detInfo.getBillEntryID();
            param[index++] = detInfo.getParentID();
            param[index++] = detInfo.getMaterialID();
            param[index++] = detInfo.getParentMateiralID();
            param[index++] = detInfo.getBaseUnitID();
            param[index++] = detInfo.getDependentQty();
            Date billDate = null;
            billDate = detInfo.getBillDate().getDate() != null ? new Date(detInfo.getBillDate().getDate().getTimeInMillis()) : new Date(System.currentTimeMillis());
            param[index++] = billDate;
            param[index++] = detInfo.getSupplyStorageOrgUnitID() != null ? detInfo.getSupplyStorageOrgUnitID() : sOrgUnit;
            param[index++] = new Integer(detInfo.getBillRowSeq());
            param[index++] = detInfo.getSrcBillEntryID();
            param[index++] = new Integer(detInfo.getSupplyType());
            param[index++] = detInfo.getUnitQty();
            param[index++] = new Integer(detInfo.getIssMode());
            param[index++] = detInfo.getDefaultWarehouseID();
            param[index++] = detInfo.getLocationID();
            param[index++] = detInfo.getTransferOrgUnitID();
            param[index++] = detInfo.getTransferWarehouseID();
            param[index++] = new Integer(detInfo.getIsBackFlush());
            param[index++] = new Integer(detInfo.getIsStockTransfer());
            param[index++] = detInfo.getProdUnitID();
            param[index++] = detInfo.getNetReqQty();
            param[index++] = detInfo.getMaterialSubsID();
            param[index++] = detInfo.getReplaceID();
            param[index++] = detInfo.getReplaceEntryID();
            param[index++] = detInfo.getLineSeq();
            param[index++] = new Integer(detInfo.getIsReplaced());
            param[index++] = new Integer(detInfo.getReplacePriority());
            param[index++] = new Integer(detInfo.getReplaceMode());
            param[index++] = detInfo.getOriginStandardQty();
            param[index++] = detInfo.getStandardQty();
            param[index++] = detInfo.getScrapRate();
            param[index++] = detInfo.getScrapQty();
            params.add(param);
        }
        SQLUtils.executeBatch((Context)this.runParam.getCtx(), (String)this.insertPlanOrderEntry, params);
    }

    public void executeUpdate(List updateDatas) throws EASBizException, BOSException {
        this.executeUpdate(this.updateSql, updateDatas);
    }

    private void executeUpdate(String sql, List updateDatas) throws EASBizException, BOSException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)this.runParam.getCtx());
            pstmt = conn.prepareStatement(sql);
            int index = 1;
            for (int i = 0; i < updateDatas.size(); ++i) {
                index = 1;
                MRPDetailInfo detInfo = (MRPDetailInfo)updateDatas.get(i);
                pstmt.setBigDecimal(index++, detInfo.getAvaliableQty());
                pstmt.setBigDecimal(index++, detInfo.getNetReqQty());
                pstmt.setBigDecimal(index++, detInfo.getAvailableBalanceQty());
                pstmt.setInt(index++, detInfo.getPeriod());
                pstmt.setInt(index++, detInfo.getAjustFlag());
                pstmt.setBigDecimal(index++, detInfo.getAjustQty());
                pstmt.setInt(index++, detInfo.getPriority());
                if (detInfo.getRePlanDATE() != null && detInfo.getRePlanDATE().getDate() != null) {
                    Date replanDate = new Date(detInfo.getRePlanDATE().getDate().getTimeInMillis());
                    pstmt.setDate(index++, replanDate);
                } else {
                    pstmt.setDate(index++, null);
                }
                pstmt.setBoolean(index++, detInfo.isDayEnd());
                pstmt.setBoolean(index++, detInfo.isWeekEnd());
                pstmt.setBoolean(index++, detInfo.isMonthEnd());
                pstmt.setBoolean(index++, detInfo.isDelay());
                pstmt.setInt(index++, detInfo.getDisplaySeq());
                pstmt.setInt(index++, detInfo.getException1());
                pstmt.setInt(index++, detInfo.getException2());
                pstmt.setInt(index++, detInfo.getException3());
                pstmt.setInt(index++, detInfo.getException4());
                pstmt.setInt(index++, detInfo.getException5());
                pstmt.setInt(index++, detInfo.getException6());
                pstmt.setInt(index++, detInfo.getException7());
                pstmt.setInt(index++, detInfo.getException8());
                pstmt.setString(index++, detInfo.getSID());
                pstmt.setInt(index++, detInfo.getSperiod());
                if (detInfo.isNewOrder() && detInfo.getMrpClassify().equals((Object)MRPClassifyEnum.Requirement)) {
                    pstmt.setBigDecimal(index++, detInfo.getScheduledReceiptQty());
                    pstmt.setBigDecimal(index++, detInfo.getScheduledReceiptQty());
                } else {
                    pstmt.setBigDecimal(index++, new BigDecimal("0.000000000"));
                    pstmt.setBigDecimal(index++, new BigDecimal("0.000000000"));
                }
                pstmt.setString(index++, detInfo.getID());
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rs, (Statement)pstmt, (Connection)conn);
    }

    private void executeUpdate4Split(String sql) throws EASBizException, BOSException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)this.runParam.getCtx());
            pstmt = conn.prepareStatement(sql);
            int index = 1;
            for (int i = 0; i < this.listUpdateData4Split.size(); ++i) {
                index = 1;
                MRPDetailInfo detInfo = (MRPDetailInfo)this.listUpdateData4Split.get(i);
                pstmt.setBigDecimal(index++, detInfo.getAvaliableQty());
                pstmt.setBigDecimal(index++, detInfo.getNetReqQty());
                pstmt.setBigDecimal(index++, detInfo.getAvailableBalanceQty());
                pstmt.setInt(index++, detInfo.getPeriod());
                pstmt.setInt(index++, detInfo.getAjustFlag());
                pstmt.setBigDecimal(index++, detInfo.getAjustQty());
                pstmt.setInt(index++, detInfo.getPriority());
                if (detInfo.getRePlanDATE() != null && detInfo.getRePlanDATE().getDate() != null) {
                    Date replanDate = new Date(detInfo.getRePlanDATE().getDate().getTimeInMillis());
                    pstmt.setDate(index++, replanDate);
                } else {
                    pstmt.setDate(index++, null);
                }
                pstmt.setBoolean(index++, detInfo.isDayEnd());
                pstmt.setBoolean(index++, detInfo.isWeekEnd());
                pstmt.setBoolean(index++, detInfo.isMonthEnd());
                pstmt.setBoolean(index++, detInfo.isDelay());
                pstmt.setInt(index++, detInfo.getDisplaySeq());
                pstmt.setInt(index++, detInfo.getException1());
                pstmt.setInt(index++, detInfo.getException2());
                pstmt.setInt(index++, detInfo.getException3());
                pstmt.setInt(index++, detInfo.getException4());
                pstmt.setInt(index++, detInfo.getException5());
                pstmt.setInt(index++, detInfo.getException6());
                pstmt.setInt(index++, detInfo.getException7());
                pstmt.setInt(index++, detInfo.getException8());
                pstmt.setString(index++, detInfo.getSID());
                pstmt.setInt(index++, detInfo.getSperiod());
                pstmt.setBigDecimal(index++, detInfo.getScheduledReceiptQty());
                Date billDate = new Date(detInfo.getBillDate().getDate().getTimeInMillis());
                pstmt.setDate(index++, billDate);
                pstmt.setString(index++, detInfo.getTrackNumber());
                pstmt.setBoolean(index++, detInfo.isHasSplit());
                pstmt.setString(index++, detInfo.getDescription64());
                pstmt.setString(index++, detInfo.getID());
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rs, (Statement)pstmt, (Connection)conn);
    }

    private void executeUpdateD(String sql, int type) throws EASBizException, BOSException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList list = this.listUpdateData_d;
        if (type == 2) {
            list = this.listUpdateData_n;
        }
        try {
            conn = EJBFactory.getConnection((Context)this.runParam.getCtx());
            pstmt = conn.prepareStatement(sql);
            int index = 1;
            MRPMaterialStatisticsInfo sdetInfo = null;
            for (int i = 0; i < list.size(); ++i) {
                index = 1;
                sdetInfo = (MRPMaterialStatisticsInfo)list.get(i);
                pstmt.setBigDecimal(index++, sdetInfo.getSQty());
                pstmt.setBigDecimal(index++, sdetInfo.getRQty());
                pstmt.setBigDecimal(index++, sdetInfo.getPreQty());
                pstmt.setBigDecimal(index++, sdetInfo.getOnHand());
                pstmt.setInt(index++, sdetInfo.getDetailCount());
                pstmt.setString(index++, sdetInfo.getMaterialID());
                pstmt.setInt(index++, sdetInfo.getPeriod());
                pstmt.setString(index++, sdetInfo.getProjectNumber());
                pstmt.setString(index++, sdetInfo.getTrackNumber());
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rs, (Statement)pstmt, (Connection)conn);
    }

    private void executeUpdateA(String sql) throws EASBizException, BOSException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList list = this.listUpdateData_a;
        try {
            conn = EJBFactory.getConnection((Context)this.runParam.getCtx());
            pstmt = conn.prepareStatement(sql);
            int index = 1;
            MRPMaterialStatisticsInfo sdetInfo = null;
            for (int i = 0; i < list.size(); ++i) {
                index = 1;
                sdetInfo = (MRPMaterialStatisticsInfo)list.get(i);
                pstmt.setBigDecimal(index++, sdetInfo.getSQty());
                pstmt.setBigDecimal(index++, sdetInfo.getRQty());
                pstmt.setBigDecimal(index++, sdetInfo.getPreQty());
                pstmt.setString(index++, sdetInfo.getId());
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rs, (Statement)pstmt, (Connection)conn);
    }

    protected void executeInsertS() throws EASBizException, BOSException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList list = this.listInsertS;
        if (this.listInsertS.size() <= 0) {
            return;
        }
        try {
            conn = EJBFactory.getConnection((Context)this.runParam.getCtx());
            pstmt = conn.prepareStatement(this.insertSqlS);
            int index = 1;
            MRPMaterialStatisticsInfo sdetInfo = null;
            for (int i = 0; i < list.size(); ++i) {
                index = 1;
                sdetInfo = (MRPMaterialStatisticsInfo)list.get(i);
                if (!KsqlUtil.isSQLServer((Context)this.runParam.getCtx())) {
                    pstmt.setInt(index++, i);
                }
                pstmt.setString(index++, sdetInfo.getId());
                pstmt.setString(index++, sdetInfo.getMaterialID());
                pstmt.setString(index++, sdetInfo.getPlanStrategy());
                pstmt.setInt(index++, sdetInfo.getPeriod());
                pstmt.setString(index++, sdetInfo.getProjectNumber());
                pstmt.setString(index++, sdetInfo.getTrackNumber());
                pstmt.setBigDecimal(index++, sdetInfo.getOnHand());
                pstmt.setInt(index++, sdetInfo.getIsDeaultTNO());
                pstmt.setInt(index++, sdetInfo.getSubstituteGroup());
                pstmt.setBigDecimal(index++, sdetInfo.getRQty());
                pstmt.setInt(index++, sdetInfo.getCalcSeq());
                pstmt.setString(index++, sdetInfo.getMaterialNumber());
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                this.listInsertS.clear();
                throw throwable;
            }
        }
        SQLUtils.cleanup(rs, (Statement)pstmt, (Connection)conn);
        this.listInsertS.clear();
    }

    protected void executeUpdateMaterial() throws EASBizException, BOSException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        int index = 1;
        MRPMaterialDataInfo detInfo = null;
        if (this.listUpdateMaterial.size() <= 0) {
            return;
        }
        try {
            conn = EJBFactory.getConnection((Context)this.runParam.getCtx());
            pstmt = conn.prepareStatement(this.updateMaterial);
            for (int i = 0; i < this.listUpdateMaterial.size(); ++i) {
                index = 1;
                detInfo = (MRPMaterialDataInfo)this.listUpdateMaterial.get(i);
                pstmt.setInt(index++, detInfo.getIsNewOrder());
                pstmt.setInt(index++, detInfo.getHasExceptions());
                pstmt.setInt(index++, detInfo.getHasStockExp());
                pstmt.setString(index++, detInfo.getMaterialID());
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                this.listUpdateMaterial.clear();
                throw throwable;
            }
        }
        SQLUtils.cleanup(rs, (Statement)pstmt, (Connection)conn);
        this.listUpdateMaterial.clear();
    }

    protected void executeInsertPlannedOrder() throws EASBizException, BOSException {
        this.insertMrpPlanOrderEntry();
        this.mrpPlanOrderEntryDatas.clear();
    }

    protected void executeUpdatePlannedOrder() throws EASBizException, BOSException {
        MRPDetailInfo detInfo = null;
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        int index = 0;
        for (int i = 0; i < this.listUpdatePlanOrder.size(); ++i) {
            index = 0;
            Object[] param = new Object[9];
            detInfo = (MRPDetailInfo)this.listUpdatePlanOrder.get(i);
            param[index++] = detInfo.getAvaliableQty().negate();
            param[index++] = detInfo.getPlannedSubQty().negate();
            param[index++] = detInfo.getStandardQty();
            param[index++] = detInfo.getStandardQty();
            param[index++] = new Integer(detInfo.getIsReplaced());
            param[index++] = new Integer(detInfo.getReplaceMode());
            param[index++] = detInfo.getPlannedSubQty().negate();
            param[index++] = detInfo.getStandardQty();
            param[index++] = detInfo.getBillEntryID();
            params.add(param);
        }
        SQLUtils.executeBatch((Context)this.runParam.getCtx(), (String)this.updatePlanOrder, params);
    }

    protected void executeRemovePlannedOrder(List materialIDs) throws EASBizException, BOSException {
        if (materialIDs.size() == 0) {
            return;
        }
        for (int i = this.mrpPlanOrderEntryDatas.size() - 1; i >= 0; --i) {
            MRPDetailInfo detInfo = (MRPDetailInfo)this.mrpPlanOrderEntryDatas.get(i);
            String materialID = detInfo.getMaterialID();
            if (!materialIDs.contains(materialID)) continue;
            this.mrpPlanOrderEntryDatas.remove(i);
        }
    }

    protected void executeUpdateStockException() throws EASBizException, BOSException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        int index = 1;
        MRPDetailInfo detInfo = null;
        if (this.listUpdateStockExcetion.size() <= 0) {
            return;
        }
        try {
            conn = EJBFactory.getConnection((Context)this.runParam.getCtx());
            pstmt = conn.prepareStatement(this.updateStockException.toString());
            for (int i = 0; i < this.listUpdateStockExcetion.size(); ++i) {
                index = 1;
                detInfo = (MRPDetailInfo)this.listUpdateStockExcetion.get(i);
                pstmt.setInt(index++, detInfo.getException4());
                pstmt.setString(index++, detInfo.getID());
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                this.listUpdateStockExcetion.clear();
                throw throwable;
            }
        }
        SQLUtils.cleanup(rs, (Statement)pstmt, (Connection)conn);
        this.listUpdateStockExcetion.clear();
    }

    private void clear() {
        this.listUpdateData.clear();
        this.listUpdateData4Split.clear();
        this.listInsertData.clear();
        this.listUpdateData_d.clear();
        this.listUpdateData_a.clear();
        this.listUpdateData_n.clear();
        this.listUpdateStockExcetion.clear();
        this.mrpPlanOrderDatas.clear();
        this.mrpPlanOrderEntryDatas.clear();
        this.mrpPlanOrderEntryUpdate.clear();
        this.listUpdatePlanOrder.clear();
        this.detailField.clear();
        this.listUpdateDetailNetReq.clear();
        this.listUpdateSurplusQty.clear();
    }

    protected String getStepDesc() throws MRPException, BOSException {
        return MessageFormat.format(MRPResource.getString(this.runParam.getCtx(), "SP_BATCHSAVEDETDATA"), String.valueOf(this.updateCount), String.valueOf(this.insertCount));
    }

    protected String getStepNum() {
        return "60.01";
    }

    public int execute(boolean forceSave) throws EASBizException, BOSException {
        int lineCount = 0;
        if (forceSave || this.listInsertData.size() + this.listUpdateData.size() + this.listUpdateData_d.size() + this.listUpdateData_n.size() + this.listUpdateData_a.size() + this.listUpdateStockExcetion.size() + this.listUpdatePlanOrder.size() + this.detailField.size() >= 2000) {
            if (this.listInsertData.size() > 0) {
                this.executeInsert(this.insertSql);
            }
            if (this.listUpdateDetailNetReq.size() > 0) {
                this.executeUpdateDetailNetReq();
            }
            if (this.listUpdateData.size() > 0) {
                this.executeUpdate(this.updateSql, this.listUpdateData);
            }
            if (this.listUpdateData4Split.size() > 0) {
                this.executeUpdate4Split(this.updateSql4Split);
            }
            if (this.listUpdateData_d.size() > 0) {
                this.executeUpdateD(this.updateSqld, 1);
            }
            if (this.listUpdateData_n.size() > 0) {
                this.executeUpdateD(this.updateSqln, 2);
            }
            if (this.listUpdateData_a.size() > 0) {
                this.executeUpdateA(this.updateSqla);
            }
            if (this.listUpdateSurplusQty.size() > 0) {
                this.executeUpdateSurplusQty();
            }
            if (this.listUpdateStockExcetion.size() > 0) {
                this.executeUpdateStockException();
            }
            if (this.mrpPlanOrderDatas.size() > 0) {
                this.insertMrpPlanOrder();
            }
            if (this.mrpPlanOrderEntryDatas.size() > 0) {
                this.insertMrpPlanOrderEntry();
            }
            if (this.mrpPlanOrderEntryUpdate.size() > 0) {
                this.updateMrpPlanOrderEntry();
            }
            if (this.listUpdatePlanOrder.size() > 0) {
                this.executeUpdatePlannedOrder();
            }
            if (this.detailField.size() > 0) {
                this.executeUpdateDetailField();
            }
            this.updateCount = this.listUpdateData.size();
            this.insertCount = this.listInsertData.size();
            lineCount = this.listInsertData.size() + this.listUpdateData.size() + this.listUpdateData_d.size() + this.listUpdateData_n.size() + this.listUpdateData_a.size() + this.listUpdateStockExcetion.size() + this.listUpdatePlanOrder.size() + this.detailField.size();
            this.clear();
        }
        return lineCount;
    }

    public void executeUpdatePlanOrderEntry() throws BOSException, EASBizException {
        if (this.mrpPlanOrderEntryUpdate.size() > 0) {
            this.updateMrpPlanOrderEntry();
            this.mrpPlanOrderEntryUpdate.clear();
        }
        if (this.listUpdatePlanOrder.size() > 0) {
            this.executeUpdatePlannedOrder();
            this.listUpdatePlanOrder.clear();
        }
    }

    private void executeUpdateDetailField() throws EASBizException, BOSException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        int index = 1;
        MRPDetailInfo detInfo = null;
        if (this.detailField.size() <= 0) {
            return;
        }
        try {
            conn = EJBFactory.getConnection((Context)this.runParam.getCtx());
            pstmt = conn.prepareStatement(this.updateDetailField.toString());
            for (int i = 0; i < this.detailField.size(); ++i) {
                index = 1;
                detInfo = (MRPDetailInfo)this.detailField.get(i);
                pstmt.setString(index++, detInfo.getDescription64());
                pstmt.setString(index++, detInfo.getID());
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                this.detailField.clear();
                throw throwable;
            }
        }
        SQLUtils.cleanup(rs, (Statement)pstmt, (Connection)conn);
        this.detailField.clear();
    }

    private void executeUpdateDetailNetReq() throws EASBizException, BOSException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)this.runParam.getCtx());
            pstmt = conn.prepareStatement(this.updateDetailNetReq.toString());
            int index = 1;
            for (int i = 0; i < this.listUpdateDetailNetReq.size(); ++i) {
                index = 1;
                MRPDetailInfo detInfo = (MRPDetailInfo)this.listUpdateDetailNetReq.get(i);
                pstmt.setBigDecimal(index++, detInfo.getSurplusQty());
                pstmt.setString(index++, detInfo.getDescription64());
                pstmt.setString(index++, detInfo.getID());
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rs, (Statement)pstmt, (Connection)conn);
    }

    public void addUpdateSurplusQtyList(MRPMaterialStatisticsInfo data) throws EASBizException, BOSException {
        this.listUpdateSurplusQty.add(data);
        this.execute(false);
    }

    private void executeUpdateSurplusQty() throws EASBizException, BOSException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)this.runParam.getCtx());
            pstmt = conn.prepareStatement(this.updateSurplusQty.toString());
            int index = 1;
            for (int i = 0; i < this.listUpdateSurplusQty.size(); ++i) {
                index = 1;
                MRPMaterialStatisticsInfo statisticsInfo = (MRPMaterialStatisticsInfo)this.listUpdateSurplusQty.get(i);
                pstmt.setBigDecimal(index++, statisticsInfo.getSurplusQty());
                pstmt.setString(index++, statisticsInfo.getId());
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rs, (Statement)pstmt, (Connection)conn);
    }
}

