/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.app.mrp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.basedata.MaterialRangeEnum;
import com.kingdee.eas.mm.common.app.SQLUtils;
import com.kingdee.eas.mm.common.util.SQLUtil;
import com.kingdee.eas.mm.planning.MRPException;
import com.kingdee.eas.mm.planning.MrpRunEnum;
import com.kingdee.eas.mm.planning.app.PlannedOrderControllerBean;
import com.kingdee.eas.mm.planning.app.mrp.MRPCalcParam;
import com.kingdee.eas.mm.planning.app.mrp.MRPResource;
import com.kingdee.eas.mm.planning.app.mrp.MRPStep;
import com.kingdee.eas.mm.planning.app.mrp.MRPUtil;
import com.kingdee.eas.mm.planning.customization.CustomizationConfigBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;

public class MRPOrderGenerator
extends MRPStep {
    private static final String CLR = "\r\n";
    private int billCount = 0;

    @Override
    protected String getStepDesc() throws MRPException, BOSException {
        return this.getStepDesc(this.runParam) + "," + MRPResource.getString(this.runParam.getCtx(), "SYM_NUMBER") + ":" + String.valueOf(this.billCount);
    }

    @Override
    protected String getStepDesc(MRPCalcParam runParam) throws MRPException, BOSException {
        return MRPResource.getString(runParam.getCtx(), "SP_GENERATEORDER");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void genPlanOrder(MRPCalcParam runParam) throws BOSException, MRPException {
        TempTablePool pool;
        String tempCollectTable;
        block21: {
            MaterialRangeEnum range;
            StringBuffer sqlBuf = new StringBuffer();
            String sTableCalc = runParam.getMrpPlanOrder();
            String sCtrlUnit = runParam.getRunLogInfo().getStorageOrgUnit().getCU().getId().toString();
            String sStorageOrgUnitID = runParam.getStorageOrgUnitID();
            String createID = runParam.getCreatorID();
            int isSimulant = 0;
            if ((runParam.getPlanType().equals((Object)MrpRunEnum.MPS_Simulator) || runParam.getPlanType().equals((Object)MrpRunEnum.MRP_Simulator)) && !runParam.getRunLogInfo().isIsTransformPlannedOrder()) {
                isSimulant = 1;
            }
            sqlBuf.append("Insert T_MM_PlannedOrder(FID,FCreatorID,FCreateTime,FControlUnitID,FNumber,FBizDate,FHandlerID,").append("FDescription,FHasEffected,FAuditorID,FSourceBillID,FSourceFunction,FAuditTime,FBaseStatus,FBizTypeID,").append("FBillTypeID,FYear,FPeriod,FMaterialID,FOrderType,").append("FStorageOrgUnitID,FProductionOrgUnitID,FStartDate,FEndDate,FAvilableDate,FQty,FBaseQty,FFinalProductsRate,FFinalProductsQty,FTotalReleaseQty,").append("FBaseTotalReleaseQty,FScheduleQty,FBaseScheduleQty,FUnitID,FProductUnitID,FBomInterID,FBomNumber,FOrderMatLock,").append("FSchemeID,FCalcID,FSourceType,FSourceBillTypeID,FSourceOrderID,FSourceNumber,FSourceEntryID,").append("FRelatingOrderType,FRelatingOrderID,FRelatingEntryID,FRelatingOrderNum,FRelatingEntrySeq,").append("FPlanner ,FProjectId ,FTrackId ,FisAfreshExtend ,FAdminOrgUnitID,FisStraightIssueMode,FTransactionTypeID,").append("FIsSimulant,FIsCannotRelease,FHierarchyCode,FPlanOrgUnitId)");
            sqlBuf.append(" select t1.FID,").append("'").append(createID).append("',").append("getdate(),'" + sCtrlUnit + "',t1.FNumber,t1.FBizDate,null,").append("null,0,null,t1.FSourceBillID,null,null,2,null,").append("'9XXvbVGlRtym/0qtqeIXXrhE1B8=',0,0,t1.FMaterialID,").append("case t1.FMaterialAttr when 10030 then 10 when 10040 then 20 when 10050 then 30 else 0 end,").append("'").append(sStorageOrgUnitID).append("',t1.FProductionOrgUnitID,t1.FStartDate,t1.FEndDate,t1.FAvilableDate,").append(this.getQtyStr()).append("t1.FYield,t1.FFinalProductsQty, 0,0,0,0,t1.FUnitID,").append("t1.FProductUnitID,t1.FBomInterID,null,0,").append("t1.FSchemeID,'").append(runParam.getRunLogInfo().getId().toString()).append("',20,").append("t1.FSourceBillTypeID,t1.FSourceOrderID,t1.FSourceNumber,t1.FSourceEntryID,0,").append("t1.FRelatingOrderID,t1.FRelatingEntryID,t1.FRelatingOrderNum,t1.FRelatingEntrySeq,").append("t1.FPlanner ,t1.FBProjectID ,t1.FBTrackID ,0, t1.FManufactureDepartment ").append(" ,t1.FisStraightIssueMode ,t1.FTransactionTypeID,").append(isSimulant).append(",t1.FIsCannotRelease,t1.FHierarchyCode,t1.FPlanOrgUnit");
            sqlBuf.append(" from ").append(sTableCalc).append(" t1 ");
            sqlBuf.append(" where t1.FBaseQty>0 ");
            if (runParam.getPlanType().equals((Object)MrpRunEnum.MPS_Simulator) || runParam.getPlanType().equals((Object)MrpRunEnum.MRP_Simulator)) {
                range = runParam.getRunLogInfo().getMateriaRange();
                if (range.equals((Object)MaterialRangeEnum.PUR)) {
                    sqlBuf.append(" and t1.FMaterialAttr = ").append(10040).append(CLR);
                } else if (range.equals((Object)MaterialRangeEnum.CUSTOM)) {
                    sqlBuf.append(" and t1.FMaterialID in (").append(SQLUtil.arrayToString((Object[])runParam.getMaterialRangeIds())).append(")");
                }
            }
            this.billCount = MRPUtil.executeUpdate(runParam.getCtx(), sqlBuf.toString(), new Object[0]);
            if (runParam.getGenOrderCount() > this.billCount) {
                runParam.setGenOrderCount(this.billCount);
            }
            sqlBuf.setLength(0);
            sTableCalc = runParam.getMrpPlanOrderEntry();
            sqlBuf.append("Insert Into T_MM_PlannedOrderEntry(FID,FParentID,FMaterialID,FUnitID,FBaseUnitID,FDemandQty,FBaseDemandQty,").append("FStandardQty,FScrapRate,FScrapQty,").append("FReqDate,FQuotaControl,FIssInHightLimit,FIssInLowLimit,").append("FValidate,FStorageOrgUnitID,FSeq,FReasonCodeID,").append("FRemark,FAssistUnitID,FSourceBillTypeID,FAssociateQty,").append("FBaseStatus,FAssCoefficient,FSourceBillEntrySeq,FSourceBillEntryID,").append("FSourceBillNumber,FSourceBillID,FAssistPropertyID,FProvideType,FUnitQty,").append("FIssMode,FDefaultWarehouseID,FLocationID,FTransferOrgUnitID,FTransferWarehouseID,").append("FBackFlush,FIsStockTransfer,FMaterialSubsID,FReplaceVersionID,FReplaceVersionEntryID,").append(CLR).append("FlineSeq,FIsReplaced,FReplacePriority,FMatReplaceType,FOriginalPlanQty,").append(CLR).append("FNewnetWeight,FBlkSize,FSpecifiedLength) ").append(CLR).append("select t1.FID,t1.FParentID,t1.FMaterialID,t3.FProductUnitID,t1.FUnitID,").append("FDemandQty = (case when t1.FDemandQty > 0 then 0 else (0-t1.FDemandQty) end),").append("FBaseDemandQty=(case when t1.FBaseDemandQty > 0 then 0 else (0-t1.FBaseDemandQty) end),").append("t1.FStandardQty,").append("t1.FScrapRate,").append("0-t1.FStandardQty-t1.FDemandQty,").append("FReqDate=t1.FReqDate,t3.FIsQuotaControl,t3.FIssInHightLimit,t3.FIssInLowLimit,").append("FValidate=0,FStorageOrgUnitID=t1.FStorageOrgUnitID,t1.FSeq,FReasonCodeID='',").append("FRemark=null,FAssistUnitID=null,FSourceBillTypeID=null,FAssociateQty=0,").append("FBaseStatus=0,FAssCoefficient=0,FSourceBillEntrySeq=0,t1.FSourceBillEntryID,").append("FSourceBillNumber=null,FSourceBillID=null,FAssistPropertyID=null,t1.FProvideType ,t1.FUnitQty, ").append("t1.FIssMode,t1.FDefaultWarehouseID,t1.FLocationID,t1.FTransferOrgUnitID,t1.FTransferWarehouseID,").append("t1.FBackFlush,t1.FIsStockTransfer,t1.FMaterialSubsID,t1.FReplaceVersionID,t1.FReplaceVersionEntryID,").append(CLR).append("t1.FLineSeq,t1.FIsReplaced,t1.FReplacePriority,t1.FMatReplaceType,t1.FOriginalPlanQty, ").append(CLR).append("t1.FNewnetWeight,t1.FBlkSize,t1.FSpecifiedLength ").append(CLR).append("from ").append(sTableCalc).append(" t1 ").append("inner join T_BD_MaterialPlan t3 on t1.FMaterialID=t3.FMaterialID and t3.FOrgUnit='").append(sStorageOrgUnitID).append("' ");
            if (runParam.getPlanType().equals((Object)MrpRunEnum.MPS_Simulator) || runParam.getPlanType().equals((Object)MrpRunEnum.MRP_Simulator)) {
                range = runParam.getRunLogInfo().getMateriaRange();
                if (range.equals((Object)MaterialRangeEnum.PUR)) {
                    sqlBuf.append("where ");
                    sqlBuf.append(" t3.FMaterialAttr = ").append(10040).append(CLR);
                } else if (range.equals((Object)MaterialRangeEnum.CUSTOM)) {
                    sqlBuf.append("where ");
                    sqlBuf.append(" t1.FParentMaterialID in (").append(SQLUtil.arrayToString((Object[])runParam.getMaterialRangeIds())).append(")");
                }
            }
            MRPUtil.executeUpdate(runParam.getCtx(), sqlBuf.toString());
            CustomizationConfigBase configBase = new CustomizationConfigBase();
            boolean isSupportCoByProduct = configBase.getCoByProductCustomFlag();
            if (isSupportCoByProduct) {
                sqlBuf.setLength(0);
                sqlBuf.append("Insert Into T_MM_PlannedOrderOutputsEntry ").append(CLR).append("(FID,FParentID,FMaterialID,FUnitID,FBaseUnitID,").append("FQty,FBaseQty,FFinishedQty,FBaseFinishedQty,FQualifiedQty,FBaseQualifiedQty,FInStroreQty,FBaseInStroreQty,").append("FOutputType,FAssistPropertyID,").append("FSourceBillID,FSourceBillNumber,FSourceBillEntryID,").append("FSourceBillEntrySeq,FAssCoefficient,FBaseStatus,").append("FAssociateQty,FSourceBillTypeID,").append("FAssistUnitID,FRemark,FReasonCodeID,FSeq) ").append(CLR).append("select t1.FBillEntryID,t1.FBillID,t1.FMaterialID,t3.FProductUnitID,t1.FUnitID,").append("round(decimal(t1.FDependent/t4.FBaseConvsRate,21,8),t4.FQtyPrecision),t1.FDependent,0,0,0,0,0,0,").append("t1.FOutputType,FAssistPropertyID=null,").append("FSourceBillID=null,FSourceBillNumber=null,t1.FSrcBillEntryID,").append("FSourceBillEntrySeq=0,FAssCoefficient=0,FBaseStatus=0,").append("FAssociateQty=0,FSourceBillTypeID=null,").append("FAssistUnitID=null,FRemark=null,FReasonCodeID='',t1.FBillRowSeq ").append(CLR).append("from " + sTableCalc + " t1 ").append(CLR).append("inner join T_BD_MaterialPlan t3 on t1.FMaterialID=t3.FMaterialID and t3.FOrgUnit='" + sStorageOrgUnitID + "' ").append(CLR).append("inner join t_bd_multimeasureunit t4 on t1.FMaterialID = t4.FMaterialID and t3.FProductUnitID = t4.fmeasureunitid ").append(CLR).append("where (t1.FOutputType=10720 or t1.FOutputType=10730) ");
                MRPUtil.executeUpdate(runParam.getCtx(), sqlBuf.toString());
            }
            if (!runParam.isMaterialPlan()) return;
            String param = "0";
            Properties prop = new Properties();
            InputStream in = this.getClass().getClassLoader().getResourceAsStream("com/kingdee/eas/mm/planning/PlanSwitch.properties");
            tempCollectTable = null;
            try {
                prop.load(in);
                param = prop.getProperty("isPlan4Material4BomChange");
                if (!"1".equals(param)) break block21;
                pool = TempTablePool.getInstance((Context)runParam.getCtx());
                tempCollectTable = pool.createTempTable("create table tempCollect (FMaterialID VARCHAR(44), FSeq Int)");
                String[] materialRange = runParam.getMaterialRangeIds();
                HashSet<String> materialRangeSet = new HashSet<String>();
                for (int i = 0; i < materialRange.length; ++i) {
                    materialRangeSet.add(materialRange[i]);
                }
                StringBuffer insertSqlUnion = new StringBuffer();
                insertSqlUnion.append("insert into ").append(tempCollectTable).append("(FMaterialID,FSeq)");
                insertSqlUnion.append("select fid, 0 from T_BD_Material where  ");
                insertSqlUnion.append("  FID in (").append(this.setToStringBuffer(materialRangeSet)).append(")");
                int insertNum = SQLUtils.execute((Context)runParam.getCtx(), (String)insertSqlUnion.toString());
                logger.info((Object)("\u7b2c0\u5c42\u6240\u6709\u7269\u6599\u603b\u6570===" + insertNum + "\u4e2a"));
                int seq = 0;
                logger.info((Object)"\u5f00\u59cb\u5c55\u7b97\u4e0b\u4e00\u5c42");
                while (this.insert(seq, tempCollectTable)) {
                    logger.info((Object)("\u7b2c" + ++seq + "\u5c42\u5b58\u5728\u5e76\u5f00\u59cb\u5904\u7406\uff01"));
                    StringBuffer reApplyData = new StringBuffer();
                    reApplyData.append("delete from ").append(tempCollectTable);
                    reApplyData.append(" t where exists(select 1 from ");
                    reApplyData.append(tempCollectTable);
                    reApplyData.append(" where fseq<t.fseq and fmaterialid = t.fmaterialid");
                    reApplyData.append(") and fseq = " + seq);
                    DbUtil.execute((Context)runParam.getCtx(), (String)reApplyData.toString());
                }
                sTableCalc = runParam.getMrpPlanOrder();
                StringBuffer getRedundant = new StringBuffer();
                getRedundant.append("select fid from ").append(sTableCalc).append(" t where not exists(select 1 from ").append(tempCollectTable).append(" where FMaterialID = t.FMaterialID) ");
                IRowSet rowset = DbUtil.executeQuery((Context)runParam.getCtx(), (String)getRedundant.toString());
                if (rowset.size() > 0) {
                    runParam.setGenOrderCount(runParam.getGenOrderCount() - rowset.size());
                    BatchExecuteParamsEntry[] entrys = new BatchExecuteParamsEntry[rowset.size()];
                    int i = -1;
                    while (rowset != null && rowset.next()) {
                        ++i;
                        String orderId = rowset.getString("fid");
                        ObjectUuidPK objPK = new ObjectUuidPK(orderId);
                        BatchExecuteParamsEntry entry = new BatchExecuteParamsEntry(new Class[]{IObjectPK.class});
                        entry.add((Object)objPK);
                        entrys[i] = entry;
                    }
                    PlannedOrderControllerBean bean = new PlannedOrderControllerBean();
                    bean.batchDelete(runParam.getCtx(), entrys);
                }
            }
            catch (EASBizException e) {
                try {
                    throw new BOSException((Throwable)e);
                    catch (IOException e2) {
                        throw new BOSException((Throwable)e2);
                    }
                    catch (Exception e3) {
                        throw new BOSException((Throwable)e3);
                    }
                }
                catch (Throwable throwable) {
                    TempTablePool pool2 = TempTablePool.getInstance((Context)runParam.getCtx());
                    if (StringUtils.isEmpty(tempCollectTable)) throw throwable;
                    pool2.releaseTable(tempCollectTable);
                    throw throwable;
                }
            }
        }
        pool = TempTablePool.getInstance((Context)runParam.getCtx());
        if (StringUtils.isEmpty(tempCollectTable)) return;
        pool.releaseTable(tempCollectTable);
    }

    boolean insert(int seq, String tempCollectTable) throws MRPException, BOSException {
        StringBuffer extendSql = new StringBuffer();
        extendSql.append("insert into ");
        extendSql.append(tempCollectTable).append("(FMaterialID,FSeq)");
        extendSql.append("select distinct FMaterialID,");
        extendSql.append(seq + 1);
        extendSql.append(" from T_MM_BOMEntry t ");
        extendSql.append(" where exists(");
        extendSql.append(" select 1 from T_MM_BOM b inner join  ");
        extendSql.append(tempCollectTable);
        extendSql.append(" a  on b.FMATERIALID=a.FMATERIALID ");
        extendSql.append(" where b.FStorageOrgUnitid='").append(this.runParam.getStorageOrgUnitID());
        extendSql.append("' And t.FParentID = b.fid");
        extendSql.append(" And b.FBaseStatus = 4 ");
        extendSql.append(" And b.FUsageType = 10 ");
        extendSql.append(" And b.FBomType = 40 ");
        extendSql.append(" And a.FSEQ =").append(seq).append(")");
        int insertNum = SQLUtils.execute((Context)this.runParam.getCtx(), (String)extendSql.toString());
        logger.info((Object)("\u7b2c" + (seq + 1) + "\u5c42\u7269\u6599===" + insertNum + "\u4e2a"));
        return insertNum > 0;
    }

    private StringBuffer setToStringBuffer(Set<String> allIDs) {
        StringBuffer ids = new StringBuffer();
        for (String id : allIDs) {
            ids.append("'");
            ids.append(id);
            ids.append("'");
            ids.append(",");
        }
        ids = ids.replace(ids.length() - 1, ids.length(), "");
        return ids;
    }

    private String getQtyStr() {
        StringBuffer sql = new StringBuffer();
        sql.append("t1.FQty,").append("t1.FBaseQty,\n");
        return sql.toString();
    }

    @Override
    protected Object innerExecute(MRPCalcParam runParam) throws EASBizException, BOSException {
        this.genPlanOrder(runParam);
        return null;
    }

    @Override
    protected boolean isNeedUpdateProgress() {
        return true;
    }

    @Override
    protected int getDataAmount() {
        return this.runParam.getGenOrderCount();
    }
}

