/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.app.mrp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.planning.CooperatePlanOrderInfo;
import com.kingdee.eas.mm.planning.MRPException;
import com.kingdee.eas.mm.planning.PlannedOrderInfo;
import com.kingdee.eas.mm.planning.app.mrp.MRPCalcParam;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import java.util.ArrayList;
import java.util.List;

public class MRPPONumberGenerator {
    private SCMBillBaseInfo PO_Instance = null;
    private ICodingRuleManager codingRuleManager = null;
    private MRPCalcParam runParam = null;
    private List numberList = new ArrayList();

    public MRPPONumberGenerator(MRPCalcParam runParam) throws BOSException, MRPException {
        this.runParam = runParam;
        this.codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)runParam.getCtx());
        this.generateInfo();
    }

    public String getNumber() throws EASBizException, BOSException {
        if (this.numberList.size() == 0) {
            this.preGetBillNumbers();
        }
        String number = (String)this.numberList.get(0);
        this.numberList.remove(0);
        return number;
    }

    private void preGetBillNumbers() throws EASBizException, BOSException {
        int numberOfbatch = 10;
        int matCount = this.runParam.getMaterialCount();
        if (matCount <= 100) {
            numberOfbatch = 10;
        } else if (matCount > 100 && matCount <= 1000) {
            numberOfbatch = 50;
        } else if (matCount > 1000) {
            numberOfbatch = 100;
        }
        String[] nums = null;
        nums = this.codingRuleManager.getBatchNumber((IObjectValue)this.PO_Instance, this.runParam.getStorageOrgUnitID(), numberOfbatch);
        for (int i = 0; i < nums.length; ++i) {
            this.numberList.add(nums[i]);
        }
    }

    public void recycleNumbers() throws EASBizException, BOSException {
        if (this.numberList.size() > 0 && this.codingRuleManager.isUseIntermitNumber((IObjectValue)this.PO_Instance, this.runParam.getStorageOrgUnitID())) {
            String[] nums = new String[this.numberList.size()];
            System.arraycopy(this.numberList.toArray(), 0, nums, 0, this.numberList.size());
            this.codingRuleManager.recycleBatchNumber((IObjectValue)this.PO_Instance, this.runParam.getStorageOrgUnitID(), nums);
        }
    }

    private void generateInfo() {
        this.PO_Instance = this.runParam.isCooperatePlan() ? new CooperatePlanOrderInfo() : new PlannedOrderInfo();
    }
}

