/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.app.mrp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.DataLimitExceedException;
import com.kingdee.bos.dao.JDBCExceptionHandler;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.basedata.BomException;
import com.kingdee.eas.mm.basedata.MaterialRangeEnum;
import com.kingdee.eas.mm.common.app.SQLUtils;
import com.kingdee.eas.mm.common.util.MMUtils;
import com.kingdee.eas.mm.common.util.SQLUtil;
import com.kingdee.eas.mm.planning.MRPException;
import com.kingdee.eas.mm.planning.MRPRunLogStatusEnum;
import com.kingdee.eas.mm.planning.MRPStepStatusEnum;
import com.kingdee.eas.mm.planning.app.ReqPlanForMRP;
import com.kingdee.eas.mm.planning.app.mrp.MRPCalcParam;
import com.kingdee.eas.mm.planning.app.mrp.MRPDynamicTableManager;
import com.kingdee.eas.mm.planning.app.mrp.MRPResource;
import com.kingdee.eas.mm.planning.app.mrp.MRPRunStop;
import com.kingdee.eas.mm.planning.app.mrp.MRPStep;
import com.kingdee.eas.mm.planning.app.mrp.MRPUtil;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;

public class MRPRunCrush
extends MRPStep {
    private Exception e;

    public void setException(Exception e) {
        this.e = e;
    }

    @Override
    protected String getStepDesc(MRPCalcParam runParam) throws MRPException, BOSException {
        return MRPResource.getString(runParam.getCtx(true), "SP_RUNCRUSH");
    }

    @Override
    protected Object innerExecute(MRPCalcParam runParam) throws EASBizException, BOSException {
        MRPRunLogStatusEnum runLogStatus;
        Calendar planDate;
        String updateSql;
        String err;
        block2: {
            Throwable exception;
            MRPException ex;
            block1: {
                this.beginTime = runParam.getRunStartTime();
                runParam.recyclePONumber();
                MRPUtil.releaseTempTable(runParam);
                err = this.getExceptionMsg(this.e);
                updateSql = "update t_mm_mrprunlog set fplandate = ?,fendTime = ?, fstatus = ?,FHorizonTo= ?  where fid = ?";
                MRPRunStop.getInstance(runParam.getCtx(true), runParam.getStorageOrgUnitID()).setStop(runParam.getCtx(true), false);
                planDate = MRPUtil.createCalendar();
                runLogStatus = MRPRunLogStatusEnum.Crashed;
                ex = null;
                exception = null;
                if (!(this.e instanceof MRPException)) break block1;
                ex = (MRPException)((Object)this.e);
                if (!MRPException.STOP_MRP.getCode().equals(ex.getSubCode())) break block2;
                runLogStatus = MRPRunLogStatusEnum.Error_Stop;
                break block2;
            }
            for (exception = this.e.getCause(); exception != null; exception = exception.getCause()) {
                if (!(exception instanceof MRPException)) continue;
                ex = (MRPException)((Object)exception);
                if (!MRPException.STOP_MRP.getCode().equals(ex.getSubCode())) break;
                runLogStatus = MRPRunLogStatusEnum.Error_Stop;
                break;
            }
        }
        SQLUtils.execute((Context)runParam.getCtx(true), (String)updateSql, (Object[])new Object[]{new Date(planDate.getTimeInMillis()), new Timestamp(Calendar.getInstance().getTimeInMillis()), new Integer(runLogStatus.getValue()), new Date(runParam.getEndDate().getTime()), runParam.getRunLogID()});
        this.updateStepLogError(err, runLogStatus);
        this.reqPlanRollBack();
        return null;
    }

    private String getExceptionMsg(Throwable t) throws EASBizException, BOSException {
        if (t != null) {
            if (t instanceof MRPException || t instanceof BomException || t instanceof CodingRuleException || t instanceof EASBizException) {
                return t.getMessage();
            }
            if (t instanceof SQLException) {
                SQLException sqlExp = (SQLException)t;
                Exception exp = JDBCExceptionHandler.convertException((SQLException)sqlExp);
                if (exp instanceof DataLimitExceedException) {
                    return MRPResource.getString(this.runParam.getCtx(true), "RUNDATA_OUTOFRANG");
                }
                String errMsg = sqlExp.getMessage();
                int index = errMsg.indexOf("source sql is :");
                if (index > 0) {
                    errMsg = errMsg.substring(index + 15);
                }
                return "SQL Error:" + errMsg;
            }
            if (t.getCause() != null) {
                return this.getExceptionMsg(t.getCause());
            }
        }
        return MRPResource.getString(this.runParam.getCtx(true), "MRP_ERROR");
    }

    @Override
    protected boolean isNeedUpdateProgress() {
        return false;
    }

    @Override
    protected void logEnd() throws BOSException, MRPException, EASBizException {
        if (logger.isInfoEnabled()) {
            logger.info((Object)(this.runParam.getCurrentStep() + " Error: "));
            this.logTrace(this.e);
        }
        super.logEnd();
    }

    private void logTrace(Throwable t) {
        if (t != null && t.getStackTrace() != null) {
            StringBuffer msg = new StringBuffer();
            msg.append(t.getClass().toString() + " : " + t.getMessage()).append("\r\n");
            StackTraceElement[] elements = t.getStackTrace();
            for (int i = 0; i < elements.length; ++i) {
                msg.append(elements[i].toString()).append("\r\n");
            }
            logger.info((Object)msg.toString());
            this.logTrace(t.getCause());
        }
    }

    private void reqPlanRollBack() throws BOSException, MRPException {
        if (!this.runParam.isTransform() || this.runParam.isCooperatePlan() || MMUtils.isEmptyString((String)this.runParam.getMrpCalcDetailTableName())) {
            return;
        }
        ReqPlanForMRP reqPlan = new ReqPlanForMRP();
        TempTablePool pool = TempTablePool.getInstance((Context)this.runParam.getCtx(true));
        String tableName = null;
        try {
            tableName = pool.createTempTable(reqPlan.getTalbeStringForMRP());
            StringBuffer sql = new StringBuffer();
            sql.append("insert into ").append(tableName).append(" select newbosid('12345678'),t1.FBillID,t1.FBillNumber,").append("t1.FBillEntryID,t1.FMaterialID,t1.FSupplyType,t3.FissMode,t1.FSupplyOrgUnitID,").append("'").append(this.runParam.getStorageOrgUnitID()).append("',").append("0,").append("(case when t1.FDependent > 0 then 0 else (0-t1.FDependent) end),").append("null,tt.FBaseUnit,1,t1.FBillDate,1,t2.FBProjectId,t2.FBTrackId ");
            sql.append("from ").append(this.runParam.getMrpCalcDetailTableName()).append(" t1 inner join ").append(this.runParam.getMrpCalcDetailTableName()).append(" t2 on t1.FBillId = t2.FBillId ").append("inner join t_bd_material tt on t1.FMaterialId = tt.FID ").append("inner join t_bd_materialplan t3 on t1.FMaterialId = t3.FMaterialId ").append(" and t3.FOrgUnit='").append(this.runParam.getStorageOrgUnitID()).append("' ");
            if (MaterialRangeEnum.CUSTOM.equals((Object)this.runParam.getRunLogInfo().getMateriaRange())) {
                String idStr = SQLUtil.arrayToString((Object[])this.runParam.getMaterialRangeIds());
                sql.append(" where t2.FMaterialID in (").append(idStr).append(") ");
            } else {
                sql.append("inner join ").append(this.runParam.getMaterialTableName()).append(" t4 on t2.FMaterialId = t4.FMaterialId ").append("where 1=1 ");
            }
            sql.append("and t1.FBillEntryID is not null ").append("and t1.FBillID is not null ").append("and t1.FParentMateiralID is not null ").append("and t1.FIsNewOrder = 1 ").append("and t2.FBillEntryID is null ").append("and t2.FBillID is not null ").append("and t2.FIsNewOrder = 1 ").append("and t2.FPlannedQty>0 ").append("and t3.FisComReqConsume = 1 and t3.FProvideType in (").append(10910).append(",").append(10920).append(")");
            MRPUtil.executeUpdate(this.runParam.getCtx(true), sql.toString());
            if (!MRPDynamicTableManager.isEmptyTable(this.runParam.getCtx(true), tableName)) {
                reqPlan.receiveData(this.runParam.getCtx(true), tableName, ReqPlanForMRP.actionTypeDelete, this.runParam.getStorageOrgUnitID());
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (!MMUtils.isEmptyString(tableName)) {
                pool.releaseTable(tableName);
            }
        }
    }

    private void updateStepLogError(String msg, MRPRunLogStatusEnum runLogStatus) throws BOSException, MRPException {
        MRPStepStatusEnum stopStatus = MRPStepStatusEnum.ERROR_STOP;
        if (msg != null && msg.length() > 1000) {
            msg = msg.substring(0, 999);
        }
        if (MRPRunLogStatusEnum.Error_Stop.equals((Object)runLogStatus)) {
            stopStatus = MRPStepStatusEnum.MANU_STOP;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("update T_MM_MRPRunsteplog set FException = ?,FStatus = ? where FID in ");
        sql.append("(select FID from T_MM_MRPRunsteplog where FStatus = 40 and FParentID = ?)");
        MRPUtil.executeUpdate(this.runParam.getCtx(true), sql.toString(), new Object[]{msg, new Integer(stopStatus.getValue()), this.runParam.getRunLogID()});
    }
}

