/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.app.mrp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.common.app.SQLUtils;
import com.kingdee.eas.mm.common.util.MMUtils;
import com.kingdee.eas.mm.planning.MRPException;
import com.kingdee.eas.mm.planning.MrpRunEnum;
import com.kingdee.eas.mm.planning.RequirementPlanFactory;
import com.kingdee.eas.mm.planning.app.mrp.MRPCalcParam;
import com.kingdee.eas.mm.planning.app.mrp.MRPDynamicTableManager;
import com.kingdee.eas.mm.planning.app.mrp.MRPHierarchyCodeGenerator;
import com.kingdee.eas.mm.planning.app.mrp.MRPResource;
import com.kingdee.eas.mm.planning.app.mrp.MRPRunningTablesInfo;
import com.kingdee.eas.mm.planning.app.mrp.MRPStep;
import com.kingdee.eas.mm.planning.app.mrp.MRPStrategySelectGenerator;
import com.kingdee.eas.mm.planning.app.mrp.MRPUtil;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;

public class MRPRunEnd
extends MRPStep {
    @Override
    protected String getStepDesc(MRPCalcParam runParam) throws MRPException, BOSException {
        return MRPResource.getString(runParam.getCtx(), "SP_RUNEND");
    }

    @Override
    protected Object innerExecute(MRPCalcParam runParam) throws EASBizException, BOSException {
        this.updateMaterialRange(runParam);
        runParam.recyclePONumber();
        MRPUtil.releaseTempTable(runParam);
        MRPHierarchyCodeGenerator hcGenerator = runParam.getHierarchyCodeGenerator();
        if (hcGenerator != null) {
            hcGenerator.updateCode();
        }
        StringBuffer updateSql = new StringBuffer("update t_mm_mrprunlog ").append("\r\n").append("set fpercent = 100,").append("\r\n").append("fendTime = ?, fstatus = ?,").append("\r\n").append("fdesc_" + runParam.getLocString() + " = ?,").append("\r\n").append("FTotalMaterals = ?,").append("\r\n").append("FNumOfexceptionMaterials = ?,").append("\r\n").append("FNumOflowerSafeStockMtl= ?,").append("\r\n").append("FTotalPlanOrders= ?, ").append("\r\n").append("FHorizonTo= ? ").append("\r\n").append("where fid = ?");
        SQLUtils.execute((Context)runParam.getCtx(), (String)updateSql.toString(), (Object[])new Object[]{new Timestamp(Calendar.getInstance().getTimeInMillis()), new Integer(10), MRPResource.getString(runParam.getCtx(), "SP_RUNEND"), new Integer(runParam.getMaterialCount()), new Integer(runParam.getExpMaterialCount()), new Integer(runParam.getUnderSaftQtyMaterialCount()), new Integer(runParam.getGenOrderCount()), new Date(runParam.getEndDate().getTime()), runParam.getRunLogID()});
        if (runParam.getPlanType().equals((Object)MrpRunEnum.MPS_GROSS)) {
            RequirementPlanFactory.getLocalInstance(runParam.getCtx()).updateCalculateTime((List)runParam.getRunLogInfo().get("requirementPlanIds"), new java.util.Date());
        }
        return null;
    }

    private void updateMaterialRange(MRPCalcParam runParam) throws BOSException, EASBizException {
        List resultTableList = MRPDynamicTableManager.getTableName(runParam.getCtx(), runParam.getStorageOrgUnitID(), runParam.getPlanVersionID(), runParam.isTransform());
        String newMaterialRange = MRPStrategySelectGenerator.newMaterialRange(runParam, ((MRPRunningTablesInfo)resultTableList.get(0)).getMaterialRange());
        if (!MMUtils.isEmptyString((String)newMaterialRange)) {
            StringBuffer sql = new StringBuffer();
            sql.append("update T_MM_RunningTables set FmaterialRange='").append(newMaterialRange).append("' where fstorageOrgUnitId = ? and fplanverid = ? and FIsFormal=?");
            SQLUtils.execute((Context)runParam.getCtx(), (String)sql.toString(), (Object[])new Object[]{runParam.getStorageOrgUnitID(), runParam.getPlanVersionID(), runParam.isTransform()});
        }
    }

    @Override
    protected boolean isNeedUpdateProgress() {
        return false;
    }
}

