/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.app.mrp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.planning.MRPException;
import com.kingdee.eas.mm.planning.MRPRunLogInfo;
import com.kingdee.eas.mm.planning.app.mrp.MRPCalcParam;
import com.kingdee.eas.mm.planning.app.mrp.MRPCalculateDateRange;
import com.kingdee.eas.mm.planning.app.mrp.MRPDynamicTableManager;
import com.kingdee.eas.mm.planning.app.mrp.MRPRunCrush;
import com.kingdee.eas.mm.planning.app.mrp.MRPStep;
import java.util.List;

public abstract class MRPRunner {
    private Context ctx;
    protected MRPCalcParam runParam = null;

    public MRPRunner(Context ctx) {
        this.ctx = ctx;
    }

    public void run(MRPRunLogInfo logInfo) throws BOSException, EASBizException {
        this.runParam = new MRPCalcParam();
        this.runParam.setRunLogInfo(logInfo);
        this.runParam.setCtx(this.ctx);
        try {
            List stepList = this.getStepList();
            this.initStepLog(stepList);
            for (int i = 0; i < stepList.size(); ++i) {
                ((MRPStep)stepList.get(i)).execute(this.runParam);
            }
        }
        catch (Exception e) {
            MRPRunCrush crush = new MRPRunCrush();
            crush.setException(e);
            crush.execute(this.runParam);
            throw new BOSException((Throwable)e);
        }
        finally {
            this.finallyHandle(this.runParam);
        }
    }

    protected void finallyHandle(MRPCalcParam runParam) throws BOSException, MRPException {
        String[] tableNames = new String[3];
        tableNames[0] = runParam.getInvDetailTableName();
        if (runParam.isNeedUpdateResultTable()) {
            tableNames[1] = runParam.getMaterialTableName();
            tableNames[2] = runParam.getMrpCalcDetailTableName();
            MRPDynamicTableManager.dropPhysicalTable(runParam.getCtx(), tableNames);
        }
        IMutexServiceControl mutex = MutexServiceControlFactory.getLocalInstance((Context)this.ctx);
        mutex.releaseObjIDForUpdate(runParam.getStorageOrgUnitID());
    }

    protected abstract List getStepList() throws EASBizException, BOSException;

    private void initStepLog(List stepList) throws EASBizException, BOSException {
        int stepIndex = 1;
        for (int i = 0; i < stepList.size(); ++i) {
            MRPStep step = (MRPStep)stepList.get(i);
            if (step instanceof MRPCalculateDateRange) continue;
            step.createLogInfo(this.runParam, null, stepIndex++);
        }
    }
}

