/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.app.mrp;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.planning.MRPElementEnum;
import com.kingdee.eas.mm.planning.MRPException;
import com.kingdee.eas.mm.planning.app.mrp.MRPCalcParam;
import com.kingdee.eas.mm.planning.app.mrp.MRPDetailInfo;
import com.kingdee.eas.mm.planning.app.mrp.MRPUtil;

public class MRPSeqUtil {
    public static final String INV_SEQ = "00" + String.valueOf(110);
    public static final String SAFESTOCK_SEQ = "00133";
    public static final String DivertInv_SEQ = "00" + String.valueOf(140);
    public static final String UNDISTRIBUTE_INV_SEQ = "00" + String.valueOf(131);
    public static final String DISTRIBUTE_INV_SEQ = "00" + String.valueOf(132);

    public static void createMrpSeq(MRPCalcParam runParam) throws BOSException, MRPException {
        StringBuffer sql = new StringBuffer();
        sql.append("update ").append(runParam.getMrpCalcDetailTableName()).append(" set FMrpSeq = TO_CHAR(FPeriod+10000) || ").append(" TO_CHAR(FMRPClassify) || ").append(" case when FMRPClassify = 30 then TO_CHAR(FisCanNotThrow) else '' end || ").append(" to_char(FPriority+10000) || ").append(" TO_CHAR(FBillNumber) || ").append(" case when FMRPClassify = 20 then to_char(FBillRowSeq+10000) else '' end ").append(" where FMrpSeq is null");
        MRPUtil.executeUpdate(runParam.getCtx(), sql.toString());
    }

    public static String getMRPSeq(MRPDetailInfo info) {
        if (info.getMrpItem().equals((Object)MRPElementEnum.I_CurInv)) {
            return INV_SEQ;
        }
        if (info.getMrpItem().equals((Object)MRPElementEnum.I_SafeInv)) {
            return SAFESTOCK_SEQ;
        }
        if (info.getMrpItem().equals((Object)MRPElementEnum.I_DivertInv)) {
            return DivertInv_SEQ;
        }
        if (info.getMrpItem().equals((Object)MRPElementEnum.UNDISTRIBUTE_INV)) {
            return UNDISTRIBUTE_INV_SEQ;
        }
        if (info.getMrpItem().equals((Object)MRPElementEnum.DISTRIBUTE_INV)) {
            return DISTRIBUTE_INV_SEQ;
        }
        StringBuffer str = new StringBuffer();
        if (info.getBillDate() != null && info.getBillDate().getDate() != null) {
            str.append(info.getPeriod() + 10000);
            int classify = info.getMrpClassify().getValue();
            str.append(classify);
            if (classify == 30) {
                str.append(info.isCanNotThrow() ? 1 : 0);
            }
            str.append(info.getPriority());
            str.append(info.getBillNumber());
            if (classify == 20) {
                str.append(info.getBillRowSeq() + 10000);
            }
        }
        return str.toString();
    }

    public static void setMRPSeq(MRPDetailInfo info) {
        info.setMrpSeq(MRPSeqUtil.getMRPSeq(info));
    }

    public static void updateRequirementDate(MRPCalcParam runParam) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("update ").append(runParam.getMrpCalcDetailTableName()).append(" t1 ").append(" set (FBillDate,FWorkDaySeqID,FPeriod,FMrpSeq) = ").append(" (select c.FRWorkDate,c.FRWorkDateSeq,c.FRWorkDateSeq, ").append(" TO_CHAR(c.FRWorkDateSeq+10000) || ").append(" TO_CHAR(FMRPClassify) || ").append(" TO_CHAR(FisCanNotThrow)  || ").append(" to_char(FPriority+10000) || ").append(" TO_CHAR(FBillNumber) || ").append(" '1000' ").append(" from ").append(runParam.getCalendarTable()).append(" c ").append(" where t1.FBillDate = c.FRealDate ").append(" and t1.FPeriod <= 0 ").append(" and t1.FMRPClassify=").append(30).append(")");
        MRPUtil.executeUpdate(runParam.getCtx(), sql.toString());
    }

    public static void updateSupplyDate(MRPCalcParam runParam) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append("update ").append(runParam.getMrpCalcDetailTableName()).append(" t1 ").append(" set (FWorkDaySeqID) = ").append(" (select c.FSWorkDateSeq - t1.FWorkDaySeqID  ").append(" from ").append(runParam.getCalendarTable()).append(" c ").append(" where t1.FBillDate = c.FRealDate ").append(" and t1.FPeriod <= 0 ").append(" and t1.FMRPClassify=").append(20).append(")");
        MRPUtil.executeUpdate(runParam.getCtx(), sql.toString());
        sql.setLength(0);
        sql.append("delete ").append(runParam.getMrpCalcDetailTableName()).append(" where (FWorkDaySeqID < ").append(runParam.getMRPBeginDate(1).getWorkDaySeqID()).append(" or FWorkDaySeqID > ").append(runParam.getMRPEndDate().getWorkDaySeqID()).append(") and FPeriod <= 0 ").append(" and FMRPClassify=").append(20).append(" ");
        MRPUtil.executeUpdate(runParam.getCtx(), sql.toString());
        sql.setLength(0);
        sql.append("update ").append(runParam.getMrpCalcDetailTableName()).append(" t1 ").append(" set (FBillDate,FWorkDaySeqID,FPeriod,FMrpSeq,FPlanEndDate) = ").append(" (select c.FWorkDate,c.FWorkDateSeq,c.FWorkDateSeq, ").append(" TO_CHAR(c.FWorkDateSeq+10000) || ").append(" TO_CHAR(FMRPClassify) || ").append(" '0' || ").append(" to_char(FPriority+10000) || ").append(" TO_CHAR(FBillNumber) || ").append(" to_char(FBillRowSeq+1000), ").append(" case when t1.FPlanEndDate is null then c.FWorkDate else t1.FPlanEndDate end").append(" from ").append(runParam.getCalendarTable()).append(" c ").append(" where t1.FWorkDaySeqID = c.FWorkDateSeq ").append(" and t1.FPeriod <= 0 ").append(" and t1.FMRPClassify=").append(20).append(")");
        MRPUtil.executeUpdate(runParam.getCtx(), sql.toString());
    }
}

