/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.app.mrp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.common.perf.IJobInstStatusFacade;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.basedata.CollaPlanVersionSetBillsInfo;
import com.kingdee.eas.mm.basedata.PlanVersionSetBillsInfo;
import com.kingdee.eas.mm.basedata.PlanVersionSetReCompositionInfo;
import com.kingdee.eas.mm.common.app.SQLUtils;
import com.kingdee.eas.mm.common.util.MMUtils;
import com.kingdee.eas.mm.planning.MRPException;
import com.kingdee.eas.mm.planning.MRPRunStepLogInfo;
import com.kingdee.eas.mm.planning.MRPStepStatusEnum;
import com.kingdee.eas.mm.planning.MrpRunEnum;
import com.kingdee.eas.mm.planning.app.mrp.MRPBillParamInfo;
import com.kingdee.eas.mm.planning.app.mrp.MRPCalcParam;
import com.kingdee.eas.mm.planning.app.mrp.MRPProgressUpdater;
import com.kingdee.eas.mm.planning.app.mrp.MRPResource;
import com.kingdee.eas.mm.planning.app.mrp.MRPRunCrush;
import com.kingdee.jdbc.rowset.IRowSet;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public abstract class MRPStep {
    protected static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.planning.app.mrp.MRPStep");
    public static Boolean isMoreInfo = Boolean.FALSE;
    public static String instanceHome = System.getProperty("EAS_INSTANCE_HOME");
    protected MRPCalcParam runParam;
    protected Date beginTime;
    protected Date endTime;
    protected int dataAmount = 0;
    protected String stepNum = null;
    protected int progressPercent = 1;
    private MRPRunStepLogInfo logInfo;

    public MRPStep() {
        if (isMoreInfo.booleanValue()) {
            logger.setLevel(Level.INFO);
        } else {
            logger.setLevel(Level.ERROR);
        }
        this.logInfo = null;
    }

    protected int getDataAmount() {
        return this.dataAmount;
    }

    public Object execute(MRPCalcParam runParam) throws EASBizException, BOSException {
        this.runParam = runParam;
        Object ret = null;
        if (!(this instanceof MRPRunCrush)) {
            runParam.setCurrentStep(this.getStepNum() + ":" + this.getStepDesc());
        }
        if (this.isRunStep(runParam)) {
            this.logBegin();
            ret = this.innerExecute(runParam);
            this.logEnd();
        }
        this.executeExtendStep(runParam);
        return ret;
    }

    private boolean isRunStep(MRPCalcParam runParam) throws BOSException, MRPException {
        StringBuffer sql = new StringBuffer();
        boolean isRun = true;
        sql.append("select FisRunStep from T_MM_MRPExtendStep where FExtendedClass = ?");
        IRowSet rs = SQLUtils.executeQuery((Context)runParam.getCtx(true), (String)sql.toString(), (Object[])new Object[]{this.getClass().getName()});
        try {
            if (rs.next()) {
                isRun = rs.getBoolean("FisRunStep");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return isRun;
    }

    private void executeExtendStep(MRPCalcParam runParam) throws BOSException, MRPException {
        block4: {
            StringBuffer sql = new StringBuffer();
            sql.append("select * from T_MM_MRPExtendStep where FExtendedClass = ?");
            IRowSet rs = SQLUtils.executeQuery((Context)runParam.getCtx(), (String)sql.toString(), (Object[])new Object[]{this.getClass().getName()});
            try {
                if (!rs.next()) break block4;
                logger.info((Object)(this.getClass().getName() + " extendStep start runnning"));
                int isMergeTransaction = 1;
                isMergeTransaction = rs.getInt("FisMergeTransaction");
                try {
                    Class<?> theClass = Class.forName(rs.getString("FExtendClass"));
                    Method m = theClass.getMethod("execute", MRPCalcParam.class);
                    m.invoke(theClass.newInstance(), runParam);
                    logger.info((Object)(this.getClass().getName() + " extendStep finish runnning"));
                }
                catch (Exception e) {
                    throw new MRPException(MRPException.CUST_DEP_ERROR, new Object[]{rs.getString("FExtendClass")});
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    protected void logBegin() throws BOSException, EASBizException {
        this.beginTime = new Date();
        if (logger.isInfoEnabled()) {
            this.beginTime = new Date();
        }
        if (this.logInfo != null) {
            StringBuffer sql = new StringBuffer();
            sql.append("update T_MM_MRPRunStepLog set FBeginTime = ? ,FStatus = ? where FID = ?");
            SQLUtils.execute((Context)this.runParam.getCtx(true), (String)sql.toString(), (Object[])new Object[]{new Timestamp(this.beginTime.getTime()), new Integer(40), this.logInfo.getId().toString()});
        }
    }

    protected void logEnd() throws BOSException, MRPException, EASBizException {
        this.endTime = new Date();
        BigDecimal e = new BigDecimal(String.valueOf(this.endTime.getTime()));
        BigDecimal b = new BigDecimal(String.valueOf(this.beginTime.getTime()));
        BigDecimal runSecs = e.subtract(b).divide(new BigDecimal("1000"), 2, 4);
        if (logger.isInfoEnabled()) {
            logger.info((Object)(this.runParam.getRunLogInfo().getNumber() + ":" + this.getStepNum() + ":" + this.getStepDesc() + "," + MRPResource.getString(this.runParam.getCtx(), "SYM_RUNTIMES") + "\uff1a" + String.valueOf(runSecs) + "s"));
        }
        if (this.logInfo != null) {
            BigDecimal min = runSecs.divide(new BigDecimal("60"), 2, 4);
            StringBuffer sql = new StringBuffer();
            sql.append("update T_MM_MRPRunStepLog set FEndTime = ?,FStatus = ?,FTime = ?,FName =?, ");
            sql.append("FDataAmount=? where FID = ?");
            SQLUtils.execute((Context)this.runParam.getCtx(true), (String)sql.toString(), (Object[])new Object[]{new Timestamp(this.endTime.getTime()), new Integer(20), min, this.logInfo.getName(), new BigDecimal(this.getDataAmount()), this.logInfo.getId().toString()});
        }
        if (this.isNeedUpdateProgress()) {
            MRPProgressUpdater.updateProgerss(this.runParam, this.getProgressPercent());
        }
        if (this.logInfo != null && this.runParam.getCtx().get((Object)"MRP_JOB_STATUS_FACADE") != null) {
            String jobId = (String)this.runParam.getCtx().get((Object)"MRP_JOB_INST_ID");
            int progress = MRPProgressUpdater.getProgress(this.runParam);
            IJobInstStatusFacade jobInstStatusFacade = (IJobInstStatusFacade)this.runParam.getCtx().get((Object)"MRP_JOB_STATUS_FACADE");
            jobInstStatusFacade.updateProgress(jobId, progress, this.logInfo.getName(), this.logInfo.getName(), this.logInfo.getName());
        }
    }

    public void logInfo(String msg) {
        if (logger.isInfoEnabled()) {
            logger.info((Object)(this.runParam.getRunLogInfo().getNumber() + ":" + msg));
        }
    }

    protected abstract boolean isNeedUpdateProgress();

    protected int getProgressPercent() {
        return this.progressPercent;
    }

    protected String getStepNum() {
        return this.stepNum;
    }

    protected String getStepDesc() throws BOSException, EASBizException {
        return this.getStepDesc(this.runParam);
    }

    protected abstract String getStepDesc(MRPCalcParam var1) throws BOSException, EASBizException;

    protected abstract Object innerExecute(MRPCalcParam var1) throws EASBizException, BOSException;

    private String getClassSimpleName() {
        String[] nameArray = this.getClass().getName().split("\\.");
        if (nameArray.length > 0) {
            return nameArray[nameArray.length - 1];
        }
        return "";
    }

    public List getSubSteps(MRPCalcParam runParam) {
        return null;
    }

    public MRPRunStepLogInfo createLogInfo(MRPCalcParam runParam, MRPRunStepLogInfo parent, int numSeq) throws EASBizException, BOSException {
        this.logInfo = new MRPRunStepLogInfo();
        this.logInfo.setId(BOSUuid.create((String)"917A7403"));
        this.logInfo.setName(this.getStepDesc(runParam));
        this.logInfo.setSeq(numSeq);
        this.logInfo.setParent(runParam.getRunLogInfo());
        if (parent != null) {
            this.logInfo.setParentStep(parent);
            this.logInfo.setLevel(parent.getLevel() + 1);
            int childSeq = parent.getChildSeq() + 1;
            this.stepNum = parent.getStepNum() + "." + String.valueOf(childSeq);
            this.logInfo.setStepNum(this.stepNum);
            parent.setChildSeq(childSeq);
            int numSeq1 = this.logInfo.getSeq();
            numSeq1 = this.logInfo.getLevel() == 2 ? (numSeq1 += childSeq * 10000) : (this.logInfo.getLevel() == 3 ? (numSeq1 += childSeq * 100) : (numSeq1 += childSeq));
            this.logInfo.setSeq(numSeq1);
        } else {
            this.logInfo.setSeq(numSeq * 1000000);
            this.logInfo.setStepNum(String.valueOf(numSeq));
            this.logInfo.setChildSeq(0);
            this.logInfo.setLevel(1);
        }
        this.logInfo.setStatus(MRPStepStatusEnum.NULL);
        this.insertStepLog(runParam, this.logInfo);
        List subStepList = this.getSubSteps(runParam);
        if (subStepList != null) {
            int stepIndex = this.logInfo.getSeq() + 1;
            for (int i = 0; i < subStepList.size(); ++i) {
                MRPStep step = (MRPStep)subStepList.get(i);
                step.createLogInfo(runParam, this.logInfo, stepIndex++);
            }
        }
        return this.logInfo;
    }

    private void insertStepLog(MRPCalcParam runParam, MRPRunStepLogInfo log) throws BOSException, MRPException {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into T_MM_MRPRunStepLog (FID,FName,FParentID,FParentStepID,FLevel,FStatus,");
        sql.append("FStepNum,FChildSeq,FSeq) ");
        sql.append("values (?,?,?,?,?,?,?,?,?) ");
        Object[] param = new Object[9];
        int index = 0;
        param[index++] = log.getId().toString();
        param[index++] = log.getName();
        param[index++] = log.getParent() != null ? log.getParent().getId().toString() : "";
        param[index++] = log.getParentStep() != null ? log.getParentStep().getId().toString() : "";
        param[index++] = new Integer(log.getLevel());
        param[index++] = new Integer(log.getStatus().getValue());
        param[index++] = log.getStepNum();
        param[index++] = new Integer(log.getChildSeq());
        param[index++] = new Integer(log.getSeq());
        SQLUtils.execute((Context)runParam.getCtx(), (String)sql.toString(), (Object[])param);
    }

    protected void initMRPBillParam(MRPCalcParam runParam) {
        if (runParam.getPlanType().equals((Object)MrpRunEnum.COOPERATE_PLAN)) {
            this.initMRPBillParam4Cooperate(runParam);
            return;
        }
        HashMap<String, MRPBillParamInfo> billParamMap = new HashMap<String, MRPBillParamInfo>();
        for (int i = 0; i < runParam.getPlanVersion().getBillParam().size(); ++i) {
            PlanVersionSetBillsInfo billInfo = runParam.getPlanVersion().getBillParam().get(i);
            BOSUuid uuid = billInfo.getBillType().getId();
            MRPBillParamInfo info = new MRPBillParamInfo();
            info.setBillTypeID(billInfo.getBillType().getId().toString());
            info.setPriority(billInfo.getPriority());
            info.setAdjust(false);
            info.setParticipate(billInfo.isIsParticipation());
            if (!MMUtils.isEmptyString((String)billInfo.getBizTypeBill())) {
                info.setBizTypeIdArray(billInfo.getBizTypeBill().split("#"));
            }
            for (int j = 0; j < runParam.getPlanVersion().getReCompParam().size(); ++j) {
                PlanVersionSetReCompositionInfo comInfo = runParam.getPlanVersion().getReCompParam().get(j);
                if (!uuid.equals((Object)comInfo.getBillType().getId())) continue;
                info.setAdjust(comInfo.isIsAdjust());
                info.setAdjustStrategy(comInfo.getAdjustStrategy());
                break;
            }
            billParamMap.put(uuid.toString(), info);
        }
        runParam.setBillParamMap(billParamMap);
    }

    protected void initMRPBillParam4Cooperate(MRPCalcParam runParam) {
        HashMap<String, MRPBillParamInfo> billParamMap = new HashMap<String, MRPBillParamInfo>();
        for (int i = 0; i < runParam.getCPlanVersion().getEntrys().get(0).getBillParam().size(); ++i) {
            CollaPlanVersionSetBillsInfo billInfo = runParam.getCPlanVersion().getEntrys().get(0).getBillParam().get(i);
            BOSUuid uuid = billInfo.getBillType().getId();
            if (!billInfo.isIsParticipation()) continue;
            MRPBillParamInfo info = new MRPBillParamInfo();
            info.setBillTypeID(billInfo.getBillType().getId().toString());
            info.setPriority(billInfo.getPriority());
            if (!MMUtils.isEmptyString((String)billInfo.getBizTypeBill())) {
                info.setBizTypeIdArray(billInfo.getBizTypeBill().split("#"));
            }
            billParamMap.put(uuid.toString(), info);
        }
        runParam.setBillParamMap(billParamMap);
    }

    public MRPRunStepLogInfo getLogInfo() {
        return this.logInfo;
    }

    public void setStepNum(String stepNum) {
        this.stepNum = stepNum;
    }

    public void setProgressPercent(int progressPercent) {
        this.progressPercent = progressPercent;
    }
}

