/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.app.mrp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.material.IsolatedRuleEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.basedata.GetSubstitueMaterial;
import com.kingdee.eas.mm.basedata.MaterialReplaceDetailVO;
import com.kingdee.eas.mm.basedata.MaterialReplaceExceptionMessageEnum;
import com.kingdee.eas.mm.basedata.MaterialReplaceParam;
import com.kingdee.eas.mm.basedata.MaterialReplaceVO;
import com.kingdee.eas.mm.basedata.ReplaceMaterailVO;
import com.kingdee.eas.mm.basedata.app.CalculateMaterialReplace;
import com.kingdee.eas.mm.common.app.SQLUtils;
import com.kingdee.eas.mm.common.util.SQLUtil;
import com.kingdee.eas.mm.planning.MRPClassifyEnum;
import com.kingdee.eas.mm.planning.MRPElementEnum;
import com.kingdee.eas.mm.planning.MRPException;
import com.kingdee.eas.mm.planning.RequirementUniteRuleInfo;
import com.kingdee.eas.mm.planning.app.ReqPlanForMRP;
import com.kingdee.eas.mm.planning.app.mrp.MRPAjustMent;
import com.kingdee.eas.mm.planning.app.mrp.MRPCalcParam;
import com.kingdee.eas.mm.planning.app.mrp.MRPConstant;
import com.kingdee.eas.mm.planning.app.mrp.MRPDate;
import com.kingdee.eas.mm.planning.app.mrp.MRPDetailInfo;
import com.kingdee.eas.mm.planning.app.mrp.MRPMaterialDataInfo;
import com.kingdee.eas.mm.planning.app.mrp.MRPMaterialStatisticsInfo;
import com.kingdee.eas.mm.planning.app.mrp.MRPPlanStrategyUtil;
import com.kingdee.eas.mm.planning.app.mrp.MRPSeqUtil;
import com.kingdee.eas.mm.planning.app.mrp.MRPSubstituteHelper;
import com.kingdee.eas.mm.planning.app.mrp.MRPSubstituteRedoAjustMent;
import com.kingdee.eas.mm.planning.app.mrp.MRPUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class MRPSubstituteAjustMent
extends MRPAjustMent {
    protected static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.planning.app.mrp.MRPSubstituteAjustMent");
    private MRPSubstituteHelper substituteHelper;
    private List existedEntries;
    private List subToList;
    private List newEntries;

    public MRPSubstituteAjustMent(List materialIDLst, MRPCalcParam runParam) throws MRPException, BOSException {
        super(materialIDLst, runParam);
        if (isMoreInfo.booleanValue()) {
            logger.setLevel(Level.INFO);
        } else {
            logger.setLevel(Level.ERROR);
        }
        this.substituteHelper = null;
        this.existedEntries = new ArrayList();
        this.subToList = new ArrayList();
        this.newEntries = new ArrayList();
        this.substituteHelper = runParam.getSubstituteHelper();
    }

    @Override
    protected String getStepNum() {
        return "60.025";
    }

    @Override
    protected void cycCalc() throws BOSException, EASBizException {
        ArrayList subList = new ArrayList();
        this.subToList.clear();
        List temp = null;
        for (int i = 0; i < this.materialIDLst.size(); ++i) {
            temp = (List)this.materialIDLst.get(i);
            subList.addAll(temp);
            if (i <= 0) continue;
            this.subToList.addAll(temp);
        }
        this.materialIDLst = subList;
        StringBuffer bakSql = new StringBuffer();
        try {
            boolean flag = MRPSubstituteAjustMent.isTableExists(this.runParam.getCtx());
            if (flag) {
                bakSql.append("drop table BACKUPTABLE");
                DbUtil.execute((Context)this.runParam.getCtx(), (String)bakSql.toString());
            }
            bakSql.setLength(0);
            bakSql.append("select * into BACKUPTABLE from ");
            bakSql.append(this.runParam.getMrpCalcDetailTableName());
            bakSql.append(" where fmaterialid in (");
            bakSql.append(this.listToStringBuffer(subList));
            bakSql.append(") and frunlogid = '");
            bakSql.append(this.runParam.getRunLogID());
            bakSql.append("'");
            DbUtil.execute((Context)this.runParam.getCtx(), (String)bakSql.toString());
        }
        catch (SQLException e) {
            logger.info((Object)"substitute material backup fail");
            throw new BOSException(e.getCause());
        }
        if (this.runParam.getPlanVersion().getRequirementUniteRule() == null) {
            this.materiaDataUtil.fetchCorrelativeReqType(this.runParam, this.materialIDLst);
        }
        super.cycCalc();
        try {
            bakSql.setLength(0);
            bakSql.append("INSERT INTO BACKUPTABLE ");
            bakSql.append(" select * from ");
            bakSql.append(this.runParam.getMrpCalcDetailTableName());
            bakSql.append(" where fmaterialid in (");
            bakSql.append(this.listToStringBuffer(subList));
            bakSql.append(") and frunlogid = '");
            bakSql.append(this.runParam.getRunLogID());
            bakSql.append("'");
            bakSql.append(" and FMRPITEM = 380");
            bakSql.append(" and FMRPClassify = 30");
            DbUtil.execute((Context)this.runParam.getCtx(), (String)bakSql.toString());
            bakSql.setLength(0);
            bakSql.append("delete from BACKUPTABLE t ");
            bakSql.append(" where not exists(select 1 from BACKUPTABLE t1 where t1.fmaterialid = t.fmaterialid  ");
            bakSql.append(" and t1.FMRPITEM = 380)");
            DbUtil.execute((Context)this.runParam.getCtx(), (String)bakSql.toString());
            ArrayList<String> reCalcList = new ArrayList<String>();
            bakSql.setLength(0);
            bakSql.append("select fmaterialid from BACKUPTABLE");
            IRowSet result = DbUtil.executeQuery((Context)this.runParam.getCtx(), (String)bakSql.toString());
            while (result.next()) {
                String fmaterialid = result.getString("fmaterialid");
                reCalcList.add(fmaterialid);
            }
            if (reCalcList.size() > 0) {
                bakSql.setLength(0);
                bakSql.append("delete from ");
                bakSql.append(this.runParam.getMrpCalcDetailTableName());
                bakSql.append(" where fmaterialid in (");
                bakSql.append("select fmaterialid from BACKUPTABLE");
                bakSql.append(") and frunlogid = '");
                bakSql.append(this.runParam.getRunLogID());
                bakSql.append("'");
                DbUtil.execute((Context)this.runParam.getCtx(), (String)bakSql.toString());
                bakSql.setLength(0);
                bakSql.append("INSERT INTO  ");
                bakSql.append(this.runParam.getMrpCalcDetailTableName());
                bakSql.append(" select * from BACKUPTABLE");
                DbUtil.execute((Context)this.runParam.getCtx(), (String)bakSql.toString());
                this.dataSaver.executeRemovePlannedOrder(reCalcList);
                this.daysStatistics(this.runParam);
                MRPSubstituteRedoAjustMent redo = new MRPSubstituteRedoAjustMent(reCalcList, this.runParam);
                redo.call();
            }
        }
        catch (Exception e) {
            logger.info((Object)"substitute material redo fail");
            throw new BOSException(e.getCause());
        }
        finally {
            bakSql.setLength(0);
            try {
                boolean flag = MRPSubstituteAjustMent.isTableExists(this.runParam.getCtx());
                if (flag) {
                    bakSql.append("drop table BACKUPTABLE");
                    DbUtil.execute((Context)this.runParam.getCtx(), (String)bakSql.toString());
                }
            }
            catch (SQLException e) {
                logger.info((Object)"substitute material backup table drop fail");
            }
        }
        this.dataSaver.executeInsertPlannedOrder();
        this.dataSaver.executeUpdatePlannedOrder();
        this.updateComReq();
    }

    private void daysStatistics(MRPCalcParam runParam) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("delete from ").append(runParam.getStatisticsTable()).append(" where FMaterialID in (").append("select fmaterialid from BACKUPTABLE").append(")");
        DbUtil.execute((Context)runParam.getCtx(), (String)sql.toString());
        sql.setLength(0);
        sql.append("Insert into ").append(runParam.getStatisticsTable()).append(" ( KSQL_SEQ,FID,FMaterialId, FPlanStrategy, FPeriod, FProjectNumber, FTrackNumber, FSQty,FRQty,").append(" FDetailcount,FIsDefaultTNO,FSubstituteGroup,FCalcSeq,FMaterialNumber,FSurplusQty) ").append("select ").append("newbosid('").append("F94043EF").append("'), ").append("d.FMaterialId, m.FPlanStrategy, d.FPeriod, d.FProjectNumber, d.FTrackNumber,  sum(d.fsr) ").append(",sum(case when m.FIsSurplusDivert=1 and d.fmrpitem=120 then 0 else d.FIndependent+ d.FDependent end)").append(",count(1),d.FIsDefaultTNO,m.FSubstituteGroup,m.FCalcSeq,m.FMaterialNumber,\n ").append("sum(d.fsr) + sum(case when m.FIsSurplusDivert=1 and d.fmrpitem=120 then 0 else d.FIndependent+ d.FDependent end) ").append("\n from ").append(runParam.getMrpCalcDetailTableName()).append(" d ").append("inner join ").append(runParam.getMaterialTableName()).append(" m on d.FMaterialId = m.FMaterialId ").append("where m.FMaterialID in (").append("select fmaterialid from BACKUPTABLE").append(")").append(" and  m.FRunLogID = ? and d.FSupplyType<10930 ").append("and d.FMRPItem<>").append(110).append(" group by d.FPeriod,m.FSubstituteGroup,m.FCalcSeq,d.FMaterialId ,m.FPlanStrategy, m.FMaterialNumber, ").append(" d.FProjectNumber,d.FTrackNumber ,d.FIsDefaultTNO ").append(" order by d.FPeriod,m.FSubstituteGroup,m.FCalcSeq,m.FMaterialNumber,d.FProjectNumber,d.FIsDefaultTNO,d.FTrackNumber");
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(runParam.getRunLogID());
        MRPUtil.executeUpdate(runParam.getCtx(), sql.toString(), paramList.toArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isTableExists(Context ctx) throws SQLException {
        boolean bl;
        String sql = "select 1 from KSQL_USERTABLES  WHERE KSQL_TABNAME = ? ";
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, "BACKUPTABLE");
            rs = pstmt.executeQuery();
            bl = rs.next();
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs, pstmt, (Connection)conn);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        return bl;
    }

    private StringBuffer listToStringBuffer(List allIDs) {
        StringBuffer ids = new StringBuffer();
        for (String id : allIDs) {
            ids.append("'");
            ids.append(id);
            ids.append("'");
            ids.append(",");
        }
        ids = ids.replace(ids.length() - 1, ids.length(), "");
        return ids;
    }

    @Override
    protected BigDecimal cancelBill(MRPMaterialDataInfo materialDataInfo, MRPDetailInfo detailInfo, BigDecimal delayQty) throws BOSException, EASBizException {
        if (this.subToList.contains(materialDataInfo.getMaterialID())) {
            return MRPConstant.ZERO;
        }
        return super.cancelBill(materialDataInfo, detailInfo, delayQty);
    }

    @Override
    protected void doSubstitute(MRPMaterialDataInfo materialDataInfo, MRPMaterialStatisticsInfo statisticsInfo, MRPDetailInfo detailInfo, BigDecimal pab_t_1, int period) throws EASBizException, BOSException {
        Map poEntryInfo = this.substituteHelper.getSrcPOEntryInfo(detailInfo);
        if (this.isCannotSubstitute(poEntryInfo)) {
            return;
        }
        MaterialReplaceParam param = this.createReplaceParam(materialDataInfo, detailInfo, statisticsInfo, pab_t_1, poEntryInfo);
        CalculateMaterialReplace replaceCmd = new CalculateMaterialReplace(this.runParam.getCtx());
        MaterialReplaceDetailVO replaceDetail = (MaterialReplaceDetailVO)replaceCmd.execute((Object)param);
        if (!replaceDetail.getExceptionMessage().equals((Object)MaterialReplaceExceptionMessageEnum.SUCCESS)) {
            logger.info((Object)("material: " + materialDataInfo.getMaterialNumber() + " " + replaceDetail.getExceptionMessage().getAlias()));
            return;
        }
        this.preProcess(replaceDetail);
        this.setOriginMaterialInfo((MaterialReplaceVO)replaceDetail, materialDataInfo, poEntryInfo);
        this.updateOriginMaterialData(statisticsInfo, (MaterialReplaceVO)replaceDetail, detailInfo, materialDataInfo, period);
        this.updateSubstituteMaterialData((MaterialReplaceVO)replaceDetail, detailInfo, period);
        if (this.isCombinationReplace(replaceDetail)) {
            this.doCombinationReplace(detailInfo, replaceDetail, period);
        }
        detailInfo.setNetReqQty(pab_t_1.add(replaceDetail.getOriginMaterialBaseQty()));
        this.dataSaver.executeInsertS();
        this.dataSaver.execute(true);
    }

    @Override
    protected boolean isNotTrackNoIsolation(String planStrategy, IsolatedRuleEnum isolationRule, MRPDetailInfo newDetailInfo) {
        return !MRPPlanStrategyUtil.isTrackNoIsolation(planStrategy, isolationRule) && newDetailInfo.getMrpItem() != MRPElementEnum.R_SUBSTITUTE;
    }

    private void updateOriginMaterialData(MRPMaterialStatisticsInfo statisticsInfo, MaterialReplaceVO replaceDetail, MRPDetailInfo reqDetail, MRPMaterialDataInfo materialDataInfo, int period) throws EASBizException, BOSException {
        this.updateReqDetail(replaceDetail, reqDetail);
        this.updateOriginMaterialStatistics(statisticsInfo, replaceDetail);
        this.insertSupplyDetail(replaceDetail, reqDetail, materialDataInfo, statisticsInfo);
        if (this.runParam.isModifyOrder()) {
            this.updatePlanOrderEntry(replaceDetail, reqDetail);
        }
    }

    private void updateSubstituteMaterialData(MaterialReplaceVO replaceDetail, MRPDetailInfo reqDetail, int period) throws EASBizException, BOSException {
        this.insertReqDetail(replaceDetail, reqDetail);
        this.updateSubstituteMaterialStatistics(replaceDetail, reqDetail);
    }

    private void doCombinationReplace(MRPDetailInfo reqDetail, MaterialReplaceDetailVO replaceDetail, int period) throws EASBizException, BOSException {
        List combinations = replaceDetail.getCombinations();
        MaterialReplaceVO unKeyMaterialDetail = null;
        MRPMaterialDataInfo unKeyMaterialInfo = null;
        MRPMaterialStatisticsInfo unKeyMaterialStatistics = null;
        MRPDetailInfo unKeyReqDetail = null;
        Map poEntryInfo = null;
        if (this.isUnkeyMaterialCanReplace(combinations)) {
            for (int i = 0; i < combinations.size(); ++i) {
                unKeyMaterialDetail = (MaterialReplaceVO)combinations.get(i);
                unKeyMaterialInfo = this.getMaterialDataInfo(unKeyMaterialDetail.getOriginMaterialId());
                unKeyReqDetail = this.detailDataUtil.getDetailInfo(this.runParam, unKeyMaterialDetail.getOriginMaterialId(), period, reqDetail.getBillID());
                if (unKeyReqDetail == null) continue;
                unKeyMaterialStatistics = this.materiaDataUtil.getStatisticsInfo(unKeyMaterialInfo.getMaterialID(), period, unKeyReqDetail.getProjectNumber(), unKeyReqDetail.getTrackNumber());
                poEntryInfo = this.substituteHelper.getSrcPOEntryInfo(unKeyReqDetail);
                this.setOriginMaterialInfo(unKeyMaterialDetail, unKeyMaterialInfo, poEntryInfo);
                this.updateOriginMaterialData(unKeyMaterialStatistics, unKeyMaterialDetail, unKeyReqDetail, unKeyMaterialInfo, period);
                this.updateSubstituteMaterialData(unKeyMaterialDetail, unKeyReqDetail, period);
            }
        }
    }

    private void updatePlanOrderEntry(MaterialReplaceVO replaceDetail, MRPDetailInfo reqDetail) throws EASBizException, BOSException {
        reqDetail.setIsReplaced(1);
        reqDetail.setStandardQty(replaceDetail.getOriginMaterialStandardQty());
        if (reqDetail.isNewOrder()) {
            this.dataSaver.addUpdateList(reqDetail);
            this.dataSaver.addMrpPlanOrderEntryU(reqDetail);
            if (!this.newEntries.contains(reqDetail.getBillEntryID())) {
                this.newEntries.add(reqDetail.getBillEntryID());
            }
        } else {
            this.dataSaver.addUpdatePLannedList(reqDetail);
            if (!this.existedEntries.contains(reqDetail.getBillEntryID())) {
                this.existedEntries.add(reqDetail.getBillEntryID());
            }
        }
    }

    private void updateReqDetail(MaterialReplaceVO replaceDetail, MRPDetailInfo reqDetail) {
        reqDetail.setAvaliableQty(replaceDetail.getOriMtlDemandBaseQty());
        reqDetail.setAvailableBalanceQty(replaceDetail.getOriginMaterialQty());
        reqDetail.setPlannedSubQty(replaceDetail.getOriMtlDemandQty());
    }

    private void setOriginMaterialInfo(MaterialReplaceVO replaceDetail, MRPMaterialDataInfo materialDataInfo, Map poEntryInfo) {
        BigDecimal standardBaseQty = replaceDetail.getOriginMaterialStandardBaseQty();
        BigDecimal scrapRate = (BigDecimal)poEntryInfo.get("scrapRate");
        int scrapExp = (Integer)poEntryInfo.get("scrapRateExpression");
        replaceDetail.setOriginMaterialStandardQty(MRPUtil.calculateProdQty(standardBaseQty, materialDataInfo));
        replaceDetail.setOriginMaterialBaseQty(MRPUtil.calculateDemandQty(standardBaseQty, scrapRate, scrapExp, materialDataInfo.getBaseQtyPrc(), this.runParam.isWastageRate()));
        replaceDetail.setOriginMaterialQty(MRPUtil.calculateProdQty(replaceDetail.getOriginMaterialBaseQty(), materialDataInfo));
        replaceDetail.setOriMtlDemandBaseQty(MRPUtil.calculateDemandQty(standardBaseQty, scrapRate, scrapExp, materialDataInfo.getBaseQtyPrc(), true));
        replaceDetail.setOriMtlDemandQty(MRPUtil.calculateProdQty(replaceDetail.getOriMtlDemandBaseQty(), materialDataInfo));
    }

    private void updateOriginMaterialStatistics(MRPMaterialStatisticsInfo statisticsInfo, MaterialReplaceVO replaceDetail) {
        BigDecimal suppliedBaseQty = replaceDetail.getOriginMaterialBaseQty();
        statisticsInfo.setSQty(statisticsInfo.getSQty().add(suppliedBaseQty));
    }

    private void updateSubstituteMaterialStatistics(MaterialReplaceVO replaceDetail, MRPDetailInfo reqDetail) throws BOSException, EASBizException {
        MRPMaterialStatisticsInfo replaceMaterialStatistics = null;
        ReplaceMaterailVO supply = null;
        List supplies = replaceDetail.getReplaceSupplies();
        for (int i = 0; i < supplies.size(); ++i) {
            supply = (ReplaceMaterailVO)supplies.get(i);
            replaceMaterialStatistics = this.materiaDataUtil.getStatisticsInfo(supply.getReplaceMaterailID(), reqDetail.getPeriod(), reqDetail.getProjectNumber(), reqDetail.getTrackNumber());
            replaceMaterialStatistics.setRQty(replaceMaterialStatistics.getRQty().add(supply.getReplaceBaseQty().negate()));
        }
    }

    private void insertSupplyDetail(MaterialReplaceVO replaceDetail, MRPDetailInfo reqDetail, MRPMaterialDataInfo materialDataInfo, MRPMaterialStatisticsInfo statisticsInfo) throws EASBizException, BOSException {
        List supplies = replaceDetail.getReplaceSupplies();
        ReplaceMaterailVO supply = null;
        MRPDetailInfo supplyDetail = null;
        MRPMaterialDataInfo supplyMaterial = null;
        BigDecimal originMtlBaseQty = null;
        if (replaceDetail.isPriorityReplace()) {
            int i;
            ArrayList<Integer> priorities = new ArrayList<Integer>();
            int priority = -1;
            StringBuffer materialNumber = null;
            for (i = 0; i < supplies.size(); ++i) {
                supply = (ReplaceMaterailVO)supplies.get(i);
                priority = supply.getPriority();
                if (priorities.contains(new Integer(priority))) continue;
                priorities.add(new Integer(priority));
            }
            for (i = 0; i < priorities.size(); ++i) {
                materialNumber = new StringBuffer();
                originMtlBaseQty = null;
                for (int j = 0; j < supplies.size(); ++j) {
                    supply = (ReplaceMaterailVO)supplies.get(j);
                    if (!new Integer(supply.getPriority()).equals(priorities.get(i))) continue;
                    supplyMaterial = this.getMaterialDataInfo(supply.getReplaceMaterailID());
                    if (originMtlBaseQty == null) {
                        originMtlBaseQty = supply.getqty();
                    } else {
                        materialNumber.append(",");
                    }
                    materialNumber.append(supplyMaterial.getMaterialNumber());
                }
                supplyDetail = this.createSupplyDetail(originMtlBaseQty, materialNumber.toString(), reqDetail, materialDataInfo);
                this.addDetailInfo(supplyDetail, statisticsInfo);
            }
        } else {
            for (int i = 0; i < supplies.size(); ++i) {
                supply = (ReplaceMaterailVO)supplies.get(i);
                supplyMaterial = this.getMaterialDataInfo(supply.getReplaceMaterailID());
                supplyDetail = this.createSupplyDetail(supply.getqty(), supplyMaterial.getMaterialNumber(), reqDetail, materialDataInfo);
                this.addDetailInfo(supplyDetail, statisticsInfo);
            }
        }
    }

    private MRPDetailInfo createSupplyDetail(BigDecimal prtOriginBaseQty, String appendMaterialNumber, MRPDetailInfo reqDetail, MRPMaterialDataInfo materialDataInfo) throws BOSException {
        MRPDetailInfo detailInfo = new MRPDetailInfo();
        detailInfo.setID(BOSUuid.create((String)"F94043EF").toString());
        detailInfo.setMaterialID(reqDetail.getMaterialID());
        detailInfo.setPlanningMode(materialDataInfo.getPlanningMode());
        detailInfo.setMrpClassify(MRPClassifyEnum.Supply);
        detailInfo.setMrpItem(MRPElementEnum.S_SUBSTITUTE);
        detailInfo.setPlanBeginDate(new MRPDate());
        detailInfo.setPlanEndDate(new MRPDate());
        detailInfo.setProjectNumber(reqDetail.getProjectNumber());
        detailInfo.setTrackNumber(reqDetail.getTrackNumber());
        detailInfo.setBProjectNumber(reqDetail.getBProjectNumber());
        detailInfo.setBTrackNumber(reqDetail.getBTrackNumber());
        detailInfo.setBTrackID(reqDetail.getBTrackID());
        detailInfo.setBProjectID(reqDetail.getBProjectID());
        detailInfo.setProjectID(reqDetail.getProjectID());
        detailInfo.setTrackID(reqDetail.getTrackID());
        detailInfo.setBillDate(reqDetail.getBillDate());
        detailInfo.setPeriod(reqDetail.getPeriod());
        detailInfo.setBillID(reqDetail.getBillID());
        detailInfo.setIsDeaultTNO(reqDetail.getIsDeaultTNO());
        detailInfo.setUnitQty(reqDetail.getUnitQty());
        detailInfo.setReplaceID(reqDetail.getReplaceID());
        detailInfo.setReplaceEntryID(reqDetail.getReplaceEntryID());
        Map poEntryInfo = this.substituteHelper.getSrcPOEntryInfo(reqDetail);
        BigDecimal scrapRate = (BigDecimal)poEntryInfo.get("scrapRate");
        int scrapExp = (Integer)poEntryInfo.get("scrapRateExpression");
        detailInfo.setScheduledReceiptQty(MRPUtil.calculateDemandQty(prtOriginBaseQty, scrapRate, scrapExp, materialDataInfo.getBaseQtyPrc(), this.runParam.isWastageRate()));
        detailInfo.setBillNumber(reqDetail.getBillNumber() + "/" + appendMaterialNumber);
        ++this.advace_seq;
        detailInfo.setPriority(0);
        detailInfo.setMrpSeq(MRPSeqUtil.getMRPSeq(detailInfo));
        if (this.runParam.getExceptionUtil().setException(detailInfo, 50)) {
            this.statisticException(materialDataInfo);
        }
        return detailInfo;
    }

    private void insertReqDetail(MaterialReplaceVO replaceDetail, MRPDetailInfo reqDetail) throws EASBizException, BOSException {
        List supplies = replaceDetail.getReplaceSupplies();
        ReplaceMaterailVO supply = null;
        MRPMaterialDataInfo replaceMaterialInfo = null;
        MRPDetailInfo replaceReqDetail = null;
        MRPDetailInfo replaceEntry = null;
        Map poEntryInfo = null;
        int entrySeq = 0;
        for (int i = 0; i < supplies.size(); ++i) {
            supply = (ReplaceMaterailVO)supplies.get(i);
            replaceMaterialInfo = this.getMaterialDataInfo(supply.getReplaceMaterailID());
            replaceReqDetail = this.createReqDetail(replaceDetail, reqDetail, supply, replaceMaterialInfo);
            entrySeq = i + 1;
            if (this.runParam.isModifyOrder() && reqDetail.getMrpItem().equals((Object)MRPElementEnum.R_PlannedOrder)) {
                replaceEntry = (MRPDetailInfo)replaceReqDetail.clone();
                replaceEntry.setNetReqQty(replaceReqDetail.getIndependentQty().divide(replaceMaterialInfo.getConvertRate(), replaceMaterialInfo.getProdQtyPrc(), 2));
                poEntryInfo = this.substituteHelper.getSrcPOEntryInfo(reqDetail);
                if (poEntryInfo.get("lineSeq") == null) {
                    this.substituteHelper.initSrcPOEntrySeq(reqDetail);
                    poEntryInfo = this.substituteHelper.getSrcPOEntryInfo(reqDetail);
                }
                replaceEntry.setLineSeq((String)poEntryInfo.get("lineSeq") + "-" + entrySeq);
                this.dataSaver.addMrpPlanOrder(replaceEntry);
                if (reqDetail.isNewOrder()) {
                    if (!this.newEntries.contains(replaceEntry.getBillEntryID())) {
                        this.newEntries.add(replaceEntry.getBillEntryID());
                    }
                } else if (!this.existedEntries.contains(replaceEntry.getBillEntryID())) {
                    this.existedEntries.add(replaceEntry.getBillEntryID());
                }
            }
            replaceReqDetail.setIndependentQty(MRPConstant.ZERO);
            this.addDetailInfo(replaceReqDetail, null);
        }
    }

    private MRPDetailInfo createReqDetail(MaterialReplaceVO replaceDetail, MRPDetailInfo reqDetail, ReplaceMaterailVO supply, MRPMaterialDataInfo materialDataInfo) throws BOSException, EASBizException {
        MRPMaterialStatisticsInfo statistics = this.materiaDataUtil.getStatisticsInfo(supply.getReplaceMaterailID(), reqDetail.getPeriod(), reqDetail.getProjectNumber(), reqDetail.getTrackNumber());
        MRPMaterialDataInfo originMaterial = this.getMaterialDataInfo(supply.getRawMaterailID());
        MRPDetailInfo detailInfo = new MRPDetailInfo();
        detailInfo.setID(BOSUuid.create((String)"F94043EF").toString());
        detailInfo.setBillNumber(reqDetail.getBillNumber() + "/" + originMaterial.getMaterialNumber());
        detailInfo.setBillID(reqDetail.getBillID());
        detailInfo.setMaterialSubsID(supply.getRawMaterailID());
        detailInfo.setUnitQty(supply.getReplaceUnitQty());
        detailInfo.setReplaceID(supply.getReplaceID());
        detailInfo.setReplaceEntryID(supply.getMaterialReplaceEntryInfo().getId().toString());
        detailInfo.setSupplyStorageOrgUnitID(supply.getSupplyOrgUnit().getId().toString());
        detailInfo.setSupplyType(supply.getProvideType().getValue());
        detailInfo.setIssMode(supply.getIssMode());
        detailInfo.setDefaultWarehouseID(supply.getDefaultWarehouseID());
        detailInfo.setLocationID(supply.getLocationID());
        detailInfo.setTransferOrgUnitID(supply.getTransferOrgUnitID());
        detailInfo.setTransferWarehouseID(supply.getTransferWarehouseID());
        detailInfo.setIsBackFlush(supply.getIsBackFlush());
        detailInfo.setIsStockTransfer(supply.getIsStockTransfer());
        detailInfo.setReplaceMode(supply.getReplaceMode().getValue());
        detailInfo.setReplacePriority(supply.getPriority());
        detailInfo.setScrapRate(supply.getScrapRate());
        detailInfo.setIsReplaced(1);
        detailInfo.setMaterialID(materialDataInfo.getMaterialID());
        detailInfo.setPlanningMode(materialDataInfo.getPlanningMode());
        detailInfo.setMrpClassify(MRPClassifyEnum.Requirement);
        detailInfo.setMrpItem(MRPElementEnum.R_SUBSTITUTE);
        detailInfo.setPlanBeginDate(new MRPDate());
        detailInfo.setPlanEndDate(new MRPDate());
        detailInfo.setProjectNumber(reqDetail.getProjectNumber());
        detailInfo.setTrackNumber(reqDetail.getTrackNumber());
        detailInfo.setProjectID(reqDetail.getProjectID());
        detailInfo.setTrackID(reqDetail.getTrackID());
        detailInfo.setBillDate(reqDetail.getBillDate());
        detailInfo.setPeriod(reqDetail.getPeriod());
        detailInfo.setIsDeaultTNO(statistics.getIsDeaultTNO());
        detailInfo.setBaseUnitID(materialDataInfo.getBaseUnitID());
        detailInfo.setProdUnitID(materialDataInfo.getProdUnitID());
        detailInfo.setBillEntryID(BOSUuid.create((String)"CE85FF93").toString());
        detailInfo.setParentID(reqDetail.getBillID());
        detailInfo.setOriginStandardQty(supply.getProductUnitQty());
        String subMaterialId = materialDataInfo.getMaterialID();
        Map subEntry = this.substituteHelper.getMaterialPlanInfos(new String[]{subMaterialId});
        BigDecimal subScrapRate = (BigDecimal)subEntry.get(subMaterialId + "scrapRate");
        int subScrapExp = (Integer)subEntry.get(subMaterialId + "scrapRateExpression");
        BigDecimal subDemandQty = MRPUtil.calculateDemandQty(supply.getReplaceQty(), subScrapRate, subScrapExp, materialDataInfo.getProdQtyPrc(), true);
        detailInfo.setStandardQty(supply.getReplaceQty());
        detailInfo.setScrapQty(subDemandQty.subtract(supply.getReplaceQty()));
        BigDecimal subBaseDemandQty = subDemandQty.multiply(materialDataInfo.getConvertRate()).setScale(materialDataInfo.getBaseQtyPrc(), 2);
        if (this.runParam.isWastageRate()) {
            detailInfo.setDependentQty(subBaseDemandQty.negate());
        } else {
            BigDecimal baseStandardQty = detailInfo.getStandardQty().multiply(materialDataInfo.getConvertRate()).setScale(materialDataInfo.getBaseQtyPrc(), 2);
            detailInfo.setDependentQty(baseStandardQty.negate());
        }
        detailInfo.setIndependentQty(subBaseDemandQty.negate());
        RequirementUniteRuleInfo reqUnit = this.runParam.getPlanVersion().getRequirementUniteRule();
        if (reqUnit == null) {
            detailInfo.setPriority(0 + this.materiaDataUtil.getCorrelativeReqType(statistics.getMaterialID()));
        } else {
            detailInfo.setPriority(55);
        }
        if (reqDetail.getBProjectID() != null) {
            detailInfo.setBProjectNumber(reqDetail.getBProjectNumber());
            detailInfo.setBProjectID(reqDetail.getBProjectID());
        } else {
            detailInfo.setBProjectNumber(statistics.getProjectNumber());
            if (statistics.getProjectNumber().equals(this.runParam.getProjectNumber())) {
                detailInfo.setBProjectID(this.runParam.getProjectID());
            }
        }
        if (reqDetail.getBTrackID() != null) {
            detailInfo.setBTrackNumber(reqDetail.getBTrackNumber());
            detailInfo.setBTrackID(reqDetail.getBTrackID());
        } else {
            detailInfo.setBTrackNumber(statistics.getTrackNumber());
            if (statistics.getTrackNumber().equals(this.runParam.getTrackNumber())) {
                detailInfo.setBTrackID(this.runParam.getTrackID());
            }
        }
        detailInfo.setMrpSeq(MRPSeqUtil.getMRPSeq(detailInfo));
        return detailInfo;
    }

    private boolean isCombinationReplace(MaterialReplaceDetailVO replaceDetail) {
        boolean isCombinationReplace = false;
        if (replaceDetail.getCombinations() != null && replaceDetail.getCombinations().size() > 0) {
            isCombinationReplace = true;
        }
        return isCombinationReplace;
    }

    private boolean isTraceProjectTrackNumber(String planStrategyId) {
        return !"NUnM+gEcEADgAA3cwKgL09g0uEU=".equals(planStrategyId) && !"NUnM+gEcEADgAA3ewKgL09g0uEU=".equals(planStrategyId) && !"NUnM+gEcEADgAA3gwKgL09g0uEU=".equals(planStrategyId);
    }

    private MRPMaterialDataInfo getMaterialDataInfo(String materialId) {
        return this.materiaDataUtil.getOneMaterialSData(materialId);
    }

    private void addDetailInfo(MRPDetailInfo detailInfo, MRPMaterialStatisticsInfo statisticsInfo) throws BOSException, EASBizException {
        this.dataSaver.addInsertList(detailInfo);
        this.detailDataUtil.addDetailDataToMemory(detailInfo, statisticsInfo);
    }

    private MaterialReplaceParam createReplaceParam(MRPMaterialDataInfo materialDataInfo, MRPDetailInfo reqDetail, MRPMaterialStatisticsInfo statisticsInfo, BigDecimal reqQty, Map poEntryInfo) {
        MaterialReplaceParam param = new MaterialReplaceParam();
        BigDecimal scrapRate = (BigDecimal)poEntryInfo.get("scrapRate");
        int scrapExp = (Integer)poEntryInfo.get("scrapRateExpression");
        int baseQtyPrc = materialDataInfo.getBaseQtyPrc();
        BigDecimal grossBaseQty = (BigDecimal)poEntryInfo.get("grossBaseQty");
        BigDecimal grossStandardBaseQty = MRPUtil.calculateStandardQty(grossBaseQty, scrapRate, scrapExp, baseQtyPrc, this.runParam.isWastageRate());
        param.setStorageOrgUnitId(this.runParam.getStorageOrgUnitID());
        param.setMaterialId(materialDataInfo.getMaterialID());
        param.setParentBomId(reqDetail.getParentBomID());
        param.setBillDate(reqDetail.getBillDate().getDate().getTime());
        param.setUnitQty(reqDetail.getUnitQty());
        param.setPeriod(statisticsInfo.getPeriod());
        param.setProjectNumber(statisticsInfo.getProjectNumber());
        param.setTrackNumber(statisticsInfo.getTrackNumber());
        param.setGrossBaseStandardQty(grossStandardBaseQty);
        BigDecimal netReqQty = reqQty.compareTo(reqDetail.getDependentQty()) < 0 ? reqDetail.getDependentQty() : reqQty;
        param.setReqBaseStandardQty(MRPUtil.calculateStandardQty(netReqQty, scrapRate, scrapExp, baseQtyPrc, this.runParam.isWastageRate()).abs());
        param.setMaterialDataUtil((GetSubstitueMaterial)this.materiaDataUtil);
        return param;
    }

    private void preProcess(MaterialReplaceDetailVO replaceDetail) throws MRPException, EASBizException, BOSException {
        ArrayList supplies = new ArrayList();
        MaterialReplaceVO unKeyMaterialVO = null;
        this.addReplaceSupplies(supplies, (MaterialReplaceVO)replaceDetail);
        if (this.isCombinationReplace(replaceDetail)) {
            for (int i = 0; i < replaceDetail.getCombinations().size(); ++i) {
                unKeyMaterialVO = (MaterialReplaceVO)replaceDetail.getCombinations().get(i);
                this.addReplaceSupplies(supplies, unKeyMaterialVO);
            }
        }
        this.substituteHelper.setDefaultValue(this.runParam.getCtx(), supplies, this.runParam.getStorageOrgUnitID());
    }

    private void addReplaceSupplies(List supplies, MaterialReplaceVO replaceVO) {
        for (int i = 0; i < replaceVO.getReplaceSupplies().size(); ++i) {
            supplies.add(replaceVO.getReplaceSupplies().get(i));
        }
    }

    private boolean isUnkeyMaterialCanReplace(List combinations) {
        boolean isCanReplace = true;
        MaterialReplaceVO unKeyMaterialDetail = null;
        for (int i = 0; i < combinations.size(); ++i) {
            unKeyMaterialDetail = (MaterialReplaceVO)combinations.get(i);
            List supplies = unKeyMaterialDetail.getReplaceSupplies();
            ReplaceMaterailVO supply = null;
            for (int j = 0; j < supplies.size(); ++j) {
                supply = (ReplaceMaterailVO)supplies.get(j);
                if (this.getMaterialDataInfo(supply.getReplaceMaterailID()) != null) continue;
                logger.info((Object)("unkey subMaterial: " + supply.getReplaceMaterailID() + " is not in material list."));
                return false;
            }
        }
        return isCanReplace;
    }

    private void updateComReq() throws EASBizException, BOSException {
        TempTablePool pool = TempTablePool.getInstance((Context)this.runParam.getCtx());
        ReqPlanForMRP reqPlan = new ReqPlanForMRP();
        String reqParamTable = null;
        if (this.newEntries.size() > 0 || this.existedEntries.size() > 0) {
            try {
                reqParamTable = pool.createTempTable(reqPlan.getTalbeStringForMRP());
                if (this.newEntries.size() > 0) {
                    this.insertReqData(reqParamTable, this.runParam.getMrpPlanOrderEntry(), this.newEntries);
                }
                if (this.existedEntries.size() > 0) {
                    this.insertReqData(reqParamTable, "T_MM_PLannedOrderEntry", this.existedEntries);
                }
                reqPlan.receiveData(this.runParam.getCtx(), reqParamTable, ReqPlanForMRP.actionTypeAudit, this.runParam.getStorageOrgUnitID());
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
            finally {
                pool.releaseTable(reqParamTable);
                this.newEntries.clear();
                this.existedEntries.clear();
            }
        }
    }

    private void insertReqData(String reqParamTable, String poEntryTable, List poEntryIds) throws Exception {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into ").append(reqParamTable).append(" select newbosid('12345678'),t1.FBillID,t1.FBillNumber,t0.FID,t0.FMaterialID,").append("t0.FProvideType,t0.FissMode,t0.FStorageOrgUnitID,").append("'").append(this.runParam.getStorageOrgUnitID()).append("',").append("0, case when t0.FBaseDemandQty<0 then 0-t0.FBaseDemandQty else t0.FBaseDemandQty end,").append("null,t0.FUnitID,1,t0.FReqDate,").append("case when t0.FSeq=0 then 1 else t0.FSeq end, ").append(" t1.FBProjectId,t1.FBTrackId \n");
        sql.append("from ").append(poEntryTable).append(" t0 ").append("inner join ").append(this.runParam.getMrpCalcDetailTableName()).append(" t1 on t0.FID = t1.FBillEntryID \n");
        sql.append(" inner join t_bd_materialPlan").append(" t2 on t0.FMaterialID = t2.FMaterialId ").append(" and t2.FOrgUnit='").append(this.runParam.getStorageOrgUnitID()).append("' \n");
        sql.append("where t2.FisComReqConsume = 1 and t2.FProvideType in (");
        sql.append(10910).append(",").append(10920).append(") \n");
        sql.append(" and t0.FID in (").append(SQLUtil.arrayToString((Object[])poEntryIds.toArray())).append(") ");
        DbUtil.execute((Context)this.runParam.getCtx(), (String)sql.toString());
    }

    private boolean isCannotSubstitute(Map poEntryInfo) {
        BigDecimal releaseBaseQty = (BigDecimal)poEntryInfo.get("releaseBaseQty");
        return MRPConstant.ZERO.compareTo(releaseBaseQty) < 0;
    }
}

