/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.app.mrp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialScrapRateExpressionEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.mm.basedata.ReplaceMaterailVO;
import com.kingdee.eas.mm.common.app.SQLUtils;
import com.kingdee.eas.mm.common.util.SQLUtil;
import com.kingdee.eas.mm.planning.PlannedOrderEntryCollection;
import com.kingdee.eas.mm.planning.PlannedOrderEntryInfo;
import com.kingdee.eas.mm.planning.PlannedOrderFactory;
import com.kingdee.eas.mm.planning.app.mrp.MRPConstant;
import com.kingdee.eas.mm.planning.app.mrp.MRPDetailInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MRPSubstituteHelper {
    private Context ctx = null;
    private String storageOrgUnitId = null;
    private String tempPlanOrderEntryTable = null;
    private int seqStep = 10;

    public MRPSubstituteHelper(Context ctx) {
        this.ctx = ctx;
    }

    public Map getSrcPOEntryInfo(MRPDetailInfo detailInfo) throws BOSException {
        HashMap<String, Object> srcPOEntryInfo = new HashMap<String, Object>();
        StringBuffer sql = new StringBuffer();
        String planOrderEntryTable = this.getPlanOrderEntryTable(detailInfo.isNewOrder());
        sql.append("select t.FLineSeq FLineSeq, t.FScrapRate FScrapRate, mp.FScrapRateExpression FScrapRateExpression,").append(" t.FIsReplaced FIsReplaced, t.FStandardQty FStandardQty, ");
        if (detailInfo.isNewOrder()) {
            sql.append(" (0-t.FBaseDemandQty) FGrossBaseQty, 0 FReleaseBaseQty ");
        } else {
            sql.append(" (t.FBaseDemandQty-t.FReleaseBaseQty) FGrossBaseQty, t.FReleaseBaseQty FReleaseBaseQty ");
        }
        sql.append(" from ").append(planOrderEntryTable).append(" t \n").append(" inner join t_bd_materialPlan mp on t.FMaterialId=mp.FMaterialId and mp.FOrgUnit=? ").append(" where t.FID=? ");
        Object[] queryParam = new Object[]{this.storageOrgUnitId, detailInfo.getBillEntryID()};
        IRowSet rs = SQLUtils.executeQuery((Context)this.ctx, (String)sql.toString(), (Object[])queryParam);
        String lineSeq = null;
        BigDecimal standardQty = MRPConstant.ZERO;
        BigDecimal scrapRate = MRPConstant.ZERO;
        Integer scrapRateExpression = new Integer(10610);
        Boolean isReplaced = Boolean.FALSE;
        BigDecimal grossBaseQty = MRPConstant.ZERO;
        BigDecimal releaseBaseQty = MRPConstant.ZERO;
        try {
            if (rs.next()) {
                lineSeq = rs.getString("FLineSeq");
                standardQty = rs.getBigDecimal("FStandardQty");
                scrapRate = rs.getBigDecimal("FScrapRate");
                scrapRateExpression = new Integer(rs.getInt("FScrapRateExpression"));
                isReplaced = new Boolean(rs.getBoolean("FIsReplaced"));
                grossBaseQty = rs.getBigDecimal("FGrossBaseQty");
                releaseBaseQty = rs.getBigDecimal("FReleaseBaseQty");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        srcPOEntryInfo.put("lineSeq", lineSeq);
        srcPOEntryInfo.put("standardQty", standardQty);
        srcPOEntryInfo.put("scrapRate", scrapRate);
        srcPOEntryInfo.put("scrapRateExpression", scrapRateExpression);
        srcPOEntryInfo.put("isReplaced", isReplaced);
        srcPOEntryInfo.put("grossBaseQty", grossBaseQty);
        srcPOEntryInfo.put("releaseBaseQty", releaseBaseQty);
        return srcPOEntryInfo;
    }

    public synchronized void initSrcPOEntrySeq(MRPDetailInfo detailInfo) throws BOSException {
        StringBuffer sql = new StringBuffer();
        String planOrderEntryTable = this.getPlanOrderEntryTable(detailInfo.isNewOrder());
        sql.append("select FID FPOEntryId from ").append(planOrderEntryTable).append(" \n").append(" where FParentID=? ");
        Object[] queryParam = new Object[]{detailInfo.getBillID()};
        IRowSet rs = SQLUtils.executeQuery((Context)this.ctx, (String)sql.toString(), (Object[])queryParam);
        StringBuffer updateSql = new StringBuffer();
        updateSql.append("update ").append(planOrderEntryTable).append(" set FLineSeq=? ").append("where FID=? ");
        Object[] updateParam = null;
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        int lineSeq = 10;
        String poEntryId = null;
        try {
            while (rs.next()) {
                poEntryId = rs.getString("FPOEntryId");
                updateParam = new Object[]{new Integer(lineSeq).toString(), poEntryId};
                paramList.add(updateParam);
                lineSeq += this.seqStep;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        SQLUtils.executeBatch((Context)this.ctx, (String)updateSql.toString(), paramList);
    }

    public Map getMaterialPlanInfos(String[] materialIds) throws BOSException {
        HashMap<String, Number> planInfos = new HashMap<String, Number>();
        StringBuffer sql = new StringBuffer();
        String materialIdsSql = SQLUtil.arrayToString((Object[])materialIds);
        sql.append("select mp.FMaterialId FMaterialId, mp.FScrapRate FScrapRate, mp.FScrapRateExpression FScrapRateExpression ").append(" from t_bd_materialPlan mp \n").append(" where mp.FOrgUnit='").append(this.storageOrgUnitId).append("' ").append(" and mp.FMaterialId in (").append(materialIdsSql).append(") ");
        IRowSet rs = SQLUtils.executeQuery((Context)this.ctx, (String)sql.toString());
        String materialId = null;
        BigDecimal scrapRate = null;
        Integer scrapRateExpression = null;
        try {
            while (rs.next()) {
                materialId = rs.getString("FMaterialId");
                scrapRate = rs.getBigDecimal("FScrapRate");
                scrapRateExpression = new Integer(rs.getInt("FScrapRateExpression"));
                planInfos.put(materialId + "scrapRate", scrapRate);
                planInfos.put(materialId + "scrapRateExpression", scrapRateExpression);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return planInfos;
    }

    public void setStorageOrgUnitId(String storageOrgUnitId) {
        this.storageOrgUnitId = storageOrgUnitId;
    }

    public void setTempPlanOrderEntryTable(String tempPlanOrderEntryTable) {
        this.tempPlanOrderEntryTable = tempPlanOrderEntryTable;
    }

    private String getPlanOrderEntryTable(boolean isNewOrder) {
        String table = "T_MM_PlannedOrderEntry";
        if (isNewOrder) {
            table = this.tempPlanOrderEntryTable;
        }
        return table;
    }

    public void setDefaultValue(Context ctx, List replaceMaterialList, String storageOrgUnitId) throws BOSException, EASBizException {
        PlannedOrderEntryCollection poEntries = new PlannedOrderEntryCollection();
        PlannedOrderEntryInfo poEntryInfo = null;
        MaterialInfo substituteMaterial = null;
        ReplaceMaterailVO substituteInfo = null;
        for (int i = 0; i < replaceMaterialList.size(); ++i) {
            substituteInfo = (ReplaceMaterailVO)replaceMaterialList.get(i);
            if (substituteInfo.getSupplyOrgUnit() == null) continue;
            poEntryInfo = new PlannedOrderEntryInfo();
            substituteMaterial = new MaterialInfo();
            substituteMaterial.setId(BOSUuid.read((String)substituteInfo.getReplaceMaterailID()));
            poEntryInfo.setMaterial(substituteMaterial);
            poEntryInfo.setStorageOrgUnit(substituteInfo.getSupplyOrgUnit());
            poEntryInfo.setProvideType(substituteInfo.getProvideType());
            poEntries.add(poEntryInfo);
        }
        poEntries = PlannedOrderFactory.getLocalInstance(ctx).setPlannedOrderEntryDefaultValue(storageOrgUnitId, poEntries);
        MaterialScrapRateExpressionEnum scrapExpression = null;
        for (int i = 0; i < replaceMaterialList.size(); ++i) {
            substituteInfo = (ReplaceMaterailVO)replaceMaterialList.get(i);
            for (int j = 0; j < poEntries.size(); ++j) {
                poEntryInfo = poEntries.get(j);
                if (!substituteInfo.getReplaceMaterailID().equals(poEntryInfo.getMaterial().getId().toString())) continue;
                substituteInfo.setIssMode(poEntryInfo.getIssMode() != null ? poEntryInfo.getIssMode().getValue() : 0);
                substituteInfo.setDefaultWarehouseID(this.getInfoId((CoreBaseInfo)poEntryInfo.getDefaultWarehouse()));
                substituteInfo.setLocationID(this.getInfoId((CoreBaseInfo)poEntryInfo.getLocation()));
                substituteInfo.setTransferOrgUnitID(this.getInfoId((CoreBaseInfo)poEntryInfo.getTransferOrgUnit()));
                substituteInfo.setTransferWarehouseID(this.getInfoId((CoreBaseInfo)poEntryInfo.getTransferWarehouse()));
                substituteInfo.setIsBackFlush(poEntryInfo.isBackFlush() ? 1 : 0);
                substituteInfo.setIsStockTransfer(poEntryInfo.isIsStockTransfer() ? 1 : 0);
                substituteInfo.setScrapRate(poEntryInfo.getScrapRate() != null ? poEntryInfo.getScrapRate() : new BigDecimal("0.00"));
                scrapExpression = (MaterialScrapRateExpressionEnum)poEntryInfo.get("scrapRateExpression");
                substituteInfo.setScrapExpression(scrapExpression != null ? scrapExpression.getValue() : 10610);
            }
        }
    }

    private String getInfoId(CoreBaseInfo info) {
        String id = null;
        if (info != null && info.getId() != null) {
            id = info.getId().toString();
        }
        return id;
    }
}

