/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.app.release;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.material.MaterialProvideTypeEnum;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.basedata.ProductLineInfo;
import com.kingdee.eas.mm.control.IProductionOrder;
import com.kingdee.eas.mm.control.ProductionOrderFactory;
import com.kingdee.eas.mm.control.ProductionOrderInfo;
import com.kingdee.eas.mm.planning.PlanOrderException;
import com.kingdee.eas.mm.planning.PlannedOrderCollection;
import com.kingdee.eas.mm.planning.PlannedOrderEntryCollection;
import com.kingdee.eas.mm.planning.PlannedOrderEntryInfo;
import com.kingdee.eas.mm.planning.PlannedOrderInfo;
import com.kingdee.eas.mm.planning.app.release.AbstractPlanOrderTransform;
import com.kingdee.eas.mm.planning.app.release.ReleaseUtil;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PlanOrder2ProductionOrder
extends AbstractPlanOrderTransform {
    public PlanOrder2ProductionOrder(Context ctx) {
        super(ctx);
    }

    @Override
    protected BOSObjectType getDestBOSType() {
        return BOSObjectType.create((String)"1F66774E");
    }

    @Override
    protected IObjectValue getDestBillInfo() {
        return new ProductionOrderInfo();
    }

    @Override
    protected String getDestBillPermission() {
        return "mm_productionOrder_addnew";
    }

    @Override
    protected void doAfterTransform(IObjectCollection billCollection, Set successPOs, List failedDestBillIds, List successDestBillIds) throws EASBizException, BOSException {
        Set planOrderSet = this.getPlanOrderSet();
        logger.info((Object)("ReleaseUtil.set2Collection(getPlanOrderSet()):" + String.valueOf(planOrderSet.size())));
        PlannedOrderCollection poCollection = ReleaseUtil.set2Collection(planOrderSet);
        String plannedId = null;
        PlannedOrderInfo planned = null;
        BigDecimal thisTotalReleaseQty = null;
        BigDecimal thisTotalReleasebaseQty = null;
        BillTypeInfo billType = new BillTypeInfo();
        billType.setId(BOSUuid.read((String)"9XXvbVGlRtym/0qtqeIXXrhE1B8="));
        IProductionOrder iProdurctionOrder = ProductionOrderFactory.getLocalInstance((Context)this.ctx);
        ProductionOrderInfo prodinfo = null;
        logger.info((Object)("doAfterTransform.[for (int i = 0; i < " + String.valueOf(billCollection.size()) + "; i++)]"));
        for (int i = 0; i < billCollection.size(); ++i) {
            prodinfo = (ProductionOrderInfo)billCollection.getObject(i);
            plannedId = prodinfo.getSourceBillId();
            planned = ReleaseUtil.getPlannedOrderInfo(poCollection, plannedId);
            if (planned != null && planned.get("thisTotalReleaseQty") != null) {
                thisTotalReleaseQty = (BigDecimal)planned.get("thisTotalReleaseQty");
                prodinfo.setQty(thisTotalReleaseQty);
            }
            if (planned != null && planned.get("thisTotalReleaseBaseQty") != null) {
                thisTotalReleasebaseQty = (BigDecimal)planned.get("thisTotalReleaseBaseQty");
                prodinfo.setBaseQty(thisTotalReleasebaseQty);
            }
            if (planned != null) {
                ProductLineInfo productLine = null;
                AdminOrgUnitInfo workShop = null;
                if (planned.get("productLine") != null) {
                    productLine = (ProductLineInfo)planned.get("productLine");
                    workShop = productLine.getWorkshop();
                }
                prodinfo.setProductLine(productLine);
                prodinfo.setWorkShop(workShop);
            }
            prodinfo.setSourceBillType(billType);
            Map tempMap = null;
            try {
                logger.info((Object)("iProdurctionOrder.submitForPlan,number:" + prodinfo.getNumber()));
                tempMap = iProdurctionOrder.submitForPlan(prodinfo);
                logger.info((Object)("iProdurctionOrder.submitForPlan,number:" + prodinfo.getNumber() + ",end"));
            }
            catch (Exception e) {
                logger.info((Object)e);
                failedDestBillIds.add(prodinfo.getId().toString());
                this.getResultMap().put(planned.getNumber(), this.getResource("SUBMIT_DESTBILL_FAILED", null));
                return;
            }
            if (tempMap == null) {
                successDestBillIds.add(prodinfo.getId().toString());
                continue;
            }
            failedDestBillIds.add(prodinfo.getId().toString());
            this.getResultMap().put(planned.getNumber(), tempMap.get(plannedId));
        }
        logger.info((Object)("doAfterTransform.[for (int i = 0; i < " + String.valueOf(poCollection.size()) + "; i++)]"));
        for (int j = 0; j < poCollection.size(); ++j) {
            planned = poCollection.get(j);
            if (this.getResultMap().get(planned.getNumber()) != null) continue;
            successPOs.add(planned);
        }
    }

    @Override
    protected void checkAdditionalItems() throws EASBizException, BOSException {
        PlannedOrderCollection poCollection = ReleaseUtil.set2Collection(this.getPlanOrderSet());
        PlannedOrderInfo poInfo = null;
        PlannedOrderEntryCollection entryColl = null;
        PlannedOrderEntryInfo poEntryInfo = null;
        PlanOrderException exception = new PlanOrderException(PlanOrderException.PRODUCTIONORDER_CANNOT_SPANORGDIRECTPROVIDE);
        block0: for (int i = 0; i < poCollection.size(); ++i) {
            poInfo = poCollection.get(i);
            entryColl = poInfo.getEntries();
            if (entryColl == null || entryColl.size() == 0) continue;
            for (int j = 0; j < entryColl.size(); ++j) {
                poEntryInfo = entryColl.get(j);
                if (!poEntryInfo.getProvideType().equals((Object)MaterialProvideTypeEnum.SPANORGDIRECTPROVIDE)) continue;
                this.getResultMap().put(poInfo.getNumber(), exception.getMessage());
                continue block0;
            }
        }
    }
}

