/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.app.release;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingCollection;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingFactory;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitFactory;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.common.app.SQLUtils;
import com.kingdee.eas.mm.common.util.MMUtils;
import com.kingdee.eas.mm.planning.MappingReturnTypeEnum;
import com.kingdee.eas.mm.planning.PlanOrderException;
import com.kingdee.eas.mm.planning.PlannedOrderCollection;
import com.kingdee.eas.mm.planning.PlannedOrderInfo;
import com.kingdee.eas.scm.common.SCMBillCommonFacadeFactory;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ReleaseUtil {
    public static PlannedOrderCollection set2Collection(Set set) {
        PlannedOrderCollection plannedOrders = new PlannedOrderCollection();
        PlannedOrderInfo plannedOrderInfo2 = null;
        for (PlannedOrderInfo plannedOrderInfo2 : set) {
            plannedOrders.add(plannedOrderInfo2);
        }
        return plannedOrders;
    }

    public static void cleanSet(Set set, Map map, MappingReturnTypeEnum typeEnum) {
        PlannedOrderInfo plannedInfo = null;
        Iterator it = set.iterator();
        while (it.hasNext()) {
            plannedInfo = (PlannedOrderInfo)it.next();
            map.put(plannedInfo.getNumber(), typeEnum);
            it.remove();
        }
    }

    public static void setResultMap(Set set, Map map, Exception exception) {
        PlannedOrderInfo plannedInfo = null;
        Iterator it = set.iterator();
        while (it.hasNext()) {
            plannedInfo = (PlannedOrderInfo)it.next();
            map.put(plannedInfo.getNumber(), exception.getMessage());
            it.remove();
        }
    }

    public static PlannedOrderInfo getPlannedOrderInfo(PlannedOrderCollection poColl, String poId) {
        PlannedOrderInfo poInfo = null;
        for (int i = 0; i < poColl.size() && !(poInfo = poColl.get(i)).getId().toString().equals(poId); ++i) {
        }
        return poInfo;
    }

    public static CompanyOrgUnitInfo getCompanyOrgUnitInfo(Context ctx, String storageOrgUnitId) throws BOSException, EASBizException {
        return ReleaseUtil.getCompanyOrgUnitInfo(ctx, storageOrgUnitId, null);
    }

    public static CompanyOrgUnitInfo getCompanyOrgUnitInfo(Context ctx, String storageOrgUnitId, SelectorItemCollection companySelectorColl) throws BOSException, EASBizException {
        IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo orgUnit = (CompanyOrgUnitInfo)iUnitRel.getDefaultToUnit(storageOrgUnitId, 4, 1);
        if (orgUnit == null) {
            OrgUnitCollection orgCol = iUnitRel.getToUnit(storageOrgUnitId, 4, 1);
            orgUnit = (CompanyOrgUnitInfo)orgCol.get(0);
        }
        if (orgUnit != null && companySelectorColl != null) {
            companySelectorColl.add("toUnit");
            companySelectorColl.add("isDefault");
            ObjectUuidPK pk = new ObjectUuidPK(orgUnit.getId());
            orgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)pk, companySelectorColl);
        }
        return orgUnit;
    }

    public static SaleOrgUnitInfo getSaleOrgUnitInfo(Context ctx, String storageOrgUnitId) throws BOSException, EASBizException {
        if (storageOrgUnitId == null) {
            return null;
        }
        IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        SaleOrgUnitInfo ret = (SaleOrgUnitInfo)iUnitRel.getDefaultToUnit(storageOrgUnitId, 4, 2);
        if (ret == null) {
            OrgUnitCollection orgCol = iUnitRel.getToUnit(storageOrgUnitId, 4, 2);
            ret = (SaleOrgUnitInfo)orgCol.get(0);
        }
        return ret;
    }

    public static PurchaseOrgUnitInfo getPurOrgUnitInfo(Context ctx, PlannedOrderInfo info) throws EASBizException, BOSException {
        String stroageOrgUnitID;
        PurchaseOrgUnitInfo purOrg = null;
        String materialID = info.getMaterial().getId().toString();
        String FPurOrgID = ReleaseUtil.getDefaultPurOrgID(ctx, materialID, stroageOrgUnitID = info.getStorageOrgUnit().getId().toString());
        if (FPurOrgID != null) {
            purOrg = new PurchaseOrgUnitInfo();
            purOrg.setId(BOSUuid.read((String)FPurOrgID));
            return purOrg;
        }
        return SCMBillCommonFacadeFactory.getLocalInstance((Context)ctx).getPurchaseByStorageOrg(stroageOrgUnitID);
    }

    public static PurchaseOrgUnitInfo getPurOrgUnitInfo(Context ctx, String storageOrgUnitId, String materialId) throws EASBizException, BOSException {
        String purOrgId = ReleaseUtil.getDefaultPurOrgID(ctx, materialId, storageOrgUnitId);
        if (MMUtils.isEmptyString((String)purOrgId)) {
            throw new PlanOrderException(PlanOrderException.DEFAULT_PURCHASEORG_ISNULL);
        }
        IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        OrgUnitInfo storageCompany = null;
        OrgUnitInfo purCompany = null;
        OrgUnitCollection orgCol = iUnitRel.getToUnit(storageOrgUnitId, 4, 1);
        if (orgCol != null && orgCol.size() > 0) {
            storageCompany = orgCol.get(0);
        }
        if ((orgCol = iUnitRel.getToUnit(purOrgId, 3, 1)) != null && orgCol.size() > 0) {
            purCompany = orgCol.get(0);
        }
        if (storageCompany == null || purCompany == null) {
            throw new PlanOrderException(PlanOrderException.PURCHASEORG_ISDIFFERENT);
        }
        if (!storageCompany.getId().toString().equals(purCompany.getId().toString())) {
            throw new PlanOrderException(PlanOrderException.PURCHASEORG_ISDIFFERENT);
        }
        ObjectUuidPK pk = new ObjectUuidPK(purOrgId);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("name");
        PurchaseOrgUnitInfo purOrg = PurchaseOrgUnitFactory.getLocalInstance((Context)ctx).getPurchaseOrgUnitInfo((IObjectPK)pk, selector);
        return purOrg;
    }

    public static String getDefaultPurOrgID(Context ctx, String materialID, String storageOrgUnitID) throws BOSException {
        if (materialID == null || storageOrgUnitID == null) {
            return null;
        }
        String purOrgID = null;
        String sql = "select FPurOrgID from T_BD_MaterialPlan where fmaterialid = ? and forgunit=  ? ";
        IRowSet purid = SQLUtils.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{materialID, storageOrgUnitID});
        try {
            if (purid.next()) {
                purOrgID = purid.getString("FPurOrgID");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return purOrgID;
    }

    public static Map checkMaterialInventory(Context ctx, Set planOrderSet) throws BOSException {
        HashMap<String, String> rst = new HashMap<String, String>();
        if (planOrderSet == null || planOrderSet.size() == 0) {
            return rst;
        }
        Iterator it = planOrderSet.iterator();
        PlannedOrderInfo planned = null;
        StringBuffer sb = new StringBuffer();
        while (it.hasNext()) {
            planned = (PlannedOrderInfo)it.next();
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append("'").append(planned.getId().toString()).append("'");
        }
        String idsWhereClause = sb.toString();
        sb.setLength(0);
        sb.append(" select plannedorder.fid , plannedorder.fnumber ");
        sb.append("from t_mm_plannedorder plannedorder ");
        sb.append(" left outer join t_bd_materialInventory materialInve1 ");
        sb.append("   on plannedorder.FProductionOrgUnitID =  materialInve1.forgunit and plannedorder.FMaterialID = materialInve1.FMaterialID ");
        sb.append(" left outer join t_bd_materialInventory materialInve on plannedorder.FStorageOrgUnitID =  materialInve.forgunit  ");
        sb.append("     and plannedorder.FMaterialID = materialInve.FMaterialID  ");
        sb.append("where  plannedorder.fid  in ( ");
        sb.append(idsWhereClause).append(")");
        sb.append(" and (  materialInve.fstatus = 0   or materialInve.fstatus  is null or materialInve1.fstatus = 0 ");
        sb.append("        or materialInve1.fstatus  is null  ) ");
        IRowSet rs = SQLUtils.executeQuery((Context)ctx, (String)sb.toString());
        String id = null;
        String planndeId = null;
        if (rs.size() == 0) {
            return rst;
        }
        try {
            String msg = new PlanOrderException(PlanOrderException.PLANNEDORDER_MATERIALINVENTORY_UNAUDIT).getMessage();
            while (rs.next()) {
                id = rs.getString("fid");
                it = planOrderSet.iterator();
                while (it.hasNext()) {
                    planned = (PlannedOrderInfo)it.next();
                    planndeId = planned.getId().toString();
                    if (!id.equals(planndeId)) continue;
                    it.remove();
                    break;
                }
                rst.put(rs.getString("fnumber"), msg);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return rst;
    }

    public static MaterialPurchasingInfo getMaterialPurchasing(Context ctx, String orgId, String materialId) throws BOSException {
        MaterialPurchasingInfo materialPurInfo = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialId, CompareType.EQUALS));
        SelectorItemCollection selectorColl = new SelectorItemCollection();
        selectorColl.add("id");
        selectorColl.add("name");
        selectorColl.add("number");
        selectorColl.add("unit.id");
        view.setSelector(selectorColl);
        view.setFilter(filter);
        MaterialPurchasingCollection coll = MaterialPurchasingFactory.getLocalInstance((Context)ctx).getMaterialPurchasingCollection(view);
        if (coll != null && coll.size() > 0) {
            materialPurInfo = coll.get(0);
        }
        return materialPurInfo;
    }

    public static String[] getPlanOrderIds(Set poSet) {
        String[] poIds = new String[poSet.size()];
        PlannedOrderInfo poInfo = null;
        Iterator it = poSet.iterator();
        int i = 0;
        while (it.hasNext()) {
            poInfo = (PlannedOrderInfo)it.next();
            poIds[i] = poInfo.getId().toString();
            ++i;
        }
        return poIds;
    }

    public static void setResultMap(Set set, Map map, String poId, Exception exception) {
        PlannedOrderInfo poInfo = null;
        Iterator it = set.iterator();
        while (it.hasNext()) {
            poInfo = (PlannedOrderInfo)it.next();
            if (!poId.equals(poInfo.getId().toString())) continue;
            map.put(poInfo.getNumber(), exception.getMessage());
            it.remove();
            break;
        }
    }
}

