/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.app.release.batch;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.mm.planning.app.release.batch.ProcessorRequestQueue;
import com.kingdee.eas.mm.planning.app.release.batch.PurRequestSubmitProcessor;
import org.apache.log4j.Logger;

public class PlanningOrderReleasePurReq {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.mo.app.release.enhancement.PlanningOrderReleaseMO");

    public BatchActionResults doit(Context ctx, IObjectCollection collection) throws EASBizException, BOSException {
        long begin = System.currentTimeMillis();
        logger.info((Object)"------------------------------------------------------------------------");
        logger.info((Object)("befor doing memeory is: " + (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024L / 1024L + " M "));
        logger.info((Object)("collection size= " + collection.size()));
        logger.info((Object)("mo release begin at: " + begin));
        ctx.put((Object)"dynaNum", (Object)new Integer(100));
        ProcessorRequestQueue processorRequestQueue = null;
        int count = 0;
        if (collection != null && collection.size() >= 50) {
            count = 5;
        }
        if (count > 0) {
            processorRequestQueue = new ProcessorRequestQueue(count);
        }
        try {
            if (null != processorRequestQueue) {
                processorRequestQueue.startThreads();
            }
            BatchActionResults result = this.submit(ctx, collection, processorRequestQueue);
            logger.info((Object)("mo release end at: " + System.currentTimeMillis() + " total spend: " + (System.currentTimeMillis() - begin) / 1000L + " S"));
            logger.info((Object)("mo release end memeory is: " + (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024L / 1024L + " M "));
            BatchActionResults batchActionResults = result;
            return batchActionResults;
        }
        catch (Exception e) {
            logger.info((Object)("mo release catch unhandle exception: " + e.getMessage()));
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        finally {
            logger.info((Object)"mo release execute finally");
            if (null != processorRequestQueue) {
                processorRequestQueue.stopThreads();
            }
            ctx.put((Object)"isPlannedOrderRelease", (Object)new Boolean(false));
        }
    }

    public BatchActionResults submit(Context ctx, IObjectCollection collection, ProcessorRequestQueue processorRequestQueue) throws EASBizException, BOSException {
        long begin = System.currentTimeMillis();
        logger.info((Object)("mo submit begin at: " + begin));
        PurRequestSubmitProcessor submitProcessor = new PurRequestSubmitProcessor(ctx, collection, processorRequestQueue);
        submitProcessor.doing();
        logger.info((Object)("mo submit end at: " + System.currentTimeMillis() + " total spend: " + (System.currentTimeMillis() - begin) / 1000L + " S"));
        return submitProcessor.getResults();
    }
}

