/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.app.release.batch;

import com.kingdee.eas.mm.planning.app.release.batch.AbstractProcessorRequest;
import com.kingdee.eas.mm.planning.app.release.batch.AbstractRequestQueue;
import com.kingdee.eas.mm.planning.app.release.batch.ProcessorThread;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class ProcessorRequestQueue
extends AbstractRequestQueue {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.mo.app.release.enhancement.threadsupport.queue.ProcessorRequestQueue");
    protected List processorQueue;
    protected final List threads;

    public ProcessorRequestQueue(int maxThreadCount) {
        super(maxThreadCount);
        this.processorQueue = new ArrayList(maxThreadCount);
        this.threads = new ArrayList(maxThreadCount);
        this.initThreads();
    }

    public synchronized void putRequest(AbstractProcessorRequest request) throws InterruptedException {
        while (this.getQueue().size() == this.maxThreadCount) {
            logger.info((Object)(this.getLogDesc() + " putRequest waitting! "));
            this.wait();
        }
        this.getQueue().add(request);
        logger.info((Object)(this.getLogDesc() + " putRequest doing! "));
        this.notifyAll();
    }

    public synchronized AbstractProcessorRequest getRequest() throws InterruptedException {
        while (this.getQueue().size() == 0) {
            logger.info((Object)(this.getLogDesc() + " getRequest waitting! "));
            this.wait();
        }
        logger.info((Object)(this.getLogDesc() + " getRequest doing! "));
        AbstractProcessorRequest request = (AbstractProcessorRequest)this.getQueue().remove(0);
        this.notifyAll();
        return request;
    }

    @Override
    public List getQueue() {
        return this.processorQueue;
    }

    @Override
    public void initThreads() {
        for (int i = 0; i < this.getMaxThreadCount(); ++i) {
            this.threads.add(new ProcessorThread(this));
            ((Thread)this.threads.get(i)).setName("MM-ProcessorThread-" + i);
            ((Thread)this.threads.get(i)).setDaemon(true);
            logger.info((Object)("create ProcessorThread: " + this.threads.get(i)));
        }
    }

    @Override
    public void startThreads() {
        for (int i = 0; i < this.getMaxThreadCount(); ++i) {
            ((ProcessorThread)this.threads.get(i)).start();
            logger.info((Object)("stard ProcessorThread: " + this.threads.get(i)));
        }
    }

    @Override
    public void stopThreads() {
        for (int i = 0; i < this.getMaxThreadCount(); ++i) {
            ((ProcessorThread)this.threads.get(i)).stopit();
            logger.info((Object)("stop ProcessorThread: " + this.threads.get(i)));
        }
    }
}

