/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.app.reqplan;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.common.app.BizCommand;
import com.kingdee.eas.mm.common.app.SQLUtils;
import com.kingdee.eas.mm.common.util.MMUtils;
import com.kingdee.eas.mm.planning.ReqPlanInsertExtendFacadeFactory;
import com.kingdee.eas.mm.planning.app.reqplan.ReqPlanWriteOffParam;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;

public class ReqPlanBeforeWriteOff
extends BizCommand {
    public ReqPlanBeforeWriteOff(Context ctx) {
        super(ctx);
    }

    public Object doing(Object inParam) throws BOSException, EASBizException {
        ReqPlanWriteOffParam param = (ReqPlanWriteOffParam)inParam;
        Calendar calendar = Calendar.getInstance();
        Date curTime = calendar.getTime();
        String storageOrgUnitid = param.getStorageOrgUnitID();
        String cuID = this.getCU(this.ctx, storageOrgUnitid);
        String tempTableName = this.createTempTable();
        this.insertTempTable(tempTableName, storageOrgUnitid, curTime);
        String tempTableNameForDelete = this.createTempTable2();
        this.insertTempTable2(tempTableName, tempTableNameForDelete);
        this.dealData(tempTableName, storageOrgUnitid, cuID);
        boolean iswriteOffDefaultTrackNumber = Boolean.valueOf(ParamManager.getParamValue((Context)this.ctx, (IObjectPK)new ObjectUuidPK(param.getStorageOrgUnitID()), (String)"Req_Writeoff_Control"));
        param.setCuID(cuID);
        param.setDefaultTrackNumber(this.getDefaultTrackNumber(this.ctx, cuID));
        param.setTempTableNameForCalc(tempTableName);
        param.setCurTime(curTime);
        param.setIsWriteOffDefaultTrackNumber(iswriteOffDefaultTrackNumber);
        param.setTempTableNameForDelete(tempTableNameForDelete);
        return param;
    }

    private String createTempTable2() throws BOSException {
        String tempTableName = null;
        StringBuffer tempTable = new StringBuffer();
        tempTable.append(" create table T_MM_ReqPlanTmpData2 (");
        tempTable.append(" FID VARCHAR(44) ,");
        tempTable.append(" FreqPlandataID VARCHAR(44) ");
        tempTable.append(")");
        TempTablePool pool = TempTablePool.getInstance((Context)this.ctx);
        try {
            tempTableName = pool.createTempTable(tempTable.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tempTableName;
    }

    private void insertTempTable2(String tempTableName, String tempTableNameForDelete) throws BOSException {
        StringBuffer insertsql = new StringBuffer();
        insertsql.append(" insert into  ").append(tempTableNameForDelete);
        insertsql.append("( FID,FreqPlandataID)");
        insertsql.append(" (select newbosid('12345678'),FReqPlanID ");
        insertsql.append(" from ").append(tempTableName).append(")");
        this.execute(insertsql.toString());
    }

    private String createTempTable() throws BOSException {
        String tempTableName = null;
        StringBuffer tempTable = new StringBuffer();
        tempTable.append(" create table T_MM_ReqPlanTmpData (");
        tempTable.append(" FID VARCHAR(44) ,");
        tempTable.append(" FReqPlanID VARCHAR(44) ,");
        tempTable.append(" FStorageOrgUnitID VARCHAR(44) ,");
        tempTable.append(" FOperationType INT DEFAULT 0 NOT NULL ,");
        tempTable.append(" FSourceBillID VARCHAR(44) ,");
        tempTable.append(" FSourceEntryID VARCHAR(44) ,");
        tempTable.append(" FBillTypeID VARCHAR(44) ,");
        tempTable.append(" FCreateTime DateTime ,");
        tempTable.append(" FMaterialID VARCHAR(44) ,");
        tempTable.append(" FUnitID VARCHAR(44) ,");
        tempTable.append(" FBaseUnitID VARCHAR(44) ,");
        tempTable.append(" FQty NUMERIC(21,8) DEFAULT 0 NOT NULL ,");
        tempTable.append(" FBaseQty NUMERIC(21,8) DEFAULT 0 NOT NULL ,");
        tempTable.append(" FCreatorID VARCHAR(44) ,");
        tempTable.append(" FSrcNumber NVARCHAR(80) ,");
        tempTable.append(" FSrcSeq INT DEFAULT 0 NOT NULL ,");
        tempTable.append(" FRequireDate DateTime ,");
        tempTable.append(" FSourceSUID VARCHAR(44) ,");
        tempTable.append(" FSrcOfSourceBillID VARCHAR(44) ,");
        tempTable.append(" FSrcOfSourceEntryID VARCHAR(44) ,");
        tempTable.append(" FSourceBillTypeID VARCHAR(44) ,");
        tempTable.append(" FProjectID VARCHAR(44) ,");
        tempTable.append(" FTrackNumberID VARCHAR(44) ,");
        tempTable.append(" Fisaddnew INT DEFAULT 0 NOT NULL ,");
        tempTable.append(" FisWriteOff INT DEFAULT 0 NOT NULL ,");
        tempTable.append(" FisOrderToOrder INT DEFAULT 0 NOT NULL ,");
        tempTable.append(" FaddPlanType VARCHAR(44) ,");
        tempTable.append(" FWriteOffPlanType INT DEFAULT 0 NOT NULL ,");
        tempTable.append(" FisRubricWriteOff INT DEFAULT 0 NOT NULL ,");
        tempTable.append(" FisDeletePlan INT DEFAULT 0 NOT NULL ,");
        tempTable.append(" FIsolatedRule VARCHAR(44) ,");
        tempTable.append(" fManufactureStrategyID VARCHAR(44) ,");
        tempTable.append(" FPlanMode INT DEFAULT 0 NOT NULL ,");
        tempTable.append(" FPlanner VARCHAR(44) ,");
        tempTable.append(" FDutyDepartment VARCHAR(44) ,");
        tempTable.append(" FControlUnitID VARCHAR(44) ,");
        tempTable.append(" FforwardDaysOffset INT DEFAULT 0 NOT NULL ,");
        tempTable.append(" FbackwardDaysOffset INT DEFAULT 0 NOT NULL ,");
        tempTable.append(" fOffsetMode INT DEFAULT 0 NOT NULL ,");
        tempTable.append(" fReqSource INT DEFAULT 0 NOT NULL  ,");
        tempTable.append(" fisclose INT DEFAULT 0 NOT NULL ,");
        tempTable.append(" fisactive INT DEFAULT 0 NOT NULL ,");
        tempTable.append(" FCUSTOMERID  VARCHAR(44) ,");
        tempTable.append(" fIsDirectTransport INT DEFAULT 0 NOT NULL ");
        String extendFileds = ReqPlanInsertExtendFacadeFactory.getLocalInstance(this.ctx).getExtendFields();
        if (extendFileds != null) {
            tempTable.append(", ");
            tempTable.append(extendFileds);
        }
        tempTable.append(" ) ");
        TempTablePool pool = TempTablePool.getInstance((Context)this.ctx);
        try {
            tempTableName = pool.createTempTable(tempTable.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tempTableName;
    }

    private int insertTempTable(String tempTableName, String storageOrgUnitid, Date curTime) throws BOSException, EASBizException {
        int i;
        HashMap map = ReqPlanInsertExtendFacadeFactory.getLocalInstance(this.ctx).getAllCols();
        ArrayList tmpList = null;
        ArrayList reqplanList = null;
        if (map != null) {
            tmpList = (ArrayList)map.get("tmpList");
            reqplanList = (ArrayList)map.get("reqplanList");
        }
        String format = "yyyy-MM-dd HH:mm:ss";
        StringBuffer innertTable = new StringBuffer();
        innertTable.append(" insert into  ").append(tempTableName);
        innertTable.append("(FID,FReqPlanID,FStorageOrgUnitID,FOperationType,FSourceBillID,");
        innertTable.append(" FSourceEntryID,FBillTypeID,FCreateTime,FMaterialID,FUnitID,");
        innertTable.append(" FBaseUnitID,FQty,FBaseQty,FCreatorID,FSrcNumber,FSrcSeq,FRequireDate,");
        innertTable.append(" FSourceSUID,FSrcOfSourceBillID,FSrcOfSourceEntryID,FSourceBillTypeID,");
        innertTable.append(" FProjectID,FTrackNumberID,Fisaddnew,FisWriteOff,FisOrderToOrder,FaddPlanType,");
        innertTable.append(" FWriteOffPlanType,FisRubricWriteOff,FisDeletePlan,FIsolatedRule,fManufactureStrategyID,");
        innertTable.append(" FPlanMode,FPlanner,FDutyDepartment,FControlUnitID,FforwardDaysOffset,");
        innertTable.append(" FbackwardDaysOffset,fOffsetMode,fReqSource,fisclose,fisactive,FCUSTOMERID,fIsDirectTransport ");
        if (reqplanList != null) {
            for (i = 0; i < reqplanList.size(); ++i) {
                innertTable.append(",").append(reqplanList.toArray()[i]);
            }
        }
        innertTable.append(") \n");
        innertTable.append(" (select newbosid('12345678'),");
        innertTable.append(" s.fid,s.FStorageOrgUnitID,");
        innertTable.append(" s.FOperationType, s.FSourceBillID,");
        innertTable.append(" s.FSourceEntryID, s.FBillTypeID,");
        innertTable.append(" s.FCreateTime, s.FMaterialID,");
        innertTable.append(" s.FUnitID, s.FBaseUnitID,");
        innertTable.append(" s.FQty, s.FBaseQty,");
        innertTable.append(" s.FCreatorID, s.FSrcNumber,");
        innertTable.append(" s.FSrcSeq, s.FRequireDate,");
        innertTable.append(" s.FSourceSUID, s.FSrcOfSourceBillID,");
        innertTable.append(" s.FSrcOfSourceEntryID, s.FSourceBillTypeID,");
        innertTable.append(" s.FProjectID, s.FTrackNumberID,");
        innertTable.append(" s.Fisaddnew, s.FisWriteOff,");
        innertTable.append(" s.FisOrderToOrder, s.FaddPlanType,");
        innertTable.append(" s.FWriteOffPlanType, s.FisRubricWriteOff,");
        innertTable.append(" s.FisDeletePlan, s.FIsolatedRule,");
        innertTable.append(" s.fManufactureStrategyID, s.FPlanMode,");
        innertTable.append(" s.FPlanner, s.FDutyDepartment,");
        innertTable.append(" s.FControlUnitID, s.FforwardDaysOffset,");
        innertTable.append(" s.FbackwardDaysOffset, s.fOffsetMode,");
        innertTable.append(" s.fReqSource, s.fisclose,");
        innertTable.append(" s.fisactive, s.FCUSTOMERID,s.fIsDirectTransport ");
        if (tmpList != null) {
            for (i = 0; i < tmpList.size(); ++i) {
                innertTable.append(",s.").append(tmpList.toArray()[i]);
            }
        }
        innertTable.append(" from  T_MM_ReqPlanData as s ");
        innertTable.append(" where s.fstorageorgunitid = '").append(storageOrgUnitid).append("' ");
        innertTable.append(" and s.fcreateTime < to_date('").append(MMUtils.dateToString((Date)curTime, (String)format)).append("'))");
        int num = SQLUtils.execute((Context)this.ctx, (String)innertTable.toString());
        return num;
    }

    private void dealData(String tempTableName, String storageOrgUnitID, String cuID) throws BOSException {
        StringBuffer str = new StringBuffer();
        str.setLength(0);
        str.append("  delete from ").append(tempTableName).append(" where fid  in ");
        str.append("(select t.fid  from ").append(tempTableName).append(" as t left outer join ");
        str.append("  (select max(fcreateTime) as fcreateTimeMax ,fSourceEntryID ");
        str.append("  from ").append(tempTableName).append(" group by fSourceEntryID  ) as t1 ");
        str.append(" on  t.fSourceEntryID = t1.fSourceEntryID and t.fcreateTime = t1.fcreateTimeMax ");
        str.append(" where t1.fSourceEntryID is null ");
        str.append(" ) and  FOPERATIONTYPE  in (");
        str.append(201).append(",");
        str.append(303).append(",");
        str.append(9902).append(",");
        str.append(9901).append(")");
        this.execute(str.toString());
        String _ = " not in (201,303,9902,9901)";
        str.setLength(0);
        str.append("  delete from ").append(tempTableName).append(" where fid  in ");
        str.append("(select t.fid  from ").append(tempTableName).append(" as t left outer join ");
        str.append("  (select max(fcreateTime) as fcreateTimeMax ,fSourceEntryID ");
        str.append("  from ").append(tempTableName).append(" where FOPERATIONTYPE " + _ + " group by fSourceEntryID  ) as t1 ");
        str.append(" on  t.fSourceEntryID = t1.fSourceEntryID  and t.fcreateTime = t1.fcreateTimeMax ");
        str.append(" where t1.fSourceEntryID is null  ");
        str.append(" )  and  FOPERATIONTYPE  not in (");
        str.append(104).append(",");
        str.append(109).append(",");
        str.append(201).append(",");
        str.append(303).append(",");
        str.append(9902).append(",");
        str.append(9901).append(")");
        this.execute(str.toString());
        str.setLength(0);
        str.append("  delete from ").append(tempTableName).append(" where fid  in ");
        str.append(" ( select  max(fid) as fid ");
        str.append("  from ").append(tempTableName).append(" where fSourceEntryID is not null");
        str.append(" group by fSourceEntryID ,FOPERATIONTYPE ,fcreateTime having count(*) >1   ) ");
        this.execute(str.toString());
        str.setLength(0);
        str.append(" update ").append(tempTableName).append(" as t set (fOffsetMode,FIsolatedRule,fqty,funitID,fManufactureStrategyID ,");
        str.append(" FPlanMode,fForwardDaysOffset,fBackwardDaysOffset,FPlanner,FDutyDepartment,FControlUnitID) = ");
        str.append(" ( select  mp.fOffsetMode,mp.FIsolatedRule,");
        str.append(" to_number(ceiling(t.FBaseQty/isnull(mu.fBaseConvsRate,1)* power(10,isnull(mu.FQtyPrecision,4)))/ to_number(power(10,isnull(mu.FQtyPrecision,4)))) as FQty, ");
        str.append(" mp.FProductUnitID as FUnitID,mp.fManufactureStrategyID,");
        str.append("  mp.FPlanningMode as FPlanMode,mp.fForwardDaysOffset,mp.fBackwardDaysOffset,mp.FPlanner,mp.FDutyDepartment,'");
        str.append(cuID).append("' as FControlUnitID");
        str.append(" from  t_bd_materialplan  as mp      ");
        str.append(" inner join t_bd_multiMeasureUnit as mu on mp.FMaterialID = mu.FMaterialID and mp.FProductUnitID = mu.FMeasureUnitID ");
        str.append(" where mp.FOrgUnit ='").append(storageOrgUnitID).append("'  ");
        str.append(" and t.FStorageOrgUnitID = '").append(storageOrgUnitID).append("'  ");
        str.append("  and t.FMaterialID = mp.fMaterialID");
        str.append(" )");
        this.execute(str.toString());
    }

    private String getCU(Context ctx, String storageOrgUnitID) throws BOSException {
        String cuID = null;
        StringBuffer str = new StringBuffer();
        str.append(" select FControlUnitID from T_ORG_Storage  ");
        str.append(" where fid = '").append(storageOrgUnitID).append("'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)str.toString());
        try {
            if (rs.next()) {
                cuID = rs.getString("FControlUnitID");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return cuID;
    }

    private String getDefaultTrackNumber(Context ctx, String cuID) throws BOSException {
        String defaultTrackNumber = " ";
        TrackNumberInfo trackNumberInfo = new TrackNumberInfo();
        StringBuffer checkSql = new StringBuffer("");
        checkSql.append("select fid from T_MM_TrackNumber\n").append(" where FDefaultTraceNumberFlag = 1\n").append(" and (FADMINCUID = '").append(cuID).append("' or FID in( select FDataBaseDID FROM T_BD_DataBaseDAssign WHERE FBOSObjectType = '").append(trackNumberInfo.getBOSType()).append("' AND FAssignCUID='").append(cuID).append("'))");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)checkSql.toString());
        try {
            if (rs.next()) {
                defaultTrackNumber = rs.getString("fid");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return defaultTrackNumber;
    }

    protected void logEnd() {
        super.logEnd();
    }
}

