/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.app.reqplan;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.common.app.BizCommand;
import com.kingdee.eas.mm.planning.ReqPlanStatusEnum;
import com.kingdee.eas.mm.planning.app.reqplan.ReqPlanDataVO;
import com.kingdee.eas.mm.planning.app.reqplan.ReqPlanWriteOffParam;
import com.kingdee.eas.mm.planning.app.reqplan.WriteOffDataVO;
import com.kingdee.eas.mm.planning.app.reqplan.WriteOffDetailDataVO;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public abstract class ReqPlanWriteOff
extends BizCommand {
    public BigDecimal ZERO = new BigDecimal("0.0");
    public ReqPlanWriteOffParam param = null;
    protected HashMap reaPlanDataBufferMap = new HashMap();
    protected HashMap detailMap = new HashMap();
    protected HashMap materialMap = new HashMap();
    private List materialList = new ArrayList();
    private int lastIndex = -1;
    private static final int MAXCOUNT = 500;
    private static final int MAXLISTCOUNT = 200;
    private static final int WRITEOFF_DATATYPE = 100;
    private static final int REAPLAN_DATATYPE = 200;
    private static final int WRITEOFF_DETAIL_DATATYPE = 300;

    public ReqPlanWriteOff(Context ctx) {
        super(ctx);
    }

    public Object doing(Object inParam) throws BOSException, EASBizException {
        this.param = (ReqPlanWriteOffParam)inParam;
        this.writeOff(this.param);
        return this.param;
    }

    protected void writeOff(ReqPlanWriteOffParam param) throws EASBizException, BOSException {
        String tmpTable;
        String storageOrgUnitID = param.getStorageOrgUnitID();
        IRowSet reqRow = this.selectWriteOffData(storageOrgUnitID, tmpTable = param.getTempTableNameForCalc());
        if (reqRow == null || reqRow.size() <= 0) {
            return;
        }
        try {
            this.writeOffReqPlan(param, reqRow);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected abstract IRowSet selectWriteOffData(String var1, String var2) throws EASBizException, BOSException;

    protected abstract ArrayList getPlanData(String var1) throws SQLException, EASBizException, BOSException;

    protected WriteOffDetailDataVO createwriteOffDetailDataVO(WriteOffDataVO writeOffDataVO) throws SQLException {
        WriteOffDetailDataVO writeOffDetailDataVO = new WriteOffDetailDataVO();
        writeOffDetailDataVO.setId(BOSUuid.create((String)"D02F7535").toString());
        writeOffDetailDataVO.setSourceID(writeOffDataVO.getSourceBillID());
        writeOffDetailDataVO.setSourceEntryID(writeOffDataVO.getSourceEntryID());
        writeOffDetailDataVO.setBillTypeID(writeOffDataVO.getBillTypeID());
        writeOffDetailDataVO.setUnitID(writeOffDataVO.getUnitID());
        writeOffDetailDataVO.setBaseUnitID(writeOffDataVO.getBaseUnitID());
        writeOffDetailDataVO.setSourceNumber(writeOffDataVO.getSourceNumber());
        writeOffDetailDataVO.setMaterialID(writeOffDataVO.getMaterialID());
        writeOffDetailDataVO.setSrcSourceEntryID(writeOffDataVO.getSrcSourceEntryID());
        return writeOffDetailDataVO;
    }

    protected WriteOffDataVO createWriteOffDataVO(IRowSet reqRow) throws SQLException {
        WriteOffDataVO writeOffDataVO = new WriteOffDataVO();
        return writeOffDataVO;
    }

    protected void getMaterialsData(IRowSet reqRow) throws SQLException, BOSException, EASBizException {
        ArrayList detailList = new ArrayList();
        WriteOffDataVO writeOffDataVO = null;
        String materialid = null;
        while (reqRow.next()) {
            writeOffDataVO = this.createWriteOffDataVO(reqRow);
            materialid = reqRow.getString("fMaterialID");
            writeOffDataVO.setSourceBillID(reqRow.getString("fSourceBillID"));
            writeOffDataVO.setSourceEntryID(reqRow.getString("fSourceEntryID"));
            writeOffDataVO.setBillTypeID(reqRow.getString("fBillTypeID"));
            writeOffDataVO.setUnitID(reqRow.getString("fUnitID"));
            writeOffDataVO.setBaseUnitID(reqRow.getString("fBaseUnitID"));
            writeOffDataVO.setSourceNumber(reqRow.getString("fsourceBillNum"));
            writeOffDataVO.setBaseUnCntactTotalQty(reqRow.getBigDecimal("fBaseNotCntactQty"));
            writeOffDataVO.setUnCntactTotalQty(reqRow.getBigDecimal("fNotCntactQty"));
            writeOffDataVO.setRequireDate(reqRow.getDate("fRequireDate"));
            writeOffDataVO.setId(reqRow.getString("fid"));
            writeOffDataVO.setbackwardDaysOffset(reqRow.getInt("fBackwardDaysOffset"));
            writeOffDataVO.setforwardDaysOffset(reqRow.getInt("fForwardDaysOffset"));
            writeOffDataVO.setMaterialID(materialid);
            writeOffDataVO.setTrackNumberID(reqRow.getString("FTrackNumberID"));
            writeOffDataVO.setManufactureStrategy(reqRow.getString("FManufactureStrategyID"));
            writeOffDataVO.setOffSetMode(reqRow.getInt("foffSetMode"));
            writeOffDataVO.setSrcSourceEntryID(reqRow.getString("FSRCSourceEntryID"));
            if (this.detailMap.containsKey(materialid)) {
                detailList = (ArrayList)this.detailMap.get(materialid);
            } else {
                detailList = new ArrayList();
                this.detailMap.put(materialid, detailList);
            }
            detailList.add(writeOffDataVO);
        }
        String sql = this.getMaterialsDataSQL(this.param.getStorageOrgUnitID(), this.detailMap.keySet());
        IRowSet rs = this.executeQuery(sql);
        while (rs.next()) {
            this.materialMap.put(rs.getString("fmaterialID"), new Integer(rs.getInt("count")));
            this.materialList.add(rs.getString("fmaterialID"));
        }
    }

    protected abstract String getMaterialsDataSQL(String var1, Set var2) throws EASBizException, BOSException;

    protected ArrayList getReqPlanData(String materialID) throws EASBizException, BOSException, SQLException {
        ArrayList reqPlanDataListforMateial = new ArrayList();
        if (this.reaPlanDataBufferMap.get(materialID) == null) {
            StringBuffer materialsBuf = new StringBuffer();
            String tempMaterialId = null;
            String tempMaterialIds = null;
            int sumCount = 0;
            int count = 0;
            for (int i = this.lastIndex + 1; i < this.materialList.size(); ++i) {
                tempMaterialId = (String)this.materialList.get(i);
                count = (Integer)this.materialMap.get(tempMaterialId);
                materialsBuf.append("'").append(tempMaterialId).append("',");
                if ((sumCount += count) < 500) continue;
                this.lastIndex = i;
                break;
            }
            if (materialsBuf.length() > 0) {
                tempMaterialIds = materialsBuf.substring(0, materialsBuf.length() - 1);
                this.getPlanData(tempMaterialIds);
            }
        }
        reqPlanDataListforMateial = (ArrayList)this.reaPlanDataBufferMap.get(materialID);
        this.reaPlanDataBufferMap.remove(materialID);
        return reqPlanDataListforMateial;
    }

    protected boolean isMatchTrackNumber(WriteOffDataVO writeOffDataVO) {
        boolean isMatchTrackNumber = false;
        String manufactureStrategyID = writeOffDataVO.getManufactureStrategy();
        if (manufactureStrategyID.equals("qAYfaBzTrmLgQKjAYj0f3dg0uEU=") || manufactureStrategyID.equals("qAYbemEdG9ngQKjAYj0V1dg0uEU=")) {
            isMatchTrackNumber = true;
        }
        return isMatchTrackNumber;
    }

    protected void writeOffReqPlan(ReqPlanWriteOffParam param, IRowSet reqRow) throws EASBizException, BOSException, SQLException {
        String materialid2 = null;
        ArrayList reqPlanDataList = new ArrayList();
        ArrayList writeOffDataList = new ArrayList();
        ArrayList writeOffDetailDataList = new ArrayList();
        WriteOffDataVO writeOffDataVO = null;
        boolean isMatchTrackNumber = false;
        ArrayList reqPlanDataListforMateial = null;
        ArrayList tempDetailList = null;
        boolean iswriteOffDefaultTrackNumber = param.isWriteOffDefaultTrackNumber();
        try {
            this.getMaterialsData(reqRow);
            for (String materialid2 : this.materialMap.keySet()) {
                int i;
                reqPlanDataListforMateial = this.getReqPlanData(materialid2);
                isMatchTrackNumber = false;
                tempDetailList = (ArrayList)this.detailMap.get(materialid2);
                for (i = 0; i < tempDetailList.size(); ++i) {
                    writeOffDataVO = (WriteOffDataVO)tempDetailList.get(i);
                    isMatchTrackNumber = this.isMatchTrackNumber(writeOffDataVO);
                    int cntactPlanType = this.getCntactPlanType(writeOffDataVO);
                    switch (cntactPlanType) {
                        case 10320: {
                            this.cntactPlanBybackward(writeOffDataVO, reqPlanDataListforMateial, writeOffDetailDataList, isMatchTrackNumber, iswriteOffDefaultTrackNumber);
                            break;
                        }
                        case 10330: {
                            this.cntactPlanByforward(writeOffDataVO, reqPlanDataListforMateial, writeOffDetailDataList, isMatchTrackNumber, iswriteOffDefaultTrackNumber);
                            break;
                        }
                        case 10340: {
                            this.cntactPlanByBackForward(writeOffDataVO, reqPlanDataListforMateial, writeOffDetailDataList, isMatchTrackNumber, iswriteOffDefaultTrackNumber);
                            break;
                        }
                        case 10350: {
                            this.cntactPlanByForwardBack(writeOffDataVO, reqPlanDataListforMateial, writeOffDetailDataList, isMatchTrackNumber, iswriteOffDefaultTrackNumber);
                            break;
                        }
                        case 0: {
                            this.cntactPlanByDate(writeOffDataVO, reqPlanDataListforMateial, writeOffDetailDataList, isMatchTrackNumber, iswriteOffDefaultTrackNumber);
                            break;
                        }
                        case 2: {
                            this.cntactPlanByMonth(writeOffDataVO, reqPlanDataListforMateial, writeOffDetailDataList, isMatchTrackNumber, iswriteOffDefaultTrackNumber);
                            break;
                        }
                    }
                    this.addListData(writeOffDataList, writeOffDataVO, 100);
                }
                if (reqPlanDataListforMateial == null || reqPlanDataListforMateial.size() <= 0) continue;
                int size = reqPlanDataListforMateial.size();
                for (i = 0; i < size; ++i) {
                    ReqPlanDataVO reqPlanData = (ReqPlanDataVO)reqPlanDataListforMateial.get(i);
                    if (!reqPlanData.getIsNeedUpdateReqPlan()) continue;
                    this.addListData(reqPlanDataList, reqPlanData, 200);
                }
            }
            this.dealWithWriteOffData(writeOffDataList);
            this.dealWithReqPlanData(reqPlanDataList);
            this.dealWithWriteOffDetailData(writeOffDetailDataList);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void addListData(ArrayList dataList, Object data, int dataType) throws BOSException {
        dataList.add(data);
        if (dataList != null && dataList.size() > 200) {
            switch (dataType) {
                case 100: {
                    this.dealWithWriteOffData(dataList);
                    dataList.clear();
                    break;
                }
                case 200: {
                    this.dealWithReqPlanData(dataList);
                    dataList.clear();
                    break;
                }
                case 300: {
                    this.dealWithWriteOffDetailData(dataList);
                    dataList.clear();
                    break;
                }
            }
        }
    }

    protected void dealWithWriteOffData(ArrayList writeOffDataList) throws BOSException {
        if (writeOffDataList == null || writeOffDataList.size() == 0) {
            return;
        }
        String sql_updateSID = "update T_MM_RequirementPlan set fNotCntactQty = ?,fBaseNotCntactQty = ? where fID = ?";
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        WriteOffDataVO writeOffDataVO = null;
        int size = writeOffDataList.size();
        for (int i = 0; i < size; ++i) {
            writeOffDataVO = (WriteOffDataVO)writeOffDataList.get(i);
            if (writeOffDataVO.getId() == null || !writeOffDataVO.getIsNeedUpdateReqPlan()) continue;
            Object[] param = new Object[]{writeOffDataVO.getUnCntactTotalQty(), writeOffDataVO.getBaseUnCntactTotalQty(), writeOffDataVO.getId()};
            paramsList.add(param);
        }
        if (paramsList.size() <= 0) {
            return;
        }
        this.executeBatch(sql_updateSID, paramsList);
    }

    protected void dealWithReqPlanData(ArrayList reqPlanDataList) throws BOSException {
        if (reqPlanDataList == null || reqPlanDataList.size() == 0) {
            return;
        }
        String sql_updatePIC = "update T_MM_RequirementPlan set fCntactTotalQty= ?,fBaseCntactTotalQty=?,fStatus = ? where fID = ?";
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        ReqPlanDataVO reqPlanDataVO = null;
        int size = reqPlanDataList.size();
        for (int i = 0; i < size; ++i) {
            reqPlanDataVO = (ReqPlanDataVO)reqPlanDataList.get(i);
            if (reqPlanDataVO.getId() == null || !reqPlanDataVO.getIsNeedUpdateReqPlan()) continue;
            Object[] param = new Object[]{reqPlanDataVO.getCntactTotalQty(), reqPlanDataVO.getBaseCntactTotalQty(), new Integer(reqPlanDataVO.getStatus().getValue()), reqPlanDataVO.getId()};
            paramsList.add(param);
        }
        if (paramsList.size() <= 0) {
            return;
        }
        this.executeBatch(sql_updatePIC, paramsList);
    }

    protected void dealWithWriteOffDetailData(ArrayList writeOffDetailDataList) throws BOSException {
        if (writeOffDetailDataList == null || writeOffDetailDataList.size() == 0) {
            return;
        }
        StringBuffer sql_writeOffRelation = new StringBuffer();
        StringBuffer updateDetail = new StringBuffer();
        sql_writeOffRelation.append("insert into T_MM_ReqCounteractRelation ");
        sql_writeOffRelation.append("(FID,FSourceID,FSourceEntryID,FDestID,FBillTypeID,FQty,FBaseQty,FUnitID,FBaseUnitID,FSeq,FSourceNumber,fmaterialId,FSRCSourceEntryID)");
        sql_writeOffRelation.append(" values(?,?,?,?,?,?,?,?,?,?,?,?,?)");
        updateDetail.append(" update T_MM_ReqCounteractRelation set FQty =FQty+?, FBaseQty = FBaseQty+?");
        updateDetail.append(" where FDestID = ? and FSourceEntryID  = ? ");
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        ArrayList<Object[]> updateparamsList = new ArrayList<Object[]>();
        WriteOffDetailDataVO writeOffDetailDataVO = null;
        int size = writeOffDetailDataList.size();
        for (int i = 0; i < size; ++i) {
            writeOffDetailDataVO = (WriteOffDetailDataVO)writeOffDetailDataList.get(i);
            boolean isexsit = this.checkDetail(writeOffDetailDataVO.getDestID(), writeOffDetailDataVO.getSourceEntryID());
            if (isexsit) {
                Object[] updateparam = new Object[]{writeOffDetailDataVO.getQty(), writeOffDetailDataVO.getBaseQty(), writeOffDetailDataVO.getDestID(), writeOffDetailDataVO.getSourceEntryID()};
                updateparamsList.add(updateparam);
            } else {
                Object[] param = new Object[]{writeOffDetailDataVO.getId(), writeOffDetailDataVO.getSourceID(), writeOffDetailDataVO.getSourceEntryID(), writeOffDetailDataVO.getDestID(), writeOffDetailDataVO.getBillTypeID(), writeOffDetailDataVO.getQty(), writeOffDetailDataVO.getBaseQty(), writeOffDetailDataVO.getUnitID(), writeOffDetailDataVO.getBaseUnitID(), new Integer(writeOffDetailDataVO.getSeq()), writeOffDetailDataVO.getSourceNumber(), writeOffDetailDataVO.getMaterialID(), writeOffDetailDataVO.getSrcSourceEntryID()};
                paramsList.add(param);
            }
            if (paramsList.size() > 500) {
                this.executeBatch(sql_writeOffRelation.toString(), paramsList);
                paramsList.clear();
            }
            if (updateparamsList.size() <= 500) continue;
            this.executeBatch(updateDetail.toString(), updateparamsList);
            updateparamsList.clear();
        }
        if (paramsList.size() > 0) {
            this.executeBatch(sql_writeOffRelation.toString(), paramsList);
        }
        if (updateparamsList.size() > 0) {
            this.executeBatch(updateDetail.toString(), updateparamsList);
        }
    }

    private boolean checkDetail(String destID, String sourceEntryID) throws BOSException {
        boolean isexsit = false;
        StringBuffer checkDetail = new StringBuffer();
        checkDetail.append("select top 1 fid from T_MM_ReqCounteractRelation where FDestID = ? and FSourceEntryID = ? ");
        IRowSet rs = this.executeQuery(checkDetail.toString(), new String[]{destID, sourceEntryID});
        try {
            if (rs.next()) {
                isexsit = true;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return isexsit;
    }

    protected int getCntactPlanType(WriteOffDataVO writeOffDataVO) throws SQLException {
        int cntactPlanType = -1;
        cntactPlanType = writeOffDataVO.getOffSetMode();
        return cntactPlanType;
    }

    protected BigDecimal cntact(int i, WriteOffDataVO writeOffDataVO, ArrayList writeOffDetailDataList, WriteOffDetailDataVO writeOffDetailDataVO, ReqPlanDataVO reqPlanDataVO) throws SQLException, BOSException {
        BigDecimal unCntactTotalQty = writeOffDataVO.getUnCntactTotalQty();
        BigDecimal baseunCntactTotalQty = writeOffDataVO.getBaseUnCntactTotalQty();
        String reqPlanID = reqPlanDataVO.getId();
        BigDecimal qty = reqPlanDataVO.getQty();
        BigDecimal baseQty = reqPlanDataVO.getBaseQty();
        BigDecimal cntactQty = reqPlanDataVO.getCntactTotalQty();
        BigDecimal baseCntactQty = reqPlanDataVO.getBaseCntactTotalQty();
        if (ReqPlanStatusEnum.ACTIVE.equals((Object)reqPlanDataVO.getStatus())) {
            if (unCntactTotalQty.compareTo(qty.subtract(cntactQty)) >= 0) {
                reqPlanDataVO.setStatus(ReqPlanStatusEnum.CLOSED);
                reqPlanDataVO.setBaseCntactTotalQty(baseQty);
                reqPlanDataVO.setCntactTotalQty(qty);
                reqPlanDataVO.setIsNeedUpdateReqPland(true);
                writeOffDetailDataVO.setDestID(reqPlanID);
                writeOffDetailDataVO.setQty(qty.subtract(cntactQty));
                writeOffDetailDataVO.setBaseQty(baseQty.subtract(baseCntactQty));
                writeOffDetailDataVO.setSeq(i);
                this.addListData(writeOffDetailDataList, writeOffDetailDataVO, 300);
                unCntactTotalQty = unCntactTotalQty.subtract(qty.subtract(cntactQty));
                baseunCntactTotalQty = baseunCntactTotalQty.subtract(baseQty.subtract(baseCntactQty));
                writeOffDataVO.setBaseUnCntactTotalQty(baseunCntactTotalQty);
                writeOffDataVO.setUnCntactTotalQty(unCntactTotalQty);
                writeOffDataVO.setIsNeedUpdateReqPland(true);
            } else {
                reqPlanDataVO.setBaseCntactTotalQty(baseCntactQty.add(baseunCntactTotalQty));
                reqPlanDataVO.setCntactTotalQty(cntactQty.add(unCntactTotalQty));
                reqPlanDataVO.setIsNeedUpdateReqPland(true);
                writeOffDetailDataVO.setDestID(reqPlanID);
                writeOffDetailDataVO.setBaseQty(baseunCntactTotalQty);
                writeOffDetailDataVO.setQty(unCntactTotalQty);
                writeOffDetailDataVO.setSeq(i);
                this.addListData(writeOffDetailDataList, writeOffDetailDataVO, 300);
                unCntactTotalQty = this.ZERO;
                baseunCntactTotalQty = this.ZERO;
                writeOffDataVO.setBaseUnCntactTotalQty(baseunCntactTotalQty);
                writeOffDataVO.setUnCntactTotalQty(unCntactTotalQty);
                writeOffDataVO.setIsNeedUpdateReqPland(true);
            }
        }
        return unCntactTotalQty;
    }

    protected int getcurIndex(WriteOffDataVO writeOffDataVO, int startIndex, ArrayList reqPlanDataList, Date startData, Date endDate, boolean isforword) {
        int curIndex = -1;
        ReqPlanDataVO reqPlanDataVO = null;
        Date curDate = null;
        for (int i = startIndex; reqPlanDataList != null && i < reqPlanDataList.size(); ++i) {
            reqPlanDataVO = (ReqPlanDataVO)reqPlanDataList.get(i);
            curDate = reqPlanDataVO.getRequireDate();
            if (isforword) {
                if (curDate.before(startData)) {
                    curIndex = i + 1;
                    continue;
                }
                if (endDate.before(curDate)) break;
                curIndex = i;
                break;
            }
            if (curDate.after(startData)) break;
            curIndex = i;
        }
        return curIndex;
    }

    protected boolean iswriteOff(Date endDate, String trackNumberID, WriteOffDataVO writeOffDataVO, ReqPlanDataVO reqPlanDataVO, boolean isMatchTrackNumber, boolean isForward) {
        boolean iswriteOff = false;
        if (isForward) {
            if (!reqPlanDataVO.getRequireDate().after(endDate)) {
                iswriteOff = true;
            }
        } else if (!reqPlanDataVO.getRequireDate().before(endDate)) {
            iswriteOff = true;
        }
        if (isMatchTrackNumber && !reqPlanDataVO.getTrackNumberID().equals(trackNumberID)) {
            iswriteOff = false;
        }
        return iswriteOff;
    }

    protected void cntactPlanforward(int curIndex, WriteOffDataVO writeOffDataVO, ArrayList reqPlanDataList, ArrayList writeOffDetailDataList, boolean isMatchTrackNumber, String tracknumber, Date endDate) throws SQLException, BOSException {
        ReqPlanDataVO reqPlanDataVO = null;
        WriteOffDetailDataVO writeOffDetailDataVO = null;
        for (int i = curIndex; reqPlanDataList != null && i < reqPlanDataList.size() && writeOffDataVO.getUnCntactTotalQty().compareTo(this.ZERO) > 0; ++i) {
            writeOffDetailDataVO = this.createwriteOffDetailDataVO(writeOffDataVO);
            reqPlanDataVO = (ReqPlanDataVO)reqPlanDataList.get(i);
            boolean iswriteOff = this.iswriteOff(endDate, tracknumber, writeOffDataVO, reqPlanDataVO, isMatchTrackNumber, true);
            if (!iswriteOff) continue;
            this.cntact(i, writeOffDataVO, writeOffDetailDataList, writeOffDetailDataVO, reqPlanDataVO);
        }
    }

    protected void cntactPlanback(int curIndex, WriteOffDataVO writeOffDataVO, ArrayList reqPlanDataList, ArrayList writeOffDetailDataList, boolean isMatchTrackNumber, String tracknumber, Date endDate) throws SQLException, BOSException {
        if (reqPlanDataList == null || reqPlanDataList.size() == 0) {
            return;
        }
        ReqPlanDataVO reqPlanDataVO = null;
        WriteOffDetailDataVO writeOffDetailDataVO = null;
        for (int i = curIndex; i >= 0 && writeOffDataVO.getUnCntactTotalQty().compareTo(this.ZERO) > 0; --i) {
            writeOffDetailDataVO = this.createwriteOffDetailDataVO(writeOffDataVO);
            reqPlanDataVO = (ReqPlanDataVO)reqPlanDataList.get(i);
            boolean iswriteOff = this.iswriteOff(endDate, tracknumber, writeOffDataVO, reqPlanDataVO, isMatchTrackNumber, false);
            if (!iswriteOff) continue;
            this.cntact(i, writeOffDataVO, writeOffDetailDataList, writeOffDetailDataVO, reqPlanDataVO);
        }
    }

    protected void cntactPlanByforward(WriteOffDataVO writeOffDataVO, ArrayList reqPlanDataList, ArrayList writeOffDetailDataList, boolean isMatchTrackNumber, boolean iswriteOffDefaultTrackNumber) throws SQLException, BOSException {
        Date reqplanDate = writeOffDataVO.getRequireDate();
        int backwardDaysOffset = writeOffDataVO.getbackwardDaysOffset();
        Date endDate = this.getDate(writeOffDataVO.getRequireDate(), backwardDaysOffset, true);
        String trackNumberID = writeOffDataVO.getTrackNumberID();
        String defaulttrackNumberID = this.param.getDefaultTrackNumber();
        int curIndex = this.getcurIndex(writeOffDataVO, 0, reqPlanDataList, reqplanDate, endDate, true);
        if (curIndex >= 0) {
            this.cntactPlanforward(curIndex, writeOffDataVO, reqPlanDataList, writeOffDetailDataList, isMatchTrackNumber, trackNumberID, endDate);
            if (isMatchTrackNumber && iswriteOffDefaultTrackNumber && writeOffDataVO.getUnCntactTotalQty().compareTo(this.ZERO) > 0 && !trackNumberID.equals(defaulttrackNumberID)) {
                this.cntactPlanforward(curIndex, writeOffDataVO, reqPlanDataList, writeOffDetailDataList, isMatchTrackNumber, defaulttrackNumberID, endDate);
            }
        }
    }

    protected void cntactPlanBybackward(WriteOffDataVO writeOffDataVO, ArrayList reqPlanDataList, ArrayList writeOffDetailDataList, boolean isMatchTrackNumber, boolean iswriteOffDefaultTrackNumber) throws SQLException, BOSException {
        Date reqplanDate = writeOffDataVO.getRequireDate();
        int backwardDaysOffset = writeOffDataVO.getforwardDaysOffset();
        String trackNumberID = writeOffDataVO.getTrackNumberID();
        String defaulttrackNumberID = this.param.getDefaultTrackNumber();
        Date endDate = this.getDate(writeOffDataVO.getRequireDate(), backwardDaysOffset, false);
        int curIndex = this.getcurIndex(writeOffDataVO, 0, reqPlanDataList, reqplanDate, endDate, false);
        if (curIndex >= 0) {
            this.cntactPlanback(curIndex, writeOffDataVO, reqPlanDataList, writeOffDetailDataList, isMatchTrackNumber, trackNumberID, endDate);
            if (isMatchTrackNumber && iswriteOffDefaultTrackNumber && writeOffDataVO.getUnCntactTotalQty().compareTo(this.ZERO) > 0 && !trackNumberID.equals(defaulttrackNumberID)) {
                this.cntactPlanback(curIndex, writeOffDataVO, reqPlanDataList, writeOffDetailDataList, true, defaulttrackNumberID, endDate);
            }
        }
    }

    protected void cntactPlanByBackForward(WriteOffDataVO writeOffDataVO, ArrayList reqPlanDataList, ArrayList writeOffDetailDataList, boolean isMatchTrackNumber, boolean iswriteOffDefaultTrackNumber) throws SQLException, BOSException {
        this.cntactPlanBybackward(writeOffDataVO, reqPlanDataList, writeOffDetailDataList, isMatchTrackNumber, false);
        this.cntactPlanByforward(writeOffDataVO, reqPlanDataList, writeOffDetailDataList, isMatchTrackNumber, false);
        if (isMatchTrackNumber && iswriteOffDefaultTrackNumber) {
            this.cntactPlanBybackward(writeOffDataVO, reqPlanDataList, writeOffDetailDataList, isMatchTrackNumber, true);
            this.cntactPlanByforward(writeOffDataVO, reqPlanDataList, writeOffDetailDataList, isMatchTrackNumber, true);
        }
    }

    protected void cntactPlanByForwardBack(WriteOffDataVO writeOffDataVO, ArrayList reqPlanDataList, ArrayList writeOffDetailDataList, boolean isMatchTrackNumber, boolean iswriteOffDefaultTrackNumber) throws SQLException, BOSException {
        this.cntactPlanByforward(writeOffDataVO, reqPlanDataList, writeOffDetailDataList, isMatchTrackNumber, false);
        this.cntactPlanBybackward(writeOffDataVO, reqPlanDataList, writeOffDetailDataList, isMatchTrackNumber, false);
        if (isMatchTrackNumber && iswriteOffDefaultTrackNumber) {
            this.cntactPlanByforward(writeOffDataVO, reqPlanDataList, writeOffDetailDataList, isMatchTrackNumber, true);
            this.cntactPlanBybackward(writeOffDataVO, reqPlanDataList, writeOffDetailDataList, isMatchTrackNumber, true);
        }
    }

    protected void cntactPlanByDate(WriteOffDataVO writeOffDataVO, ArrayList reqPlanDataList, ArrayList writeOffDetailDataList, boolean isMatchTrackNumber, boolean iswriteOffDefaultTrackNumber) throws SQLException, BOSException {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, 3099);
        Date endDate = calendar.getTime();
        String trackNumberID = writeOffDataVO.getTrackNumberID();
        String defaulttrackNumberID = this.param.getDefaultTrackNumber();
        this.cntactPlanforward(0, writeOffDataVO, reqPlanDataList, writeOffDetailDataList, isMatchTrackNumber, trackNumberID, endDate);
        if (isMatchTrackNumber && iswriteOffDefaultTrackNumber && writeOffDataVO.getUnCntactTotalQty().compareTo(this.ZERO) > 0 && !trackNumberID.equals(defaulttrackNumberID)) {
            this.cntactPlanforward(0, writeOffDataVO, reqPlanDataList, writeOffDetailDataList, isMatchTrackNumber, defaulttrackNumberID, endDate);
        }
    }

    protected void cntactPlanByMonth(WriteOffDataVO writeOffDataVO, ArrayList reqPlanDataList, ArrayList writeOffDetailDataList, boolean isMatchTrackNumber, boolean iswriteOffDefaultTrackNumber) throws SQLException, BOSException {
        Date reqplanDate = writeOffDataVO.getRequireDate();
        Date startDate = this.getDate(reqplanDate, true);
        Date endDate = this.getDate(reqplanDate, false);
        int curIndex = this.getcurIndex(writeOffDataVO, 0, reqPlanDataList, startDate, endDate, true);
        String trackNumberID = writeOffDataVO.getTrackNumberID();
        String defaulttrackNumberID = this.param.getDefaultTrackNumber();
        if (curIndex >= 0) {
            this.cntactPlanforward(curIndex, writeOffDataVO, reqPlanDataList, writeOffDetailDataList, isMatchTrackNumber, trackNumberID, endDate);
            if (isMatchTrackNumber && iswriteOffDefaultTrackNumber && writeOffDataVO.getUnCntactTotalQty().compareTo(this.ZERO) > 0 && !trackNumberID.equals(defaulttrackNumberID)) {
                this.cntactPlanforward(curIndex, writeOffDataVO, reqPlanDataList, writeOffDetailDataList, isMatchTrackNumber, defaulttrackNumberID, endDate);
            }
        }
    }

    protected Date getDate(Date reqDate, int days, boolean isforward) {
        Calendar theDate = Calendar.getInstance();
        theDate.setTime(reqDate);
        if (isforward) {
            theDate.add(6, days);
        } else {
            theDate.add(6, -days);
        }
        return theDate.getTime();
    }

    protected Date getDate(Date reqDate, boolean isstart) {
        Calendar theDate = Calendar.getInstance();
        theDate.setTime(reqDate);
        if (isstart) {
            theDate.set(5, 1);
        } else {
            theDate.add(2, 1);
            theDate.set(5, 1);
            theDate.add(6, -1);
        }
        return theDate.getTime();
    }
}

